/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap.impl;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.messaging.saaj.soap.impl.DetailImpl;
import com.sun.xml.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.messaging.saaj.soap.name.NameImpl;
import java.util.Locale;
import java.util.Map;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.w3c.dom.Element;

public abstract class FaultImpl
extends ElementImpl
implements SOAPFault {
    private static final String FAULT_CODE_ELEMENT_ERR = "Fault/Code not supported by this SOAP version, try SOAP 1.2 or later";
    private static final String FAULT_REASON_TEXT_ERR = "Fault/Reason/Text not supported by this SOAP version, try SOAP 1.2 or later";
    private static final String FAULT_NODE_ERR = "Fault/Node not supported by this SOAP version, try SOAP 1.2 or later";
    private static final String FAULT_ROLE_ERR = "Fault/Role not supported by this SOAP version, try SOAP 1.2 or later";
    private Locale faultStringLocale;
    ElementImpl faultActorElement;
    String faultCodeUri;
    String faultCodePrefix;
    ElementImpl faultStringElement;
    Detail detail;

    void initializeDetail() {
        NameImpl detailName = this.getDetailName();
        this.detail = (Detail)this.findChild(detailName);
    }

    void initializeFaultActor() {
        NameImpl faultActorName = NameImpl.createFromUnqualifiedName("faultactor");
        this.faultActorElement = (ElementImpl)this.findChild(faultActorName);
    }

    void initializeFaultString() {
        NameImpl faultStringName = this.getFaultstringName();
        this.faultStringElement = (ElementImpl)this.findChild(faultStringName);
    }

    protected abstract DetailImpl createDetail();

    ElementImpl findFaultCodeElement() {
        NameImpl faultCodeName = NameImpl.createFromUnqualifiedName("faultcode");
        return (ElementImpl)this.findChild(faultCodeName);
    }

    protected abstract NameImpl getDetailName();

    protected NameImpl getFaultstringName() {
        return NameImpl.createFromUnqualifiedName("faultstring");
    }

    public String getFaultActor() {
        this.initializeFaultActor();
        if (this.faultActorElement != null) {
            return this.faultActorElement.getValue();
        }
        return null;
    }

    public String getFaultCode() {
        this.findFaultCodeElement();
        return this.findFaultCodeElement().getValue();
    }

    public String getFaultNode() {
        ElementImpl.log.severe("SAAJ0143.impl.node.not.supported");
        throw new UnsupportedOperationException(FAULT_NODE_ERR);
    }

    public String getFaultRole() {
        ElementImpl.log.severe("SAAJ0144.impl.role.not.supported");
        throw new UnsupportedOperationException(FAULT_ROLE_ERR);
    }

    public String getFaultString() {
        this.initializeFaultString();
        if (this.faultStringElement != null) {
            return this.faultStringElement.getValue();
        }
        return null;
    }

    public String getFirstFaultReasonText() {
        ElementImpl.log.severe("SAAJ0142.impl.reason.or.text.not.supported");
        throw new UnsupportedOperationException(FAULT_REASON_TEXT_ERR);
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if (this.faultActorElement == null) {
            this.initializeFaultActor();
        }
        if (this.faultActorElement != null) {
            this.faultActorElement.detachNode();
        }
        this.faultActorElement = (ElementImpl)this.addChildElement(NameImpl.createFromUnqualifiedName("faultactor")).addTextNode(faultActor);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        this.setFaultCode(NameImpl.getLocalNameFromTagName(faultCode), NameImpl.getPrefixFromTagName(faultCode), null);
    }

    public void setFaultNode(String uri) throws SOAPException {
        ElementImpl.log.severe("SAAJ0143.impl.node.not.supported");
        throw new UnsupportedOperationException(FAULT_NODE_ERR);
    }

    public void setFaultRole(String uri) throws SOAPException {
        ElementImpl.log.severe("SAAJ0144.impl.role.not.supported");
        throw new UnsupportedOperationException(FAULT_ROLE_ERR);
    }

    public void setFaultString(String faultString) throws SOAPException {
        if (this.faultStringElement == null) {
            this.initializeFaultString();
        }
        if (this.faultStringElement != null) {
            this.faultStringElement.detachNode();
        }
        this.faultStringElement = (ElementImpl)this.addChildElement(this.getFaultstringName()).addTextNode(faultString);
    }

    public Locale getFaultStringLocale() {
        String xmlLangAttr;
        this.initializeFaultString();
        if (this.faultStringElement != null && (xmlLangAttr = this.faultStringElement.getAttributeValue(NameImpl.createFromUnqualifiedName("xml:lang"))) != null) {
            return FaultImpl.xmlLangToLocale(xmlLangAttr);
        }
        return null;
    }

    public Locale getFirstFaultReasonTextLocale() {
        ElementImpl.log.severe("SAAJ0142.impl.reason.or.text.not.supported");
        throw new UnsupportedOperationException(FAULT_REASON_TEXT_ERR);
    }

    public Map getFaultReasonTexts() {
        ElementImpl.log.severe("SAAJ0142.impl.reason.or.text.not.supported");
        throw new UnsupportedOperationException(FAULT_REASON_TEXT_ERR);
    }

    public Detail addDetail() throws SOAPException {
        if (this.detail == null) {
            this.initializeDetail();
        }
        if (this.detail == null) {
            this.detail = this.createDetail();
            this.addNode(this.detail);
            return this.circumventBug5034339(this.detail);
        }
        ElementImpl.log.severe("SAAJ0104.impl.invalid.elem.type");
        throw new SOAPExceptionImpl("Error: Detail already exists");
    }

    public Detail getDetail() {
        this.initializeDetail();
        return this.detail;
    }

    public Name getFaultCodeAsName() {
        String faultcodeString = this.getFaultCode();
        if (faultcodeString == null) {
            return null;
        }
        int prefixIndex = faultcodeString.indexOf(58);
        if (prefixIndex == -1) {
            return NameImpl.createFromUnqualifiedName(faultcodeString);
        }
        String prefix = faultcodeString.substring(0, prefixIndex);
        String nsName = this.findFaultCodeElement().getNamespaceURI(prefix);
        return NameImpl.createFromQualifiedName(faultcodeString, nsName);
    }

    public void ensureNamespaceIsDeclared(Name name) throws SOAPException {
        super.ensureNamespaceIsDeclared(name);
        if (!name.equals(this.getElementName())) {
            return;
        }
        ElementImpl faultCodeElement = this.findFaultCodeElement();
        if (faultCodeElement != null) {
            faultCodeElement.ensureNamespaceIsDeclared(this.faultCodePrefix, this.faultCodeUri);
        }
    }

    public void setFaultCode(Name faultCodeQName) throws SOAPException {
        this.setFaultCode(faultCodeQName.getLocalName(), faultCodeQName.getPrefix(), faultCodeQName.getURI());
    }

    protected abstract DetailImpl createDetail(Name var1);

    protected FaultImpl(SOAPDocumentImpl ownerDoc, NameImpl name) {
        super(ownerDoc, name);
    }

    protected static String localeToXmlLang(Locale locale) {
        String xmlLang = locale.getLanguage();
        String country = locale.getCountry();
        if (!"".equals(country)) {
            xmlLang = xmlLang + "-" + country;
        }
        return xmlLang;
    }

    protected static Locale xmlLangToLocale(String xmlLang) {
        if (xmlLang == null) {
            return null;
        }
        int index = xmlLang.indexOf("-");
        if (index == -1) {
            index = xmlLang.indexOf("_");
        }
        if (index == -1) {
            return new Locale(xmlLang, "");
        }
        String language = xmlLang.substring(0, index);
        String country = xmlLang.substring(index + 1);
        return new Locale(language, country);
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        ElementImpl.log.severe("SAAJ0142.impl.reason.or.text.not.supported");
        throw new UnsupportedOperationException(FAULT_REASON_TEXT_ERR);
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        this.setFaultString(faultString);
        this.faultStringElement.addAttribute(NameImpl.createFromTagName("xml:lang"), FaultImpl.localeToXmlLang(locale));
    }

    protected Detail circumventBug5034339(Detail element) {
        String prefix;
        String defaultNamespace;
        Name elementName = element.getElementName();
        if (!this.isNamespaceAware(elementName) && (defaultNamespace = element.getNamespaceURI(prefix = elementName.getPrefix())) != null) {
            NameImpl newElementName = NameImpl.create(elementName.getLocalName(), elementName.getPrefix(), defaultNamespace);
            DetailImpl newElement = this.createDetail(newElementName);
            this.replaceChild(newElement, element);
            return newElement;
        }
        return element;
    }

    protected SOAPElement addElement(Name name) throws SOAPException {
        if (this.getDetailName().equals(name)) {
            return this.addDetail();
        }
        return super.addElement(name);
    }

    protected SOAPElement convertToSoapElement(Element element) {
        if (element instanceof Detail) {
            return (SOAPElement)element;
        }
        if (element instanceof SOAPElement) {
            SOAPElement soapElement = (SOAPElement)element;
            if (this.getDetailName().equals(soapElement.getElementName())) {
                return ElementImpl.replaceElementWithSOAPElement(element, this.createDetail());
            }
            return soapElement;
        }
        Name elementName = NameImpl.copyElementName(element);
        ElementImpl newElement = this.getDetailName().equals(elementName) ? this.createDetail() : (ElementImpl)this.createElement(elementName);
        return ElementImpl.replaceElementWithSOAPElement(element, newElement);
    }

    public void setFaultCode(String faultCode, String prefix, String uri) throws SOAPException {
        ElementImpl faultCodeElement;
        if (prefix == null || prefix.equals("")) {
            if (uri == null || uri.equals("")) {
                ElementImpl.log.severe("SAAJ0140.impl.no.ns.URI");
                throw new SOAPExceptionImpl("No NamespaceURI, SOAP requires faultcode content to be a QName");
            }
            prefix = this.getNamespacePrefix(uri);
            if (prefix == null || prefix.equals("")) {
                ElementImpl.log.severe("SAAJ0125.impl.URI.cannot.be.null");
                throw new SOAPExceptionImpl("SAAJ0125: Unable to locate namespace for prefix");
            }
        }
        if ((faultCodeElement = this.findFaultCodeElement()) != null) {
            faultCodeElement.detachNode();
        }
        faultCodeElement = (ElementImpl)this.addChildElement(NameImpl.createFromUnqualifiedName("faultcode")).addTextNode(prefix + ":" + faultCode);
        this.faultCodePrefix = prefix;
        this.faultCodeUri = uri;
        if (this.faultCodeUri == null) {
            this.faultCodeUri = faultCodeElement.getNamespaceURI(this.faultCodePrefix);
        }
        if (this.faultCodeUri != null) {
            faultCodeElement.ensureNamespaceIsDeclared(this.faultCodePrefix, this.faultCodeUri);
        }
    }
}

