/*
 * Decompiled with CFR 0.152.
 */
package com.ssa.taimpl.taxprovider1.vertex1;

import com.eibus.util.DoubleHolder;
import com.eibus.util.IntHolder;
import com.eibus.util.StringHolder;
import com.ssa.ta.taxprovider1.BuyerDestination;
import com.ssa.ta.taxprovider1.CustomerDestination;
import com.ssa.ta.taxprovider1.Geocode;
import com.ssa.ta.taxprovider1.GeocodeArray;
import com.ssa.ta.taxprovider1.ITaxProvider;
import com.ssa.ta.taxprovider1.Jurisdiction;
import com.ssa.ta.taxprovider1.Location;
import com.ssa.ta.taxprovider1.QuotationSaleCustomerDestination;
import com.ssa.ta.taxprovider1.QuotationSaleSellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.QuotationSaleSellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.SellerAdministrativeOrigin;
import com.ssa.ta.taxprovider1.SellerDestination;
import com.ssa.ta.taxprovider1.SellerPhysicalOrigin;
import com.ssa.ta.taxprovider1.Tax;
import com.ssa.ta.taxprovider1.TaxArray;
import com.ssa.ta.taxprovider1.TaxProviderException;
import com.ssa.ta.taxprovider1.VendorAdministrativeOrigin;
import com.ssa.ta.taxprovider1.VendorPhysicalOrigin;
import com.ssa.ta.vertex1.ws.bindings.AmountType;
import com.ssa.ta.vertex1.ws.bindings.Company;
import com.ssa.ta.vertex1.ws.bindings.ExemptionCertificateType;
import com.ssa.ta.vertex1.ws.bindings.InvoiceSaleRequest;
import com.ssa.ta.vertex1.ws.bindings.InvoiceSaleRequestType;
import com.ssa.ta.vertex1.ws.bindings.InvoiceSaleResponse;
import com.ssa.ta.vertex1.ws.bindings.InvoiceSaleResponseType;
import com.ssa.ta.vertex1.ws.bindings.JurisdictionType;
import com.ssa.ta.vertex1.ws.bindings.LineItemISIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemISOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemPOTIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemPOTOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemQSIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemQSOType;
import com.ssa.ta.vertex1.ws.bindings.LineItemTOASIType;
import com.ssa.ta.vertex1.ws.bindings.LineItemTOASOType;
import com.ssa.ta.vertex1.ws.bindings.LocationType;
import com.ssa.ta.vertex1.ws.bindings.ObjectFactory;
import com.ssa.ta.vertex1.ws.bindings.Product;
import com.ssa.ta.vertex1.ws.bindings.ProductType;
import com.ssa.ta.vertex1.ws.bindings.Purchase;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderTPPRequest;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderTPPRequestType;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderTPPResponse;
import com.ssa.ta.vertex1.ws.bindings.PurchaseOrderTPPResponseType;
import com.ssa.ta.vertex1.ws.bindings.PurchaseType;
import com.ssa.ta.vertex1.ws.bindings.Quantity;
import com.ssa.ta.vertex1.ws.bindings.QuantityType;
import com.ssa.ta.vertex1.ws.bindings.QuotationSaleRequest;
import com.ssa.ta.vertex1.ws.bindings.QuotationSaleRequestType;
import com.ssa.ta.vertex1.ws.bindings.QuotationSaleResponse;
import com.ssa.ta.vertex1.ws.bindings.QuotationSaleResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaRequest;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaResponse;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxAreaType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSaleRequest;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSaleRequestType;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSaleResponse;
import com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSaleResponseType;
import com.ssa.ta.vertex1.ws.bindings.TaxesType;
import com.ssa.taimpl.taxprovider1.vertex1.Util;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public final class TaxProvider
implements ITaxProvider {
    private static final Util UTIL = Util.getInstance();
    private static final Logger s_logger = UTIL.getLogger();
    private static final String C_NAME = (class$com$ssa$taimpl$taxprovider1$vertex1$TaxProvider == null ? (class$com$ssa$taimpl$taxprovider1$vertex1$TaxProvider = TaxProvider.class$("com.ssa.taimpl.taxprovider1.vertex1.TaxProvider")) : class$com$ssa$taimpl$taxprovider1$vertex1$TaxProvider).getName();
    private static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final String EMPTY_STRING = new String().intern();
    private static final SimpleTimeZone TIMEZONE_UTC = new SimpleTimeZone(0, "UTC");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    static /* synthetic */ Class class$com$ssa$taimpl$taxprovider1$vertex1$TaxProvider;
    static /* synthetic */ Class class$com$ssa$ta$vertex1$ws$bindings$TaxAreaResponse;
    static /* synthetic */ Class class$com$ssa$ta$vertex1$ws$bindings$InvoiceSaleResponse;
    static /* synthetic */ Class class$com$ssa$ta$vertex1$ws$bindings$QuotationSaleResponse;
    static /* synthetic */ Class class$com$ssa$ta$vertex1$ws$bindings$PurchaseOrderTPPResponse;
    static /* synthetic */ Class class$com$ssa$ta$vertex1$ws$bindings$TaxOnlyAdjustmentSaleResponse;

    public void getGeocode(GeocodeArray p_geocodes, String p_city, String p_state, String p_zipCode, String p_country) {
        String M_NAME = "getGeocode";
        s_logger.entering(C_NAME, "getGeocode");
        TaxAreaRequest request = null;
        try {
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createTaxAreaRequest();
            TaxAreaType taxArea = objectFactory.createTaxAreaType();
            taxArea.setCity(p_city);
            taxArea.setMainDivision(p_state);
            taxArea.setPostalCode(p_zipCode);
            taxArea.setCountry(p_country);
            request.setTaxArea(taxArea);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        TaxAreaResponse response = (TaxAreaResponse)UTIL.doLookupTaxAreasRequest(request, class$com$ssa$ta$vertex1$ws$bindings$TaxAreaResponse == null ? (class$com$ssa$ta$vertex1$ws$bindings$TaxAreaResponse = TaxProvider.class$("com.ssa.ta.vertex1.ws.bindings.TaxAreaResponse")) : class$com$ssa$ta$vertex1$ws$bindings$TaxAreaResponse);
        List taxAreas = response.getTaxArea();
        int nrTaxAreas = taxAreas.size();
        if (nrTaxAreas == 0) {
            throw UTIL.newSevereRuntimeException("No tax areas received from Vertex");
        }
        for (int i = 0; i < nrTaxAreas; ++i) {
            String country;
            String state;
            String county;
            String city;
            String zipCode;
            Geocode geocodeStruct = new Geocode();
            Location location = new Location();
            TaxAreaResponseType.TaxAreaType responseTaxArea = (TaxAreaResponseType.TaxAreaType)taxAreas.get(i);
            BigInteger bigInt = responseTaxArea.getTaxAreaId();
            if (bigInt.compareTo(INTEGER_MIN_VALUE) < 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too low. Cannot fit in a Java int");
            }
            if (bigInt.compareTo(INTEGER_MAX_VALUE) > 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too big. Cannot fit in a Java int");
            }
            int geocode = bigInt.intValue();
            location.setGeocode(geocode);
            String street = responseTaxArea.getStreetAddress();
            if (street != null) {
                location.setStreet(street);
            }
            if ((zipCode = responseTaxArea.getPostalCode()) != null) {
                location.setZipCode(zipCode);
            }
            if ((city = responseTaxArea.getCity()) != null) {
                location.setCity(city);
            }
            if ((county = responseTaxArea.getSubDivision()) != null) {
                location.setCounty(county);
            }
            if ((state = responseTaxArea.getMainDivision()) != null) {
                location.setState(state);
            }
            if ((country = responseTaxArea.getCountry()) != null) {
                location.setCountry(country);
            }
            geocodeStruct.setLocation(location);
            Iterator jurisdictions = responseTaxArea.getJurisdiction().iterator();
            while (jurisdictions.hasNext()) {
                JurisdictionType jurisdiction = (JurisdictionType)jurisdictions.next();
                Jurisdiction jurisdictionObject = new Jurisdiction();
                String jurisdictionName = jurisdiction.getValue();
                jurisdictionObject.setJurisdictionName(jurisdictionName);
                String jurisdictionLevel = jurisdiction.getJurisdictionLevel();
                jurisdictionObject.setJurisdictionLevel(jurisdictionLevel);
                geocodeStruct.addJurisdiction(jurisdictionObject);
            }
            p_geocodes.addGeocode(geocodeStruct);
            Iterator statusItems = responseTaxArea.getStatus().iterator();
            while (statusItems.hasNext()) {
                TaxAreaResponseType.TaxAreaType.StatusType status = (TaxAreaResponseType.TaxAreaType.StatusType)statusItems.next();
                String lookupResult = status.getLookupResult();
                if ("BAD_REGION_FIELDS".equals(lookupResult)) {
                    throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'BAD_REGION_FIELDS' (" + lookupResult + ')');
                }
                if ("BAD_STREET_INFORMATION".equals(lookupResult)) {
                    throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'BAD_STREET_INFORMATION' (" + lookupResult + ')');
                }
                if (!"IGNORED_REGION_FIELDS".equals(lookupResult)) continue;
                throw UTIL.newSevereRuntimeException("For tax area with ID the status result " + bigInt + " was 'IGNORED_REGION_FIELDS' (" + lookupResult + ')');
            }
        }
        s_logger.exiting(C_NAME, "getGeocode");
    }

    public void calculateTaxForInvoicing(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, StringHolder p_customerExemptCertNr, String p_customerCompany, CustomerDestination p_customerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List rLineItems;
        int nrLineItems;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "calculateTaxForInvoicing";
        s_logger.entering(C_NAME, "calculateTaxForInvoicing");
        InvoiceSaleRequest request = null;
        try {
            String productClass;
            Location customerDestinationLocation;
            Company customerCompany;
            Location sellerAdministrativeOriginLocation;
            Location sellerPhysicalOriginLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createInvoiceSaleRequest();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            request.setDocumentDate(documentDate);
            InvoiceSaleRequestType.SellerType seller = objectFactory.createInvoiceSaleRequestTypeSellerType();
            Company sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((sellerPhysicalOriginLocation2 = p_sellerPhysicalOrigin.getLocation()) != null) {
                InvoiceSaleRequestType.SellerType.PhysicalOriginType physicalOrigin = objectFactory.createInvoiceSaleRequestTypeSellerTypePhysicalOriginType();
                if (this.locationToLocationType(sellerPhysicalOriginLocation2, physicalOrigin)) {
                    seller.setPhysicalOrigin(physicalOrigin);
                } else {
                    sellerPhysicalOriginLocation2 = null;
                }
            }
            if ((sellerAdministrativeOriginLocation = p_sellerAdministrativeOrigin.getLocation()) != null) {
                InvoiceSaleRequestType.SellerType.AdministrativeOriginType administrativeOrigin = objectFactory.createInvoiceSaleRequestTypeSellerTypeAdministrativeOriginType();
                if (this.locationToLocationType(sellerAdministrativeOriginLocation, administrativeOrigin)) {
                    seller.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    sellerAdministrativeOriginLocation = null;
                }
            }
            if (sellerCompany != null || sellerPhysicalOriginLocation2 != null || sellerAdministrativeOriginLocation != null) {
                request.setSeller(seller);
            }
            InvoiceSaleRequestType.CustomerType customer = objectFactory.createInvoiceSaleRequestTypeCustomerType();
            if (this.isValid(p_customerClassCode)) {
                customer.setClassCode(p_customerClassCode);
            }
            if (p_customerIsTaxExempt) {
                customer.setIsTaxExempt(p_customerIsTaxExempt);
            }
            if (this.isValid(p_customerExemptReasonCode)) {
                customer.setExemptionReasonCode(p_customerExemptReasonCode);
            }
            if ((customerCompany = this.newCompany(p_customerCompany)) != null) {
                customer.setCompany(customerCompany);
            }
            if ((customerDestinationLocation = p_customerDestination.getLocation()) != null) {
                InvoiceSaleRequestType.CustomerType.DestinationType destination = objectFactory.createInvoiceSaleRequestTypeCustomerTypeDestinationType();
                if (this.locationToLocationType(customerDestinationLocation, destination)) {
                    customer.setDestination(destination);
                } else {
                    customerDestinationLocation = null;
                }
            }
            if (this.isValid(p_customerClassCode) || p_customerIsTaxExempt || this.isValid(p_customerExemptReasonCode) || customerCompany != null || customerDestinationLocation != null) {
                request.setCustomer(customer);
            }
            List inputLineItems = request.getLineItem();
            LineItemISIType inputLineItem = objectFactory.createLineItemISIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(documentDate);
            Product product = objectFactory.createProduct();
            String productString = p_itemProduct.toString();
            if (this.isValid(productString)) {
                product.setValue(productString);
            }
            if (this.isValid(productClass = p_itemProductClass.toString())) {
                product.setProductClass(productClass);
            }
            if (this.isValid(productString) || this.isValid(productClass)) {
                inputLineItem.setProduct(product);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue > 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue > 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        InvoiceSaleResponse response = (InvoiceSaleResponse)UTIL.doCalculateTaxRequest(request, class$com$ssa$ta$vertex1$ws$bindings$InvoiceSaleResponse == null ? (class$com$ssa$ta$vertex1$ws$bindings$InvoiceSaleResponse = TaxProvider.class$("com.ssa.ta.vertex1.ws.bindings.InvoiceSaleResponse")) : class$com$ssa$ta$vertex1$ws$bindings$InvoiceSaleResponse);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        Calendar rDocumentDateObject = response.getDocumentDate();
        Date rDocumentDate = rDocumentDateObject.getTime();
        String rDocumentDateString = DATE_FORMAT.format(rDocumentDate);
        p_documentDate.setValue(rDocumentDateString);
        InvoiceSaleResponseType.SellerType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_sellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        InvoiceSaleResponseType.CustomerType rCustomer = response.getCustomer();
        String rExemptionCertificateNr = null;
        LocationType rDestinationLocation = null;
        if (rCustomer != null) {
            ExemptionCertificateType rExemptionCertificate = rCustomer.getExemptionCertificate();
            if (rExemptionCertificate != null) {
                rExemptionCertificateNr = rExemptionCertificate.getExemptionCertificateNumber();
            }
            rDestinationLocation = rCustomer.getDestination();
        }
        this.setValue(p_customerExemptCertNr, rExemptionCertificateNr);
        Location customerDestinationLocation = this.newLocation(rDestinationLocation);
        if (customerDestinationLocation != null) {
            p_customerDestination.setLocation(customerDestinationLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemISOType rLineItem = (LineItemISOType)rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        ProductType rProduct = rLineItem.getProduct();
        String rProductValue = null;
        String rProductClass = null;
        if (rProduct != null) {
            rProductValue = rProduct.getValue();
            rProductClass = rProduct.getProductClass();
        }
        this.setValue(p_itemProduct, rProductValue);
        this.setValue(p_itemProductClass, rProductClass);
        QuantityType rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = (TaxesType)rTaxes.get(i);
            Tax tax = new Tax();
            String rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult);
            TaxesType.JurisdictionType rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            String rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel);
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "calculateTaxForInvoicing");
    }

    public void quoteTaxForSale(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, QuotationSaleSellerPhysicalOrigin p_quotationSaleSellerPhysicalOrigin, QuotationSaleSellerAdministrativeOrigin p_quotationSaleSellerAdministrativeOrigin, String p_customerClassCode, boolean p_customerIsTaxExempt, String p_customerExemptReasonCode, String p_customerExemptCertNr, String p_customerCompany, QuotationSaleCustomerDestination p_quotationSaleCustomerDestination, IntHolder p_itemNumber, StringHolder p_itemProduct, StringHolder p_itemProductClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List rLineItems;
        int nrLineItems;
        Location quotationSaleCustomerDestinationLocation;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "quoteTaxForSale";
        s_logger.entering(C_NAME, "quoteTaxForSale");
        QuotationSaleRequest request = null;
        try {
            String productClass;
            Location quotationSaleCustomerDestinationLocation2;
            Company customerCompany;
            Location quotationSaleSellerAdministrativeOriginLocation;
            Location quotationSaleSellerPhysicalOriginLocation;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createQuotationSaleRequest();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            request.setDocumentDate(documentDate);
            QuotationSaleRequestType.SellerType seller = objectFactory.createQuotationSaleRequestTypeSellerType();
            Company sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((quotationSaleSellerPhysicalOriginLocation = p_quotationSaleSellerPhysicalOrigin.getLocation()) != null) {
                QuotationSaleRequestType.SellerType.PhysicalOriginType physicalOrigin = objectFactory.createQuotationSaleRequestTypeSellerTypePhysicalOriginType();
                if (this.locationToLocationType(quotationSaleSellerPhysicalOriginLocation, physicalOrigin)) {
                    seller.setPhysicalOrigin(physicalOrigin);
                } else {
                    quotationSaleSellerPhysicalOriginLocation = null;
                }
            }
            if ((quotationSaleSellerAdministrativeOriginLocation = p_quotationSaleSellerAdministrativeOrigin.getLocation()) != null) {
                QuotationSaleRequestType.SellerType.AdministrativeOriginType administrativeOrigin = objectFactory.createQuotationSaleRequestTypeSellerTypeAdministrativeOriginType();
                if (this.locationToLocationType(quotationSaleSellerAdministrativeOriginLocation, administrativeOrigin)) {
                    seller.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    quotationSaleSellerAdministrativeOriginLocation = null;
                }
            }
            if (sellerCompany != null || quotationSaleSellerPhysicalOriginLocation != null || quotationSaleSellerAdministrativeOriginLocation != null) {
                request.setSeller(seller);
            }
            QuotationSaleRequestType.CustomerType customer = objectFactory.createQuotationSaleRequestTypeCustomerType();
            if (this.isValid(p_customerClassCode)) {
                customer.setClassCode(p_customerClassCode);
            }
            if (p_customerIsTaxExempt) {
                customer.setIsTaxExempt(p_customerIsTaxExempt);
            }
            if (this.isValid(p_customerExemptReasonCode)) {
                customer.setExemptionReasonCode(p_customerExemptReasonCode);
            }
            if ((customerCompany = this.newCompany(p_customerCompany)) != null) {
                customer.setCompany(customerCompany);
            }
            if ((quotationSaleCustomerDestinationLocation2 = p_quotationSaleCustomerDestination.getLocation()) != null) {
                QuotationSaleRequestType.CustomerType.DestinationType destination = objectFactory.createQuotationSaleRequestTypeCustomerTypeDestinationType();
                if (this.locationToLocationType(quotationSaleCustomerDestinationLocation2, destination)) {
                    customer.setDestination(destination);
                } else {
                    quotationSaleCustomerDestinationLocation2 = null;
                }
            }
            if (this.isValid(p_customerClassCode) || p_customerIsTaxExempt || this.isValid(p_customerExemptReasonCode) || customerCompany != null || quotationSaleCustomerDestinationLocation2 != null) {
                request.setCustomer(customer);
            }
            List inputLineItems = request.getLineItem();
            LineItemQSIType inputLineItem = objectFactory.createLineItemQSIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(documentDate);
            Product product = objectFactory.createProduct();
            String productString = p_itemProduct.toString();
            if (this.isValid(productString)) {
                product.setValue(productString);
            }
            if (this.isValid(productClass = p_itemProductClass.toString())) {
                product.setProductClass(productClass);
            }
            if (this.isValid(productString) || this.isValid(productClass)) {
                inputLineItem.setProduct(product);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue > 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue > 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        QuotationSaleResponse response = (QuotationSaleResponse)UTIL.doQuoteForSaleRequest(request, class$com$ssa$ta$vertex1$ws$bindings$QuotationSaleResponse == null ? (class$com$ssa$ta$vertex1$ws$bindings$QuotationSaleResponse = TaxProvider.class$("com.ssa.ta.vertex1.ws.bindings.QuotationSaleResponse")) : class$com$ssa$ta$vertex1$ws$bindings$QuotationSaleResponse);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        Calendar rDocumentDateObject = response.getDocumentDate();
        Date rDocumentDate = rDocumentDateObject.getTime();
        String rDocumentDateString = DATE_FORMAT.format(rDocumentDate);
        p_documentDate.setValue(rDocumentDateString);
        QuotationSaleResponseType.SellerType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_quotationSaleSellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_quotationSaleSellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        QuotationSaleResponseType.CustomerType rCustomer = response.getCustomer();
        Object rExemptionCertificateNr = null;
        LocationType rDestinationLocation = null;
        if (rCustomer != null) {
            rDestinationLocation = rCustomer.getDestination();
        }
        if ((quotationSaleCustomerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_quotationSaleCustomerDestination.setLocation(quotationSaleCustomerDestinationLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemQSOType rLineItem = (LineItemQSOType)rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        ProductType rProduct = rLineItem.getProduct();
        String rProductValue = null;
        String rProductClass = null;
        if (rProduct != null) {
            rProductValue = rProduct.getValue();
            rProductClass = rProduct.getProductClass();
        }
        this.setValue(p_itemProduct, rProductValue);
        this.setValue(p_itemProductClass, rProductClass);
        QuantityType rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = (TaxesType)rTaxes.get(i);
            Tax tax = new Tax();
            String rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult);
            TaxesType.JurisdictionType rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            String rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel);
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "quoteTaxForSale");
    }

    public void purchaseOrderTPP(StringHolder p_documentNr, StringHolder p_documentDate, String p_buyerCompany, BuyerDestination p_buyerDestination, boolean p_buyerIsTaxExempt, String p_buyerExemptReasonCode, String p_buyerExemptCertNr, String p_vendorCompany, VendorAdministrativeOrigin p_vendorAdministrativeOrigin, VendorPhysicalOrigin p_vendorPhysicalOrigin, IntHolder p_itemNumber, StringHolder p_itemPurchase, StringHolder p_itemPurchaseClass, DoubleHolder p_itemQuantity, DoubleHolder p_itemExtendedPrice, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List rLineItems;
        int nrLineItems;
        Location vendorAdministrativeLocation;
        Location vendorPhysicalOriginLocation;
        Location buyerDestinationLocation;
        String M_NAME = "purchaseOrderTPP";
        s_logger.entering(C_NAME, "purchaseOrderTPP");
        PurchaseOrderTPPRequest request = null;
        try {
            String purchaseClass;
            Location vendorPhysicalOriginLocation2;
            Location vendorAdministrativeOriginLocation;
            ExemptionCertificateType exemptCertNr;
            Location buyerDestinationLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createPurchaseOrderTPPRequest();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            request.setDocumentDate(documentDate);
            PurchaseOrderTPPRequestType.BuyerType buyer = objectFactory.createPurchaseOrderTPPRequestTypeBuyerType();
            Company buyerCompany = this.newCompany(p_buyerCompany);
            if (buyerCompany != null) {
                buyer.setCompany(buyerCompany);
            }
            if ((buyerDestinationLocation2 = p_buyerDestination.getLocation()) != null) {
                PurchaseOrderTPPRequestType.BuyerType.DestinationType destination = objectFactory.createPurchaseOrderTPPRequestTypeBuyerTypeDestinationType();
                if (this.locationToLocationType(buyerDestinationLocation2, destination)) {
                    buyer.setDestination(destination);
                } else {
                    buyerDestinationLocation2 = null;
                }
            }
            if ((p_buyerIsTaxExempt || this.isValid(p_buyerExemptReasonCode)) && (exemptCertNr = objectFactory.createExemptionCertificateType()) != null) {
                exemptCertNr.setExemptionCertificateNumber(p_buyerExemptCertNr);
                buyer.setExemptionCertificate(exemptCertNr);
            }
            PurchaseOrderTPPRequestType.VendorType vendor = objectFactory.createPurchaseOrderTPPRequestTypeVendorType();
            Company vendorCompany = this.newCompany(p_vendorCompany);
            if (vendorCompany != null) {
                vendor.setCompany(vendorCompany);
            }
            if ((vendorAdministrativeOriginLocation = p_vendorAdministrativeOrigin.getLocation()) != null) {
                PurchaseOrderTPPRequestType.VendorType.AdministrativeOriginType administrativeOrigin = objectFactory.createPurchaseOrderTPPRequestTypeVendorTypeAdministrativeOriginType();
                if (this.locationToLocationType(vendorAdministrativeOriginLocation, administrativeOrigin)) {
                    vendor.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    vendorAdministrativeOriginLocation = null;
                }
            }
            if ((vendorPhysicalOriginLocation2 = p_vendorPhysicalOrigin.getLocation()) != null) {
                LocationType physicalOrigin = objectFactory.createLocationType();
                if (this.locationToLocationType(vendorPhysicalOriginLocation2, physicalOrigin)) {
                    vendor.setPhysicalOrigin(physicalOrigin);
                } else {
                    vendorPhysicalOriginLocation2 = null;
                }
            }
            if (buyerDestinationLocation2 != null) {
                request.setBuyer(buyer);
            }
            if (vendorPhysicalOriginLocation2 != null || vendorAdministrativeOriginLocation != null) {
                request.setVendor(vendor);
            }
            List inputLineItems = request.getLineItem();
            LineItemPOTIType inputLineItem = objectFactory.createLineItemPOTIType();
            int itemNumber = p_itemNumber.intValue();
            if (itemNumber >= 0) {
                inputLineItem.setLineItemNumber(BigInteger.valueOf(itemNumber));
            }
            inputLineItem.setTaxDate(documentDate);
            Purchase purchase = objectFactory.createPurchase();
            String purchaseString = p_itemPurchase.toString();
            if (this.isValid(purchaseString)) {
                purchase.setValue(purchaseString);
            }
            if (this.isValid(purchaseClass = p_itemPurchaseClass.toString())) {
                purchase.setPurchaseClass(purchaseClass);
            }
            if (this.isValid(purchaseString) || this.isValid(purchaseClass)) {
                inputLineItem.setPurchase(purchase);
            }
            Quantity quantity = objectFactory.createQuantity();
            double quantityValue = p_itemQuantity.doubleValue();
            quantity.setValue(quantityValue);
            if (quantityValue > 0.0) {
                inputLineItem.setQuantity(quantity);
            }
            AmountType extendedPrice = objectFactory.createAmountType();
            double extendedPriceValue = p_itemExtendedPrice.doubleValue();
            extendedPrice.setValue(extendedPriceValue);
            if (extendedPriceValue > 0.0) {
                inputLineItem.setExtendedPrice(extendedPrice);
            }
            inputLineItems.add(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        PurchaseOrderTPPResponse response = (PurchaseOrderTPPResponse)UTIL.doPurchaseOrderTPPRequest(request, class$com$ssa$ta$vertex1$ws$bindings$PurchaseOrderTPPResponse == null ? (class$com$ssa$ta$vertex1$ws$bindings$PurchaseOrderTPPResponse = TaxProvider.class$("com.ssa.ta.vertex1.ws.bindings.PurchaseOrderTPPResponse")) : class$com$ssa$ta$vertex1$ws$bindings$PurchaseOrderTPPResponse);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        Calendar rDocumentDateObject = response.getDocumentDate();
        Date rDocumentDate = rDocumentDateObject.getTime();
        String rDocumentDateString = DATE_FORMAT.format(rDocumentDate);
        p_documentDate.setValue(rDocumentDateString);
        PurchaseOrderTPPResponseType.BuyerType rBuyer = response.getBuyer();
        LocationType rDestinationLocation = null;
        if (rBuyer != null) {
            rDestinationLocation = rBuyer.getDestination();
        }
        if ((buyerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_buyerDestination.setLocation(buyerDestinationLocation);
        }
        PurchaseOrderTPPResponseType.VendorType rVendor = response.getVendor();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        if (rVendor != null) {
            rPhysicalOriginLocation = rVendor.getPhysicalOrigin();
            rAdministrativeOrigin = rVendor.getAdministrativeOrigin();
        }
        if ((vendorPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_vendorPhysicalOrigin.setLocation(vendorPhysicalOriginLocation);
        }
        if ((vendorAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_vendorAdministrativeOrigin.setLocation(vendorAdministrativeLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemPOTOType rLineItem = (LineItemPOTOType)rLineItems.get(0);
        BigInteger rItemNr = rLineItem.getLineItemNumber();
        this.setValue(p_itemNumber, rItemNr);
        PurchaseType rPurchase = rLineItem.getPurchase();
        String rPurchaseValue = null;
        String rPurchaseClass = null;
        if (rPurchase != null) {
            rPurchaseValue = rPurchase.getValue();
            rPurchaseClass = rPurchase.getPurchaseClass();
        }
        this.setValue(p_itemPurchase, rPurchaseValue);
        this.setValue(p_itemPurchaseClass, rPurchaseClass);
        QuantityType rQuantity = rLineItem.getQuantity();
        double rQuantityValue = -1.0;
        if (rQuantity != null) {
            rQuantityValue = rQuantity.getValue();
        }
        p_itemQuantity.setValue(rQuantityValue);
        AmountType rExtendedPrice = rLineItem.getExtendedPrice();
        double rExtendedPriceValue = -1.0;
        if (rExtendedPrice != null) {
            rExtendedPriceValue = rExtendedPrice.getValue();
        }
        p_itemExtendedPrice.setValue(rExtendedPriceValue);
        List rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = (TaxesType)rTaxes.get(i);
            Tax tax = new Tax();
            String rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult);
            TaxesType.JurisdictionType rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            String rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel);
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "purchaseOrderTPP");
    }

    public void taxOnlyAdjustmentSale(StringHolder p_documentNr, StringHolder p_documentDate, String p_sellerCompany, SellerPhysicalOrigin p_sellerPhysicalOrigin, SellerAdministrativeOrigin p_sellerAdministrativeOrigin, SellerDestination p_sellerDestination, double p_inputTotalTax, TaxArray p_taxArray, DoubleHolder p_itemTotalTax) throws TaxProviderException {
        List rLineItems;
        int nrLineItems;
        Location sellerDestinationLocation;
        Location sellerAdministrativeLocation;
        Location sellerPhysicalOriginLocation;
        String M_NAME = "taxOnlyAdjustmentSale";
        s_logger.entering(C_NAME, "taxOnlyAdjustmentSale");
        TaxOnlyAdjustmentSaleRequest request = null;
        try {
            Location sellerDestinationLocation2;
            Location sellerAdministrativeOriginLocation;
            Location sellerPhysicalOriginLocation2;
            ObjectFactory objectFactory = UTIL.getObjectFactory();
            request = objectFactory.createTaxOnlyAdjustmentSaleRequest();
            String requestDocumentNr = p_documentNr.toString();
            if (this.isValid(requestDocumentNr)) {
                request.setDocumentNumber(requestDocumentNr);
            }
            Calendar documentDate = this.stringToCalendar(p_documentDate.toString());
            request.setDocumentDate(documentDate);
            TaxOnlyAdjustmentSaleRequestType.SellerType seller = objectFactory.createTaxOnlyAdjustmentSaleRequestTypeSellerType();
            Company sellerCompany = this.newCompany(p_sellerCompany);
            if (sellerCompany != null) {
                seller.setCompany(sellerCompany);
            }
            if ((sellerPhysicalOriginLocation2 = p_sellerPhysicalOrigin.getLocation()) != null) {
                TaxOnlyAdjustmentSaleRequestType.SellerType.PhysicalOriginType physicalOrigin = objectFactory.createTaxOnlyAdjustmentSaleRequestTypeSellerTypePhysicalOriginType();
                if (this.locationToLocationType(sellerPhysicalOriginLocation2, physicalOrigin)) {
                    seller.setPhysicalOrigin(physicalOrigin);
                } else {
                    sellerPhysicalOriginLocation2 = null;
                }
            }
            if ((sellerAdministrativeOriginLocation = p_sellerAdministrativeOrigin.getLocation()) != null) {
                TaxOnlyAdjustmentSaleRequestType.SellerType.AdministrativeOriginType administrativeOrigin = objectFactory.createTaxOnlyAdjustmentSaleRequestTypeSellerTypeAdministrativeOriginType();
                if (this.locationToLocationType(sellerAdministrativeOriginLocation, administrativeOrigin)) {
                    seller.setAdministrativeOrigin(administrativeOrigin);
                } else {
                    sellerAdministrativeOriginLocation = null;
                }
            }
            if ((sellerDestinationLocation2 = p_sellerDestination.getLocation()) != null) {
                TaxOnlyAdjustmentSaleRequestType.SellerType.DestinationType destination = objectFactory.createTaxOnlyAdjustmentSaleRequestTypeSellerTypeDestinationType();
                if (this.locationToLocationType(sellerDestinationLocation2, destination)) {
                    seller.setDestination(destination);
                } else {
                    sellerDestinationLocation2 = null;
                }
            }
            if (sellerDestinationLocation2 != null || sellerPhysicalOriginLocation2 != null || sellerAdministrativeOriginLocation != null) {
                request.setSeller(seller);
            }
            LineItemTOASIType inputLineItem = objectFactory.createLineItemTOASIType();
            inputLineItem.setTaxDate(documentDate);
            AmountType inputTotalTax = objectFactory.createAmountType();
            inputTotalTax.setValue(p_inputTotalTax);
            if (inputTotalTax != null) {
                inputLineItem.setInputTotalTax(inputTotalTax);
            }
            request.setLineItem(inputLineItem);
        }
        catch (JAXBException ex_j) {
            throw UTIL.newSevereRuntimeException("Could not construct Vertex request message", ex_j);
        }
        TaxOnlyAdjustmentSaleResponse response = (TaxOnlyAdjustmentSaleResponse)UTIL.doTaxOnlyAdjustmentSaleRequest(request, class$com$ssa$ta$vertex1$ws$bindings$TaxOnlyAdjustmentSaleResponse == null ? (class$com$ssa$ta$vertex1$ws$bindings$TaxOnlyAdjustmentSaleResponse = TaxProvider.class$("com.ssa.ta.vertex1.ws.bindings.TaxOnlyAdjustmentSaleResponse")) : class$com$ssa$ta$vertex1$ws$bindings$TaxOnlyAdjustmentSaleResponse);
        String rDocumentNr = response.getDocumentNumber();
        this.setValue(p_documentNr, rDocumentNr);
        Calendar rDocumentDateObject = response.getDocumentDate();
        Date rDocumentDate = rDocumentDateObject.getTime();
        String rDocumentDateString = DATE_FORMAT.format(rDocumentDate);
        p_documentDate.setValue(rDocumentDateString);
        TaxOnlyAdjustmentSaleResponseType.SellerType rSeller = response.getSeller();
        LocationType rPhysicalOriginLocation = null;
        LocationType rAdministrativeOrigin = null;
        LocationType rDestinationLocation = null;
        if (rSeller != null) {
            rPhysicalOriginLocation = rSeller.getPhysicalOrigin();
            rAdministrativeOrigin = rSeller.getAdministrativeOrigin();
            rDestinationLocation = rSeller.getDestination();
        }
        if ((sellerPhysicalOriginLocation = this.newLocation(rPhysicalOriginLocation)) != null) {
            p_sellerPhysicalOrigin.setLocation(sellerPhysicalOriginLocation);
        }
        if ((sellerAdministrativeLocation = this.newLocation(rAdministrativeOrigin)) != null) {
            p_sellerAdministrativeOrigin.setLocation(sellerAdministrativeLocation);
        }
        if ((sellerDestinationLocation = this.newLocation(rDestinationLocation)) != null) {
            p_sellerDestination.setLocation(sellerDestinationLocation);
        }
        if ((nrLineItems = (rLineItems = response.getLineItem()).size()) != 1) {
            throw UTIL.newSevereRuntimeException("Detected more than one LineItem in Vertex response");
        }
        LineItemTOASOType rLineItem = (LineItemTOASOType)rLineItems.get(0);
        List rTaxes = rLineItem.getTaxes();
        int nrTaxes = rTaxes.size();
        for (int i = 0; i < nrTaxes; ++i) {
            TaxesType rTax = (TaxesType)rTaxes.get(i);
            Tax tax = new Tax();
            String rTaxResult = rTax.getTaxResult();
            tax.setTaxResult(rTaxResult);
            TaxesType.JurisdictionType rJurisdiction = rTax.getJurisdiction();
            Jurisdiction jurisdiction = new Jurisdiction();
            String rJurisdictionValue = rJurisdiction.getValue();
            jurisdiction.setJurisdictionName(rJurisdictionValue);
            String rJurisdictionLevel = rJurisdiction.getJurisdictionLevel();
            jurisdiction.setJurisdictionLevel(rJurisdictionLevel);
            tax.setJurisdiction(jurisdiction);
            AmountType rCalculatedTax = rTax.getCalculatedTax();
            double rCalculatedTaxValue = rCalculatedTax.getValue();
            tax.setCalculatedTax(rCalculatedTaxValue);
            double rEffectiveRate = rTax.getEffectiveRate();
            tax.setEffectiveRate(rEffectiveRate);
            p_taxArray.addTax(tax);
        }
        AmountType rTotalTax = rLineItem.getTotalTax();
        double rTotalTaxValue = rTotalTax.getValue();
        p_itemTotalTax.setValue(rTotalTaxValue);
        s_logger.exiting(C_NAME, "taxOnlyAdjustmentSale");
    }

    private Location newLocation(LocationType p_location) {
        String country;
        String state;
        String county;
        String city;
        String zipCode;
        if (p_location == null) {
            return null;
        }
        Location location = new Location();
        BigInteger bigInt = p_location.getTaxAreaId();
        if (bigInt.compareTo(INTEGER_MIN_VALUE) < 0) {
            throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too low. Cannot fit in a Java int");
        }
        if (bigInt.compareTo(INTEGER_MAX_VALUE) > 0) {
            throw UTIL.newSevereRuntimeException("TaxAreaId " + bigInt + " is too big. Cannot fit in a Java int");
        }
        int geocode = bigInt.intValue();
        location.setGeocode(geocode);
        String street = p_location.getStreetAddress();
        if (street != null) {
            location.setStreet(street);
        }
        if ((zipCode = p_location.getPostalCode()) != null) {
            location.setZipCode(zipCode);
        }
        if ((city = p_location.getCity()) != null) {
            location.setCity(city);
        }
        if ((county = p_location.getSubDivision()) != null) {
            location.setCounty(county);
        }
        if ((state = p_location.getMainDivision()) != null) {
            location.setState(state);
        }
        if ((country = p_location.getCountry()) != null) {
            location.setCountry(country);
        }
        return location;
    }

    private void setValue(IntHolder p_holder, BigInteger p_value) {
        if (p_value != null) {
            if (p_value.compareTo(INTEGER_MIN_VALUE) < 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + p_value + " is too low. Cannot fit in a Java int");
            }
            if (p_value.compareTo(INTEGER_MAX_VALUE) > 0) {
                throw UTIL.newSevereRuntimeException("TaxAreaId " + p_value + " is too big. Cannot fit in a Java int");
            }
            int value = p_value.intValue();
            p_holder.setValue(value);
        } else {
            p_holder.setValue(-1);
        }
    }

    private void setValue(StringHolder p_holder, String p_value) {
        if (p_value != null) {
            p_holder.setValue(p_value);
        } else {
            p_holder.setValue(EMPTY_STRING);
        }
    }

    private boolean isValid(String p_parameter) {
        return p_parameter != null && p_parameter.length() > 0;
    }

    private Company newCompany(String p_company) throws JAXBException {
        if (!this.isValid(p_company)) {
            return null;
        }
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        Company company = objectFactory.createCompany();
        List companyObjects = company.getContent();
        companyObjects.add(p_company);
        return company;
    }

    private Company newCompany(StringHolder p_company) throws JAXBException {
        if (p_company == null) {
            return null;
        }
        ObjectFactory objectFactory = UTIL.getObjectFactory();
        Company company = objectFactory.createCompany();
        List companyObjects = company.getContent();
        companyObjects.add(p_company);
        return company;
    }

    private Calendar stringToCalendar(String p_date) {
        try {
            Date datetime = DATE_FORMAT.parse(p_date);
            Calendar date = Calendar.getInstance(TIMEZONE_UTC);
            date.setTime(datetime);
            return date;
        }
        catch (ParseException ex_p) {
            throw UTIL.newSevereRuntimeException("Could not convert date string to Calendar object", ex_p);
        }
    }

    private boolean locationToLocationType(Location p_location, LocationType p_locationType) {
        int nrFields = 0;
        if (p_location.hasGeocode()) {
            p_locationType.setTaxAreaId(BigInteger.valueOf(p_location.getGeocode()));
            ++nrFields;
        }
        if (p_location.hasStreet()) {
            p_locationType.setStreetAddress(p_location.getStreet());
            ++nrFields;
        }
        if (p_location.hasCity()) {
            p_locationType.setCity(p_location.getCity());
            ++nrFields;
        }
        if (p_location.hasZipCode()) {
            p_locationType.setPostalCode(p_location.getZipCode());
            ++nrFields;
        }
        if (p_location.hasCounty()) {
            p_locationType.setSubDivision(p_location.getCounty());
            ++nrFields;
        }
        if (p_location.hasState()) {
            p_locationType.setMainDivision(p_location.getState());
            ++nrFields;
        }
        if (p_location.hasCountry()) {
            p_locationType.setCountry(p_location.getCountry());
            ++nrFields;
        }
        return nrFields != 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DATE_FORMAT.setTimeZone(TIMEZONE_UTC);
    }
}

