/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.rpc.streaming.XMLReader;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.FactoryConfigurationError;
import org.xml.sax.InputSource;

public abstract class XMLReaderFactory {
    private static XMLReaderFactory _instance;

    protected XMLReaderFactory() {
    }

    public static XMLReaderFactory newInstance() {
        if (_instance == null) {
            String factoryImplName = XMLReaderFactory.getFactoryImplName();
            try {
                Class<?> clazz = Class.forName(factoryImplName);
                _instance = (XMLReaderFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new FactoryConfigurationError(e);
            }
            catch (IllegalAccessException e) {
                throw new FactoryConfigurationError(e);
            }
            catch (InstantiationException e) {
                throw new FactoryConfigurationError(e);
            }
        }
        return _instance;
    }

    private static String getFactoryImplName() {
        String factoryImplName;
        try {
            factoryImplName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.sun.xml.rpc.streaming.XMLReaderFactory", "com.sun.xml.rpc.streaming.XMLReaderFactoryImpl");
                }
            });
        }
        catch (AccessControlException e) {
            factoryImplName = "com.sun.xml.rpc.streaming.XMLReaderFactoryImpl";
        }
        return factoryImplName;
    }

    public abstract XMLReader createXMLReader(InputStream var1);

    public abstract XMLReader createXMLReader(InputStream var1, boolean var2);

    public abstract XMLReader createXMLReader(InputSource var1);

    public abstract XMLReader createXMLReader(InputSource var1, boolean var2);
}

