/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.server.http;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.rpc.server.http.Implementor;
import com.sun.xml.rpc.server.http.ImplementorCache;
import com.sun.xml.rpc.server.http.JAXRPCRuntimeInfo;
import com.sun.xml.rpc.server.http.RuntimeEndpointInfo;
import com.sun.xml.rpc.server.http.ServletDelegate;
import com.sun.xml.rpc.server.http.ServletEndpointContextImpl;
import com.sun.xml.rpc.server.http.WSDLPublisher;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.message.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import com.sun.xml.rpc.util.exception.JAXRPCExceptionBase;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class JAXRPCServletDelegate
implements ServletDelegate {
    private SOAPEncodingConstants soapEncodingConstants = null;
    private ServletConfig servletConfig;
    private ServletContext servletContext;
    private JAXRPCRuntimeInfo jaxrpcInfo;
    private Localizer defaultLocalizer;
    private LocalizableMessageFactory messageFactory;
    private ImplementorCache implementorCache;
    private Map fixedUrlPatternEndpoints;
    private List pathUrlPatternEndpoints;
    private Map localizerMap;
    private WSDLPublisher publisher;
    private boolean publishWSDL;
    private boolean publishModel;
    private boolean publishStatusPage;
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.rpc.server.http");
    private ServletSecondDelegate secondDelegate = null;
    private SystemHandlerDelegate systemHandlerDelegate = null;

    public void destroy() {
        this.implementorCache.destroy();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.destroy")));
        }
    }

    protected void warnMissingContextInformation() {
        if (this.secondDelegate != null) {
            this.secondDelegate.warnMissingContextInformation();
        } else {
            logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.missingContextInformation")));
        }
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
    }

    protected com.sun.xml.rpc.spi.runtime.ImplementorCache createImplementorCache() {
        if (this.secondDelegate != null) {
            return this.secondDelegate.createImplementorCache(this.servletConfig);
        }
        return new ImplementorCache(this.servletConfig);
    }

    public void registerEndpointUrlPattern(com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo info) {
        String urlPattern = ((RuntimeEndpointInfo)info).getUrlPattern();
        if (urlPattern.indexOf("*.") != -1) {
            logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.ignoringImplicitUrlPattern", ((RuntimeEndpointInfo)info).getName())));
        } else if (urlPattern.endsWith("/*")) {
            this.pathUrlPatternEndpoints.add(info);
        } else if (this.fixedUrlPatternEndpoints.containsKey(urlPattern)) {
            logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointUrlPattern", ((RuntimeEndpointInfo)info).getName())));
        } else {
            this.fixedUrlPatternEndpoints.put(urlPattern, info);
        }
    }

    public void setSecondDelegate(ServletSecondDelegate secondDelegate) {
        this.secondDelegate = secondDelegate;
    }

    public void setSystemHandlerDelegate(SystemHandlerDelegate systemHandlerDelegate) {
        this.systemHandlerDelegate = systemHandlerDelegate;
    }

    protected static byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        if (istream != null) {
            while ((num = istream.read(buf)) != -1) {
                bout.write(buf, 0, num);
            }
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.init(servletConfig, SOAPVersion.SOAP_11);
    }

    private void setContentTypeAndFlush(HttpServletResponse response) throws IOException {
        response.setContentType("text/xml");
        response.flushBuffer();
        response.getWriter().close();
    }

    protected boolean checkContentLength(MimeHeaders headers) {
        int length;
        String[] contentLength = headers.getHeader("Content-Length");
        return contentLength != null && contentLength.length > 0 && (length = new Integer(contentLength[0]).intValue()) > 0;
    }

    protected boolean checkContentType(MimeHeaders headers) {
        String[] contentTypes = headers.getHeader("Content-Type");
        return contentTypes != null && contentTypes.length >= 1 && contentTypes[0].indexOf("text/xml") != -1;
    }

    boolean checkForContent(MimeHeaders headers) {
        return this.checkContentType(headers) && this.checkContentLength(headers);
    }

    protected RuntimeEndpointInfo getEndpointFor(HttpServletRequest request) {
        String path = request.getRequestURI().substring(request.getContextPath().length());
        RuntimeEndpointInfo result = (RuntimeEndpointInfo)this.fixedUrlPatternEndpoints.get(path);
        if (result == null) {
            Iterator iter = this.pathUrlPatternEndpoints.iterator();
            while (iter.hasNext()) {
                RuntimeEndpointInfo candidate = (RuntimeEndpointInfo)iter.next();
                if (!candidate.getUrlPattern().startsWith(path)) continue;
                result = candidate;
                break;
            }
        }
        return result;
    }

    public void init(ServletConfig servletConfig, SOAPVersion ver) throws ServletException {
        this.init(ver);
        this.defaultLocalizer = new Localizer();
        this.localizerMap = new HashMap();
        this.localizerMap.put(this.defaultLocalizer.getLocale(), this.defaultLocalizer);
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.jaxrpcservlet");
        this.servletConfig = servletConfig;
        this.servletContext = servletConfig.getServletContext();
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.initialize")));
        }
        this.fixedUrlPatternEndpoints = new HashMap();
        this.pathUrlPatternEndpoints = new ArrayList();
        this.jaxrpcInfo = (JAXRPCRuntimeInfo)this.servletContext.getAttribute("com.sun.xml.rpc.server.http.info");
        if (this.jaxrpcInfo == null) {
            this.warnMissingContextInformation();
        } else {
            HashMap<String, RuntimeEndpointInfo> endpointsByName = new HashMap<String, RuntimeEndpointInfo>();
            Iterator iter = this.jaxrpcInfo.getEndpoints().iterator();
            while (iter.hasNext()) {
                RuntimeEndpointInfo info = (RuntimeEndpointInfo)iter.next();
                if (endpointsByName.containsKey(info.getName())) {
                    logger.warning(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.warning.duplicateEndpointName", info.getName())));
                    continue;
                }
                endpointsByName.put(info.getName(), info);
                this.registerEndpointUrlPattern(info);
            }
        }
        String publishWSDLParam = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishWSDL");
        this.publishWSDL = publishWSDLParam == null ? true : Boolean.valueOf(publishWSDLParam);
        String publishModelParam = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishModel");
        this.publishModel = publishModelParam == null ? true : Boolean.valueOf(publishModelParam);
        String publishStatusPageParam = this.servletContext.getInitParameter("com.sun.xml.rpc.server.http.publishStatusPage");
        this.publishStatusPage = publishStatusPageParam == null ? true : Boolean.valueOf(publishStatusPageParam);
        this.implementorCache = (ImplementorCache)this.createImplementorCache();
        this.publisher = new WSDLPublisher(this.servletContext, this.jaxrpcInfo);
        if (this.secondDelegate != null) {
            this.secondDelegate.postInit(servletConfig);
        }
    }

    protected void writeInvalidContentType(HttpServletResponse response, SOAPMessageContext messageContext) throws SOAPException, IOException {
        response.setStatus(415);
        this.setContentTypeAndFlush(response);
    }

    protected void writeReply(HttpServletResponse resp, SOAPMessageContext messageContext) throws SOAPException, IOException {
        if (this.checkMessageContextProperty(messageContext, "com.sun.xml.rpc.server.OneWayOperation")) {
            return;
        }
        SOAPMessage reply = messageContext.getMessage();
        boolean statusCode = false;
        if (messageContext.isFailure()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.writingFaultResponse")));
            }
            if (this.checkMessageContextProperty(messageContext, "com.sun.xml.rpc.server.http.ClientBadRequest")) {
                resp.setStatus(400);
                this.setContentTypeAndFlush(resp);
                return;
            }
            resp.setStatus(500);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.writingSuccessResponse")));
            }
            resp.setStatus(200);
        }
        ServletOutputStream os = resp.getOutputStream();
        String[] headers = reply.getMimeHeaders().getHeader("Content-Type");
        if (headers != null && headers.length > 0) {
            resp.setContentType(headers[0]);
        } else {
            resp.setContentType("text/xml");
        }
        JAXRPCServletDelegate.putHeaders(reply.getMimeHeaders(), resp);
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Localizer getLocalizerFor(ServletRequest request) {
        Locale locale = request.getLocale();
        if (locale.equals(this.defaultLocalizer.getLocale())) {
            return this.defaultLocalizer;
        }
        Map map = this.localizerMap;
        synchronized (map) {
            Localizer localizer = (Localizer)this.localizerMap.get(locale);
            if (localizer == null) {
                localizer = new Localizer(locale);
                this.localizerMap.put(locale, localizer);
            }
            return localizer;
        }
    }

    protected static void copyStream(InputStream istream, OutputStream ostream) throws IOException {
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            ostream.write(buf, 0, num);
        }
        ostream.flush();
    }

    protected String getValidPathForEndpoint(RuntimeEndpointInfo info) {
        String s = info.getUrlPattern();
        if (s.endsWith("/*")) {
            return s.substring(0, s.length() - 2);
        }
        return s;
    }

    void setMessageContextProperty(SOAPMessageContext messageContext, String property) {
        messageContext.setProperty(property, "true");
    }

    boolean checkMessageContextProperty(SOAPMessageContext messageContext, String property) {
        String prop = (String)messageContext.getProperty(property);
        return prop != null && prop.equalsIgnoreCase("true");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.secondDelegate != null) {
            this.secondDelegate.doGet(request, response);
        } else {
            this.doGetDefault(request, response);
        }
    }

    private void doGetDefault(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            MimeHeaders headers = JAXRPCServletDelegate.getHeaders(request);
            Localizer localizer = this.getLocalizerFor((ServletRequest)request);
            if (this.checkForContent(headers)) {
                this.writeInvalidMethodType(localizer, response, "Invalid Method Type");
                if (logger.isLoggable(Level.INFO)) {
                    logger.severe(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.html.method")));
                    logger.severe("Must use Http POST for the service request");
                }
                return;
            }
            RuntimeEndpointInfo targetEndpoint = this.getEndpointFor(request);
            if (targetEndpoint != null && request.getQueryString() != null) {
                if (request.getQueryString().equals("WSDL")) {
                    if (this.publishWSDL && targetEndpoint.getWSDLFileName() != null) {
                        this.publisher.handle(targetEndpoint, this.fixedUrlPatternEndpoints, request, response);
                    } else {
                        this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                    }
                } else if (request.getQueryString().equals("model")) {
                    if (this.publishModel && targetEndpoint.getModelFileName() != null) {
                        response.setContentType("application/x-gzip");
                        InputStream istream = this.servletContext.getResourceAsStream(targetEndpoint.getModelFileName());
                        JAXRPCServletDelegate.copyStream(istream, (OutputStream)response.getOutputStream());
                        istream.close();
                    } else {
                        this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                    }
                } else {
                    this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                }
            } else if (request.getPathInfo() == null) {
                if (this.publishStatusPage) {
                    response.setContentType("text/html");
                    PrintWriter out = response.getWriter();
                    out.println("<html>");
                    out.println("<head><title>");
                    out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
                    out.println("</title></head>");
                    out.println("<body>");
                    out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title2")));
                    if (this.jaxrpcInfo == null) {
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.noInfoAvailable")));
                    } else {
                        out.println("<table width='100%' border='1'>");
                        out.println("<tr>");
                        out.println("<td>");
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.portName")));
                        out.println("</td>");
                        out.println("<td>");
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.status")));
                        out.println("</td>");
                        out.println("<td>");
                        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.columnHeader.information")));
                        out.println("</td>");
                        out.println("</tr>");
                        String baseAddress = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
                        Iterator iter = this.jaxrpcInfo.getEndpoints().iterator();
                        while (iter.hasNext()) {
                            RuntimeEndpointInfo info = (RuntimeEndpointInfo)iter.next();
                            String endpointAddress = baseAddress + this.getValidPathForEndpoint(info);
                            out.println("<tr>");
                            out.println("<td>" + info.getName() + "</td>");
                            out.println("<td>");
                            if (info.isDeployed()) {
                                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.active")));
                            } else {
                                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.status.error")));
                            }
                            out.println("</td>");
                            out.println("<td>");
                            out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.information.table", new Object[]{endpointAddress, info.getPortName(), info.getRemoteInterface().getName(), info.getImplementationClass().getName()})));
                            out.println("</td>");
                            out.println("</tr>");
                        }
                        out.println("</table>");
                    }
                    out.println("</body>");
                    out.println("</html>");
                } else {
                    this.writeNotFoundErrorPage(localizer, response, "Invalid request");
                }
            } else if (this.publishStatusPage) {
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html>");
                out.println("<head><title>");
                out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
                out.println("</title></head>");
                out.println("<body>");
                out.println("</body>");
                out.println("</html>");
            } else {
                this.writeNotFoundErrorPage(localizer, response, "Invalid request");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new ServletException(e.getMessage());
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            MimeHeaders headers = JAXRPCServletDelegate.getHeaders(request);
            SOAPMessageContext messageContext = new SOAPMessageContext();
            if (!this.checkContentType(headers)) {
                this.writeInvalidContentType(response, messageContext);
                return;
            }
            SOAPMessage message = this.getSOAPMessageFromRequest(request, headers, messageContext);
            if (message == null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.emptyRequestMessage")));
                }
                messageContext.writeSimpleErrorResponse(this.soapEncodingConstants.getFaultCodeClient(), this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.info.emptyRequestMessage")));
            } else {
                messageContext.setMessage(message);
                RuntimeEndpointInfo targetEndpoint = this.getEndpointFor(request);
                if (targetEndpoint != null) {
                    Implementor implementor;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.gotRequestForEndpoint", targetEndpoint.getName())));
                    }
                    if ((implementor = (Implementor)this.implementorCache.getImplementorFor(targetEndpoint)) == null) {
                        logger.severe(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.error.noImplementorForEndpoint", targetEndpoint.getName())));
                        messageContext.writeSimpleErrorResponse(this.soapEncodingConstants.getFaultCodeServer(), this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.portNotFound", targetEndpoint.getName())));
                    } else {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.trace.invokingImplementor", implementor.toString())));
                        }
                        ServletEndpointContextImpl endpointContext = implementor.getContext();
                        Object clientContext = null;
                        try {
                            block25: {
                                endpointContext.setMessageContext((MessageContext)messageContext);
                                endpointContext.setHttpServletRequest(request);
                                messageContext.setProperty("com.sun.xml.rpc.server.http.ServletContext", this.servletContext);
                                messageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletRequest", request);
                                messageContext.setProperty("com.sun.xml.rpc.server.http.HttpServletResponse", response);
                                messageContext.setProperty("com.sun.xml.rpc.server.http.Implementor", implementor);
                                if (this.systemHandlerDelegate == null) {
                                    implementor.getTie().handle(messageContext);
                                    break block25;
                                }
                                if (!this.systemHandlerDelegate.processRequest(messageContext)) break block25;
                                implementor.getTie().handle(messageContext);
                                this.systemHandlerDelegate.processResponse(messageContext);
                            }
                            Object var12_16 = null;
                            endpointContext.clear();
                        }
                        catch (Throwable throwable) {
                            Object var12_17 = null;
                            endpointContext.clear();
                            throw throwable;
                        }
                        this.implementorCache.releaseImplementor(targetEndpoint, implementor);
                    }
                } else {
                    logger.severe(this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.error.noEndpointSpecified")));
                    messageContext.writeSimpleErrorResponse(this.soapEncodingConstants.getFaultCodeClient(), this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.missingPort")));
                }
            }
            SOAPMessage reply = messageContext.getMessage();
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
            this.writeReply(response, messageContext);
        }
        catch (JAXRPCExceptionBase e) {
            logger.log(Level.SEVERE, this.defaultLocalizer.localize(e), (Throwable)((Object)e));
            response.setStatus(500);
            try {
                SOAPMessageContext messageContext = new SOAPMessageContext();
                messageContext.writeSimpleErrorResponse(this.soapEncodingConstants.getFaultCodeServer(), this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.internalServerError", this.defaultLocalizer.localize(e))));
                this.writeReply(response, messageContext);
            }
            catch (Throwable e2) {
                logger.log(Level.SEVERE, "caught throwable while recovering", e2);
            }
        }
        catch (Throwable e) {
            if (e instanceof Localizable) {
                logger.log(Level.SEVERE, this.defaultLocalizer.localize((Localizable)((Object)e)), e);
            } else {
                logger.log(Level.SEVERE, "caught throwable", e);
            }
            response.setStatus(500);
            try {
                SOAPMessageContext messageContext = new SOAPMessageContext();
                messageContext.writeSimpleErrorResponse(this.soapEncodingConstants.getFaultCodeServer(), this.defaultLocalizer.localize(this.messageFactory.getMessage("servlet.faultstring.missingPort")));
                this.writeReply(response, messageContext);
            }
            catch (Throwable e2) {
                logger.log(Level.SEVERE, "caught throwable while recovering", e2);
                return;
            }
        }
    }

    protected static void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        headers.removeHeader("Content-Type");
        headers.removeHeader("Content-Length");
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            res.setHeader(header.getName(), header.getValue());
        }
    }

    protected static MimeHeaders getHeaders(HttpServletRequest req) {
        Enumeration enums = req.getHeaderNames();
        MimeHeaders headers = new MimeHeaders();
        while (enums.hasMoreElements()) {
            String headerName = (String)enums.nextElement();
            String headerValue = req.getHeader(headerName);
            headers.addHeader(headerName, headerValue);
        }
        return headers;
    }

    protected void writeInvalidMethodType(Localizer localizer, HttpServletResponse response, String message) throws IOException {
        response.setStatus(405);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
        out.println("</title></head>");
        out.println("<body>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.method", message)));
        out.println("</body>");
        out.println("</html>");
    }

    protected void writeNotFoundErrorPage(Localizer localizer, HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head><title>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.title")));
        out.println("</title></head>");
        out.println("<body>");
        out.println(localizer.localize(this.messageFactory.getMessage("servlet.html.notFound", message)));
        out.println("</body>");
        out.println("</html>");
    }

    protected SOAPMessage getSOAPMessageFromRequest(HttpServletRequest request, MimeHeaders headers, SOAPMessageContext messageContext) throws IOException {
        SOAPMessage message = null;
        ServletInputStream is = request.getInputStream();
        byte[] bytes = JAXRPCServletDelegate.readFully((InputStream)is);
        int length = request.getContentLength() == -1 ? bytes.length : request.getContentLength();
        ByteInputStream in = new ByteInputStream(bytes, length);
        message = messageContext.createMessage(headers, (InputStream)in);
        return message;
    }
}

