/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model.exporter;

import com.sun.xml.rpc.encoding.simpletype.XSDDateTimeCalendarEncoder;
import com.sun.xml.rpc.processor.util.PrettyPrintingXMLWriterFactoryImpl;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.streaming.XMLWriter;
import com.sun.xml.rpc.streaming.XMLWriterException;
import com.sun.xml.rpc.util.IdentityMap;
import com.sun.xml.rpc.util.VersionUtil;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.GZIPOutputStream;
import javax.xml.namespace.QName;

public abstract class ExporterBase {
    protected OutputStream out;
    protected XMLWriter writer;
    protected Map obj2id;
    protected Map immutableObj2id;
    protected int nextId;
    protected Set obj2serialize;
    protected Stack obj2serializeStack;
    protected Set immediateClasses;
    protected Set immutableClasses;
    protected static final QName DEF_OBJ_NAME = new QName("object");
    protected static final QName DEF_IMM_OBJ_NAME = new QName("iobject");
    protected static final QName PROP_NAME = new QName("property");
    protected static final String ATTR_VERSION = "version";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_VALUE = "value";
    protected static final String ATTR_SUBJECT = "subject";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle;
    static /* synthetic */ Class class$com$sun$xml$rpc$wsdl$document$soap$SOAPUse;
    static /* synthetic */ Class class$com$sun$xml$rpc$soap$SOAPVersion;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$GregorianCalendar;

    protected void initialize() {
        this.obj2id = new IdentityMap();
        this.immutableObj2id = new HashMap();
        this.obj2serialize = new HashSet();
        this.obj2serializeStack = new Stack();
        this.nextId = 1;
        this.immutableClasses = new HashSet();
        this.immutableClasses.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ExporterBase.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.immutableClasses.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ExporterBase.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.immutableClasses.add(class$java$lang$Short == null ? (class$java$lang$Short = ExporterBase.class$("java.lang.Short")) : class$java$lang$Short);
        this.immutableClasses.add(class$java$lang$Long == null ? (class$java$lang$Long = ExporterBase.class$("java.lang.Long")) : class$java$lang$Long);
        this.immutableClasses.add(class$java$lang$Float == null ? (class$java$lang$Float = ExporterBase.class$("java.lang.Float")) : class$java$lang$Float);
        this.immutableClasses.add(class$java$lang$Double == null ? (class$java$lang$Double = ExporterBase.class$("java.lang.Double")) : class$java$lang$Double);
        this.immutableClasses.add(class$java$lang$Byte == null ? (class$java$lang$Byte = ExporterBase.class$("java.lang.Byte")) : class$java$lang$Byte);
        this.immutableClasses.add(class$java$lang$String == null ? (class$java$lang$String = ExporterBase.class$("java.lang.String")) : class$java$lang$String);
        this.immutableClasses.add(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ExporterBase.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.immutableClasses.add(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ExporterBase.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        this.immutableClasses.add(class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = ExporterBase.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        this.immutableClasses.add(class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle == null ? (class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle = ExporterBase.class$("com.sun.xml.rpc.wsdl.document.soap.SOAPStyle")) : class$com$sun$xml$rpc$wsdl$document$soap$SOAPStyle);
        this.immutableClasses.add(class$com$sun$xml$rpc$wsdl$document$soap$SOAPUse == null ? (class$com$sun$xml$rpc$wsdl$document$soap$SOAPUse = ExporterBase.class$("com.sun.xml.rpc.wsdl.document.soap.SOAPUse")) : class$com$sun$xml$rpc$wsdl$document$soap$SOAPUse);
        this.immutableClasses.add(class$com$sun$xml$rpc$soap$SOAPVersion == null ? (class$com$sun$xml$rpc$soap$SOAPVersion = ExporterBase.class$("com.sun.xml.rpc.soap.SOAPVersion")) : class$com$sun$xml$rpc$soap$SOAPVersion);
        this.immutableClasses.add(class$java$net$URI == null ? (class$java$net$URI = ExporterBase.class$("java.net.URI")) : class$java$net$URI);
        this.immediateClasses = new HashSet();
        this.immediateClasses.addAll(this.immutableClasses);
        try {
            this.immediateClasses.add(Class.forName("[I"));
            this.immediateClasses.add(Class.forName("[B"));
            this.immediateClasses.add(Class.forName("[Ljava.lang.String;"));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        this.immediateClasses.add(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ExporterBase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        this.immediateClasses.add(class$java$util$HashSet == null ? (class$java$util$HashSet = ExporterBase.class$("java.util.HashSet")) : class$java$util$HashSet);
        this.immediateClasses.add(class$java$util$HashMap == null ? (class$java$util$HashMap = ExporterBase.class$("java.util.HashMap")) : class$java$util$HashMap);
        this.immediateClasses.add(class$java$util$GregorianCalendar == null ? (class$java$util$GregorianCalendar = ExporterBase.class$("java.util.GregorianCalendar")) : class$java$util$GregorianCalendar);
    }

    public ExporterBase(OutputStream s) {
        this.out = s;
        try {
            this.writer = new PrettyPrintingXMLWriterFactoryImpl().createXMLWriter(new GZIPOutputStream(s));
        }
        catch (IOException e) {
            throw new XMLWriterException("xmlwriter.ioException", new LocalizableExceptionAdapter(e));
        }
        this.writer.setPrefixFactory(new PrefixFactoryImpl("ns"));
    }

    protected abstract void failUnsupportedClass(Class var1);

    protected Integer newId() {
        return new Integer(this.nextId++);
    }

    protected int getId(Object obj) {
        if (obj == null) {
            return 0;
        }
        Integer id = (Integer)this.obj2id.get(obj);
        if (id != null) {
            return id;
        }
        boolean immutable = this.isImmutable(obj);
        if (immutable && (id = (Integer)this.immutableObj2id.get(obj)) != null) {
            return id;
        }
        id = this.newId();
        this.obj2id.put(obj, id);
        if (immutable) {
            this.immutableObj2id.put(obj, id);
        }
        if (this.isImmediate(obj)) {
            this.defineImmediate(obj, id);
        } else {
            this.define(obj, id);
        }
        return id;
    }

    protected void internalDoExport(Object root) {
        this.initialize();
        this.writer.startElement(this.getContainerName());
        if (this.getVersion() != null) {
            int[] version = VersionUtil.getCanonicalVersion(this.getVersion());
            this.writer.writeAttribute(ATTR_VERSION, version[0] + "." + version[1] + "." + version[2] + "." + version[3]);
        }
        int id = this.getId(root);
        while (!this.obj2serializeStack.empty()) {
            Object obj = this.obj2serializeStack.pop();
            this.obj2serialize.remove(obj);
            this.visit(obj);
        }
        this.writer.endElement();
        this.writer.close();
    }

    protected void visit(Object obj) {
        if (obj == null) {
            return;
        }
        this.failUnsupportedClass(obj.getClass());
    }

    protected boolean isImmediate(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.immediateClasses.contains(obj.getClass());
    }

    protected boolean isImmutable(Object obj) {
        if (obj == null) {
            return true;
        }
        return this.immutableClasses.contains(obj.getClass());
    }

    protected String getVersion() {
        return null;
    }

    protected abstract QName getContainerName();

    protected QName getDefineImmediateObjectName() {
        return DEF_IMM_OBJ_NAME;
    }

    protected QName getDefineObjectName() {
        return DEF_OBJ_NAME;
    }

    protected QName getPropertyName() {
        return PROP_NAME;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void define(Object obj, Integer id) {
        this.writer.startElement(this.getDefineObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.endElement();
        this.obj2serialize.add(obj);
        this.obj2serializeStack.push(obj);
    }

    protected void defineImmediate(Object obj, Integer id) {
        String value = this.getImmediateObjectValue(obj);
        this.writer.startElement(this.getDefineImmediateObjectName());
        this.writer.writeAttribute(ATTR_ID, id.toString());
        this.writer.writeAttribute(ATTR_TYPE, obj.getClass().getName());
        this.writer.writeAttribute(ATTR_VALUE, value);
        this.writer.endElement();
    }

    protected String getImmediateObjectValue(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof QName) {
            return obj.toString();
        }
        if (obj instanceof Boolean || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Byte || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof SOAPStyle) {
            return obj == SOAPStyle.RPC ? "rpc" : "document";
        }
        if (obj instanceof SOAPUse) {
            return obj == SOAPUse.ENCODED ? "encoded" : "literal";
        }
        if (obj instanceof SOAPVersion) {
            return obj.toString();
        }
        if (obj instanceof int[]) {
            int[] a = (int[])obj;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(a[i]));
                ++i;
            }
            return sb.toString();
        }
        if (obj instanceof byte[]) {
            byte[] a = (byte[])obj;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(Byte.toString(a[i]));
                ++i;
            }
            return sb.toString();
        }
        if (obj instanceof String[]) {
            String[] a = (String[])obj;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < a.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(a[i]);
                ++i;
            }
            return sb.toString();
        }
        if (obj instanceof ArrayList) {
            ArrayList a = (ArrayList)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = a.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashSet) {
            HashSet s = (HashSet)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(element)));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof HashMap) {
            HashMap m = (HashMap)obj;
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            Iterator iter = m.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!first) {
                    sb.append(' ');
                }
                sb.append(Integer.toString(this.getId(entry.getKey())));
                sb.append(' ');
                sb.append(Integer.toString(this.getId(entry.getValue())));
                first = false;
            }
            return sb.toString();
        }
        if (obj instanceof GregorianCalendar) {
            try {
                return XSDDateTimeCalendarEncoder.getInstance().objectToString(obj, null);
            }
            catch (Exception e) {
                this.failUnsupportedClass(obj.getClass());
                return "UNKOWN";
            }
        }
        this.failUnsupportedClass(obj.getClass());
        return "UNKOWN";
    }

    protected void property(String name, Object subject, Object object) {
        int sid = this.getId(subject);
        int oid = this.getId(object);
        this.writer.startElement(this.getPropertyName());
        this.writer.writeAttribute(ATTR_NAME, name);
        this.writer.writeAttribute(ATTR_SUBJECT, Integer.toString(sid));
        this.writer.writeAttribute(ATTR_VALUE, Integer.toString(oid));
        this.writer.endElement();
    }
}

