/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import com.sun.org.apache.xerces.internal.util.ShadowedSymbolTable;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.SynchronizedSymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl;
import com.sun.org.apache.xerces.internal.xni.grammars.Grammar;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarDescription;
import com.sun.org.apache.xerces.internal.xni.grammars.XMLGrammarPool;

public class CachingParserPool {
    public static final boolean DEFAULT_SHADOW_SYMBOL_TABLE = false;
    public static final boolean DEFAULT_SHADOW_GRAMMAR_POOL = false;
    protected SymbolTable fSynchronizedSymbolTable;
    protected XMLGrammarPool fSynchronizedGrammarPool;
    protected boolean fShadowSymbolTable = false;
    protected boolean fShadowGrammarPool = false;

    public CachingParserPool() {
        this(new SymbolTable(), new XMLGrammarPoolImpl());
    }

    public void setShadowSymbolTable(boolean shadow) {
        this.fShadowSymbolTable = shadow;
    }

    public DOMParser createDOMParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        XMLGrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new DOMParser(symbolTable, grammarPool);
    }

    public SAXParser createSAXParser() {
        SymbolTable symbolTable = this.fShadowSymbolTable ? new ShadowedSymbolTable(this.fSynchronizedSymbolTable) : this.fSynchronizedSymbolTable;
        XMLGrammarPool grammarPool = this.fShadowGrammarPool ? new ShadowedGrammarPool(this.fSynchronizedGrammarPool) : this.fSynchronizedGrammarPool;
        return new SAXParser(symbolTable, grammarPool);
    }

    public SymbolTable getSymbolTable() {
        return this.fSynchronizedSymbolTable;
    }

    public XMLGrammarPool getXMLGrammarPool() {
        return this.fSynchronizedGrammarPool;
    }

    public CachingParserPool(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this.fSynchronizedSymbolTable = new SynchronizedSymbolTable(symbolTable);
        this.fSynchronizedGrammarPool = new SynchronizedGrammarPool(grammarPool);
    }

    public static final class ShadowedGrammarPool
    extends XMLGrammarPoolImpl {
        private XMLGrammarPool fGrammarPool;

        public boolean containsGrammar(XMLGrammarDescription desc) {
            return super.containsGrammar(desc);
        }

        public ShadowedGrammarPool(XMLGrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        public Grammar getGrammar(XMLGrammarDescription desc) {
            if (super.containsGrammar(desc)) {
                return super.getGrammar(desc);
            }
            return null;
        }

        public Grammar retrieveGrammar(XMLGrammarDescription gDesc) {
            Grammar g = super.retrieveGrammar(gDesc);
            if (g != null) {
                return g;
            }
            return this.fGrammarPool.retrieveGrammar(gDesc);
        }

        public Grammar[] retrieveInitialGrammarSet(String grammarType) {
            Grammar[] grammars = super.retrieveInitialGrammarSet(grammarType);
            if (grammars != null) {
                return grammars;
            }
            return this.fGrammarPool.retrieveInitialGrammarSet(grammarType);
        }

        public void cacheGrammars(String grammarType, Grammar[] grammars) {
            super.cacheGrammars(grammarType, grammars);
            this.fGrammarPool.cacheGrammars(grammarType, grammars);
        }
    }

    public static final class SynchronizedGrammarPool
    implements XMLGrammarPool {
        private XMLGrammarPool fGrammarPool;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                this.fGrammarPool.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lockPool() {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                this.fGrammarPool.lockPool();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlockPool() {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                this.fGrammarPool.unlockPool();
            }
        }

        public SynchronizedGrammarPool(XMLGrammarPool grammarPool) {
            this.fGrammarPool = grammarPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grammar retrieveGrammar(XMLGrammarDescription gDesc) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                return this.fGrammarPool.retrieveGrammar(gDesc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Grammar[] retrieveInitialGrammarSet(String grammarType) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                return this.fGrammarPool.retrieveInitialGrammarSet(grammarType);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheGrammars(String grammarType, Grammar[] grammars) {
            XMLGrammarPool xMLGrammarPool = this.fGrammarPool;
            synchronized (xMLGrammarPool) {
                this.fGrammarPool.cacheGrammars(grammarType, grammars);
            }
        }
    }
}

