/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMFilter;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.IteratorPool;
import com.sun.org.apache.xpath.internal.axes.PathComponent;
import com.sun.org.apache.xpath.internal.axes.PredicatedNodeTest;
import com.sun.org.apache.xpath.internal.axes.WalkerFactory;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.res.XPATHMessages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    protected boolean m_allowDetach = true;
    protected transient IteratorPool m_clones = new IteratorPool(this);
    protected transient DTM m_cdtm;
    transient int m_stackFrame = -1;
    private boolean m_isTopLevel = false;
    public transient int m_lastFetched = -1;
    protected transient int m_context = -1;
    protected transient int m_currentContextNode = -1;
    protected transient int m_pos = 0;
    protected transient int m_length = -1;
    private PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;

    public int getAnalysisBits() {
        int axis = this.getAxis();
        int bit = WalkerFactory.getAnalysisBitFromAxes(axis);
        return bit;
    }

    public int getAxis() {
        return -1;
    }

    public final int getContext() {
        return this.m_context;
    }

    public final int getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public int getCurrentNode() {
        return this.m_lastFetched;
    }

    public final int getCurrentPos() {
        return this.m_pos;
    }

    public int getLength() {
        int next;
        LocPathIterator clone;
        boolean isPredicateTest = this == this.m_execContext.getSubContextList();
        int predCount = this.getPredicateCount();
        if (-1 != this.m_length && isPredicateTest && this.m_predicateIndex < 1) {
            return this.m_length;
        }
        if (this.m_foundLast) {
            return this.m_pos;
        }
        int pos = this.m_predicateIndex >= 0 ? this.getProximityPosition() : this.m_pos;
        try {
            clone = (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        if (predCount > 0 && isPredicateTest) {
            clone.m_predCount = this.m_predicateIndex;
        }
        while (-1 != (next = clone.nextNode())) {
            ++pos;
        }
        if (isPredicateTest && this.m_predicateIndex < 1) {
            this.m_length = pos;
        }
        return pos;
    }

    public int getRoot() {
        return this.m_context;
    }

    public int getWhatToShow() {
        return -17;
    }

    public abstract int nextNode();

    public int previousNode() {
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_ITERATE", null));
    }

    public int size() {
        this.assertion(false, "size() not supported by this iterator!");
        return 0;
    }

    protected LocPathIterator() {
    }

    public void detach() {
        if (this.m_allowDetach) {
            this.m_execContext = null;
            this.m_cdtm = null;
            this.m_length = -1;
            this.m_pos = 0;
            this.m_lastFetched = -1;
            this.m_context = -1;
            this.m_currentContextNode = -1;
            this.m_clones.freeInstance(this);
        }
    }

    public void incrementCurrentPos() {
        ++this.m_pos;
    }

    public void reset() {
        this.assertion(false, "This iterator can not reset!");
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public boolean isDocOrdered() {
        return true;
    }

    public boolean isFresh() {
        return this.m_pos == 0;
    }

    public boolean isMutable() {
        return false;
    }

    public boolean isNodesetExpr() {
        return true;
    }

    public int item(int index) {
        this.assertion(false, "item(int index) not supported by this iterator!");
        return 0;
    }

    protected int returnNextNode(int nextNode) {
        if (-1 != nextNode) {
            ++this.m_pos;
        }
        this.m_lastFetched = nextNode;
        if (-1 == nextNode) {
            this.m_foundLast = true;
        }
        return nextNode;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int index) {
        block3: {
            if (this.m_foundLast || index >= 0 && index <= this.getCurrentPos()) {
                return;
            }
            if (-1 != index) ** GOTO lbl-1000
            while (-1 != (n = this.nextNode())) {
            }
            break block3;
            while (this.getCurrentPos() < index) lbl-1000:
            // 2 sources

            {
                if (-1 != (n = this.nextNode())) continue;
            }
        }
    }

    public final void setCurrentContextNode(int n) {
        this.m_currentContextNode = n;
    }

    public void setCurrentPos(int i) {
        this.assertion(false, "setCurrentPos not supported by this iterator!");
    }

    protected void setNextPosition(int next) {
        this.assertion(false, "setNextPosition not supported in this iterator!");
    }

    public void setItem(int node, int index) {
        this.assertion(false, "setItem not supported by this iterator!");
    }

    public void allowDetachToRelease(boolean allowRelease) {
        this.m_allowDetach = allowRelease;
    }

    public void setIsTopLevel(boolean b) {
        this.m_isTopLevel = b;
    }

    public void setShouldCacheNodes(boolean b) {
        this.assertion(false, "setShouldCacheNodes not supported by this iterater!");
    }

    public DTM getDTM(int nodeHandle) {
        return this.m_execContext.getDTM(nodeHandle);
    }

    public DTMFilter getFilter() {
        return null;
    }

    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator clone = (LocPathIterator)this.m_clones.getInstanceOrThrow();
        clone.m_execContext = this.m_execContext;
        clone.m_cdtm = this.m_cdtm;
        clone.m_context = this.m_context;
        clone.m_currentContextNode = this.m_currentContextNode;
        clone.m_stackFrame = this.m_stackFrame;
        return clone;
    }

    public DTMManager getDTMManager() {
        return this.m_execContext.getDTMManager();
    }

    public final PrefixResolver getPrefixResolver() {
        if (null == this.m_prefixResolver) {
            this.m_prefixResolver = (PrefixResolver)((Object)this.getExpressionOwner());
        }
        return this.m_prefixResolver;
    }

    protected LocPathIterator(PrefixResolver nscontext) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = nscontext;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        DTMIterator iter = this.m_clones.getInstance();
        int current = xctxt.getCurrentNode();
        iter.setRoot(current, xctxt);
        int next = iter.nextNode();
        iter.detach();
        return next;
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getLength();
    }

    public boolean bool(XPathContext xctxt) throws TransformerException {
        return this.asNode(xctxt) != -1;
    }

    protected LocPathIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        this(compiler, opPos, analysis, true);
    }

    protected LocPathIterator(Compiler compiler, int opPos, int analysis, boolean shouldLoadWalkers) throws TransformerException {
        this.setLocPathIterator(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, TransformerException {
        try {
            stream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TransformerException(cnfe);
        }
    }

    public void setRoot(int context, Object environment) {
        XPathContext xctxt;
        this.m_context = context;
        this.m_execContext = xctxt = (XPathContext)environment;
        this.m_cdtm = xctxt.getDTM(context);
        this.m_currentContextNode = context;
        if (null == this.m_prefixResolver) {
            this.m_prefixResolver = xctxt.getNamespaceContext();
        }
        this.m_lastFetched = -1;
        this.m_foundLast = false;
        this.m_pos = 0;
        this.m_length = -1;
        if (this.m_isTopLevel) {
            this.m_stackFrame = xctxt.getVarStack().getStackFrame();
        }
    }

    public void setEnvironment(Object environment) {
    }

    public DTMIterator asIterator(XPathContext xctxt, int contextNode) throws TransformerException {
        XNodeSet iter = new XNodeSet((LocPathIterator)this.m_clones.getInstance());
        iter.setRoot(contextNode, xctxt);
        return iter;
    }

    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitLocationPath(owner, this)) {
            visitor.visitStep(owner, this);
            this.callPredicateVisitors(visitor);
        }
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XNodeSet iter = new XNodeSet((LocPathIterator)this.m_clones.getInstance());
        iter.setRoot(xctxt.getCurrentNode(), xctxt);
        return iter;
    }

    public void executeCharsToContentHandler(XPathContext xctxt, ContentHandler handler) throws TransformerException, SAXException {
        LocPathIterator clone = (LocPathIterator)this.m_clones.getInstance();
        int current = xctxt.getCurrentNode();
        clone.setRoot(current, xctxt);
        int node = clone.nextNode();
        DTM dtm = clone.getDTM(node);
        clone.detach();
        if (node != -1) {
            dtm.dispatchCharactersEvents(node, handler, false);
        }
    }
}

