/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import java.io.Serializable;
import java.util.Vector;

public class IteratorPool
implements Serializable {
    private final DTMIterator m_orig;
    private final Vector m_freeStack;

    public synchronized DTMIterator getInstance() {
        if (this.m_freeStack.isEmpty()) {
            try {
                return (DTMIterator)this.m_orig.clone();
            }
            catch (Exception ex) {
                throw new WrappedRuntimeException(ex);
            }
        }
        DTMIterator result = (DTMIterator)this.m_freeStack.lastElement();
        this.m_freeStack.setSize(this.m_freeStack.size() - 1);
        return result;
    }

    public synchronized DTMIterator getInstanceOrThrow() throws CloneNotSupportedException {
        if (this.m_freeStack.isEmpty()) {
            return (DTMIterator)this.m_orig.clone();
        }
        DTMIterator result = (DTMIterator)this.m_freeStack.lastElement();
        this.m_freeStack.setSize(this.m_freeStack.size() - 1);
        return result;
    }

    public IteratorPool(DTMIterator original) {
        this.m_orig = original;
        this.m_freeStack = new Vector();
    }

    public synchronized void freeInstance(DTMIterator obj) {
        this.m_freeStack.addElement(obj);
    }
}

