/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.utils.Context2;
import com.sun.org.apache.xml.internal.utils.PrefixForUriEnumerator;
import java.util.EmptyStackException;
import java.util.Enumeration;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespaceSupport2
extends NamespaceSupport {
    private Context2 currentContext;
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";

    public NamespaceSupport2() {
        this.reset();
    }

    public void popContext() {
        Context2 parentContext = this.currentContext.getParent();
        if (parentContext == null) {
            throw new EmptyStackException();
        }
        this.currentContext = parentContext;
    }

    public void pushContext() {
        Context2 parentContext = this.currentContext;
        this.currentContext = parentContext.getChild();
        if (this.currentContext == null) {
            this.currentContext = new Context2(parentContext);
        } else {
            this.currentContext.setParent(parentContext);
        }
    }

    public void reset() {
        this.currentContext = new Context2(null);
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    public Enumeration getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    public Enumeration getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public String getPrefix(String uri) {
        return this.currentContext.getPrefix(uri);
    }

    public String getURI(String prefix) {
        return this.currentContext.getURI(prefix);
    }

    public boolean declarePrefix(String prefix, String uri) {
        if (prefix.equals("xml") || prefix.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(prefix, uri);
        return true;
    }

    public Enumeration getPrefixes(String uri) {
        return new PrefixForUriEnumerator(this, uri, this.getPrefixes());
    }

    public String[] processName(String qName, String[] parts, boolean isAttribute) {
        String[] name = this.currentContext.processName(qName, isAttribute);
        if (name == null) {
            return null;
        }
        System.arraycopy(name, 0, parts, 0, 3);
        return parts;
    }
}

