/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.regexp.internal;

import com.sun.org.apache.regexp.internal.RE;
import com.sun.org.apache.regexp.internal.REDebugCompiler;
import java.applet.Applet;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.swing.JFrame;

public class REDemo
extends Applet
implements TextListener {
    RE r = new RE();
    REDebugCompiler compiler = new REDebugCompiler();
    TextField fieldRE;
    TextField fieldMatch;
    TextArea outRE;
    TextArea outMatch;

    public void init() {
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 13;
        gb.setConstraints(this.add(new Label("Regular expression:", 2)), c);
        c.gridy = 0;
        c.anchor = 17;
        this.fieldRE = new TextField("\\[([:javastart:][:javapart:]*)\\]", 40);
        gb.setConstraints(this.add(this.fieldRE), c);
        c.gridx = 0;
        c.gridy = -1;
        c.anchor = 13;
        gb.setConstraints(this.add(new Label("String:", 2)), c);
        c.gridy = 1;
        c.gridx = -1;
        c.anchor = 17;
        this.fieldMatch = new TextField("aaa([foo])aaa", 40);
        gb.setConstraints(this.add(this.fieldMatch), c);
        c.gridy = 2;
        c.gridx = -1;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.outRE = new TextArea();
        gb.setConstraints(this.add(this.outRE), c);
        c.gridy = 2;
        c.gridx = -1;
        this.outMatch = new TextArea();
        gb.setConstraints(this.add(this.outMatch), c);
        this.fieldRE.addTextListener(this);
        this.fieldMatch.addTextListener(this);
        this.textValueChanged(null);
    }

    public void textValueChanged(TextEvent e) {
        if (e == null || e.getSource() == this.fieldRE) {
            this.updateRE(this.fieldRE.getText());
        }
        this.updateMatch(this.fieldMatch.getText());
    }

    void sayMatch(String s) {
        this.outMatch.setText(s);
    }

    void sayRE(String s) {
        this.outRE.setText(s);
    }

    void updateMatch(String match) {
        block4: {
            try {
                if (this.r.match(match)) {
                    String out = "Matches.\n\n";
                    int i = 0;
                    while (i < this.r.getParenCount()) {
                        out = out + "$" + i + " = " + this.r.getParen(i) + "\n";
                        ++i;
                    }
                    this.sayMatch(out);
                    break block4;
                }
                this.sayMatch("Does not match");
            }
            catch (Throwable t) {
                this.sayMatch(this.throwableToString(t));
            }
        }
    }

    void updateRE(String expr) {
        try {
            this.r.setProgram(this.compiler.compile(expr));
            CharArrayWriter w = new CharArrayWriter();
            this.compiler.dumpProgram(new PrintWriter(w));
            this.sayRE(w.toString());
            System.out.println(w);
        }
        catch (Exception e) {
            this.r.setProgram(null);
            this.sayRE(this.throwableToString(e));
        }
        catch (Throwable t) {
            this.r.setProgram(null);
            this.sayRE(this.throwableToString(t));
        }
    }

    public static void main(String[] arg) {
        JFrame f = new JFrame("RE Demo");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container c = f.getContentPane();
        c.setLayout(new FlowLayout());
        REDemo demo = new REDemo();
        c.add(demo);
        demo.init();
        f.pack();
        f.setVisible(true);
    }

    String throwableToString(Throwable t) {
        String s = t.getClass().getName();
        String m = t.getMessage();
        if (m != null) {
            s = s + "\n" + m;
        }
        return s;
    }
}

