define(function() {

    var modulePaths = {
        // core
        "webhelp" : "core/webhelp_202212050809",
		"sohoxi": "../../js/sohoxi_202212050809",
		"main-init": "../../js/main-init_202212050809",
		"varstore": "../../js/varstore_202212050809",
		"titlemap": "../../js/titlemap_202212050809",					
		"inforhelp": "../../js/inforhelp_202212050809",
		"deliverableCollectionModule": "../../js/deliverableCollectionModule_202212050809",
        // search
        "search" : "search/search_202212050809",
        "nwSearchFnt" : "search/nwSearchFnt_202212050809",
        "searchHistoryItems" : "search/searchHistoryItems",
        // search index
        "index" : "search/index/index",
        "link2parent" : "search/index/link-to-parent_202212050809",
        "stopwords" : "search/index/stopwords",
        "whordersugindex-1" : "search/index/index-1_202212050809",
        "whordersugindex-2" : "search/index/index-2_202212050809",
        "whordersugindex-3" : "search/index/index-3_202212050809",
        "htmlFileInfoList" : "search/index/htmlFileInfoList_202212050809",
        "englishfileinfo" : "../../../../en-us/whordersug/oxygen-webhelp/app/search/index/htmlFileInfoList_202212050809",
        "keywords" : "search/index/keywords_202212050809",
        // stemmers
        "stemmer" : "search/stemmers/stemmer",
        "en_stemmer" : "search/stemmers/en_stemmer",
        "de_stemmer" : "search/stemmers/de_stemmer",
        "fr_stemmer" : "search/stemmers/fr_stemmer",
        // options
        "options" : "options/options",
        "properties" : "options/properties",
        // utilities
        "util" : "util/util",
        "parseuri" : "util/parseuri",
        // i18n
        "localization" : "localization/localization",
        "strings" : "localization/strings",
        // jquery-private
        "jquery-private" : "jquery-private/jquery-private",
        "jquery.highlight.amd" : "jquery-private/jquery.highlight.amd",
        "jquery.bootpag.amd" : "jquery-private/jquery.bootpag.amd",
        "jquery.rwdImageMaps.amd" : "jquery-private/jquery.rwdImageMaps.amd",
        /********************************************************
         **************** 3rd Party Libraries *******************
         ********************************************************/

        // JQuery
        "jquery" : "../lib/jquery/jquery-3.5.1.min",
        // JQuery UI
        "jquery.ui" : "../lib/jquery-ui/jquery-ui.min",
        // JQuery Highlight
        "jquery.highlight" : "../lib/jquery-highlight/jquery.highlight-3",
        // JQuery Image maps highlighter
        "jquery.maphilight" : "../lib/maphighlight/jquery.maphilight.min",
        // JQuery Responsive image maps
        "jquery.rwdImageMaps" : "../lib/rwdImageMaps/jquery.rwdImageMaps.min",
        // JQuery Bootpag
        "jquery.bootpag" : "../lib/jquery-bootpag/jquery.bootpag.min",
        // Popper
        "bootstrap" : "../lib/bootstrap/js/bootstrap.bundle.min",

        "kuromoji" : "../lib/kuromoji/kuromoji"
    };

    var shimConfig = {
        // Responsive image maps
        "jquery.rwdImageMaps" : {
            deps: ["jquery"],
            exports : "jQuery.fn.rwdImageMaps"
        },
        // JQuery Highlight
        "jquery.highlight" : {
            deps: ["jquery"],
            exports : "jQuery.fn.highlight"
        },
        // JQuery Bootpag
        "jquery.bootpag" : {
            deps: ["jquery"],
            exports : "jQuery.fn.bootpag"
        }	
    };

    requirejs.config({
		waitSeconds: 500,
        paths : modulePaths,
        shim : shimConfig,
        map: {
            // @see http://requirejs.org/docs/jquery.html#noconflictmap

            // '*' means all modules will get 'jquery-private'
            // for their 'jquery' dependency.
            "*": {
                     "jquery": "jquery-private",
                     "jquery.rwdImageMaps" : "jquery.rwdImageMaps.amd",
                     "jquery.highlight" : "jquery.highlight.amd",
                     "jquery.bootpag" : "jquery.bootpag.amd"
            },

            // 'jquery-private' wants the real jQuery module
            // though. If this line was not here, there would
            // be an unresolvable cyclic dependency.
            "jquery-private": { "jquery": "jquery" },
            "jquery.rwdImageMaps.amd" : {"jquery.rwdImageMaps" : "jquery.rwdImageMaps"},
            "jquery.highlight.amd" : {"jquery.highlight" : "jquery.highlight"},
            "jquery.bootpag.amd" : {"jquery.bootpag" : "jquery.bootpag"}

        }
    });
});
