define({"title":"Infor PLM for Discrete Autodesk Inventor User Guide","topics":[{"title":"About this guide","href":"dtr1649309683154.html","outputclass":"preface","attributes":{"data-file":"dtr1649309683154.html","data-id":"dtr1649309683154"},"menu":{"hasChildren":false},"tocID":"dtr1649309683154-d49e53","topics":[]},{"title":"Introduction","shortdesc":"<p class=\"shortdesc\">This section introduces the <cite class=\"cite\">Autodesk Inventor - PLM integration<\/cite>.<\/p>","href":"ydz1649150421431.html","attributes":{"data-file":"ydz1649150421431.html","data-id":"ydz1649150421431"},"menu":{"hasChildren":true},"tocID":"ydz1649150421431-d49e76","next":"ydz1649150421431-d49e76"},{"title":"Getting Started","shortdesc":"<p class=\"shortdesc\">This section contains the following topics:<\/p>","href":"moy1649151107607.html","attributes":{"data-file":"moy1649151107607.html","data-id":"moy1649151107607"},"menu":{"hasChildren":true},"tocID":"moy1649151107607-d49e108","next":"moy1649151107607-d49e108"},{"title":"Working with PLM","shortdesc":"<p class=\"shortdesc\">This section contains the following topics that describes the tasks to be executed while       working with PLM:<\/p>","href":"cec1649152813421.html","attributes":{"data-file":"cec1649152813421.html","data-id":"cec1649152813421"},"menu":{"hasChildren":true},"tocID":"cec1649152813421-d49e180","next":"cec1649152813421-d49e180"},{"title":"Save Files to PLM","shortdesc":"<p class=\"shortdesc\">The Save to PLM process saves your Autodesk Inventor file in the PLM database. The       document is saved with the status Draft. Each consecutive save updates the latest changes       performed on the Draft revision of the document in PLM.<\/p>","href":"med1649155007314.html","attributes":{"data-file":"med1649155007314.html","data-id":"med1649155007314"},"menu":{"hasChildren":true},"tocID":"med1649155007314-d49e223","next":"med1649155007314-d49e223"},{"title":"Retrieving Files from PLM","shortdesc":"<p class=\"shortdesc\">The download manager retrieves the latest files from the PLM database and saves them to       the local work directory of the user. The following preferences control the behaviour of the       Download Manager:<\/p>","href":"skp1649155892463.html","attributes":{"data-file":"skp1649155892463.html","data-id":"skp1649155892463"},"menu":{"hasChildren":true},"tocID":"skp1649155892463-d49e280","next":"skp1649155892463-d49e280"},{"title":"Link to item","shortdesc":"<p class=\"shortdesc\">If the preferences specify that no items must be generated for part files on initial save       to PLM, you must use the Link to Item option from the PLM menu to create items for the part       file that you are working on, or to link the part file to an existing item in the PLM       database.<\/p>","href":"flx1649158291610.html","attributes":{"data-file":"flx1649158291610.html","data-id":"flx1649158291610"},"menu":{"hasChildren":false},"tocID":"flx1649158291610-d49e312","topics":[]},{"title":"Link to Document","shortdesc":"<p class=\"shortdesc\">To link existing document:<\/p>","href":"qjz1649158926893.html","attributes":{"data-file":"qjz1649158926893.html","data-id":"qjz1649158926893"},"menu":{"hasChildren":false},"tocID":"qjz1649158926893-d49e327","topics":[]},{"title":"Saving and Unlocking Files","shortdesc":"<p class=\"shortdesc\">If a file that you are working on is supposed to be used in a business process, the       business process cannot be launched while the file is locked. To avoid this situation, you       should save such files using the <span class=\"keyword cmdname\">Save and Unlock<\/span> command. This       automatically updates your data, while relinquishing ownership of the file. The business       process can then proceed.<\/p>","href":"jhv1649159187918.html","attributes":{"data-file":"jhv1649159187918.html","data-id":"jhv1649159187918"},"menu":{"hasChildren":false},"tocID":"jhv1649159187918-d49e342","topics":[]},{"title":"Checking-in a File","shortdesc":"<p class=\"shortdesc\">When you have finished working with a file, it can be released. The PLM - Autodesk       Inventor Integration enables you to check in any Autodesk Inventor file and its linked       documents to the PLM vault.<\/p>","href":"auz1649159576610.html","attributes":{"data-file":"auz1649159576610.html","data-id":"auz1649159576610"},"menu":{"hasChildren":true},"tocID":"auz1649159576610-d49e361","next":"auz1649159576610-d49e361"},{"title":"Checking out a file","shortdesc":"<p class=\"shortdesc\">You must check a file out of the vault in order to change it. The <span class=\"ph uicontrol field\">Check Out<\/span> option is available after the file has been       retrieved from PLM using the <span class=\"ph uicontrol field\">PLM Integration Query<\/span>       tool.<\/p>","href":"pzg1649160312696.html","attributes":{"data-file":"pzg1649160312696.html","data-id":"pzg1649160312696"},"menu":{"hasChildren":true},"tocID":"pzg1649160312696-d49e390","next":"pzg1649160312696-d49e390"},{"title":"Ownership","href":"aqd1649237071413.html","attributes":{"data-file":"aqd1649237071413.html","data-id":"aqd1649237071413"},"menu":{"hasChildren":true},"tocID":"aqd1649237071413-d49e425","next":"aqd1649237071413-d49e425"},{"title":"Viewing PLM Data","href":"wrv1649238008611.html","attributes":{"data-file":"wrv1649238008611.html","data-id":"wrv1649238008611"},"menu":{"hasChildren":true},"tocID":"wrv1649238008611-d49e451","next":"wrv1649238008611-d49e451"},{"title":"Opening a File in PLM Structure","href":"fcc1649238686265.html","attributes":{"data-file":"fcc1649238686265.html","data-id":"fcc1649238686265"},"menu":{"hasChildren":false},"tocID":"fcc1649238686265-d49e477","topics":[]},{"title":"Batch Save Process","href":"xif1649238942529.html","attributes":{"data-file":"xif1649238942529.html","data-id":"xif1649238942529"},"menu":{"hasChildren":true},"tocID":"xif1649238942529-d49e489","next":"xif1649238942529-d49e489"},{"title":"Using Infocards","href":"iaq1649240022735.html","attributes":{"data-file":"iaq1649240022735.html","data-id":"iaq1649240022735"},"menu":{"hasChildren":false},"tocID":"iaq1649240022735-d49e527","topics":[]},{"title":"Synchronize PLM Info","shortdesc":"<p class=\"shortdesc\">You can synchronize a working PLM file with Autodesk Inventor.<\/p>","href":"and1649240299805.html","attributes":{"data-file":"and1649240299805.html","data-id":"and1649240299805"},"menu":{"hasChildren":true},"tocID":"and1649240299805-d49e539","next":"and1649240299805-d49e539"},{"title":"Clear Storage Information","shortdesc":"<p class=\"shortdesc\">The <span class=\"ph uicontrol field\">Clear Storage Information<\/span> functionality is       designed to enable the user to quickly save the active\/selected part to a new       project.<\/p>","href":"abe1649241279977.html","attributes":{"data-file":"abe1649241279977.html","data-id":"abe1649241279977"},"menu":{"hasChildren":false},"tocID":"abe1649241279977-d49e568","topics":[]},{"title":"Deleting Local Files","shortdesc":"<p class=\"shortdesc\">Use the PLM menu option <span class=\"ph uicontrol field\">Delete Local Files<\/span> to       delete the selected local files. PLM also clears the information about the deleted files from       the storage files.<\/p>","href":"vvi1649241370190.html","attributes":{"data-file":"vvi1649241370190.html","data-id":"vvi1649241370190"},"menu":{"hasChildren":false},"tocID":"vvi1649241370190-d49e586","topics":[]},{"title":"Capturing and Saving Design Variants","href":"ddu1649241606899.html","attributes":{"data-file":"ddu1649241606899.html","data-id":"ddu1649241606899"},"menu":{"hasChildren":true},"tocID":"ddu1649241606899-d49e604","next":"ddu1649241606899-d49e604"},{"title":"Dispatch to business process","href":"kcp1649244308337.html","attributes":{"data-file":"kcp1649244308337.html","data-id":"kcp1649244308337"},"menu":{"hasChildren":true},"tocID":"kcp1649244308337-d49e691","next":"kcp1649244308337-d49e691"},{"title":"Save Modified Files Only","shortdesc":"<p class=\"shortdesc\">Generally, the Save to PLM process performs the operation on all the editable files       within the structure of current file and transfers all these editable files to PLM. However,       it is possible that one or more files within the structure of the current file are unchanged       even though they are editable; therefore, it is not required to save them into PLM. To save       only the modified files, enable the <span class=\"ph uicontrol field\">Save only modified         files<\/span> integration preference. The <span class=\"ph uicontrol field\">Save only         modified files<\/span> preference is made available in the <span class=\"ph uicontrol field\">Save Changes to PLM<\/span> property.<\/p>","href":"wga1649309970720.html","attributes":{"data-file":"wga1649309970720.html","data-id":"wga1649309970720"},"menu":{"hasChildren":true},"tocID":"wga1649309970720-d49e754","next":"wga1649309970720-d49e754"},{"title":"General mapping","shortdesc":"<p class=\"shortdesc\">General mapping enables you to define attribute-based mapping rules for a template. When       you create parts, assemblies, or drawings in Autodesk Inventor using a template, the mapping       rules are carried over to the parts, assemblies, or drawings based on how you set up the       rules.<\/p>","href":"qvk1649311006622.html","attributes":{"data-file":"qvk1649311006622.html","data-id":"qvk1649311006622"},"menu":{"hasChildren":true},"tocID":"qvk1649311006622-d49e795","next":"qvk1649311006622-d49e795"},{"title":"Neutral Files","shortdesc":"<p class=\"shortdesc\">Use this option to specify an additional format to save the local Autodesk Inventor files       to PLM. As a result, if you save a part file to PLM, the part file is also saved in the       additional format. The additional file is used for viewing.<\/p>","href":"djr1649314214963.html","attributes":{"data-file":"djr1649314214963.html","data-id":"djr1649314214963"},"menu":{"hasChildren":false},"tocID":"djr1649314214963-d49e941","topics":[]},{"title":"Presentation Files","shortdesc":"<p class=\"shortdesc\">Presentation files provide a multi-dimensional view of an assembly. You can use the       presentation files to develop exploded view, animations, and other stylized views of an       assembly to help \"document\" your design; where as a drawing, provides only a static view of       the assembly. Presentation views are saved in a separate file called a presentation file       (.ipn). Each presentation file can contain as many presentation views as needed for a       specified assembly. When changes are made to an assembly, the presentation views are updated       automatically. A presentation can contain only a single assembly.<\/p>","href":"pnw1649314423574.html","attributes":{"data-file":"pnw1649314423574.html","data-id":"pnw1649314423574"},"menu":{"hasChildren":false},"tocID":"pnw1649314423574-d49e956","topics":[]},{"title":"Thumbnails","shortdesc":"<p class=\"shortdesc\">Thumbnail is a miniature representation of a Autodesk Inventor part, assembly or a       drawing. Autodesk Inventor integration generates the thumbnails in the JPEG or PNG       format.<\/p>","href":"sbo1649320719731.html","attributes":{"data-file":"sbo1649320719731.html","data-id":"sbo1649320719731"},"menu":{"hasChildren":true},"tocID":"sbo1649320719731-d49e971","next":"sbo1649320719731-d49e971"},{"title":"Balloon Mapping","shortdesc":"<p class=\"shortdesc\">You can now transfer balloon numbers from Autodesk Inventor to the part list table in       PLM. This information can be stored to any field of the Part List table, in addition to the         <span class=\"ph uicontrol field\">Find No.<\/span> field.<\/p>","href":"pte1649327311495.html","attributes":{"data-file":"pte1649327311495.html","data-id":"pte1649327311495"},"menu":{"hasChildren":true},"tocID":"pte1649327311495-d49e1053","next":"pte1649327311495-d49e1053"},{"title":"Content Center","shortdesc":"<p class=\"shortdesc\">Content center files are standard library components generated from the content center       database.<\/p>","href":"kac1649327935637.html","attributes":{"data-file":"kac1649327935637.html","data-id":"kac1649327935637"},"menu":{"hasChildren":true},"tocID":"kac1649327935637-d49e1086","next":"kac1649327935637-d49e1086"},{"title":"Derived Components","shortdesc":"<p class=\"shortdesc\">Derived parts are new parts that use an existing part or assembly as their base       component.<\/p>","href":"hca1649391361207.html","attributes":{"data-file":"hca1649391361207.html","data-id":"hca1649391361207"},"menu":{"hasChildren":true},"tocID":"hca1649391361207-d49e1143","next":"hca1649391361207-d49e1143"},{"title":"Tools and Utilities","shortdesc":"<p class=\"shortdesc\">The PLM Integration for Inventor includes a utility that enables you to convert RELEASED       Inventor files from previous Inventor versions to the current version of Inventor.<\/p>","href":"lva1649393167205.html","attributes":{"data-file":"lva1649393167205.html","data-id":"lva1649393167205"},"menu":{"hasChildren":true},"tocID":"lva1649393167205-d49e1219","next":"lva1649393167205-d49e1219"},{"title":"Package Assemblies","shortdesc":"<p class=\"shortdesc\">The Package Assembly feature is to allow a completely new assembly or drawing to be       represented in PLM as a single object. This feature can be applied to new files which have       never been stored in PLM database or files that are already flagged as package.<\/p>","href":"dze1649397250117.html","attributes":{"data-file":"dze1649397250117.html","data-id":"dze1649397250117"},"menu":{"hasChildren":true},"tocID":"dze1649397250117-d49e1298","next":"dze1649397250117-d49e1298"},{"title":"iAssemblies","shortdesc":"<p class=\"shortdesc\">An iAssembly is a collection of various members and individual parts.<\/p>","href":"agz1649406012617.html","attributes":{"data-file":"agz1649406012617.html","data-id":"agz1649406012617"},"menu":{"hasChildren":false},"tocID":"agz1649406012617-d49e1349","topics":[]},{"title":"Setting preferences","shortdesc":"<p class=\"shortdesc\">The PLM preferences control the way the PLM integration for Autodesk Inventor works. To       access the PLM preferences, in Autodesk Inventor, click <span class=\"ph uicontrol button\">Open         PLM Inventor Integration Preferences<\/span> in the PLM toolbar. As a result, the PLM       Integration Preferences dialog box appears.<\/p>","href":"qop1649406580467.html","attributes":{"data-file":"qop1649406580467.html","data-id":"qop1649406580467"},"menu":{"hasChildren":true},"tocID":"qop1649406580467-d49e1364","next":"qop1649406580467-d49e1364"},{"title":"The properties of the Toolkit tab","shortdesc":"<p class=\"shortdesc\">This option includes the following properties:<\/p>","href":"wiy1649651161445.html","attributes":{"data-file":"wiy1649651161445.html","data-id":"wiy1649651161445"},"menu":{"hasChildren":true},"tocID":"wiy1649651161445-d49e1532","next":"wiy1649651161445-d49e1532"},{"title":"Setup and administration","shortdesc":"<p class=\"shortdesc\">This section contains the following topics for the administrator:<\/p>","href":"nps1649651704269.html","attributes":{"data-file":"nps1649651704269.html","data-id":"nps1649651704269"},"menu":{"hasChildren":true},"tocID":"nps1649651704269-d49e1558","next":"nps1649651704269-d49e1558"},{"title":"Working with the PLM Integration for Autodesk Inventor – Best practices","shortdesc":"<p class=\"shortdesc\">The following section lists the best practices in PLM:<\/p>","href":"rzh1649652271337.html","attributes":{"data-file":"rzh1649652271337.html","data-id":"rzh1649652271337"},"menu":{"hasChildren":true},"tocID":"rzh1649652271337-d49e1587","next":"rzh1649652271337-d49e1587"}]});