define({"title":"Infor PLM for Discrete AutoCAD User Guide","topics":[{"title":"About this guide","href":"gft1649821757564.html","outputclass":"preface","attributes":{"data-file":"gft1649821757564.html","data-id":"gft1649821757564"},"menu":{"hasChildren":false},"tocID":"gft1649821757564-d49e53","topics":[]},{"title":"Introduction","shortdesc":"<p class=\"shortdesc\">PLM interfaces directly with AutoCAD, facilitating direct transfer of product designs       from the AutoCAD environment into PLM and then ERP. This eliminates the inherent risks and       errors associated with data entry from multiple sources. AutoCAD files can be managed       according to configuration management methodology, while facilitating the direct transfer of       complete design Bills of Material (BOMs) to the production environment.<\/p>","href":"puy1649821925934.html","attributes":{"data-file":"puy1649821925934.html","data-id":"puy1649821925934"},"menu":{"hasChildren":true},"tocID":"puy1649821925934-d49e76","next":"puy1649821925934-d49e76"},{"title":"Getting started","shortdesc":"<p class=\"shortdesc\">The following topics are available to help you getting started with the Infor PLM       Discrete integration for AutoCAD:<\/p>","href":"mps1649822686949.html","attributes":{"data-file":"mps1649822686949.html","data-id":"mps1649822686949"},"menu":{"hasChildren":true},"tocID":"mps1649822686949-d49e105","next":"mps1649822686949-d49e105"},{"title":"Working with PLM","shortdesc":"<p class=\"shortdesc\">This section contains the following topics that describes the tasks to be executed while       working with PLM:<\/p>","href":"fec1649827015828.html","attributes":{"data-file":"fec1649827015828.html","data-id":"fec1649827015828"},"menu":{"hasChildren":true},"tocID":"fec1649827015828-d49e160","next":"fec1649827015828-d49e160"},{"title":"Saving Files to PLM","shortdesc":"<p class=\"shortdesc\">The Save to PLM process saves your AutoCAD file in the PLM database. The document is       saved with the status <kbd class=\"ph userinput\">draft<\/kbd>. Each consecutive save updates the latest       changes performed on the <kbd class=\"ph userinput\">draft<\/kbd> revision of the document in       PLM.<\/p>","href":"uav1649830254129.html","attributes":{"data-file":"uav1649830254129.html","data-id":"uav1649830254129"},"menu":{"hasChildren":true},"tocID":"uav1649830254129-d49e203","next":"uav1649830254129-d49e203"},{"title":"Retrieving Files from PLM","shortdesc":"<p class=\"shortdesc\">The download manager retrieves the latest files from the PLM database and saves them to       the local work directory of the user. The following PLM preferences controls the functions of       download manager:<\/p>","href":"pce1649832087899.html","attributes":{"data-file":"pce1649832087899.html","data-id":"pce1649832087899"},"menu":{"hasChildren":true},"tocID":"pce1649832087899-d49e266","next":"pce1649832087899-d49e266"},{"title":"Saving and Unlocking Files","shortdesc":"<p class=\"shortdesc\">If a file that you are working on is supposed to be used in a business process, the       business process cannot be launched while the file is locked. To avoid this situation, you       should save such files using the <span class=\"keyword cmdname\">Save and Unlock<\/span> command. This       automatically updates your data, while relinquishing ownership of the file. The business       process can then proceed.<\/p>","href":"pcv1649840545038.html","attributes":{"data-file":"pcv1649840545038.html","data-id":"pcv1649840545038"},"menu":{"hasChildren":false},"tocID":"pcv1649840545038-d49e338","topics":[]},{"title":"Checking in a File","shortdesc":"<p class=\"shortdesc\">When you have finished working with a file, it can be released. The PLM integration for       AutoCAD enables you to check in any AutoCAD file and its linked documents to the PLM       vault.<\/p>","href":"tdy1649841469187.html","attributes":{"data-file":"tdy1649841469187.html","data-id":"tdy1649841469187"},"menu":{"hasChildren":false},"tocID":"tdy1649841469187-d49e356","topics":[]},{"title":"Checking out a File","shortdesc":"<p class=\"shortdesc\">You must check a file out of the vault in order to change it. The <span class=\"ph uicontrol field\">Check Out<\/span> option is available after the file has been       retrieved from PLM using the Download files from PLM menu option.<\/p>","href":"sln1649841965337.html","attributes":{"data-file":"sln1649841965337.html","data-id":"sln1649841965337"},"menu":{"hasChildren":false},"tocID":"sln1649841965337-d49e371","topics":[]},{"title":"Viewing PLM Data","href":"wvz1649842531771.html","attributes":{"data-file":"wvz1649842531771.html","data-id":"wvz1649842531771"},"menu":{"hasChildren":false},"tocID":"wvz1649842531771-d49e390","topics":[]},{"title":"Thumbnails","shortdesc":"<p class=\"shortdesc\">Thumbnail is a miniature representation of a AutoCAD file. <\/p>","href":"sly1649842984953.html","attributes":{"data-file":"sly1649842984953.html","data-id":"sly1649842984953"},"menu":{"hasChildren":true},"tocID":"sly1649842984953-d49e402","next":"sly1649842984953-d49e402"},{"title":"Ownership","shortdesc":"<p class=\"shortdesc\">The owner of a file is determined by one of the following:<\/p>","href":"nhu1649906785246.html","attributes":{"data-file":"nhu1649906785246.html","data-id":"nhu1649906785246"},"menu":{"hasChildren":true},"tocID":"nhu1649906785246-d49e506","next":"nhu1649906785246-d49e506"},{"title":"Opening File in a PLM ","href":"vua1649910359310.html","attributes":{"data-file":"vua1649910359310.html","data-id":"vua1649910359310"},"menu":{"hasChildren":false},"tocID":"vua1649910359310-d49e535","topics":[]},{"title":"Using Infocards","href":"hoa1649910745361.html","attributes":{"data-file":"hoa1649910745361.html","data-id":"hoa1649910745361"},"menu":{"hasChildren":false},"tocID":"hoa1649910745361-d49e547","topics":[]},{"title":"Synchronize Headers","shortdesc":"<p class=\"shortdesc\">Header information is the PLM data that is stored in your local environment. This       information is used by the PLM Integration for AutoCAD to verify whether a specific local file       can safely overwrite the PLM file. The Synchronize Headers operation updates the headers of       the AutoCAD files currently opened with the relevant PLM information.<\/p>","href":"fmj1649911004784.html","attributes":{"data-file":"fmj1649911004784.html","data-id":"fmj1649911004784"},"menu":{"hasChildren":false},"tocID":"fmj1649911004784-d49e559","topics":[]},{"title":"Clean Storage Information","shortdesc":"<p class=\"shortdesc\">Clears the storage information for the active\/selected file and its dependents. <\/p>","href":"esh1649911717620.html","attributes":{"data-file":"esh1649911717620.html","data-id":"esh1649911717620"},"menu":{"hasChildren":false},"tocID":"esh1649911717620-d49e575","topics":[]},{"title":"Deleting Local Files","shortdesc":"<p class=\"shortdesc\">Use the PLM menu option <span class=\"ph uicontrol field\">Delete Local Files<\/span> to       delete the selected local files. PLM integration also clears the information about the deleted       files from the local storage files.<\/p>","href":"pfz1649911873178.html","attributes":{"data-file":"pfz1649911873178.html","data-id":"pfz1649911873178"},"menu":{"hasChildren":false},"tocID":"pfz1649911873178-d49e590","topics":[]},{"title":"Refresh Files from PLM","shortdesc":"<p class=\"shortdesc\">You can click <span class=\"ph uicontrol button\">Refresh files from PLM<\/span> (<img class=\"image\" src=\"teh1649912337851.png\"\/>) to update the currently open files from       Infor PLM.<\/p>","href":"qzx1649912117326.html","attributes":{"data-file":"qzx1649912117326.html","data-id":"qzx1649912117326"},"menu":{"hasChildren":false},"tocID":"qzx1649912117326-d49e608","topics":[]},{"title":"Dispatch to Business Process","shortdesc":"<p class=\"shortdesc\">The <span class=\"ph uicontrol field\">Dispatch to Business Process<\/span> option on the       PLM menu enables you to link the PLM items and\/or documents, which are generated for a file,       to an PLM business process. This will link the PLM items and\/or documents of the part file to       a workflow, which will be distributed to the users associated to the workflow       template.<\/p>","href":"cdh1649912449704.html","attributes":{"data-file":"cdh1649912449704.html","data-id":"cdh1649912449704"},"menu":{"hasChildren":false},"tocID":"cdh1649912449704-d49e628","topics":[]},{"title":"Mapping Rules","shortdesc":"<p class=\"shortdesc\">We can use Mapping to transfer the values of Title-Block attribute tags from AutoCAD to       PLM and also can use to update the Title-Block attribute tags values based on values from       PLM.<\/p>","href":"xjd1649912783469.html","attributes":{"data-file":"xjd1649912783469.html","data-id":"xjd1649912783469"},"menu":{"hasChildren":true},"tocID":"xjd1649912783469-d49e646","next":"xjd1649912783469-d49e646"},{"title":"Title blocks","shortdesc":"<p class=\"shortdesc\">A collection of AutoCAD Title Blocks used for a particular design purpose is called a       Title Block Type. Integration provides features to Insert Title-Blocks and update the       Title-Block tags using mapping rules.<\/p>","href":"tix1649914723214.html","attributes":{"data-file":"tix1649914723214.html","data-id":"tix1649914723214"},"menu":{"hasChildren":true},"tocID":"tix1649914723214-d49e697","next":"tix1649914723214-d49e697"},{"title":"AutoCAD and Toolkit Preferences","shortdesc":"<p class=\"shortdesc\">The AutoCAD tab includes properties that control the behavior of the PLM integration for       AutoCAD. <\/p>","href":"plv1650271574963.html","attributes":{"data-file":"plv1650271574963.html","data-id":"plv1650271574963"},"menu":{"hasChildren":true},"tocID":"plv1650271574963-d49e724","next":"plv1650271574963-d49e724"},{"title":"Setup and administration","shortdesc":"<p class=\"shortdesc\">In addition to setting the preferences for individual users in the PLM - AutoCAD       Integration Preferences dialog box, the administrator must set up various data in order to       make the PLM integration for AutoCAD work in the preferred way.<\/p>","href":"xyq1650360233572.html","attributes":{"data-file":"xyq1650360233572.html","data-id":"xyq1650360233572"},"menu":{"hasChildren":true},"tocID":"xyq1650360233572-d49e1213","next":"xyq1650360233572-d49e1213"},{"title":"Troubleshooting","shortdesc":"<p class=\"shortdesc\">This topic lists error messages, support log files, and the most commonly encountered       issues.<\/p>","href":"nlx1650429944536.html","attributes":{"data-file":"nlx1650429944536.html","data-id":"nlx1650429944536"},"menu":{"hasChildren":true},"tocID":"nlx1650429944536-d49e1298","next":"nlx1650429944536-d49e1298"}]});