define(["require","sohoxi","varstore","titlemap","webhelp","search","nwSearchFnt","jquery"], function(require,sohoxi,varstore,titlemap, webhelp, search, nwSearchFnt, $){

// various js variables and functions for help system		
		
	var fromBack = false;
	errorpage = "helperror.html";
	wh = window.location;
	whUrl = wh.protocol + '//' + wh.host + wh.pathname;
	var scrollOffset = "";
	var currpage = -1;
	var collPdfFilename = "";
	
	//URL parameters
	var contentParam = "";
	var searchParam = "";
	var pageParam = "";
	var filterParam = "";
	var hlParam = "";
	var hashParam = "";
	var tocParam = "show";
	let shParam = "";
	let toolbarParam = false;
	
	//formerly in index.html
	var fromInputEnter = false;
	newwinName = "";
	winCounter = 0;		
	// window opener global variables
	var winopener = "";
	var extopener = "";
	// variables for module.js loading
	fullJsonLoading = false;	
	jsonfileContentsInit = {};
	jsonfileContents = [];
	jsonfileEnContentsInit = {};
	jsonfileEnContents = [];
	const JSONFILE = "module" + varstore.buildVersion + ".js";
	collSearchFilter = "";
	let landingTopicDocid = "";
	let landingTopicLibid = "";
		
	function addHistory(topic){
		// adds topics and search pages to history for use by back/forward buttons
		if (varstore.pagehistory[currpage] == topic) {
			return;
		}
		else {
			varstore.pagehistory.push(topic);
			currpage = currpage + 1;
			feedbackMail();
		}	
		if (currpage === 0) {
			$('.buttonset.back').addClass('disabled');
		}
		else if (currpage > 0) {
			$('.buttonset.back').removeClass('disabled');
		}
		if (currpage == varstore.pagehistory.length - 1) {
			$('.buttonset.forward').addClass('disabled');
		}
		else {
			$('.buttonset.forward').removeClass('disabled');
		}
	}
		
	function landing(iframeDoc,callback) {
		// called from main-init.js to set up cover page
		var defaultpage = "cover.html";	
		var dsearch2 = document.location.search + '',
		hashid2 = document.location.hash + '',
		helpcontent2 = getParam("helpcontent",dsearch2);
		var lcHelpcontent2 = helpcontent2.toLowerCase();
		if (lcHelpcontent2 == "" && hashid2 == "") {
			// not checking for search param since search is handled in main-init.js if search param exists
			var initoptions = getIsoLang($('html').attr('lang'));
			iframeDoc.src = defaultpage;
			$('#landing').off('load');
			$('#landing').on('load', function(){
				require(["sohoxi"], function (sohoxi) {
					$('#landing',window.document).contents().find('body').first().initialize(initoptions);
					feedbackMail();
					setFocusOnTopic(defaultpage);
				});
			});
			setTimeout(function () {
				$('.busy, .busy-indicator-container').addClass('is-hidden');
			}, 2000);
			addHistory("topic=" + defaultpage);
		}			
		callback();
	}
		
	function collectionHome(lcHelpcontent,hashid,searchParam,callback) {
		// called from coll-init.js to set up cover page
		var iframeDoc = window.document.getElementById("landing");
		var defaultpage = "landing.html"; // CHANGE TO A GLOBAL CONSTANT IN COLLECTION VARSTORE???
		if (lcHelpcontent == "" && hashid == "" && searchParam == "") {
			addHistory("topic=landing.html");
			iframeDoc.src = defaultpage;	
		}
		else if (searchParam !== "") {
			iframeDoc.src = "blank.html";
		}
		setTimeout(function () {
			$('.busy, .busy-indicator-container').addClass('is-hidden');
		}, 2000);
			
		// build array from module.js for later checking for cross-deliv link ids, if not
		// already built for regex context-sensitive search, plus need map folder array
		var fulljsfile = "module" + varstore.buildVersion + ".js";
		if (jsonfileContents.length == 0 && !fullJsonLoading) {
			fullJsonLoading = true;
			loadFullJSON(fulljsfile,function(response) {
				buildJSONArray(response, function(){
					fullJsonLoading = false;
					if (lcHelpcontent == "" && hashid == "" && searchParam == "") {
						//if not context-sensitive call or search call, init the cover page
						collLandingInit();
					}
			})});
		}
		callback();
	}
	
	function collLandingInit() {
		// set up link events for collection landing/cover page
		var initoptions = getIsoLang($('html').attr('lang'));
		var savehistory = varstore.pagehistory;
		require(["sohoxi"], function (sohoxi) {
			$('#landing',window.document).off('load.landing');
			let loadtest = false;
			$('#landing',window.document).on('load.landing', function(){
				loadtest = true;
				$('#landing',window.document).contents().find('body').first().initialize(initoptions);				
				$('#landing',window.document).contents().find(".wh_tile_title a, .wh_tile_shortdesc a").not('[data-file]').off('click touchend.landing');
				$('#landing',window.document).contents().find(".wh_tile_title a, .wh_tile_shortdesc a").not('[data-file]').on('touchend.landing', function(e) {
					handleTitleClick(e);
				}).on('click', function(e) {
					disableBrowserContextMenu(e);				
					handleTitleClick(e);				
				});
			
				$( window ).off('resize');
				$( window ).on('resize',function() {
					if ($('#landing',window.document).contents().find('.hslist.is-open').length) {
						repositionPopup();
					}
				});
				$('#landing',window.document).contents().find('html').off('keydown.popupmenu').on('keydown.popupmenu', function (e) {
				  var key = e.which;
				  //Close on escape
				  if (key === 27) {
					e.stopPropagation();
					handleLandingListLeave(e);
				  }
				  // space bar
				  if (key === 32) {
					 e.stopPropagation(); 
					 handleTitleClick(e);
				  }
				  // tab key on submenu in landing
				  if (key === 9) {
					if ($(e.target).next('.ul.popupmenu').length != 0) {
						handleLandingListEnter(e,key);
					}
					else if ($(e.target).next('.ul.popupmenu').length == 0 && $(e.target).prop('tagName') == "A") {
					  handleLandingListEnter(e,key);
					  
					}
				  }			  
				});
				$('#landing',window.document).contents().find('.hslist > li').off('mouseenter.popupmenu');
				$('#landing',window.document).contents().find('.hslist > li').on('mouseenter.popupmenu', function (e) {
					handleLandingListEnter(e,0);
				});
				$('#landing',window.document).contents().find('.hslist2 > li').off('mouseenter.popupmenu');
				$('#landing',window.document).contents().find('.hslist2 > li').on('mouseenter.popupmenu', function (e) {
					handleLandingListEnter(e,0);
				});
				$('#landing',window.document).contents().find('.hslist3 > li').off('mouseenter.popupmenu');
				$('#landing',window.document).contents().find('.hslist3 > li').on('mouseenter.popupmenu', function (e) {
					handleLandingListEnter(e,0);
				});
				$('#landing',window.document).contents().find('.hslist').off('mouseleave.popupmenu');
				$('#landing',window.document).contents().find('.hslist').on('mouseleave.popupmenu', function(e) {
					handleLandingListLeave(e);
				});	
				landingTopicDocid = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
				landingTopicLibid = $('#landing',window.document).contents().find('meta[name="INF.Lib.Docid"]').attr('content');
				if ($('html').hasClass('smarthelp')) {
					$('#landing',window.document).contents().find('body').first().addClass('smarthelp');
				}				
			});
			if (!loadtest) {
				// load failed, try reloading iframe
				$('#landing').attr('src', $('#landing').attr('src'));
			}
		});	
		
		setFocusOnTopic("landing.html");
		feedbackMail();
		varstore.pagehistory = savehistory;
	}
	function showCollectionTitle(){
		// Makes adjustments to search buttons and TOC if collection not focused on an individual map
		$('.titlebar .divider').css('display','');
		$('button.btn-icon.searchselect-button',window.document).css('cursor','default');
		$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
	}
	function buildJSONArray(response,callback) {
		// gets module.js content
		jsonfileContentsInit = JSON.parse(response);
		jsonfileContents.push(jsonfileContentsInit);
		callback();
	}
	function buildJsonEnArray(response,callback) {
		// gets module.js from an English collection/help system when needed in non-English collection/help systems
		jsonfileEnContentsInit = JSON.parse(response);
		jsonfileEnContents.push(jsonfileEnContentsInit);
		callback();
	}
	function displayEnglishTopic(topic,anchorid) {
		// displays an English topic inside a non-English collection/help system
		if (topic != "") {			
			// load the English help topic
			if (topic.indexOf(".html") == -1 && topic.indexOf(".htm") != -1) {
				topic = topic.replace(".htm",".html");
			}
			var startroot = window.document.getElementsByTagName('HTML');
			var starturl = startroot[0].parentNode.documentURI;
			var whpath = starturl;
			if (whpath.indexOf("?") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("?"));
			}
			if (whpath.indexOf("#") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("#"));
			}
			whpath = whpath.substring(0,whpath.lastIndexOf("/")+1);
			whpath = whpath.replace(getIsoLang($('html').attr('lang')).toLowerCase(),"en-us");
			iframeDoc.src = whpath + topic;
			var initoptions = getIsoLang($('html').attr('lang'));
			$('#landing').off('load');
			$('#landing').on('load', function(){
				require(["sohoxi","deliverableCollectionModule"], function (sohoxi,deliverableCollectionModule) {
					deliverableCollectionModule.enableCrossDeliverableLinks();			
					$('#landing',window.document).contents().find('body').first().initialize(initoptions);
					addHistory("topic=" + whpath + topic);
					feedbackMail();
					hideAllSearch(true);
				});
			});
			// NEED TO DO ADDHISTORY HERE AND SEE IF THAT FUNCTION SUPPORTS CALLS TO ENGLISH
			// MIGHT NEED TO ADD A SCROLLTO IF ANCHORID EXISTS
			setTimeout(function () {
				$('.busy, .busy-indicator-container').addClass('is-hidden');
			}, 2000);
		}
		else {
			// no English topic found to display in non-English system
			showErrorPage();			
		}			
	}
	function checkEnglishTopicLink(topic) {
		// calls checkTopic for an English topic in a non-English system
		// sets fallback to false
		varstore.fallback = false;
		var highlight = "";
		checkTopic(topic,highlight,function(){
		});
	}
	
	function checkEnglishNonHtmlLink(topic,showinframe) {
		var startroot = window.document.getElementsByTagName('HTML');
		var whpath = startroot[0].parentNode.documentURI;
		var url = topic;
		if (showinframe) {
			if (UrlExists(url)) {
				// file exists in base system, either English or non-English
				goTopic(topic,false,true);
			}
			else {
				// file does not exist in base non-English system, try base English
				var currLang = getIsoLang($('html').attr('lang')).toLowerCase();
				url = url.replace(currLang,"en-us");
				if (UrlExists(url)) {
					extopener = window.open(url);
					extopener.opener = null;
					return;	
				}
				else {
					var iframeDoc = window.document.getElementById("landing");
					showErrorPage();
				}
			}			
		}
		else if (showinframe == false || showinframe == undefined) {
			if (UrlExists(url)) {
				// file exists in base system, either English or non-English
				goTopic(topic,false);
			}
			else {
				// file does not exist in base non-English system, try base English
				var currLang = getIsoLang($('html').attr('lang')).toLowerCase();
				url = url.replace(currLang,"en-us");
				if (UrlExists(url)) {
					extopener = window.open(url);
					extopener.opener = null;
					return;	
				}
				else {
					showErrorPage();
				}
			}			
		}
	}
	function checkTopic(lcHelpcontent, highlight, callback) {
		// to get basic filename to use in search through module.js
		let helpcontentbase = lcHelpcontent.substring(0,lcHelpcontent.indexOf(".htm"));
		// to handle duplicate topics (where file name ends in -2, -3, etc)
		let duplicateValue = "";
		// to save off anchor value in URLs containing #... after file name
		let anchorid = "";
		// adjust helpcontentbase if duplicate, plus save off duplicate value for later use
		if (helpcontentbase.indexOf("-") != -1) {
			let baselength = helpcontentbase.length;
			let filesuffix = helpcontentbase.substring(helpcontentbase.lastIndexOf("-") + 1);
			if (!isNaN(filesuffix) && (helpcontentbase.lastIndexOf("-") == baselength - 2 || helpcontentbase.lastIndexOf("-") == baselength - 3)) {
				duplicateValue = helpcontentbase.substring(helpcontentbase.lastIndexOf("-"));
				helpcontentbase = helpcontentbase.substring(0,helpcontentbase.lastIndexOf("-"));				
			}
		}		
		// for URLs that contain #... for a link to section within a topic
		if (lcHelpcontent.indexOf("#") != -1) {
			anchorid = lcHelpcontent.substring(lcHelpcontent.indexOf("#"));
		}
		if (varstore.fallback && lcHelpcontent != "") {
			// if fallback scenario and we have a topic, then display it
			displayEnglishTopic(lcHelpcontent,anchorid);
		}
		else if (jsonfileContents.length == 0 && !varstore.fallback) {
			// module.js not loaded, load it now
			fullJsonLoading = true;
			loadFullJSON(JSONFILE,function(response) {
				buildJSONArray(response, function(){
					fullJsonLoading = false;
					var topicList = search4helpcontent(helpcontentbase);
					if (topicList == "" && lcHelpcontent.indexOf("cover.html") == -1 && lcHelpcontent.indexOf("landing.html") == -1){
						// for fallback
						if (getIsoLang($('html').attr('lang')).toLowerCase() == "en-us") {
							//no topic found for English help, just go to helperror.html
							showErrorPage();
						}
						else {
							//current help is non-English, check if topic is in English
							getBuildVersion(function(whroot,buildversion) {
								getEnglishModuleJsPath(whroot,buildversion,function(jsonfile) {
									loadFullJSON(jsonfile,function(response) {
										buildJsonEnArray(response, function(){
											varstore.fallback = true;
											topicList = search4helpcontent(helpcontentbase);
											if (topicList == "") {
												//topic not found in English either
												showErrorPage();					
											}
											else {
												// launch the English help
												displayEnglishTopic(topicList,anchorid);
											}
										});
									});										
								});
							});																				
						}
					}
					else if (lcHelpcontent.indexOf("cover.html") == -1 && ((lcHelpcontent.indexOf("landing.html") == -1 && varstore.isCollection) || !varstore.isCollection)){
						// not a case of cover.html in standalone or collection, and not a landing.html in a collection, just a topic. (This allows rare possibility that writer created a landing.html in a standalone help system)
						if (topicList.indexOf(".html") == -1 && topicList.indexOf(".htm") != -1) {
							topicList = topicList.replace(".htm",".html");
						}
						if (duplicateValue !== "") {
							topicList = topicList.substring(0,topicList.indexOf(".html")) + duplicateValue + ".html";
						}
						if (highlight !== null && highlight !== undefined && highlight !== "") {
							var hl = "?hl=" + highlight;
							topicList = topicList + anchorid + hl;
							goTopic(topicList, false);
						}
						else {
							goTopic(topicList + anchorid,false);
						}
											
					}
					else if (lcHelpcontent.indexOf("cover.html") != -1 || lcHelpcontent.indexOf("landing.html") != -1) {
						// special handling for cover.html and landing.html
						if (!varstore.isCollection) {
							if (lcHelpcontent == "cover.html") {
								// display cover page of standalone help system
								goTopic(lcHelpcontent,false);
							}
							else {
								// cover.html specified but more in path as well, which is invalid in standalone
								showErrorPage();
							}							
						}
						else {
							if (lcHelpcontent.indexOf("cover.html") != -1) {
								if (lcHelpcontent == "cover.html" || lcHelpcontent == "cover.htm") {
									// invalid request, user typed this URL, in collection cover.html must include map folder
									showErrorPage();								
								}
								else {
									// A map folder is present, so check it and, if valid, display topic and synch with TOC
									var mapfolder = getMapFolder(lcHelpcontent);
									if (mapfolder === "") {
										// map folder present but it wasn't valid
										showErrorPage();
									}
									else {
										goTopic(lcHelpcontent,false);
										var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').not('.collection-link').find("a[data-file*='" + mapfolder + "/cover.html']");
										synchToc(lcHelpcontent,collBookAnchor,function(){
											$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
											$('.accordion-header',window.document).not('.collection-group').find('a').each(function() {
												var coveranchor = $(this);
												if(coveranchor.attr('data-file') != undefined && coveranchor.attr('data-file').indexOf(lcHelpcontent) != -1) {
													coveranchor.parent('.accordion-header').removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
												}
											});
										});
									}
								}
							}
							else if (lcHelpcontent == "landing.html") {
								// display landing page of collection
								goTopic(lcHelpcontent,false);
								collLandingInit();
							}
							else if (lcHelpcontent.indexOf("landing.html") != -1 && lcHelpcontent != "landing.html") {
								// landing.html in URL, but also a mapfolder, which is invalid
								showErrorPage();
							}							
						}
					}
				});	
			});
		}
		else if (jsonfileContents.length != 0 && !varstore.fallback) {
			// module.js loaded, so try to get topic
			var topicList = search4helpcontent(helpcontentbase);
			if (topicList == "" && lcHelpcontent.indexOf("cover.html") == -1 && lcHelpcontent.indexOf("landing.html") == -1){
				// testing for fallback
				if (getIsoLang($('html').attr('lang')).toLowerCase() == "en-us") {
					//no topic found for English help, just go to helperror.html					
					showErrorPage();					
				}
				else if (!varstore.fallback) {
					//current help is non-English, check if topic is in English
					getBuildVersion(function(whroot,buildversion) {
						getEnglishModuleJsPath(whroot,buildversion,function(jsonfile) {
							loadFullJSON(jsonfile,function(response) {
								buildJsonEnArray(response, function(){
									varstore.fallback = true;
									topicList = search4helpcontent(helpcontentbase);
									if (topicList == "") {
										//topic not found in English either
										showErrorPage();					
									}
									else {
										// launch the English help
										displayEnglishTopic(topicList,anchorid);				
									}
								});
							});							
						});
					});														
				}
			}
			else if (lcHelpcontent.indexOf("cover.html") == -1 && ((lcHelpcontent.indexOf("landing.html") == -1 && varstore.isCollection) || !varstore.isCollection)){
			// not a case of cover.html in standalone or collection, and not a landing.html in a collection, just a topic. (This allows rare possibility that writer created a landing.html in a standalone help system)
				if (topicList.indexOf(".html") == -1 && topicList.indexOf(".htm") != -1) {
					topicList = topicList.replace(".htm",".html");
				}
				if (duplicateValue !== "") {
					topiclist = topiclist.substring(0,topiclist.indexOf(".html")) + duplicateValue + ".html";
				}	
				goTopic(topicList + anchorid,false);				
			}
			else if (lcHelpcontent.indexOf("cover.html") != -1 || lcHelpcontent.indexOf("landing.html") != -1) {
				// special handling for cover.html and landing.html
				if (!varstore.isCollection) {
					if (lcHelpcontent == "cover.html") {
						// display cover page of standalone help system
						goTopic(lcHelpcontent,false);
					}
					else {
						// cover.html specified but more in path as well, which is invalid in standalone
						showErrorPage();
					}							
				}
				else {
					if (lcHelpcontent.indexOf("cover.html") != -1) {
						if (lcHelpcontent == "cover.html" || lcHelpcontent == "cover.htm") {
							// invalid request, user typed this URL, in collection cover.html must include map folder
							showErrorPage();								
						}
						else {
							// A map folder is present, so check it and, if valid, display topic and synch with TOC
							var mapfolder = getMapFolder(lcHelpcontent);
							if (mapfolder === "") {
								// map folder present but it wasn't valid
								showErrorPage();
							}
							else {
								goTopic(lcHelpcontent,false);
								var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').find("a[data-file*='" + mapfolder + "/cover.html']");
								synchToc(lcHelpcontent,collBookAnchor,function(){
									$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
									$('.accordion-header',window.document).not('.collection-group').find('a').each(function() {
										var coveranchor = $(this);
										if(coveranchor.attr('data-file') != undefined && coveranchor.attr('data-file').indexOf(lcHelpcontent) != -1) {
											coveranchor.parent('.accordion-header').removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
										}
									});
								});
							}
						}
					}
					else if (lcHelpcontent == "landing.html") {
						// display landing page of collection
						goTopic(lcHelpcontent,false);
					}
					else if (lcHelpcontent.indexOf("landing.html") != -1 && lcHelpcontent != "landing.html") {
						// landing.html in URL, but also a mapfolder, which is invalid
						showErrorPage();
					}							
				}
			}			
		}
			// SAVE CODE BELOW for if we go back to displaying multiple topics found in a popup list
			/*else if (topicList.length == 1) {
				var singletopic = topicList[0].topic;
				if (singletopic.indexOf(".html") == -1 && singletopic.indexOf(".htm") != -1) {
					singletopic = singletopic.replace(".htm",".html");
					goTopic(singletopic,false);
				}	
				else if (singletopic.indexOf(".html") != -1){
					goTopic(singletopic,false);
				}					
			}
			else if (topicList.length > 1) {
				showTopicList(topicList);
			}*/
		callback();
		//}
	}

	function showErrorPage() {
		let iframeDoc = document.getElementById("landing");	
		iframeDoc.src = errorpage;
		feedbackMail();
		setTimeout(function () {
			$('.busy, .busy-indicator-container').addClass('is-hidden');
		}, 2000);
		if (currpage = -1) {
			// provide an initial history page
			if (!varstore.isCollection) {
				addHistory("topic=cover.html");
			}
			else {
				addHistory("topic=landing.html");
			}
		}
	}
	function showhidesidetoc(load) {
		// shows or hides side TOC when button is clicked, adjusts CSS for topic page
		let topicload = load;
		let sidetocclass = $('body',window.document).attr('class');
		let sidetocclass2 = $('#landing',window.document).contents().find('body').first().attr('class');
			
		if ($('#landing',window.document).contents().find('div.wh_publication_toc').length == 0 && !$('html').hasClass('smarthelp')) {
			// no section toc items to show, so hide button
			$('#landing',window.document).contents().find('div.sidetocbtn').css('display','none');
			$('div.wh_publication_toc').css('display','none');
			$('div.wh_topic_content').css('width','90%');
			return;
		}
		else if ($('html').hasClass('smarthelp')) {
			// for Smart Help, hide button but show side toc items, if any available
			//$('#landing',window.document).contents().find('div.sidetocbtn').css('display','none');
			$('#landing',window.document).contents().find('body').addClass('showside');
			$('#landing',window.document).contents().find('body').removeClass('hideside');
			let smartHelpContent = $('#landing',window.document).contents().find('body.smarthelp div.wh_topic_content');
			$(smartHelpContent).css('width','90%');
		}
		else {
			$('#landing',window.document).contents().find('div.sidetocbtn').css('display','block');
			$('div.wh_topic_content').css('width','');
		}		

		if (topicload && !$('html').hasClass('smarthelp')) {
			// just loading a new topic, use current sidetoc setting
			if (sidetocclass.indexOf("hideside") != -1) {
				$('#landing',window.document).contents().find('body').addClass('hideside');
				// below probably not needed 
				if (sidetocclass2.indexOf('showside') != -1) {
					$('#landing',window.document).contents().find('body').removeClass('showside');
				}
			}
			if (sidetocclass.indexOf("showside") != -1) {
				$('#landing',window.document).contents().find('body').addClass('showside');
				// below probably not needed 
				if (sidetocclass2.indexOf('hideside') != -1) {
					$('#landing',window.document).contents().find('body').removeClass('hideside');
				}
			}
		}
		else if (!topicload && !$('html').hasClass('smarthelp')) {
			// button clicked to toggle sidetoc setting
			if (sidetocclass.indexOf("hideside") != -1) {
				$('body',window.document).addClass('showside');
				$('body',window.document).removeClass('hideside');				
				$('#landing',window.document).contents().find('body').addClass('showside'); 
				if (sidetocclass2.indexOf('hideside') != -1) {
					$('#landing',window.document).contents().find('body').removeClass('hideside');
				}
			}
			if (sidetocclass.indexOf("showside") != -1) {
				$('body',window.document).addClass('hideside');
				$('body',window.document).removeClass('showside');
				$('#landing',window.document).contents().find('body').addClass('hideside');
				if (sidetocclass2.indexOf('showside') != -1) {
					$('#landing',window.document).contents().find('body').removeClass('showside');
				}
			}			
		}
	}
	function pageHighlightAndSynch(topic) {
		// performs various tasks when a topic is loaded
		if (topic.indexOf("hl=") != -1) {
			// highlight search terms if hl param exists
			var hlparam = topic.substring(topic.indexOf("hl=") + 3);
			require(["webhelp"], function (webhelp) {
				webhelp.highlightSearchTerm(hlparam);
			});	
		}			
		// set up collapsible headings for LN
		enableCollapsibleHeadings();
		// set up CSS based on whether it's a SmartHelp topic being loaded
		if ($('html').hasClass('smarthelp')) {
			$('#landing',window.document).contents().find('body').first().addClass('smarthelp');
		}
		// set up CSS based on current setting for showing sidetoc (which is controlled by class on framework body)
		showhidesidetoc(true);
		var topic = topic;
		if (topic.indexOf("?hl") != -1) {
			topic = topic.substring(0,topic.indexOf("?hl"));
		}
		// following if/else can probably be deleted since margins are being set to 25px in all cases now
		// but need to test this
		if ($('.application-menu-trigger.show').css('display') == "block" && !($('html').hasClass('smarthelp'))) {
			if ($('html').attr('dir') == "rtl") {
				//$('#landing',window.document).contents().find('body.wh_topic_page').first().css('margin-right','25px');
			}
			else {
				//$('#landing',window.document).contents().find('body.wh_topic_page').first().css('margin-left','25px');
			}			
		}
		else {
			if ($('html').attr('dir') == "rtl") {
				$('#landing',window.document).contents().find('body').first().css('margin-right','');
			}
			else {
				$('#landing',window.document).contents().find('body').first().css('margin-left','');
			}			
		}
		var container = $('.inverse');
		var mapfolder = "";
		if (varstore.isCollection) {
			var map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
			mapfolder = getMapFolder(topic);
			// check if topic has map folder already, add if doesn't
			if (topic.indexOf(mapfolder) != -1) {
				topic = topic.substring(topic.indexOf(mapfolder));
			}			
			else if (mapfolder == "") {
				topic = map + "/" + topic;
			}
		}
		var tocAnchor = "";
		scrollOffset = "";
		var targetoffset = 0;
		var topoffset = 0;
		var homeoffset = 0;
		var divHeight = container.innerHeight();
		var datafile = mapfolder + "/cover.html";	
		var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').not('.collection-link').find("a[data-file*='" + datafile + "']"); 
		if (varstore.isCollection) {
			if (collBookAnchor.length == 0) {
				// would this be hit if user has URL to help topic not in toc because it's a page overview?
				return;
			}
			else {
				if (collBookAnchor.length > 1) {
					collBookAnchor.each(function(){
						var onclicktext = $(this).attr('data-file');
						var mapstring = onclicktext.substring(0,onclicktext.indexOf("/"));
						if (mapfolder == mapstring) {
							collBookAnchor = $(this);
							return false;
						}
					});
				}
				var accordionPaneChildren = collBookAnchor.parent().next('.accordion-pane').find('a');
				var childrenCount = accordionPaneChildren.length;
				if (childrenCount != 0 || topic.indexOf("cover.html") != -1) {
					// The map's TOC is loaded, so try to synch with TOC with topic
					synchToc(topic, collBookAnchor, function(anchorReturned) {
						tocAnchor = anchorReturned;
						if ((typeof tocAnchor == "undefined" || tocAnchor == undefined || tocAnchor == "") && varstore.isCollection) {
							var expandedPanes = $('.accordion-header.collection',window.document).next('.accordion-pane.is-expanded');
							var hdr = expandedPanes.prev('.accordion-header');
							var hdrbtns = hdr.children('button').first().trigger('click');
							hdr.removeClass('is-selected');
							hdr.removeClass('is-focused');
							return;
						}
						if (typeof tocAnchor != "undefined" && tocAnchor != undefined && tocAnchor != "") {
							var scrollTarget = $(tocAnchor).parent('.accordion-header').first();
							scrollOffset = scrollTarget.offset().top;
							var target = $(tocAnchor); // NOT USED?
							topoffset = $('.inverse')[0].scrollTop;
							// NEED TO CHECK INTO ADJUSTING CONDITIIONS BELOW IN IF'S
							if (scrollOffset > divHeight) {
								if (scrollOffset > divHeight + 50 || scrollOffset == divHeight + 50 || scrollOffset < 86) {
									scrollPageTo(scrollTarget, function() {
										adjustTocScroll(scrollTarget,topoffset);				
									});
								}
							}
							if (scrollOffset < 86) {
								scrollPageTo(scrollTarget, function() {
									adjustTocScroll(scrollTarget,topoffset);				
								});
							}
						}
						setFocusOnTopic(topic);
					});					
				}
				else {
					// Map's TOC not loaded, so wait till it is before synching with TOC
					var checkcount = 0;
					var delay = 200;
					var collheaderbtn = collBookAnchor.parent().find('[class^="btn"]');
					
					var initcheck = window.setTimeout(function checkbutton() {
						var buttonclick = undefined;
						getButtonStatus(collheaderbtn,function(currBtnStatus) {
							if (checkcount > 20) {
								buttonclick = true;
								window.clearTimeout(initcheck);							
							}
							else if (!currBtnStatus) {
								initcheck = setTimeout(checkbutton,delay + 200);
								checkcount++;
							}
							else if (currBtnStatus) {
								collheaderbtn.trigger('click');
								var pauseb4synch = window.setTimeout(function callSynchToc() {
									if (checkcount > 20 ) {
										window.clearTimeout(pauseb4synch);							
									}
									else if (collBookAnchor.parent().next('.accordion-pane').find('a').length == 0) {
										pauseb4synch = setTimeout(callSynchToc,delay + 200);
										checkcount++;
									}
									else if (window.tocJSONloaded || collBookAnchor.parent().next('.accordion-pane').find('a').length > 0){
										synchToc(topic, collBookAnchor, function(anchorReturned) {
											tocAnchor = anchorReturned;
											if ((typeof tocAnchor == "undefined" || tocAnchor == undefined || tocAnchor == "") && varstore.isCollection) {
												var expandedPanes = $('.accordion-header.collection',window.document).next('.accordion-pane.is-expanded');
												var hdr = expandedPanes.prev('.accordion-header');
												var hdrbtns = hdr.children('button').first().trigger('click');
												hdr.removeClass('is-selected');
												hdr.removeClass('is-focused');
												return;
											}
											if (typeof tocAnchor != "undefined" && tocAnchor != undefined && tocAnchor != "") {
												var scrollTarget = $(tocAnchor).parent('.accordion-header').first();
												scrollOffset = scrollTarget.offset().top;
												topoffset = $('.inverse')[0].scrollTop;
												var target = $(tocAnchor); // NOT USED?
												// NEED TO CHECK INTO ADJUSTING CONDITIIONS BELOW IN IF'S
												if (scrollOffset > divHeight) {
													if (scrollOffset > divHeight + 50 || scrollOffset == divHeight + 50 || scrollOffset < 86) {
														scrollPageTo(scrollTarget, function() {
															adjustTocScroll(scrollTarget,topoffset);				
														});
													}
												}
												if (scrollOffset < 86) {
													scrollPageTo(scrollTarget, function() {
														adjustTocScroll(scrollTarget,topoffset);				
													});
												}
											}
											setFocusOnTopic(topic);
										});	
										$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
										if ($(tocAnchor,window.document).parent().is('.accordion-header')) {
											$(tocAnchor,window.document).parent().removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
										}
										window.clearTimeout(pauseb4synch);
									}	
								},delay);
							}
						});
					}, delay);
				}
			}
			var topic2 = topic;
			if (topic.indexOf("?hl") != -1) {
				// need to remove ?h1 before sending to replaceTitle()
				topic2 = topic.substring(0,topic.indexOf("?hl"));
			}
			replaceTitle(topic2);
		}
		else {
			// not a collection, so TOC is already present, go ahead and call synchTOC
			if (topic !== "" && topic !== undefined && topic.indexOf("cover.html") == -1) {
				
				synchToc(topic, collBookAnchor, function(anchorReturned) {
					tocAnchor = anchorReturned;
					if (typeof tocAnchor != "undefined" && tocAnchor != undefined && tocAnchor != "") {
						var scrollTarget = $(tocAnchor).parent('.accordion-header').first();
						scrollOffset = scrollTarget.offset().top;
						var target = $(tocAnchor); // NOT USED?
						// NEED TO CHECK INTO ADJUSTING CONDITIIONS BELOW IN IF'S
						if (container[0].scrollHeight > divHeight) {
							topoffset = container[0].scrollTop;
							targetoffset = scrollTarget.offset().top;
							if (scrollOffset > divHeight + 50 || scrollOffset == divHeight + 50 || scrollOffset < 86) {
								scrollPageTo(scrollTarget, function() {
									var currScroll = $('#application-menu',window.document).scrollTop();
									adjustTocScroll(scrollTarget,currScroll);				
								});
							}
						}
					}
					setFocusOnTopic(topic);					
				});
			}
		}
		$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
		if ($(tocAnchor,window.document).parent().is('.accordion-header')) {
			$(tocAnchor,window.document).parent().removeClass('hide-focus').addClass('is-selected');
		}
		// hiding below to avoid permission denied on Permission denied to access property "document" on cross-origin object
		if ($('#landing',window.document)[0].src.indexOf(".pdf") == -1) {
			//$('#landing',window.document).get(0).contentWindow.document.body.click();
		}
		if (window.innerWidth < 640  && window.innerWidth < window.innerHeight && $('#application-menu').hasClass('is-open')) {
			// small portrait screens
			$('.application-menu-trigger').trigger('click');
		}
		else if (window.innerWidth < 569 && window.innerWidth >= window.innerHeight && $('#application-menu').hasClass('is-open')) {
			// small landscape screens 
			$('.application-menu-trigger').trigger('click');
		}
	}
	function setFocusOnTopic(topic) {
		if (topic.indexOf("lib_pdflist.html") == -1) {
			// this applies to all cases except pdf list page
		  $('#landing',window.document).contents().find('html a, body div.container-fluid').on('click.window', function(e) {
			  varstore.clickTarget = e.target;

			  if (varstore.keyTarget == varstore.clickTarget && e.type == "click") {
				  varstore.lastEvent = "keydown";
				  $('#landing',window.document).contents().find('body div.container-fluid').first().addClass('visible-focus');
				  $('#landing',window.document).contents().find('body div.container-fluid').first().removeClass('hide-focus');
			  }
			  if (e.target != varstore.lastTarget || ($(e.target).parents('.container-fluid').length > 0 && $(e.target).prop('tagName') != "SPAN" && $(e.target).prop('tagName') != "A") && e.type == "click" ) {
				varstore.lastEvent = "click";
				varstore.lastTarget = e.target;
				$('#landing',window.document).contents().find('body div.container-fluid').first().addClass('hide-focus');
				$('#landing',window.document).contents().find('body div.container-fluid').first().removeClass('visible-focus');
			  }
			  if ($(e.target).parents('.container-fluid').length > 0 && e.type == "click") {
				  // for clicks inside div.container-fluid
				   $('#landing',window.document).contents().find('body div.container-fluid').first().addClass('hide-focus');
				   $('#landing',window.document).contents().find('body div.container-fluid').first().removeClass('visible-focus');
			  }
		  });
		  
		  $('#landing',window.document).contents().find('html').first().on('keydown.window', function(e) {
			varstore.lastEvent = "keydown";
			varstore.lastTarget = e.target;
			varstore.keyTarget = e.target;			
		  });
		 $('#landing',window.document).contents().find('body div.container-fluid').on('focusin', function(e){
			  if (varstore.lastEvent == "keydown" && e.type != "click") {			  
				 $('#landing',window.document).contents().find('body div.container-fluid').addClass('visible-focus');
				 $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
			  }
			  else if (varstore.lastEvent == "click") {
				  $('#landing',window.document).contents().find('body div.container-fluid').addClass('hide-focus');
				  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
			  }
		  });
		$('#landing',window.document).contents().find('#sidetoc1, #sidetoc2, a').on('focusin', function(e){
			  e.stopPropagation();
			  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
			  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
		  });
		$('#landing',window.document).contents().find('a, body div.container-fluid').on('focusout', function(e){
			  e.stopPropagation();
			  $(this).removeClass('visible-focus');
			  $(this).removeClass('hide-focus');
		  });

		  // identify type of topic
		  let coverTopic = false;
		  let coverTopicDocid = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
		  let coverTopicLibid = $('#landing',window.document).contents().find('meta[name="INF.Lib.Docid"]').attr('content');
		  let landingTopic = false;
		  let landingTopicDocid = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
		  let landingTopicLibid = $('#landing',window.document).contents().find('meta[name="INF.Lib.Docid"]').attr('content');
		  let stdTopicDocid = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
		  let stdTopicLibid = $('#landing',window.document).contents().find('meta[name="INF.Lib.Docid"]').attr('content');
		  let stdTopic = false;
		  
		  if (coverTopicDocid !== "" && coverTopicDocid !== undefined && $('#landing',window.document).contents().find('.wh_main_page').length !== 0) {
			  coverTopic = true;
		  }
		  else if (varstore.isCollection && landingTopicDocid === undefined && landingTopicLibid === undefined) {
			  landingTopic = true;
		  }
		  else if ($('#landing',window.document).contents().find('.wh_topic_page').length !== 0) {
			  stdTopic = true;
		  }
		  if ($(document.activeElement).prop('tagName') !== "INPUT" && landingTopic) {
			  if (varstore.lastEvent == "initload") {
				  // make sure focus in on search input
				  $('#textToSearch').focus();
			  }
			  else if (varstore.lastEvent == "keydown" && varstore.lastEvent != "initload") {
				  $('#landing',window.document).contents().find('body div.container-fluid').focus();
				  $('#landing',window.document).contents().find('body div.container-fluid').addClass('visible-focus');
				  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
			  }
			  else if (varstore.lastEvent != "keydown" && varstore.lastEvent != "initload") {
				  $('#landing',window.document).contents().find('body div.container-fluid').focus();
				  $('#landing',window.document).contents().find('body div.container-fluid').addClass('hide-focus');
				  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
			  }
		  }
		  else if (coverTopic) {
			  if (varstore.lastEvent == "initload") {
				  // make sure focus in on search input
				  $('#textToSearch').focus();
			  }
			  if ($(document.activeElement).prop('tagName') !== "INPUT" && !varstore.isCollection && varstore.lastEvent != "initload") {
				  $('#landing',window.document).contents().find('body div.container-fluid').focus();
				  if (varstore.lastEvent == "keydown") {
					  $('#landing',window.document).contents().find('body div.container-fluid').addClass('visible-focus');
					  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
				  }
				  else {
					  $('#landing',window.document).contents().find('body div.container-fluid').addClass('hide-focus');
					  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
				  }
			  }
			  else if (varstore.isCollection) {
				  // same as above???
				  $('#landing',window.document).contents().find('.wh_tile a').first().focus();
				  if (varstore.lastEvent == "keydown") {
					  $('#landing',window.document).contents().find('body div.container-fluid').addClass('visible-focus');
					  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
				  }
				  else {
					  $('#landing',window.document).contents().find('body div.container-fluid').addClass('hide-focus');
					  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
				  }
			  }
		  }
		  else if (stdTopic) {
			  	let topicbody = $('#landing',window.document).contents().find('body').first();
				let firstanchor = topicbody.find('a').first();
				topicbody.focus();
				firstanchor.focus();
			  if (varstore.lastEvent == "keydown" || varstore.lastEvent === "initload") {
				  $('#landing',window.document).contents().find('a').first().addClass('visible-focus');		  
			  }
			  else {
				  $('#landing',window.document).contents().find('a').removeClass('visible-focus');
					if (varstore.lastEvent == "click") {
					  $('#landing',window.document).contents().find('a').first().addClass('hide-focus');
					  $('#landing',window.document).contents().find('.container-fluid').addClass('hide-focus');
				  }
			  }	
		  }
		}
		else if (topic.indexOf("lib_pdflist.html") != -1) {
		   $('#landing',window.document).contents().find('body div.container-fluid').focus();
		  if (varstore.lastEvent == "keydown") {
			  $('#landing',window.document).contents().find('body div.container-fluid').addClass('visible-focus');
			  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('hide-focus');
		  }
		  else {
			  $('#landing',window.document).contents().find('body div.container-fluid').addClass('hide-focus');
			  $('#landing',window.document).contents().find('body div.container-fluid').removeClass('visible-focus');
		  }
		}
	}
	function helpFileInit(callback) {
		// Performs special initialization needed when help.html is displayed
		$('#help-iframe').on('load.help', function() {
			var iframeclose = $('#help-iframe',window.document).contents().find('.row div.close-container button');
			iframeclose.attr('title',Locale.translate('Close'));
			iframeclose.children('span').first().text(Locale.translate('Close'));
			iframeclose.on('click', function() {
				$('#help-modal',window.document).css('display','none');
				$('div.overlay',window.document).remove();
				$('#help-modal').off('click.help');
			});
			var iframeprint = $('#help-iframe',window.document).contents().find('.row div.printbtn-container button');
			iframeprint.attr('title',Locale.translate('Print'));
			iframeprint.children('span').first().text(Locale.translate('Print'));			
			iframeprint.on('click', function() {
				var iframehelp = $('#help-iframe',window.document)[0];
				iframehelp.contentWindow.print();
			}).on('keydown', function(e) {
				if (e.which === 0 || e.which === 27) {
					$('#help-modal',window.document).css('display','none');
					$('div.overlay',window.document).remove();
					$('#help-modal').off('click.help');
				}					
			});
					
			$(document).on('keydown.help', function(e) {
				 if (e.which === 0 || e.which === 27) {
					$('#help-modal',window.document).css('display','none');
					$('div.overlay',window.document).remove();
					$('#help-modal').off('click.help');
				 }
			});

			let containerdiv = $('#help-iframe').contents().find('.container-fluid');
			containerdiv.on('click.help', function(e) {
				varstore.clickTarget = e.target;

				if (varstore.keyTarget == varstore.clickTarget && e.type == "click") {
					varstore.lastEvent = "keydown";
					//containerdiv.first().addClass('visible-focus');
					containerdiv.removeClass('hide-focus');
				  }
				  if (e.target != varstore.lastTarget || $(e.target).parents('.container-fluid').length > 0) {
					varstore.lastEvent = "click";
					varstore.lastTarget = e.target;
					containerdiv.addClass('hide-focus');
					containerdiv.removeClass('visible-focus');
				  }
				  if ($(e.target).parents('.container-fluid').length > 0 && e.type == "click") {
					containerdiv.addClass('hide-focus');
					containerdiv.removeClass('visible-focus');
				  }
			}).on('keydown.help', function(e) {
				if (e.which === 0 || e.which === 27) {
					$('#help-modal',window.document).css('display','none');
					$('div.overlay',window.document).remove();
					$('#help-modal').off('click.help');
				}
			}).on('focusin.help', function(e){
				  if (varstore.lastEvent == "keydown" && e.type != "click") {
					 containerdiv.addClass('visible-focus');
					 containerdiv.removeClass('hide-focus');
				  }
				  else if (varstore.lastEvent == "click") {
					  containerdiv.addClass('hide-focus');
					  containerdiv.removeClass('visible-focus');
				  }
			});
			$('#help-iframe').contents().find('a.external').on('focusin.help', function() {
				e.stopPropagation();
				containerdiv.addClass('hide-focus');
				containerdiv.removeClass('visible-focus');
			});
			$('#help-iframe').contents().find('a.external, .container-fluid').on('focusout.help', function(e){
				  e.stopPropagation();
				  $(this).removeClass('visible-focus');
				  $(this).removeClass('hide-focus');
			});
		
			$('#help-iframe').contents().find('html').on('keydown.help', function(e) {
				varstore.lastEvent = "keydown";
				varstore.lastTarget = e.target;
				varstore.keyTarget = e.target;
			});
			
			$('#help-iframe').contents().find('a[data-file^="mailto"').on('click', function(e) {
				var hrefvalue = "";
				var bodycontent = "";
				var referenceid = $("#inforFeedback",window.document).attr("data-id");
				var product = $("#about-trigger",window.document).attr("data-product-name");
				var subject = "";
				let topictitle = $('#help-iframe',window.document).contents().find('h1').first().text();;
				subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product) + encodeURIComponent(", ") + encodeURIComponent(topictitle);
				bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0ATopic title: " + topictitle + "%0D%0AFile Name: help.html" + "%0D%0AHelp System Reference ID: " + referenceid;
				hrefvalue = subject + bodycontent;
				mailhref = hrefvalue;
				sendMail(mailhref);
			})
			.on('keydown', function(e) {
				if (e.which === 32 && e.target === document.body) {
					e.preventDefault();
				}
				if (e.which === 32) {
					var hrefvalue = "";
					var bodycontent = "";
					var referenceid = $("#inforFeedback",window.document).attr("data-id");
					var product = $("#about-trigger",window.document).attr("data-product-name");
					var subject = "";
					let topictitle = $('#help-iframe',window.document).contents().find('h1').first().text();;
					subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product) + encodeURIComponent(", ") + encodeURIComponent(topictitle);
					bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0ATopic title: " + topictitle + "%0D%0AFile Name: help.html" + "%0D%0AHelp System Reference ID: " + referenceid;
					hrefvalue = subject + bodycontent;
					mailhref = hrefvalue;
					sendMail(mailhref);	
				}					
			});
			// keeping focus in modal if tabbing
			const focusableElements = 'button, div.container-fluid, a.external';
			const modaltabbable = $('#help-iframe',window.document).contents().find(focusableElements);
			const firstFocusableElement = modaltabbable.first(); // get first element to be focused inside modal
			const lastFocusableElement = modaltabbable.last(); // get last element to be focused inside modal

			$('#help-iframe').contents().find('html').on('keydown', function(e) {
			  let isTabPressed = e.key === 'Tab' || e.keyCode === 9;

			  if (!isTabPressed) {
				return;
			  }

			  if (e.shiftKey) { // if shift key pressed for shift + tab combination
					let frameActiveElement = document.getElementById("help-iframe").contentWindow.document.activeElement;
					if (firstFocusableElement.is(":focus")) {
					  lastFocusableElement.focus(); // add focus for the last focusable element
					  e.preventDefault();
					}
			  } else { // if tab key is pressed
					let frameActiveElement = document.getElementById("help-iframe").contentWindow.document.activeElement;
					if (lastFocusableElement.is(":focus")) { 						
					  firstFocusableElement.focus(); // add focus for the first focusable element
					  e.preventDefault();
					}
			  }
			});
			callback();				
		});	
	}
	function pdfMessageInit(callback) {
		// Performs special initialization needed when PDF message dialog is displayed
		var close = $('#pdf-modal',window.document).contents().find('div button.btn-cancel');
		close.attr('title',Locale.translate('Cancel'));
		close.text(Locale.translate('Cancel'));
		close.on('click', function() {
			$('#pdf-modal',window.document).css('display','none');
			$('div.overlay',window.document).remove();
			//$('#pdf-modal').off('click.pdfdialog');
		});
		var buttonok = $('#pdf-modal',window.document).contents().find('div button.btn-ok');
		//buttonok.attr('title',Locale.translate('OK'));
		//buttonok.text(Locale.translate('OK'));			
		buttonok.on('click', function() {
			$('div.overlay',window.document).remove();
			$('#pdf-modal',window.document).css('display','none');
			var iframe = $('#landing',window.document)[0]; 
			iframe.src = "lib_pdflist.html";				
		});
		$(document).on('keydown.pdfdialog', function(e) {
			 if (e.which === 0 || e.which === 27) {
				$('#pdf-modal',window.document).css('display','none');
				$('div.overlay',window.document).remove();
				//$('#pdf-modal').off('click.pdfdialog');
			 }
		});
		callback();				
	}
	function adjustTocScroll(scrollTarget,currScroll) {
		// As part of synchTOC, tries to ensure that highlighted topic in TOC is visible in window
		var scrollTarget = scrollTarget;
		var topoffset = scrollTarget.offset().top;
		var container = $('.inverse');
		var divHeight = container.innerHeight();
		var firsthdr = $('.accordion-header',window.document).first();

		var currScroll = currScroll;
		var newscroll = currScroll;		

		if (topoffset < 0 ) {
			var testscroll = -(firsthdr.offset().top - topoffset);
			container.scrollTop(testscroll);
		}
		else if (topoffset < 86) {
			var newscroll = container.scrollTop() - 100;
			container.scrollTop(newscroll);
		}
		else if (topoffset > divHeight + 30 && topoffset < divHeight + 50) {
			var currScroll = container.scrollTop();
			container.scrollTop(currScroll + 50);
		}
		else if (topoffset > divHeight + 49) {	
			newscroll = currScroll + 86 + (topoffset - divHeight);	
			container.scrollTop(newscroll);
		}
		var newoffset = scrollTarget.offset().top;	
		if (newoffset < 86 || newoffset > divHeight + 49) {
			// try a little more adjustment for insurance
			container.scrollTop(newscroll + 80);
		}
		else {
			// no more adjustment needed
			return;
		}
	}
	
	function scrollPageTo(target, callback) {
		// As part of synchTOC, tries to ensure that highlighted topic in TOC is visible in window
		let scrolltarget = target[0];
		let topPos = window.document.getElementById("application-menu").offsetTop;
		scrollToElem(scrolltarget, topPos-100, 600, function(){
			callback();
		}); 

		function scrollToElem(element, to, duration, callback) {
			var start = element.scrollTop,
				change = to - start,
				currentTime = 0,
				increment = 20;

			var animateScroll = function(){        
				currentTime += increment;
				var val = Math.easeInOutQuad(currentTime, start, change, duration);
				element.scrollTop = val;
				if(currentTime < duration) {
					setTimeout(animateScroll, increment);
				}
				else {
					callback();
				}
			};
			//t = current time
			//b = start value
			//c = change in value
			//d = duration
			Math.easeInOutQuad = function (t, b, c, d) {
				t /= d/2;
				if (t < 1) return c/2*t*t + b;
				t--;
				return -c/2 * (t*(t-2) - 1) + b;
			};
			animateScroll();
		}
	}
	
	function showTopicList(topicList) {
		// currently not used; designed to help display list of topics if duplicates exist
		var listlocation = $('#listtopic-modal ul').first();
		for (var i = 0; i < topicList.length; i++) {
			var onclickval = "goTopic('" + topicList[i].topic + "',false)";
			var topicTitle = getTopicTitle(topicList[i].topic);
			$('<li class="li"></li>').appendTo(listlocation);
			$('<a href="#" onclick="' + onclickval + '">' + topicTitle + ' (' + topicList[i].title + ')</a>').appendTo(listlocation.find('li').eq(i));
		}
		$('#listtopic-modal').trigger('open');
	}
	
	function getTopicTitle(topic) {
		// works with showTopicList
		var topictitle = "";
		var topic = topic;
		var topictitlefound = false;
		for (key in fil) {
			var currFile = fil[key];
			if (currFile.indexOf(topic) != -1) {
				topictitle = currFile.substring(currFile.indexOf("@@@")+3,currFile.lastIndexOf("@@@"));
				break;
			}
		}
		return topictitle;
	}

	function loadFullJSON(jsonfile, callback) { 
		// loads the module.js so context-sensitive URLs can be checked, and xdr links resolved
		var xobj = new XMLHttpRequest();
			xobj.overrideMimeType("application/json");
		xobj.open('GET', jsonfile, true);
		xobj.onreadystatechange = function () {
			  if (xobj.readyState == 4 && xobj.status == "200") {
				// Required use of an anonymous callback as .open will NOT return a value but simply returns undefined in asynchronous mode
				callback(xobj.responseText);
			  }
			  else {
				  console.log("Error loadfulljson status=" + xobj.status + ", readystate=" + xobj.readyState);
			  }
		};
		xobj.send(null);
	}
	
	function search4helpcontent(helpcontentbase) {
		// works with the checkTopic function to get a valid topic from module.js
		var foundtopics = "";
		if (helpcontentbase == "") {
			return "";
		}
		var item = "";
		//create filepaths from jsonfileContents					
		var jsonfilekeys = Object.keys(jsonfileContents[0]);
		var jsonfilevalues = Object.values(jsonfileContents[0]);
		if (varstore.fallback) {
			//if fallback scenario, replace arrays to search English module.js
			jsonfilekeys = Object.keys(jsonfileEnContents[0]);
			jsonfilevalues = Object.values(jsonfileEnContents[0]);			
		}
		var pathentries = "";
	
		for (var i=0; i < jsonfilekeys.length; i++) {
			if (jsonfilekeys[i] == "entries") {
				pathentries = Object.keys(jsonfilevalues[i]);
				pathvalues = Object.values(jsonfilevalues[i]);
				var mapfolderfound = false;
				if (varstore.isCollection && helpcontentbase.indexOf("/") != -1) {
					//need to check if helpcontentbase starts with mapfolder 
					var foldercheck = helpcontentbase.substring(0,helpcontentbase.indexOf("/"));
					for (var i = 0; i < titlemap.titlemapping.length; ++i) {
						if (titlemap.titlemapping[i].folder == foldercheck) {
							mapfolderfound = true;
						}
					}
				}
				for (var key in pathentries) {					
					if (pathvalues[key].path != undefined && pathentries[key].path != "") {
						var obj = pathvalues[key].path;
						var objcheck = "";
						
						if (mapfolderfound){
							// mapfolder is in helpcontentbase, use obj minus .html
							objcheck = obj.substring(0,obj.indexOf(".htm"));
							objcheck = objcheck.toLowerCase();
						}
						else if (varstore.isCollection && !mapfolderfound && helpcontentbase.indexOf("/") != -1) {
							// mapfolder not in helpcontentbase, but slash present, so use obj minus its mapfolder and .html
							objcheck = obj.substring(obj.indexOf("/")+1,obj.indexOf(".htm"));
							objcheck = objcheck.toLowerCase();
						}
						else if (varstore.isCollection && helpcontentbase.indexOf("/") == -1) {
							// mapfolder not present, no slash, so use only filename from obj minus the .html
							objcheck = obj.substring(obj.lastIndexOf("/")+1,obj.indexOf(".htm"));
							objcheck = objcheck.toLowerCase();
						}
						else if (!varstore.isCollection && helpcontentbase.indexOf("/") != -1) {
							// slash present, so use obj minus .html
							objcheck = obj.substring(0,obj.indexOf(".htm"));
							objcheck = objcheck.toLowerCase();
						}
						else if (!varstore.isCollection && helpcontentbase.indexOf("/") == -1) {
							// no slash present, so only filename from obj minus the .html
							objcheck = obj.substring(obj.lastIndexOf("/")+1,obj.indexOf(".htm"));
							objcheck = objcheck.toLowerCase();
						}							
						if (objcheck == helpcontentbase) {
							var curdoctitle = "";
							return obj;
						}
						//if (isCollection) {
							// for future list, if we want to return multiple topics from module.js
						//	var currdocid = obj.substring(0,obj.indexOf("/"));
						//	curdoctitle = getTitle(currdocid);
						//}
						//foundTopics.push({title:curdoctitle,topic:obj});
					}			
				}
				return foundtopics;
			}
		}		
	}
	function getTitle(currdocid) {
		// works with unused clause in search4helpcontent function
		 var title = "";
		 for (var i = 0; i < titlemapping.length; ++i) {
			 if (titlemapping[i].folder == currdocid) {
				 title = titlemapping[i].title;
				 break;
			 }
		 }
		return title;
	}
	
	function home(fromback) {
		// handles clicks on Home button
		var iframeDoc = document.getElementById("landing");	
		$('#homebutton').hideFocus();
		var initoptions = getIsoLang($('html').attr('lang'));
		if (varstore.isCollection) {
			//iframeDoc.src = "landing.html";
			goTopic("landing.html");
			collLandingInit();
			require(["varstore"], function (varstore) {
				arraycheck = varstore.pagehistory.length;
				if (fromBack == false) {
					if (arraycheck > currpage + 1) {
						varstore.pagehistory.splice(currpage + 1,arraycheck - currpage + 1);
						addHistory("topic=landing.html");
					}
					else if (arraycheck == currpage + 1) {
						addHistory("topic=landing.html");
					}
				}
				else {
					fromBack = false;
				}
			});			
			hideAllSearch(false);
			replaceTitle("");
		}
		else {
			iframeDoc.src = "cover.html";
			$('#landing').off('load');
			$('#landing').on('load', function(){
				require(["sohoxi"], function (sohoxi) {
					$('#landing',window.document).contents().find('body').first().initialize(initoptions);
					feedbackMail();
					setFocusOnTopic("cover.html");
					hideAllSearch(true);
					if ($('html').hasClass('smarthelp')) {
						$('#landing',window.document).contents().find('body').first().addClass('smarthelp');
					}
				});
			});			
			require(["varstore"], function (varstore) {
				arraycheck = varstore.pagehistory.length;
				if (fromBack == false) {
					if (arraycheck > currpage + 1) {
						varstore.pagehistory.splice(currpage + 1,arraycheck - currpage + 1);
						addHistory("topic=cover.html");
					}
					else if (arraycheck == currpage + 1) {
						addHistory("topic=cover.html");
					}
				}
				else {
					fromBack = false;
				}				
			});	
			setTimeout(function () {
				$('.busy, .busy-indicator-container').addClass('is-hidden');
			}, 1000);
		}

	}

	function goTocTopic(topic) {  
		// handles clicks on TOC items
		var currpagetopic = varstore.pagehistory[currpage];
		currpagetopic = currpagetopic.substring(currpagetopic.lastIndexOf("=") +1);
		var iframeDoc = window.document.getElementById("landing");
		var iframesrc = iframeDoc.src;
		let topicmeta = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
		let mapfoldermeta = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
		let topicfullpath = topicmeta;
		if (varstore.isCollection && topic.indexOf("http:") == -1 && topic.indexOf("https:") == -1) {
			topicfullpath = mapfoldermeta + "/" + topicmeta;
		}
		if (topic.indexOf("http:") != -1 || topic.indexOf("https:") != -1) {
			// external link in TOC, open in new window/tab
			extopener = window.open(topic);
			extopener.opener = null;
			return;
		}
		if (iframesrc.indexOf(errorpage) == -1 && topic == currpagetopic && (currpagetopic == topicfullpath || (topic.indexOf(mapfoldermeta) != -1 && topic.indexOf("cover.html") != -1))) {	
			//don't reload same topic but hide TOC on portrait phones (may need to adjust number)
			if (window.innerWidth < 569) {
				$('.application-menu-trigger').trigger('click');
				return;
			}
			else {
				return;
			}
		}
		else if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
			$('.application-menu-trigger').trigger('click');
		}
		if (varstore.isCollection) {
			replaceTitle(topic);
		}		
		var iframeDoc = window.document.getElementById("landing");
		if (iframeDoc == null) {
			iframeDoc = window.document.getElementById("landing");
		}	
		// adjust for small window, portrait mode
		if (window.innerWidth < 640 && window.innerWidth < window.innerHeight) {
			//$('.application-menu-trigger').trigger('click');
		}
		iframeDoc.src = topic;
		
		// initialize the topic and synch to toc
		var initoptions = getIsoLang($('html').attr('lang'));
		$('#landing').off('load');
		$('#landing').on('load', function(){
			require(["sohoxi","deliverableCollectionModule"], function (sohoxi,deliverableCollectionModule) {
				deliverableCollectionModule.enableCrossDeliverableLinks();					
				$('#landing',window.document).contents().find('body').first().initialize(initoptions);
				feedbackMail();
				enableCollapsibleHeadings();
				sendInfoToSmartHelp(topic);
				hideAllSearch(true);
				if ($('html').hasClass('smarthelp')) {
					$('#landing',window.document).contents().find('body').first().addClass('smarthelp');
				}
				showhidesidetoc(true);
				setFocusOnTopic(topic);
			});
		});
		arraycheck = varstore.pagehistory.length;
		if (fromBack == false) {
			if (arraycheck > currpage + 1) {
				varstore.pagehistory.splice(currpage + 1,arraycheck - currpage + 1);
				addHistory("topic=" + topic);
			}
			else if (arraycheck == currpage + 1) {
				addHistory("topic=" + topic);
			}
		}
	}

	function hideAllSearch(showcurrent) {
		// change name to resetSearch()???
		$('#textToSearch').val('');
		$('.searchfield-wrapper .icon.close').addClass('is-empty');
		
		if (varstore.isCollection){
		  $('#textToSearchHS').val('');
		  if (showcurrent && $('#textToSearchHS').css('display') != "none") {
			  //$('#textToSearchHS').css('display','inline-block');
		  }
		  else if (!showcurrent) {
			  $('#textToSearch').css('display','');
			  $('#textToSearchHS').css('display','none')
			  $('.searchselect-button',window.document).css('display','');
		  }
		  
		}
		else {
			$('#textToSearch').css('display','');
		}
		
	}
	
	function showsearch() {
		var searchbox = $('#textToSearch', window.document);
		searchbox.attr("data-options", "{collapsible: false}");
		var searchboxHS = $('#textToSearchHS', window.document);
		searchboxHS.css('display','none');
		searchboxHS.removeClass('active');
		var titlediv = $('.title').first();
		var span = searchbox.parent().first();
		var searchdiv = span.parent().first();
		var searchsvg = $('.icon.search', window.document);
		var closeicondiv = $('.closeicondiv',window.document).first();
		var closeicon = $('.closeicondiv .close.icon',window.document).first();
		
		// display search input box
		searchbox.css("display","");
		closeicondiv.css("display","inline-block");
		if ($('#textToSearch', window.document).val() === '') {
			closeicon.addClass('is-empty');
		}
		if ($('#textToSearch', window.document).val() !== '') {
			closeicon.removeClass('is-empty');
		}
		span.attr("class", "searchfield-wrapper active is-open");		
		searchbox.focus();
		
		if (window.innerWidth < 377) {
			/*titlediv.css("display","none");
			searchbox.css("width","130");
			searchbox.css("min-width","130");
			span.css("width","180");
			span.css("min-width","180");
			searchdiv.css("width","180");
			searchdiv.css("min-width","180");	*/
		}
		if (window.innerWidth < 448 && window.innerWidth > 376) {
			/*titlediv.css("display","none");
			searchbox.css("width","150");
			searchbox.css("min-width","140");
			span.css("width","200");
			span.css("min-width","180");
			searchdiv.css("width","200");
			searchdiv.css("min-width","180");	
			$(searchsvg).css("right","35px");*/
		}
		if (window.innerWidth < 641 && window.innerWidth > window.innerHeight) {
			/*titlediv.css("display","none");
			searchbox.css("width","140");
			searchbox.css("min-width","140");
			span.css("width","180");
			span.css("min-width","180");
			searchdiv.css("width","180");
			searchdiv.css("min-width","180");	*/
		}
		// setup events to hide search box on smaller devices than laptop
		// check that 641 is good width to use here, could be wider perhaps
		// IN NEW DESIGN, SHOULD NOT BOTHER CALLING HIDESEARCH UNLESS IT DOES NOT REALLY HIDE INPUT BOX
		if (window.innerWidth < 641) {
			$("#landing").contents().on("touchstart.searchfield mousedown.searchfield click.searchfield", function(e) {
				var target = $(e.target);				
				var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
				if (touchenabled && ((e.type == "mousedown" || e.type == "touchstart") && !target.is('INPUT') && !target.is('svg'))) {
					if ($('svg.icon.close').first().hasClass('is-empty')){
						hidesearch();	
						$('#textToSearch').val('');				
					}
				}
			});
			$('#toolbar, .main .content > .page-container').on('touchstart.links mousedown.links click.links', function(e) {
				var target = $(e.target);				
				var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
				if (touchenabled && ((e.type == "mousedown" || e.type == "touchstart") && !target.is('INPUT') && !target.is('svg'))) {
					if ($('svg.icon.close').first().hasClass('is-empty')){
						hidesearch();	
						$('#textToSearch').val('');				
					}				
				}		
			});
		}
	}

	function hidesearch() {
		var searchbox = $('#textToSearch', window.document);
		searchbox.attr("data-options", "{collapsible: true}");
		var titledivs = document.getElementsByClassName("title");
		var titlediv = $('.title').first();
		var span = searchbox.parent().first();
		var searchdiv = span.parent().first();
		var closeicondiv = $('.closeicondiv',window.document).first();
		var closeicon = $('.close.icon',window.document).first();
		if (closeicon.hasClass("is-empty")) {
			searchbox.blur();
		}
		closeicondiv.css("display","");
		var focus = $("#textToSearch").is(":focus");
		if (!focus) {
			span.attr("class", "searchfield-wrapper");
			searchbox.attr("class","searchfield");
			
			if (window.innerWidth < 377 && window.innerWidth < window.innerHeight) {
				/*searchbox.css("width","25px");
				searchbox.css("min-width","25px");
				span.css("width","25");
				span.css("min-width","25");
				searchdiv.css("width","25");
				searchdiv.css("min-width","25");	
				titlediv.css("display","inline-block");
				$('.searchicondiv').first().css('right','0px');*/
			}
			if (window.innerWidth < 448 && window.innerWidth > 376) {
				/*titlediv.css("display","inline-block");
				searchbox.css("width","25px");
				searchbox.css("min-width","25px");
				span.css("width","25");
				span.css("min-width","25");
				searchdiv.css("width","25");
				searchdiv.css("min-width","25");	
				$('.searchicondiv').first().css('right','0px');*/
			}			
			if (window.innerWidth < 641 && window.innerWidth > window.innerHeight) {
				//searchbox.css("width","25");
				//searchbox.css("min-width","25");
				//span.css("width","25");
				//span.css("min-width","25");
				//searchdiv.css("width","25");
				//searchdiv.css("min-width","25");	
			}
		}		
	}	
	function showsearchHS() {
		var searchboxHS = $('#textToSearchHS', window.document);
		var searchboxColl = $('#textToSearch', window.document);
		searchboxColl.css('display','none');
		var titlediv = $('.title').first();
		var span = searchboxHS.parent().first();
		var searchdiv = span.parent().first();
		searchboxHS.attr("data-options", "{collapsible: false}");
		var searchsvg = $('icon.search',window.document);
		var closeicondiv = $('.closeicondivHS',window.document).first();
		var closeicon = $('.closeicondivHS .close.icon',window.document).first();
		// display search input box
		searchboxHS.css("display","");
		//searchboxHS.css("width","200px");
		closeicondiv.css("display","inline-block");
		if (closeicon.hasClass("is-empty")) {
			//searchboxHS.blur();
		}
		if ($('#textToSearchHS', window.document).val() === '') {
			closeicon.addClass('is-empty');
		}
		if ($('#textToSearchHS', window.document).val() !== '') {
			closeicon.removeClass('is-empty');
		}
		searchboxHS.focus();
		if (!(searchboxHS.is(':focus'))) {
			// Seems necessary to reset this to make it work
			searchboxHS.focus();
		}
		if (window.innerWidth < 377) {
			/*searchboxHS.css("width","130");
			span.css("width","180");
			span.css("min-width","180");
			searchdiv.css("width","180");
			searchdiv.css("min-width","180");	*/
		}
		if (window.innerWidth < 448 && window.innerWidth > 376) {
			/*titlediv.css("display","none");
			searchboxHS.css("width","175");
			searchboxHS.css("min-width","150");
			span.css("width","200");
			span.css("min-width","180");
			searchdiv.css("width","200");
			searchdiv.css("min-width","180");	
			searchsvg.css("right","35px");*/
		}
		if (window.innerWidth < 641 && window.innerWidth > window.innerHeight) {
			/*titlediv.css("display","none");
			searchboxHS.css("width","140");
			searchboxHS.css("min-width","140");
			span.css("width","180");
			span.css("min-width","180");
			searchdiv.css("width","180");
			searchdiv.css("min-width","180");	*/
		}
		span.attr("class", "searchfield-wrapper active is-open");
		searchboxColl.removeClass('active');
	}

	function hidesearchHS() {
		var searchboxhs = $('#textToSearchHS', window.document);
		var searchboxColl = $('#textToSearch', window.document);
		//searchboxColl.removeClass('active');
		searchboxColl.css('display','');
		searchboxhs.attr("data-options", "{collapsible: true}");
		var titlediv = $('.title').first();
		var span = searchboxhs.parent().first();
		var searchdiv = span.parent().first();
		var closeicondiv = $('.closeicondivHS');
		var closeicon = $('.closeicondivHS.close.icon', window.document);
		if (closeicon.hasClass("is-empty")) {
			searchboxhs.blur();
		}
		var focus = $('#textToSearchHS', window.document).is(":focus");
		searchboxhs.attr("class","searchfieldHS");
		searchboxhs.removeClass('active');
		searchboxhs.css("display","");
		closeicondiv.css("display","");
		if (!focus) {
			span.attr("class", "searchfield-wrapper");
			if (window.innerWidth < 377 && window.innerWidth < window.innerHeight) {
				/*searchboxhs.css("width","25px");
				searchboxhs.css("min-width","25px");
				span.css("width","25");
				span.css("min-width","25");
				searchdiv.css("width","25");
				searchdiv.css("min-width","25");	
				titlediv.css("display","inline-block");
				$('.searchicondiv').first().css('right','0px');*/
			}
			if (window.innerWidth < 641 && window.innerWidth > window.innerHeight) {
				/*$(titlediv).css("display","inline-block");
				searchboxhs.css("width","25");
				searchboxhs.css("min-width","25");
				span.css("width","25");
				span.css("min-width","25");
				searchdiv.css("width","25");
				searchdiv.css("min-width","25");	*/
			}
		}		
	}
	
	function copyURL() {
		// called from sohoxi.js, main-init.js
		var currTopic = varstore.pagehistory[currpage];
		var copiedURL = "";
		if (currTopic.indexOf("query=") != -1) {
			var searchQuery = $('#landing',window.document).contents().find('.wh_search_expression').html();
			var phraseSearch = nwSearchFnt.getPhraseSearch();
			if (phraseSearch) {
				searchQuery='"' + searchQuery + '"';
			}
			var filter = collSearchFilter;
			var page = $('#landing',window.document).contents().find('.pagination li.active.page-item .page-link').html();
			if (page == "" || page == undefined) {
				page = 1;
			}
			copiedURL = whUrl + "?searchQuery=" + searchQuery + "&filter=" + filter + "&page=" + page;
		}
		else {
			currTopic = currTopic.substring(currTopic.indexOf("=") + 1);
			if (currTopic.indexOf(".pdf") == -1) {
				if (currTopic.indexOf("?hl") != -1) {
					var hl = currTopic.substring(currTopic.indexOf("?hl")+4);
					currTopic = currTopic.substring(0,currTopic.indexOf("?hl"));
					currTopic = currTopic + "&hl=" + hl;
				}
				copiedURL = whUrl + "?helpcontent=" + currTopic;				
			}
			else {
				// for PDFs displayed in content pane
				copiedURL = whUrl.substring(0,whUrl.lastIndexOf("/")+1) + currTopic;
			}
		}
		return copiedURL;
	}
	function openCollectionTOCLink(url) {
		var url2check = "";
		if (url.indexOf("http:") != -1 || url.indexOf("https:") != -1) {
			// link is to another collection
			if (url.indexOf("?helpcontent") == -1) {
				url2check = url;
			}
			else {
				var collRoot = url.substring(0,url.indexOf("default.html"));
				var filename = url.substring(url.indexOf("?helpcontent")+ 13);
				url2check = collRoot + filename;
			}
			if (UrlExists(url2check)) {
				winopener = window.open(url);
				winopener.opener = null;
			}
			else {
				var iframeDoc = window.document.getElementById("landing");
				showErrorPage();
				return;			
			}			
		}
		else {
			// link is to a location within current collection
			// First, check if URL needs fixing
			if (url.indexOf("default.html") != -1) {
				if (url.indexOf("helpcontent=") != -1) {
					url = url.substring(0,url.indexOf("/") +1) + url.substring(url.indexOf("helpcontent=") + 12);
					checkTopic(url, function() {
					});
				}
				else {
					url = url.substring(0,url.indexOf("/") +1) + "cover.html";
					goTocTopic(url);
					pageHighlightAndSynch(url);
				}
			}
			else {
				checkTopic(url, function() {
					});
			}
		}

	}
	function openContextTarget(topic,type) {
		if (topic.indexOf("mailto:") != -1) {
			// Need to do special handling for mailto links
			winopener = window.open(topic);
			winopener.opener = null;	
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');		
		}
		// for right-click options to open topic link in new tab or window
		// Only need to check if topic exists if going outside current help system
		// to another help system
		var checkserver = false;
		checkserver = checkServerNames(topic);

		if (checkserver && topic.indexOf("mailto:") == -1) {
			if (UrlExists(topic)) {
				if (type == "tab") {			
					winopener = window.open(topic);
					winopener.opener = null;	
					$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
				}
				if (type == "window") {
					winopener = window.open(topic,newwinName,"height=700,width=1000");
					winopener.opener = null;
					updateName();
					$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');			
				}
			}
			else {
				var iframeDoc = window.document.getElementById("landing");
				showErrorPage();
				return;
			}
		}
		else if (!checkserver && topic.indexOf("mailto:") == -1) {
			if (type == "tab") {			
				winopener = window.open(topic);
				winopener.opener = null;	
				$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
			}
			if (type == "window") {
				winopener = window.open(topic,newwinName,"height=700,width=1000");
				winopener.opener = null;
				updateName();
				$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');			
			}			
		}
	}
	function openControlClickTab(topic) {
		// to open link target in new tab via Ctrl+click
		var httpurl = false;
		if (topic.indexOf("http:") != -1|| topic.indexOf("https:") != -1) {
			httpurl = true;
		}		
		var pdffile = false; 
		if (topic.indexOf(".pdf") != -1) {
			pdffile = true;
		}
		var htmlfile = false;
		if (topic.indexOf(".htm") != -1) {
			htmlfile = true;
		}
		var mailtofile = false;
		if (topic.indexOf("mailto:") != -1) {
			mailtofile = true;
		}
		if ((htmlfile && !pdffile) || httpurl) {
			// for any link to internal or external html file or website

			var checkserver = false;
			checkserver = checkServerNames(topic);
			if (checkserver) {
				// check server is only for links to other help systems or collections on same site
				if (topic.indexOf("/") != 0 && !httpurl) {
					// needed for tile links that go to other help system
					topic = "/" + topic;
				}
				if (UrlExists(topic)) {
					winopener = window.open(topic);
					winopener.opener = null;
				}
				else {
					var iframeDoc = window.document.getElementById("landing");
					showErrorPage();
					return;
				}
			}
			else {
				winopener = window.open(topic);
				winopener.opener = null;			
			}						
		}
		else if (!htmlfile && pdffile && !httpurl) {
			// for any pdf internal file
			checkEnglishNonHtmlLink(topic);		
		}
		else if (mailtofile) {
			winopener = window.open(topic);
			winopener.opener = null;
		}		
		else {
			console.log("Error: no target match for Ctrl click");
		}

	}
	function checkServerNames(topic) {
		var checkserver = false;
		var startroot = window.document.getElementsByTagName('HTML');
		var currenths = startroot[0].parentNode.documentURI;
		currenths = currenths.substring(0, currenths.indexOf("default.html") - 1);
		currenths = currenths.substring(currenths.lastIndexOf("/") + 1);
		var targeths = topic.substring(0, topic.indexOf("default.html") - 1);
		targeths = targeths.substring(targeths.lastIndexOf("/") + 1);
		var currenthost = location.hostname;
		if (currenthost.indexOf(":") != -1) {
			currenthost = currenthost.substring(0,currenthost.indexOf(":"));
		}
		var targethost = "";
		if (topic.indexOf("://") != -1) {
			targethost = topic.substring(topic.indexOf("://") + 3);
			if (targethost.indexOf(":") != -1) {
				targethost = targethost.substring(0,targethost.indexOf(":"));
			}
			if (targethost.indexOf("/") != -1) {
				targethost = targethost.substring(0,targethost.indexOf("/"));
			}	
		}
		else {
			targethost = currenthost;
		}
		if (currenths != targeths && currenthost == targethost) {
			checkserver = true;
		}
		return checkserver;
	}
	function showlinks() {
		// for responsive display of footer depending on window width 
		
		// initialize to enable later footer redisplay
		$("#landing").contents().off("touchstart.links mousedown.links click.links");
		$("#landing").contents().on("touchstart.links mousedown.links click.links", function(e) {
			e.stopPropagation();
			e.preventDefault();
			var target = $(e.target);				
			var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
			if (touchenabled && ((e.type == "mousedown" || e.type == "touchstart") && !target.is('INPUT') && !target.is('svg'))) {
				if ($('#footerlinks').css('display') == 'none' && (!target.is('#doclinks a') && !target.is('#feedbacklink a') && !target.is('#aboutlink button') && !target.is('#productsupport a'))){
					resetFooter();
				}
			}
		});
		$('.two-column div.content.scrollable').off("touchstart.links mousedown.links click.links");
		$('.two-column div.content.scrollable').on("touchstart.links mousedown.links click.links", function(e) {
			e.stopPropagation();
			e.preventDefault();
			var target = $(e.target);				
			var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
			if (touchenabled && ((e.type == "mousedown" || e.type == "touchstart") && !target.is('INPUT') && !target.is('svg'))) {
				if ($('#footerlinks').css('display') == 'none' && (!target.is('#doclinks a') && !target.is('#feedbacklink a') && !target.is('#aboutlink button') && !target.is('#productsupport a'))){
					resetFooter();
				}
			}
		});		
	$('#toolbar, .main .content > .page-container').on('touchstart.links mousedown.links click.links', function(e) {
		if ($('#footerlinks').css('display') == 'none') {
			resetFooter();
		}		
	});
		var phonefooter = $("#footerlinks");
		var doclinks = $("#doclinks");
		var feedbacklink = $("#feedbacklink");
		var productsupport = $("#productsupport");
		var aboutlink = $("#aboutlink");
		var footerdiv = $(".footer-container.no-transition");
		var ulnode = aboutlink.parent().first();
		
		phonefooter.css("display","none");		
		footerdiv.css("height","25%");
		doclinks.css({"margin":"0px","padding":"0px","margin-top":"2px"});
		feedbacklink.css({"margin":"0px","padding":"0px","margin-top":"2px"});
		productsupport.css({"margin":"0px","padding":"0px","margin-top":"2px"});
		aboutlink.css({"margin":"0px","padding":"0px","margin-top":"2px"});
		// changing this to work for all portrait screens
		if (window.innerWidth < window.innerHeight) {
			// general portrait
			doclinks.css({"width":"100%","display":"inline-block","height":"16px"});
			feedbacklink.css({"width":"100%","display":"block","height":"16px"});
			productsupport.css({"width":"100%","display":"block","height":"16px"});
			aboutlink.css({"width":"100%","display":"block","height":"16px"});
			ulnode.css("height","15%");
		}
		if (window.innerWidth < window.innerHeight && window.innerWidth < 671) {
			// small portrait
			ulnode.css("height","100%");
			footerdiv.css("height","max(80px,10%)");
			doclinks.css("vertical-align","top");
			doclinks.css("line-height","14px");
			feedbacklink.css("vertical-align","top");
			feedbacklink.css("display","inline-block");
			feedbacklink.css("line-height","14px");
			ulnode.css('line-height','16px');
			productsupport.css("vertical-align","top");
			productsupport.css("display","inline-block");
			productsupport.css("line-height","14px");
			aboutlink.css("display","inline-block");			
			aboutlink.css("vertical-align","top");
			aboutlink.css("line-height","14px");
			$('button.about').css('margin-top','0px');
		}
		// for small landscape screens
		if (window.innerWidth < 671 && window.innerWidth > window.innerHeight) {
			//landscape
			doclinks.css("display","inline-block");
			feedbacklink.css("display","block");
			productsupport.css("display","block");
			aboutlink.css("display","block");
			footerdiv.css("width","100%");
			footerdiv.css("height","max(80px,20%)");
			//ulnode.css("height","100%");
			$('.help-footer, .help-footer .row, .help-footer .row .full.column').css('height','80px'); 
		}
		/*if (window.innerWidth < 461 && window.innerWidth > window.innerHeight) {
			doclinks.css("display","inline-block");
			feedbacklink.css("display","block");
			productsupport.css("display","block");
			aboutlink.css("display","inline-block");
			footerdiv.css("width","100%");
		}	*/	
	}
	
	function resetFooter() { 
		// hides the popup menu that takes the place of a regular footer in smart phone device
		var phonefooter = $("#footerlinks");
		var doclinks = $("#doclinks");
		var feedbacklink = $("#feedbacklink");
		var productsupport = $("#productsupport");
		var aboutlink = $("#aboutlink");
		var footerdiv = $(".footer-container.no-transition");
		var ulnode = aboutlink.parent().first();
		footerdiv.css({'width':'','height':''});
		doclinks.css({'width':'','margin':'','display':'','padding':''});
		feedbacklink.css({'width':'','margin':'','display':'','padding':''});
		productsupport.css({'width':'','margin':'','display':'','padding':''});
		aboutlink.css({'width':'','margin':'','display':'','padding':''});
		phonefooter.css("display","");
		$('.help-footer, .help-footer .row, .help-footer .row .full.column, .help-footer .row nav ul').css('height','');
		// temporarily keeping following ifs in case resetting all to no value so CSS takes
		// over needs tweaking in some cases
		if (window.innerWidth < 447) {
		}
		if (window.innerWidth < 671 && window.innerWidth > window.innerHeight) {
		}
		if (window.innerWidth < window.innerHeight && window.innerWidth < 671) {
			ulnode.css('line-height','');
		}
		if (window.innerWidth < 448 && window.innerWidth > 376) {
		}
	}
		
	function printPage() {
		// to print what is displayed in content pane
		var iframe = $('#landing')[0]; 
		iframe.contentWindow.focus(); 
		iframe.contentWindow.print();
	}
	
	function buildPDFName(data, bookroot,callback) {
		// To get full path and name of pdf to print, or to check if it exists
		// in order to determine whether print menu option for printing PDF should be shown.
		// Name is stored in from oxyhelp7-pdf.js
		if (data.indexOf(".pdf") == -1) {
			// No pdf file name was in oxyhelp7-pdf.js
			callback(collPdfFilename);
		}
		else {
			var pdfname = data.substring(data.indexOf("dhtmlhelpPdfFilename=") + 22, data.indexOf(".pdf")+4);
			if (varstore.isCollection) {
				collPdfFilename = bookroot + "/" + pdfname;
			}
			else {
				collPdfFilename = pdfname;
			}
			callback(collPdfFilename);
		}
	}
	
	function printPDF(pdffile) {
		// called to display PDF for single map, either only map as in help system
		// or in collection if a map topic is currently active
		var iframeDoc = document.getElementById("landing");
		var pdfjspath = "oxyhelp7-pdf.js";
		var bookroot = "";
		if (pdffile === "" || pdffile === undefined) {
			if (varstore.isCollection) {
				bookroot = $(".booktitle",window.document).first().attr("data-id");
				pdfjspath = bookroot + "/oxyhelp7-pdf.js";
			}
			$.getScript(pdfjspath, function(data, textStatus, jqxhr) {
				if (data.indexOf("dhtmlhelpPdfFilename") !== -1 ) {
					buildPDFName(data, bookroot, function(collPdfFilename) {
						if (!collPdfFilename || collPdfFilename == "") {
							// do nothing, menu item should be hidden by sohoxi code												
						} else if ((collPdfFilename.lastIndexOf(".pdf") != collPdfFilename.length - 4) || collPdfFilename.indexOf("http:") != -1 || collPdfFilename.indexOf("https:") != -1) {
							// filename does not end in .pdf or is attempt to go to other http site
							collPdfFilename = "";
						}						
						else {							
							iframeDoc.src = encodeURI(collPdfFilename);
							if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
								$('.application-menu-trigger').trigger('click');
							}							
						}
					});
				}
			});				
		}
		else {
			//pdf is from list of collection pdfs, path provided by parameter
			iframeDoc.src = encodeURI(pdffile);
		}
								
	}
	function checkpdfjs(pdfjspath,callback) {
		// Checks PDF status and adjusts printpdf button
		var collpdfstatus = false;
		var bookroot = "";
		if (varstore.isCollection) {
			bookroot = $(".booktitle",window.document).first().attr("data-id");
			for (var i = 0; i < titlemap.titlemapping.length; ++i) {
				if (titlemap.titlemapping[i].folder == bookroot && titlemap.titlemapping[i].pdfstatus == true) {						
					collpdfstatus = true;
					break;
				}
			}
		}
		$.getScript(pdfjspath, function(data, textStatus, jqxhr) {
			if (data.indexOf("dhtmlhelpPdfFilename") !== -1 ) {
				buildPDFName(data, bookroot, function(collPdfFilename) {
					if (!varstore.isCollection) {
						if ((!collPdfFilename || collPdfFilename == "") || !pdfStatus) {
							$('button.btn-pdf').addClass('disabled hide-focus');
							$('#printpdf',window.document).addClass('disabled');
							$('.buttonset.pdf, .buttonset.pdf .btn-pdf').css('cursor','default');							
						}
						else if (collPdfFilename != "" && pdfStatus) {
							$('button.btn-pdf').removeClass('disabled');
							$('button.btn-pdf').removeClass('hide-focus');
							$('#printpdf',window.document).removeClass('disabled');
							$('.buttonset.pdf, .buttonset.pdf .btn-pdf').css('cursor','pointer');
						}
						callback(collPdfFilename,collpdfstatus);
					}
					else {
						callback(collPdfFilename,collpdfstatus);
					}					
				});
			}
		});				 	
		//callback(pdfjsexists,collPdfFilename);		
	}		
	function goBack() {
		// applied when back button used
		fromBack = true;
		var backtopic = "";
		var backpage = 0;
		
		if (currpage != 0) {
			// get previous page but avoid trying to go below zero
			backpage = currpage - 1;
		}		
		var backtopicentry = varstore.pagehistory[backpage];
		
		if (backtopicentry == null) {
			return;
		}
		var type = backtopicentry.substring(0,backtopicentry.indexOf("="));
		var iframeDoc = window.document.getElementById("landing");
		if (type == "topic") {
			backtopic = backtopicentry.substring(backtopicentry.indexOf("=")+1);
			if (iframeDoc == null) {
				//probably never gets here
				location.href = backtopic;
				var apptop = parent.document.getElementsByClassName("accordion panel inverse");
				var anchors = apptop[0].querySelectorAll("a");
				var count;
				var topichref = backtopic.substring(0,backtopic.indexOf(".html")+5);
				for (count = 0; count < anchors.length; count++) {
					var anchorhref = anchors[count].getAttribute("data-file");
					if (anchorhref != null) {
						if (anchorhref.indexOf(topichref) != -1) {
							var anchor = anchors[count];
							synchToc(backtopic,function(){
								$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
								if ($(anchor,window.document).parent().is('.accordion-header')) {
									$(anchor,window.document).parent().removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
								}
							});
						}
					}
				}
			}
			else {
				if (backtopic.indexOf("landing.html") != -1) {
					// set title bar to main collection title if user returns to landing page
					iframeDoc.src = backtopic;
					replaceTitle("");
					$('#textToSearch').val('');
					hidesearch();
					$('#textToSearchHS').val('');
					hidesearchHS();	
					collLandingInit();					
				}
				else if (backtopic.indexOf("helperror.html") != -1) {
					// don't bother going back to "help topic not found" page
					return;
				}				
				else {
					iframeDoc.src = backtopic;
					// initialize the topic and synch to toc
					var initoptions = getIsoLang($('html').attr('lang'));
					$('#landing').off('load');
					$('#landing').on('load', function(){
						require(["sohoxi","deliverableCollectionModule"], function (sohoxi,deliverableCollectionModule) {
							if (backtopic.indexOf(".pdf") != -1) {
								// might not need initialization if PDF, but keep this "if" for later adding feedbackmail()
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
							}
							else if (backtopic.indexOf("lib_pdflist") != -1) {
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
								// maybe add feedbackMail()--need to how that get's populated in this case
							}
							else {
								deliverableCollectionModule.enableCrossDeliverableLinks();			
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
								pageHighlightAndSynch(backtopic);
								sendInfoToSmartHelp(backtopic);
								//feedbackMail();
								if (varstore.isCollection) {
									replaceTitle(backtopic);
								}
								backtopic = "";
							}
						});
					});						
				}
				if (backtopic.indexOf("cover.html") != -1) {
					if (varstore.isCollection) {
						// if going to cover.html in collection, then we need to reset title bar to the map title for that cover page
						replaceTitle(backtopic);
						var mapfolder = getMapFolder(backtopic);
						var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').find("a[onclick*='" + mapfolder + "/cover.html']");
						synchToc(backtopic, collBookAnchor, function(){
							$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
							$('.accordion-header',window.document).not('.collection-group').find('a').each(function() {
								var coveranchor = $(this);
								if(coveranchor.attr('onclick') != undefined && coveranchor.attr('onclick').indexOf(backtopic) != -1) {
									coveranchor.parent('.accordion-header').removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
								}
							});
						});						
					}
					else {
						// WHY DO THIS FOR HELP SYSTEM???
						$('#textToSearch').val('');
						hidesearch();						
					}
				}								
			}
		}
		else if (type == "query"){
			//backtopic here is the query string plus other params
			backtopic = backtopicentry.substring(backtopicentry.indexOf("=")+1);
			backtopic = backtopic.substring(0,backtopic.indexOf("page=")-1);
			var filter = "";
			var page = backtopicentry.substring(backtopicentry.indexOf("\&")+6,backtopicentry.indexOf("filter=")-1);
			if (iframeDoc == null) {
				// seems to be not ever getting to this if				
			}
			else {
				if (backtopicentry.indexOf("filter=") != -1) {
					filter = backtopicentry.substring(backtopicentry.indexOf("filter=")+7);
				}
				if (filter !== "") {
					$('#textToSearchHS').val(backtopic);
					$('#textToSearch').val('');
					showsearchHS();
				} else {
					$('#textToSearch').val(backtopic);
					$('#textToSearchHS').val('');
					showsearch();
				}
				SearchToc2(backtopic,true,page,filter);
			}
		}		
		if (currpage != 0) {
			currpage = currpage - 1;
		}
		if (currpage === 0) {
			$('.buttonset.back').addClass('disabled');
		}
		if (currpage < varstore.pagehistory.length - 1) {
			$('.buttonset.forward').removeClass('disabled');
		}
		
		if (type == "topic") {
			feedbackMail();
		}
		if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
			$('.application-menu-trigger').trigger('click');
		}		
		fromBack = false;
	}
	function goForward() {
		// applied when forward button used
		fromBack = true;
		var nexttopicentry = varstore.pagehistory[currpage + 1];
		if (nexttopicentry == null) {
			return;
		}
		var type = nexttopicentry.substring(0,nexttopicentry.indexOf("="));
		var iframeDoc = window.document.getElementById("landing");
		if (type == "topic") {
			nexttopic = nexttopicentry.substring(nexttopicentry.indexOf("=")+1);
			if (iframeDoc == null) {
				location.href = nexttopic;
				var apptop = window.document.getElementsByClassName("accordion panel inverse");
				var anchors = apptop[0].querySelectorAll("a");
				var count;
				var topichref = nexttopic.substring(0,nexttopic.indexOf(".html")+5);
				for (count = 0; count < anchors.length; count++) {
					var anchorhref = anchors[count].getAttribute("data-file");
					if (anchorhref != null) {
						if (anchorhref.indexOf(topichref) != -1) {
							var anchor = anchors[count];
							synchToc(nexttopic, function(){
								$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
								if ($(anchor,window.document).parent().is('.accordion-header')) {
									$(anchor,window.document).parent().removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
								}
							});
						}
					}
				}
			}
			else {
				if (nexttopic.indexOf("landing.html") != -1) {
					iframeDoc.src = nexttopic;
					replaceTitle("");				
					$('#textToSearch').val('');
					hidesearch();
					$('#textToSearchHS').val('');
					hidesearchHS();
					collLandingInit();
				}
				else if (nexttopic.indexOf("helperror.html") != -1) {
					// don't bother going to the "help topic not found" page
					return;
				}
				else {
					iframeDoc.src = nexttopic;
					// initialize the topic and synch to toc
					var initoptions = getIsoLang($('html').attr('lang'));
					$('#landing').off('load');
					$('#landing').on('load', function(){
						require(["sohoxi","deliverableCollectionModule"], function (sohoxi,deliverableCollectionModule) {
							if (nexttopic.indexOf(".pdf") != -1) {
								// might not need initialization if PDF, but keep this "if" for later adding feedbackmail()
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
							}
							else if (nexttopic.indexOf("lib_pdflist") != -1) {
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
								// maybe add feedbackMail()--need to how that get's populated in this case
							}
							else {
								deliverableCollectionModule.enableCrossDeliverableLinks();			
								$('#landing',window.document).contents().find('body').first().initialize(initoptions);
								pageHighlightAndSynch(nexttopic);
								sendInfoToSmartHelp(nexttopic);
								//feedbackMail();
								if (varstore.isCollection) {
									replaceTitle(nexttopic);
								}
								nexttopic = "";
							}
						});
					});						
				}
				if (nexttopic.indexOf("cover.html") != -1) {
					// CHANGE THIS ONE FOR HS MODE TO TRIGGER CLICK ON HOME BUTTON???
					if (varstore.isCollection) {
						replaceTitle(nexttopic);
						var mapfolder = getMapFolder(nexttopic);
						var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').find("a[onclick*='" + mapfolder + "/cover.html']");
						synchToc(nexttopic, collBookAnchor, function(){
							$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
							$('.accordion-header',window.document).not('.collection-group').find('a').each(function() {
								var coveranchor = $(this);
								if(coveranchor.attr('onclick') != undefined&& coveranchor.attr('onclick').indexOf(nexttopic) != -1) {
									coveranchor.parent('.accordion-header').removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
								}
							});
						});	
					}
					else {
						return;						
					}					
				}		
			}
		}
		else if (type === "query"){
			nexttopic = nexttopicentry.substring(nexttopicentry.indexOf("=")+1);
			nexttopic = nexttopic.substring(0,nexttopic.indexOf("page=")-1);
			var filter = "";
			var page = nexttopicentry.substring(nexttopicentry.indexOf("\&")+6,nexttopicentry.indexOf("filter=")-1);
			if (iframeDoc == null) {
				// seems to be not ever getting to this if				
			}
			else {
				if (nexttopicentry.indexOf("filter=") != -1) {
					//NEED TO WORK ON THIS FOR COLLECTIONS, NEEDS CHANGES ???
					filter = nexttopicentry.substring(nexttopicentry.indexOf("filter=")+7);
				}
				if (filter !== "") {
					$('#textToSearchHS').val(nexttopic);
					$('#textToSearch').val('');
					showsearchHS();
				} else {
					$('#textToSearch').val(nexttopic);
					$('#textToSearchHS').val('');
					showsearch();
				} 
				SearchToc2(nexttopic,true,page,filter);			
			}		
		}
		currpage = currpage + 1;
		if (currpage > 0) {
			$('.buttonset.back').removeClass('disabled');
		}
		if (currpage == varstore.pagehistory.length - 1) {
			$('.buttonset.forward').addClass('disabled');
		}
		
		if (type == "topic") {
			feedbackMail();
		}
		if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
			$('.application-menu-trigger').trigger('click');
		}			
		fromBack = false;
	}
  
  function SearchToc2(input, fromback, page, filter) {
	  // called from goSearch and other places, might be able to eliminate goSearch, which is called from sohoxi in 5 places
	  // this is called directly from coll-init.js, main-init.js and functions with inforhelp.js
	$('.busy, .busy-indicator-container').removeClass('is-hidden');
	var query = input;
	collSearchFilter = filter;
	var requestedPage = 1;
	if (page > 1) {
		requestedPage = page;
	}
    // Check browser compatibility
    if (navigator.userAgent.indexOf("Konquerer") > -1) {
        alert(getLocalization(txt_browser_not_supported));
        return;
    }
	var srchtoc2fromback = fromback;
	require(["search"], function (search) {
		var filter2 = "";
		if (varstore.isCollection) {
			if ($('#textToSearchHS').val() != "" && !srchtoc2fromback) {
				filter2 = $(".booktitle").first().attr("data-id");
				collSearchFilter = filter2;
				varstore.globalSearch = false;
			}
			else if (varstore.globalSearch || srchtoc2fromback){
				filter2 = collSearchFilter;
				$(".booktitle").first().attr("data-id", filter2);
				replaceTitle(filter2);
				if (collSearchFilter == "") {
					varstore.globalSearch = true;
				}
			}
		}
		search.searchAndDisplayResults(query, requestedPage, filter2, srchtoc2fromback, function (){
			fromInputEnter = false;
			// to fix weird behavior where pressing Enter to display search results also causes click on first result
			// window.event now throws error, at least in FF				
			//if (window.event.target.tagName == "INPUT" && window.event.keyCode == 13) {
			//	fromInputEnter = true;
			//}
			setTimeout(function () {
				$('.busy, .busy-indicator-container').addClass('is-hidden');
			}, 1000);
			feedbackMail();
		});
		if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
			$('.application-menu-trigger').trigger('click');
		}
		if (filter2 !== "") {
			hideAllSearch(true);
		}
		else {
			hideAllSearch(false);
		}
		
	});
   
	filter = "";
	$('#landing',window.document).focus();
  }
	function synchToc(topic, collBookAnchor, callback)  {
		var apptop = $(".accordion.panel.inverse",window.document);
		var tocAnchor = "";
		var anchorfound = false;
		var topic = topic.toLowerCase();
		if (!varstore.isCollection) { 
			var anchors = apptop.find("a");
			var count;
			var topichref = "";
			topichref = topic.substring(topic.lastIndexOf("/")+1,topic.indexOf(".html")+5);
			anchors.each(function() {
				if (this.hasAttribute('data-file')){
					var onclicktext = this.getAttribute('data-file').toLowerCase();
					var anchorhash = "";
					var basefile = "";
					
					if (onclicktext.indexOf("#") != -1 && topic.indexOf("#") != -1) {
						if (topic.indexOf(onclicktext) != -1) {
							tocAnchor = this;
							expandToAnchor(tocAnchor);
							anchorfound = true;									
						}						
					}
					else if (onclicktext.indexOf("#") != -1 && topic.indexOf("#") == -1) {
						anchorhash = onclicktext.substring(onclicktext.indexOf("#") + 1);
						basefile = topic.substring(topic.lastIndexOf("/") + 1, topic.indexOf(".htm"));
						if (basefile == anchorhash) {
							var newtopic = topic + "#" + anchorhash;
							if (newtopic.indexOf(onclicktext) != -1) {
								tocAnchor = this;
								expandToAnchor(tocAnchor);
								anchorfound = true;									
							}
						}
					}
					else if (onclicktext.indexOf("#") == -1 && topic.indexOf("#") == -1 ) {
						if (topic.indexOf(onclicktext) != -1) {
							tocAnchor = this;
							expandToAnchor(tocAnchor);
							anchorfound = true;								
						}

					}	
					else if (!anchorfound && topic.indexOf("#") != -1 ) {
						basefile = topic.substring(0, topic.indexOf("#"));
						if (onclicktext.indexOf(basefile) != -1) {
							tocAnchor = this;
							expandToAnchor(tocAnchor);
							anchorfound = true;									
						}
					}
				}
				if (anchorfound) {
					return false;
				}
			});	
			callback(tocAnchor);				
		}
		else {
			if (collBookAnchor != "" && collBookAnchor != undefined) {	
				var topanchor = collBookAnchor.parent().find('a');
				var accpaneanchors = collBookAnchor.parent().next('.accordion-pane').find('a');
				var subanchors = topanchor.add(accpaneanchors);

				subanchors.each(function() {
					if (this.hasAttribute('data-file')){
						var onclicktext = this.getAttribute('data-file').toLowerCase();
						var anchorhash = "";
						var basefile = "";
						if (onclicktext.indexOf("#") != -1 && topic.indexOf("#") != -1) {
							if (topic.indexOf(onclicktext) != -1) {
								tocAnchor = this;
								expandToAnchor(tocAnchor);
								anchorfound = true;									
							}						
						}
						else if (onclicktext.indexOf("#") != -1 && topic.indexOf("#") == -1) {
							anchorhash = onclicktext.substring(onclicktext.indexOf("#") + 1);
							basefile = topic.substring(topic.lastIndexOf("/") + 1, topic.indexOf(".htm"));
							if (basefile == anchorhash) {
								var newtopic = topic + "#" + anchorhash;
								if (newtopic.indexOf(onclicktext) != -1) {
									tocAnchor = this;
									expandToAnchor(tocAnchor);
									anchorfound = true;									
								}
							}
						}
						else if (onclicktext.indexOf("#") == -1 && topic.indexOf("#") == -1 ) {
							if (topic.indexOf(onclicktext) != -1) {
								tocAnchor = this;
								expandToAnchor(tocAnchor);
								anchorfound = true;								
							}

						}	
						else if (!anchorfound && topic.indexOf("#") != -1 ) {
							basefile = topic.substring(0, topic.indexOf("#"));
							if (onclicktext.indexOf(basefile) != -1) {
								tocAnchor = this;
								expandToAnchor(tocAnchor);
								anchorfound = true;									
							}
						}
					}
					if (anchorfound) {
						return false;
					}
				});				
			}
			if (anchorfound == false) {
				console.log("No anchor found");
			}
			callback(tocAnchor);
		}
	}
	
	function expandToAnchor(tocAnchor) {
		// used by synchTOC()
		var nodes2expand = [];
		var context = "window.document"; // maybe not needed
		var nodeParent = $(tocAnchor).parent();
		var accPaneParents = nodeParent.parents('.accordion-pane').not('.is-expanded');
		$(accPaneParents.get().reverse()).each(function() {
			$(this).prev('.accordion-header').children('button').first().trigger('click');
		});	
	}
	
	function goTopic(topic, fromSearch, showinframe) {
		var showinframe = showinframe;
		if (showinframe == undefined) {
			showinframe = false;
		}
		var iframeDoc = window.document.getElementById("landing");
		if (topic.indexOf("#") == 0){
			// invalid topic reference sent, don't continue
			return;
		}
		if (topic.indexOf(".html") == -1 && topic.indexOf(".htm") != -1) {
			// change .htm to .html
			topic = topic.replace(".htm",".html");
		}
		if (topic.indexOf("/") == 0) {
			// This assumes that any xref with scope=external that starts with a slash
			// is meant to link to different help system on same server using the 
			// format: "/differentHelpSys/default.html?helpcontent=sometopic.html
			var serverroot = window.location.protocol + '//' + window.location.host;
			if (UrlExists(serverroot + topic)) {
				extopener = window.open(serverroot + topic);
				extopener.opener = null;
				return;	
			}
			else {
				showErrorPage();
				return;
			}					
		}
		if (topic.indexOf("cover.html") != -1 && !varstore.isCollection){
			// if standalone help system, simulate click or Enter key on Home button for links to cover.html
			home(false);
			return;
		}
		// next line is for external http links
		if (topic.indexOf("http:") != -1 || topic.indexOf("https:") != -1) {
			extopener = window.open(topic);
			extopener.opener = null;
			return;
		}
		if (topic.indexOf(".pdf") != -1) {
			if (showinframe) {
				iframeDoc.src = topic;
				//return;				
			}
			else {
				extopener = window.open(topic);
				extopener.opener = null;
				return;				
			}			
		}
		// code below is for if/when we display popup list of multiple topics
		if ($('.overlay')){
			$('.overlay').remove();
			$('body').removeClass('modal-engaged');
			$('#listtopic-modal li').remove();
			$('#listtopic-modal').css('display','none');
		}
		var newtopic = "";
		var currTopicFolder = "";
		var hsContext = false;
		var collSearch = false;	
		var whroot = window.location.pathname;
		var whrootpath = whroot.substring(0,whroot.lastIndexOf("/"));
		var iframeDoc = window.document.getElementById("landing");
		var currRelPath = "";
		
		if (iframeDoc != null) {
			if (!varstore.isCollection) {
				newtopic = calcHistoryPath(topic, whrootpath, fromSearch);
			}
			else if (varstore.isCollection) {
				var mapfolderfound = false;
				var foldercheck = "";
				if (topic.indexOf("landing.html") != -1) {
					newtopic = topic;
				}
				else if (topic.indexOf("/") != -1 && topic.indexOf("..") == -1) {
					foldercheck = topic.substring(0,topic.indexOf("/"));
					for (var i = 0; i < titlemap.titlemapping.length; ++i) {
						if (titlemap.titlemapping[i].folder == foldercheck) {
							currTopicFolder = foldercheck;
							replaceTitle(topic);
							newtopic = topic;							
							mapfolderfound = true;
							break;
						}
					}
					if (!mapfolderfound) {
						// topic value doesn't start with mapfolder, so get map folder from currently displayed topic
						var basetopic = $('#landing',window.document).attr('src');
						var currTopicFolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');	
						newtopic = currTopicFolder + "/" + topic;						
					}
				}
				else if (topic.indexOf("/") == -1 && topic.indexOf("..") == -1) {
					// topic value has no /, thus no map folder, so get from currently displayed topic
					var basetopic = $('#landing',window.document).attr('src');
					var currTopicFolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');					
					if (currTopicFolder == undefined) {
						// this is a case of pre-og38 cover.html probably, so must try to make backwards compatible
						// this assumes a cover.html is currently selected in the TOC
						var currSelected = $('.accordion-header.collection.is-selected').children('a').attr('data-file');
						currTopicFolder = currSelected.substring(0,currSelected.indexOf("/"));
					}						
					newtopic = currTopicFolder + "/" + topic;
				}
				else if (topic.indexOf("..") != -1) {
					// could go here if link is in related topics of topic in subfolder
					newtopic = calcHistoryPath(topic, whrootpath, false);
				}
				if (newtopic.indexOf("cover.html") != -1) {
					if (getIsoLang($('html').attr('lang')).toLowerCase() != "en-us" && $('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us") {
						if ($('#landing').attr('src') != undefined) {
							currRelPath = $('#landing').attr('src');							
							var engMapFolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');					
							if (getMapFolder(newtopic) == "") {
								newtopic = engMapFolder + "/" + newtopic;
							}
						}						
					}
					else if (getIsoLang($('html').attr('lang')).toLowerCase() == "en-us") {
						var mapfolder = getMapFolder(newtopic);
						var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header.collection').find("a[data-file*='" + mapfolder + "/cover.html']");
						synchToc(newtopic,collBookAnchor,function(){
							$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
							$('.accordion-header',window.document).not('.collection-group').not('.collection-link').find('a').each(function() {
								var coveranchor = $(this);
								if(coveranchor.attr('data-file') != undefined && coveranchor.attr('data-file').indexOf(newtopic) != -1 && 
								!coveranchor.parent('.accordion-header').hasClass('collection-link')) {
									coveranchor.parent('.accordion-header').removeClass('hide-focus').addClass('is-focused').addClass('is-selected');
								}
							});
						});
					}
				}
				//following might fail if a currTopicFolder is a substring of another one, maybe add slash after
				var topAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').find('.collection a[data-file]').filter('[data-file*="' +currTopicFolder + '"]');
				if (topAnchor.length > 1) {
					topAnchor.each(function(){
						var onclicktext = $(this).attr('data-file');
						var mapstring = onclicktext.substring(onclicktext.indexOf("'")+1,onclicktext.indexOf("/"));
						if (currTopicFolder == mapstring) {
							topAnchor = $(this);
							return false;
						}
					});
				}
				
				var topButton = topAnchor.parent().find('button').first();
				var topAnchorPane = "";
				if (topAnchor.length != 0) {
					topAnchorPane = topAnchor.parent('.accordion-header').next('.accordion-pane');
				}
				if (topButton.length != 0 && (topAnchorPane == "" || topAnchorPane.children().length == 0)) {
					topButton.trigger('click');
				}
				replaceTitle(newtopic);	
			}
		}
		else if (iframeDoc == null) {
			console.log("iframe2 still not found");
			return;
		}	
		iframeDoc.src = newtopic;
		require(["varstore"], function (varstore) {
			arraycheck = varstore.pagehistory.length;
			if (fromBack == false) {
				if (arraycheck > currpage + 1) {
					varstore.pagehistory.splice(currpage + 1,arraycheck - currpage + 1);
					addHistory("topic=" + newtopic);
				}
				else if (arraycheck == currpage + 1) {
					addHistory("topic=" + newtopic);
				}
			}
		});
		
		if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
			$('.application-menu-trigger').trigger('click');
		}

		// initialize the topic and synch to toc
		var initoptions = getIsoLang($('html').attr('lang'));
		$('#landing').off('load');
		$('#landing').on('load', function(){
			require(["sohoxi","deliverableCollectionModule"], function (sohoxi,deliverableCollectionModule) {
				deliverableCollectionModule.enableCrossDeliverableLinks();			
				$('#landing',window.document).contents().find('body').first().initialize(initoptions);
				if (newtopic.indexOf(".pdf") == -1 && newtopic != "" && ((newtopic.indexOf("landing.html") == -1 && varstore.isCollection) || !varstore.isCollection)) {
					pageHighlightAndSynch(newtopic);
				}				
				feedbackMail();
				hideAllSearch(true);
				sendInfoToSmartHelp(newtopic);
				
				// try scrolling to section within a topic only on load
				let checkcurrent = "";
				let currValue = "";
				try {
					checkcurrent = varstore.pagehistory[currpage];
					currValue = checkcurrent.substring(checkcurrent.indexOf("=")+1);
					if (currValue.indexOf("#") != -1) {
						currValue = currValue.substring(0,currValue.indexOf("#"));
						if (newtopic.indexOf("#") != -1 && newtopic.indexOf(currValue) != -1) {
							var elementid = newtopic.substring(newtopic.indexOf("#"));
							checkAnchorID(elementid, function(idexists,existingID) {
								if (idexists) {
									// scroll to anchor id within topic
									var elmnt = $('#landing',window.document).contents().find('' + existingID + '');
									elmnt[0].scrollIntoView(true);
									//elmnt[0].scrollIntoView({ behavior: 'smooth', block: 'end', inline: 'nearest' });
									let elmntVisible = isScrolledIntoView(elmnt[0]);
									if (!elmntVisible) {
										adjustTopicScroll(existingID);
									}
								}
								else {
									// do nothing, neither regular or alternative id exists in topic
								}
							});
						}					
					}				
				}
				catch (e) {
					console.log("goTopic scroll Error=" + e);
				}								
				newtopic = "";
			});
		});	
		// hide busy indicator after loading topic from helpcontent parameter
		setTimeout(function () {
			$('.busy, .busy-indicator-container').addClass('is-hidden');
		}, 1000);
	}
	function sendInfoToSmartHelp(topic) {
		let toolbarState = $('#toolbarColl').css('display');
		if ($('html.smarthelp').hasClass('showbar')) {
			toolbarState = "visible";
		}
		else if ($('html.smarthelp').hasClass('hidebar') || $('html.smarthelp').attr('class') == undefined) {
			toolbarState = "hidden";
		}
		let startpage = "default.html";
		var startroot = window.document.getElementsByTagName('HTML');
		var whpath = startroot[0].parentNode.documentURI;
		if (whpath.indexOf("?") != -1) {
			whpath = whpath.substring(0,whpath.lastIndexOf("?"));   
		}
		if (whpath.indexOf("#") != -1) {
			whpath = whpath.substring(0,whpath.lastIndexOf("#"));
		}
		whpath = whpath.substring(0,whpath.lastIndexOf("/")+1);
		var serverroot = window.location.protocol + '//' + window.location.host;
		if (topic.indexOf("query=") == -1) {
			// this is a topic not a search query
			if (topic.indexOf("?hl") != -1) {
				topic = topic.replace("?hl", "&hl");
			}				
			topic = whpath + startpage + "?helpcontent=" + topic + "&sh=0";
		}
		else {
			// search query url (default.html?searchQuery=user&filter=&page=1)
			let searchparams = topic.substring(6);
			topic = whpath + startpage + "?searchQuery=" + searchparams + "&sh=0";
		}
		if (window.top !== window.self) {
			
		  let referrer = document.referrer;
		  if (referrer.indexOf("infor.com") !== -1 || referrer.indexOf("inforcloudsuite.com") !== -1) {
			window.parent.postMessage(
			
			// Serialize the message
			JSON.stringify({
			  topic: topic,
			  toolbarState: toolbarState
			}),
			referrer
		        );
		  }
		}
	}
	function checkAnchorID(elemid,callback) {
		let idexists = false;
		let rawid = elemid.substring(1);
		let existingID = "";
		let elmnt = $('#landing',window.document).contents().find('' + elemid + '');
		if (elmnt.length != 0) {
			// URL id matches regular id
			idexists = true;
			existingID = elemid;
			callback(idexists, existingID);
		}
		else {
			// look for alternative ids
			let altelems = $('#landing',window.document).contents().find('[data-alt-ids]');
			if (altelems.length > 0) {
				for (let elem of $(altelems)) {
					if ($(elem).attr('data-alt-ids').includes(rawid)) {						
						if ($(elem).attr('id') !== "") {
							// return associated regular id
							existingID = "#" + $(elem).attr('id');
							idexists = true;
							callback(idexists, existingID);
						}
						else {
							// no regular id to return
							callback(idexists, existingID);
						}
					}
				}
			}
			else {
				// no alternative ids to search through
				callback(idexists, existingID);
			}
		}
	}
	
	function isScrolledIntoView(elem)
	{
		var docViewTop = $('#landing',window.document).contents().find('.wh_content_area').scrollTop();
		var docViewBottom = docViewTop + $('#landing',window.document).contents().find('.wh_content_area').height();
		var elemTop = $(elem).offset().top;
		var elemBottom = elemTop + $(elem).height();
		return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
	}	
	function adjustTopicScroll(elmnt) {
		// try one time to scroll content down, assumes it's hidden above top of content pane
		let docViewTop = $('#landing',window.document).contents().find('.wh_content_area').scrollTop();
		let elemTop = elmnt.offset().top;
		if (elemTop < 70) {
			elmnt.offset().top = elemTop + 70;
		}
	}
	function calcHistoryPath(topic, whrootpath, fromSearch) {
		// formulates a full path for topic values containing ../. This is needed when a topic and its path
		// is added to the history
		var whrootpath = whrootpath;
		//init currRelPath to blank string since on URL calls to a topic iframe.src is not set yet
		var currRelPath = "";
		var map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
		var pathTopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');

		if (map != undefined && pathTopic != undefined) {
			if (varstore.isCollection) {
				currRelPath = map + "/" + pathTopic;
			}
			else {
				currRelPath = pathTopic;
			}
		}
		var newpath = "";
		if (currRelPath.indexOf("/") != -1) {
			 //this removes the filename from currRelPath if path is, e.g., help/abc/xyz.html
			 currRelPath = currRelPath.substring(0,currRelPath.lastIndexOf("/")+1);
		}
		if (topic.indexOf("..") != -1) {
			 // this removes the appropriate folders from the currRelPath based on number
			 // of .. in target link
			var count = getFrequency(topic,"..");
			topic = topic.substring(topic.lastIndexOf("..")+2);
			currRelPath = currRelPath.substring(0,currRelPath.lastIndexOf("/"));
			for (var i = 0; i<count; i++) {
				if (currRelPath.indexOf("/") == -1){
					currRelPath = "";
				}
				else {
					currRelPath = currRelPath.substring(0,currRelPath.lastIndexOf("/"));
				}
			}
			newpath = currRelPath + topic;
			if (newpath.indexOf("/") == 0 ){
				newpath = newpath.substring(1);
			}
			return newpath;
		 }
		 else if (currRelPath == "/" ){				
				currRelPath = "";
		 }
		// SAVE code below for collection testing, but currently not doing anything
		var pathcount = getFrequency(currRelPath,"/");
		var topiccount = getFrequency(topic,"/");
		if (pathcount == topiccount) {	
			currRelPath = "";
		}
		else if (pathcount > topiccount && fromSearch && !varstore.isCollection) {
			currRelPath = "";	
		}
		else if (pathcount > topiccount && !fromSearch) {
			for (var t = 0; t < topiccount +1; t++) {
				currRelPath = currRelPath.substring(0,currRelPath.lastIndexOf("/"));
			}
			currRelPath = currRelPath + "/";
		}
		newpath = topic;
		return newpath; 
	 }  
	function getFrequency(string, character) {
		// utility function to get count of a character
		var count = 0;
		for (var i=0; i<string.length+2;i++) {
			if (string.indexOf(character) != -1){
				count++;
				string = string.substring(string.indexOf(character) + character.length);
			}
		}
		return count;
	}
	function applySmartHelpStyles(tbarParam) {
		// re-style the help system to show in SmartHelp iframe
		$('html').addClass('smarthelp');
		$('#landing',window.document).contents().find('html').first().addClass('smarthelp');		
		if (!tbarParam || tbarParam == undefined || tbarParam === "" || tbarParam == "false") {
			$('html').addClass('hidebar');
			$('html').removeClass('showbar');
		}
		else if (tbarParam || tbarParam == "true") {
			$('html').addClass('showbar');
			$('html').removeClass('hidebar');
		}		
}
	function updateName() {
		// used to ensure unique name for windows if multiple windows are opened via right-click options
		newwinName = newwinName.substring(0,6) + winCounter.toString();
		winCounter = winCounter + 1;	
	}
	
	function disableBrowserContextMenu(e) {
		// utility method to turn off browser context menus
	  e.stopPropagation();
	  e.preventDefault();
	  return false;
	}

	function getButtonStatus(collheaderbtn,callback) {
		// utility function to check if buttons have been added to TOC, thus proving TOC is loaded/initialized for a map
		var currBtnStatus = window.buttonInitStatus;		
		callback(currBtnStatus);
	}

	function getMapFolder(topic) {
		// utility function to get valid map folder or else return blank value 
		var mapFolder = "";
		if (titlemap.titlemapping.length === 0) {
			console.log("Error: titlemap.titlemapping is 0");
		}
		else {
			for (i = 0; i < titlemap.titlemapping.length; i++) {
				var testfolder = titlemap.titlemapping[i].folder;
				var testlength = testfolder.length;
				var topicmaplength = topic.substring(0,topic.indexOf("/")).length;
				if (topic.indexOf(testfolder) != -1 && testlength == topicmaplength) {
					mapFolder = topic.substring(0,topic.indexOf("/"));
				}					
			}
		}
		return mapFolder;
	}

	 function checkForInvalidChars(string) {
		// utility function to cleanup title text
		var string = string;
		var pattern = new RegExp(/[~`!#$%\^&*+=\[\]\\';,{}|\\":<>\?]/); //unacceptable chars
		if (pattern.test(string)) {
			return false;
		}
		return true; //valid string for topic, etc.
	}	
/* URL RELATED FUNCTIONS *************************************** */
	function processParameters(callback) {
		//get, parse, and clean URL 
		var dsearch = document.location.search + '',
			hashid = document.location.hash + '';
		if (hashid == "") { 
			if (dsearch.indexOf("%5E") != -1 || dsearch.indexOf("%5e") != -1) {
				dsearch = dsearch.replace(/%5E/i,"#");
				hashid = dsearch.substring(dsearch.indexOf("#"));
			}
		}
		if (hashid.indexOf("&amp;amp;") != -1) {
			hashid = hashid.substring(0,hashid.indexOf("&amp;amp;"));
		}
		if (hashid.indexOf("&") != -1) {
			hashid = hashid.substring(0,hashid.indexOf("&"));
		}
		if (hashid.indexOf(".") != -1 && getParam("helpcontent",dsearch) !== "") {
			hashid = hashid.split(".").join("_");
		}
		if (hashid.indexOf("$") != -1) {
			hashid = hashid.split("$").join("_");
		}
		hashParam = hashid.toLowerCase();
		contentParam = getParam("helpcontent",dsearch);	
		searchParam = getParam("searchQuery",dsearch);
		pageParam = getParam("page",dsearch);
		filterParam = getParam("filter",dsearch);
		hlParam = getParam("hl",dsearch);
		tocParam = getParam("toc",dsearch);
		shParam = getParam("sh",dsearch);
		toolbarParam = getParam("toolbar", dsearch);
		if (tocParam == "" || tocParam == undefined) {
			tocParam = "show";
		}
		callback(contentParam, searchParam, pageParam, filterParam, hlParam, hashParam, tocParam, shParam, toolbarParam);
	}

function getParam(paramName, fullHref) {
	if (fullHref == "") {
		return "";
	} 
	// remove the question mark
	var hasHash = (fullHref.indexOf("#")>0)? true : false,
		halfs = fullHref.split("\?");
				
    if (halfs.length!=2) { 
		return "";
	}
		
	var querystring = halfs[1],
			anchor = "",
			halfs2 = "";
	
	/* preserve the anchor */
	if (hasHash) {
		halfs2 = querystring.split("#");
		querystring = halfs2[0];
    }
		
	var arg = (querystring.split("&")),
			i = 0,
			arg_values = "",
			AccentCirconflexe = "";
		
    for (i=0; i < arg.length; i++) {
        arg_values = arg[i].split("=");
		// 2012-06-28 changed unescape to decodeURIComponent
		// to be able to have proper utf-8 characters
        if (decodeURIComponent(arg_values[0]) == paramName) 
        {
        	var ret = decodeURIComponent(arg_values[1]);
        	// To be able to: http://example.com/myhelp.default.html?helpcontent=my/path/page.html^innersectionid
        	AccentCirconflexe = ret.split("^");
        	if (AccentCirconflexe.length > 1) 
        	{
        		ret = AccentCirconflexe[0] + "#" + AccentCirconflexe[1];
        	}
          return ret;
        }
    }
    return "";
}
	function UrlExists(url)
	{
		var http = new XMLHttpRequest();
		http.open('HEAD', url, false);
		http.send();
		return http.status!=404;
	}
	function checkHashId(topicid,iframedoc,callback) {
		// this function called from main-init.js or coll-init.js if regex url used
		var topicFile = "";
		var topicNbr = "";
		if (!varstore.fallback) {
			// that is, just coming in from coll-init or main-init for any language, English or otherwise
			firstloop:
			for (var i = 0; i < jsonfileContents.length; i++ ) {
				var idlist = jsonfileContents[i].ids;				
				for (var key in idlist) {
					if (key.toLowerCase() == topicid) {
						topicNbr = idlist[key];
						break firstloop;
					}
				}			
			}
			if (topicNbr !== "" ) {
				getTopicFromNbr(topicNbr,function(topic) {
					topicFile = topic;
				});			
			}
			else {
				console.log("Warning: no topic number found");
				// do fallback if non-English help
				if (getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
					getBuildVersion(function(whroot,buildversion) {
						getEnglishModuleJsPath(whroot,buildversion,function(jsonfile) {
							loadFullJSON(jsonfile,function(response) {
								buildJsonEnArray(response, function(){
									varstore.fallback = true;
									checkEnglishHashId(topicid,iframedoc,function(topicfile) {
										displayEnglishTopic(topicfile,"");
									});	
								});
							});							
						});
					});					
				}
			}			
		}			
		callback(topicFile);
	}
	function getBuildVersion(callback) {
		var startroot = window.document.getElementsByTagName('HTML'); 
		var whroot = startroot[0].parentNode.documentURI;
		if (whroot.indexOf("?") != -1) {
			whroot = whroot.substring(0,whroot.lastIndexOf("?"));
		}
		if (whroot.indexOf("#") != -1) {
			whroot = whroot.substring(0,whroot.lastIndexOf("#"));
		}
		whroot = whroot.substring(0,whroot.lastIndexOf("/")+1);
		var lang = getIsoLang($('html').attr('lang')).toLowerCase();
		whroot = whroot.substring(whroot.indexOf(lang) + 5);
		var fileversionpath = "../../en-us" + whroot + "buildVersion.txt";
		// need to get file version number in order to find module js file
		$.ajax({
			url : fileversionpath,
			dataType: "text",
			success : function (data) {
				callback(whroot,data);
			},
			statusCode: {
				404: function() {
				  callback(whroot,"");
				}
			  }
		});
	}
	function getEnglishModuleJsPath(whroot,buildVersion,callback) {
		var modulepath = "../../en-us" + whroot + "module" + buildVersion + ".js";
		callback(modulepath);	
	}
	function checkEnglishHashId(topicid,iframedoc,callback) {
		var topicFile = "";
		var topicNbr = "";

		if (varstore.fallback) {
			// need to check for fallback English topic 
			secondloop:
			for (var i = 0; i < jsonfileEnContents.length; i++ ) {
				var idlist = jsonfileEnContents[i].ids;				
				for (var key in idlist) {
					if (key.toLowerCase() == topicid) {
						topicNbr = idlist[key];
						break secondloop;
					}
				}			
			}
			if (topicNbr != "") {
				getTopicFromNbr(topicNbr,function(topic) {
					topicFile = topic;
				});			
			}
			else {
				console.log("Warning: no topic number found in English");				
			}
		}	
		else {
			console.log("Warning: fallback set to false incorrectly");
		}
		callback(topicFile);
	}
	// used by coll-init.js
	function getCxRegex(callback) {
		let csregex = "";
		for (var i = 0; i < jsonfileContents.length; i++ ) {
			csregex = jsonfileContents[i].cxRegex;
		}
		if (csregex === "" || csregex == null) {
			console.log("Error: Regular expression expected but none provided in module.js");
		}
		callback(csregex);
	}	
function getTopicFromNbr(topicNbr,callback){
	// For use with regex type URL requests, where an id is passed to checkHashId
	var topicFile = "";
	if (!varstore.fallback) {
		for (var i = 0; i < jsonfileContents.length; i++ ) {
			var pathentries = jsonfileContents[i].entries;
			for (var key in pathentries) {
				if (key == topicNbr) {
					var obj = pathentries[key];
					thirdloop:
					for (var prop in obj) {
						if (prop == "path"){
							topicFile = obj[prop];
							break thirdloop;						
						}
					}
					continue;
				}			
			}			
		}		
	}
	else if (varstore.fallback) {
		for (var i = 0; i < jsonfileEnContents.length; i++ ) {
			var pathentries = jsonfileEnContents[i].entries;
			for (var key in pathentries) {
				if (key == topicNbr) {
					var obj = pathentries[key];
					fourthloop:
					for (var prop in obj) {
						if (prop == "path"){
							topicFile = obj[prop];
							break fourthloop;						
						}
					}
					continue;
				}			
			}			
		}		
	}
	callback(topicFile);
}
function getID(hashid, csregex) {
	// used in main-init.js and coll-init.js
	hashid = decodeURIComponent(hashid);
	var regex = new RegExp(csregex);
	var results = regex.exec(hashid);
	var topicid = "";
	if (results == null) {
		topicid = "";
		return topicid;
	}
	else {
		if (csregex == '^#.id=([0-9]+)[^0-9]*$') {
			topicid = results[0].substring(results[0].indexOf("<id=") + 4, results[0].indexOf(">>"));
		}
		else if (csregex == '^#([0-9]+)$') {
			topicid = results[0].substring(results[0].indexOf("#") + 1);
		}
		else if (csregex == '^#topicid=([A-Za-z0-9_]+)$'){
			topicid = results[0].substring(results[0].indexOf("#") + 9);
		}
		else if (csregex == '^#([A-Za-z0-9]+)$') {
			topicid = results[0].substring(results[0].indexOf("#") + 1);
		}
		else if (csregex == '^#([A-Za-z0-9_]+)$') {
			topicid = results[0].substring(results[0].indexOf("#") + 1);
		}
		else if (csregex == '^#([A-Za-z0-9_\.]+)$') {
			topicid = results[0].substring(results[0].indexOf("#") + 1);
		}		
		else {
			// no match for regular exppression
			if (csregex !== "") {
				console.log("Error: The regular expression provided is not supported");
			}
			if (csregex === "") {
				console.log("Error: Regular expression expected but none provided in default.html");
			}			
			topicid = "";
		}
	}
	return topicid;
}

function getIsoLang(langattr) {
	// ensures consistent language codes
	if (langattr.length == 5) {
		var lang1 = langattr.substring(0,2);
		var lang2 = langattr.substring(3).toUpperCase();
		langattr = lang1 + "-" + lang2;
		return langattr;
	}
	else if (langattr.length == 2) {
		switch (langattr) {
			case "af":
			    langattr = "af-ZA";
				break;
			case "ar":
				// must be ar-AR instead of ar-EG for Soho controls
				langattr = "ar-AR";
				break;
			case "bg":
				langattr = "bg-BG";
				break;
			case "cs":
				langattr = "cs-CZ";
				break;
			case "da":
				langattr = "da-DK";
				break;				
			case "de":
				langattr = "de-DE";
				break;	
			case "el":
			    langattr = "el-GR";
				break;
			case "es":
				langattr = "es-ES";
				break;
			case "et":
			    langattr = "et-EE";
				break;
			case "fi":
			    langattr = "fi-FI";
				break;
			case "fr":
				langattr = "fr-FR";
				break;
			case "he":
			    langattr = "he-IL";
				break;
			case "hi":
			    langattr = "hi-IN";
				break;
			case "hr":
				langattr = "hr-HR";
				break;
			case "hu":
			    langattr = "hu-HU";
				break;
			case "it":
				langattr = "it-IT";
				break;
			case "ja":
				langattr = "ja-JP";
				break;
			case "ko":
				langattr = "ko-KR";
				break;
			case "lt":
			    langattr = "lt-LT";
				break;
			case "lv":
			    langattr = "lv-LV";
				break;
			case "nl":
				langattr = "nl-NL";
				break;
			case "nb":
				langattr = "nb-NO";
				break;
			case "no":
				langattr = "no-NO";
				break;
			case "pl":
			    langattr = "pl-PL";
				break;
			case "pt":
				langattr = "pt-BR";
				break;
			case "ro":
			    langattr = "ro-RO";
				break;
			case "ru":
				langattr = "ru-RU";
				break;
			case "sl":
			    langattr = "sl-SI";
				break;
			case "sk":
			    langattr = "sk-SK";
				break;
			case "sv":
				langattr = "sv-SE";
				break;
			case "th":
			    langattr = "th-TH";
				break;
			case "tr":
			    langattr = "tr-TR";
				break;
			case "uk":
				langattr = "uk-UA";
				break;
			case "vi":
			    langattr = "vi-VN";
				break;
			case "zh":
				langattr = "zh-CN";
				break;				
			default:
				langattr = "en-US";
		}
	}
	else {
		langattr = "en-US";
	}
	return langattr;
}
	
	function replaceTitle (topic) {
		// replaces the title in the blue bar to title of current map
		if (!checkForInvalidChars(topic)) {
			return;
		}
		else {
			var olhdir = "";
			if (topic.indexOf("/") != -1) {
				olhdir = topic.substring(0,topic.indexOf("/"));
			}	
			else {
				olhdir = topic;
			}
			var found = false;
			loopexit:
			for (i = 0; i < titlemap.titlemapping.length; i++) {
				if (titlemap.titlemapping[i].folder == olhdir) {
					$(".booktitle",window.document).first().text(titlemap.titlemapping[i].title);
					$(".booktitle",window.document).first().attr("data-id",olhdir);
					if (window.innerWidth < 767) {
						// hide collection title if showing map title on narrow screen
						$('div.titlebar h1').css('display','none');
						$('header .titlebar h2.booktitle',window.document).css('max-width','95%');
					}
					else {
						$('header .titlebar .divider').css('display','inline-block');
						$('header .titlebar h1').css('max-width','40%');
						$(".booktitle",window.document).css('max-width','');
					}
					found = true;
					break loopexit;
				}
			}
			if (!found) {
				//reset title bar to collection title if topic has no folder associated with it
				showCollectionTitle();	
				$('.searchselect-button svg.icon.dropdown',window.document).css('display','none');
				$('button.btn-icon.searchselect-button',window.document).css('cursor','default');			
				$('div.titlebar h1').css('display','');
				$('div.titlebar h1').css('max-width','');
				$(".booktitle",window.document).first().attr("data-id","");
				$(".booktitle",window.document).first().html("");
			}
			else {
				$('.searchselect-button svg.icon.dropdown',window.document).css('display','inline-block');
				$('button.btn-icon.searchselect-button').css('display','inline-block');
				$('button.btn-icon.searchselect-button').css('cursor','pointer');				
			}
		}
	}

function feedbackMail() {
	// sets the subject line and text for email to be sent to documentation@infor.com
	let currTopic = "";
	try {
		if (currpage !== "" && currpage !== -1) {
			currTopic = varstore.pagehistory[currpage];	
		}
	}
	catch (e) {
		console.log("Error=" + e);
	}	
	var topictitle = $('#landing',window.document).contents().find('h1').first().text();
	var product = $("#about-trigger",window.document).attr("data-product-name");
	let currValue = "";
	if (currTopic !== "") {
		currValue = currTopic.substring(currTopic.indexOf("=")+1);
	}
	if (currValue.indexOf(".pdf") != -1) {
		if (varstore.isCollection) {
			let mapFolder = currValue.substring(0,currValue.indexOf("/"));
			loopexit:
			for (i = 0; i < titlemap.titlemapping.length; i++) {
				if (titlemap.titlemapping[i].folder == mapFolder) {
					topictitle = titlemap.titlemapping[i].title;
					break loopexit;
				}
			}			
		}
		else {
			topictitle = product;
		}
	}
	var hrefvalue = "";
	var bodycontent = "";
	var referenceid = $("#inforFeedback",window.document).attr("data-id");
	var subject = "";	
	var iframeSrc = window.document.getElementById("landing").src;
	if (iframeSrc.indexOf("helperror.html") != -1) {
		// special handling for error page
		subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product) + encodeURIComponent(", Error page");
		bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0AFile Name: helperror.html" + 
	    "%0D%0AHelp System Reference ID: " + referenceid;
		hrefvalue = subject + bodycontent;		
	}	
	else {
		try {
			if (currpage !== "" && varstore.pagehistory[currpage] !== undefined) {
				currTopic = varstore.pagehistory[currpage];	
			}
			else if (varstore.pagehistory[currpage] == undefined) {
				if (varstore.isCollection) {
					varstore.pagehistory[0] = "topic=landing.html";
					currpage = 0;
					currTopic = varstore.pagehistory[currpage];
				}
				else {
					varstore.pagehistory[0] = "topic=cover.html";
				}
			}
		}
		catch (e) {
			console.log("Error=" + e);
		}
		// set a default page type
		var pagetype = "topic";
		if (currTopic.indexOf("=") != -1) {
			pagetype = currTopic.substring(0,currTopic.indexOf("="));
		}
		if (pagetype == "topic") {
			if (currValue == "cover.html" || currValue == "landing.html") {
				subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product) + encodeURIComponent(", Start page");
				bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0AFile Name: " + 
				currValue + "%0D%0AHelp System Reference ID: " + referenceid;
				hrefvalue = subject + bodycontent;
			}
			else {
				subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product) + encodeURIComponent(", ") + encodeURIComponent(topictitle);
				bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0ATopic title: " + topictitle + "%0D%0AFile Name: " + currValue + "%0D%0AHelp System Reference ID: " + referenceid;
				hrefvalue = subject + bodycontent;
			}
		}
		else if (pagetype == "query") {
			currValue = currValue.substring(0, currValue.indexOf("&"));
			subject = "mailto:documentation@infor.com?Subject=Help System Feedback for " + encodeURIComponent(product + ", search: " + currValue);
			bodycontent = "&body=" + "%0D%0A%0D%0A%0D%0A%0D%0AProduct: " + product + "%0D%0ASearch query: " + currValue + "%0D%0AHelp System Reference ID: " + referenceid;
			hrefvalue = subject + bodycontent;
		}		
	}
	mailhref = hrefvalue;
}
function sendMailto(dataid) {
	window.location.href = dataid;
}
function sendMail() {
	// used in sohoxi to trigger sending of feedback mail
	window.location.href = mailhref;
}

//various functions for collection landing page:
function handleTitleClick(e){
	var target = $(e.target);
	var tilespan = $('#landing',window.document).contents().find('.wh_tile_title > span > a');
	if (tilespan.is(target)){
		// display .hslist ul as a popupmenu
		var tileshortdesc = target.closest('span').closest('.wh_tile_title').next('.wh_tile_shortdesc');
		tileshortdesc.find('.hslist').addClass('is-open');
		tileshortdesc.find('.hslist').find('li').first().addClass('is-focused');
		tileshortdesc.find('.hslist').find('li').first().find('a').focus();
		// figure out positioning
		var titletext = tilespan.html();
		var titlewidth = tilespan.width();
		let span = document.createElement('span');
		span.append(document.createTextNode(titletext));
		span.style.display = "inline-block";
		document.body.append(span);
		let textlength = span.offsetWidth;
		span.remove();
		var titleOffset = target.offset();
		var left = titleOffset.left;
		var top = titleOffset.top;
		var newleft = left - 30 + (titlewidth - tileshortdesc.width()) / 2;
		var newtop = top + 15;
		// calculcate top offset for popupmenu
		var bodyHt = $('#landing',window.document).contents().find('.wh_main_page').height();
		var spaceCheck = bodyHt - top - 20;
		// adjust max height of hslist elements for small vertical space
		if (bodyHt < 400) {
			$('#landing',window.document).contents().find('.hslist').css('max-height','200px');
			$('#landing',window.document).contents().find('.hslist2').css('max-height','180px');
			$('#landing',window.document).contents().find('.hslist2').css('max-height','160px');
		}
		var hslistht = $('#landing',window.document).contents().find('.hslist').height();
		var hslistht2 = $('#landing',window.document).contents().find('.hslist2').height();
		if (spaceCheck < hslistht ) {
			newtop = top - (hslistht - spaceCheck);
		}			
		target.closest('span').closest('.wh_tile_title').next('.wh_tile_shortdesc').find('div.popupmenu-wrapper').css('left',newleft);
		target.closest('span').closest('.wh_tile_title').next('.wh_tile_shortdesc').find('div.popupmenu-wrapper').css('top',newtop);			
		target.closest('span').closest('.wh_tile_title').next('.wh_tile_shortdesc').find('div.popupmenu-wrapper').css('z-index','9001');
		// need eventually to calculate based on available window screen space also, using height and width of popup, curr title pos, and screen dimensions
		if ($('html').attr('dir') == "rtl" && $('html').hasClass('is-firefox')) {
			var offset = -(window.pageXOffset);
			window.scrollBy(offset + 7, 0);
		}
	}
	else if ($('#landing',window.document).contents().find(".wh_tile_shortdesc .hslist > li > a").is(target)) {
		target.parent('li').find('.hslist2').css('display', 'block');
		target.parent('li').find('.hslist2').addClass('is-open');
		target.parent('li').find('.hslist2').find('li').first().addClass('is-focused');
		target.parent('li').find('.hslist2').find('li').first().find('a').first().focus();
	}
	else if ($('#landing',window.document).contents().find(".wh_tile_shortdesc .hslist2 > li > a").is(target)) {
		target.parent('li').find('.hslist3').css('display', 'block');
		target.closest('span').closest('.wh_tile_title').next('.wh_tile_shortdesc').find('.hslist2').addClass('is-open');
		$('.hslist3').find('li').first().addClass('is-focused');
		$('.hslist3').find('li').first().find('a').first().focus();			
	}
}
function repositionPopup() {
	var tileTitleOffset = $('#landing',window.document).contents().find('.hslist.is-open').closest('.popupmenu-wrapper').closest('.wh_tile_shortdesc').prev('.wh_tile_title').offset();
	var tileTitleTop = tileTitleOffset.top;
	var tileTitleLeft = tileTitleOffset.left;
	var newleft = tileTitleLeft + 35;
	var newtop = tileTitleTop + 30;
	var winHeight = $(window).height();
	var popupHeight = $('.hslist.is-open').closest('.popupmenu-wrapper').height;
	if (tileTitleTop + 40 + popupHeight > winHeight) {
		var newtop = winHeight - popupHeight - 40;
	}
	$('#landing',window.document).contents().find('.hslist.is-open').closest('div.popupmenu-wrapper').css('left',newleft);
	$('#landing',window.document).contents().find('.hslist.is-open').closest('div.popupmenu-wrapper').css('top',newtop);		
}
function handleLandingListEnter(e,key) {
	if (key === 0) {
		// This is a case of a mouseenter, not really any key press
		var li = $(e.target).parent();
		li.parent().children('li').removeClass('is-focused');
		li.addClass('is-focused');		
	}
	else if (key === 9 ) {
		// tab key
		if (!e.shiftKey) {
			if ($(e.target).next('ul.popupmenu').length != 0) {
				var li = $(e.target).next('ul.popupmenu').children('li');
				li.removeClass('is-focused');
				li.first().addClass('is-focused');			
			}
			else if ($(e.target).next('ul.popupmenu').length == 0) {
				var li = $(e.target).parent('li').parent('ul.popupmenu').children('li');
				li.removeClass('is-focused');
				if ($(e.target).parent('li').next('li').length != 0) {
					$(e.target).parent('li').next('li').addClass('is-focused');	
				}
				else if ($(e.target).parent('li').next().length == 0) {
					handleLandingListLeave(e);
				}
			}
		}
		else {
			if ($(e.target).prev('ul.popupmenu').length != 0) {
				var li = $(e.target).prev('ul.popupmenu').children('li');
				li.removeClass('is-focused');
				li.first().addClass('is-focused');			
			}
			else if ($(e.target).prev('ul.popupmenu').length == 0) {
				var li = $(e.target).parent('li').parent('ul.popupmenu').children('li');
				li.removeClass('is-focused');
				if ($(e.target).parent('li').prev('li').length != 0) {
					$(e.target).parent('li').prev('li').addClass('is-focused');	
				}
				else if ($(e.target).parent('li').prev().length == 0) {
					handleLandingListLeave(e);
				}
			}			
		}
	}

}
function handleLandingListLeave(e) {
	let key = e.which;
	if ($('#landing',window.document).contents().find('#item-a').attr('data-file') != "") {
		return;
	}
	let leavingListOne = $(e.target).parent().parent().hasClass('hslist') && $(e.target).parent().is($(e.target).parent().parent().children('li:last-child')) && $(e.target).parent().parent().find('.hslist2').length == 0;

	$('#landing',window.document).contents().find('.hslist, .hslist2, .hslist3').removeClass('is-open');
	$('#landing',window.document).contents().find('.hslist, .hslist2, .hslist3').find('li').removeClass('is-focused');
	$('#landing',window.document).contents().find('#contextmenu-3').find('li').find('a').attr('data-file','');
	$('#landing',window.document).contents().find('.hslist, .hslist2, .hslist3').css('display', '');
}
function enableCollapsibleHeadings() {
	// to initialize/build collapsible headings used in LN
	let headers = $('#landing',window.document).contents().find('p.collapsible-header, p.collapsible-list');
	headers.each(function() {
		let nextsibling = $(this).next('dl, ul');
		if (nextsibling.length != 0 && !$(this).prev('button.collapsible-btn')) {
			$(`<button class="btn collapsible-btn hide-focus" type="button"><span class="icon plus-minus" aria-hidden="true" role="presentation"></span></button>`).insertBefore($(this));
		}
		let textInListItem = false;
		const testnode = $(this).parent()[0];
		let textnodelength = 0;
		if (testnode.firstChild.nodeValue !== null) {
			textnodelength = testnode.firstChild.nodeValue.trim().length;
		}
		if (testnode.firstChild.nodeName === "#text" && textnodelength > 0) {
			 textInListItem = true; //Node.TEXT_NODE
		}
		if ($(this).parent().hasClass('li') && !$(this).hasClass('collapsible-list')) {
			// this should apply to LN field help valid value lists
			$(this).parent().css('list-style-type','none');
		}
		else if (!textInListItem && $(this).parent().hasClass('li') && $(this).hasClass('collapsible-list')) {
			// this should apply to collapsible-list cases where there is no text in li before the p header
			// but it won't apply if the collapsible-list heading is preceded by text in the li
			$(this).parent().css('list-style-type','none');			
		}
	});
	let expander = $('#landing',window.document).contents().find('.collapsible-btn');			
	expander.hideFocus();
	
	$('#landing',window.document).contents().find('.collapsible-btn').on('click', function(evt) {
		if ($(this).children('.plus-minus').first().hasClass('active')) {
			$(this).children('.plus-minus').first().removeClass('active');
			$(this).next('p.collapsible-header').first().removeClass('active');
			$(this).next('p.collapsible-list').first().removeClass('active');
		}
		else {
			$(this).children('.plus-minus').first().addClass('active');
			$(this).next('p.collapsible-header').first().addClass('active');
			$(this).next('p.collapsible-list').first().addClass('active');
		}
		let content;		
		if ($(this).siblings('dl.collapsible-content').first().length > 0) {
			content = $(this).siblings('dl.collapsible-content').first();
		}
		else if ($(evt.currentTarget).nextAll('ul').first().length > 0) {		
			content = $(evt.currentTarget).nextAll('ul').first();
		}		
		if (content != undefined) {
			if (content.css('display') == "block") {
				content.css('display','none');
			}
			else {
				content.css('display','block');
			}				
		}			
	});
	
	$('#landing',window.document).contents().find('p.collapsible-header, p.collapsible-list').on('click', function() {
		if ($(this).hasClass('active')) {
			$(this).removeClass('active');
			$(this).prev('.collapsible-btn').first().children('.plus-minus').first().removeClass('active');
		}
		else {
			$(this).addClass('active');
			$(this).prev('.collapsible-btn').first().children('.plus-minus').first().addClass('active');
		}
		let content;
		if ($(this).next('dl.collapsible-content').first().length > 0) {
			content = $(this).next('dl.collapsible-content').first();
		}
		else if ($(this).next('ul').first().length > 0) {
			content = $(this).next('ul').first();
		}
		if (content != undefined) {
			if (content.css('display') == "block") {
				content.css('display','none');
			}
			else {
				content.css('display','block');
			}
		}
	});
}

function goSearch(input, filter) {
   // called from sohoxi.js to start a search, could probably be combined with searchtoc2
if (input != "") {
	// Page setting to 1 for default
	var page = 1;
	SearchToc2(input, false, page, filter);
	//if (window.innerWidth < 769  && $('#application-menu').hasClass('is-open')) {
	//	$('.application-menu-trigger').trigger('click');
	//}	
}
}
	
	return {
		landing : landing,
		collectionHome : collectionHome,
		getIsoLang : getIsoLang,
		addHistory : addHistory,
		goTocTopic : goTocTopic,
		hidesearch : hidesearch,
		hidesearchHS : hidesearchHS,
		showsearchHS : showsearchHS,
		showsearch : showsearch,
		goSearch : goSearch,
		SearchToc2 : SearchToc2,
		goTopic : goTopic,
		feedbackMail : feedbackMail,
		pageHighlightAndSynch : pageHighlightAndSynch,
		checkTopic : checkTopic,
		checkHashId :checkHashId,
		loadFullJSON: loadFullJSON,
		buildJSONArray : buildJSONArray,
		buildJsonEnArray : buildJsonEnArray,
		home : home,
		showhidesidetoc : showhidesidetoc,
		resetFooter : resetFooter,
		showlinks : showlinks,
		calcHistoryPath : calcHistoryPath,
		openContextTarget : openContextTarget,
		openControlClickTab : openControlClickTab,
		handleLandingListLeave : handleLandingListLeave,
		goBack : goBack,
		goForward : goForward,
		copyURL : copyURL,
		buildPDFName :buildPDFName,
		printPDF : printPDF,
		printPage : printPage,
		sendMail : sendMail,
		whUrl : whUrl,
		processParameters : processParameters,
		getCxRegex : getCxRegex,
		getID : getID,
		getMapFolder : getMapFolder,
		synchToc : synchToc,
		scrollPageTo : scrollPageTo,
		adjustTocScroll : adjustTocScroll,
		getFrequency : getFrequency,
		hideAllSearch : hideAllSearch,
		jsonfileContents : jsonfileContents,
		fullJsonLoading : fullJsonLoading,
		helpFileInit : helpFileInit,
		pdfMessageInit : pdfMessageInit,
		displayEnglishTopic : displayEnglishTopic,
		checkEnglishHashId : checkEnglishHashId,
		checkEnglishTopicLink : checkEnglishTopicLink,
		getEnglishModuleJsPath : getEnglishModuleJsPath,
		checkEnglishNonHtmlLink : checkEnglishNonHtmlLink,
		openCollectionTOCLink : openCollectionTOCLink,
		UrlExists : UrlExists,
		checkpdfjs : checkpdfjs,
		applySmartHelpStyles : applySmartHelpStyles,
		sendInfoToSmartHelp : sendInfoToSmartHelp,
		setFocusOnTopic : setFocusOnTopic,
		sendMailto : sendMailto
	};
});		