define(['inforhelp', 'sohoxi', 'varstore', 'jquery'], function(inforhelp, sohoxi, varstore, $) {
   
   $(document).ready(function(){	
	
	// from inforhelp.js
	var topic="";
	var fromBack = false;
	var rootpath;
	filePaths = [];
	errorpage = "helperror.html";
	var titlemapping = [];
	var helpRoot = "";
	var wh = window.location;
	var sidevisible = false;
	var lcHelpcontent = "";
	var hashid = "";		
	var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
	console.log("lang attr=" + initoptions);
	// to enable subsequent calls using different hash URLs to display the new topic
	// in same tab or window, overwriting the previous
	$( window ).on( 'hashchange', function (event) { 
		window.location.reload(); 
	});
	require(["sohoxi"], function () {
		inforhelp.processParameters(function(contentParam, searchParam, pageParam, filterParam, hlParam, hashParam, tocParam, shParam, tbarParam){
			if (shParam !== "" && window.top !== window.self) {
				// The following assumes that help system launched from Smart Help will always show a topic
				$('html .header div.bannerbar').css('display','');
				$('html .header .toolbar').css('top','');
				if ((contentParam !== "" || hashParam !== "" || searchParam !== "") && tocParam != "hide" && window.innerWidth < 768) {
					$('section.sidebar').css('display','none');
					$('section.sidebar').addClass('initload');
					$('#application-menu').removeClass('is-open');
					$('#application-menu').addClass('initload');
					$('.application-menu-trigger.show').css('display','block');
					$('.application-menu-trigger.hide').css('display','none');
				}						
				inforhelp.applySmartHelpStyles(tbarParam);
			}
			$('body').initialize(initoptions, function() {
				if (tocParam == "hide") {
					$('section.sidebar').css('display','none');
					$('.application-menu-trigger').trigger('click');
				}
				else {
					$('html .header div.bannerbar').css('visibility','visible');
					$('html .header .toolbar').css('top','');
				}				
				lcHelpcontent = contentParam.toLowerCase();
				hashid = hashParam;
				// for case where url is ?helpcontent=abc.html#someelementid
				if (lcHelpcontent != "") {
					if (hashid != "") {
						lcHelpcontent = lcHelpcontent + hashid;
					}		
				}
				iframeDoc = document.getElementById("landing");
				if (lcHelpcontent.indexOf(".html") != -1 || lcHelpcontent.indexOf(".htm") != -1) {
					inforhelp.checkTopic(lcHelpcontent, hlParam, function() {
					});
				}
				else if (lcHelpcontent != "" && lcHelpcontent.indexOf(".htm") == -1) {
					//no .htm or .html file value in URL for ?helpcontent
					iframeDoc.src = errorpage;
					inforhelp.addHistory("topic=" + errorpage);
					setTimeout(function () {
					  $('.busy, .busy-indicator-container').addClass('is-hidden');
					}, 2000);		
				}
				else if (hashid != "") {
					var topicid = inforhelp.getID(hashid, csregex);
					inforhelp.fullJsonLoading = true;
					var fulljsfile = "module" + varstore.buildVersion + ".js";
					inforhelp.loadFullJSON(fulljsfile,function(response) {
						inforhelp.buildJSONArray(response, function(){
							inforhelp.fullJsonLoaded = true;
							inforhelp.fullJsonLoading = false;
							inforhelp.checkHashId(topicid, iframeDoc, function(topicfile) {
								if (inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == "en-us") {
											inforhelp.checkTopic(topicfile, hlParam, function() {
									});
								}
								else if (inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
									if (topicfile != "") {
												inforhelp.checkTopic(topicfile, hlParam, function() {
										});
									}
									else {
										inforhelp.checkEnglishHashId(topicid, iframeDoc, function(topicfile) {
											inforhelp.displayEnglishTopic(topicfile,"");
										});
									}
								}
							});
						});
					});
				}
			
				inforhelp.landing(iframeDoc, function(){
					if (hashid == "" && lcHelpcontent  == "" && searchParam != "") {
						//initiate a search with search, page, and filter parameters
						if ($(iframeDoc).contents().find('body').first().hasClass('wh_main_page') || $(iframeDoc).contents().find('body').first().hasClass('wh_topic_page')) {
							try {
								var searchQuery = searchParam;
								var page = pageParam;
								var filter = filterParam; //really only for collections, should always be empty in standalone help
								searchQuery = decodeURIComponent(searchQuery);
								searchQuery = searchQuery.replace(/\+/g, " ");
								if (searchQuery.trim()!='' && searchQuery!==undefined && searchQuery!='undefined') {
									$('#textToSearch').val(searchQuery);
									inforhelp.SearchToc2(searchQuery, false, page, filter);
								}
							} catch (e) {
								console.log("#########", e);
							}					
						}
						else {
							var delay = 200;
							var loadcheck = window.setTimeout(function checkload() {
								if ($(iframeDoc).contents().find('body').first().hasClass('wh_main_page') || $(iframeDoc).contents().find('body').first().hasClass('wh_topic_page')) {
									try {
										var searchQuery = searchParam;
										var page = pageParam;
										var filter = filterParam; //really only for collections
										searchQuery = decodeURIComponent(searchQuery);
										searchQuery = searchQuery.replace(/\+/g, " ");
										if (searchQuery.trim()!='' && searchQuery!==undefined && searchQuery!='undefined') {
											$('#textToSearch').val(searchQuery);
											inforhelp.SearchToc2(searchQuery, false, page, filter);
										}
									} catch (e) {
										console.log("#########", e);
									}
									window.clearTimeout(loadcheck);							
								}								
								else {
									initcheck = setTimeout(checkload,delay + 200);
								}						
							}, delay);
						}
					}
				});

				// add event handlers for back forward buttons
				$('.buttonset.back').on('touchstart.button click.button', function (e) {
					if (!($('.buttonset.back').hasClass('disabled'))) {
						inforhelp.goBack();
					}
					return false;
				});
				$('.buttonset.forward').on('touchstart.button click.button', function (e) {
					if (!($('.buttonset.forward').hasClass('disabled'))) {
						inforhelp.goForward();
					}
					return false;
				}); 
				
				// add events for various buttons
				$('#menucopy').on('click.popupmenu',function() {
					inforhelp.copyURL();
				});				
				$('#printpage, .buttonset.print').on('click.print',function() {
					inforhelp.printPage();
				});
				const pdfjspath = "oxyhelp7-pdf.js";
				$('#printpdf,.buttonset.pdf').on('click.pdf',function() {
					if (pdfStatus) {
						inforhelp.checkpdfjs(pdfjspath, function(pdfFilename){
							inforhelp.printPDF("");
							inforhelp.addHistory("topic=" + pdfFilename);							
						});	
					}	
				});	
				inforhelp.checkpdfjs(pdfjspath,function(pdfFilename) {
					// this sets up status of PDF button at load time
				});
				$('section.sidebar').css('visibility','visible');
				$('.main').css('visibility','visible');
				$('html:not(.smarthelp) div.bannerbar').css('visibility','visible');
				$('html:not(.smarthelp) div.bannerbar div.toolbar-section.logo').css('visibility','visible');
				$('html header.header').css('visibility','visible');
			});
		
			// event handlers to track keydown for accessibility
			$('html').on('click.window', function(e) {
				varstore.clickTarget = e.target;
				if (e.target != varstore.lastTarget) {
					varstore.lastEvent = "click";
					varstore.lastTarget = e.target;
				}
			});
			$('html').on('keydown.window', function(e) {
				varstore.lastEvent = "keydown";
				varstore.lastTarget = e.target;
				varstore.keyTarget = e.target;
			});			
		});
	});	   
  });
});