define(["require", "inforhelp", "sohoxi","varstore","titlemap","htmlFileInfoList","jquery"], function(require, inforhelp, sohoxi, varstore, titlemap, fileInfoList, $){
/*jslint browser: true*/
/*global $, jQuery, alert, console, Porthole*/

/**
 * Each deliverables collection module requires 
 *
 * @version 0.1.0
 * @author Leen Smits <Leen.Smits@infor.com>
 * @author Annie Feedback <documentation@infor.com>
 * @copyright Copyright © 2017. Infor. All Rights Reserved. www.infor.com
 *
 */

/** DeliverableCollection "module" scripting; must be loaded and initialized in every topic. */
	
// more variables
var jsonfileContentsInit = {}
var jsonfileContents = [];

/**
 * Hide or show debug message depending on debug variable
 */
function log(message) {
    'use strict';
    if (debug) {
        console.log(message);
    }
}

/**
 * Click event handler for cross deliverable links. Defines the actions for both regular click and Ctrl+clicks.
 */
function onCrossDeliverableLinkClick(event) {
    'use strict';
    //messageEvent.preventDefault(); // prevent continuing the link click
	// Inside a jQuery click handler, the this object = element clicked
    var target = $(event.target),
		targetOrigin = "*",
		xdrLinkTarget = target.attr('data-onclickval'),
		module = "",
		validModule = false;
	var lang = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase();
	var langlength = lang.length;
	var topiclang = $('#landing',window.document).contents().find('html.fixed').attr('lang');
	var topiclanglength = topiclang.length;
	if (event.ctrlKey) {
		var newURL = buildURL(xdrLinkTarget);
		inforhelp.openControlClickTab(newURL);
		
		function buildURL(xdrLinkTarget) {
			var startpage = "default.html";
			var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
			if (varstore.isCollection) {
				var basetopic = window.location.href;
				var mapfolder = inforhelp.getMapFolder(basetopic);
				//whpath = whpath.substring(0, whpath.indexOf(mapfolder));
				// shouldn't need to use basetopic or mapfolder, latter is always
				// supplied by the earlier lookup of the ID in module.js
				return whpath + startpage + "?helpcontent=" + xdrLinkTarget;
			}
			else {
				// shouldn't reach this since only collections should have active xdr links
				return whpath + startpage + "?helpcontent=" + xdrLinkTarget;
			}					 
		 }
	}
	else {
		//var onclickval = "goTopic('" + xdrLinkTarget + "'),true,false";
		var samelength = (langlength == topiclanglength);
		if (inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == $('#landing',window.document).contents().find('html.fixed').attr('lang')) {
			inforhelp.goTopic(xdrLinkTarget,true,false);
		}
		else if (!samelength && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase().substring(0,2) == $('#landing',window.document).contents().find('html.fixed').attr('lang')) {
			inforhelp.goTopic(xdrLinkTarget,true,false);			
		}
		else if ($('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us" && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
			varstore.fallback = false;
			inforhelp.checkTopic(xdrLinkTarget, function() {
			});
		}
	}
}

function onMessage(messageEvent) { 
	if (messageEvent.data["topicId"]) {
		require(["inforhelp"], function (inforhelp) {
			inforhelp.goTopic(messageEvent.data["topicId"],true,false);
		});		
	}
	else {
		log("Xdr: No topic value sent");
	}
}

/**
 * Utility method to select all cross deliverable links, attach the eventhandler,
 * add a title to the xdr element, but hide if link is unresolvable.
 */
function enableCrossDeliverableLinks() {
    'use strict';
	require(["inforhelp"], function (inforhelp) {
		if (inforhelp.jsonfileContents.length == 0) {
			inforhelp.fullJsonLoading = true;
			var fulljsfile = "module" + varstore.buildVersion + ".js";
			inforhelp.loadFullJSON(fulljsfile,function(response) {
				inforhelp.buildJSONArray(response, function(){
					inforhelp.fullJsonLoaded = true;
					inforhelp.fullJsonLoading = false;
					var xdrs = $('#landing',window.document).contents().find('.xdr');
					xdrs.on("click", onCrossDeliverableLinkClick);
					xdrs.each(function() {
						var topicid = $(this).data('id');
						var module = "";
						var validModule = true;
						var topic = "";
						// get module name if present, check if valid, hide .xdr if not
						if (topicid.indexOf("/") != -1 && topicid.substring(0,topicid.indexOf("/")) != "") {
							module = topicid.substring(0,topicid.indexOf("/"));
							topicid = topicid.substring(topicid.indexOf("/") + 1);
							validModule = checkModule(module);
							if (validModule == false) {
								hideXdr($(this));
							}
							else {
								// valid module so check if id is present
								if (topicid.substring(topicid.indexOf("/")+1).length == 0) {
									// no id, so assume link is to module only
									topic = module + "/cover.html";
									getXdrTopicTitle(topic, $(this), function(topic, title, $node){
										if (title == "") {
											hideXdr($node);
										}
										else {
											createTopicAnchor(topic, title, $node);
										}
									});	
								}
								else {
									// id given, so check for matching file in the specific module
									checkTopicId(topicid, module, $(this), function(topic, $node){
										if (topic == "") {
											hideXdr($node);
										}
										else {
											getXdrTopicTitle(topic, $node, function(topic, title, $node){
												if (title == "") {
													hideXdr($node);
												}
												else {
													createTopicAnchor(topic, title, $node);
												}								
											});
										}													
									});					
								}
							}
						}
						else {
							// no module, simply go get topic file for the id
							checkTopicId(topicid, module, $(this), function(topic, $node){
								if (topic == "" || topic.indexOf("null") != -1) {
									hideXdr($node);
								}
								else {
									getXdrTopicTitle(topic, $node, function(topic, title, $node){
										if (title == "") {
											if ($('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us" && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
												// try to get English title
												getEnglishXdrTitle(topic, $node, function(topic, title, $node){
													if (englishTitle ==  "") {
														hideXdr($node);
													}
													else {
														createTopicAnchor(topic, title, $node);
													}	
												});													
											}
											else {
												hideXdr($node);
											}
										}
										else {
											createTopicAnchor(topic, title, $node);
										}
									});						
								}											
							});	
						}
					// end of .xdr each() function
					});
						
					$('#landing',window.document).contents().find('.relinfo').each(function() {
						var reglinks = $('#landing',window.document).contents().find('.relinfo li.linklist');
						var xdrlinks = $('#landing',window.document).contents().find('.relinfo .xdr[data-onclickval]');
						if (reglinks.length == 0 && xdrlinks.length == 0) {
							$(this).css('display','none');
						}
					});
				});
			});			
		}
		
		else {
			var xdrs = $('#landing',window.document).contents().find('.xdr');
			xdrs.on("click", onCrossDeliverableLinkClick);
			xdrs.each(function() {
				var topicid = $(this).data('id');
				var module = "";
				var validModule = true;
				var topic = "";
				// get module name if present, check if valid, hide .xdr if not
				if (topicid.indexOf("/") != -1 && topicid.substring(0,topicid.indexOf("/")) != "") {
					module = topicid.substring(0,topicid.indexOf("/"));
					topicid = topicid.substring(topicid.indexOf("/") + 1);
					validModule = checkModule(module);
					if (validModule == false) {
						hideXdr($(this));
					}
					else {
						// valid module so check if id is present
						if (topicid.substring(topicid.indexOf("/")+1).length == 0) {
							// no id, so assume link is to module only
							topic = module + "/cover.html";
							getXdrTopicTitle(topic, $(this), function(topic, title, $node){
								if (title == "") {
									hideXdr($node);
								}
								else {
									createTopicAnchor(topic, title, $node);
								}
							});	
						}
						else {
							// id given, so check for matching file in the specific module
							checkTopicId(topicid, module, $(this), function(topic, $node){
								if (topic == "") {
									hideXdr($node);
								}
								else {
									getXdrTopicTitle(topic, $node, function(topic, title, $node){
										if (title == "") {
											hideXdr($node);
										}
										else {
											createTopicAnchor(topic, title, $node);
										}								
									});
								}													
							});					
						}
					}
				}
				else {
					// no module, simply go get topic file for the id
					checkTopicId(topicid, module, $(this), function(topic, $node){
						if (topic == "" || topic.indexOf("null") != -1) {
							hideXdr($node);
						}
						else {
							getXdrTopicTitle(topic, $node, function(topic, title, $node){
								if (title == "") {
									if ($('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us" && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
										// try to get English title
										getEnglishXdrTitle(topic, $node, function(topic, englishTitle, $node){
											if (englishTitle ==  "") {
												hideXdr($node);
											}
											else {
												createTopicAnchor(topic, englishTitle, $node);
											}	
										});													
									}
									else {
										hideXdr($node);
									}
								}
								else {
									createTopicAnchor(topic, title, $node);
								}
							});						
						}											
					});	
				}
			// end of .xdr each() function
			});
				
			$('#landing',window.document).contents().find('.relinfo').each(function() {
				var reglinks = $('#landing',window.document).contents().find('.relinfo li.linklist');
				var xdrlinks = $('#landing',window.document).contents().find('.relinfo .xdr[data-onclickval]');
				if (reglinks.length == 0 && xdrlinks.length == 0) {
					$(this).css('display','none');
				}
			});			
		}
	});
}
/**
 *  Looks through the IDs in the array loaded from module.js. If found, gets
 *  the associated topic number. If not found and collection is non-English, tries
 *  to check the English module.js contents. If topic number found in either of
 *  these cases, returns the topic file value.
*/ 
	function checkTopicId(topicid,module,$node,callback) {
		var topic2check = topicid;
		var subtopicid = "";
		if (topicid.indexOf("#") != -1) {
			topic2check = topicid.substring(0,topicid.indexOf("#"));
			subtopicid = topicid.substring(topicid.indexOf("#"));
		}
		var topicfile = "";
		var topicNbr = "";
		firstloop:
		for (var i = 0; i < inforhelp.jsonfileContents.length; i++ ) {
			var idlist = inforhelp.jsonfileContents[i].ids;
			for (var key in idlist) {
				if (key == topic2check) {
					topicNbr = idlist[key];
					break firstloop;						
				}
			}			
		}
		if (topicNbr != "") {
			getTopicFromTopicNbr(topicNbr,module,function(topicfile) {
				topicfile = topicfile + subtopicid;
				callback(topicfile,$node);				
			});			
		}
		else if (topicNbr == "" && $('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us" && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
			inforhelp.getBuildVersion(function(whroot,buildversion) {
				inforhelp.getEnglishModuleJsPath(whroot,buildversion,function(jsonfile) {			
					inforhelp.loadFullJSON(jsonfile,function(response) {
						inforhelp.buildJsonEnArray(response, function(){
							varstore.fallback = true;
							var iframeDoc = window.document.getElementById("landing");
							inforhelp.checkEnglishHashId(topicid,iframeDoc,function(topicfile) {
								topicfile = topicfile + subtopicid;
								callback(topicfile,$node);
							});
						});	
						
					});
				});
			});
		}
		else {
			callback(topicfile,$node);
		}
		
	}
/**
 * A utility function to check if a module (map folder) is valid within
 * the collection.
 * @returns true if the module value exists within the titlemapping array
 */
function checkModule(moduleName) {
	 for (var i = 0; i < titlemap.titlemapping.length; ++i) {
		 if (titlemap.titlemapping[i].folder == moduleName) {
			 return true;
		 }
	}
	return false;
}
/**
 * Called from checkTopicId to retrieve the topic file value when that 
 * functions finds topic number 
 * @param {*} topicNbr The topic number sent
 * @param {*} module If a module (map folder) is included in xdr value, it will
 * be included in topic file value
 * @param {*} callback 
 */
function getTopicFromTopicNbr(topicNbr,module,callback){
	var topicFile = "";
	secondloop:
	for (var i = 0; i < inforhelp.jsonfileContents.length; i++ ) {
		var pathentries = inforhelp.jsonfileContents[i].entries;
		for (var key in pathentries) {
			if (key == topicNbr) {
				var obj = pathentries[key];
				for (var prop in obj) {
					if (prop == "path"){
						if (module == "") {
							topicFile = obj[prop];
							break secondloop;
						}
						else {
							var tempTopicFile = obj[prop];
							if (tempTopicFile.indexOf(module + "/") != -1) {
								// match found for module/topicfile
								topicFile = tempTopicFile;
								break secondloop;
							}
							else {
								// match not found for specified module/topicfile combination so just 
								// return orig module plus topic, and then check if title exists in htmlFileInforList
								topicFile = module + "/" + tempTopicFile.substring(tempTopicFile.indexOf("/") + 1);
								break secondloop;
							}							
						}
					}
				}
				continue;
			}			
		}			
	}
	callback(topicFile);
}
/**
 * For non-English collections, will try to get an English title if it's a case of
 * a "language fallback".
 * @param {*} topic 
 * @param {*} $node 
 * @param {*} callback 
 */
function getEnglishXdrTitle(topic, $node, callback) {
	require(["englishfileinfo"], function (englishfileinfo) {
		var topictitle = "";
		var topic2check = "";
		var filter = topic.substring(0,topic.indexOf("/"));
		var relPath = topic.substring(topic.indexOf("/") + 1);
		if (relPath.indexOf("#") != -1) {
			relPath = relPath.substring(0,relPath.indexOf("#")); 
		}	
		if (varstore.isCollection) {
			if (relPath.indexOf("cover.html") == -1) {
				var topicInfoString = "";			
				var filelistarray = Object.keys(englishfileinfo);
				var fileitemsarray = Object.values(englishfileinfo);
				
				for (var list in filelistarray) {
					if (filelistarray[list] == filter) {
						var listitems = fileitemsarray[list];
						checkModuleLoop1:
						for (var test in listitems) {
							item = listitems[test];
							var pos1 = item.indexOf("@@@");
							var pos2 = item.lastIndexOf("@@@");
							var filPath = item.substring(0, pos1);
							if (filPath == relPath) {
								topictitle = item.substring(pos1 + 3, pos2)
									.replace(/</g, "&lt;").replace(/>/g, "&gt;");
								break checkModuleLoop1;
							}		
						}	
					}			
				}			
			}
			else {
				loopexit:
				for (i = 0; i < titlemap.titlemapping.length; i++) {
					if (titlemap.titlemapping[i].folder == filter) {
						topictitle = titlemap.titlemapping[i].title;
						break loopexit;
					}
				}
			}			
		}
		if (!varstore.isCollection) {
			var indexfil = fileInfoList;
			checkModuleLoop2:
			for (item of indexfil) {
				var pos1 = item.indexOf("@@@");
				var pos2 = item.lastIndexOf("@@@");
				var filPath = item.substring(0, pos1);
				if (filPath == relPath) {
					topictitle = item.substring(pos1 + 3, pos2)
						.replace(/</g, "&lt;").replace(/>/g, "&gt;");
					break checkModuleLoop2;
				}
			}
		}
		callback(topic,topictitle,$node);		
	});			
}
/** 
 * Gets the title of the topic that the xdr link points to
*/
function getXdrTopicTitle(topic,$node,callback) {
	var topictitle = "";
	var topic2check = "";
	var filter = topic.substring(0,topic.indexOf("/"));
	var relPath = topic.substring(topic.indexOf("/") + 1);
	if (relPath.indexOf("#") != -1) {
		relPath = relPath.substring(0,relPath.indexOf("#")); 
	}	
	if (varstore.isCollection) {
		if (relPath.indexOf("cover.html") == -1) {
			var topicInfoString = "";			
			var filelistarray = Object.keys(fileInfoList);
			var fileitemsarray = Object.values(fileInfoList);
			var filpathfound = false;
			for (var list in filelistarray) {
				if (filelistarray[list] == filter) {
					var listitems = fileitemsarray[list];
					checkModuleLoop1:
					for (var test in listitems) {
						item = listitems[test];
						var pos1 = item.indexOf("@@@");
						var pos2 = item.lastIndexOf("@@@");
						var filPath = item.substring(0, pos1);
						if (filPath == relPath) {
							topictitle = item.substring(pos1 + 3, pos2)
								.replace(/</g, "&lt;").replace(/>/g, "&gt;");
							filpathfound = true;
							break checkModuleLoop1;
						}		
					}	
				}			
			}
			if (!filpathfound) {
				// checktopic found a topic but it's not in fileinfolist. Might be search=no case
				if ($node.text() != "") {
					topictitle = $node.text();
				}
			}
		}
		else {
			loopexit:
			for (i = 0; i < titlemap.titlemapping.length; i++) {
				if (titlemap.titlemapping[i].folder == filter) {
					topictitle = titlemap.titlemapping[i].title;
					break loopexit;
				}
			}
		}			
	}
	if (!varstore.isCollection) {
		var indexfil = fileInfoList;
		var filpathfound = false;
		checkModuleLoop2:
		for (item of indexfil) {
			var pos1 = item.indexOf("@@@");
			var pos2 = item.lastIndexOf("@@@");
			var filPath = item.substring(0, pos1);
			if (filPath == relPath) {
				topictitle = item.substring(pos1 + 3, pos2)
					.replace(/</g, "&lt;").replace(/>/g, "&gt;");
				filpathfound = true;
				break checkModuleLoop2;
			}
		}
		if (!filpathfound) {
			// checktopic found a topic but it's not in fileinfolist. Might be search=no case
			if ($node.text() != "") {
				topictitle = $node.text();
			}
		}
	}
	callback(topic,topictitle,$node);
}
/**
 * Creates the actual cross-deliverable link from the topic, title, and html node
 */
function createTopicAnchor(topic, title, $node) {
	var title = title;
	if ($node.text() != "" && !$node.parents().hasClass('related_link')) {
		title = $node.text();
	}
	//mludwig, changing below to use jquery html instead of text in order to handle &apos; in titles
	$node.attr('title',title).html(title);
	$node.css({'display':'inline'});
	$node.attr('data-onclickval',topic);		

}
/**
 * Hides the xdr node because it can't be resolved or populated with valid topic info. In the case
 * of a standalone help system, this will always occur. In collections, it will occur if the link is 
 * trying to point to a target not in the current collection.
 * @param {*} $node The html node that needs to be hidden
 */
function hideXdr($node) {
	// hide inline xdr and the li containing an xdr if problem with link
	if (!($node.parents('.related_link').length)) {
		if ($node.text() != "") {
			$node.css('display','inline');
			$node.css('color','inherit');
			$node.css('cursor','inherit');
		}
		else {
			$node.css('display','none');
		}
	}
	else {
		console.log("Error: no related topics section");
		// 	NEED VERY DIFFERENT LOGIC FOR HIDING THE RELATED TOPICS SECTION IF NEED BE
		//$node.parents('.related_link').css('display','none');
	}
}

	return {
		enableCrossDeliverableLinks : enableCrossDeliverableLinks
		
	};
});
