define(['inforhelp', 'sohoxi', 'varstore', 'jquery'], function(inforhelp, sohoxi, varstore, $) {
   
   $(document).ready(function(){	
	
	// from inforhelp.js
	var topic="";
	var fromBack = false;
	var rootpath;
	filePaths = [];
	errorpage = "helperror.html";
	var titlemapping = [];
	var helpRoot = "";
	var wh = window.location;
	var sidevisible = false;
		
	var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
	var lcHelpcontent = "";
	var hashid = "";
	// to enable subsequent calls using different hash URLs to display the new topic
	// in same tab or window, overwriting the previous
	$( window ).on( 'hashchange', function (event) { 
		window.location.reload(); 
	});
	require(["sohoxi"], function () {
		inforhelp.processParameters(function(contentParam, searchParam, pageParam, filterParam, hlParam, hashParam, tocParam, shParam, tbarParam){

			if (shParam !== "" && window.top !== window.self) {
				// The following assumes that help system launched from Smart Help will always show a topic
				$('html .header div.bannerbar').css('display','');
				$('html .header .toolbar').css('top','');
				if ((contentParam !== "" || hashParam !== "" || searchParam !== "") && tocParam != "hide" && window.innerWidth < 768) {
					$('section.sidebar').css('display','none');
					$('section.sidebar').addClass('initload');
					$('#application-menu').removeClass('is-open');
					$('#application-menu').addClass('initload');
					$('.application-menu-trigger.show').css('display','block');
					$('.application-menu-trigger.hide').css('display','none');
				}						
				inforhelp.applySmartHelpStyles(tbarParam);
			}
			$('body').initialize(initoptions, function() {
				if (tocParam == "hide") {
					$('section.sidebar').css('display','none');
					$('.application-menu-trigger').trigger('click');
				}
				else {
					$('html .header div.bannerbar').css('visibility','visible');
					$('html .header .toolbar').css('top','');
				}
				lcHelpcontent = contentParam.toLowerCase();
				hashid = hashParam;
				// for case where url is ?helpcontent=abc.html#someelementid
				if (lcHelpcontent != "") {
					if (hashid != "") {
						lcHelpcontent = lcHelpcontent + hashid;
					}		
				}
				iframeDoc = document.getElementById("landing");
				if (lcHelpcontent.indexOf(".html") != -1 || lcHelpcontent.indexOf(".htm") != -1) {
					inforhelp.checkTopic(lcHelpcontent, hlParam, function() {
					});
				}
				else if (lcHelpcontent != "" && lcHelpcontent.indexOf(".htm") == -1) {
					//no .htm or .html file value in URL for ?helpcontent
					iframeDoc.src = errorpage;
					inforhelp.addHistory("topic=" + errorpage);
					setTimeout(function () {
					  $('.busy, .busy-indicator-container').remove();
					}, 2000);		
				}
				else if (hashid != "") {
					inforhelp.fullJsonLoading = true;
					var fulljsfile = "module" + varstore.buildVersion + ".js";
					inforhelp.loadFullJSON(fulljsfile,function(response) {
						inforhelp.buildJSONArray(response, function(){
							inforhelp.fullJsonLoaded = true;
							inforhelp.fullJsonLoading = false;
							inforhelp.getCxRegex(function(csregex) {
								if (lcHelpcontent == "" && hashid != "") {
									var topicid = inforhelp.getID(hashid, csregex);
									inforhelp.checkHashId(topicid, iframeDoc, function(topicfile) {
										if (inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == "en-us") {
											inforhelp.checkTopic(topicfile, hlParam, function() {
											});
										}
										else if (inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us") {
											if (topicfile != "") {
												inforhelp.checkTopic(topicfile, hlParam, function() {
												});
											}
											else {
												inforhelp.checkEnglishHashId(topicid, iframeDoc, function(topicfile) {
													inforhelp.displayEnglishTopic(topicfile,"");
												});
											}
										}										
									});
								}
							});
						});
					});
				}
				
				if (hashid == "" && lcHelpcontent  == "" && searchParam == "") {
					inforhelp.collectionHome(lcHelpcontent, hashid, searchParam, function() {
						//nothing more to do here but maybe could move code from collectinHome here
						// It's not that much, unless I need the variables it sets in inforhelp.js to
						// be set there, rather than here.
					});
				}
				else if (hashid == "" && lcHelpcontent  == "" && searchParam != "") {
					inforhelp.collectionHome(lcHelpcontent, hashid, searchParam, function() {
						//initiate a search with search, page, filter parameters
						if ($(iframeDoc).contents().find('body').first().hasClass('wh_main_page') || $(iframeDoc).contents().find('body').first().hasClass('wh_topic_page')) {
							try {
								var searchQuery = searchParam;
								var page = pageParam;
								var filter = filterParam; //really only for collections
								searchQuery = decodeURIComponent(searchQuery);
								searchQuery = searchQuery.replace(/\+/g, " ");
								if (searchQuery.trim()!='' && searchQuery!==undefined && searchQuery!='undefined') {
									$('#textToSearch').val(searchQuery);
									inforhelp.SearchToc2(searchQuery, false, page, filter);
								}
							} catch (e) {
								console.log("#########", e);
							}					
						}
						else {
							var delay = 200;
							var loadcheck = window.setTimeout(function checkload() {
								if ($(iframeDoc).contents().find('body').first().hasClass('wh_main_page') || $(iframeDoc).contents().find('body').first().hasClass('wh_topic_page')) {
									try {
										var searchQuery = searchParam;
										var page = pageParam;
										var filter = filterParam; //really only for collections
										searchQuery = decodeURIComponent(searchQuery);
										searchQuery = searchQuery.replace(/\+/g, " ");
										if (searchQuery.trim()!='' && searchQuery!==undefined && searchQuery!='undefined') {
											$('#textToSearch').val(searchQuery);
											inforhelp.SearchToc2(searchQuery, false, page, filter);
										}
									} catch (e) {
										console.log("#########", e);
									}
									window.clearTimeout(loadcheck);							
								}								
								else {
									initcheck = setTimeout(checkload,delay + 200);
								}						
							}, delay);
						}				
					});
				}
				// add event handlers for back forward buttons
				$('.buttonset.back').on('touchstart.button click.button', function (e) {
					if (!($('.buttonset.back').hasClass('disabled'))) {
						inforhelp.goBack();
					}
					return false;
				});
				$('.buttonset.forward').on('touchstart.button click.button', function (e) {
					if (!($('.buttonset.forward').hasClass('disabled'))) {
						inforhelp.goForward();
					}
					return false;
				}); 
				   
				// add events for various buttons
				$('#menucopy').on('click.popupmenu',function() {
					inforhelp.copyURL();
				});				
				$('#printpage, .buttonset.print').on('click.print',function() {
					inforhelp.printPage();
				});
				$('#printpdf,.buttonset.pdf').on('click.pdf',function() {
					let pdfjspath = "oxyhelp7-pdf.js";
					let bookdataid = $(".booktitle",window.document).first().attr("data-id");
					if (bookdataid !== undefined && bookdataid !== "") {
						pdfjspath = bookdataid + "/" + pdfjspath;
						inforhelp.checkpdfjs(pdfjspath, function(collPdfFilename,collpdfstatus){
							if (collpdfstatus) {
								inforhelp.printPDF("");
								inforhelp.addHistory("topic=" + collPdfFilename);
							}
							else {
								//activate the pdf message dialog DOES IT EVER GO HERE????
								inforhelp.pdfMessageInit(function() {
								});							
							}							
						});
					}
					else {
						var iframe = $('#landing',window.document)[0]; 
						iframe.src = "lib_pdflist.html";
						if (window.innerWidth < 640  && $('#application-menu').hasClass('is-open')) {
							$('.application-menu-trigger').trigger('click');
						}
						inforhelp.addHistory("topic=lib_pdflist.html");
						$('#landing').off('load');
						$('#landing').on('load', function(){
							$('#landing',window.document).contents().find('body h1').html(Locale.translate('PDFlist'));
							$('#landing',window.document).contents().find('body').first().initialize(initoptions);
						});
					}					
				});						
				$('section.sidebar').css('visibility','visible');
				$('.main').css('visibility','visible');
				$('html:not(.smarthelp) div.bannerbar').css('visibility','visible');
				$('html:not(.smarthelp) div.bannerbar div.toolbar-section.logo').css('visibility','visible');
				$('html header.header').css('visibility','visible');
			});			

			// event handlers to track keydown for accessibility
			$('html').on('click.window', function(e) {
				varstore.clickTarget = e.target;
				if (e.target != varstore.lastTarget) {
					varstore.lastEvent = "click";
					varstore.lastTarget = e.target;
				}
			});
			$('html').on('keydown.window', function(e) {
				varstore.lastEvent = "keydown";
				varstore.lastTarget = e.target;
				varstore.keyTarget = e.target;
			});	 
		});				
	});	
  });
});