define(["require", "inforhelp", "sohoxi","varstore","titlemap","htmlFileInfoList","jquery"], function(require, inforhelp, sohoxi, varstore, titlemap, fileInfoList, $){
/*jslint browser: true*/
/*global $, jQuery, alert, console, Porthole*/

/**
 * Each deliverables collection module requires 
 *
 * @version 0.1.0
 * @author Leen Smits <Leen.Smits@infor.com>
 * @author Annie Feedback <documentation@infor.com>
 * @copyright Copyright © 2017. Infor. All Rights Reserved. www.infor.com
 *
 */

/** DeliverableCollection "module" scripting; must be loaded and initialized in every topic. */

// Not using porthole, but will keep code around for a while. Doesn't work in Sprint 32
var portholeWP = new Porthole.WindowProxy("proxy.html"),   // the proxy that communicates between 
                                                            //topic IFrame and parent Deliverable Collection
    debug = true;
	portholeWP.addEventListener(onMessage);
	
// more variables
var jsonfileContentsInit = {}
var jsonfileContents = [];

/**
 * Hide or show debug message depending on debug variable
 */
function log(message) {
    'use strict';
    if (debug) {
        console.log(message);
    }
}

/**
 * Click event handler for cross deliverable links. Composes a porthole proxy message to the parent IFrame.
 */
function onCrossDeliverableLinkClick(event) {
    'use strict';
    //messageEvent.preventDefault(); // prevent continuing the link click
	// Inside a jQuery click handler, the this object = element clicked
    var target = $(event.target),
		targetOrigin = "*",
		xdrLinkTarget = target.attr('data-onclickval'),
		module = "",
		validModule = false;
	if (event.ctrlKey) {
		var newURL = buildURL(xdrLinkTarget);
		inforhelp.openControlClickTab(newURL);
		
		function buildURL(xdrLinkTarget) {
			var startpage = "default.html";
			var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
			if (varstore.isCollection) {
				var basetopic = window.location.href;
				var mapfolder = inforhelp.getMapFolder(basetopic);
				whpath = whpath.substring(0, whpath.indexOf(mapfolder));	
				return whpath + startpage + "?helpcontent=" + xdrLinkTarget;
			}
			else {
				// shouldn't reach this since only collections should have active xdr links
				return whpath + startpage + "?helpcontent=" + xdrLinkTarget;
			}					 
		 }
	}
	else {
		var onclickval = "goTopic('" + xdrLinkTarget + "'),true,false";
		inforhelp.goTopic(xdrLinkTarget,true,false);
		//if (typeof (portholeWP) !== 'undefined' && xdrLinkTarget !== undefined) {
		//	console.log("xx porthole exists");
			// Should always have a value that includes module and topic file name'
		//	log('Module 1. Xdr to id:' + xdrLinkTarget);
		//	  portholeWP.post({
		//		"message": "goto",
		//		"topicId": xdrLinkTarget
		//	});
		//} else {
		//	log('Module 2. Looks like Porthole is not correctly working.');
		//	}
	}
}

function onMessage(messageEvent) { 
	if (messageEvent.data["topicId"]) {
		require(["inforhelp"], function (inforhelp) {
			inforhelp.goTopic(messageEvent.data["topicId"],true,false);
		});		
	}
	else {
		log("Xdr: No topic value sent");
	}
}

/**
 * Utility method to select all cross deliverable links, attach the eventhandler,
 * add a title to the xdr element, but hide if link is unresolvable.
 */
function enableCrossDeliverableLinks() {
    'use strict';
	require(["inforhelp"], function (inforhelp) {
		if (inforhelp.jsonfileContents.length == 0) {
			inforhelp.fullJsonLoading = true;
			var fulljsfile = "module.js";
			inforhelp.loadFullJSON(fulljsfile,function(response) {
				inforhelp.buildJSONArray(response, function(){
					inforhelp.fullJsonLoaded = true;
					inforhelp.fullJsonLoading = false;
					var xdrs = $('#landing',window.parent.document).contents().find('.xdr');
					xdrs.on("click", onCrossDeliverableLinkClick);
					xdrs.each(function() {
						var topicid = $(this).data('id');
						var module = "";
						var validModule = true;
						var topic = "";
						// get module name if present, check if valid, hide .xdr if not
						if (topicid.indexOf("/") != -1 && topicid.substring(0,topicid.indexOf("/")) != "") {
							module = topicid.substring(0,topicid.indexOf("/"));
							topicid = topicid.substring(topicid.indexOf("/") + 1);
							validModule = checkModule(module);
							if (validModule == false) {
								hideXdr($(this));
							}
							else {
								// valid module so check if id is present
								if (topicid.substring(topicid.indexOf("/")+1).length == 0) {
									// no id, so assume link is to module only
									topic = module + "/cover.html";
									getXdrTopicTitle(topic, $(this), function(topic, title, $node){
										if (title == "") {
											hideXdr($node);
										}
										else {
											createTopicAnchor(topic, title, $node);
										}
									});	
								}
								else {
									// id given, so check for matching file in the specific module
									checkTopicId(topicid, module, $(this), function(topic, $node){
										if (topic == "") {
											hideXdr($node);
										}
										else {
											getXdrTopicTitle(topic, $node, function(topic, title, $node){
												if (title == "") {
													hideXdr($node);
												}
												else {
													createTopicAnchor(topic, title, $node);
												}								
											});
										}													
									});					
								}
							}
						}
						else {
							// no module, simply go get topic file for the id
							checkTopicId(topicid, module, $(this), function(topic, $node){
								if (topic == "" || topic.indexOf("null") != -1) {
									hideXdr($node);
								}
								else {
									getXdrTopicTitle(topic, $node, function(topic, title, $node){
										if (title == "") {
											hideXdr($node);
										}
										else {
											createTopicAnchor(topic, title, $node);
										}
									});						
								}											
							});	
						}
					// end of .xdr each() function
					});
						
					$('#landing',window.parent.document).contents().find('.relinfo').each(function() {
						var reglinks = $('#landing',window.parent.document).contents().find('.relinfo li.linklist');
						var xdrlinks = $('#landing',window.parent.document).contents().find('.relinfo .xdr[data-onclickval]');
						if (reglinks.length == 0 && xdrlinks.length == 0) {
							$(this).css('display','none');
						}
					});
				});
			});			
		}
		
		else {
			var xdrs = $('#landing',window.parent.document).contents().find('.xdr');
			xdrs.on("click", onCrossDeliverableLinkClick);
			xdrs.each(function() {
				var topicid = $(this).data('id');
				var module = "";
				var validModule = true;
				var topic = "";
				// get module name if present, check if valid, hide .xdr if not
				if (topicid.indexOf("/") != -1 && topicid.substring(0,topicid.indexOf("/")) != "") {
					module = topicid.substring(0,topicid.indexOf("/"));
					topicid = topicid.substring(topicid.indexOf("/") + 1);
					validModule = checkModule(module);
					if (validModule == false) {
						hideXdr($(this));
					}
					else {
						// valid module so check if id is present
						if (topicid.substring(topicid.indexOf("/")+1).length == 0) {
							// no id, so assume link is to module only
							topic = module + "/cover.html";
							getXdrTopicTitle(topic, $(this), function(topic, title, $node){
								if (title == "") {
									hideXdr($node);
								}
								else {
									createTopicAnchor(topic, title, $node);
								}
							});	
						}
						else {
							// id given, so check for matching file in the specific module
							checkTopicId(topicid, module, $(this), function(topic, $node){
								if (topic == "") {
									hideXdr($node);
								}
								else {
									getXdrTopicTitle(topic, $node, function(topic, title, $node){
										if (title == "") {
											hideXdr($node);
										}
										else {
											createTopicAnchor(topic, title, $node);
										}								
									});
								}													
							});					
						}
					}
				}
				else {
					// no module, simply go get topic file for the id
					checkTopicId(topicid, module, $(this), function(topic, $node){
						if (topic == "" || topic.indexOf("null") != -1) {
							hideXdr($node);
						}
						else {
							getXdrTopicTitle(topic, $node, function(topic, title, $node){
								if (title == "") {
									hideXdr($node);
								}
								else {
									createTopicAnchor(topic, title, $node);
								}
							});						
						}											
					});	
				}
			// end of .xdr each() function
			});
				
			$('#landing',window.parent.document).contents().find('.relinfo').each(function() {
				var reglinks = $('#landing',window.parent.document).contents().find('.relinfo li.linklist');
				var xdrlinks = $('#landing',window.parent.document).contents().find('.relinfo .xdr[data-onclickval]');
				if (reglinks.length == 0 && xdrlinks.length == 0) {
					$(this).css('display','none');
				}
			});			
		}
	});
}

	function checkTopicId(topicid,module,$node,callback) {
		var topic2check = topicid;
		var subtopicid = "";
		if (topicid.indexOf("#") != -1) {
			topic2check = topicid.substring(0,topicid.indexOf("#"));
			subtopicid = topicid.substring(topicid.indexOf("#"));
		}
		var topicFile = "";
		var topicNbr = "";
		firstloop:
		for (var i = 0; i < inforhelp.jsonfileContents.length; i++ ) {
			var idlist = inforhelp.jsonfileContents[i].ids;
			for (var key in idlist) {
				if (key == topic2check && module == "") {
					topicNbr = idlist[key];
					break firstloop;
				}
				else if (key == topic2check && module != ""){
					topicNbr = idlist[key];
					break firstloop;						
				}
			}			
		}
		if (topicNbr != "") {
			getTopicFromTopicNbr(topicNbr,module,function(topic) {
				topicFile = topic;
				topicFile = topicFile + subtopicid;
			});
			callback(topicFile,$node);			
		}
		else {
			callback(topicFile,$node);
		}
		
	}
function checkModule(moduleName) {
	 for (var i = 0; i < titlemap.titlemapping.length; ++i) {
		 if (titlemap.titlemapping[i].folder == moduleName) {
			 return true;
		 }
	}
	return false;
}
function getTopicFromTopicNbr(topicNbr,module,callback){
	var topicFile = "";
	secondloop:
	for (var i = 0; i < inforhelp.jsonfileContents.length; i++ ) {
		var pathentries = inforhelp.jsonfileContents[i].entries;
		for (var key in pathentries) {
			if (key == topicNbr) {
				var obj = pathentries[key];
				thirdloop:
				for (var prop in obj) {
					if (prop == "path"){
						if (module == "") {
							topicFile = obj[prop];
							break secondloop;
						}
						else {
							var tempTopicFile = obj[prop];
							if (tempTopicFile.indexOf(module + "/") != -1) {
								topicFile = tempTopicFile;
								break secondloop;
							}
							else {
								break thirdloop;
							}							
						}
					}
				}
				continue;
			}			
		}			
	}
	callback(topicFile);
}
function getXdrTopicTitle(topic,$node,callback) {
	var topictitle = "";
	var topic2check = "";
	var filter = topic.substring(0,topic.indexOf("/"));
	var relPath = topic.substring(topic.indexOf("/") + 1);
	if (relPath.indexOf("#") != -1) {
		relPath = relPath.substring(0,relPath.indexOf("#")); 
	}	
	if (varstore.isCollection) {
		var topicInfoString = "";
		var filelistarray = Object.keys(fileInfoList);
		var fileitemsarray = Object.values(fileInfoList);
		
		for (var list in filelistarray) {
			if (filelistarray[list] == filter) {
				var listitems = fileitemsarray[list];
				checkModuleLoop1:
				for (var test in listitems) {
					item = listitems[test];
					var pos1 = item.indexOf("@@@");
					var pos2 = item.lastIndexOf("@@@");
					var filPath = item.substring(0, pos1);
					if (filPath == relPath) {
						topictitle = item.substring(pos1 + 3, pos2)
							.replace(/</g, "&lt;").replace(/>/g, "&gt;");
						break checkModuleLoop1;
					}		
				}	
			}			
		}
		
		
			
	}
	if (!varstore.isCollection) {
		var indexfil = fileInfoList;
		checkModuleLoop2:
		for (item of indexfil) {
			var pos1 = item.indexOf("@@@");
			var pos2 = item.lastIndexOf("@@@");
			var filPath = item.substring(0, pos1);
			if (filPath == relPath) {
				topictitle = item.substring(pos1 + 3, pos2)
					.replace(/</g, "&lt;").replace(/>/g, "&gt;");
				break checkModuleLoop2;
			}
		}
	}
	callback(topic,topictitle,$node);
}
function createTopicAnchor(topic, title, $node) {
	var title = title;
	if ($node.text() != "" && !$node.parents().hasClass('related_link')) {
		title = $node.text();
	}
	//mludwig, changing below to use jquery html instead of text in order to handle &apos; in titles
	$node.attr('title',title).html(title);
	$node.css({'display':'inline'});
	$node.attr('data-onclickval',topic);		

}
function hideXdr($node) {
	// hide inline xdr and the li containing an xdr if problem with link
	if (!($node.parents('.related_link').length)) {
		if ($node.text() != "") {
			$node.css('display','inline');
			$node.css('color','inherit');
			$node.css('cursor','inherit');
		}
		else {
			$node.css('display','none');
		}
	}
	else {
		console.log("Error: no related topics section");
		// 	NEED VERY DIFFERENT LOGIC FOR HIDING THE RELATED TOPICS SECTION IF NEED BE
		//$node.parents('.related_link').css('display','none');
	}
}

	return {
		enableCrossDeliverableLinks : enableCrossDeliverableLinks
		
	};
});
