/**
* Soho XI Controls v4.2.3 
* Date: 06/12/2016 1:15:32 PM 
* Revision: e7085ebbb3f05a54bbe5c1d9c2561c52e4398705 
 */ 
 
define(["require","inforhelp","varstore","titlemap","jquery","jquery.ui"], function(require,inforhelp,varstore,titlemap,$){

/**
* PERSONALIZE Control (TODO: bitly link to soho xi docs)
* (Deleted from here, mludwig)
*/

/**
 * Page Bootstrapper
 */


  $.fn.initialize = function(options, callback) {
    'use strict';
    // Settings and Options
    var pluginName = 'initialize',
        defaults = {
          locale: Locale.currentLocale.name || 'en-US'
        },
        settings;

      if (typeof options === 'string') {
        settings = {};
        settings.locale = options;
      } else {
        settings = $.extend({}, defaults, options);
      }

    // Plugin Constructor
    function Initialize(element, settings) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Initialize.prototype = {
      init: function() {
        var self = this;
        Locale.set(this.settings.locale).done(function () {
          self.initAll();
        });

        return this;
      },

      initAll : function () {

        // Iterate all objects we are initializing
        this.element.filter(':not(.no-init)').each(function() {
          var elem = $(this),
            noinitExcludes = '.no-init, [data-init]';

          function invokeWithInlineOptions(elem, plugin) {
            var options = $.fn.parseOptions(elem);
            $(elem)[plugin](options);
          }

          function matchedItems(selector) {
            var items = elem.find(selector);
            if (elem.filter(selector).length) {
              items = items.add(elem);
            }
            return items;
          }

          function simpleInit(plugin, selector) {
            //Allow only the plugin name to be specified if the default selector is a class with the same name
            //Like $.fn.header applying to elements that match .header
            if (typeof selector === 'undefined') {
              selector = '.' + plugin;
            }

            if ($.fn[plugin]) {
              matchedItems(selector).each(function () {
                var elem = $(this);

                if (elem.is(noinitExcludes) && selector !=='[data-trackdirty="true"]') {
                  return;
                }

                if (elem.parents().hasClass('no-init')) {
                  return;
                }

                // Don't invoke elements inside of "container" controls that need to invoke their internal
                // items in a specific order.
                if (!elem.is('.icon') && elem.parents('.toolbar').length && !elem.parents().hasClass('masthead')) {
                  return;
                }
			
                invokeWithInlineOptions(this, plugin);
              });
            }

            // Radio switch
            matchedItems('.radio-section input:radio.handle').change(function() {
              if (this.checked) {
                var option = $(this).closest('.option'),
                siblings = option.siblings(),
                fields = 'button, select, input[type="text"]';

                $(fields, option).removeAttr('disabled');
                $(fields, siblings).attr('disabled','disabled');
              }
            });
			
			//mludwig, adding for collection back/forward button translations
			// Text labels are set in Button plugin
			matchedItems('.back-btn').attr('title',Locale.translate('GoBack'));			
			matchedItems('.fwd-btn').attr('title',Locale.translate('GoForward'));
			
		  }
          // Mobile Zoom Control
          // Needs manual invokation because the rest of initialization is scoped to the
          // calling element, which is the <body> tag.
          if ($.fn.zoom) {
            $('head').zoom();
          }

          // Application Menu
          if ($.fn.applicationmenu) {
            matchedItems('#application-menu').applicationmenu({
              triggers: elem.find('.application-menu-trigger')
            });
          }

          // Personalization
          if ($.fn.personalize) {
            matchedItems('body').personalize();
          }

          //Array of plugin names and selectors (optional) for no-configuration initializations
          var simplePluginMappings = [
            // Icons
            ['icon'],

            //Tabs
            ['tabs', '.tab-container:not(.vertical)'],

            //Vertical Tabs
            //['verticaltabs', '.tab-container.vertical'],

            //Select / DropDowns
            ['dropdown', 'select.dropdown:not(.multiselect)'],
            ['dropdown', 'select.dropdown-xs:not(.multiselect)'],
            ['dropdown', 'select.dropdown-sm:not(.multiselect)'],
            ['dropdown', 'select.dropdown-lg:not(.multiselect)'],

            //Modals
            ['modal'],

            //Sliders
            ['slider', 'input[type="range"], .slider'],

            //Editors
            ['editor'],

            //Tooltips
            ['tooltip', '[title]'],

            //Tree
            ['tree'],

            //Rating
            ['rating'],

            //Light Box
            ['lightbox'],

            //Progress
            ['progress', '.progress-bar'],

            //Format
            ['mask', 'input[data-mask]'],

            //Auto Complete
            ['autocomplete', '.autocomplete:not([data-init])'],

            //Multiselect
            ['multiselect', 'select[multiple]:not(.dropdown), .multiselect:not([data-init])'],

            //Button with Effects
            ['button', '.btn, .btn-secondary, .btn-primary, .btn-modal-primary, .btn-tertiary, .btn-icon, .btn-actions, .btn-menu, .btn-split, .btn-secondary-border'],

            //Hide Focus
            ['hideFocus', 'a.hide-focus, a.tick, a.hyperlink'],

            //Circle Pager
            ['circlepager'],

            //Pager
            ['pager', '.paginated'],

            //Track Dirty
            ['trackdirty', '[data-trackdirty="true"]'],

            //Clear x
            ['clearable', '[data-clearable="true"]'],

            //Text Area
            ['textarea', 'textarea'],

            //Spinbox
            ['spinbox'],

            //sort drag and drop
            ['arrange'],

            //Swap List
            ['swaplist'],

            //Color Picker
            ['colorpicker'],

            //Date Picker
           // ['datepicker'],

            //Time Picker
           // ['timepicker'],

            //Tag
           // ['tag'],

            //Busy Indicator
            ['busyindicator','.busy, .busy-xs, .busy-sm'],

            ['header'],

            ['fileupload'],

            ['fileuploadadvanced', '.fileupload-advanced'],
			
			// mludwig, adding to do init on collection topic list
			['topiclist'],
			
			//mludwig, adding to do init on Help popup
			['help'],
			
			//mludwig, adding to do init on each topic page
			['topic', '.wh_topic_page'],
			['topic', '.wh_main_page'],
			
            ['pdfdialog'],
			
			['about'],

            ['contextualactionpanel', '.contextual-action-panel-trigger'],

            ['sidebar', '.sidebar-nav'],

            ['expandablearea', '.expandable-area'],

            ['modalsearch', '.modal-search'],

            ['signin'],

            ['homepage'],

            ['lookup', '.lookup:not([data-init])'],

            ['wizard'],

            ['splitter', '.splitter'],

            ['popdown', '[data-popdown]'],
			
			['popupmenu', '.popupmenu.contextmenu']
          ];

          //Do initialization for all the simple controls
          for(var i = 0; i < simplePluginMappings.length; i++) {
            simpleInit.apply(null, simplePluginMappings[i]);
          }
          if ($.fn.popupmenu) {
            // Don't double-invoke menu buttons
            var btnExcludes = ', .btn-actions, .btn-filter, .btn-menu';

            //Context Menus
            matchedItems('[data-popupmenu]:not('+ noinitExcludes + btnExcludes + ')').each(function () {
              var triggerButton = $(this),
                options = $.extend({}, $.fn.parseOptions(this)),
                popupData = triggerButton.attr('data-popupmenu');

              if (popupData) {
                options.menuId = popupData;
              }

              triggerButton.popupmenu(options);
            });

            //Button-based Popup-Menus (Action/More Button, Menu Buttons, etc.)
            matchedItems('.btn-filter, .btn-menu, .btn-actions').filter(':not('+ noinitExcludes +')').each(function() {
              var triggerButton = $(this);

              // Don't auto-invoke Toolbar's Popupmenus.
              // Toolbar needs to completely control its contents and invoke each one manually.
              if (triggerButton.parents('.toolbar').length > 0) {
                //return;
              }

              invokeWithInlineOptions(triggerButton, 'popupmenu');
            });
          }

          //Popovers
          if ($.fn.popover) {
            matchedItems('[data-popover]:not('+ noinitExcludes +')').each(function () {
              var obj = $(this),
                trigger = obj.attr('data-trigger'),
                title = obj.attr('data-title'),
                placement = obj.attr('data-placement');

              obj.popover({
                content: $('#' + obj.attr('data-popover')),
                trigger: trigger ? trigger : 'click',
                title: title ? title : undefined,
                placement: placement || 'right'
              });
            });
          }

          //Cardstack
          if ($.fn.listview) {
            matchedItems('.listview:not('+ noinitExcludes +')').each(function () {
              var cs = $(this),
                attr = cs.attr('data-dataset'),
                tmpl = cs.attr('data-tmpl'),
                options = $.fn.parseOptions(this) || {};

              options.dataset = options.dataset || attr;
              options.template = options.template || tmpl;

              if (window[options.dataset]) {
                options.dataset = window[options.dataset];
              }
              if (options.template && options.template.length) {
                options.template = $('#' + options.template).text();
              }

              cs.listview(options);
            });
          }

          // Searchfield
          // NOTE:  The Toolbar Control itself understands how to invoke internal searchfields, so they
          // are excluded from this initializer.
          if ($.fn.searchfield) {
            var searchfields = matchedItems('.searchfield:not('+ noinitExcludes +'), .searchfieldHS'),
              toolbarSearchfields = searchfields.filter(function() {
                return $(this).parents('.toolbar').length;
              });
            searchfields = searchfields.not(toolbarSearchfields);

            searchfields.each(function() {
              invokeWithInlineOptions(this, 'searchfield');
            });
          }

          // Accordion
          if ($.fn.accordion) {
            matchedItems('.accordion:not('+ noinitExcludes +')').each(function() {
              var a = $(this);
              if (a.parents('.application-menu').length) {
                return;
              }

              invokeWithInlineOptions(a, 'accordion');
            });
          }

          // Toolbar
          if ($.fn.toolbar) {
            matchedItems('.toolbar:not('+ noinitExcludes +')').each(function() {
              var t = $(this);
              // Don't re-invoke toolbars that are part of the page/section headers.
              // header.js manually invokes these toolbars during its setup process.
              if (t.parents('.header').length || t.parents('.contextual-action-panel').length) {
                return;
              }

              invokeWithInlineOptions(t, 'toolbar');
            });
          }

          matchedItems('[data-translate="text"]').each(function () {
            var obj = $(this);
            obj.text(Locale.translate(obj.text()));
          });

          //Toggle boxes on image list
          matchedItems('.block').on('click', function () {
            $(this).toggleClass('is-selected');
          });

          //Validation
          //Should be one of the last items to invoke
          if ($.fn.validate) {
            matchedItems('[data-validate]').validate();
            matchedItems('[data-validate-on="submit"]').validate();
          }

          matchedItems('.breadcrumb ol').attr('aria-label', Locale.translate('Breadcrumb'));
        });

        // NOTE: use of .triggerHandler() here causes event listeners for "initialized" to fire, but prevents the
        // "initialized" event from bubbling up the DOM.  It should be possible to initialize just the contents
        // of an element on the page without causing the entire page to re-initialize.
        this.element.triggerHandler('initialized');
		if (typeof callback == 'function') { // make sure the callback is a function
			callback.call(this); // brings the scope to the callback
		}
        return this;
      }

    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = new Initialize(this, settings); // jshint ignore:line
    });
  };

// ENVIRONMENT code from sohoxi 4.36

  var UTIL_NAME = 'environment';
  /**
   * @class {Environment}
   */

  var Environment = {
    browser: {},
    features: {
      resizeObserver: typeof ResizeObserver !== 'undefined',
      touch: 'ontouchstart' in window || navigator.MaxTouchPoints > 0 || navigator.msMaxTouchPoints > 0
    },
    os: {},
    devicespecs: {},

    /**
     * @returns {boolean} true if the page locale is currently read Right-To-Left instead
     * of the default Left-to-Right.
     */
    get rtl() {
      return $('html').attr('dir') === 'rtl';
    },

    /**
     * Builds run-time environment settings
     */
    set: function set() {
      $('html').attr('data-sohoxi-version', version); // Set the viewport meta tag to limit scaling

      this.viewport = document.querySelector('meta[name=viewport]');

      if (this.viewport) {
        this.viewport.setAttribute('content', 'width=device-width, initial-scale=1.0, user-scalable=0');
      }

      this.addBrowserClasses();
      this.addGlobalResize();
      this.addDeviceSpecs();
    },

    /**
     * Global Classes for browser, version and device as needed.
     */
    addBrowserClasses: function addBrowserClasses() {
      var ua = navigator.userAgent || navigator.vendor || window.opera;
      var platform = navigator.platform;
      var html = $('html');
      var cssClasses = ''; // User-agent string

      if (ua.indexOf('Safari') !== -1 && ua.indexOf('Chrome') === -1 && ua.indexOf('Android') === -1) {
        cssClasses += 'is-safari ';
        this.browser.name = 'safari';
      }

      this.browser.isWKWebView = function () {
        return false;
      };

      if (navigator.platform.substr(0, 2) === 'iP') {
        var lte9 = /constructor/i.test(window.HTMLElement);
        var idb = !!window.indexedDB;

        if (window.webkit && window.webkit.messageHandlers || !lte9 || idb) {
          // WKWebView
          this.browser.name = 'wkwebview';
          cssClasses += 'is-safari is-wkwebview ';

          this.browser.isWKWebView = function () {
            return true;
          };
        }
      }

      if (ua.indexOf('Chrome') !== -1) {
        cssClasses += 'is-chrome ';
        this.browser.name = 'chrome';
      }

      var macosPlatforms = ['Macintosh', 'MacIntel', 'MacPPC', 'Mac68K'];

      if (macosPlatforms.indexOf(platform) > -1 && !/Linux/.test(platform)) {
        cssClasses += 'is-mac ';
        this.os.name = 'Mac OS X';
      }

      if (ua.indexOf('Firefox') > 0) {
        cssClasses += 'is-firefox ';
        this.browser.name = 'firefox';
      } // Class-based detection for IE


      if (ua.match(/Edge\//)) {
        cssClasses += 'ie ie-edge ';
        this.browser.name = 'edge';
        this.browser.version = navigator.appVersion.indexOf('Edge/18') > -1 ? '18' : '17';
        cssClasses += "ie-edge".concat(this.browser.version);
      }

      if (ua.match(/Trident/)) {
        cssClasses += 'ie ';
        this.browser.name = 'ie';
      }

      if (navigator.appVersion.indexOf('MSIE 8.0') > -1 || ua.indexOf('MSIE 8.0') > -1 || document.documentMode === 8) {
        cssClasses += 'ie8 ';
        this.browser.version = '8';
      }

      if (navigator.appVersion.indexOf('MSIE 9.0') > -1) {
        cssClasses += 'ie9 ';
        this.browser.version = '9';
      }

      if (navigator.appVersion.indexOf('MSIE 10.0') > -1) {
        cssClasses += 'ie10 ';
        this.browser.version = '10';
      } else if (ua.match(/Trident\/7\./)) {
        cssClasses += 'ie11 ';
        this.browser.version = '11';
      } // Class-based detection for iOS
      // /iPhone|iPod|iPad|Silk|Android|BlackBerry|Opera Mini|IEMobile/


      if (/iPhone|iPod|iPad/.test(ua)) {
        cssClasses += 'ios ';
        this.os.name = 'ios';
        var iDevices = ['iPod', 'iPad', 'iPhone'];

        for (var i = 0; i < iDevices.length; i++) {
          if (new RegExp(iDevices[i]).test(ua)) {
            cssClasses += "".concat(iDevices[i].toLowerCase(), " ");
            this.device = iDevices[i];
          }
        }
      }

      if (/Android/.test(ua)) {
        cssClasses += 'android ';
        this.os.name = 'android';
      }

      if (!this.os.name && /Linux/.test(platform)) {
        this.os.name = 'linux';
      }

      html.addClass(cssClasses);
    },
    addDeviceSpecs: function addDeviceSpecs() {
      var unknown = '-';
      var nAppVer = navigator.appVersion;
      var nUAgent = navigator.userAgent;
      var browser = navigator.appName;
      var version = " ".concat(parseFloat(navigator.appVersion));
      var majorVersion = parseInt(navigator.appVersion, 10);
      var nameOffset;
      var verOffset;
      var ix;
      var browserVersionName = '';

      if ((verOffset = nUAgent.indexOf('Opera')) !== -1) {
        //eslint-disable-line
        browser = 'Opera';
        version = nUAgent.substring(verOffset + 6);

        if ((verOffset = nUAgent.indexOf('Version')) !== -1) {
          //eslint-disable-line
          version = nUAgent.substring(verOffset + 8);
        }
      }

      if ((verOffset = nUAgent.indexOf('OPR')) !== -1) {
        //eslint-disable-line
        browser = 'Opera';
        version = nUAgent.substring(verOffset + 4);
      } else if ((verOffset = nUAgent.indexOf('Edge')) !== -1) {
        //eslint-disable-line
        browser = 'Microsoft Edge';
        version = nUAgent.substring(verOffset + 5);
      } else if ((verOffset = nUAgent.indexOf('MSIE')) !== -1) {
        //eslint-disable-line
        browser = 'Microsoft Internet Explorer';
        version = nUAgent.substring(verOffset + 5);
      } else if ((verOffset = nUAgent.indexOf('Chrome')) !== -1) {
        //eslint-disable-line
        browser = 'Chrome';
        version = nUAgent.substring(verOffset + 7);

        if (nUAgent.indexOf('Edg') > -1) {
          browserVersionName = 'Microsoft Edge';
        }
      } else if ((verOffset = nUAgent.indexOf('Safari')) !== -1) {
        //eslint-disable-line
        browser = 'Safari';
        version = nUAgent.substring(verOffset + 7);

        if ((verOffset = nUAgent.indexOf('Version')) !== -1) {
          //eslint-disable-line
          version = nUAgent.substring(verOffset + 8);
        }
      } else if (this.browser.isWKWebView()) {
        //eslint-disable-line
        browser = "WKWebView"; //eslint-disable-line

        version = '';
        majorVersion = '';
      } else if ((verOffset = nUAgent.indexOf('Firefox')) !== -1) {
        //eslint-disable-line
        browser = 'Firefox';
        version = nUAgent.substring(verOffset + 8);
      } else if (nUAgent.indexOf('Trident/') !== -1) {
        //eslint-disable-line
        browser = 'Microsoft Internet Explorer';
        version = nUAgent.substring(nUAgent.indexOf('rv:') + 3);
      } else if ((nameOffset = nUAgent.lastIndexOf(' ') + 1) < (verOffset = nUAgent.lastIndexOf('/'))) {
        //eslint-disable-line
        browser = nUAgent.substring(nameOffset, verOffset);
        version = nUAgent.substring(verOffset + 1);

        if (browser.toLowerCase() === browser.toUpperCase()) {
          browser = navigator.appName;
        }
      } // Trim the version string


      if ((ix = version.indexOf(';')) !== -1) version = version.substring(0, ix); //eslint-disable-line

      if ((ix = version.indexOf(' ')) !== -1) version = version.substring(0, ix); //eslint-disable-line

      if ((ix = version.indexOf(')')) !== -1) version = version.substring(0, ix); //eslint-disable-line

      majorVersion = " ".concat(parseInt(version, 10));

      if (isNaN(majorVersion)) {
        version = " ".concat(parseFloat(navigator.appVersion));
        majorVersion = parseInt(navigator.appVersion, 10);
      } // mobile version


      var mobile = /Mobile|mini|Fennec|Android|iP(ad|od|hone)/.test(nAppVer);
      var os = unknown;
      var clientStrings = [{
        s: 'Windows 10',
        r: /(Windows 10.0|Windows NT 10.0)/
      }, {
        s: 'Windows 8.1',
        r: /(Windows 8.1|Windows NT 6.3)/
      }, {
        s: 'Windows 8',
        r: /(Windows 8|Windows NT 6.2)/
      }, {
        s: 'Windows 7',
        r: /(Windows 7|Windows NT 6.1)/
      }, {
        s: 'Android',
        r: /Android/
      }, {
        s: 'Open BSD',
        r: /OpenBSD/
      }, {
        s: 'Sun OS',
        r: /SunOS/
      }, {
        s: 'Linux',
        r: /(Linux|X11)/
      }, {
        s: 'iOS',
        r: /(iPhone|iPad|iPod)/
      }, {
        s: 'Mac OS X',
        r: /Mac OS X/
      }, {
        s: 'Mac OS',
        r: /(MacPPC|MacIntel|Mac_PowerPC|Macintosh)/
      }, {
        s: 'UNIX',
        r: /UNIX/
      }];

      for (var id in clientStrings) {
        //eslint-disable-line
        var cs = clientStrings[id];

        if (cs.r.test(nUAgent)) {
          os = cs.s;
          break;
        }
      }

      var osVersion = unknown;

      if (/Windows/.test(os)) {
        osVersion = /Windows (.*)/.exec(os)[1];
      }

      switch (os) {
        //eslint-disable-line
        case 'Mac OS X':
          osVersion = /Mac OS X ([1-9][0-9][\.\_\d]+)/.exec(nUAgent)[1].replace(/\_/g, '.'); //eslint-disable-line

          break;

        case 'Android':
          osVersion = /Android ([\.\_\d]+)/.exec(nUAgent)[1]; //eslint-disable-line

          break;

        case 'iOS':
          osVersion = /OS (\d+)_?(\d+)?/.exec(nUAgent); //eslint-disable-line

          osVersion = "".concat(osVersion[1], ".").concat(osVersion[2], ".").concat(osVersion[3] | 0); //eslint-disable-line

          break;
      }

      this.devicespecs = {
        currentBrowser: browser,
        browserVersion: version.trim(),
        browserMajorVersion: majorVersion,
        isMobile: mobile,
        os: os,
        currentOSVersion: osVersion,
        browserVersionName: browserVersionName
      };
    },

    /**
     * Setup a global resize event trigger for controls to listen to
     */
    addGlobalResize: function addGlobalResize() {
      // Global resize event
      $(window).debouncedResize(function () {
        $('body').triggerHandler('resize', [window]);
        breakpoints.compare();
      }); // Also detect whenenver a load or orientation change occurs

      $(window).on('orientationchange load', function () {
        return breakpoints.compare();
      });
    },

    /**
     * Tears down global UI-specific event handlers
     * @returns {void}
     */
    removeGlobalEvents: function removeGlobalEvents() {
      $(window).off("scroll.".concat(UTIL_NAME));
      $('body').off(["focusin.".concat(UTIL_NAME), "focusout.".concat(UTIL_NAME)].join(' '));
    }
  };
/**
* Base Tag Object (TODO: bitly link to soho xi docs)
* Provides a global object that detects the existence of a Base Tag, and provides some methods
* that can be used to get an accurate relative URL using the base tag.
*/

// NOTE:  There are AMD Blocks available


  function Base(element) {
    this.element = $(element);
    this.url = this.getCurrentURL();

    window.Soho = window.Soho || {};

    if (!window.Soho.base) {
      $.detectBaseTag();
    }

    return this;
  }

  Base.prototype = {
    getCurrentURL: function() {
      return window.location.href
        .replace(window.location.hash, '');
    },

    getBaseURL: function(hash) {
      if (hash) {
        // absolute links
        if (hash.indexOf('/') === 0) {
          return window.location.origin + hash;
        }

        hash = (hash.indexOf('#') === -1 ? '#' : '') + hash;
        return this.url + hash;
      }

      return this.url;
    }
  };

  // Setup a default function that just returns the contents of the hash,
  // if no base tag is present.
  $.getBaseURL = function(hash) {
    return hash;
  };

  // Detect the Base tag and install a global object, if necessary
  $.detectBaseTag = function detectBaseTag() {
    var base = $('base[href]');
    if (base.length) {
      window.Soho.base = new Base(base);

      // override the "getBaseURL"
      $.getBaseURL = window.Soho.base.getBaseURL.bind(window.Soho.base);
    }
  };

/**
* Transition Support Check
* Returns the vendor-prefixed name of the 'transition' property available by the browser.
* If the browser doesn't support transitions, it returns null.
*/


  // Used for changing the stacking order of jQuery events.  This is needed to override certain
  // Events invoked by other plugins http://stackoverflow.com/questions/2360655
  $.fn.bindFirst = function(name, fn) {
    this.on(name, fn);
    this.each(function() {
        var handlers = $._data(this, 'events')[name.split('.')[0]];
        // take out the handler we just inserted from the end
        var handler = handlers.pop();
        // move it at the beginning
        handlers.splice(0, 0, handler);
    });
  };

  function visible(element) {
    return $.expr.filters.visible( element ) &&
      !$(element).parents().addBack().filter(function() {
        return $.css(this, 'visibility') === 'hidden';
      }).length;
  }

  //Get a unique ID
  $.fn.uniqueId = function(className, prefix, suffix) {
    var predefinedId = $(this).attr('id');

    if (predefinedId && $('#' + predefinedId).length < 2) {
      return predefinedId;
    }

    prefix = (!prefix ? '' : prefix + '-');
    suffix = (!suffix ? '' : '-' + suffix);
    className = (!className ? $(this).attr('class') : className);

    var cnt = $('.' + className).length;
    return prefix + className + cnt + suffix;
  };

  // Check for CSS Property Support in a cross browser way
  $.fn.cssPropSupport = function(prop) {
    'use strict';

    if (!prop) {
      return null;
    }

    var el = $('<div></div>')[0],
      propStr = prop.toString(),
      prefixes = ['Moz', 'Webkit', 'O', 'ms'],
      prop_ = propStr.charAt(0).toUpperCase() + propStr.substr(1);

    if (prop in el.style) {
      $(el).remove();
      return prop;
    }

    for (var i = 0; i < prefixes.length; i++) {
      var vendorProp = prefixes[i] + prop_;
      if (vendorProp in el.style) {
        $(el).remove();
        return vendorProp;
      }
    }

    $(el).remove();
    return null;
  };

  // Returns the name of the TransitionEnd event.
  $.fn.transitionEndName = function() {
    var prop = $.fn.cssPropSupport('transition'),
      eventNames = {
        'WebkitTransition' :'webkitTransitionEnd',
        'MozTransition'    :'transitionend',
        'MSTransition'     :'msTransitionEnd',
        'OTransition'      :'oTransitionEnd',
        'transition'       :'transitionend'
      };

    return eventNames[prop] || null;
  };

  // From jQueryUI Core: https://github.com/jquery/jquery-ui/blob/24756a978a977d7abbef5e5bce403837a01d964f/ui/jquery.ui.core.js#L93
  // Adapted from:  http://stackoverflow.com/questions/7668525/is-there-a-jquery-selector-to-get-all-elements-that-can-get-focus
  // Adds the ':focusable' selector to Sizzle to allow for the selection of elements that can currently be focused.
  function focusable(element) {
    var map, mapName, img,
      nodeName = element.nodeName.toLowerCase(),
      isTabIndexNotNaN = !isNaN($.attr(element, 'tabindex'));

    if ('area' === nodeName) {
      map = element.parentNode;
      mapName = map.name;
      if (!element.href || !mapName || map.nodeName.toLowerCase() !== 'map') {
        return false;
      }
      img = $('img[usemap=#' + mapName + ']')[0];
      return !!img && visible(img);
    }

    return (/input|select|textarea|button|object/.test(nodeName) ?
      !element.disabled :
      'a' === nodeName ?
        element.href || isTabIndexNotNaN :
        isTabIndexNotNaN) &&
      // the element and all of its ancestors must be visible
      visible( element );
  }

  $.extend($.expr[':'], {
    focusable: function(element) {
      return focusable(element, !isNaN($.attr(element, 'tabindex')));
    }
  });

  // Custom Touch Event Handler that simply passes Touch Event Handlers onto a Click Event Handler.
  // Used for avoiding the 300ms wait time that click events have in most mobile environments
  // if 'one' is defined, it only listens once.
  $.fn.onTouchClick = function(eventNamespace, filter, one) {
    eventNamespace = (eventNamespace !== null || eventNamespace !== undefined ? '.' + eventNamespace : '');
    filter = (filter !== null || filter !== undefined ? filter : '');

    return this.each(function() {
      var self = $(this),
        listener = one ? 'one' : 'on',
        threshold = 10,
        thresholdReached = false,
        pos;

     self[listener]('touchstart' + eventNamespace, filter, function handleMove(e) {
        pos = {
          x: e.originalEvent.touches[0].pageX,
          y: e.originalEvent.touches[0].pageY
        };
      });

      self[listener]('touchmove' + eventNamespace, filter, function handleMove(e) {
        var newPos;
        newPos = {
          x: e.originalEvent.touches[0].pageX,
          y: e.originalEvent.touches[0].pageY
        };
		// To fix case when touchmove comes before touchstart
		if (pos == undefined) {
			pos = {
			  x: e.originalEvent.touches[0].pageX,
			  y: e.originalEvent.touches[0].pageY
			};			
		}
        if ((newPos.x >= pos.x + threshold) || (newPos.x <= pos.x - threshold) ||
            (newPos.y >= pos.y + threshold) || (newPos.y <= pos.y - threshold)) {
          thresholdReached = true;
        }
      });

      self[listener]('touchend' + eventNamespace + ' touchcancel' + eventNamespace, filter, function handleTouches(e) {
        var elem = $(this);
        if (thresholdReached) {
          thresholdReached = false;
          return;
        }

        setTimeout(function(){
          thresholdReached = false;
          e.preventDefault();

          if (elem.attr('disabled')) {
            return;
          }

          elem.trigger('click');
        }, 0);

        return false;
      });
      return self;
    });
  };

  // Reverses the .onTouchClick() method and turns off a matching event listener
  $.fn.offTouchClick = function(eventNamespace, filter) {
    eventNamespace = (eventNamespace !== null || eventNamespace !== undefined ? '.' + eventNamespace : '');
    filter = (filter !== null || filter !== undefined ? filter : '');

    return this.each(function() {
      return $(this).off('touchend' + eventNamespace + ' touchcancel' + eventNamespace + ' touchstart' + eventNamespace + ' touchmove' + eventNamespace, filter);
    });
  };

  // Returns a key/value list of currently attached event listeners
  $.fn.listEvents = function() {
    var data = {};

    this.each(function() {
      data = $._data(this, 'events');
    });

    return data;
  };

  // Implements consistent support for the placeholder attribute in browsers that do not handle it
  // ** Supports any kind of input (no issues with password) and textarea
  // ** does nothing if native support exists
  $.fn.placeholderPolyfill = function(options) {
    if (!('placeholder' in document.createElement('input'))) {
      var settings = $.extend({className: 'is-placeholder'}, options),
        setInputType = function (input, type, opt) {
          if(opt) {
            input.attr('type', type);
          }
        };
      $('[placeholder]').each(function() {
        var input = $(this),
        isPassword = input.is('input[type="password"]');
        input.removeClass(settings.className).on('focus.placeholderPolyfill, click.placeholderPolyfill', function() {
          if (input.val() === input.attr('placeholder') && input.data('placeholder')) {
            input.get(0).setSelectionRange(0, 0);
          }
        }).on('keydown.placeholderPolyfill', function() {
          setInputType(input, 'password', isPassword);
          if (input.val() === input.attr('placeholder') && input.data('placeholder')) {
            input.val('');
            input.removeClass(settings.className);
          }
        }).on('blur.placeholderPolyfill', function() {
          if (input.val() === '') {
            setInputType(input, 'text', isPassword);
            input.addClass(settings.className);
            input.val(input.attr('placeholder'));
            input.data('placeholder', true);
          } else {
            input.data('placeholder', false);
          }
        }).trigger('blur.placeholderPolyfill').parents('form').on('submit', function() {
          $('[placeholder]', this).each(function () {
            var field = $(this);
            if (field.val() === field.attr('placeholder') && field.data('placeholder')) {
              field.val('');
            }
          });
        });
      });
    }
   return this;
  };

  // Parse options from attribute and return obj
  $.fn.parseOptions = function(element, attr) {
    var options;

    attr = attr || 'data-options'; //default
    options = $(element).attr(attr);

    if (options && options.length) {
      if (options.indexOf('{') > -1) {
        try {
          options = JSON.parse(options.replace(/'/g, '"'));
        } catch(err) {
          // Attempt a manual parse
          var regex = /({|,)(?:\s*)(?:')?([A-Za-z_$\.][A-Za-z0-9_ \-\.$]*)(?:')?(?:\s*):/g; //get keys
          options = options.replace(regex, '$1\"$2\":'); //add double quotes to keys
          regex = /:(?:\s*)(?!(true|false|null|undefined))([A-Za-z_$\.#][A-Za-z0-9_ \-\.$]*)/g; //get strings in values
          options = options.replace(regex, ':\"$2\"'); //add double quotes to strings in values
          options = JSON.parse(options.replace(/'/g, '"')); //replace single to double quotes
        }
      }
    }

    if (!options) {
      options = {};
    }

    return options;
  };

  // Timer - can be use for play/pause or stop for given time
  // use as new instance [ var timer = new $.fn.timer(function() {}, 6000); ]
  // then can be listen events as [ $(timer.event).on('update', function(e, data){console.log(data.counter)}); ]
  // or can access as [ timer.cancel(); -or- timer.pause(); -or- timer.resume(); ]
  $.fn.timer = function(callback, delay) {
    var self = $(this),
      interval,
      speed = 10,
      counter = 0,
      cancel = function() {
        self.triggerHandler('cancel');
        clearInterval(interval);
        counter = 0;
      },
      pause = function() {
        self.triggerHandler('pause');
        clearInterval(interval);
      },
      update = function() {
        interval = setInterval(function() {
          counter += speed;
          self.triggerHandler('update', [{'counter': counter}]);
          if (counter > delay) {
            self.triggerHandler('timeout');
            callback.apply(arguments);
            clearInterval(interval);
            counter = 0;
          }
        }, speed);
      },
      resume = function() {
        self.triggerHandler('resume');
        update();
      };

      update();
    return { event: this, cancel: cancel, pause: pause, resume: resume };
  };

  // Copies a string to the clipboard. Must be called from within an event handler such as click.
  // May return false if it failed, but this is not always
  // possible. Browser support for Chrome 43+, Firefox 42+, Edge and IE 10+.
  // No Safari support, as of (Nov. 2015). Returns false.
  // IE: The clipboard feature may be disabled by an adminstrator. By default a prompt is
  // shown the first time the clipboard is used (per session).
  $.copyToClipboard = function(text) {
    if (window.clipboardData && window.clipboardData.setData) {
      // IE specific code path to prevent textarea being shown while dialog is visible.
      return window.clipboardData.setData('Text', text);
    }
    else if (document.queryCommandSupported && document.queryCommandSupported('copy')) {
      var textarea = document.createElement('textarea');
      textarea.textContent = text;
      textarea.style.position = 'fixed'; // Prevent scrolling to bottom of page in MS Edge.
      document.body.appendChild(textarea);
      textarea.select();
      try {
        return document.execCommand('copy'); // Security exception may be thrown by some browsers.
      }
      catch (ex) {
        // console.warn('Copy to clipboard failed.', ex);
        return false;
      }
      finally {
        document.body.removeChild(textarea);
      }
    }
  };

  //Functions For Sanitising and Escaping Html
  $.escapeHTML = function(value) {
    var newValue = value;
    if (typeof value === 'string') {
      newValue = newValue.replace(/&/g, '&amp;');
      newValue = newValue.replace(/</g, '&lt;').replace(/>/g, '&gt;');
    }
    return newValue;
  };

  $.unescapeHTML = function(value) {
    var newValue = value;
    if (typeof value === 'string') {
      newValue = newValue.replace(/&lt;/g, '<').replace(/&gt;/g, '>');
      newValue = newValue.replace(/&amp;/g, '&');
    }
    return newValue;
  };

  //Hide Focus - Only show on key entry
  $.fn.hideFocus = function() {
    var element = $(this);

    var isClick = false,
      isFocused = false;

    element.addClass('hide-focus').on('mousedown.hide-focus touchstart.hide-focus', function() {
      isClick = true;
      $(this).addClass('hide-focus');
    }).on('focusin.hide-focus', function() {
      var elem = $(this);

      if (!isClick && !isFocused) {
        //elem.removeClass('hide-focus');
      }
      isClick = false;
      isFocused = true;
    }).on('focusout.hide-focus', function() {
      $(this).addClass('hide-focus');
      isClick = false;
      isFocused = false;
    });

  };

  //CLEARABLE (Shows an X to clear)
  $.fn.clearable = function() {
    var self = this;
    this.element = $(this);
    //Create an X icon button styles in icons.scss
    this.xButton = $.createIconElement({ classes: 'close is-empty', icon: 'close' }).icon();
	this.xButtonHS = $.createIconElement({ classes: 'close is-empty', icon: 'close' }).icon();
	
    //Create a function
    this.checkContents = function () {
      var text = self.element.val();
	  var text2 = $('#textToSearchHS').val();

	  if (!text || !text.length) {
        this.xButton.addClass('is-empty');
      } 
	  else {
			this.xButton.removeClass('is-empty');
      }	  
	 if (!text2 || !text2.length) { 
		this.xButtonHS.addClass('is-empty');
	  }
	  else {
			$('.closeicondivHS .close.icon').removeClass('is-empty');
      }

      this.element.trigger('contents-checked');
    };
	
	// mludwig, add second input below #textToSearch input element
	if (this.element.attr('class') == "searchfield") {
		$("#textToSearch").after(this.xButton);
		this.xButton.wrap("<div class='closeicondiv' title='" + Locale.translate('Clear') + "'></div>");
		if (varstore.isCollection) {
			$("#textToSearchHS").after(this.xButtonHS);
			this.xButtonHS.wrap("<div class='closeicondivHS' title='" + Locale.translate('Clear') + "'></div>");
		}
	}	
	
    //Handle Events
	
    this.xButton.offTouchClick('clearable').off()
	.onTouchClick('clearable', '.clearable')
      .on('click.clearable touchstart.clearable', function handleClear() {
        self.element.val('').trigger('change').focus().trigger('cleared');
        self.checkContents();
      });
	this.xButtonHS.offTouchClick('clearable').off()
	.onTouchClick('clearable', '.clearable')
      .on('click.clearable touchstart.clearable', function handleClear() {
        $("#textToSearchHS").val('').trigger('change').focus().trigger('cleared');
        self.checkContents();
      });
    this.element.on('change.clearable, blur.clearable, keyup.clearable', function () {
      self.checkContents();
    });

    //Set initial state
    this.checkContents();
  };

  // Replacement for String.fromCharCode() that takes meta keys into account when determining which
  // character key was pressed.
  $.actualChar = function(e) {
      var key = e.which,
        character = '',
        toAscii = {
          '188': '44',
          //'109': '45', // changes "m" to "-" when using keypress
          '190': '46',
          '191': '47',
          '192': '96',
          '220': '92',
          '222': '39',
          '221': '93',
          '219': '91',
          '173': '45',
          '187': '61', //IE Key codes
          '186': '59', //IE Key codes
          '189': '45'  //IE Key codes
        },
        shiftUps = {
          '96': '~',
          '49': '!',
          '50': '@',
          '51': '#',
          '52': '$',
          '53': '%',
          '54': '^',
          '55': '&',
          '56': '*',
          '57': '(',
          '48': ')',
          '45': '_',
          '61': '+',
          '91': '{',
          '93': '}',
          '92': '|',
          '59': ':',
          '37': '%',
          '38': '&',
          '39': '\"',
          '44': '<',
          '46': '>',
          '47': '?'
        };

      // Normalize weird keycodes
      if (toAscii.hasOwnProperty(key)) {
        key = toAscii[key];
      }

      // Convert Keycode to Character String
      if (!e.shiftKey && (key >= 65 && key <= 90)) {
        character = String.fromCharCode(key + 32);
      } else if (e.shiftKey && shiftUps.hasOwnProperty(key)) { // User was pressing Shift + any key
        character = shiftUps[key];
      } else {
        character = String.fromCharCode(key);
      }

      return character;
  };

  window.Soho = window.Soho || {};
  window.Soho.utils = {};
  window.Soho.DOM = {};

  window.Soho.utils.equals = function equals(a, b) {
    return JSON.stringify(a) === JSON.stringify(b);
  };

  // Returns an array containing an element's attributes.
  window.Soho.DOM.getAttributes = function getAttributes(element) {
    if (!element || (!(element instanceof HTMLElement) && !(element instanceof SVGElement))) {
      return;
    }

    return element.attributes;
  };

/**
* Height Animation Controls (TODO: bitly link to soho xi docs)
* Adapted from: http://n12v.com/css-transition-to-from-auto/
* Contains a handful of animation helper methods that attempt to DRY up CSS-powered sliding animations.
*/


  // Use CSS Transitions to animate from "0" to "auto" widths
  $.fn.animateOpen = function(options) {
    'use strict';

    // Settings and Options
    var defaults = {
        direction: 'vertical', // Can also be 'horizontal'
        distance: 'auto', // Distance in pixels that the animation covers.  'auto', or pixel value size
        timing: 300, // in Miliseconds
        transition: 'cubic-bezier(.17, .04, .03, .94)' // CSS Transition Timing Function
      },
      settings = $.extend({}, defaults, options);

    // Initialize the plugin (Once)
    return this.each(function() {
      var self = this,
        $self = $(this),
        eventName = $.fn.transitionEndName(),
        dim = settings.direction === 'horizontal' ? 'width' : 'height',
        cDim = dim.charAt(0).toUpperCase() + dim.slice(1),
        distance = !isNaN(settings.distance) ? parseInt(settings.distance, 10) + 'px' : 'auto',
        timeout;

      function transitionEndCallback() {
        if (timeout) {
          clearTimeout(timeout);
        }

        if ($self.data('ignore-animation-once')) {
          $.removeData($self[0], 'ignore-animation-once');
        }

        if ($self.data('is-animating')) {
          $.removeData($self[0], 'is-animating');
        }
        $self.off(eventName + '.animateopen');
        self.style.transition = '';
        self.style[dim] = distance;
        $self.trigger('animateopencomplete');
      }

      // Clear any previous attempt at this animation when the animation starts new
      $self.one('animateopenstart.animation', function(e) {
        e.stopPropagation();
        $self.off(eventName + '.animateopen');
      });
      $self.trigger('animateopenstart');

      // Trigger the callback either by Timeout or by TransitionEnd
      if (eventName) {
        $self.one(eventName + '.animateopen', transitionEndCallback);
      }

      // Animate
      $self.data('is-animating', true);
      var prevVal = this.style[dim];
      this.style[dim] = distance;
      var endVal = getComputedStyle(this)[dim];
      this.style[dim] = prevVal;
      // next line forces a repaint
      this['offset' + cDim]; // jshint ignore:line
      this.style.transition = dim + ' ' + settings.timing + 'ms ' + settings.transition;

      timeout = setTimeout(transitionEndCallback, settings.timing);
      this.style[dim] = endVal;

      // Trigger immediately if this element is invisible or has the 'no-transition' class
      if ($self.is(':hidden') || $self.is('.no-transition') || $self.data('ignore-animation-once')) {
        transitionEndCallback();
      }
    });
  };

  // Use CSS Transitions to animate from "auto" to "0" widths
  $.fn.animateClosed = function(options) {

    // Settings and Options
    var defaults = {
        direction: 'vertical', // can also be 'horizontal'
        timing: 300, // in Miliseconds
        transition: 'cubic-bezier(.17, .04, .03, .94)'
      },
      settings = $.extend({}, defaults, options);

    // Initialize the plugin (Once)
    return this.each(function() {
      var self = this,
        $self = $(this),
        eventName = $.fn.transitionEndName(),
        dim = settings.direction === 'horizontal' ? 'width' : 'height',
        cDim = dim.charAt(0).toUpperCase() + dim.slice(1),
        timeout;

      function transitionEndCallback() {
        if (timeout) {
          clearTimeout(timeout);
        }

        if ($self.data('ignore-animation-once')) {
          $.removeData($self[0], 'ignore-animation-once');
        }

        if ($self.data('is-animating')) {
          $.removeData($self[0], 'is-animating');
        }

        $self.off(eventName + '.animatedclosed');
        self.style.transition = '';
        self.style[dim] = '0px';
        $self.trigger('animateclosedcomplete');
      }

      // Clear any previous attempt at this animation when the animation starts new
      $self.one('animateclosedstart', function(e) {
        e.stopPropagation();
        $self.off(eventName + '.animatedclosed');
      });
      $self.trigger('animateclosedstart');

      // Trigger the callback either by Timeout or by TransitionEnd
      if (eventName) {
        $self.one(eventName + '.animatedclosed', transitionEndCallback);
      }

      // Animate
      $self.data('is-animating', true);
      this.style[dim] = getComputedStyle(this)[dim];
      // next line forces a repaint
      this['offset' + cDim]; // jshint ignore:line
      this.style.transition = dim + ' ' + settings.timing + 'ms ' + settings.transition;

      timeout = setTimeout(transitionEndCallback, settings.timing);
      this.style[dim] = '0px';

      // Trigger immediately if this element is invisible or has the 'no-transition' class
      if ($self.is(':hidden') || $self.is('.no-transition') || $self.data('ignore-animation-once')) {
        transitionEndCallback();
      }
    });
  };

  // Chainable jQuery plugin that checks if an element is in the process of animating
  $.fn.isAnimating = function() {
    return this.each(function() {
      return $(this).data('is-animating') === true;
    });
  };

  // Extends the jQuery $.css() method to vendor-prefix newer CSS properties that are still in Draft specification
  $.fn.cssVendorProp = function(prop, value) {

    // Settings
    var defaults = {
        propertyName: '', // Name of the CSS property that can be changed
        propertyValue: '' // Value to set the property to
      },
      incomingOptions = {},
      settings;

    if (!prop) {
      return;
    }

    if (typeof prop === 'object') {
      incomingOptions = prop;
    }

    if (typeof prop === 'string') {
      incomingOptions.propertyName = prop;
      if (value !== undefined) {
        incomingOptions.propertyValue = value;
      }
    }

    settings = $.extend({}, defaults, incomingOptions);

    // Initialize the plugin (Once)
    return this.each(function() {
      var prefixes = ['-moz-', '-ms-', '-o-', '-webkit-', ''];

      // Sanitize
      settings.propertyName = settings.propertyName.toString();
      settings.propertyValue = settings.propertyValue.toString();

      for (var i = 0; i < prefixes.length; i++) {
        $(this).css(prefixes[i] + settings.propertyName, settings.propertyValue);
      }
    });
  };

/**
* Localization Routines
* Data From: http://www.unicode.org/repos/cldr-aux/json/22.1/main/
* For Docs See: http://ibm.co/1nXyNxp
*/


  //If there already exists a Locale object with a culturesPath use that path
  //This allows manually setting the directory for the culture files to be retrieved from
  var existingCulturePath = '';

  if (window.Locale && window.Locale.hasOwnProperty('culturesPath')) {
    existingCulturePath = window.Locale.culturesPath;
  }

  window.Locale = {

    currentLocale:  {name: '', data: {}}, //default
    cultures: {},
    culturesPath: existingCulturePath,

    //Sets the Lang in the Html Header
    updateLang: function () {
      var html = $('html');  
	  //mludwig, changing below to explicitly set currentLocale.name to
	  // what is lang in start page. IIS was resetting it to en-US otherwise.
	  this.currentLocale.name = inforhelp.getIsoLang(html.attr('lang'));
	  html.attr('lang', this.currentLocale.name);
	  // mludwig, disabling below, seems to confuse the browser
	  // with rtl languages, since we already set the dir attribute
	  // for rtl languages
      if (this.isRTL()) {
        //html.attr('dir', 'rtl');
      } else {
        //html.removeAttr('dir');
      }
    },

    //Get the path to the directory with the cultures
    getCulturesPath: function() {
      if (!this.culturesPath) {
        var scripts = document.getElementsByTagName('script'),
          partialPathMin = 'sohoxi.min.js',
          partialPath = 'sohoxi.js';

        for (var i = 0; i < scripts.length; i++) {
          var src = scripts[i].src;

          //remove from ? to end
          var idx = src.indexOf('?');
          if (src !== '' && idx > -1) {
            src = src.substr(0, idx);
          }

          if (scripts[i].id === 'sohoxi-script') {
            return src.substring(0, src.lastIndexOf('/')) + '/';
          }

          if (src.indexOf(partialPathMin) > -1) {
            this.culturesPath = src.replace(partialPathMin, '') + 'cultures/';
          }
          if (src.indexOf(partialPath) > -1) {
            this.culturesPath = src.replace(partialPath, '') + 'cultures/';
          }
		  // mludwig, adding below to set path to cultures/
		  else if (src.indexOf("sohoxi") != -1) {
			  this.culturesPath = src.substring(0,src.indexOf("sohoxi")) + "cultures/";
		  }
        }
      }
      return this.culturesPath;
    },

    cultureInHead: function() {
      var isThere = false,
        scripts = document.getElementsByTagName('script'),
        partialPath = 'cultures';


        for (var i = 0; i < scripts.length; i++) {
          var src = scripts[i].src;

          if (src.indexOf(partialPath) > -1) {
            isThere = true;
          }
        }
      return isThere;
    },

    addCulture: function(locale, data) {
      this.cultures[locale] = data;
    },

    //Set the Locale
    set: function (locale) {

      var self = this;
      this.dff = $.Deferred();

      //Map incorrect java locale to correct locale
      if (locale === 'in-ID') {
        locale = 'id-ID';
      }
      if (locale && !this.cultures[locale] && this.currentLocale.name !== locale) {
        this.setCurrentLocale(locale);

        //fetch the locale and cache it
        $.ajax({
          url: this.getCulturesPath() + this.currentLocale.name + '.js',
          dataType: 'script',
          error: function () {
            self.dff.reject();
          }
        }).done(function () {
          self.setCurrentLocale(locale, self.cultures[locale]);
          self.addCulture(locale, self.currentLocale.data);
          self.dff.resolve(self.currentLocale.name);
        });
      }

      if (locale && self.currentLocale.data && self.currentLocale.dataName === locale) {
        self.dff.resolve(self.currentLocale.name);
      }

      self.setCurrentLocale(locale, self.cultures[locale]);

      if (self.cultures[locale] && this.cultureInHead()) {
        self.dff.resolve(self.currentLocale.name);
      }
      return this.dff.promise();
    },

    setCurrentLocale: function(name, data) {
      this.currentLocale.name = inforhelp.getIsoLang($('html').attr('lang'));
	  //this.currentLocale.name = name;

      if (data) {
        this.currentLocale.data = data;
        this.currentLocale.dataName = inforhelp.getIsoLang($('html').attr('lang'));
      }
      this.updateLang();
    },

    //Format a Date Object and return it parsed in the current locale
    formatDate: function(value, attribs) {

      //We will use http://www.unicode.org/reports/tr35/tr35-dates.html#Date_Field_Symbol_Table
      if (!attribs) {
        attribs = {date: 'short'};  //can be date, time, datetime or pattern
      }

      if (!value) {
        return undefined;
      }

      //Convert if a string..
      if (!(value instanceof Date)) {
        value = new Date(value);
      }

      // TODO: Can we handle this if (this.dff.state()==='pending')
       var data = this.currentLocale.data,
        pattern, ret = '', cal = (data.calendars ? data.calendars[0] : null);

      if (attribs.pattern) {
        pattern = attribs.pattern;
      }

      if (attribs.date) {
        pattern = cal.dateFormat[attribs.date];
      }

      var day = value.getDate(), month = value.getMonth(), year = value.getFullYear(),
        mins = value.getMinutes(), hours = value.getHours(), seconds = value.getSeconds();

      //Special
      pattern = pattern.replace('ngày','nnnn');
      pattern = pattern.replace('tháng','t1áng');

      //Day of Month
      ret = pattern.replace('dd', this.pad(day, 2));
      ret = ret.replace('d', day);

      //years
      ret = ret.replace('yyyy', year);
      ret = ret.replace('yy', year.toString().substr(2));
      ret = ret.replace('y', year);

      //Time
      var showDayPeriods = ret.indexOf(' a') > -1;

      if (showDayPeriods && hours === 0) {
        ret = ret.replace('hh', 12);
        ret = ret.replace('h', 12);
      }

      ret = ret.replace('hh', (hours > 12 ? hours - 12 : hours));
      ret = ret.replace('h', (hours > 12 ? hours - 12 : hours));
      ret = ret.replace('HH', hours);
      ret = ret.replace('mm', this.pad(mins, 2));
      ret = ret.replace('ss', this.pad(seconds, 2));
      ret = ret.replace('SSS', this.pad(value.getMilliseconds(), 0));

      //months
      ret = ret.replace('MMMM', cal ? cal.months.wide[month] : null);  //full
      ret = ret.replace('MMM',  cal ? cal.months.abbreviated[month] : null);  //abreviation
      if (pattern.indexOf('MMM') === -1) {
        ret = ret.replace('MM', this.pad(month+1, 2));  //number padded
        ret = ret.replace('M', month+1);                //number unpadded
      }

      //PM
      if (cal) {
        ret = ret.replace(' a', ' '+ (hours >= 12 ? cal.dayPeriods[1] : cal.dayPeriods[0]));
        ret = ret.replace('EEEE', cal.days.wide[value.getDay()]);  //Day of Week
      }

      //Day of Week
      if (cal) {
        ret = ret.replace('EEEE', cal.days.wide[value.getDay()]);  //Day of Week
      }
      ret = ret.replace('nnnn','ngày');
      ret = ret.replace('t1áng','tháng');

      return ret.trim();
    },

    isValidDate: function (date) {
      if (Object.prototype.toString.call(date) === '[object Date]') {
        // it is a date
        if (isNaN(date.getTime())) {  // d.valueOf() could also work
          return false;
        } else {
          return true;
        }
      } else {
        return false;
      }
    },

    // Take a date string written in the current locale and parse it into a Date Object
    parseDate: function(dateString, dateFormat, isStrict) {
      var thisLocaleCalendar = this.calendar(),
        orgDatestring = dateString;

      if (!dateString) {
        return undefined;
      }

      if (!dateFormat) {
        dateFormat = this.calendar().dateFormat.short;
      }

      if (dateFormat.pattern) {
        dateFormat = dateFormat.pattern;
      }

      var formatParts,
        dateStringParts,
        dateObj = {},
        isDateTime = (dateFormat.toLowerCase().indexOf('h') > -1);

      if (isDateTime) {
        //replace [space & colon & dot] with "/"
        dateFormat = dateFormat.replace(/[\s:.-]/g,'/');
        dateString = dateString.replace(/[\s:.]/g,'/');
      }

      if (dateFormat === 'Mdyyyy' || dateFormat === 'dMyyyy') {
        dateString = dateString.substr(0, dateString.length - 4) + '/' + dateString.substr(dateString.length - 4, dateString.length);
        dateString = dateString.substr(0, dateString.indexOf('/')/2) + '/' + dateString.substr(dateString.indexOf('/')/2);
      }

      if (dateFormat === 'Mdyyyy') {
        dateFormat = 'M/d/yyyy';
      }

      if (dateFormat === 'dMyyyy') {
        dateFormat = 'd/M/yyyy';
      }

      if (dateFormat.indexOf(' ') !== -1 ) {
        dateFormat = dateFormat.replace(/[\s:.]/g,'/');
        dateString = dateString.replace(/[\s:.]/g,'/');
      }

      if (dateFormat.indexOf(' ') === -1 && dateFormat.indexOf('.') === -1  && dateFormat.indexOf('/')  === -1 && dateFormat.indexOf('-')  === -1) {
        var lastChar = dateFormat[0],
          newFormat = '', newDateString = '';

        for (var j = 0; j < dateFormat.length; j++) {
          newFormat +=  (dateFormat[j] !== lastChar ? '/' + dateFormat[j]  : dateFormat[j]);
          newDateString += (dateFormat[j] !== lastChar ? '/' + dateString[j]  : dateString[j]);

          if (j > 1) {
            lastChar = dateFormat[j];
          }
        }

        dateString = newDateString;
        dateFormat = newFormat;
      }

      formatParts = dateFormat.split('/');
      dateStringParts = dateString.split('/');

      if (formatParts.length === 1) {
        formatParts = dateFormat.split('.');
      }

      if (dateStringParts.length === 1) {
        dateStringParts = dateString.split('.');
      }

      if (formatParts.length === 1) {
        formatParts = dateFormat.split('-');
      }

      if (dateStringParts.length === 1) {
        dateStringParts = dateString.split('-');
      }

      if (formatParts.length === 1) {
        formatParts = dateFormat.split(' ');
      }

      if (dateStringParts.length === 1) {
        dateStringParts = dateString.split(' ');
      }

      // Check the incoming date string's parts to make sure the values are valid against the localized
      // Date pattern.
      var month = this.getDatePart(formatParts, dateStringParts, 'M', 'MM', 'MMM'),
        year = this.getDatePart(formatParts, dateStringParts, 'yy', 'yyyy');

      for (var i = 0; i < dateStringParts.length; i++) {
        var pattern = formatParts[i],
          value = dateStringParts[i],
          numberValue = parseInt(value);

        switch(pattern) {
          case 'd':
            var lastDay = new Date(year, month, 0).getDate();

            if (numberValue < 1 || numberValue > 31 || numberValue > lastDay) {
              return;
            }
            dateObj.day = value;
            break;
          case 'dd':
            if ((numberValue < 1 || numberValue > 31) || (numberValue < 10 && value.substr(0,1) !== '0')) {
              return;
            }
            dateObj.day = value;
            break;
          case 'M':
            if (numberValue < 1 || numberValue > 12) {
              return;
            }
            dateObj.month = value-1;
            break;
          case 'MM':
            if ((numberValue < 1 || numberValue > 12) || (numberValue < 10 && value.substr(0,1) !== '0')) {
              return;
            }
            dateObj.month = value-1;
            break;
          case 'MMM':
              var abrMonth = this.calendar().months.abbreviated;

              for (var l = 0; l < abrMonth.length; l++) {
                if (orgDatestring.indexOf(abrMonth[l]) > -1) {
                  dateObj.month = l;
                }
              }

              break;
          case 'MMMM':
            var textMonths = this.calendar().months.wide;

            for (var k = 0; k < textMonths.length; k++) {
              if (orgDatestring.indexOf(textMonths[k]) > -1) {
                dateObj.month = k;
              }
            }

            break;
          case 'yy':
            dateObj.year = parseInt('20'+value, 10);
            break;
          case 'yyyy':
            dateObj.year = value;
            break;
          case 'h':
            if (numberValue < 0 || numberValue > 12) {
              return;
            }
            dateObj.h = value;
            break;
          case 'HH':
            if (numberValue < 0 || numberValue > 24) {
              return;
            }
            dateObj.h = value;
            break;

          case 'ss':
            if (numberValue < 0 || numberValue > 60) {
              dateObj.ss = 0;
              break;
            }
            dateObj.ss = value;
            break;

          case 'mm':
            if (numberValue < 0 || numberValue > 60) {
              dateObj.mm = 0;
              break;
            }
            dateObj.mm = value;
            break;

          case 'a':
            if((value.toLowerCase() === thisLocaleCalendar.dayPeriods[0]) ||
             (value.toUpperCase() === thisLocaleCalendar.dayPeriods[0])) {
              dateObj.a = 'AM';
            }

            if((value.toLowerCase() === thisLocaleCalendar.dayPeriods[1]) ||
             (value.toUpperCase() === thisLocaleCalendar.dayPeriods[1])) {
              dateObj.a = 'PM';

              if (dateObj.h) {
                dateObj.h = parseInt(dateObj.h) + 12;
              }
            }
            break;
        }
      }

      dateObj.return = undefined;
      dateObj.leapYear = ((dateObj.year % 4 === 0) && (dateObj.year % 100 !== 0)) || (dateObj.year % 400 === 0);

      if ((isDateTime && !dateObj.h && !dateObj.mm)) {
        return undefined;
      }

      if (!dateObj.year && dateObj.year !== 0 && !isStrict) {
        dateObj.year = (new Date()).getFullYear();
      }

      if (!dateObj.month && dateObj.month !== 0 && !isStrict) {
        dateObj.month = (new Date()).getMonth();
      }

      if (!dateObj.day && dateObj.day !== 0 && !isStrict) {
        dateObj.day = 1;
      }

      if (isDateTime) {
        if (dateObj.h) {
          dateObj.return = new Date(dateObj.year, dateObj.month, dateObj.day, dateObj.h, dateObj.mm);
        }
        if (dateObj.ss !== undefined) {
          dateObj.return = new Date(dateObj.year, dateObj.month, dateObj.day, dateObj.h, dateObj.mm, dateObj.ss);
        }
      } else {
        dateObj.return = new Date(dateObj.year, dateObj.month, dateObj.day);
      }

      return (this.isValidDate(dateObj.return) ? dateObj.return : undefined);

    },

    getDatePart: function (formatParts, dateStringParts, filter1, filter2, filter3) {
      var ret = 0;

      $.each(dateStringParts, function(i) {
        if (filter1 === formatParts[i] || filter2 === formatParts[i] || filter3 === formatParts[i]) {
          ret = dateStringParts[i];
        }
      });

      return ret;
    },

    //format a decimal with thousands and padding in the current locale
    // options.style can be decimal, currency, percent and integer
    // http://mzl.la/1MUOEWm
    // percentSign, minusSign, decimal, group
    // minimumFractionDigits (0), maximumFractionDigits (3)
    formatNumber: function(number, options) {
      //Lookup , decimals, decimalSep, thousandsSep
      var formattedNum, curFormat, percentFormat,
        decimal = options && options.decimal ? options.decimal : this.numbers().decimal,
        group = options && options.group !== undefined ? options.group : this.numbers().group,
        minimumFractionDigits = options && options.minimumFractionDigits !== undefined ? options.minimumFractionDigits : (options && options.style && (options.style === 'currency' || options.style === 'percent') ? 2: 2),
        maximumFractionDigits = options && options.maximumFractionDigits !== undefined ? options.maximumFractionDigits : (options && options.style && (options.style === 'currency' || options.style === 'percent') ? 2: (options && options.minimumFractionDigits ? options.minimumFractionDigits :3));

      if (number === undefined || number === null || number === '') {
        return undefined;
      }

      if (options && options.style === 'integer') {
        maximumFractionDigits = 0;
        minimumFractionDigits = 0;
      }

      if (options && options.style === 'percent') {
        minimumFractionDigits = 2;
      }

      //TODO: Doc Note: Uses Truncation
      if (options && options.style === 'currency') {
        var sign = this.currentLocale.data.currencySign;

        curFormat = this.currentLocale.data.currencyFormat;
        curFormat = curFormat.replace('¤', sign);
      }

      if (options && options.style === 'percent') {
        var percentSign = this.currentLocale.data.numbers.percentSign;

        percentFormat = this.currentLocale.data.numbers.percentFormat;
        percentFormat = percentFormat.replace('¤', percentSign);
      }

      if (typeof number === 'string') {

        if (decimal !== '.') {
          number = number.replace(decimal, '.');
        }
        number = Locale.parseNumber(number);
      }

      if (options && options.style === 'percent') {
        number = number * 100;
      }

      var parts = this.truncateDecimals(number, minimumFractionDigits, maximumFractionDigits, options && options.round).split('.');
      parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, group);
      formattedNum = parts.join(decimal);

      if (minimumFractionDigits === 0) { //Not default
        formattedNum = formattedNum.replace(/(\.[0-9]*?)0+$/, '$1'); // remove trailing zeros
        formattedNum = formattedNum.replace(/\.$/, '');              // remove trailing dot
      }

      if (minimumFractionDigits === 0 && decimal !== '.') { //Not default
        formattedNum = formattedNum.replace(/(\,[0-9]*?)0+$/, '$1'); // remove trailing zeros
        formattedNum = formattedNum.replace(/\,$/, '');              // remove trailing dot
      }

      if (minimumFractionDigits > 0) {
        var expr = new RegExp('(\\..{' + minimumFractionDigits+ '}[0-9]*?)0+$');
        formattedNum = formattedNum.replace(expr, '$1'); // remove trailing zeros
        formattedNum = formattedNum.replace(/\.$/, '');  // remove trailing dot
      }

      //Confirm Logic After All Locales are added.
      if (options && options.style === 'currency') {
        formattedNum = curFormat.replace('#,##0.00', formattedNum);
      }

      if (options && options.style === 'percent') {
        formattedNum = percentFormat.replace('#,##0', formattedNum);
      }

      return formattedNum;
    },

    decimalPlaces: function(number) {
      var result= /^-?[0-9]+\.([0-9]+)$/.exec(number);
      return result === null ? 0 : result[1].length;
    },

    truncateDecimals: function (number, minDigits, maxDigits, round) {
      var multiplier = Math.pow(10, maxDigits),
        adjustedNum = number * multiplier,
        truncatedNum;

      //Round Decimals
      var decimals = this.decimalPlaces(number);

      //Handle larger numbers
      if (number.length - decimals - 1 >= 10) {
        multiplier = Math.pow(100, maxDigits);
        adjustedNum = number * multiplier;
      }

      truncatedNum = Math[adjustedNum < 0 ? 'ceil' : 'floor'](adjustedNum);

      if (round && decimals >= maxDigits && adjustedNum > 0) {
        truncatedNum = Math.round(adjustedNum);
      }

      if (round && decimals <= maxDigits && decimals > 0) {
        truncatedNum = Math.round(adjustedNum);
      }

      if (decimals < maxDigits && decimals > 0) {
        truncatedNum = Math.floor(adjustedNum);
        maxDigits = Math.max(decimals, minDigits);
      }

      return (truncatedNum / multiplier).toFixed(maxDigits);
    },


    //Take a Formatted Number and return a real number
    parseNumber: function(input) {
      var numSettings = this.currentLocale.data.numbers,
        numString, group, decimal, percentSign, currencySign;

      numString = input;

      if (!numString) {
        return NaN;
      }

      group = numSettings ? numSettings.group  : ',';
      decimal = numSettings ? numSettings.decimal  : '.';
      percentSign = numSettings ? numSettings.percentSign  : '%';
      currencySign = currencySign ? this.currentLocale.data.currencySign  : '$';

      numString = numString.replace(new RegExp('\\' + group, 'g'), '');
      numString = numString.replace(decimal, '.');
      numString = numString.replace(percentSign, '');
      numString = numString.replace(currencySign, '');
      numString = numString.replace(' ', '');

      return parseFloat(numString);
    },

    // Overridable culture messages
    translate: function(key) {
      if (this.currentLocale.data === undefined || this.currentLocale.data.messages === undefined) {
        return key;
      }

      if (this.currentLocale.data.messages[key] === undefined) {
        // Substitue English Expression if missing
        if (!this.cultures['en-US'] || this.cultures['en-US'].messages[key] === undefined) {
          return undefined;
        }
        return this.cultures['en-US'].messages[key].value;
      }

      return this.currentLocale.data.messages[key].value;
    },

    // Translate Day Period
    translateDayPeriod: function(period) {
      if (/am|pm|AM|PM/i.test(period)) {
        return Locale.calendar().dayPeriods[/AM|am/i.test(period) ? 0 : 1];
      }
      return period;
    },

    // Short cut function to get 'first' calendar
    calendar: function() {
      if (this.currentLocale.data.calendars) {
        return this.currentLocale.data.calendars[0];
      }

      //Defaults to ISO 8601
      return {dateFormat: 'yyyy-MM-dd', timeFormat: 'HH:mm:ss'};
    },

    // Short cut function to get numbers
    numbers: function() {
      return this.currentLocale.data.numbers ? this.currentLocale.data.numbers : {
          percentSign: '%',
          percentFormat: '#,##0 %',
          minusSign: '-',
          decimal: '.',
          group: ','
        };
    },

    pad: function(n, width, z) {
      z = z || '0';
      n = n + '';
      return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
    },

    isRTL: function() {
      return this.currentLocale.data.direction === 'right-to-left';
    },

    flipIconsHorizontally: function() {
      var icons = [
        'attach',
        'bottom-aligned',
        'bullet-list',
        'cancel',
        'cart',
        'collapse-app-tray',
        'cut',
        'document',
        'drilldown',
        'duplicate',
        'expand-app-tray',
        'export',
        'first-page',
        'folder',
        'import',
        'last-page',
        'launch',
        'left-align',
        'left-text-align',
        'left-arrow',
        'new-document',
        'next-page',
        'number-list',
        'paste',
        'previous-page',
        'quote',
        'redo',
        'refresh',
        'right-align',
        'right-arrow',
        'right-text-align',
        'save',
        'search-folder',
        'search-list',
        'send',
        'tack',
        'tree-collapse',
        'tree-expand',
        'undo',
        'unlocked',
        'add-grid-record',
        'add-grid-row',
        'additional-help',
        'bubble',
        'cascade',
        'change-font',
        'clear-screen',
        'script',
        'clockwise-90',
        'close-cancel',
        'close-save',
        'contacts',
        'copy-from',
        'copy-mail',
        'copy-url',
        'counter-clockwise-90',
        'create-report',
        'delete-grid-record',
        'delete-grid-row',
        'display',
        'employee-directory',
        'export-2',
        'export-to-pdf',
        'generate-key',
        'get-more-rows',
        'group-selection',
        'headphones',
        'help',
        'helper-list-select',
        'history',
        'invoice-released',
        'language',
        'logout',
        'key',
        'lasso',
        'line-bar-chart',
        'line-chart',
        'new-expense-report',
        'new-payment-request',
        'new-time-sheet',
        'new-travel-plan',
        'no-attachment',
        'no-comment',
        'no-filter',
        'overlay-line',
        'pdf-file',
        'phone',
        'payment-request',
        'pie-chart',
        'queries',
        'quick-access',
        'refresh-current',
        'restore-user',
        'run-quick-access',
        'save-close',
        'save-new',
        'search-results-history',
        'select',
        'send-submit',
        'show-last-x-days',
        'special-item',
        'stacked',
        'timesheet',
        'unsubscribe',
        'update-preview',
        'zoom-100',
        'zoom-in',
        'zoom-out',
        'caret-left',
        'caret-right',
		'caret-up',
		'caret-down',
		'print',
		'home'
      ];

      $('svg').each(function() {
        var iconName = $(this).getIconName();

        if (iconName && $.inArray(iconName, icons) !== -1 && !$(this).parent().hasClass('btn-help') && !$(this).parent().hasClass('btn-pdf')) {
          $(this).addClass('icon-rtl-rotate');
        }
      });
    }

  };

  //Has to delay in order to check if no culture in head since scripts load async
  $(function() {
    setTimeout(function() {
      if (!window.Locale.cultureInHead() && !window.Locale.currentLocale.name) {
		  var htmllang = inforhelp.getIsoLang($('html').attr('lang'));
		  if (htmllang != "" && htmllang !== undefined) {
			  window.Locale.set(htmllang);
		  }
		  else {
			 window.Locale.set('en-US'); 
		  }         
      }

      // ICONS: Right to Left Direction
      if (window.Locale.isRTL()) {
        window.Locale.flipIconsHorizontally();
      }
    }, 50);
  });


/**
* ListFilter - Abstracted search/filter for use in other controls
* TODO: Add Docs Link
*/


  var defaults = {
      caseSensitive: false, // Set to true if searches ARE case sensitive
      filterMode: 'startsWith', // see "filterModes" var for possible values
      highlightMatchedText: false, // inserts markup that appears to highlight text
      highlightCallback: null // if defined, will execute this code for highlighting text instead of the built-in highlighting code
    },
    filterModes = ['startsWith', 'contains'];

  function ListFilter(settings) {
    this.settings = $.extend({}, defaults, settings);
    Soho.logTimeStart('ListFilter');
    this.init();
    Soho.logTimeEnd('ListFilter');
  }

  ListFilter.prototype = {

    init: function() {
      // Sanitize Incoming Options
      function setReasonableDefaults(setting, limits, preset) {
        if ($.inArray(setting, limits) === -1) {
          setting = preset;
        }
      }

      var checks = [
        { setting: this.settings.filterMode, limits: filterModes, preset: defaults.filterMode }
      ];

      for (var i = 0; i < checks.length; i++) {
        setReasonableDefaults(checks[i].setting, checks[i].limits, checks[i].preset);
      }

      return this;
    },

    filter: function(list, term) {
      if (!list) {
        return false;
      }

      // Check incoming list type
      if (!$.isArray(list) && !(list instanceof jQuery)) {
        return false;
      }

      // Search term must exist and must not be nothing
      if (!term || typeof term !== 'string' || !term.length) {
        return false;
      }

      var self = this,
        items = [],
        isJQuery = false;

      // make search term lowercase if the search is not case-senstive
      if (!this.settings.caseSensitive) {
        term = term.toLowerCase();
      }

      // If it's not an array, build an array of the incoming object(s) for iterating through
      if (!$.isArray(list)) {
        if (list instanceof jQuery || typeof list === 'object') {
          list = $.makeArray(list);
          isJQuery = true;
        }
      }

      function searchItemIterator(item) {
        var isString = typeof item === 'string',
          text = (isString ? item : $(item).text()),
          parts = text.split(' '),
          match = false;

        if (self.settings.filterMode === 'startsWith') {
          for (var a = 0; a < parts.length; a++) {
            if (parts[a].toLowerCase().indexOf(term) === 0) {
              match = true;
              break;
            }
          }

          //Direct Match
          if (text.toLowerCase().indexOf(term) === 0) {
            match = true;
          }

          //Partial dual word match
          if (term.indexOf(' ') > 0 && text.toLowerCase().indexOf(term) > 0) {
            match = true;
          }
        }

        if (self.settings.filterMode === 'contains') {
          if (text.toLowerCase().indexOf(term) >= 0) {
            match = true;
          }
        }

        if (match) {

          // TODO: Figure out if we want to do this in the filtering logic, or in each control
          /*
          // Highlight the search term in this result if the current settings allow for it
          if (self.settings.highlightMatchedText) {
            var cb = self.settings.highlightCallback;

            if (cb && typeof cb === 'function') {
              text = cb(text, term);
            } else {
              text = (function searchItemHighlighter(itemText, term) {
                // Base iterator for highlighting valid, searched items.
                // This won't run if a callback is present.
                var exp = new RegExp('(' + term + ')', 'gi');
                itemText = itemText.replace(exp, '<i>$1</i>');
                return itemText;
              })(text, term);
            }

            // Replace the content with
            if (isString) {
              item = text;
            } else {
              $(item).clone().text(text);
            }
          }
          */

          items.push(item);
        }

        return;
      }

      // Run the iterator
      list.forEach(searchItemIterator);

      // If we originally took in a jQuery selector, rebuild that jQuery selector with the relevant results.
      if (isJQuery) {
        var jqSelector = $();
        items.forEach(function(item) {
          jqSelector = jqSelector.add($(item));
        });

        items = jqSelector;
      }

      return items;
    },

    updated: function(settingsObj) {
      this.settings = $.extend({}, this.settings, settingsObj);
      return this
        .teardown()
        .init();
    },

    teardown: function() {
      return this;
    },

    destroy: function() {
      return this.teardown();
    }

  };

  // Add it to the Window for use
  window.ListFilter = ListFilter;

/** 
* HELP MODAL control for help systems, mludwig  
*/

	$.fn.help = function(options) {

		// Settings and Options
		var pluginName = 'help',
			defaults = {contenttitle: 'Help'},
			settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Help(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }			
    // Plugin Methods
    Help.prototype = {

      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },	

	  setup: function() {
        this.isBody = $(this.element).is('body');
		var contenttitle = Locale.translate('Help');
		this.settings.contenttitle = contenttitle !== undefined ? contenttitle.toString() : this.settings.contenttitle;
		return this;
	  },
	  build: function() {
		  this.modal = $('#help-modal');
		  $('<div class="modal-content"></div>').appendTo($('body').find('#help-modal'));
		  var modalcontent = $('#help-modal').find('.modal-content');
		  $('<iframe id="help-iframe" class="helpiframe"></iframe>').appendTo(modalcontent);
		  $('#help-iframe').attr('src',"help.html");
		  
		   
		  return this;
	  },
	  handleEvents: function() {
		  var self = this;

		  this.modal.data('modal').element.on('beforeopen.help', function() {
			self.modal.find('body').scrollTop(0);
		  });

		   $('#help-modal .close-container button').on('mouseover', function () {
				$('#help-iframe').contents().find("div.close-container button.btn-icon").attr('title',Locale.translate('Close'));			   
		   });	
		  $(document).on('keydown.help', function(e) {
          // Close on Escape.
			  if (e.which === 0 || e.which === 27) {
				self.close();
				}
			});

		$('.buttonset.help, #menuhelp').on('touchstart.help mousedown.help touchend.help', function() {
			self.open();
			inforhelp.helpFileInit(function() {			
				$('#help-iframe').contents().find("div.close-container button.btn-icon").on('touchstart.help mousedown.help touchend.help',function() {
					self.close();
				});				
			});			
		}).on('click.help', function() {
			self.open();
			inforhelp.helpFileInit(function() {	
				$('#help-iframe').contents().find("div.close-container button.btn-icon").on('click.help',function() {
					self.close();
				});
			});				
		});
		return this;
	  },
	  close: function() {
        var modalApi = this.modal.data('modal');
		$('.modal-page-container').attr('aria-hidden','true');
        if (modalApi) {
          modalApi.close();
        }

        if (this.isBody) {
          this.destroy();
        }
      },
	  open: function() {
        var modalApi = this.modal.data('modal');
        if (modalApi) {
          modalApi.open();;
        }
      }
	};
	
	
	// Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
      } else {
        instance = $.data(this, pluginName, new Help(this, settings));
      }
    });	
};
  
  
/** 
* PDF DIALOG MODAL control for help systems, mludwig 
* This is a modal to popup if no PDF exists for a map.
* Gives user option of viewing list of available PDFs
*/

	$.fn.pdfdialog = function(options) {

		// Settings and Options
		var pluginName = 'pdfdialog',
			defaults = {contenttitle: 'PDF dialog'},
			settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Pdfdialog(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }			
    // Plugin Methods
    Pdfdialog.prototype = {

      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },	

	  setup: function() {
        this.isBody = $(this.element).is('body');
		var contenttitle = Locale.translate('PDF');
		this.settings.contenttitle = contenttitle !== undefined ? contenttitle.toString() : this.settings.contenttitle;
		return this;
	  },
		  
	  build: function() {
		  this.modal = $('#pdf-modal');
		  $('<div class="modal-content"></div>').appendTo($('body').find('#pdf-modal'));
		  let modalcontent = $('#pdf-modal').find('.modal-content');
		  $('<div class="modal-body"></div>').appendTo(modalcontent);
		  // let pdfmessage1="<p>No PDF is available for the current document.</p>";
		  let pdfmessage1 = '<p>' + Locale.translate("pdfmessage1") + '</p>';
		  // let pdfmessage2="<p>Click OK to view the list of available PDFs.</p>";
		  let pdfmodalbody = $('#pdf-modal').find('.modal-body').first();
		  $(pdfmessage1).appendTo(pdfmodalbody);
		  $('<div class="pdfbodydiv"></div>').appendTo(pdfmodalbody);
		  let pdfbodydiv = pdfmodalbody.find('div').first();
		  // Need to create translation string so Locale.translate('PDFList') works
		 // $('<button class="btn-ok">PDF List</button>').appendTo($(pdfbodydiv));
		  $('<button class="btn-ok">' + Locale.translate("PDFlist") + '</button>').appendTo($(pdfbodydiv));
		  $('<button class="btn-cancel">' + Locale.translate("Cancel") + '</button>').appendTo($(pdfbodydiv));
		  return this;
	  },
	  handleEvents: function() {
		  var self = this;

		  this.modal.data('modal').element.on('beforeopen.pdfdialog', function() {
			self.modal.find('div').scrollTop(0);
		  });

		   $('#pdf-modal .btn-cancel').on('mouseover', function () {
				$('#pdf-iframe').contents().find("div button.btn-cancel").attr('title',Locale.translate('Cancel'));			   
		   });
		   $('#pdf-modal .btn-ok').on('mouseover', function () {
				$('#pdf-iframe').contents().find("div button.btn-ok").attr('title',Locale.translate('OK'));			   
		   });
		  $(document).on('keydown.pdfdialog', function(e) {
          // Close on Escape.
			  if (e.which === 0 || e.which === 27) {
				self.close();
				}
			});

		$('.buttonset.pdf, #printpdf').on('touchstart.pdfdialog mousedown.pdfdialog click.pdfdialog touchend.pdfdialog', function() {
			let pdfjspath = "oxyhelp7-pdf.js";
			let bookdataid = $(".booktitle",window.document).first().attr("data-id");
			if (bookdataid !== undefined) {
				pdfjspath = bookdataid + "/" + pdfjspath;
				inforhelp.checkpdfjs(pdfjspath, function(pdfjsexists){
					if (!pdfjsexists) {
						inforhelp.pdfMessageInit(function() {
						});
						self.open();
					}
				});				
			}		
		});
		/*.on('click.pdfdialog', function() {
			let pdfjspath = "oxyhelp7-pdf.js";
			let bookdataid = $(".booktitle",window.document).first().attr("data-id");
			if (bookdataid !== undefined) {
				pdfjspath = bookdataid + "/" + pdfjspath;
				inforhelp.checkpdfjs(pdfjspath, function(pdfjsexists){
					if (!pdfjsexists) {
						inforhelp.pdfMessageInit(function() {
						});
						self.open();
					}
				});				
			}			
		});*/
		return this;
	  },
	  close: function() {
        var modalApi = this.modal.data('modal');
		$('.modal-page-container').attr('aria-hidden','true');
        if (modalApi) {
          modalApi.close();
        }

        if (this.isBody) {
          this.destroy();
        }
      },
	  open: function() {
        var modalApi = this.modal.data('modal');
        if (modalApi) {
          modalApi.open();;
        }
      }
	};
	
	
	// Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
      } else {
        instance = $.data(this, pluginName, new Pdfdialog(this, settings));
      }
    });	
};
/** 
* TOPIC PLUGIN for topic page init, mludwig  
*/

	$.fn.topic = function(options) {

		// Settings and Options
		var pluginName = 'topic',
			defaults = {},
			settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Topic(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }			
    // Plugin Methods
    Topic.prototype = {

      init: function() {
        return this
          .handleEvents();
      },	

     handleEvents: function() {
        var self = this,
          headerWhereMouseDown = null,
          linkFollowedByTouch = null;
        // Intercepts a 'touchend' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function touchendInterceptor(e, element) {
          linkFollowedByTouch = true;
          return handleTopicClick(e, element);
		  //result = self['handleTopicClick'](e, element);

          //if (!result) {
           // e.preventDefault();
         // }
         // return result;
        }

        // Intercepts a 'click' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function clickInterceptor(e, element) {
          if (linkFollowedByTouch) {
            linkFollowedByTouch = null;
            return false;
          }
          return handleTopicClick(e, element);
        }
		
		function handleControlClick(e, element) {
			var dataid = $(element).attr('data-file');
			var newURL = buildURL(dataid, element);
			inforhelp.openControlClickTab(newURL);
		}
		function handleImgClick(e,element) {
			let imgHref = $(element).attr('src');
			let map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
			if (varstore.isCollection) {
				imgHref = map + "/" + imgHref;
			}
			let winopener = window.open(imgHref, '_blank');
            winopener.opener = null;
		}
		
		function buildURL(dataid, element) {
			// coll-link class is for special collection links to other help systems/doc libraries
			if ($(element).hasClass('coll-link')) {
				  return window.location.protocol + "//" + window.location.host + "/" + dataid;
			  }
			var startpage = "default.html";
			var startroot = window.document.getElementsByTagName('html');
			var whpath = startroot[0].parentNode.documentURI;
			if (whpath.indexOf("?") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("?"));
			}
			if (whpath.indexOf("#") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("#"));
			}
			whpath = whpath.substring(0,whpath.lastIndexOf("/")+1);	
			if (dataid.indexOf("/") == 0) {
				// This assumes that any xref with scope=external that starts with a slash
				// is meant to link to different help system on same server using the 
				// format: "differentHelpSys/default.html?helpcontent=sometopic.html
				var serverroot = window.location.protocol + '//' + window.location.host;
				return serverroot + dataid;
			}
			if (dataid.indexOf("/") > 0 && !varstore.isCollection && dataid.indexOf("http:") == -1 && dataid.indexOf("https:") == -1) {
				dataid = dataid.substring(dataid.lastIndexOf("/") +1);
			}
			var ellipsis = inforhelp.getFrequency(dataid,"..");	
			var map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
			var pathTopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
			var basetopic = "";
			if (varstore.isCollection) {
				basetopic = map + "/" + pathTopic;
			}
			else {
				basetopic = pathTopic;
			}
			var srcurl = $('#landing',window.document).attr('src');
			if (srcurl.indexOf("?hl") != -1) {
				var hl = srcurl.substring(srcurl.indexOf("?hl")+4);
				//basetopic = basetopic.substring(0,basetopic.indexOf("?hl"));
				basetopic = basetopic + "&hl=" + hl;
			}
			var mapfolder = "";
			var relpath = "";
			
			var nonhtmlfile = false;
			var pdffile = false;
			var httpurl = false;
			if (dataid != undefined) {
				nonhtmlfile = dataid.indexOf(".htm") == -1;
				pdffile = dataid.indexOf(".pdf") != -1;
				httpurl = dataid.indexOf("http:") != -1 || dataid.indexOf("https:") != -1;				
			}	
			var nonEnglishTopic = $(element).parents('html.fixed').attr('lang') != "en-us";
			var englishTopic = $(element).parents('html.fixed').attr('lang') == "en-us";
			var nonEnglishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us";
			var englishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == "en-us";				
			
			if (varstore.isCollection && (englishHelpSys || (nonEnglishTopic && nonEnglishHelpSys))) {
				mapfolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content') + "/";
				relpath = basetopic.substring(basetopic.indexOf(mapfolder)+mapfolder.length+1);
				relpath = relpath.substring(0,relpath.lastIndexOf("/"));
			}
			
			// for links to web sites				
			if (dataid.indexOf("http:") != -1 || dataid.indexOf("https:") != -1) {
				return dataid;
			}
			// for links in English topics displayed in non-English help systems or collections
			if (englishTopic && nonEnglishHelpSys) {	
				if (!varstore.isCollection || (varstore.isCollection && dataid.indexOf("cover.html") == -1)) {
					if (dataid.indexOf(".htm") != -1) {
						return whpath + startpage + "?helpcontent=" + dataid;
					}
					else if (nonhtmlfile) {
						mapfolder = basetopic.substring(basetopic.indexOf("/en-us/")+7);
						var url = "";
						var mapfolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content') + "/";
						if (!varstore.isCollection) {
							url = whpath + dataid;
						}
						else {
							url = whpath + mapfolder + dataid;
						}
						if (inforhelp.UrlExists(url)) {
							return url;
						}
						else {	
							// try the English help system
							var currLang = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase();
							url = url.replace(currLang,"en-us");
							return url;
						}
					}						
				}
				else if (varstore.isCollection && dataid.indexOf("cover.html") != -1) {
					// special case of links to a cover.html in an English topic/non-English collection, such as Home breadcrumb
					var map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
					var pathTopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
					dataid = map + "/" + dataid;
					return whpath + startpage + "?helpcontent=" + dataid;
				}
			}
			// for inline links to pdf or Excel files stored internally (and not handled in previous if)
			if (dataid.indexOf(".pdf") != -1) {
				var basedir = whpath.substring(0,whpath.lastIndexOf("/")); // not needed???
				basedir = basedir.substring(basedir.lastIndexOf("/")) // not needed????
				if ($(element).hasClass('pdffile')) {
					// already has map folder if pdffile class (from pdflist page)
					return dataid;
				}
				else {
					// needs mapfolder (it's an topic inline link)
					return mapfolder + dataid;
				}				
			}	
			// for links to other topics in collection topics
			if (varstore.isCollection) {
				if ($('#landing',window.document).contents().find('html').hasClass('cover')){
					return whpath + startpage + "?helpcontent=" + dataid;
				}
				if (ellipsis > 0) {
					for (var i = 0; i < ellipsis; i++) {
						relpath = relpath.substring(0,relpath.lastIndexOf("/"));
						dataid = dataid.substring(dataid.indexOf("/") + 1);
					}

					if (relpath.length > 0) {
						return whpath + startpage + "?helpcontent=" + mapfolder + relpath + "/" + dataid;
					}
					else {
						return whpath + startpage + "?helpcontent=" + mapfolder + dataid;
					}					
				}
				else if (ellipsis == 0 && mapfolder != "") {
					return whpath + startpage + "?helpcontent=" + mapfolder + dataid;					
				}
				else if (ellipsis == 0 && mapfolder == "") {
					// Should occur on collection landing page links to cover page of a help system.
					// Assumes non-html links would never be on landing page.
					return whpath + startpage + "?helpcontent=" + dataid;
				}
			}
			// for links to other topics in standalone help system topics
			else {
				return whpath + startpage + "?helpcontent=" + dataid;
			}					 		 
		 }
		 
		var allTopicAnchors = $('#landing',window.document).contents().find('.wh_topic_page a[data-file], .wh_main_page a[data-file]').not('#contextmenu-2 a, #contextmenu-3 a, #contextmenu-4 a');
		allTopicAnchors.on('touchend.topic', function(e) {
			e.stopPropagation();
			if (e.cancelable) {
				e.preventDefault();
			}			
		  return touchendInterceptor(e, $(this));
		}).on('click.topic', function(e) {
			//move below to handleTopicClick???
			e.stopPropagation();
			if (e.cancelable) {
				e.preventDefault();
			}
			var dataid = $(this).attr('data-file');
			if ( e.ctrlKey ) {
				if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
					return handleControlClick(e, $(this));
				}
			} else {
				if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
					return clickInterceptor(e, $(this));
				}
			}			
		}).on('focusin.topic', function(e) {
			var target = $(e.target);			
			if (!self.originalSelection) {
				self.originalSelection = target;
			}
			if (target.is(':not(.btn)')) {
				$(this).addClass('is-focused');
			}
		}).on('focusout.topic', function() {
		  $(this).removeClass('is-focused');
		}).on('keydown.topic', function(e) {
		  //self.handleKeys(e);
		  //NEED TO ADD HANDLEKEYS TO TOPIC PLUGIN AT SOME POINT, MAYBE FOR SPACE KEY or other 508 stuff
		}).on('mousedown.topic', function(e) {
		  $(this).addClass('is-focused');
		  headerWhereMouseDown = e.target;
		}).on('mouseup.topic', function() {
		  headerWhereMouseDown = null;
		});

        this.element.on('selected.topic', function(e) {
          // Don't propagate this event above the element
          e.stopPropagation();
        }).on('updated.topic', function(e) {
          // Don't propagate just in case this is contained by an Application Menu
          e.stopPropagation();
          //self.updated();
        });
		
		let topicImg = $('#landing',window.document).contents().find('img');
		topicImg.on('click.topic', function(e) {
			return handleImgClick(e, $(this));
		});
		
		function handleTopicClick(e, anchor) {
			var dataid = $(anchor).attr('data-file');
			var startroot = window.document.getElementsByTagName('html');
			var whpath = startroot[0].parentNode.documentURI;
			// adjust whpath to remove /startpage.html and following text. Note need to check for a slash in parameter
			if (whpath.indexOf("helpcontent=") != -1) {
				if (whpath.indexOf("/default.html") != -1) {
					whpath = whpath.substring(0,whpath.lastIndexOf("/default.html"));
				}
				else if (whpath.indexOf("/index.html") != -1) {
					whpath = whpath.substring(0,whpath.lastIndexOf("/index.html"));
				}
				else if (whpath.indexOf("/default.html") == -1 && whpath.indexOf("/index.html") == -1) {
					// non-standard start file, must figure it out in order to remove it
					var contentparam = whpath.substring(whpath.indexOf("helpcontent="));
					if (contentparam.indexOf("/") != -1) {
						//remove / in content parameter part of whpath
						whpath = whpath.substring(0,whpath.lastIndexOf("/"));
						// remove / and start page html from whpath
						whpath = whpath.substring(0,whpath.lastIndexOf("/"));
					}
					else {
						whpath = whpath.substring(0,whpath.lastIndexOf("/"));
					}
				}
			}
			
			var nonhtmlfile = false;
			var pdffile = false;
			var httpurl = false;
			if (dataid != undefined) {
				nonhtmlfile = dataid.indexOf(".htm") == -1;
				pdffile = dataid.indexOf(".pdf") != -1;
				httpurl = dataid.indexOf("http:") != -1 || dataid.indexOf("https:") != -1;				
			}
			var nonEnglishTopic = $(anchor).parents('html.fixed').attr('lang') != "en-us";
			var englishTopic = $(anchor).parents('html.fixed').attr('lang') == "en-us";
			var nonEnglishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us";
			var englishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == "en-us";
			var collink = $(anchor).hasClass('coll-link');
			if (collink) {
				dataid = window.location.protocol + "//" + window.location.host + "/" + dataid;
				inforhelp.openCollectionTOCLink(dataid);
				return;
			}
			if (pdffile && !httpurl && (englishHelpSys || (nonEnglishHelpSys && nonEnglishTopic))) {
				if (varstore.isCollection) {
					// modify dataid for inline links to internal pdfs in collections
					var mapfolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
					var basetopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
					if (mapfolder != undefined && basetopic != undefined && varstore.isCollection) {
						if ($(anchor).hasClass('pdffile')) {
							// already has map folder if pdffile class (from pdflist page)
							inforhelp.checkEnglishNonHtmlLink(dataid,true);
						}
						else {
							// needs mapfolder (it's a topic inline link)
							dataid = mapfolder + "/" + dataid;
							inforhelp.checkEnglishNonHtmlLink(dataid,false);
						}						
					}
				}
				// send dataid to check if file exists, and then display it
				
			}
			if (englishTopic && nonEnglishHelpSys) {
				// for links in non-English help system when viewing English fallback topic
				if (!nonhtmlfile && !httpurl) {
					// for links to internal html files
					inforhelp.checkEnglishTopicLink(dataid);
				}
				else if (nonhtmlfile && !httpurl) {
					// for links to internal PDFs but those reside in the English help system, not the current non-English one
					// and user is currently viewing an English fallback topic
					var basetopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
					var mapfolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
					dataid = whpath + "/" + mapfolder + "/" + dataid;
					inforhelp.checkEnglishNonHtmlLink(dataid);
				}
				else {
					// if it gets here, just go to gotopic and let it handle things
					inforhelp.goTopic(dataid);
				}
			}
			else if (!nonEnglishHelpSys || (nonEnglishHelpSys && nonEnglishTopic)) {
				// for English help systems and case of non-English topic in non-English help
				if (!nonhtmlfile || (nonhtmlfile && !pdffile) || (nonhtmlfile && httpurl)) {
					inforhelp.goTopic(dataid);
				}				
			}
			else {
				console.log("Error: Topic link not handled");
			}
		}
        return this;
      },
	};
	
	// Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
      } else {
        instance = $.data(this, pluginName, new Topic(this, settings));
      }
    });	
};

/** 
* TOPICLIST MODAL control for collections, mludwig  
*/

	$.fn.topiclist = function(options) {

		// Settings and Options
		var pluginName = 'topiclist',
			defaults = {contenttitle: 'Multiple Topics Found'},
			settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Topiclist(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }			
    // Plugin Methods
    Topiclist.prototype = {

      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },	

	  setup: function() {
        this.isBody = $(this.element).is('body');
		var contenttitle = Locale.translate('MultiTopicsFound');
		this.settings.contenttitle = contenttitle !== undefined ? contenttitle.toString() : this.settings.contenttitle;
		return this;
	  },
	  build: function() {
		  //this.modal = $('<div class="modal listtopic" id="listtopic-modal"></div>');
		  this.modal = $('#listtopic-modal');
		  $('<div class="modal-content"></div>').appendTo($('body').find('#listtopic-modal'));
		  var header = $('<div class="modal-header"></div>').appendTo($('body').find('#listtopic-modal .modal-content'));
		  var closetitle = Locale.translate("Close");
		  $('<div class="close-container"></div>')
		  .append($('<button name="close listtopic" type="button" class="btn-icon hide-focus" title="' + closetitle +'"></button>')
		  .append($.createIconElement({ icon: 'close', classes: 'icon-close' }))
		  .append('<span>' + Locale.translate('Close') + '</span>'))
		  .appendTo(header);
		  
		   this.title = $('<h1 class="title topictitle1"></h1>').text(this.settings.contenttitle).appendTo($('body').find('#listtopic-modal .modal-header'));
		   var body = $('<div class="modal-body"></div>').appendTo($('body').find('#listtopic-modal .modal-content'));		
			// add unordered list for topics
		   $('<ul class="ul"></ul>').appendTo(body);		  
		   
		  return this;
	  },
	  handleEvents: function() {
		  var self = this;
		  $('#listtopic-modal').one('open.topiclist', function() {
			  self.open();
		  });
		  this.modal.data('modal').element.on('beforeopen.topiclist', function() {
			self.modal.find('.modal-body').scrollTop(0);
			});		  
		   $('#listtopic-modal li a').on('click.topiclist', function() {
			   self.close();
		   });
		   $('#listtopic-modal .close-container button').on('click.topiclist', function () {
			   self.close();
		   });
		  $(document).on('keydown.topiclist', function(e) {
          // Close on Escape.
			  if (e.which === 0 || e.which === 27) {
				$('.modal-body > p').css('display','block');
				self.close();
				}
			});	
		  return this;
	  },
	  close: function() {
        var modalApi = this.modal.data('modal');

        if (modalApi) {
          modalApi.close();
        }

        if (this.isBody) {
          this.destroy();
        }
      },
	  open: function() {
        var modalApi = this.modal.data('modal');

        if (modalApi) {
          modalApi.open();
        }
      }
	};
	
	
	// Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
      } else {
        instance = $.data(this, pluginName, new Topiclist(this, settings));
      }
    });	
};
/**
* ABOUT Control (TODO: bitly link to soho xi docs)
*/


  $.fn.about = function(options) {

    // Settings and Options
    var pluginName = 'about',
        defaults = {
          appName: 'Infor Application Name',
          content: undefined,
          copyrightYear: new Date().getFullYear(),
          deviceSpecs: true,
          productName: undefined,
          useDefaultCopyright: false,
          version: undefined
        },
        settings = $.extend({}, defaults, options);
		
    // Plugin Constructor
    function About(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    About.prototype = {

      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },
	  footerbuild: function() {
		  if (varstore.isCollection) {
			  $('#footerlinks a').first().attr('title',Locale.translate('links'));
			  $('#footerlinks a').first().text(Locale.translate('links'));
			  $('#feedbacklink a').first().attr('title',Locale.translate('label.feedback'));
			  $('#feedbacklink a').first().text(Locale.translate('label.feedback'));
			  $('#productsupport a').first().attr('title',Locale.translate('ProductSupport'));
			  $('#productsupport a').first().text(Locale.translate('ProductSupport'));			  
			  // for "about" link
			  $('#aboutlink button').attr('title',Locale.translate('label.about'));
			  $('#aboutlink button').text(Locale.translate('label.about'));
			  $('#aboutlink button').attr('data-appname',Locale.translate('HelpLib'));
		  }
	  },
	  
      setup: function() {
        this.isBody = $(this.element).is('body');
		this.footerbuild();
        var appName = this.element.attr('data-appname');
        this.settings.appName = appName !== undefined ? appName.toString() : this.settings.appName;
		// Don't think we need this anymore
        //this.settings.content = content !== undefined ? content.toString() : this.settings.content;

        var copyrightYear = this.element.attr('data-copyright-year');
        this.settings.copyrightYear = copyrightYear !== undefined ? copyrightYear.toString() : this.settings.copyrightYear;

        var deviceSpecs = this.element.attr('data-device-specs');
        if (deviceSpecs) {
          this.settings.deviceSpecs = deviceSpecs === 'true';
        }

        var productName = this.element.attr('data-product-name');
        this.settings.productName = productName !== undefined ? productName.toString() : this.settings.productName;

        var useDefaultCopyright = this.element.attr('data-use-default');
        if (useDefaultCopyright !== undefined) {
          this.settings.useDefaultCopyright = useDefaultCopyright === 'true';
        }

        var version = this.element.attr('data-version');
        this.settings.version = version !== undefined ? version.toString() : this.settings.version;

        // Get the default copyright text and cut in the current year
        this.defaultCopyright = Locale.translate('AboutText') + ' <a class="hyperlink" href="http://www.infor.com" rel="noopener noreferrer" target="_blank">www.infor.com</a>.';
        this.defaultCopyright = this.defaultCopyright.replace('{0}', this.settings.copyrightYear);

		//mludwig, new version for copyright - link to documentation legal/copyright page
		var copyrightlink = Locale.translate("Copyrightyear") + ' <a class="hyperlink" id="copyright" href="#">' + Locale.translate("Copyright") + '</a>';
		this.defaultCopyright = copyrightlink.replace('{0}', this.settings.copyrightYear); 
			
        return this;
      },

      build: function() {
		var locale = Locale.currentLocale.name;
        this.modal = $('<div class="modal about" id="about-modal"></div>');
        $('<div class="modal-content"></div>').appendTo(this.modal);
        var header = $('<div class="modal-header"></div>').appendTo(this.modal.find('.modal-content'));
		var closetitle = Locale.translate("Close");
		var backabouttitle = Locale.translate("GoBack");
        $('<div class="back-container" style="display:none"></div>')
          .append($('<button name="back" type="button" class="btn-icon hide-focus" title="' + backabouttitle +'"></button>')
            .append($.createIconElement({ icon: 'left-arrow', classes: 'icon-left-arrow' }))
            .append('<span>' + Locale.translate('Back') + '</span>'))
          .appendTo(header);		
        $('<div class="close-container"></div>')
          .append($('<button name="close" type="button" class="btn-icon hide-focus" title="' + closetitle +'"></button>')
            .append($.createIconElement({ icon: 'close', classes: 'icon-close' }))
            .append('<span>' + Locale.translate('Close') + '</span>'))
          .appendTo(header);
        $.createIconElement({ icon: 'logo-registered', classes: ['icon', 'about-logo'] }).attr({ viewBox: '0 0 44 44' }).appendTo(header);
        this.title = $('<h1 class="title"></h1>').text(this.settings.appName).appendTo(this.modal.find('.modal-header'));

        var body = $('<div class="modal-body"></div>').appendTo(this.modal.find('.modal-content'));
		
		// mludwig, adding Oxygen footer to About modal
		var modalfooter = $('<div class="modal-footer"></div>').appendTo(this.modal.find('.modal-content'));
		var ftr1 = '<nav class="navbar navbar-default wh_footer"><div class=" footer-container text-center ">';
		var ftr2 = Locale.translate('WebHelpOutput') + ' <a class="oxyFooter" href="' + encodeURI("http://www.oxygenxml.com") + '" rel="noopener noreferrer" target="_blank"> &lt;oXygen/&gt; XML Author </a>';
		var ftr3 = '</div></nav>'
		var footer = $(ftr1 + ftr2 + ftr3).appendTo(this.modal.find('.modal-footer'));
		
        $('<p></p>').text(this.settings.productName).appendTo(body);
        
		var versionContent = this.element.attr('data-version');
		var dateContent = this.element.attr('data-date');
		var refContent = this.element.attr('data-about-content');
		var dataid = $('#inforFeedback').data('id');
		var versionNbr = dataid.substring(dataid.indexOf("_")+1);
		versionNbr = versionNbr.substring(0,versionNbr.indexOf("_"));
		var versionText = Locale.translate('Version');
		var dateText = Locale.translate('Date');
		var year = dataid.substring(dataid.lastIndexOf('-')+1,dataid.lastIndexOf('-')+5);
		var month = dataid.substring(dataid.lastIndexOf('-')+5,dataid.lastIndexOf('-')+7) - 1;
		var day = dataid.substring(dataid.lastIndexOf('-')+7,dataid.lastIndexOf('-')+9);
		var datesrc = new Date(year,month,day);
		var dateVal = datesrc.toLocaleDateString(locale);
		var refidText = Locale.translate('ReferenceID');
		
		if (varstore.isCollection) {
			versionContent = versionText + ": " + versionNbr;
			dateContent = dateText + ": " + dateVal;
			refContent = refidText + ": " + dataid;
		}

		var versionNode = $('<p></p>').html(versionContent);
		var dateNode = $('<p></p>').html(dateContent);
		var refNode = $('<p></p>').html(refContent);
		var addContent = $('<div class="additional-content"></div>');
		addContent.append(versionNode);
		addContent.append(dateNode);
		addContent.append(refNode);
		addContent.appendTo(body);
	

        if (this.settings.useDefaultCopyright || !this.settings.content) {
          $('<p></p>').html(this.defaultCopyright).appendTo(body);
        }
		else {
			// mludwig, use Infor help system copyright link
			$('<p></p>').html(this.defaultCopyright).appendTo(body);
		}

        if (this.settings.deviceSpecs) {
			var browser = Locale.translate("Browser");
			var platform = Locale.translate("platform");
			var helpLocale = Locale.translate("Locale");

          var specs = this.getDeviceSpecs();

          var textcontent = '<span class="browser">' + browser + ': ' + specs.browser + '</span><br>' +
              '<span class="platform">' + platform + ': ' + specs.os + '</span><br>' +
              '<span class="locale">' + helpLocale + ': '  + specs.locale + '</span><br>';
          $('<p></p>').html(textcontent).appendTo(body);
        }
		
		// mludwig, copyright import and copy into modal

		$('<div id="copyrighttext" class="copyright-content" style="display:none"></div>').load( "___c_copyright.html .conbody .section").appendTo(body);

        this.buttons = this.modal.find('button');

        this.modal.find('.hide-focus').one('blur', function () {
          $(this).removeClass('hide-focus');
        });

        this.element.attr('data-modal','about-modal');

        $('.modal-body', this.modal)[0].tabIndex = 0;

        this.modal.appendTo('body');
        this.modal.modal({trigger: this.isBody ? 'immediate' : 'click'});
        return this;
      },

      handleEvents: function() {
        var self = this;
		//mludwig, adding touchstart, changing from this.element to footerlinks (touchstart.about)
		$('#footerlinks').off('touchstart.about mousedown.about touchend.about');
        $('#footerlinks').on('touchstart.about mousedown.about touchend.about', function(e) {
          e.stopPropagation();
		  if (e.cancelable) {
			e.preventDefault();
		  }
		  inforhelp.showlinks();
        });
		$('#aboutlink button').on('touchstart.about mousedown.about touchend.about', function(e) {
          self.element.trigger('click.about');
        });
		$('#aboutlink button').on('open.about', function(e) {
		//this.element.on('open.about', function(e) {
          e.stopPropagation();
          self.element.trigger('click.about');
        });
		$('#doclinks').on('touchstart.about mousedown.about touchend.about', function(e) {
		  $('#doclinks a').trigger('click');
        });
		$('html.android #feedbacklink a, html.ipad #feedbacklink a, html.iphone #feedbacklink a').on('touchstart.about touchend.about', function(e) {
		  inforhelp.sendMail();
        });
		// clear events to avoid multiple events
		$('#feedbacklink a').off('click.about');
		$('#feedbacklink a').on('click.about', function(e) {
			if (window.innerWidth > 640) {
				inforhelp.sendMail();
			}
        });
		$('#feedbacklink a').on('mousedown.about', function(e) {
			// this is for windows phone landscape, mludwig
		  if (window.innerWidth < 481) {
			inforhelp.sendMail();
		  }
        });		
        $('#copyright').on('touchstart.about mousedown.about', function(e) {
          $('#copyright').trigger('click');
        }).on('click.about', function(e) {
			e.stopPropagation();
			$('.modal-body > p, .modal-body > .additional-content').css('display','none');
			$('.back-container').css('display','block');
			$('.copyright-content').css('display','block');
		});
		
        this.buttons.filter('[name="done"], [name="close"]').on('click.about', function() {
			$('.modal-body > p, .modal-body > .additional-content').css('display','block');
			$('.copyright-content').css('display','none');	
			$('.back-container').css('display','none');
			self.close();
        });
		this.buttons.filter('[name="back"]').on('click.about', function() {
			$('.modal-body > p, .modal-body > .additional-content').css('display','block');
			$('.copyright-content').css('display','none');	
			$('.back-container').css('display','none');
        });
		this.copyrtlink = this.modal.find('#copyright');
		this.copyrtlink.on('click', function() {
			$('.modal-body > p, .modal-body > .additional-content').css('display','none');
			$('.back-container').css('display','block');
			$('.copyright-content').css('display','block');
		});
        this.modal.data('modal').element.on('beforeopen.about', function() {
          self.modal.find('.modal-body').scrollTop(0);
        });

        $(document).on('keydown.about', function(e) {
          // Close on Escape.
          if (e.which === 0 || e.which === 27) {
			$('.modal-body > p, .modal-body > .additional-content').css('display','block');
			$('.copyright-content').css('display','none');
			$('.back-container').css('display','none');
            self.close();
          }
        });

        return this;
      },

      getDeviceSpecs: function() {
        var locale = navigator.appName === 'Microsoft Internet Explorer' ? navigator.userLanguage : navigator.language,
          browser = (function(){
            var ua= navigator.userAgent, tem,
            M= ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || [];
            if (/trident/i.test(M[1])){
              tem=  /\brv[ :]+(\d+)/g.exec(ua) || [];
              return 'IE '+(tem[1] || '');
            }
            if (M[1]=== 'Chrome'){
              tem= ua.match(/\bOPR\/(\d+)/);
              if (tem !== null) {
                return 'Opera '+tem[1];
              }
            }
            M= M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];
            if((tem= ua.match(/version\/(\d+)/i)) !== null) {
              M.splice(1, 1, tem[1]);
            }
            return M.join(' ');
          })();

        return {
          browser: browser,
          os: navigator.platform,
          cookiesEnabled: navigator.cookieEnabled,
          locale: locale
        };
      },

      close: function() {
        var modalApi = this.modal.data('modal');

        if (modalApi) {
          modalApi.close();
        }

        if (this.isBody) {
          this.destroy();
        }
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        var modalApi = this.modal.data('modal');

        if (modalApi) {
          modalApi.element.off('beforeopen.about');
          modalApi.destroy();
        }

        this.buttons.off();
        this.element.off('open.about');
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
      } else {
        instance = $.data(this, pluginName, new About(this, settings));
      }
    });
  };

/**
* ACCORDION Control (TODO: bitly link to soho xi docs)
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.

  $.fn.accordion = function(options) {
    'use strict';

    // Settings and Options
    var pluginName = 'accordion',
        defaults = {
          allowOnePane: true,
          displayChevron: true, // Displays a "Chevron" icon that sits off to the right-most side of a top-level accordion header.  Used in place of an Expander (+/-) if enabled.
          rerouteOnLinkClick: true, // Can be set to false if routing is externally handled
          source: null
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Accordion(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Accordion.prototype = {
      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },
	  homeBtnBuild: function() {
		  // setup for Home button in collections, collection title controls the tooltip
		  // other items are set to Home, but don't show
		  if (varstore.isCollection) {
			  var colltitle = $('h2.booktitle').first().text();
			  $('#homebutton span').first().text(Locale.translate('Home'));
			  $('#homebutton').attr('title',colltitle);
			  $('#homebutton a').first().attr('alt',Locale.translate('Home'));
			  $('#homebutton p.home-text').first().text(Locale.translate('Home'));
		  }
	  },
      setup: function() {
		this.homeBtnBuild();
        return this;
      },

      build: function() {
        var self = this;

        //this.headers = this.element.find('.accordion-header');
		
		if (varstore.isCollection) {
			this.headers = this.element.find('.collection');
			this.groupheaders = this.element.find('.collection-group');
			this.linkheaders = this.element.find('.collection-link');
			this.allheaders = this.element.find('.collection, .collection-group, .collection-link');
			this.anchors = this.headers.find('a');
			//this.anchors = this.headers.find('a[data-file]').filter("a:not([data-file=''])").filter("a:not([data-file$='javascript:void(0)'])");			 
			this.panes = this.element.find('.collection, .collection-group').next('.accordion-pane');
			self.addExpander(this.allheaders, this.anchors, this.panes);
		}
		else {
			this.headers = this.element.children('.accordion-header');
			this.anchors = this.element.children('.accordion-header').children('a[data-file]').filter("a:not([data-file=''])").filter("a:not([data-file$='javascript:void(0)'])");	
			this.anchors2 = this.element.find('.accordion-pane').children('.accordion-header').find('a[data-file]').filter("a:not([data-file=''])").filter("a:not([data-file$='javascript:void(0)'])");
			this.panes = this.headers.next('.accordion-pane');
			self.addExpander(this.headers, this.anchors, this.panes);
		}

        //var headersHaveIcons = false;

        return this;
      },
	  
	  //mludwig
	  addExpander: function(headers, anchors, panes) {
		  var self = this;
		  var headersHaveIcons = false;
		  headers.each(function() {
			var header = $(this),
            hasIcons = false,
            containerPane = header.parent(),
            isTopLevel = containerPane.is('.accordion');
          function checkIfIcons() {
            if (isTopLevel) {
              return;
            }

            if (!hasIcons) {
              header.addClass('no-icon');
              return;
            }
            containerPane.addClass('has-icons');
          }

          header.attr('role', 'presentation').hideFocus();

          // For backwards compatibility:  If an icon is found inside an anchor, bring it up to the level of the header.
          header.children('a').find('svg').detach().insertBefore(header.children('a'));

          var outerIcon = header.children('.icon, svg');
          outerIcon.addClass('icon').attr({'role': 'presentation', 'aria-hidden': 'true', 'focusable': 'false'});
          if (isTopLevel && outerIcon.length) {
            headersHaveIcons = true;
          }

          if (header.is('.list-item') || (!isTopLevel && header.find('button').length)) {
            hasIcons = true;
          }

          // Enable/Disable
          if (header.hasClass('is-disabled')) {
            header.children('a, button').attr('tabindex', '-1');
          }

          // Don't continue if there's no pane
          if (!header.next('.accordion-pane').length) {
            checkIfIcons();
            return;
          }

          hasIcons = true;
          var expander = header.children('.btn');
          if (!expander.length) {
            expander = $('<button class="btn" type="button"></button>');

            var method = 'insertBefore';
            if (self.settings.displayChevron && isTopLevel) {
              header.addClass('has-chevron');
              method = 'insertAfter';
            }
            expander[method](header.children('a'));
            header.data('addedExpander', expander);
          }

          // Hide Focus functionality (mludwig, 8-8-19, removing hiding for 508)
         // expander.hideFocus();

          // If Chevrons are turned off and an icon is present, it becomes the expander
          if (outerIcon.length && !self.settings.displayChevron) {
            outerIcon.appendTo(expander);
          }			
			
          var expanderIcon = expander.children('.icon, .svg, .plus-minus');
          if (!expanderIcon.length) {
            if (self.settings.displayChevron && isTopLevel) {
              expanderIcon = $.createIconElement({ icon: 'caret-down', classes: ['chevron'] });
            } else {
              var isActive = self.isExpanded(header) ? ' active' : '';
              expanderIcon = $('<span class="icon plus-minus'+ isActive +'" aria-hidden="true" role="presentation"></span>');
            }
            expanderIcon.appendTo(expander);
          }
          var expanderIconOpts = {
            'role': 'presentation',
            'aria-hidden': 'true'
          };
          if (!expanderIcon.is('span')) {
            expanderIconOpts.focusable = 'false';
          }
          expanderIcon.attr(expanderIconOpts);

          // Move around the Expander depending on whether or not it's a chevron
          if (expanderIcon.is('.chevron') && !(header.is('.has-chevron'))) {
            header.addClass('has-chevron');
            expander.insertAfter(header.children('a'));
          } else if (!(expanderIcon.is('.chevron')) ) {
            header.removeClass('has-chevron');
            expander.insertBefore(header.children('a'));
          }

          // Double check to see if we have left-aligned expanders or icons present,
          // so we can add classes that do alignment
          if (!self.settings.displayChevron && isTopLevel) {
            headersHaveIcons = true;
          }
          checkIfIcons();

          // Add an Audible Description to the button
          var description = expander.children('.audible');
          if (!description.length) {
            description = $('<span class="audible"></span>').appendTo(expander);
          }
          description.text(Locale.translate('Expand'));
        });
        if (headersHaveIcons) {
          this.element.addClass('has-icons');
        }
        panes.each(function addPaneARIA() {
          var pane = $(this),
            header = pane.prev('.accordion-header');
          header.children('a').attr({'aria-haspopup': 'true', 'role': 'button'});
			// below seems backwards but doesn't work if I reverse logic
          if (!self.isExpanded(header)) {
            pane.data('ignore-animation-once', true);
			// mludwig, switching to leaving TOC expanded, only collapse on user choice
            //self.collapse(header);
          }
        });
		
        // Expand to the current accordion header if we find one that's selected
        if (!this.element.data('updating')) {
          var targetsToExpand = this.headers.filter('.is-selected, .is-expanded');
          if (this.settings.allowOnePane) {
            targetsToExpand = targetsToExpand.first();
          }
	// commenting this out, not needed in our help, seems to confuse it
          //this.expand(targetsToExpand);

          //this.select(targetsToExpand.last());
        }				 	  
	  },	  
		  
      handleEvents: function() {
        var self = this,
          headerWhereMouseDown = null,
          linkFollowedByTouch = null;


        // Returns "Header", "Anchor", or "Expander" based on the element's tag
        function getElementType(element) {
          var elementType = 'Header';
          if (element.is('a')) {
            elementType = 'Anchor';
          }
          if (element.is('button')) {
            elementType = 'Expander';
          }
		  if (elementType == 'Header' && varstore.isCollection && element.hasClass("collection-link")) {
			  elementType = "Link";
		  }
          return elementType;
        }

        // Intercepts a 'touchend' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function touchendInterceptor(e, element) {
          linkFollowedByTouch = true;
          var type = getElementType(element),
            result = self['handle' + type + 'Click'](e, element);
          if (!result) {
			if (e.cancelable) {
				e.preventDefault();
			}
          }
          return result;
        }
		function handleControlClick(e,anchor) {
			var newURL = "";
			var dataid = anchor.attr('data-file');
		  // for special collection links to other help systems/doc libraries
		  if ($(anchor).parent('.accordion-header.list-item').hasClass('collection-link')) {
			  newURL =  window.location.protocol + "//" + window.location.host + "/" + dataid;
			  inforhelp.openCollectionTOCLink(newURL);
		  }			
		  else {
			  if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
				var startpage = "default.html";
				var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
				if (varstore.isCollection) {
					var mapfolder = inforhelp.getMapFolder(dataid);
					whpath = whpath.substring(0, whpath.indexOf(mapfolder));				
				}
				newURL = whpath + startpage + "?helpcontent=" + dataid;
				inforhelp.openControlClickTab(newURL);						
			  }
		  }		  
	  }
	  function handleDblclick (e, element) {
			var type = getElementType(element);
			if (type == "Header") {
				if (element.next('.accordion-pane').hasClass('is-expanded')) {
					toggleExpander(element);
				}
				else {
					//grpheader not expanded, doing same as single click
					clickCollHeaderGroupClick(e,element);
				}
			}
			else if (type == "Anchor") {
			   //clickInterceptor(e, element);
			   if (element.next('.btn').length > 0 ) {
				   clickInterceptor(e, element.next('.btn'));
			   } else if (element.prev('.btn').length > 0) {
				   clickInterceptor(e, element.prev('.btn'));
			   }				
			}
	  }
	  
	  function toggleExpander(element) {
          if (element.next('.accordion-pane').hasClass('is-expanded')) {	
            self.toggle(element);
          }
          element.focus();
        }
	  
        // Intercepts a 'click' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function clickInterceptor(e, element) {
          var type = getElementType(element);
          if (linkFollowedByTouch) {
            linkFollowedByTouch = null;
            return false;
          }
          return self['handle' + type + 'Click'](e, element);
        }
		
        function clickCollInterceptor(e, element) {
          var type = getElementType(element);
          if (linkFollowedByTouch) {
            linkFollowedByTouch = null;
            return false;
          }
		   if (type == "Expander") {
			   return self['handle' + type + 'Click'](e, element);
		   }
		   else if (type !== 'Link') {
				return self['handleColl' + type + 'Click'](e, element);
		   }
		   else if (type == 'Link') {
			   return self['handle' + type + 'Click'](e, element);
		   }
        }
		function clickCollHeaderGroupClick(e, element) {
			return self.handleCollHdrGrpClick(e, element);			
		}
				
		if (!varstore.isCollection) {
			var touchmoved;
			this.headers.on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved != true){
					return touchendInterceptor(e, $(this));
				}				
			}).on('touchmove.accordion', function(e){
				touchmoved = true;
			}).on('touchstart.accordion', function(e){
				touchmoved = false;			  
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else if (!touchmoved) {
					return clickInterceptor(e, $(this));
				}				
			}).on('focusin.accordion', function(e) {
				var target = $(e.target);			
				if (!self.originalSelection) {
					self.originalSelection = target;
				}
				if (target.is(':not(.btn)')) {
					$(this).addClass('is-focused');
				}
			}).on('focusout.accordion', function() {
			  if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
				$(this).removeClass('is-focused');
			  }
			  $(this).removeClass('is-focused');
			}).on('keydown.accordion', function(e) {
			  self.handleKeys(e);
			}).on('mousedown.accordion', function(e) {
			  $(this).addClass('is-focused');
			  headerWhereMouseDown = e.target;
			}).on('mouseup.accordion', function() {
			  headerWhereMouseDown = null;
			});
			
			var hdrchildren = this.headers.next('.accordion-pane').children('.list-item');
			hdrchildren.on('focusin.accordion', function(e) {
			  var target = $(e.target);
			  if (!self.originalSelection) {
				self.originalSelection = target;
			  }
			  if (target.is(':not(.btn)')) {
				$(this).addClass('is-focused');
			  }
			}).on('focusout.accordion', function() {
			  if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
				$(this).removeClass('is-focused');
			  }
			});	
		}
		var clicks = 0;
		var timer = null;
		if (varstore.isCollection) {
			var touchmoved;
			// MIGHT NEED TO SET UP TOUCHMOVE FOR GROUPHEADERS, THOUGH THEY SHOULD BE SHORT
			this.groupheaders.on('touchend.accordion', function(e) {
				//SWITCH BELOW TO NEW HEADER GROUP CLICK?? ADD CTRL CLICK???
			  return touchendInterceptor(e, $(this));
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				clicks++; // Increment click counter
				var collgrpheader = $(this);
				if (clicks === 1) {
					timer = setTimeout(function() {							
					  clicks = 0; //Reset
					  return clickCollHeaderGroupClick(e, collgrpheader);
					}, 200); // Increase or decrease if there is slowness or speed
			    } else {
					clearTimeout(timer); //prevent single-click action
					clicks = 0; // Reset
					return clickCollHeaderGroupClick(e, collgrpheader);
				}										
			}).on('dblclick.accordion', function(e) {
				e.preventDefault();
			});
			
			this.headers.on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved != true){
					return touchendInterceptor(e, $(this));
				}
			}).on('touchmove.accordion', function(e){
				touchmoved = true;
			}).on('touchstart.accordion', function(e){
				touchmoved = false;				
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				// No need for Ctrl+Click event here, handled by hdranchors Ctrl+Click
				if (!touchmoved){
					return clickCollInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			}).on('focusin.accordion', function(e) {
				var target = $(e.target);
				if (!self.originalSelection) {
					self.originalSelection = target;
				  }
				if (target.is(':not(.btn)')) {
					$(this).addClass('is-focused');
				  }
			}).on('focusout.accordion', function() {
			  if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
				$(this).removeClass('is-focused');
			  }
			}).on('keydown.accordion', function(e) {
			  self.handleKeys(e);
			}).on('mousedown.accordion', function(e) {
			  $(this).addClass('is-focused');
			  headerWhereMouseDown = e.target;
			}).on('mouseup.accordion', function() {
			  headerWhereMouseDown = null;
			});

			this.linkheaders.on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved != true){
					return touchendInterceptor(e, $(this));
				}
			}).on('touchmove.accordion', function(e){
				touchmoved = true;
			}).on('touchstart.accordion', function(e){
				touchmoved = false;				
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				// No need for Ctrl+Click event here, handled by hdranchors Ctrl+Click
				if (!touchmoved){
					return clickCollInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				// maybe no need to double-click collection links
				//return handleDblclick(e, $(this));
			}).on('focusin.accordion', function(e) {
				var target = $(e.target);
				if (!self.originalSelection) {
					self.originalSelection = target;
				  }
				if (target.is(':not(.btn)')) {
					$(this).addClass('is-focused');
				  }
			}).on('focusout.accordion', function() {
			  if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
				$(this).removeClass('is-focused');
			  }
			}).on('keydown.accordion', function(e) {
			  self.handleKeys(e);
			}).on('mousedown.accordion', function(e) {
			  $(this).addClass('is-focused');
			  headerWhereMouseDown = e.target;
			}).on('mouseup.accordion', function() {
			  headerWhereMouseDown = null;
			});
			
			// SECTION BELOW CAN BE DELETED PROBABLY, headers ALREADY ONLY HAS .collection
			this.headers.filter(':not(.collection):not(.collection-group):not(.collection-link)')
			  .on('touchend.accordion', function(e) {
			  return touchendInterceptor(e, $(this));
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else {
					return clickInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			}).on('focusin.accordion', function(e) {
				var target = $(e.target);
				if (!self.originalSelection) {
					self.originalSelection = target;
				  }
				if (target.is(':not(.btn)')) {
					$(this).addClass('is-focused');
				  }
			}).on('focusout.accordion', function() {
			  if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
				$(this).removeClass('is-focused');
			  }
			}).on('keydown.accordion', function(e) {
			  self.handleKeys(e);
			}).on('mousedown.accordion', function(e) {
			  $(this).addClass('is-focused');
			  headerWhereMouseDown = e.target;
			}).on('mouseup.accordion', function() {
			  headerWhereMouseDown = null;
			}).on('mouseenter.accordion', function() {
				$(this).parent().hide().show(0);
			});		
		}
		
		if (!varstore.isCollection) {
			var touchmoved;
			this.anchors.one('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved != true){
					return touchendInterceptor(e, $(this));
				}
			}).on('touchmove.accordion', function(e){
				touchmoved = true;
			}).on('touchstart.accordion', function(e){
				touchmoved = false;			
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				e.stopPropagation();
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else if (!touchmoved){
					return clickInterceptor(e, $(this));
				}				
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			});	
			this.anchors2.on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved != true){
					return touchendInterceptor(e, $(this));
				}
			}).on('touchmove.accordion', function(e){
				touchmoved = true;
			}).on('touchstart.accordion', function(e){
				touchmoved = false;
			}).on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				e.stopPropagation();
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else if (!touchmoved){
					return clickInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			});			
		}

		if (varstore.isCollection) {
			var hdranchors = this.headers.filter('.collection:not(.collection-link)').children('a');
			hdranchors = hdranchors.add(this.allheaders.next('.accordion-pane').children('.accordion-header.list-item:not(.collection-link)').children('a'));
			hdranchors.on('touchend.accordion', function(e) {
				var clicktext = $(this).attr('data-file');
				if (clicktext != undefined && clicktext != "" && clicktext.indexOf("javascript:void(0)") == -1) {	
					return clickCollInterceptor(e, $(this));
				}			
			}).on('click.accordion', function( e ) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else {
					return clickCollInterceptor(e, $(this));
				}				
			}).on('dblclick.accordion', function(e) {
				e.stopPropagation();
				// TEMPORARY IF/ELSE TO SEE WHAT IS TRIGGERED
				return handleDblclick(e, $(this));
			});
			// IS THIS EVER REACHED?
			this.headers.filter(':not(.collection):not(.collection-group)').children('a').on('touchend.accordion', function(e) {
				var clicktext = $(this).attr('data-file');
				if (clicktext != undefined && clicktext != "" && clicktextclick .indexOf("javascript:void(0)") == -1) {	
					return clickCollInterceptor(e, $(this));
				}			
			}).on('click.accordion', function( e ) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else {
					return clickInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			});
			
			//ADDING THIS FOR ANCHORS, BUT MAYBE GETS HANDLED IN SUBHEADER AREA
			/* COMMENTING OUT TO SEE IF UNNEEDED
			var anchors = this.anchors;
			this.anchors.on('touchend.accordion', function(e) {
				var clicktext = $(this).attr('data-file');
				if (clicktext != undefined && clicktext != "" && clicktext.indexOf("javascript:void(0)") == -1) {	
					return clickCollInterceptor(e, $(this));
				}			
			}).on('click.accordion', function( e ) {
			    e.preventDefault();
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else {
					return clickInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				//return handleDblclick(e, $(this));
			});		*/		
		}
						
		if (!varstore.isCollection) {
			this.headers.children('[class=btn]') // trying equals instead of begins with
			  .on('touchend.accordion', function(e) {
				return touchendInterceptor(e, $(this));
			  })
			  .on('click.accordion', function(e) {
				return clickInterceptor(e, $(this));
			  }).on('keydown.accordion', function(e) {
				self.handleKeys(e);
			  }).on('contextmenu.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
			});			
		}

		if (varstore.isCollection) {
			this.allheaders.children('[class^="btn"]')
			  .on('touchend.accordion', function(e) {
				return touchendInterceptor(e, $(this));
			  })
			  .on('click.accordion', function(e) {
				return clickCollInterceptor(e, $(this));
			  }).on('keydown.accordion', function(e) {
				self.handleKeys(e);
			  })
			  .on('contextmenu.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
			  });
			  window.buttonInitStatus = true;
		}
        this.element.on('selected.accordion', function(e) {
          // Don't propagate this event above the accordion element
          e.stopPropagation();
        }).on('updated.accordion', function(e) {
          // Don't propagate just in case this is contained by an Application Menu
          e.stopPropagation();
          self.updated();
        });
		//mludwig, home button execute and toc collapse call (saving off mousedown.button)
        $('.buttonset.home-btn').on('touchstart.button click.button', function (e) {
			e.stopPropagation();
			if(e.hasOwnProperty('originalEvent')) {
				inforhelp.home(false);
			}
			else {
				inforhelp.home(true);
			}
			var headers = $('#application-menu').find('.accordion-header');
			headers.each(function() {
			  var h = $(this);
			   h.removeClass('is-selected');
			   h.removeClass('is-focused');
			   h.removeClass('child-selected');
			  if (self.isExpanded(h)) {
				self.collapse(h);
			  }
			});	
		});
        return this;
      },
	  
	  loadTocJSON: function(tocidjson, callback) { 
	    if (window.jsonLoading) {
			return;
		}
		window.jsonLoading = true;
		var xobj = new XMLHttpRequest();
			xobj.overrideMimeType("application/json");
		xobj.open('GET', tocidjson, true);
		xobj.onreadystatechange = function () {
			  if (xobj.readyState == 4 && xobj.status == "200") {
				// Required use of an anonymous callback as .open will NOT return a value but simply returns undefined in asynchronous mode
				callback(xobj.responseText);
			  }
		};
		xobj.send(null);
	  },
	  
	  parseAppendJSON: function (data, tocid, header, iframeFlag, callback) {
		    var self = this;
			var dataobject = JSON.parse(data);
			var iframeFlag = iframeFlag;
			data = dataobject[tocid];
			header.next().append(data);
			var subheaders = header.next().first().children('.accordion-header');
			var subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
			var anchors = subheadersExpandable.children('a');
			var panes = subheadersExpandable.next('.accordion-pane');
			self.addExpander(subheadersExpandable, anchors, panes);
			self.handleSubEvents(subheaders);
			callback();
	  },
	  
      handleSubEvents: function(subheaders) {
        var self = this,
          headerWhereMouseDown = null,
          linkFollowedByTouch = null;
		subheaders.each(function() {
			var header = $(this);
		});
        // Returns "Header", "Anchor", or "Expander" based on the element's tag
        function getElementType(element) {
          var elementType = 'Header';
          if (element.is('a')) {
            elementType = 'Anchor';
          }
          if (element.is('button')) {
            elementType = 'Expander';
          }
          return elementType;
        }

        // Intercepts a 'touchend' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function touchendInterceptor(e, element) {
          linkFollowedByTouch = true;
          var type = getElementType(element),
            result = self['handle' + type + 'Click'](e, element);
          if (!result) {
			if (e.cancelable) {
				e.preventDefault();
			}
          }
          return result;
        }

        // Intercepts a 'click' event in order to either prevent a link from being followed,
        // or allows it to continue.
        function clickInterceptor(e, element) {
          var type = getElementType(element);
          if (linkFollowedByTouch) {
            linkFollowedByTouch = null;
            return false;
          }
          return self['handle' + type + 'Click'](e, element);
        }
		
		function handleControlClick(e,anchor) {
		  var dataid = anchor.attr('data-file');
		  if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
			var startpage = "default.html";
			var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
			if (varstore.isCollection) {
				var mapfolder = inforhelp.getMapFolder(dataid);
				whpath = whpath.substring(0, whpath.indexOf(mapfolder));				
			}
			var newURL = whpath + startpage + "?helpcontent=" + dataid;
			if (newURL.indexOf("?hl") != -1) {
				newURL = newURL.substring(0,newURL.indexOf("?hl"));
			}
			inforhelp.openControlClickTab(newURL);						
		  }  				
	  }
	  function handleDblclick (e, anchor) {
		   //clickInterceptor(e, anchor);
		   if (anchor.next('.btn').length > 0 ) {
			   clickInterceptor(e, anchor.next('.btn'));
		   } else if (anchor.prev('.btn').length > 0) {
			   clickInterceptor(e, anchor.prev('.btn'));
		   }
	  }
		var touchmoved;
		subheaders.on('touchend.accordion', function(e) {
			if (e.cancelable) {
				e.preventDefault();
			}
			if(touchmoved != true){
				return touchendInterceptor(e, $(this));
			}
		}).on('touchmove.accordion', function(e){
			touchmoved = true;
		}).on('touchstart.accordion', function(e){
			touchmoved = false;
		}).on('click.accordion', function(e) {
			if (e.cancelable) {
				e.preventDefault();
			}
			return clickInterceptor(e, $(this));
        }).on('focusin.accordion', function(e) {
          var target = $(e.target);

          if (!self.originalSelection) {
            self.originalSelection = target;
          }

          if (target.is(':not(.btn)')) {
            $(this).addClass('is-focused');
          }
        }).on('focusout.accordion', function() {
          if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
            $(this).removeClass('is-focused');
          }
        }).on('keydown.accordion', function(e) {
          self.handleKeys(e);
        }).on('mousedown.accordion', function(e) {
          $(this).addClass('is-focused');
          headerWhereMouseDown = e.target;
        }).on('mouseup.accordion', function() {
          headerWhereMouseDown = null;
        }).on('mouseenter.accordion', function() {
			$(this).parent().hide().show(0);
		});
		
		// for 508 compliance, focus highlighting
		var subhdrchildren = subheaders.next('.accordion-pane').children('.accordion-header.list-item');
		subhdrchildren.on('focusin.accordion', function(e) {
          var target = $(e.target);
          if (!self.originalSelection) {
            self.originalSelection = target;
          }
          if (target.is(':not(.btn)')) {
            $(this).addClass('is-focused');
          }
        }).on('focusout.accordion', function() {
          if (!$.contains(this, headerWhereMouseDown) || $(this).is($(headerWhereMouseDown))) {
            $(this).removeClass('is-focused');
          }
        });
		var touchmoved2;
		if (varstore.isCollection) {
			var anchors = subheaders.children('a');
			var subheadersExpandable = subheaders.filter('.accordion-header:not(.list-item)');
			var panes = subheadersExpandable.next('.accordion-pane');
			anchors.on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved2 != true){
					return touchendInterceptor(e, $(this));
				}
				}).on('touchmove.accordion', function(e){
					touchmoved2 = true;
				}).on('touchstart.accordion', function(e){
					touchmoved2 = false;
				})
				.on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else if (!touchmoved2){
					return clickInterceptor(e, $(this));
				}
			}).on('dblclick.accordion', function(e) {
				return handleDblclick(e, $(this));
			});	
		}
		
        subheaders.children('[class^="btn"]')
          .on('touchend.accordion', function(e) {
            return touchendInterceptor(e, $(this));
          })
          .on('click.accordion', function(e) {
            return clickInterceptor(e, $(this));
          }).on('keydown.accordion', function(e) {
            self.handleKeys(e);
          }).on('contextmenu.accordion', function(e) {
			if (e.cancelable) {
				e.preventDefault();
			}
		  });
		  
        if (varstore.isCollection) {
			subheaders.next('.accordion-pane').children('.accordion-header.list-item').children('a')
			  .on('touchend.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if(touchmoved2 != true){
					return touchendInterceptor(e, $(this));
				}
				}).on('touchmove.accordion', function(e){
					touchmoved2 = true;
				}).on('touchstart.accordion', function(e){
					touchmoved2 = false;
				})				  
			  .on('click.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
				if ( e.ctrlKey ) {
					return handleControlClick(e, $(this));
				} else if (!touchmoved2){
					return clickInterceptor(e, $(this));
				}
			  }).on('keydown.accordion', function(e) {
				self.handleKeys(e);
			  }).on('contextmenu.accordion', function(e) {
				if (e.cancelable) {
					e.preventDefault();
				}
			  });
			this.element.on('selected.accordion', function(e) {
			  // Don't propagate this event above the accordion element
			  e.stopPropagation();
			}).on('updated.accordion', function(e) {
			  // Don't propagate just in case this is contained by an Application Menu
			  e.stopPropagation();
			  self.updated();
			});
		}

        return this;
      },	  

		// adding next six for delayed init, mludwig, might not need sub versions
        
		// Returns "SubHeader", "SubAnchor", or "Expander" based on the element's tag
        getElementType: function(element) {
          var elementType = 'Header';
          if (element.is('a')) {
            elementType = 'Anchor';
          }
          if (element.is('button')) {
			  // see where handleExpanderClick is called, make subexpander one???
            elementType = 'Expander';
          }
          return elementType;
        },		
        // Intercepts a 'touchend' event in order to either prevent a link from being followed,
        // or allows it to continue.
        touchendInterceptor: function(e, element) {
          self.linkFollowedByTouch = true;
          var type = self.getElementType(element),
            result = self['handle' + type + 'Click'](e, element);

          if (!result) {
			if (e.cancelable) {
				e.preventDefault();
			}
          }
          return result;
        },

        // Intercepts a 'click' event in order to either prevent a link from being followed,
        // or allows it to continue.
        clickInterceptor: function(e, element) {
			var self = this;
          var type = self.getElementType(element);
          if (self.linkFollowedByTouch) {
            self.linkFollowedByTouch = null;
            return false;
          }
          return self['handle' + type + 'Click'](e, element);
        },		
		// Returns "SubHeader", "SubAnchor", or "Expander" based on the element's tag
        getSubElementType: function(element) {
          var elementType = 'SubHeader';
          if (element.is('a')) {
            elementType = 'SubAnchor';
          }
          if (element.is('button')) {
			  // see where handleExpanderClick is called, make subexpander one???
            elementType = 'Expander';
          }
          return elementType;
        },

        // Intercepts a 'touchend' event in order to either prevent a link from being followed,
        // or allows it to continue.
        touchendSubInterceptor: function(e, element) {
          self.linkFollowedByTouch = true;
          var type = self.getSubElementType(element),
            result = self['handle' + type + 'Click'](e, element);

          if (!result) {
			if (e.cancelable) {
				e.preventDefault();
			}
          }
          return result;
        },

        // Intercepts a 'click' event in order to either prevent a link from being followed,
        // or allows it to continue.
        clickSubInterceptor: function(e, element) {
			var self = this;
          var type = self.getSubElementType(element);
          if (self.linkFollowedByTouch) {
            self.linkFollowedByTouch = null;
            return false;
          }
          return self['handle' + type + 'Click'](e, element);
        },		
      handleHeaderClick: function(e, header) {
        if (!header || !header.length || this.isDisabled(header) || header.data('is-animating')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }

        // Check that we aren't clicking the expando button.  If we click that, this listener dies
        if ($(e.target).is('[class^="btn"]')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }

        var anchor = header.children('a');
		if (!varstore.isCollection) {
			return this.handleAnchorClick(e, anchor);
		}
		else {
			return this.handleCollAnchorClick(e, anchor);
		}
        
      },
      handleCollHeaderClick: function(e, header) {
        if (!header || !header.length || this.isDisabled(header) || header.data('is-animating')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }

        // Check that we aren't clicking the expando button.  If we click that, this listener dies
        if ($(e.target).is('[class^="btn"]')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }
		
        var anchor = header.children('a');
		// why is this here? Should never be a non-collection scenario inside handleCollHeaderClick
		if (!varstore.isCollection) {
			return this.handleAnchorClick(e, anchor);
		}
		else {
			return this.handleCollAnchorClick(e, anchor);
		}
        
      },
	  
	  handleCollHdrGrpClick: function(e,header){
        if (!header || !header.length || this.isDisabled(header) || header.data('is-animating')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }

        // Check that we aren't clicking the expando button.  If we click that, this listener dies
        if ($(e.target).is('[class^="btn"]')) {
			if (e.cancelable) {
				e.preventDefault();
			}
          return;
        }	
		var anchor = header.children('a');
		if (anchor.attr('data-file') == "") {
			/* do nothing if collection-group is already expanded
			if (header.hasClass('collection-group') && header.next('.accordion-pane').hasClass('is-expanded')) {
				if (!header.is('.is-selected')) {
					$('.is-selected').removeClass('is-selected');
					header.addClass('is-selected');					
				}			
				return;
			}*/
			var accPane = header.next('.accordion-pane');
			var nextHdrs = accPane.find('div.accordion-header:not(.collection-link)');			
			var nextAnchor = nextHdrs.find('a:not([data-file=""])').filter('a:not([data-file$="javascript:void(0)"])').first(); 
			var currURL = inforhelp.copyURL();
			var currTopic = currURL.substring(currURL.indexOf("=")+1);
			var targetTopic = nextAnchor.first().attr('data-file');
			/*var allanchors = header.next('.accordion-pane').find('a');
			allanchors.each(function() {
				if (this.hasAttribute('data-file')){
					var datafile = this.getAttribute('data-file');
					if (currTopic == datafile) {	
						targetTopic = currTopic;
					}
				}
			});*/
			if (!header.next('.accordion-pane').hasClass('is-expanded')) {	
				inforhelp.goTocTopic(targetTopic);
				// expand from nextAnchor up to header that was clicked
				//var parenthdr = nextAnchor.parent('.accordion-header');
				var paneparenthdrs = nextAnchor.parents('.accordion-pane').children('.collection-group');
				var headers2expand = paneparenthdrs.add(header);
				headers2expand.each(function() {
					expandCollGroups($(this));
				});
				$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
				if ($(nextAnchor,window.document).parent().is('.accordion-header')) {
					$(nextAnchor,window.document).parent().removeClass('hide-focus').addClass('is-selected');
					var container = $('#application-menu',window.document);
					var divHeight = container.innerHeight();
					var scrollTarget = $(nextAnchor).parent('.accordion-header');
					var scrollOffset = scrollTarget.offset().top;
					if (container[0].scrollHeight > divHeight) {
						var targetoffset = scrollTarget.offset().top;
						if (scrollOffset > divHeight + 50 || scrollOffset == divHeight + 50 || scrollOffset < 86) {
							inforhelp.scrollPageTo(scrollTarget, function() {
								var currScroll = $('#application-menu',window.document).scrollTop();
								inforhelp.adjustTocScroll(scrollTarget,currScroll);				
							});
						}
					}
				}
				$('#landing',window.document).get(0).contentWindow.document.body.click();
				$('#landing',window.document).get(0).contentWindow.document.body.focus();				
			}
			else if (header.next('.accordion-pane').hasClass('is-expanded')){
				this.toggle(header);
			}			
		}	

		// functions to handle collection group expansion, copied/modified version
		// of Soho expand function
		function expandCollGroups(header) {
			if (!header || !header.length) {
			  return;
			}

			var self = this, // 
			  pane = header.next('.accordion-pane'),
			  a = header.children('a');
			var canExpand = header.triggerHandler('beforeexpand', [a]);
			if (canExpand === false) {
			  return;
			}

			function continueExpand() {
			  // Change the expander button into "collapse" mode
			  var expander = header.children('.btn');
			  if (expander.length) {
				expander.children('.plus-minus, .chevron').addClass('active');
				expander.children('.audible').text(Locale.translate('Collapse'));
			  }
	
			  var headerParents = header.parentsUntil('.accordion').filter('.accordion-pane').prev('.accordion-header').add(header);


			  // Expand all headers that are parents of this one, if applicable
			  headerParents.not(header).each(function() {
				var h = $(this);
				if (!h.parent('.accordion-pane').hasClass('is-expanded')) {
					h.trigger('expand');
				  //self.expand(h);
				}
			  });
			  pane.addClass('is-expanded');
			  header.trigger('expand', [a]);

			  pane.one('animateopencomplete', function(e) {
				e.stopPropagation();
				header.children('a').attr('aria-expanded', 'true');
				header.trigger('afterexpand', [a]);
			  }).animateOpen();
			}
			 // Load from an external source, if applicable
			 var hdranchor = header.children('a').first();
			if (!callSource(hdranchor, continueExpand)) {
				var previousHdrs = header.prev('.accordion-header:not(.list-item)');
				var siblingHdrs = previousHdrs.add(header.next('.accordion-header:not(.list-item)'));
				siblingHdrs.each(function() {
					continueExpand.apply(this);
				});
			  continueExpand.apply(this);		  
			}			
		}
		
		function callSource(anchor, animationCallback) {

			var self = anchor,
			  header = anchor.parent(),
			  pane = header.next('.accordion-pane'),
			  ui = {
				anchor: anchor,
				header: header,
				pane: pane
			  };

			function response() {
			  self.updated();
			  setTimeout(function() {
				animationCallback.apply(self);
			  }, 1);
			  return;
			}

			// Trigger the external method and wait for a response.
			//return this.settings.source(ui, response);
			return;
		  }
	  },
	  
	  handleControlClick: function(e,anchor) {
		  var dataid = anchor.attr('data-file');
		  if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
			var startpage = "default.html";
			var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
			if (varstore.isCollection) {
				var basetopic = $('#landing',window.document).attr('src');
				var mapfolder = inforhelp.getMapFolder(basetopic);
				whpath = whpath.substring(0, whpath.indexOf(mapfolder));				
			}
			var newURL = whpath + startpage + "?helpcontent=" + dataid;
			if (newURL.indexOf("?hl") != -1) {
				newURL = newURL.substring(0,newURL.indexOf("?hl"));
			}
			inforhelp.openControlClickTab(newURL);						
		  }  				
	  },
	  handleDblclick: function(e, anchor) {
		   //clickInterceptor(e, anchor);
		   if (anchor.next('.btn').length > 0 ) {
			   clickInterceptor(e, anchor.next('.btn'));
		   } else if (anchor.prev('.btn').length > 0) {
			   clickInterceptor(e, anchor.prev('.btn'));
		   }
	  },
      handleAnchorClick: function(e, anchor) {
          var self = this,
          headerWhereMouseDown = null,
          linkFollowedByTouch = null,
          header = anchor.parent('.accordion-header'),
          pane = header.next('.accordion-pane'),
          ngLink = anchor.attr('ng-reflect-href');
        if (e && !ngLink) {
			if (e.cancelable) {
				e.preventDefault();
			}

        }

        if (!header.length || this.isDisabled(header)) {
          return false;
        }

        var canSelect = this.element.triggerHandler('beforeselect', [anchor]);
        if (canSelect === false) {
          return;
        }
		var headerclass = header.attr('class');
		if (headerclass.indexOf('is-selected') != -1) {
			this.element.trigger('selected', header);
		}
		
		// new stuff
		var dataid = anchor.attr('data-file');
		if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
			inforhelp.goTocTopic(dataid);			
		}
		else {
			var nextTopic = anchor.parent().next().find('a:not([data-file=""])').filter('a:not([data-file$="javascript:void(0)"])').first(); 
			inforhelp.goTocTopic(nextTopic.first().attr('data-file'));
			var topic = nextTopic.first().attr('data-file');
			// below is copied from pagehighlightandsynch in inforhelp.js
			var container = $('#application-menu',window.document);
			var mapfolder = "";	
			if (varstore.isCollection) {
				mapfolder = inforhelp.getMapFolder(topic);
				if (topic.indexOf(mapfolder) != -1) {
					topic = topic.substring(topic.indexOf(mapfolder));
				}
			}
			else {
				var whroot = window.location.pathname;
				window.helpRoot = whroot.substring(0,whroot.lastIndexOf("/"));
				window.helpRoot = helpRoot.substring(helpRoot.lastIndexOf("/")+1);
				var rootfolder = window.helpRoot;
				if (topic.indexOf("/") != -1) {
					
				}
			}			
			var tocAnchor = "";
			var targetoffset = 0;
			var topoffset = 0;
			var homeoffset = 0;
			var divHeight = container.innerHeight();
			var datafile = mapfolder + "/cover.html";	
			var collBookAnchor = $('.accordion.panel.inverse',window.document).find('.accordion-header').find("a[data-file*='" + datafile + "']"); 
			inforhelp.synchToc(topic, collBookAnchor, function(anchorReturned) {
				tocAnchor = anchorReturned;
				if (typeof tocAnchor != "undefined" && tocAnchor != undefined && tocAnchor != "") {
					var scrollTarget = $(tocAnchor).parent('.accordion-header').first();
					var scrollOffset = scrollTarget.offset().top;
					var target = $(tocAnchor); // NOT USED?
					// NEED TO CHECK INTO ADJUSTING CONDITIIONS BELOW IN IF'S
					if (container[0].scrollHeight > divHeight) {
						topoffset = container[0].scrollTop;
						targetoffset = scrollTarget.offset().top;
						if (scrollOffset > divHeight + 50 || scrollOffset == divHeight + 50 || scrollOffset < 86) {
							inforhelp.scrollPageTo(scrollTarget, function() {
								var currScroll = $('#application-menu',window.document).scrollTop();
								inforhelp.adjustTocScroll(scrollTarget,currScroll);				
							});
						}
					}
				}	
				$('.accordion-header',window.document).removeClass('is-focused').removeClass('is-selected');
				if ($(tocAnchor,window.document).parent().is('.accordion-header')) {
					$(tocAnchor,window.document).parent().removeClass('hide-focus').addClass('is-selected');
				}
				$('#landing',window.document).get(0).contentWindow.document.body.click();
				$('#landing',window.document).get(0).contentWindow.document.body.focus();				
			});
			}
		
        // Set the original element for DOM traversal by keyboard
        this.originalSelection = anchor;
        this.select(anchor);
		
		var onclicktext = header.children('a').first().attr('data-file');
		var subheaders = header.next().first().children('.accordion-header');
		var anchors = subheaders.children('a');
		var subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
		var panes = subheadersExpandable.next('.accordion-pane');
	
		//mludwig, adding in lower level building on click
		subheaders = header.next().first().children('.accordion-header');
		anchors = subheaders.children('a');
		subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
		panes = subheadersExpandable.next('.accordion-pane');		
		if (subheadersExpandable.children('button').length == 0) {
			self.addExpander(subheadersExpandable, anchors, panes);
			self.handleSubEvents(subheadersExpandable);
			if(varstore.isCollection) {
				var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
				$('.popupmenu.contextmenu, .contextmenu-trigger').initialize(initoptions);
			}
		}

        function followLink() {
          var href = anchor.attr('href');
          if (href && href !== '' && href !== '#') {
            if (!self.settings.rerouteOnLinkClick) {
              return true;
            }

            window.location.href = href;
            return true;
          }
          return false;
        }

        function toggleExpander() {
          if (pane.length) {
            self.toggle(header);
          }
          anchor.focus();
        }

        // Stop propagation here because we don't want to bubble up to the Header and potentially click it twice
        if (e) {
          e.stopPropagation();
        }

        // If the anchor's a real link, follow the link and die here
        if (followLink()) {
          this.element.trigger('followlink', [anchor]);
          return true;
        }

        // If it's not a real link, try and toggle an expansion pane
		//if ($(anchor).attr('data-file') == "") {
		//	toggleExpander();			
		//}

        return true;
      },

      handleCollAnchorClick: function(e, anchor) {
          var self = this,
          headerWhereMouseDown = null,
          linkFollowedByTouch = null,
          header = anchor.parent('.accordion-header'),
          pane = header.next('.accordion-pane'),
          ngLink = anchor.attr('ng-reflect-href');
;        if (e && !ngLink) {
			if (e.cancelable) {
				e.preventDefault();
			}

        }
        if (!header.length || this.isDisabled(header)) {
          return false;
        }
        var canSelect = this.element.triggerHandler('beforeselect', [anchor]);
        if (canSelect === false) {
          return;
        }

		if (!(header.is('.is-selected'))) {
			this.element.trigger('selected', header);			
		}

        // Set the original element for DOM traversal by keyboard
        this.originalSelection = anchor;
        this.select(anchor);
		
		var dataid = anchor.attr('data-file');
		var subheaders = header.next().first().children('.accordion-header:not(.collection)')
		var subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
		var anchors = subheadersExpandable.children('a');
		var panes = subheadersExpandable.next('.accordion-pane');
		var iframeFlag = false;
		if (header.is('.collection') && header.next().children().length == 0) {
			var tocid = dataid.substring(0,dataid.indexOf("/"));
			var tocidjson = tocid + ".js";
			self.loadTocJSON(tocidjson, function(data) {
				self.parseAppendJSON(data, tocid, header, iframeFlag, function() {
					parent.jsonLoading = false;
					var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
					$('.popupmenu.contextmenu, .contextmenu-trigger').initialize(initoptions);
					if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
						inforhelp.goTocTopic(dataid);
					}				
				});						
			});
		}
		else if (header.is('.collection') && header.next().children().length != 0) {
			if (dataid !== "" && dataid !== "undefined" && dataid !== undefined && dataid.indexOf("javascript:void(0)") == -1) {
				inforhelp.goTocTopic(dataid);
			}			
		}
		if (header.next().children().length != 0 && header.next().children('.accordion-header:not(.list-item)').children('button').length == 0) {
			self.addExpander(subheadersExpandable, anchors, panes);
			self.handleSubEvents(subheadersExpandable);
		}
		  
        function followLink() {
          var href = anchor.attr('href');
          if (href && href !== '' && href !== '#') {
            if (!self.settings.rerouteOnLinkClick) {
              return true;
            }

            window.location.href = href;
            return true;
          }
          return false;
        }

        function toggleExpander() {
          if (pane.length) {
            self.toggle(header);
          }
          anchor.focus();
        }

        // Stop propagation here because we don't want to bubble up to the Header and potentially click it twice
        if (e) {
          e.stopPropagation();
        }

        // If the anchor's a real link, follow the link and die here
        if (followLink()) {
          this.element.trigger('followlink', [anchor]);
          return true;
        }

        // If it's not a real link, try and toggle an expansion pane
        //toggleExpander();

        return true;
      },
	handleLinkClick: function(e, element) {
		var anchor = element.find('a').first();
		var dataid = anchor.attr('data-file');
		var serverroot = window.location.protocol + '//' + window.location.host;
		var target = serverroot + "/" + dataid;
		inforhelp.openCollectionTOCLink(target);
		
	},
      handleExpanderClick: function(e, expander) {
		  var self = this,
		      headerWhereMouseDown = null,
			linkFollowedByTouch = null;
        var header = expander.parent('.accordion-header');
        if (!header.length || this.isDisabled(header) || header.data('is-animating')) {
          return;
        }
		var onclicktext = header.children('a').first().attr('data-file');
		window.tocJSONloaded = false;
		function tocJSONSetup(currthis) {
			if (header.children('a').first().attr('data-file') && header.hasClass('collection')) {
				// could use collection class check on header instead here
				var tocid = onclicktext.substring(0,onclicktext.indexOf("/"));
				var tocidjson = tocid + ".js";
				if (header.next().children().length == 0) {
					self.loadTocJSON(tocidjson, function(data) {
						appendJSON(data, header, tocid, function(subheadersExpandable,subheaders, anchors, panes) {
							window.tocJSONloaded = true;
							window.jsonLoading = false;
							self.addExpander(subheadersExpandable, anchors, panes);
							self.handleSubEvents(subheaders);										
							var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
							$('.popupmenu.contextmenu, .contextmenu-trigger').initialize(initoptions);
						});
					});
				}
			}
			else if (header.next().first().children('.accordion-header:not(.list-item)').length != 0 && header.next().first().children('.accordion-header:not(.list-item)').children('button').length == 0) {
				var subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
				var subheaders = header.next().first().children('.accordion-header');
				var anchors = subheadersExpandable.children('a');
				var panes = subheadersExpandable.next('.accordion-pane');
				self.addExpander(subheadersExpandable, anchors, panes);
				self.handleSubEvents(subheaders);
			}
		}
		tocJSONSetup(this);
		
		function appendJSON(data, header, tocid, callback) {
			var dataobject = JSON.parse(data);
			data = dataobject[tocid];
			header.next().append(data);
			var subheadersExpandable = header.next().first().children('.accordion-header:not(.list-item)');
			var subheaders = header.next().first().children('.accordion-header');
			var anchors = subheadersExpandable.children('a');
			var panes = subheadersExpandable.next('.accordion-pane');
			callback(subheadersExpandable,subheaders, anchors, panes);
		}
        // Set the original element for DOM traversal by keyboard
        this.originalSelection = expander;

        // Don't propagate when clicking the expander.  Propagating can cause the link to be clicked in cases
        // where it shouldn't be clicked.
        if (e) {
          e.stopPropagation();
        }
		
		// REMOVING CHUNK OF INIT CODE HERE
        var pane = header.next('.accordion-pane');
        if (pane.length) {
          this.toggle(header);
         // this.select(header);
          expander.focus();
          return;
        }			
			
        // If there's no accordion pane, attempt to simply follow the link.
		// mludwig, commenting out below to see if not needed
        //return this.handleAnchorClick(null, header.children('a'));
      },

      handleKeys: function(e) {
        var self = this,
          key = e.which,
          target = $(e.target), // will be either an anchor or expando button.  Should NEVER be the header itself.
          header = target.parent(),
          expander = header.children('[class^="btn"]').first(),
          anchor = header.children('a');

        function setInitialOriginalSelection(selection) {
          if (!selection) {
            selection = target;
          }

          if (!self.originalSelection) {
            self.originalSelection = selection;
          }
        }

        if (key === 9) { // Tab (also triggered by Shift + Tab)
          this.headers.removeClass('is-selected');

          if (target.is('a') && expander.length) {
            setInitialOriginalSelection(expander);
          } else {
            setInitialOriginalSelection(anchor);
          }
        }

        if (key === 32) { // Spacebar
			if (e.cancelable) {
				e.preventDefault();
			}


          // Don't let this propagate and run against the header element, if it's a button
          if (target.is('[class^="btn"]')) {
            e.stopPropagation();
            e.stopImmediatePropagation();

            // Firefox will attempt to run this twice, despite the fact that we're stopping propagation.
            // Just cancel the whole thing if Firefox is running this method.
            if ($('html').hasClass('is-firefox')) {
              return;
            }
          }

          if (expander.length) {
            setInitialOriginalSelection(expander);
            return this.handleExpanderClick(null, target);
          } else {
            setInitialOriginalSelection(anchor);
            return this.handleAnchorClick(null, target);
          }
        }

        if (key === 37 || key === 38) { // Left Arrow/Up Arrow
			if (e.cancelable) {
				e.preventDefault();
			}
          setInitialOriginalSelection();
          if (e.shiftKey) {
            return this.ascend(header);
          }
          return this.prevHeader(header);
        }

        if (key === 39 || key === 40) { // Right Arrow/Down Arrow
			if (e.cancelable) {
				e.preventDefault();
			}
          setInitialOriginalSelection();
          if (e.shiftKey) {
            return this.descend(header);
          }
          return this.nextHeader(header);
        }
      },

      // Makes a header "selected" if its expander button or anchor tag is focused.
      // @param {Object} element - a jQuery Object containing either an expander button or an anchor tag.
      select: function(element) {
        if (!element || !element.length) {
          return;
        }
        // Make sure we select the anchor
        var anchor = element,
          header = anchor.parent();

        if (element.is('.accordion-header')) {
          header = element;
          anchor = header.children('a');
        }

        if (anchor.is('[class^="btn"]')) {
			
          anchor = element.next('a');
        }

        if (this.isDisabled(header)) {
          return;
        }
		
		var allheaders = $('.accordion').find('.accordion-header');
		allheaders.removeClass('child-selected').removeClass('is-selected');
       // this.headers.removeClass('child-selected').removeClass('is-selected');
	   if (header.children('a').first().attr('data-file').indexOf("javascript:void(0)") == -1) {
		   header.addClass('is-selected');
	   }
        else {
			var headernext = header.next();
			var nextanchors = headernext.find('a:not([data-file=""])');
			var nextanchors2 = nextanchors.filter('a:not([data-file$="javascript:void(0)"])');
			var firstanchor = nextanchors2.first();
			var firstparent = firstanchor.parent();
			//var headerToSelect = firstparent;
			var headerToSelect = header.next().find('a:not([data-file=""])').filter('a:not([data-file$="javascript:void(0)"])').first().parent();
			headerToSelect.addClass('is-selected');
		}

        var items = header.parentsUntil(this.element, '.accordion-pane')
          .prev('.accordion-header');
        items.addClass('child-selected');
      },

      // Checks if a particular header is disabled, or if the entire accordion is disabled.
      isDisabled: function(header) {
        if (this.element.hasClass('is-disabled')) {
          return true;
        }

        if (!header) {
          return false;
        }

        return header.hasClass('is-disabled');
      },

      // Checks if an Accordion Section is currently expanded
      isExpanded: function(header) {
        if (!header || !header.length) {
          return;
        }

        return header.children('a').attr('aria-expanded') === 'true';
      },

      toggle: function(header) {
        if (!header || !header.length || this.isDisabled(header)) {
          return;
        }

        if (this.isExpanded(header)) {
          this.collapse(header);
          return;
        }
        this.expand(header);
      },

      expand: function(header) {
        if (!header || !header.length) {
          return;
        }

        var self = this,
          pane = header.next('.accordion-pane'),
          a = header.children('a');
        var canExpand = this.element.triggerHandler('beforeexpand', [a]);
        if (canExpand === false) {
          return;
        }

        function continueExpand() {
          // Change the expander button into "collapse" mode
          var expander = header.children('.btn');
          if (expander.length) {
            expander.children('.plus-minus, .chevron').addClass('active');
            expander.children('.audible').text(Locale.translate('Collapse'));
          }
		  var hdrsToCollapse =  header.siblings('.accordion-header:not(.list-item)');
			hdrsToCollapse.each(function() {
              var h = $(this);
              if (self.isExpanded(h)) {
				  // mludwig, switching to leaving TOC expanded, only collapse on user choice
                //self.collapse(h);
              }
            });		
          var headerParents = header.parentsUntil(self.element).filter('.accordion-pane').prev('.accordion-header').add(header);

          // If we have the correct settings defined, close other accordion headers that are not parents of this one.
          if (self.settings.allowOnePane) {
			self.headers.not(headerParents).each(function() {
              var h = $(this);
              if (self.isExpanded(h)) {
				  // mludwig, switching to leaving TOC expanded, only collapse on user choice
                //self.collapse(h);
              }
            });
          }

          // Expand all headers that are parents of this one, if applicable
          headerParents.not(header).each(function() {
            var h = $(this);
            if (!self.isExpanded(h)) {
              self.expand(h);
            }
          });
          pane.addClass('is-expanded');
          self.element.trigger('expand', [a]);

          pane.one('animateopencomplete', function(e) {
            e.stopPropagation();
            header.children('a').attr('aria-expanded', 'true');
            self.element.trigger('afterexpand', [a]);
          }).animateOpen();
        }

        // Load from an external source, if applicable
        if (!this.callSource(a, continueExpand)) {
			var previousHdrs = $(this).prev('.accordion-header:not(.list-item)');
			var siblingHdrs = previousHdrs.add($(this).next('.accordion-header:not(.list-item)'));
			siblingHdrs.each(function() {
				continueExpand.apply(this);
			});
		  continueExpand.apply(this);		  
		}		
      },

      collapse: function(header) {
        if (!header || !header.length) {
          return;
        }

        var self = this,
          pane = header.next('.accordion-pane'),
          a = header.children('a');

        var canExpand = this.element.triggerHandler('beforecollapse', [a]);
        if (canExpand === false) {
          return;
        }

        // Change the expander button into "expand" mode
        var expander = header.children('.btn');
        if (expander.length) {
          expander.children('.plus-minus, .chevron').removeClass('active');
          expander.children('.audible').text(Locale.translate('Expand'));
        }

        pane.removeClass('is-expanded').closeChildren();
        a.attr('aria-expanded', 'false');

		//mludwig, to fix expanded children upon collapse of header
		var panechildren = pane.children('.accordion-header:not(.list-item)');
		if (panechildren.length) {
			panechildren.each(function() {
				// mludwig, switching to leaving TOC expanded, only collapse on user choice
				//self.collapse($(this));
			});
		}
		//var paneChildrenBtns = panechildren.children('.btn');
		//if (paneChildrenBtns.length) {
        //  paneChildrenBtns.children('.plus-minus, .chevron').removeClass('active');
        //  paneChildrenBtns.children('.audible').text(Locale.translate('Expand'));			
		//}
		
        pane.one('animateclosedcomplete', function(e) {
          e.stopPropagation();
          //pane.css('display', 'none');
          self.element.trigger('aftercollapse', [a]);
        }).animateClosed();
      },

      // Uses a function (this.settings.source()) to call out to an external API to fill the
      // inside of an accordion pane.
      callSource: function(anchor, animationCallback) {
        if (!this.settings.source || typeof this.settings.source !== 'function') {
          return false;
        }

        var self = this,
          header = anchor.parent(),
          pane = header.next('.accordion-pane'),
          ui = {
            anchor: anchor,
            header: header,
            pane: pane
          };

        function response() {
          self.updated();
          setTimeout(function() {
            animationCallback.apply(self);
          }, 1);
          return;
        }

        // Trigger the external method and wait for a response.
        return this.settings.source(ui, response);
      },

      // Prepares a handful of references to a specific
      getElements: function(eventTarget) {
        var target = $(eventTarget),
          header, anchor, expander, pane;

        if (target.is('.accordion-header')) {
          header = target;
          expander = target.children('[class^="btn"]');
          anchor = target.children('a');
        }

        if (target.is('.btn')) {
          expander = target;
          header = expander.parent();
          anchor = header.children('a');
        }

        if (target.is('a')) {
          anchor = target;
          header = anchor.parent();
          expander = header.children('.btn');
        }

        pane = header.next('.accordion-pane');

        return {
          header: header,
          expander: expander,
          anchor: anchor,
          pane: pane
        };
      },

      // Selects an adjacent Accordion Header that sits directly before the currently selected Accordion Header.
      // @param {Object} element - a jQuery Object containing either an expander button or an anchor tag.
      // @param {boolean} noDescend - if it's normally possible to descend into a sub-accordion, prevent against descending.
      prevHeader: function(element, noDescend) {
        var elem = this.getElements(element),
          adjacentHeaders = elem.header.parent().children(),
          currentIndex = adjacentHeaders.index(elem.header),
          target = $(adjacentHeaders.get(currentIndex - 1));

        if (!adjacentHeaders.length || currentIndex === 0) {
          if (elem.header.parent('.accordion-pane').length) {
            return this.ascend(elem.header);
          }
          target = adjacentHeaders.last();
        }

        while (target.is('.accordion-content') || this.isDisabled(target)) {
          if (target.is(':only-child') || target.is(':first-child')) {
            return this.ascend(elem.header);
          }
          target = target.prev();
        }

        if (target.is('.accordion-pane')) {
          var prevHeader = target.prev('.accordion-header');
          if (this.isExpanded(prevHeader)) {
            var descendantChildren = prevHeader.next('.accordion-pane').children(':not(.accordion-content)');
            if (descendantChildren.length && !noDescend) {
              return this.descend(prevHeader, -1);
            }
          }
          target = prevHeader;

          // if no target's available here, we've hit the end and need to wrap around
          if (!target.length) {
            if (elem.header.parent('.accordion-pane').length) {
              return this.ascend(elem.header);
            }

            target = adjacentHeaders.last();
            while (target.is('.accordion-content') || this.isDisabled(target)) {
              target = target.prev();
            }
          }
        }

        this.focusOriginalType(target);
      },

      // Selects an adjacent Accordion Header that sits directly after the currently selected Accordion Header.
      // @param {Object} element - a jQuery Object containing either an expander button or an anchor tag.
      // @param {boolean} noDescend - if it's normally possible to descend into a sub-accordion, prevent against descending.
      nextHeader: function(element, noDescend) {
        var elem = this.getElements(element),
          adjacentHeaders = elem.header.parent().children(),
          currentIndex = adjacentHeaders.index(elem.header),
          target = $(adjacentHeaders.get(currentIndex + 1));

        if (!adjacentHeaders.length || currentIndex === adjacentHeaders.length - 1) {
          if (elem.header.parent('.accordion-pane').length) {
            return this.ascend(elem.header, -1);
          }
          target = adjacentHeaders.first();
        }

        while (target.is('.accordion-content') || this.isDisabled(target)) {
          if (target.is(':only-child') || target.is(':last-child')) {
            return this.ascend(elem.header);
          }
          target = target.next();
        }

        if (target.is('.accordion-pane')) {
          var prevHeader = target.prev('.accordion-header');
          if (this.isExpanded(prevHeader)) {
            var descendantChildren = prevHeader.next('.accordion-pane').children(':not(.accordion-content)');
            if (descendantChildren.length && !noDescend) {
              return this.descend(prevHeader);
            }
          }
          target = $(adjacentHeaders.get(currentIndex + 2));

          // if no target's available here, we've hit the end and need to wrap around
          if (!target.length) {
            if (elem.header.parent('.accordion-pane').length) {
              return this.ascend(elem.header, -1);
            }

            target = adjacentHeaders.first();
            while (target.is('.accordion-content') || this.isDisabled(target)) {
              target = target.next();
            }
          }
        }

        this.focusOriginalType(target);
      },

      // Selects the first Accordion Header in the parent container of the current Accordion Pane.
      // If we're at the top level, jump out of the accordion to the last focusable element.
      // @param {Object} header - a jQuery Object containing an Accordion header.
      // @param {integer} direction - if -1, sets the position to be at the end of this set of headers instead of at the beginning.
      ascend: function(header, direction) {
        if (!direction) {
          direction = 0;
        }

        var pane = header.parent('.accordion-pane'),
          target = pane.prev();

        if (direction === -1) {
          target = pane.next('.accordion-header');
          if (!target.length) {
            if (pane.parent('.accordion').length) {
              return this.nextHeader(pane.prev().children('a'), true);
            }

            return this.ascend(pane.prev(), -1);
          }
        }

        this.focusOriginalType(target);
      },

      // Selects the first Accordion Header in the child container of the current Accordion Header.
      // @param {Object} header - a jQuery Object containing an Accordion header.
      // @param {integer} direction - if -1, sets the position to be at the end of this set of headers instead of at the beginning.
      descend: function(header, direction) {
        if (!direction) {
          direction = 0;
        }

        var pane = header.next('.accordion-pane'),
          target = pane.children('.accordion-header').first();

        if (direction === -1) {
          target = pane.children('.accordion-header').last();
        }

        // No headers may be present.  In which case, it may be necessary to simply focus the header for the current pane.
        if (!target.length) {
          return this.focusOriginalType(header);
        }

        if (this.isExpanded(target)) {
          return this.descend(target, -1);
        }

        this.focusOriginalType(target);
      },

      // Selects an Accordion Header, then focuses either an expander button or an anchor.
      // Governed by the property "this.originalSelection".
      // @param {Object} header - a jQuery Object containing an Accordion header.
      focusOriginalType: function(header) {
        //this.select(header.children('a'));

        if (this.originalSelection.is('.btn') && header.children('.btn').length) {
          header.children('.btn').focus();
        } else {
          header.children('a').focus();
        }
      },

      disable: function() {
        this.element
          .addClass('is-disabled');

        this.anchors.add(this.headers.children('[class^="btn"]')).attr('tabindex', '-1');
      },

      enable: function() {
        this.element
          .removeClass('is-disabled');

        this.anchors.add(this.headers.children('[class^="btn"]')).removeAttr('tabindex');
      },

      updated: function() {
        this.element.data('updating', true);

        var currentFocus = $(document.activeElement);
        if (!$.contains(this.element[0], currentFocus[0])) {
          currentFocus = undefined;
        }

        this
          .teardown()
          .init();

        if (currentFocus && currentFocus.length) {
          currentFocus.focus();
        }

        $.removeData(this.element[0], 'updating');
        return this;
      },

      teardown: function() {
        this.headers
          .off('touchend.accordion click.accordion focusin.accordion focusout.accordion keydown.accordion')
          .each(function() {
            var expander = $(this).data('addedExpander');
            if (expander) {
              expander.remove();
              $.removeData(this, 'addedExpander');
            }
          });

        this.anchors.off('touchend.accordion keydown.accordion click.accordion');

        this.headers.children('[class^="btn"]')
          .off('touchend.accordion click.accordion keydown.accordion');

        this.element.off('updated.accordion');

        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new Accordion(this, settings));
      }
    });
  };

/**
* Application Nav Control (TODO: bitly link to soho xi docs)
*/


  $.fn.applicationmenu = function(options) {

    'use strict';

    // Settings and Options
    var pluginName = 'applicationmenu',
        defaults = {
          breakpoint: 'tablet', // can be 'tablet' (+720), 'phablet (968)'desktop' +(1024), or 'large' (+1280);
          openOnLarge: false, // If true, will automatically open the Application Menu when a large screen-width breakpoint is met.
          triggers: [] // An Array of jQuery-wrapped elements that are able to open/close this nav menu.
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function ApplicationMenu(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    ApplicationMenu.prototype = {

      init: function() {
        this
          .setup()
          .handleEvents();
      },

      setup: function() {
        this.hasTrigger = false;
        this.isAnimating = false;
        this.triggers = $();
        this.menu = this.element;
		
        var openOnLarge = this.element.attr('data-open-on-large');
        this.settings.openOnLarge = openOnLarge !== undefined ? openOnLarge === 'true' : this.settings.openOnLarge;
		// trying changing tablet to 767 to handle android, or might try 705 for mini ipad, mludwig

        var breakpoints = {
          'tablet': 767,
          'phablet': 968,
          'desktop': 1024,
          'large': 1280
        },
        dataBreakpoint = this.element.attr('data-breakpoint');
        this.settings.breakpoint = breakpoints[dataBreakpoint] !== undefined ? dataBreakpoint : this.settings.breakpoint;
        this.breakpoint = breakpoints[this.settings.breakpoint];

        // Pull in the list of Nav Menu trigger elements and store them internally.
        this.modifyTriggers(this.settings.triggers, false, true);

        this.scrollTarget = this.menu.parents('.header');
        var masthead = this.menu.prevAll('.masthead'),
          moduleTabs = this.menu.prevAll('.module-tabs');

        if (masthead.length > 0) {
          this.scrollTarget = masthead;
          this.menu.addClass('short');
        }
        if (moduleTabs.length > 0) {
          this.scrollTarget = moduleTabs;
        }

        this.accordion = this.menu.find('.accordion');
        this.accordion.addClass('panel').addClass('inverse');

        // Check to make sure that the internal Accordion Control is invoked
        var accordion = this.accordion.data('accordion');
        if (!accordion) {
          var accOpts = $.fn.parseOptions(this.accordion[0]);
          this.accordion.accordion(accOpts);
        }
		// sets show/hide button to "show" action for portrait mode or small landscape screens,mludwig		
		if ((window.innerWidth < 801 && window.innerWidth < window.innerHeight) || (window.innerWidth < 569 && window.innerWidth > window.innerHeight)) {
			//$('.application-menu-trigger').attr('data-id','showtoc');
			//this.menu.removeClass('is-open');
			//$('.application-menu-trigger').attr('title', Locale.translate('showtoc'));
			this.menu.addClass('is-open');
		}
		else {
			// It's wide enough landscape, so make sure app menu has is-open class
			this.menu.addClass('is-open');
		}
        this.adjustHeight();
        return this;
      },

      handleEvents: function() {
        var self = this;

        // Setup click events on this.element if it's not the menu itself
        // (this means that it's a trigger button)
        if (this.triggers.length) {
          this.triggers.on('touchend.applicationmenu touchcancel.applicationmenu', function(e) {
			if (e.cancelable) {
				e.preventDefault();
			}
            e.stopImmediatePropagation();
            $(e.target).click();
          }).on('click.applicationmenu', function(e2) {
            if ($(this).find('.icon.app-header').hasClass('go-back')) {
              return false;
            }
            if (!self.menu.hasClass('is-open') && self.isAnimating === false && $(e2.target).is('.application-menu-trigger') ) {
				setTimeout(function() {
					self.openMenu();
					}, 800);
            } else if (self.menu.hasClass('is-open')) {
              self.closeMenu();
            }
          });
        }

        // Setup notification change events
        this.menu.on('notify.applicationmenu', function(e, anchor, value) {
          self.notify(anchor, value);
        }).on('updated.applicationmenu', function() {
          self.updated();
        });

        this.accordion.on('blur.applicationmenu', function() {
         // self.closeMenu(); MAYBE DON'T NEED, PLUS ie11 DOES WEIRD STUFF CUZ OF THIS
        });

        $(document).on('open-applicationmenu', function() {
          self.openMenu();
        }).on('close-applicationmenu', function() {
          self.closeMenu();
        });

        $(window).on('scroll.applicationmenu', function() {
          self.adjustHeight();
        }).on('resize.applicationmenu', function() {
          self.testWidth();
        });
        if (this.settings.openOnLarge && this.isLargerThanBreakpoint()) {
          this.menu.addClass('no-transition');
          $('.page-container').addClass('no-transition');
        }
        this.testWidth();

        //Remove after initial transition
        setTimeout(function() {
          self.menu.removeClass('no-transition');
          $('.page-container').removeClass('no-transition');
        }, 800);

        return this;
      },

      handleKeyDown: function(e) {
        var key = e.which;
		var activeElem = parent.document.activeElement;

		
        if (key === 27 && $(activeElem).hasClass("application-menu-trigger"))
		{ // Escape

		   if (e.cancelable) {
		    	e.preventDefault();
		   }
          this.closeMenu();
          if (this.triggers.length) {
            this.triggers.eq(0).focus();
          }
          return false;
        }
      },

      notify: function(anchor, value) {
        if (!anchor || anchor === undefined) {
          return;
        }
        if (anchor instanceof HTMLElement) {
          anchor = $(anchor);
        }
        if (!anchor.is('a')) {
          return;
        }

        var tag = anchor.find('.tag');

        // Close the tag if an undefined or '0' value is passed
        if (!value || value === undefined || parseInt(value, 10) === 0) {
          if (tag.length) {
            tag.remove();
          }
          return;
        }

       // if (!tag.length) {
       //   tag = $('<span class="tag"></span>').appendTo(anchor);
       // }

        tag.text(value.toString());
        return tag;
      },

      adjustHeight: function() {
        var isSticky = this.scrollTarget.is('.is-sticky'),
          totalHeight = this.scrollTarget.outerHeight(true),
          offset = totalHeight - (!isSticky ? $(window).scrollTop() : 0);

        if (this.scrollTarget.prev().is('.masthead')) {
          offset += this.scrollTarget.prev().outerHeight(true);
        }
		// mludwig, commenting out below so nav height is not set wrong for my uses
        //this.menu.css('height', (offset > 0 ? 'calc(100% - ' + offset + 'px)' : '100%'));
      },

      isLargerThanBreakpoint: function() {
        return $(window).width() > this.breakpoint;
      },

      testWidth: function() {
        if (this.isLargerThanBreakpoint()) {
          this.menu.removeClass('show-shadow');
          if (this.settings.openOnLarge && !this.menu.hasClass('is-open') && this.isAnimating === false) {
            this.openMenu(true);
          }
        } else {
          this.menu.addClass('show-shadow');
		  var activeElemCheck = false;
		  if (document.activeElement.nodeName == "A" || document.activeElement.nodeName == "BODY" || document.activeElement.nodeName == "IFRAME") {
			  activeElemCheck = true;
		  }
		  // mludwig, the following change (plus line above) is to close menu when focus is on A element in the toc menu
		  // THIS IS NOT MAKING SENSE. WHY CLOSE MENU IF FOCUS ON AN <A> ELEMENT???
          //if (!this.element.find(document.activeElement).length && this.menu.is('.is-open') && this.isAnimating === false) {
		 /* if (activeElemCheck && this.menu.is('.is-open') && this.isAnimating === false) {
			this.closeMenu();
          }*/
        }
      },

      openMenu: function(noFocus) {
        if (this.isAnimating === true) {
          return;
        }

        var self = this,
          transitionEnd = $.fn.transitionEndName;

        this.isAnimating = true;
        this.adjustHeight();

        function isOpen() {
          if (self.timeout !== null) {
            clearTimeout(self.timeout);
            self.timeout = null;
          }

          self.isAnimating = false;
          self.element.trigger('applicationmenuopen');
          self.menu.removeClass('no-transition');
          $('.page-container').removeClass('no-transition');
        }

        this.triggers.each(function() {
          var trig = $(this);
          if (trig.parents('.header').length > 0 || trig.parents('.masthead').length > 0) {
            var header = trig.parents('.header, .masthead');
            if (header.parents('.page-container').length) {
              return;
            }
            trig.find('.icon.app-header').removeClass('go-back').addClass('close');
            trig.trigger('icon-change');
          }
        });

        this.menu
          .off(transitionEnd + '.applicationmenu')
          .css('display', '');
        // next line forces a repaint
        this.menu[0].offsetHeight; //jshint ignore:line
		var tocresize = localStorage['splitter-1'];
		if (Locale.isRTL()) {
			tocresize = window.innerWidth - tocresize;
		}
		$('.application-menu-trigger.show').css('display','none');
		$('.application-menu-trigger.hide').css('display','block');
		$('#landing',window.document).contents().find('body').css('margin-left','');
		$('.splitter.splitter-right').css('top','-48px');
		if (!(window.innerWidth < 569)) {
			$('header > div.page-container > section.main').css('width','calc(100% - ' + tocresize + 'px)');		
			$('.sidebar').css('width',tocresize);
			if (Locale.isRTL()) {
				$('#splitter-right-1').css('left','auto');
				$('#splitter-right-1').css('right',tocresize - 1);
			}
			else {
				$('#splitter-right-1').css('left',tocresize - 1);
			}
			$('.sidebar').css('display','block');
		}			
		else if (window.innerWidth > 490 && window.innerWidth < 570) {
			// DO I NEED TO ADD RTL SETTINGS BELOW?
			$('header > div.page-container > section.main').css('z-index','505');
			//$('header > div.page-container > section.main').css('position','absolute');
			$('header > div.page-container > section.main').css('left','1px');
			$('header > div.page-container > section.main').removeClass('flex-grow-shrink');
			$('section.main .page-container > .page-container').css('height','0px');
			$('section.sidebar.is-right-side').css('width','100%');
			$('.sidebar').css('display','block');
			$('#application-menu').css('top','0px');
			$('#application-menu').css('width','100%');
			//$('section.main.is-right-side').css({'height':'36px','width':'100%'});
			//$('section.main.is-right-side').css('width','100%');
			$('section.main.is-right-side').css('display','none');
		}
		else if (window.innerWidth < 491) {
			$('section.sidebar.is-right-side').css('width','100%');
		}
		

		//$('.application-menu-trigger').attr('title', Locale.translate('hidetoc'));
		if (window.innerWidth < 769) {
			this.menu.addClass('is-open');
			$('header > div.page-container > section.main').css('width','100%');
			//mludwig, might need to check how I'm controlling this display for phones elsewhere
		}
		else {
			this.menu.addClass('is-open');
		}
		

        if (!noFocus || noFocus !== true) {
          this.menu.find('.is-selected > a').focus();
        }
        this.menu.one(transitionEnd + '.applicationmenu', isOpen);
        this.timeout = setTimeout(isOpen, 900); // tripled, mludwig

        // Events that will close the nav menu
        // On a timer to prevent conflicts with the Trigger button's click events
        setTimeout(function() {
          $(document).on('touchend.applicationmenu touchcancel.applicationmenu', function(e) {
			if (e.cancelable) {
				e.preventDefault();
			}
            $(e.target).click();
          }).on('click.applicationmenu', function(e) {
            if ($(e.target).parents('.application-menu').length < 1 && !self.isLargerThanBreakpoint()) {
			 // self.closeMenu($(e.target).hasClass('application-menu-trigger'));
            }
          }).on('keydown.applicationmenu', function(e) {
            self.handleKeyDown(e);
          });
        }, 0);
      },

      closeMenu: function() {
        if (this.isAnimating === true) {
          return;
        }

        var self = this,
          transitionEnd = $.fn.transitionEndName();
        this.isAnimating = true;

        function close() {
          if (self.timeout !== null) {
            clearTimeout(self.timeout);
            self.timeout = null;
          }
          self.menu
            .off(transitionEnd + '.applicationmenu')
            .css('display', 'none');
          self.isAnimating = false;
          self.element.trigger('applicationmenuclose');
		  if (Locale.isRTL()) {
			  $('#landing',window.document).contents().find('body.wh_topic_page').first().css('margin-right','25px');
		  }
		  else {
			  $('#landing',window.document).contents().find('body.wh_topic_page').first().css('margin-left','25px');
		  }
		  
		  $('.application-menu-trigger.show').css('display','block');
		  $('.application-menu-trigger.hide').css('display','none');
		  $('.splitter.splitter-right').css('top','0px');
		  // will need to add rtl/ltr conditions here
		 // $('#landing',window.document).contents().find('body.wh_topic_page').first().css('margin-left','25px');
		 // $('.application-menu-trigger').attr('data-id','showtoc');
		  $('.application-menu-trigger.show').attr('title', Locale.translate('showtoc'));
		  if (!(window.innerWidth < 569)) {
			  $('header > div.page-container > section.main').css('width','100%');
			  $('#splitter-right-1').css('left','0px');
			  $('.sidebar').css('width','0px');			  
		  }
		  else {
			  $('#application-menu').css('display','none');
			  $('header > div.page-container > section.main').css('width','100%');
			  $('header > div.page-container > section.main').css('z-index','505');
			  $('section.main .page-container > .page-container').css('height','');
			  $('.application-menu-trigger').attr('data-id','showtoc');
			  $('.application-menu-trigger').attr('title', Locale.translate('showtoc'));	
			  $('header > div.page-container > section.main').css('position','relative');
			  $('#splitter-right-1').css('left','0px');
			  $('.sidebar').css('width','0px');	
			  $('.sidebar').css('display','');
			  $('section.main.is-right-side').css('height','100%');
			  $('section.main.is-right-side').css('display','block');
		  }
        }

        this.triggers.each(function() {
          var trig = $(this);
          if (trig.parents('.header').length > 0 || trig.parents('.masthead').length > 0) {
            trig.find('.icon.app-header').removeClass('close');
            trig.trigger('icon-change');
          }
        });

        this.menu.one(transitionEnd + '.applicationmenu', close);
        this.timeout = setTimeout(close, 900); //tripling, mludwig

        //this.menu.removeClass('is-open').find('[tabindex]');
		this.menu.removeClass('is-open');
        $(document).off('touchend.applicationmenu touchcancel.applicationmenu click.applicationmenu keydown.applicationmenu');
      },

      // Externally Facing function that can be used to add/remove application nav menu triggers.
      // If the 'remove' argument is defined, triggers that are defined will be removed internally instead of added.
      // If the 'norebuild' argument is defined, this control's events won't automatically be rebound to include
      // the new triggers.
      modifyTriggers: function(triggers, remove, norebuild) {
        if (!triggers || !triggers.length) {
          return;
        }
        var changed = $();

        $.each(triggers, function(i, obj) {
          changed = changed.add($(obj));
        });

        this.triggers = this.triggers[!remove ? 'add' : 'not'](changed);

        if (norebuild && norebuild === true) {
          return;
        }

        this.updated();
      },

      teardown: function() {
        this.accordion.off('blur.applicationmenu');
        this.menu.off('animateopencomplete animateclosedcomplete');
        $(window).off('scroll.applicationmenu');
        $(document).off('touchend.applicationmenu touchcancel.applicationmenu click.applicationmenu open-applicationmenu close-applicationmenu');

        this.accordion.data('accordion').destroy();

        return this;
      },

      updated: function() {
        return this
          .teardown()
          .init();
      },

      // Teardown - Remove added markup and events
    //  destroy: function() removed
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
	  $('.application-menu-trigger.hide').attr('title', Locale.translate('hidetoc'));
	  if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new ApplicationMenu(this, settings));
      }
    });
  };

/**
* Autocomplete for inputs and searches (not using, deleted)
*/

/**
* Busy Indicator Control (TODO: bitly link to docs) (not using, deleted)
*/


/**
* BUTTON Control - Adds wripple effect
*/


  $.fn.button = function() {

    'use strict';
    // Settings and Options
    var pluginName = 'button';

    // Plugin Constructor
    function Button(element) {
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Button.prototype = {
      init: function() {
        var self = this;

        this.isTouch = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
        this.isSafari = $('html').is('.is-safari');
        this.isFirefox = $('html').is('.is-firefox');

        if (this.element.hasClass('no-ripple')) {
          return;
        }

        if (this.element.hasClass('btn-menu') && !this.element.hasClass('btn-icon') && !this.element.hasClass('btn-actions')) {
          var ddIcon = this.element.children('svg.icon'),
              use = ddIcon.find('use'), hasIcon = false;

          if (ddIcon.length > 0 && use.length === 1) {
            hasIcon = use.attr('xlink:href').indexOf('#icon-dropdown') > -1;
          } else if (ddIcon.length > 0) {
            hasIcon = ddIcon.attr('data-icon') === 'dropdown' || ddIcon.hasClass('icon-dropdown');
          }

          if (!hasIcon) {
            ddIcon = $.createIconElement({ icon: 'dropdown', classes: ['icon-dropdown']});
            this.element.append(ddIcon);
          }

          if (!ddIcon.hasClass('icon-dropdown')) {
            ddIcon.addClass('icon-dropdown');
          }
        }
		//mludwig, adding translations for collection header buttons
		if (varstore.isCollection) {
			$(".buttonset.home-btn p.toolbtn-text",window.document).text(Locale.translate('Home'));
			$(".buttonset.home-btn",window.document).attr('title',Locale.translate('Home'));
			$(".home .buttonset #homebutton").attr('title',Locale.translate('Home'));
			$(".buttonset.back p.toolbtn-text",window.document).text(Locale.translate('GoBack'));
			$(".buttonset.back",window.document).attr('title',Locale.translate('GoBack'));
			$(".buttonset.forward p.toolbtn-text",window.document).text(Locale.translate('GoForward'));
			$(".buttonset.forward",window.document).attr('title',Locale.translate('GoForward'));
			$(".buttonset.pdf",window.document).attr('title','PDF');
			$("#printButton, button.print, .buttonset.print",window.document).attr('title',Locale.translate('printpage'));
			$(".buttonset.print label",window.document).text(Locale.translate('Print'));
			$(".buttonset.print p.toolbtn-text",window.document).text(Locale.translate('Print'));
			$(".button.btn-help, .buttonset.help",window.document).attr('title',Locale.translate('Help'));
			$(".buttonset.help label",window.document).text(Locale.translate('Help'));
			$(".buttonset.help p.toolbtn-text, #menuhelp",window.document).text(Locale.translate('Help'));
			$(".buttonset.copy-url",window.document).attr('title',Locale.translate('CopyUrl'));
			$(".buttonset.copy-url p.toolbtn-text, #menucopy",window.document).text(Locale.translate('CopyUrl'));
			$(".buttonset.copy-url label",window.document).text(Locale.translate('CopyUrl'));
			$("#popover-contents-click-right p",window.document).text(Locale.translate('CopyUrlMsg'));
		}

		// mludwig, deleted call to changeIcon here

        if (!this.element.parent().is('.field') && this.element.hasClass('btn-actions') && !this.element.data('tooltip')) {
          this.element.attr('title', Locale.translate('More')).tooltip({
            content: Locale.translate('More')
          });
        }
		// mludwig, hiding next line to help 508 compliance
        // this.element.hideFocus();

        this.element
        .on('touchstart.button click.button', function (e) {
          if (((self.element.attr('disabled')) || self.element.is('.is-disabled') || (!self.isTouch && e.which !== 1) ||
              ($('.ripple-effect', this).length) || (self.isTouch && e.type !== 'touchstart')) &&
			  !self.element.is('#homebutton')) {
            return;
          }
          var element = $(this),
            btnOffset = element.offset(),
            xPos = e.pageX - btnOffset.left,
            yPos = e.pageY - btnOffset.top,
            ripple = $('<svg class="ripple-effect" focusable="false" aria-hidden="true" role="presentation"><circle r="0" class="ripple-circle"></circle></svg>');

          if (self.isTouch) {
            // Make sure the user is using only one finger and then get the touch position relative to the ripple wrapper
            e = e.originalEvent;
            if (e && e.touches && e.touches.length === 1) {
              xPos = e.touches[0].pageX - btnOffset.left;
              yPos = e.touches[0].pageY - btnOffset.top;
            }
          }

          // Using keyboard to click
          xPos = (xPos < 0) ? self.element.outerWidth()/2 : xPos;
          yPos = (yPos < 0) ? self.element.outerHeight()/2 : yPos;

          $('svg.ripple-effect', element).remove();
		  //mludwig, hiding ripple
          //ripple.css({'left':xPos, 'top':yPos});
          //element.prepend(ripple);

          // Start the JS Animation Loop if IE9
          // Or Safari/Firefox has bug with combination like: animation, overflow, position, border-radius etc.)
          if (!$.fn.cssPropSupport('animation') || self.isSafari || self.isFirefox) {
            //ripple.removeClass('is-animation');
            //self.animateWithJS(ripple);
          } else {
            //var elem = $('svg.ripple-effect', element);
            //elem.attr('class', elem.attr('class') + ' is-animation');
          }

          setTimeout(function() {
            //ripple.remove();
          }, 1000);

        });

		// add event handler for sidetoc button
		let sidetoc1 = $('#landing',window.document).contents().find('#sidetoc1');
		let sidetoc2 = $('#landing',window.document).contents().find('#sidetoc2');

		sidetoc1.on('touchstart.button click.button', function (e) {
			inforhelp.showhidesidetoc(false);
			e.stopImmediatePropagation();
		});
		sidetoc2.on('touchstart.button click.button', function (e) {
			inforhelp.showhidesidetoc(false);
			e.stopImmediatePropagation();
		});					
      },

      // Browsers that don't support CSS-based animation can still show the animation
      animateWithJS: function(el) {
        var scale = 200,
        xPos = (parseFloat(el.css('left')) - (scale / 2)) + 'px',
        yPos = (parseFloat(el.css('top'))  - (scale / 2)) + 'px';

        el.css({ opacity: 0.4 })
        .animate({
          opacity: 0,
          left: xPos,
          top: yPos,
          width: scale,
          height: scale
        }, 1000);
      },

      destroy: function() {
        this.element.off('touchstart.button touchend.button touchcancel.button mousedown.button mouseup.button mouseleave.button focusout.button');

        var moreTooltip = this.element.data('tooltip');
        if (this.element.hasClass('btn-actions') && moreTooltip) {
          moreTooltip.destroy();
        }

        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (!instance) {
        instance = $.data(this, pluginName, new Button(this));
      }
    });
  };

  /* Chart controls deleted from here*/
 
  /* color picker deleted from here/

/**
* Contextual Action Panel Control (TODO: bitly link to soho xi docs) (Deleted, not used)
*/

/**
* Datepicker Control (TODO link to docs) (Deleted, not used)
*/

/**
* Datagrid Control
*/

window.Formatters = {

  Text: function(row, cell, value) {
    var str = ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString());
    return str;
  },

  Ellipsis: function(row, cell, value, col) {
    var str = ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString());
    col.textOverflow = 'ellipsis';
    return str;
  },

  Password: function(row, cell, value) {
    var str = ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString());
    return str.replace(/./g, '*');
  },

  Readonly: function(row, cell, value) {
    return '<span class="is-readonly">' + ((value === null || value === undefined) ? '&nbsp;' : value) + '</span>';
  },

  Date: function(row, cell, value, col) {
    var formatted = ((value === null || value === undefined) ? '' : value);

    if (typeof value === 'string' && value) {
      var value2 = Locale.parseDate(value, (typeof col.dateFormat === 'string' ? {pattern: col.dateFormat}: col.dateFormat));
      if (value2) {
        formatted = Locale.formatDate(value2, (typeof col.dateFormat === 'string' ? {pattern: col.dateFormat}: col.dateFormat));
      } else {
		    formatted = Locale.formatDate(value, (typeof col.dateFormat === 'string' ? {pattern: col.dateFormat}: col.dateFormat));

        if (formatted === 'NaN/NaN/NaN') { //show invalid dates not NA/NA/NA
          formatted = value;
        }
      }
    } else if (value) {
      formatted = Locale.formatDate(value, (typeof col.dateFormat === 'string' ? {pattern: col.dateFormat}: col.dateFormat));
    }

    if (!col.editor) {
      return formatted === '' ? '&nbsp;' : formatted;
    }
    return '<span class="trigger">' + formatted + '</span>' + $.createIcon({ icon: 'calendar', classes: ['icon-calendar'] });
  },

  Autocomplete: function(row, cell, value) {
    var formatted = ((value === null || value === undefined) ? '&nbsp;' : value);
    return formatted;
  },

  Lookup: function(row, cell, value, col, item) {
    var formatted = ((value === null || value === undefined) ? '&nbsp;' : value);

    if (!col.editor) {
      return formatted;
    }

    if (col.editorOptions && typeof col.editorOptions.field === 'function') {
      formatted = col.editorOptions.field(item, null, null);
    }

    return '<span class="trigger">' + formatted + '</span>' + $.createIcon({ icon: 'search-list', classes: ['icon-search-list'] });
  },

  Decimal:  function(row, cell, value, col) {
    var formatted;

    formatted = value;

    if (typeof Locale !== undefined) {
       formatted = Locale.formatNumber(value, (col.numberFormat ? col.numberFormat : null));
    }

    formatted = ((formatted === null || formatted === undefined) ? '&nbsp;' : formatted);
    return formatted;
  },

  Integer:  function(row, cell, value, col) {
    var formatted;

    formatted = value;

    if (typeof Locale !== undefined) {
      formatted = Locale.formatNumber(value, (col.numberFormat ? col.numberFormat : {style: 'integer'}));
    }

    formatted = ((formatted === null || formatted === undefined) ? '&nbsp;' : formatted);
    return formatted;
  },

  Hyperlink: function(row, cell, value, col, item) {
    var textValue,
      colHref = col.href || '#';

    //Support for dynamic links based on content
    if (col.href && typeof col.href === 'function') {
      colHref = col.href(row, cell, item, col);
      //Passing a null href will produce "just text" with no link
      if (colHref == null) {
        return col.text || value;
      }
    } else  {
      colHref = colHref.replace('{{value}}', value);
    }

    textValue = col.text || value;
    if (!textValue && !col.icon) {
      return '&nbsp;';
    }

    return col.icon ?
      ('<a href="'+ colHref +'" class="btn-icon row-btn '+ (col.cssClass || '') +'">'+
          $.createIcon({ icon: col.icon, file: col.iconFile }) +
          '<span class="audible">'+ textValue +'</span>'+
        '</a>') :
      ('<a href="'+ colHref +'" tabindex="-1" role="presentation" class="hyperlink '+ (col.cssClass || '') + '"' + (col.target ? ' target="' + col.target + '"' : '') + '>'+ textValue +'</a>');
  },

  Template: function(row, cell, value, col, item) {
    var tmpl = col.template,
      renderedTmpl = '';

    if (Tmpl && item && tmpl) {
      var compiledTmpl = Tmpl.compile('{{#dataset}}'+tmpl+'{{/dataset}}');
      renderedTmpl = compiledTmpl.render({dataset: item});
    }

    return renderedTmpl;
  },

  Drilldown: function () {
    var text = Locale.translate('Drilldown');

    if (text === undefined) {
      text = '';
    }

    return (
      '<button type="button" class="btn-icon small datagrid-drilldown">' +
         $.createIcon({icon: 'drilldown'}) +
        '<span>' + text + '</span>' +
      '</button>'
    );
  },

  Checkbox: function (row, cell, value, col) {
    var isChecked;

    // Use isChecked function if exists
    if (col.isChecked) {
      isChecked = col.isChecked(value);
    } else {
      //treat 1, true or '1' as checked
      isChecked = (value == undefined ? false : value == true); // jshint ignore:line
    }

    return '<div class="datagrid-checkbox-wrapper"><span role="checkbox" aria-label="'+ col.name +'" class="datagrid-checkbox ' +
     (isChecked ? 'is-checked' : '') +'" aria-checked="'+isChecked+'"></span></div>';
  },

  SelectionCheckbox: function (row, cell, value, col) {
    var isChecked = (value==undefined ? false : value == true); // jshint ignore:line
    return '<div class="datagrid-checkbox-wrapper"><span role="checkbox" aria-label="'+ col.name +'" class="datagrid-checkbox datagrid-selection-checkbox' +
     (isChecked ? 'is-checked' : '') +'" aria-checked="'+isChecked+'"></span></div>';
  },

  Actions: function (row, cell, value, col) {
    //Render an Action Formatter
    return (
      '<button type="button" class="btn-actions" aria-haspopup="true" aria-expanded="false" aria-owns="'+ col.menuId +'">' +
        '<span class="audible">'+ col.title +'</span>' +
        $.createIcon({ icon: 'more' }) +
      '</button>'
    );
  },

  // Multi Line TextArea
  Textarea: function (row, cell, value) {
    var formatted = ((value === null || value === undefined) ? '&nbsp;' : value);
    return '<span class="datagrid-multiline-text">'+ formatted + '</span>';
  },

  // Expand / Collapse Button
  Expander: function (row, cell, value) {
    var button = '<button type="button" class="btn-icon datagrid-expand-btn" tabindex="-1">'+
      '<span class="icon plus-minus"></span>' +
      '<span class="audible">' + Locale.translate('ExpandCollapse') + '</span>' +
      '</button>' + ( value ? '<span> ' + value + '</span>' : '');

    return button;
  },

  // Datagrid Group Row
  GroupRow: function (row, cell, value, col, item, api) {
    var groupSettings = api.settings.groupable,
      groups = '',
      isOpen = groupSettings.expanded === undefined ? true : groupSettings.expanded;

    if (groupSettings.expanded && typeof groupSettings.expanded === 'function') {
      isOpen = groupSettings.expanded(row, cell, value, col, item, api);
    }

    for (var i = 0; i < groupSettings.fields.length ; i++) {
      groups += item[groupSettings.fields[i]] + (i === 0 ? '&nbsp;' : ',');
    }

    if (groupSettings.groupRowFormatter) {
      groups = groupSettings.groupRowFormatter(row, cell, value, col, item, api);
    }

    var button = '<button type="button" class="btn-icon datagrid-expand-btn'+ (isOpen ? ' is-expanded' : '') +'" tabindex="-1"' +'>'+
    '<span class="icon plus-minus'+ (isOpen ? ' active' : '') +'"></span>' +
    '<span class="audible">'+ Locale.translate('ExpandCollapse') +'</span>' +
    '</button>'+ '<span> '+ groups +'</span>';

    return button;
  },

  GroupFooterRow: function (row, cell, value, col, item, api) {
    var groupSettings = api.settings.groupable,
      groups = '',
      isOpen = groupSettings.expanded === undefined ? true : groupSettings.expanded;

    if (groupSettings.expanded && typeof groupSettings.expanded === 'function') {
      isOpen = groupSettings.expanded(row, cell, value, col, item, api);
    }

    //TODO: Add Test Case for this
    if (groupSettings.groupFooterRowFormatter) {
      groups = groupSettings.groupFooterRowFormatter(row, cell, value, col, item, api);
    }

    var idx = api.columnIdxById(groupSettings.aggregate),
        button = '<td role="gridcell" colspan=' + (idx) + '><div class="datagrid-cell-wrapper">&nbsp;</div></td><td role="gridcell"><div class="datagrid-cell-wrapper"> '+ item.sum +'</div></td>';

    return button;
  },

  SummaryRow: function (row, cell, value, col) {
    var afterText = '',
        beforeText = col.summaryText ||  '<b class="datagrid-summary-totals">' + Locale.translate('Total') + ' </b>';

    if (col.summaryTextPlacement === 'after') {
      afterText = beforeText;
      beforeText = '';
    }

    if (typeof Locale !== undefined && col.numberFormat) {
       value = Locale.formatNumber(value, (col.numberFormat ? col.numberFormat : null));
    }

    return (beforeText + ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString()) + afterText);
  },

  // Tree Expand / Collapse Button and Paddings
  Tree: function (row, cell, value, col, item, api) {
    var isOpen = item.expanded,
      depth = api.settings.treeDepth[row].depth,
      button = '<button type="button" class="btn-icon datagrid-expand-btn'+ (isOpen ? ' is-expanded' : '') +'" tabindex="-1"'+ (depth ? ' style="margin-left: '+ (depth ? (30* (depth -1)) +'px' : '') +'"' : '') +'>'+
      '<span class="icon plus-minus'+ (isOpen ? ' active' : '') +'"></span>' +
      '<span class="audible">'+ Locale.translate('ExpandCollapse') +'</span>' +
      '</button>'+ ( value ? '<span> '+ value +'</span>' : ''),
      node = '<span class="datagrid-tree-node"'+ (depth ? ' style="margin-left: '+ (depth ? (30* (depth-1)) +'px' : '') +'"' : '') +'> '+ value +'</span>';

    return (item[col.children ? col.children : 'children'] ? button : node);
  },

  // Badge / Tags and Visual Indictors
  ClassRange: function (row, cell, value, col) {
    var ranges = col.ranges,
      classes = '', text='';

    if (!ranges) {
      return {};
    }

    for (var i = 0; i < ranges.length; i++) {
      if (value >= ranges[i].min && value <= ranges[i].max) {
        classes = ranges[i].classes;
        text = (ranges[i].text ? ranges[i].text : classes.split(' ')[0]);
      }

      if (value === ranges[i].value) {
        classes = ranges[i].classes;
        text = (ranges[i].text ? ranges[i].text : value);
      }
    }

    return {'classes': classes, 'text': text};
  },

  // Badge (Visual Indictors)
  Badge: function (row, cell, value, col) {
    var ranges = Formatters.ClassRange(row, cell, value, col);

    return '<span class="badge ' + ranges.classes +'">' + value +' <span class="audible">'+ ranges.text+ '</span></span>';
  },

  // Tags (low priority)
  Tag: function (row, cell, value, col) {
    var ranges = Formatters.ClassRange(row, cell, value, col);
    return '<span class="tag ' + ranges.classes +'">'+ value + '</span>';
  },

  Alert: function (row, cell, value, col) {
    var ranges = Formatters.ClassRange(row, cell, value, col);
    var icon = $.createIcon({
      icon: ranges.classes, classes: [
        'icon',
        'datagrid-alert-icon',
        'icon-' + ranges.classes
      ]
    });
    return icon + '<span class="datagrid-alert-text">' + (ranges.text === 'value' ? value : ranges.text) + '</span>';
  },

  Image: function (row, cell, value, col) {

    return '<img class="datagrid-img"' + ' src="' + value +'" alt= "' + (col.alt ? col.alt : Locale.translate('Image')) +
     '"' + (col.dimensions ? ' style="height:'+col.dimensions.height+';width:'+col.dimensions.height+'"' : '') + '/>';
  },

  Color: function (row, cell, value, col) {
    var ranges = Formatters.ClassRange(row, cell, value, col),
      text = ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString());

    return '<span class="' + ranges.classes + '">' + text + '</span>';
  },

  Button: function (row, cell, value, col) {
    var text = col.text ? col.text : ((value === null || value === undefined || value === '') ? '&nbsp;' : value.toString()),
      markup ='<button type="button" class="'+ ( col.icon ? 'btn-icon': 'btn') + ' row-btn ' + (col.cssClass ? col.cssClass : '') + '">';

      if (col.icon) {
        markup += $.createIcon({ icon: col.icon, file: col.iconFile });
      }
      markup += '<span>' + text + '</span></button>';

    return markup;
  },

  Dropdown: function (row, cell, value, col) {
    var formattedValue = value, compareValue, i, option, optionValue;

    if (col.options && value !== undefined) {
      compareValue = col.caseInsensitive && typeof value === 'string' ? value.toLowerCase() : value;

      for (i = 0; i < col.options.length; i++) {
        option = col.options[i];
        optionValue = col.caseInsensitive && typeof option.value === 'string' ? option.value.toLowerCase() : option.value;

        if (optionValue === compareValue) {
          formattedValue = option.label;
          break;
        }
      }
    }

    return '<span class="trigger">' + formattedValue + '</span>' + $.createIcon({ icon: 'dropdown' });
  },

  Favorite: function (row, cell, value, col) {
    var isChecked;

    // Use isChecked function if exists
    if (col.isChecked) {
      isChecked = col.isChecked(value);
    } else {
      isChecked = (value == undefined ? false : value == true); // jshint ignore:line
    }

    return !isChecked ? '&nbsp;' : '<span class="audible">'+ Locale.translate('Favorite') + '</span><span class="icon-favorite">' + $.createIcon({ icon: 'star-filled' }) + '</span>';
  },

  Status: function (row, cell, value, col, item) {

    if (!item.rowStatus) {
      return '<span>&nbsp;</span>';
    }

    return $.createIcon({ icon: item.rowStatus.icon, classes: ['icon', 'icon-' + item.rowStatus.icon, 'datagrid-alert-icon'] }) + '<span class="audible">' + item.rowStatus.text + '</span>';
  },

  // Possible future Formatters
  // Percent
  // Image?
  // Multi Select
  // Re Order - Drag Indicator
  // Sparkline
  // Progress Indicator (n of 100%)
  // Process Indicator
  // Currency
  // File Upload (Simple)
  // Menu Button
  // Toggle Button (No)
  // Color Picker (Low)
};

//window.Editors = { removed from here

window.GroupBy = (function() {

  //Can also use in isEquals: function(obj1, obj2)  in datagrid.js
  var equals = window.Soho.utils.equals;

  //See if the object has these proprties or not
  var has = function(obj, target) {
    return obj.some(function(value) {
        return equals(value, target);
    });
  };

  //Return just the object properties matching the names
  var pick = function(obj, names) {
    var chosen = {};
    for (var i = 0; i < names.length; i++) {
      chosen[names[i]] = obj[names[i]];
    }
    return chosen;
  };

  //Return the specific keys from the object
  var keys = function(data, names) {
    return data.reduce(function(memo, item) {
      var key = pick(item, names);

      if (!has(memo, key)) {
        memo.push(key);
      }
      return memo;
    }, []);
  };

  //Look through each value in the list and return an array of all the values
  //that contain all of the key-value pairs listed in properties.
  var where = function (data, names) {
    var chosen = [];

    data.map(function(item) {
      var match = true;
      for (var prop in names) {
        if (names[prop] !== item[prop]) {
          match = false;
          return;
        }
      }
      chosen.push(item);
      return;
    });

    return chosen;
  };

  //Grouping Function with Plugins/Aggregator
  var group = function(data, names) {
    var stems = keys(data, names);

    return stems.map(function(stem) {
      return {
        key: stem,
        values: where(data, stem).map(function(item) {
          return item;
        })
      };
    });
  };

  //Register an aggregator
  group.register = function(name, converter) {
    return group[name] = function(data, names, extra) { // jshint ignore:line
      var that = this;
      that.extra = extra;
      return group(data, names).map(converter, that);
    };
  };

  return group;
}());

//Register built in aggregators
GroupBy.register('sum', function(item) {
  var extra = this.extra;
  return $.extend({}, item.key, {values: item.values}, {sum: item.values.reduce(function(memo, node) {
      return memo + Number(node[extra]);
  }, 0)});
});

GroupBy.register('max', function(item) {
  var extra = this.extra;
  return $.extend({}, item.key, {values: item.values}, {max: item.values.reduce(function(memo, node) {
      return Math.max(memo, Number(node[extra]));
  }, Number.NEGATIVE_INFINITY)});
});

GroupBy.register('list', function(item) {
  var extra = this.extra;

  return $.extend({}, item.key, {values: item.values}, {list: item.values.map(function(item) {
    var list = [];

    for (var i = 0; i < extra.list.length; i++) {
      var exclude = extra.exclude ? item[extra.exclude] : false;
      if (item[extra.list[i]] && !exclude) {
        list.push({value: item[extra.list[i]], key: extra.list[i]});
      }
    }
    return list;
  })});
});

//Simple Summary Row Accumlator
window.Aggregators = {};
window.Aggregators.aggregate = function(items, columns) {
  var totals = {}, self = this;

  for (var i = 0; i < columns.length; i++) {
    if (columns[i].aggregator) {
      var field = columns[i].field;

      self.sum = function(sum, node) {
        return sum + Number(node[field]);
      };

      var total = items.reduce(self[columns[i].aggregator], 0);
      totals[field] = total;
    }
  }

  return totals;
};

/**
* Drop Down Control (REMOVED FROM HERE)
*/

/**
* Drag and Drop Functions with Touch Support (Deleted, not used)
*/

/**
* Html Editor (Deleted, not used)
* @name editor
*/

/**
 * Page Bootstrapper
 */

  var environment = {

    // Setup a global resize event trigger for controls to listen to
    addGlobalResize: function() {
      $(window).on('resize', function() {
        $('body').triggerHandler('resize', [window]);
      });

      return this;
    },

    set: function () {
      this
        .makeSohoObject()
        .addBrowserClasses()
        .addGlobalResize();
    },

    // Global Classes for browser, version and device as needed.
    addBrowserClasses: function() {
      var ua = navigator.userAgent || navigator.vendor || window.opera,
        html = $('html'); // User-agent string

      if (ua.indexOf('Safari')  !== -1 &&
          ua.indexOf('Chrome')  === -1 &&
          ua.indexOf('Android') === -1) {
        html.addClass('is-safari');
      }

      if (ua.indexOf('Mac OS X') !== -1) {
        html.addClass('is-mac');
      }

      if (ua.indexOf('Firefox') > 0) {
        html.addClass('is-firefox');
      }

      //Class-based detection for IE
      if (ua.match(/Edge\//)) {
        html.addClass('ie ie-edge');
      }
      if (ua.match(/Trident/)) {
        html.addClass('ie');
      }
      if (navigator.appVersion.indexOf('MSIE 8.0') > -1 ||
        ua.indexOf('MSIE 8.0') > -1 ||
        document.documentMode === 8) {
        html.addClass('ie8');
      }
      if (navigator.appVersion.indexOf('MSIE 9.0') > -1) {
        html.addClass('ie9');
      }
      if (navigator.appVersion.indexOf('MSIE 10.0') > -1) {
        html.addClass('ie10');
      } else {
        if (ua.match(/Trident\/7\./)) {
          html.addClass('ie11');
        }
      }

      // Class-based detection for iOS
      // /iPhone|iPod|iPad|Silk|Android|BlackBerry|Opera Mini|IEMobile/
      if ((/iPhone|iPod|iPad/).test(ua)) {
        html.addClass('ios');

        var iDevices = ['iPod', 'iPad', 'iPhone'];
        for (var i = 0; i < iDevices.length; i++) {
          if (new RegExp(iDevices[i]).test(ua)) {
            html.addClass(iDevices[i].toLowerCase());
          }
        }
      }

      if ((/Android/.test(ua))) {
        html.addClass('android');
      }

      return this;
    },

    makeSohoObject: function() {
      window.Soho = window.Soho || {};

	  	// Easy flag for determining whether or not time will be logged to the console.
		var enableTimeLogging = true;
		
      window.Soho.logTimeStart = function(label) { // jshint ignore:line
        if (enableTimeLogging) {
          console.time(label); // jshint ignore:line
        }
      };

      window.Soho.logTimeEnd = function(label) { // jshint ignore:line
        if (enableTimeLogging) {
          console.timeEnd(label); // jshint ignore:line
        }
      };

      window.Soho.theme = 'light';
      return this;
    }

  };

  environment.set();
/**
* Expandable Area Control (TODO: bitly link to soho xi docs) (Deleted, not used)
*/

  /**
  * Make something disabled
  */
  $.fn.disable = function() {
    $.each(this.data(), function(index, value) {
      if (value instanceof jQuery) {
        return;
      }

      if (value.disable) {
        value.disable();
      }
    });
    this.prop('disabled', true);
    return this;
  };

  /**
  * Make something enabled
  */
  $.fn.enable = function() {
    $.each(this.data(), function(index, value) {
      if (value instanceof jQuery) {
        return;
      }

      if (value.enable) {
        value.enable();
      }
    });
    this.prop('disabled', false);
    return this;
  };

  /**
  * Make something readonly
  */
  $.fn.readonly = function() {
    $.each(this.data(), function(index, value) {
      if (value instanceof jQuery) {
        return;
      }

      if (value.readonly) {
        value.readonly();
      }
    });
    this.prop('readonly', true);
    return this;
  };

  /**
  * Track Input is changed from last submit
  */
  $.fn.trackdirty = function() {
      this.each(function () {
        var input = $(this);

        function valMethod(elem) {
          switch(elem.attr('type')) {
            case 'checkbox':
            case 'radio':
              return elem.prop('checked');
            default:
              return elem.val();
          }
        }

        input.data('original', valMethod(input))
         .on('change.dirty', function () {
          var input = $(this),
            el = input,
            field = input.closest('.field'),
            cssClass = '';

          if (input.attr('data-trackdirty') !== 'true') {
            return;
          }

          //Set css class
          input.addClass('dirty');
          if ((input.attr('type')==='checkbox' || input.attr('type')==='radio')) {
            cssClass +=' dirty-'+ input.attr('type') +
                      (input.is(':checked') ? ' is-checked' : '');
          }
          if (input.is('select')) {
            cssClass += ' is-select';
            el = $('.dropdown-wrapper input[type="text"]', field);
          }

          //Add class and icon
          if (!el.prev().is('.icon-dirty')) {
            el.before('<span class="icon-dirty' + cssClass + '"></span>');
            $('label:visible', field).append('<span class="audible msg-dirty">'+ Locale.translate('MsgDirty') +'</span>');
          }

          //Handle reseting value back
          if (valMethod(input) === input.data('original')) {
            input.removeClass('dirty');
            $('.icon-dirty, .msg-dirty', field).remove();
            input.trigger('pristine');
            return;
          }

          //Trigger event
          input.trigger('dirty');

        });
      });
    return this;
  };

  /**
  * Labels without the "for" attribute
  */
  $(function () {
    var str, control,
      labelText = $('.label-text'),
      labels = labelText.closest('label, .label');

    labels.each(function () {
      control = $('input, textarea, select', this);
      str = control.attr('class');

      $(this).addClass(function () {
        // Add "inline" and "inline-{control}" class to label
        // assuming control class is first thing in class string
        return 'inline' + (str ? ' inline-'+ (str.indexOf(' ') === -1 ? str : str.substr(0, str.indexOf(' '))) : '');
      });
    });
  });

  /**
  * Fix: Radio buttons was not selecting when click and than use arrow keys on Firefox
  */
  $(function () {
    $('input:radio').on('click.radios', function() {
      this.focus();
    });
  });

/**
* File Upload Control (TODO: bitly link to soho xi docs) (deleted, not used)
*/

/**
* File Upload Advance Control (TODO link to docs) (deleted, not used)
*/

/*
ERROR
--------
https://social.technet.microsoft.com/Forums/ie/en-US/ec3c0be0-0834-4873-8e94-700e9df9c822/edge-browser-drag-and-drop-files-not-working?forum=ieitprocurrentver

*/
/**
* HEADER Control (TODO: Link to Docs)
* Special Toolbar at the top of the page used to faciliate SoHo Xi Nav Patterns
*/

  $.fn.header = function(options) {

    'use strict';
    // Tab Settings and Options
    var pluginName = 'header',
        defaults = {
          demoOptions: true, // Used to enable/disable default SoHo Xi options for demo purposes
          useBackButton: true, // If true, displays a back button next to the title in the header toolbar
          useBreadcrumb: false, // If true, displays a breadcrumb on drilldown
          usePopupmenu: false, // If true, changes the Header Title into a popupmenu that can change the current page
          tabs: null, // If defined as an array of Tab objects, displays a series of tabs that represent application sections
          wizardTicks: null, // If defined as an array of Wizard Ticks, displays a Wizard Control that represents steps in a process
          useAlternate: false, // If true, use alternate background/text color for sub-navigation areas
          addScrollClass: false //If true a class will be added as the page scrolls up and down to the header for manipulation. Eg: Docs Page.
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Header(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    Header.prototype = {

      init: function() {
        this
          .setup()
          .build()
          .handleEvents();

        // Theme, Personalization, Language Changer, Scrolling
        if (this.settings.demoOptions) {
          this.initPageChanger();
        }
      },

      setup: function() {
        // TODO: Settings all work independently, but give better descriptions
        this.settings.demoOptions = this.element.attr('data-demo-options') ? this.element.attr('data-demo-options') === 'true' : this.settings.demoOptions;
        this.settings.useBackButton = this.element.attr('data-use-backbutton') ? this.element.attr('data-use-backbutton') === 'true' : this.settings.useBackButton;
        this.settings.useBreadcrumb = this.element.attr('data-use-breadcrumb') ? this.element.attr('data-use-breadcrumb') === 'true' : this.settings.useBreadcrumb;
        this.settings.useAlternate = this.element.attr('data-use-alternate') ? this.element.attr('data-use-alternate') === 'true' : this.settings.useAlternate;

        this.settings.tabs = !$.isArray(this.settings.tabs) ? null : this.settings.tabs;
        this.settings.wizardTicks = !$.isArray(this.settings.wizardTicks) ? null : this.settings.wizardTicks;

        this.titleText = this.element.find('.title > h1');

        // Used to track levels deep
        this.levelsDeep = [];
        this.levelsDeep.push('' + this.titleText.text());

        return this;
      },

      build: function() {
        this.toolbarElem = this.element.find('.toolbar');

        // Build toolbar if it doesn't exist
        if (!this.toolbarElem.data('toolbar')) {
          var opts = $.fn.parseOptions(this.toolbarElem);
          this.toolbarElem.toolbar(opts);
        }
        this.toolbar = this.toolbarElem.data('toolbar');

        // Hamburger Icon is optional, but tracking it is necessary.
        this.titleButton = this.element.find('.title > .application-menu-trigger');
        this.hasTitleButton = this.titleButton.length > 0;

        if (this.hasTitleButton) {
          this.toolbarElem.addClass('has-title-button');
          var appMenu = $('#application-menu').data('applicationmenu');
          if (appMenu) {
            appMenu.modifyTriggers([this.titleButton], null, true);
          } else {
            $('#application-menu').applicationmenu({
              triggers: [this.titleButton]
            });
          }
        }

        // Application Tabs would be available from the Application Start, so activate them during build if they exist
        if (this.settings.tabs && this.settings.tabs.length) {
          this.buildTabs();
        }

      //  if (this.settings.usePopupmenu) {
       //   this.buildPopupmenu();
      //  }

        //Add a Scrolling Class to manipulate the header
        if (this.settings.addScrollClass) {
          var self =$(this.element),
            scrollDiv = $(this.element).next('.scrollable'),
            container = (scrollDiv.length === 1 ? scrollDiv : $(window)),
            scrollThreshold = this.settings.scrollThreshold ? this.settings.scrollThreshold : 15;

          container.on('scroll.header', function () {
            if (this.scrollTop > scrollThreshold) {
              self.addClass('is-scrolled-down');
            } else {
              self.removeClass('is-scrolled-down');
            }

          });

          if (container.scrollTop() > scrollThreshold ) {
            self.addClass('is-scrolled-down');
          }
        }

        return this;
      },

      buildTitleButton: function() {
        if (this.levelsDeep.length > 1 && !this.hasTitleButton && !this.titleButton.length) {
          this.titleButton = $('<button class="btn-icon back-button" type="button"></button>');
          this.titleButton.text('<span class="audible">'+ Locale.translate('Drillup') +'</span>' +
            '<span class="icon app-header go-back">' +
              '<span class="one"></span>' +
              '<span class="two"></span>' +
              '<span class="three"></span>' +
            '</span>');
          this.titleButton.prependTo(this.element.find('.title'));

          // Need to trigger an update on the toolbar control to make sure tabindexes and events are all firing on the button
          this.toolbar.element.triggerHandler('updated');
        }

        this.titleButton.find('.icon.app-header').addClass('go-back');
      },

      handleEvents: function() {
        var self = this;

        this.element
          .on('updated.header', function() {
            self.updated();
          })
          .on('reset.header', function() {
            self.reset();
          })
          .on('drilldown.header', function(e, viewTitle) {
            self.drilldown(viewTitle);
          })
          .on('drillup.header', function(e, viewTitle) {
            self.drillup(viewTitle);
          });

        // Events for the title button.  e.preventDefault(); stops Application Menu functionality while drilled
        this.titleButton.bindFirst('click.header', function(e) {
          if (self.levelsDeep.length > 1) {
            e.stopImmediatePropagation();
            self.drillup();
            e.returnValue = false;
          }
        });

        // Popupmenu Events
        if (this.settings.usePopupmenu) {
          this.titlePopup.on('selected.header', function(e, anchor) {
            $(this).children('h1').text(anchor.text());
          });
        }

        return this;
      },

      handleBreadcrumbClick: function(e) {
        var selected = $(e.target).parent(),
          breadcrumbs = this.breadcrumb.find('li'),
          selectedIndex = breadcrumbs.index(selected),
          delta;

        if (selected.hasClass('current')) {
          return;
        }

        if (selectedIndex === 0) {
          return this.reset();
        }

        if (selectedIndex < breadcrumbs.length - 1) {
          delta = (breadcrumbs.length - 1) - selectedIndex;
          while (delta > 0) {
            this.drillup();
            delta = delta - 1;
          }
        }
      },

      initPageChanger: function () {
        this.element.find('.page-changer').on('selected.header', function (e, link) {
          // Change Theme
          if (link.attr('data-theme')) {
            var theme = link.attr('data-theme');
            $('body').trigger('changetheme', theme.replace('-theme',''));
            return;
          }

          // TODO: Change Lang
          if (link.attr('data-lang')) {
            Locale.set(link.attr('data-lang'));
            return;
          }

          // Change Color
          var color = link.attr('data-rgbcolor');
          $('body').trigger('changecolors', [color]);
        });
      },

      // Activates the Drilldown Header View
      drilldown: function(viewTitle) {
        this.element.addClass('is-drilldown');
        this.levelsDeep.push(viewTitle.toString());
        this.titleText.text(this.levelsDeep[this.levelsDeep.length - 1]);

        if (this.settings.useBackButton) {
          this.buildTitleButton();
        }
      },

      drillup: function(viewTitle) {
        var title;
        this.element.removeClass('is-drilldown');

        if (this.levelsDeep.length > 1) {
          this.levelsDeep.pop();
          title = this.levelsDeep[this.levelsDeep.length - 1];
        }

        if (viewTitle !== undefined) {
          title = viewTitle;
        }

        if (this.levelsDeep.length > 1) {
          if (this.settings.useBreadcrumb) {
            this.adjustBreadcrumb();
          }
          this.titleText.text(title);
          return;
        }

        // Completely reset all the way back to normal
        title = this.levelsDeep[0];

        if (this.settings.useBackButton) {
          this.removeButton();
        }
        if (this.settings.useBreadcrumb) {
          this.removeBreadcrumb();
        }
        if (this.settings.usePopupmenu) {
		//mludwig, hiding, function doesn't exist in this file anymore
          //this.removePopupmenu();
        }

        this.titleText.text(title);
        this.element.trigger('drillTop');
      },

      reset: function() {
        while (this.levelsDeep.length > 1) {
          this.levelsDeep.pop();
        }
        this.titleText.text(this.levelsDeep[0]);

        this.removeBreadcrumb();
        this.removeTabs();
        this.removeWizard();
        //this.removePopupmenu();
        this.removeButton();

        this.element.trigger('afterreset');
        return this;
      },

      removeButton: function() {
        if (this.hasTitleButton) {
          this.titleButton.find('.icon.app-header').removeClass('go-back');
          return;
        }

        if (this.titleButton && this.titleButton.length) {
          this.titleButton.remove();
          this.titleButton = $();

          // Need to trigger an update on the toolbar control to make sure tabindexes and events are all firing on the button
          this.toolbar.element.triggerHandler('updated');
        }
      },

      removeBreadcrumb: function() {
        if (!this.breadcrumb || !this.breadcrumb.length) {
          return;
        }

        var self = this,
          transitionEnd = $.fn.transitionEndName(),
          timeout;

        function destroyBreadcrumb() {
          if (timeout) {
            clearTimeout(timeout);
            timeout = null;
          }

          self.element.off(transitionEnd + '.breadcrumb-header');
          self.breadcrumb.off().remove();
          self.breadcrumb = $();
        }

        self.element.removeClass('has-breadcrumb').removeClass('has-alternate-breadcrumb');
        if (this.breadcrumb.is(':not(:hidden)')) {
          this.element.one(transitionEnd + '.breadcrumb-header', destroyBreadcrumb);
          timeout = setTimeout(destroyBreadcrumb, 300);
        } else {
          destroyBreadcrumb();
        }
      },

      removeTabs: function() {
        if (!this.tabsContainer || !this.tabsContainer.length) {
          return;
        }

        var self = this,
          transitionEnd = $.fn.transitionEndName(),
          timeout;

        function destroyTabs() {
          if (timeout) {
            clearTimeout(timeout);
            timeout = null;
          }

          self.element.off(transitionEnd + '.tabs-header');
          self.tabsContainer.data('tabs').destroy();
          self.tabsContainer.remove();
          self.tabsContainer = null;

          // NOTE: For demo purposes the markup for tab panels is already inside the Nav Patterns Test page.
          $('#header-tabs-level-1').css('display', 'none');
          $('#header-tabs-level-2').css('display', 'none');
        }

        this.element.removeClass('has-tabs').removeClass('has-alternate-tabs');
        if (this.tabsContainer.is(':not(:hidden)')) {
          this.element.one(transitionEnd + '.tabs-header', destroyTabs);
          timeout = setTimeout(destroyTabs, 300);
        } else {
          destroyTabs();
        }
      },

      removeWizard: function() {
        if (!this.wizard || !this.wizard.length) {
          return;
        }

        var self = this,
          transitionEnd = $.fn.transitionEndName(),
          timeout;

        function destroyWizard() {
          if (timeout) {
            clearTimeout(timeout);
            timeout = null;
          }

          self.element.off(transitionEnd + '.wizard-header');
          self.wizard.data('wizard').destroy();
          self.wizard.remove();
          self.wizard = null;

        }

        this.element.removeClass('has-wizard');
        if (this.wizard.is(':not(:hidden)')) {
          this.element.one(transitionEnd + '.wizard-header', destroyWizard);
          timeout = setTimeout(destroyWizard, 300);
        } else {
          destroyWizard();
        }
      },

      // teardown events
      unbind: function() {
        this.titleButton.off('click.header');
        this.element.off('drilldown.header drillup.header');
        return this;
      },

      updated: function() {
        this
          .reset()
          .unbind()
          .init();
      },

      destroy: function() {
        this.unbind();
        if (this.hasTitleButton) {
          this.toolbarElem.removeClass('has-title-button');
        }

        $.removeData(this.element[0], pluginName);
      }
    };

    // Keep the Chaining while Initializing the Control (Only Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new Header(this, settings));
      }
    });
  };

/**
* Hierarchy Chart - For Org Charts and Trees ect... (Deleted, not used)
*/

/*
 * Text Highlight/Unhighlight Control
 * Originally called "highlight v5" by Johann Burkard
 * http://johannburkard.de/blog/programming/javascript/highlight-javascript-text-higlighting-jquery-plugin.html
 *
 * Modified for SoHo Xi (TODO: bit.ly link to docs)
**/


  $.fn.highlight = function(pat) {

    function innerHighlight(node, pat) {
      var skip = 0,
        pos, spannode, middlebit, middleclone, endbit;

      if (node.nodeType === 3) {
        pos = node.data.toUpperCase().indexOf(pat);
        pos -= (node.data.substr(0, pos).toUpperCase().length - node.data.substr(0, pos).length);

        if (pos >= 0 && pat.length > 1) {
          spannode = document.createElement('mark');
          spannode.className = 'highlight';
          middlebit = node.splitText(pos);
          endbit = middlebit.splitText(pat.length);
          middleclone = middlebit.cloneNode(true);
          spannode.appendChild(middleclone);
          middlebit.parentNode.replaceChild(spannode, middlebit);
          skip = 1;
        }

      } else if (node.nodeType === 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
        for (var i = 0; i < node.childNodes.length; ++i) {
          i += innerHighlight(node.childNodes[i], pat);
        }
      }

      return skip;
    }

    return this.length && pat && pat.length ? this.each(function() {
      innerHighlight(this, pat.toUpperCase());
    }) : this;
  };

  $.fn.unhighlight = function() {
    return this.find('mark.highlight').each(function() {
      var node = this.parentNode;
      node.replaceChild(this.firstChild, this);
      node.normalize();
    }).end();
  };

/**
* Homepage Control
*/


  $.fn.homepage = function(options) {

    // Settings and Options
    var pluginName = 'homepage',

        defaults = {
          gutterSize: 20,
          widgetWidth: 360,
          widgetHeight: 370,
          animate: true,
          timeout: 100,
          columns: 3,
          easing: 'blockslide'
        },
        settings = $.extend({}, defaults, options);


    // Plugin Constructor
    function Homepage(element) {
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Homepage.prototype = {

      init: function() {
        this.settings = settings;
        this.isTransitionsSupports = this.supportsTransitions();
        this.initHeroWidget();
        this.attachEvents();

        //Initial Sizing
        this.resize(this, false);
      },

      initColumns: function(row) {
        row = row || 0;
        this.rowsAndCols[row] = [];

        for (var i = 0, l = this.settings.columns; i < l; i++) {
          this.rowsAndCols[row][i] = true;// Make all columns available in first row[true]
        }
      },

      initHeroWidget: function() {
        var heroWidget = $('.hero-widget');
        if (heroWidget.length > 1) {
          heroWidget = heroWidget.not(':first').remove();
        }
        this.heroWidget = heroWidget;
      },

      initRowsAndCols: function() {
        this.rowsAndCols = [];// Keeping all blocks as rows and columns
        this.initColumns();
      },

      // Return [x and y] where we can fit this block
      getAvailability: function(block) {
        var i, j, n, l, cols, innerCheck,
          self = this,
          rows = self.rowsAndCols.length,
          smallest = {},
          abort = false;

        // Loop thru each row and column soon it found first available spot
        // Then check for if block's width can fit in(yes), asign to [smallest] and break both loops
        for (i = 0, l = rows; i < l && !abort; i++) {
          for (j = 0, innerCheck = true, cols = self.rowsAndCols[i].length; j < cols && !abort; j++) {
            if ((self.rowsAndCols[i][j]) && ((block.w + j) <= cols)) {
              if ((block.w > 1) && (cols > (j+1))) {
                for (n = 0; n < block.w; n++) {
                  if (!self.rowsAndCols[i][j + n]) {
                    innerCheck = false;
                    break;
                  }
                }
              }
              if ((block.h > 1) && (rows > (i+1))) {
                for (n = 0; n < block.h; n++) {
                  if (!self.rowsAndCols[i + n][j]) {
                    innerCheck = false;
                    break;
                  }
                }
              }
              if (innerCheck) {
                smallest.row = i;
                smallest.col = j;
                abort = true;
              }
            }
          }
        }

        // If did not found any available spot from previous loops
        // Add new row and asign to [smallest] first column in this new row
        if (!Object.getOwnPropertyNames(smallest).length) {
          self.initColumns(rows);
          smallest.row = rows;
          smallest.col = 0;
        }

        return smallest; //{x:0, y:0}
      },

      // Make all spots as unavailable, depends on block's width and height
      // Soon we used this block
      fitBlock: function(r, c, block) {
        var i, j, l, l2,
          self = this,
          addRow = true;

        block.x = c;
        block.y = r;

        if ((block.w === 1) && (block.h === 1)) { // Single block can fit anywhere
          self.rowsAndCols[r][c] = false;
        } else {
          // If more then one row or column then loop thru to block's width and height
          // If height is more then current rows then add new row
          // Mark those spots as unavailable[false]
          if(block.w !== 1) {
            // Left to right
            for (i = r, l = block.h + r; i < l; i++) {
              for (j = c, l2 = block.w + c; j < l2; j++) {
                if (!self.rowsAndCols[i]) {
                  self.initColumns(i);
                }
                self.rowsAndCols[i][j] = false;
              }
            }
          } else {
            // Top to bottom
            for (i = r, l = block.h + r; i < l; i++) {
              for (j = c, l2 = block.h + c; j < l2; j++) {
                if (!self.rowsAndCols[i]) {
                  self.initColumns(i);
                }
                self.rowsAndCols[i][c] = false;
              }
            }
          }
        }

        // Check if reach to end of columns then assign flag[addRow]
        for (i = 0, l = self.rowsAndCols[r].length; i < l; i++) {
          if(self.rowsAndCols[r][i]) {
            addRow = false;
          }
        }

        // If reach to end of columns and next row is not avaiable then add new row
        // Make all columns available, if not assigned earlier as unavailable
        if (addRow) {
          if (!self.rowsAndCols[r +1]) {
            self.initColumns(r +1);
          }
        }
      },

      // Setup each block sizes, based on classes provided from markup
      setBlocks: function() {
        var self = this;
        self.blocks = [];

        self.element.find('.card, .widget').each(function () {
          var card = $(this),
            h = card.hasClass('double-height') ? 2 : 1,
            w = card.hasClass('quad-width') ? 4 : card.hasClass('triple-width') ? 3 : card.hasClass('double-width') ? 2 : 1;

          self.blocks.push({w: w, h: h, elem: card, text: card.text()});
        });

        // Max sized columns brings to top
        for (var i=0, j=0, w=0, l=self.blocks.length; i<l; i++) {
          if (self.settings.columns > 1) {
            if (self.blocks[i].w >= self.settings.columns && i) {
              self.arrayIndexMove(self.blocks, i, j);
            }
            w += self.blocks[i].w;
            if(w >= self.settings.columns) {
              w = 0; //reset
              j = (self.blocks[j].w >= self.settings.columns) ? j+1 : i; //record to move
            }
          }
        }
      },

      //Move an array element position
      arrayIndexMove: function(arr, from, to) {
        arr.splice(to, 0, arr.splice(from, 1)[0]);
      },

      attachEvents: function () {
        var self = this,
          timeout;

        //Throttle the Resize Down
        $(window).on('resize.homepage', function() {
          clearTimeout(timeout);
          timeout = setTimeout(function () {
            self.resize(self, self.settings.animate);
          }, 100);
        });

        $('.application-menu').on('applicationmenuopen.homepage applicationmenuclose.homepage', function () {
          self.resize(self, self.settings.animate);
        });
      },

      // Resize Method
      resize: function(self, animate) {
        //Sizes of "breakpoints" is  320, 660, 1000 , 1340 (for 320)
        //or 376, 740, 1120, 1500 or (for 376) (mludwig, adding phablet)
        var bpXL    = (self.settings.widgetWidth * 4) + (self.settings.gutterSize * 3),
          bpDesktop = (self.settings.widgetWidth * 3) + (self.settings.gutterSize * 2),
          bpTablet  = (self.settings.widgetWidth * 2) + self.settings.gutterSize,
		  bpPhablet = (self.settings.widgetWidth * 2) + self.settings.gutterSize,
          bpPhone   = self.settings.widgetWidth;

        var bp = bpXL, //1340,
          elemWidth = self.element.outerWidth(); //Math min against window.screen.width for single line mobile support

        // elemWidth -= 30; //extra break space

        // Find the Breakpoints (mludwig, adding phablet)
        var xl    = (elemWidth >= bpXL),
          desktop = (elemWidth >= bpDesktop && elemWidth <= bpXL),
          tablet  = (elemWidth >= bpTablet && elemWidth <= bpDesktop),
		  phablet = (elemWidth >= bpPhablet && elemWidth <= bpTablet),
          phone   = (elemWidth <= bpPhablet);

        var maxAttr = this.element.attr('data-columns');
        this.settings.columns = parseInt((maxAttr || this.settings.columns));

        // Assign columns as breakpoint sizes
        if (xl && self.settings.columns === 4) {
          self.settings.columns = 4;
          bp = bpXL;
        }
        if ((desktop) || (xl && self.settings.columns === 3)) {
          self.settings.columns = 3;
          bp = bpDesktop;
        }
        if (tablet) {
          self.settings.columns = 2;
          bp = bpTablet;
        }
	if (phablet){
		  self.settings.columns = 2;
          bp = bpPhablet;
		}
        if (phone) {
          self.settings.columns = 1;
          bp = bpPhone;
        }

        self.element.find('> .content').css('margin-left', '-' + (bp/2) + 'px');

        this.setBlocks(); //setup blocks
        this.initRowsAndCols(); //setup colums

        // Loop thru each block, make fit where available and
        // If block more wider than available size, make as  available size
        // Assign new left and top css positions
        for (var i = 0, l = self.blocks.length; i < l; i++) {
          var left, top, pos, available,
            block = self.blocks[i];

          // Remove extra classes if assigned earlier
          block.elem.removeClass('to-single to-double to-triple');

          // If block more wider than available size, make as available size
          if (block.w > self.settings.columns) {
            block.w = self.settings.columns;

            if (self.settings.columns === 1) {
              block.elem.addClass('to-single');
            }
            else if (self.settings.columns === 2) {
              block.elem.addClass('to-double');
            }
            else if (self.settings.columns === 3) {
              block.elem.addClass('to-triple');
            }
          }

          // Get Availability
          available = self.getAvailability(block);

          // Set positions
          var box = self.settings.widgetWidth + self.settings.gutterSize,
            totalWidth = box * self.settings.columns;

          left = Locale.isRTL() ? totalWidth - ((box * block.w) + (box * available.col)) : box * available.col;
          top = (self.settings.widgetHeight + self.settings.gutterSize) * available.row;
          pos = {left: left, top: top};

          if (animate) {
            var easing = self.settings.easing,
              blockslide = [0.09, 0.11, 0.24, 0.91];

            if (easing === 'blockslide') {
              if (self.isTransitionsSupports) {
                self.applyCubicBezier(block.elem, blockslide);
                block.elem.css(pos);
              }
              // IE-9
              else {
                block.elem.animate(pos, self.settings.timeout);
              }
            }

            // Other easing effects ie (linear, swing)
            else {
              block.elem.animate(pos, self.settings.timeout, easing);
            }
          }
          else {
            block.elem.css(pos);
          }

          // Mark all spots as unavailable for this block, as we just used this one
          self.fitBlock(available.row, available.col, block);
        }
        self.element.triggerHandler('resize', self.settings.columns);
      },

      applyCubicBezier: function (el, cubicBezier) {
        el.css({
          '-webkit-transition': 'all .3s cubic-bezier('+ cubicBezier +')',
          '-moz-transition': 'all .3s cubic-bezier('+ cubicBezier +')',
          '-ms-transition': 'all .3s cubic-bezier('+ cubicBezier +')',
          '-o-transition': 'all .3s cubic-bezier('+ cubicBezier +')',
          'transition': 'all .3s cubic-bezier('+ cubicBezier +')'
        });
      },

      supportsTransitions: function () {
        var s = document.createElement('p').style,
          p = 'transition';

        if (typeof s[p] === 'string') {
          return true;
        }

        // Tests for vendor specific prop
        var v = ['Moz', 'webkit', 'Webkit', 'Khtml', 'O', 'ms'];
        p = p.charAt(0).toUpperCase() + p.substr(1);

        for (var i = 0, l = v.length; i < l; i++) {
          if (typeof s[v[i] + p] === 'string') {
            return true;
          }
        }
        return false;
      },

      detachEvents: function () {
        $(window).off('resize.homepage');
        $('.application-menu').off('applicationmenuopen.homepage applicationmenuclose.homepage');
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.detachEvents();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, defaults, options);
      } else {
        instance = $.data(this, pluginName, new Homepage(this, settings));
      }
    });
  };

/**
* Icon Control (TODO: bitly link to soho xi docs)
* Wraps SVG Icons with a Javascript control that can change the icon type, reference
* relative or absolute URLs, and clean up after itself.  Works with the Base tag.
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.

  $.fn.icon = function(options) {
    'use strict';
    // Settings and Options
    var pluginName = 'icon',
        defaults = {
          use: 'user-profile', // Match this to one of the SoHo Xi icons, prefixed with an ID of '#icon-'
          focusable: false
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Icon(element, settings) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Icon.prototype = {
      init: function() {
        this.getExistingUseTag();

        //Do other init (change/normalize settings, load externals, etc)
        return this
          .render()
          .handleEvents();
      },

      // Add markup to the control
      render: function() {
        var self = this;
        this.element.addClass('icon');

        if (!this.element.is('svg')) {
          // TODO: Possibly work with span-based icons here?
          return this;
        }

        // Get a "base-tag-proof" version of the Use tag's definition.
        // jQuery can't work with SVG elements, so we just modify it with regular DOM APIs
        var use = this.element[0].getElementsByTagName('use')[0];
        if (!use) {
          return this;
        }

        if (use.getAttribute('xlink:href') !== self.getBasedUseTag()) {
          setTimeout(function () {
            use.setAttribute('xlink:href', self.getBasedUseTag());
          }, 0);
        }

        return this;
      },

      getBasedUseTag: function() {
        return $.getBaseURL('#icon-' + this.settings.use);
      },

      // In the event that a <use> tag exists on an icon, we want to retain it
      // and replace the settings.
      getExistingUseTag: function() {
        if (!this.element.is('svg')) {
          return;
        }

        var useTag = this.element.children('use');
        if (!useTag.length) {
          return this;
        }
		// mludwig, trying a change to avoid error
        var xlinkHref = useTag.attr('xlink:href');
		if (xlinkHref != null) {
			this.settings.use = xlinkHref.replace('#icon-', '');
		}
		else {
			var xlinkHref = useTag.attr('href');
			this.settings.use = xlinkHref.replace('#icon-', '');
		}
       

        return this;
      },

      // Sets up event handlers for this control and its sub-elements
      handleEvents: function() {
        var self = this;

        this.element.on('updated.' + pluginName, function() {
          self.updated();
        });

        return this;
      },

      //Handle Updating Settings
      updated: function() {
        return this
          .teardown()
          .init();
      },

      // Simple Teardown - remove events & rebuildable markup.
      teardown: function() {
        this.element.off('updated.' + pluginName);
        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
        var instance = $.data(this, pluginName);
      if (!instance) {
        instance = $.data(this, pluginName, new Icon(this, settings));
      }
    });
  };

  // Factory Function for instantly building icons.
  // Use this for building icons that don't exist yet.
  // Scoped Privately on purpose...
  (function (){
    'use strict';
	
    function normalizeIconOptions(options) {
      var defaults = {
        icon: 'user-profile', // omit the "icon-" if you want; this code strips it out.
        classes: ['icon']
      };
      options = options || $.extend({}, defaults);

      if (typeof options === 'string') {
        options = $.extend({}, defaults, {
          icon: options.replace('icon-', '')
        });
      }

      // reroute "options.class" if that exists
      if (!options.classes && options.class) {
        options.classes = options.class;
        delete options.class;
      }

      if (!options.classes) {
        options.classes = [].concat(defaults.classes);
      }

      if (typeof options.classes === 'string') {
        options.classes = options.classes.split(' ');
      }

      if (options.classes.indexOf('icon') === -1) {
        options.classes.push('icon');
      }

      return options;
    }

	// MLudwig, added below for html escaping, but not using yet.
	// Maybe try escaping before adding to the actual DOM, such as
	// for caret-down
		var entityMap = {
		  '&': '&amp;',
		  '<': '&lt;',
		  '>': '&gt;',
		  '"': '&quot;',
		  "'": '&#39;',
		  '/': '&#x2F;',
		  '`': '&#x60;',
		  '=': '&#x3D;'
		};

		function escapeHtml (string) {
		  return String(string).replace(/[&<>"'`=\/]/g, function (s) {
			return entityMap[s];
		  });
		}
	
    // Returns the RAW HTML for creating a new icon in string form
    $.createIcon = function createIcon(options) {
      options = normalizeIconOptions(options);
	  var returnedicon = [
        '<svg class="' + options.classes.join(' ') + '" focusable="false" aria-hidden="true" role="presentation">' +
          '<use xlink:href="#icon-' + options.icon + '"></use>' +
        '</svg>'
      ].join('');
	 return [
        '<svg class="' + options.classes.join(' ') + '" focusable="false" aria-hidden="true" role="presentation">' +
          '<use xlink:href="#icon-' + options.icon + '"></use>' +
        '</svg>'
      ].join('');   
    };

    // Returns a jQuery-wrapped element containing a new icon
    $.createIconElement = function createIconElement(options) {	
      return $($.createIcon(options));
    };

    // Returns just the path part
    $.createIconPath = function createIconElement(options) {
      options = normalizeIconOptions(options);
      return $.getBaseURL('#icon-' + options.icon.replace('icon-',''));
    };

    //Toggle the use or entire svg icon in the case of the polyfill
    $.fn.changeIcon = function(icon) {
      var svg = $(this),
          use = svg.find('use');

      if (use.length === 1) {
        use.attr('xlink:href', $.createIconPath({icon: icon}));
      } else {
        //ie polyfilled
        var newSvg = $.createIcon({classes: svg.attr('class'), icon : icon});
        svg.after(newSvg);
        svg.remove();
      }
      svg.attr('data-icon', icon);
    };

    $.fn.getIconName = function() {
      var svg = $(this),
          use = svg.find('use');
		  
      if (use.length === 1 && use.attr('xlink:href') != undefined) {
        return use.attr('xlink:href').substr(use.attr('xlink:href').indexOf('#icon-')+6);
      } else {
        return svg.attr('data-icon');
      }

    };

  })();

/**
* Lookup Control (Deleted, not used)
*/

/**
 * Lifecycle Methods for jQuery Controls
 * Recursive methods that "globally" call certain methods on large groups of controls
 */


  var EXCLUDED_FROM_CLOSE_CHILDREN = ['.expandable-area', '.accordion'],
      EXCLUDED_FROM_HANDLE_RESIZE = [];

  // Used by several of these plugins to detect whether or not the "data" property in question
  // is a valid SoHo Xi Control.
  function canAccessAPI(prop) {
    return prop && !(prop instanceof jQuery);
  }

  // Used by several of these plugins to detect whether or not there is a method on a "data" api
  // that can be called.
  function canCall(prop, method) {
    var api = canAccessAPI(prop);
    if (!api) {
      return false;
    }

    return (prop[method] && typeof prop[method] === 'function');
  }

  // Actually triggers the method on the control if it's possible
  function triggerAPIMethod(prop, method) {
    if (canCall(prop, method)) {
      prop[method]();
      return true;
    }
    return false;
  }

  // Tracks each element that attempts to trigger an API method.
  // If a trigger is successful, it stores it in an array that's used later.
  function findControlsOnElements(elems, method) {
    var foundControls = [];

    $.each(elems, function elementIterator(index, elem) {
      $.each($(elem).data(), function dataEntryIterator(index, dataEntry) {
        if (triggerAPIMethod(dataEntry, method)) {
          foundControls.push({ elem: $(elem), control: dataEntry });
        }
      });
    });

    return foundControls;
  }

  // Kicks it all off
  function siftFor(rootElem, method, filteredOutElements) {
    if (!rootElem || !method) {
      return;
    }

    rootElem = $(rootElem);
    var DOMelements = rootElem.find('*').add(rootElem);

    if (filteredOutElements) {
      DOMelements = DOMelements.not(filteredOutElements.join(', '));
    }
    var siftedControls = findControlsOnElements(DOMelements, method);

    rootElem.trigger('sift-' + method + '-complete', [siftedControls]);
    return rootElem;
  }

  //==========================================================
  // Actual Control Plugins
  //==========================================================

  $.fn.destroy = function() {
    return siftFor($(this), 'destroy');
  };

  $.fn.closeChildren = function() {
    return siftFor($(this), 'close', EXCLUDED_FROM_CLOSE_CHILDREN);
  };

  $.fn.handleResize = function() {
    return siftFor($(this), 'handleResize', EXCLUDED_FROM_HANDLE_RESIZE);
  };

/**
* Lightbox Control (TODO: bitly link to soho xi docs) (Deleted, not used)
*/

/**
* List View Control (Deleted, not used)
*/

// Cirle Pager, (Deleted, not used)

/**
* Pager Control (Deleted, not used)
*/

/**
* Place Behavior (TODO: bitly link to soho xi docs)
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.

  $.fn.place = function(options) {
    'use strict';

    // Settings and Options
    var pluginName = 'place',
        defaults = {
          bleedFromContainer: false, // If true, allows positioned content to bleed outside of a defined container.
          callback: null, // If defined, provides extra placement adjustments after the main calculation is performed.
          container: null, // If defined, contains the placement of the element to the boundaries of a specific container element.
          parent: null, // If defined, will be used as the reference element for placement this element.
          parentXAlignment: 'center',
          parentYAlignment: 'center', // Only used for parent-based placement. Determines the alignment of the placed element against its parent. value 0 === X, value 1 === Y
          placement: 'bottom', // If defined, changes the direction in which placement of the element happens
          strategies: ['nudge'] // Determines the "strategy" for alternatively placing the element if it doesn't fit in the defined boundaries.  Only matters when "parent" is a defined setting.  It's possible to define multiple strategies and execute them in order.
        },
        strategies = ['nudge', 'clockwise', 'flip', 'shrink'],
        placements = ['top', 'left', 'right', 'bottom', 'center'],
        xAlignments = ['left', 'center', 'right'],
        yAlignments = ['top', 'center', 'bottom'],
        settings = $.extend({}, defaults, options);

    // Object that contains coordinates along with temporary, changeable properties.
    // This object gets passed around the Place Behavior and modified during each phase of positioning.
    // This object is also passed to all callbacks and event listeners for further modification.
    function PlacementObject(placementOptions) {
      var self = this,
        possibleSettings = [
          'x', 'y',
          'container', 'containerOffsetX', 'containerOffsetY',
          'callback',
          'parent', 'parentXAlignment', 'parentYAlignment',
          'placement',
          'strategies'
        ];

      possibleSettings.forEach(function settingIterator(val) {
        if (placementOptions[val] === null) {
          return;
        }

        if (val === 'x' || val === 'y') {
          self.setCoordinate(val, placementOptions[val]);
          self['original' + val] = placementOptions[val];
          return;
        }

        self[val] = placementOptions[val];
      });

      this.modified = false;

      return this.sanitize();
    }

    PlacementObject.prototype = {
      isReasonableDefault: function(setting, limits) {
        return $.inArray(setting, limits) > -1;
      },

      sanitize: function() {
        var self = this;

        this.bleedFromContainer = this.bleedFromContainer === true;
        this.callback = (typeof this.callback === 'function') ? this.callback : settings.callback;
        this.container = (this.container instanceof $ && this.container.length) ? this.container : settings.container;
        this.containerOffsetX = !isNaN(parseInt(this.containerOffsetX)) ? this.containerOffsetX : 0;
        this.containerOffsetY = !isNaN(parseInt(this.containerOffsetY)) ? this.containerOffsetY : 0;
        this.parent = (this.parent instanceof $ && this.parent.length) ? this.parent : settings.parent;
        this.parentXAlignment = this.isReasonableDefault(this.parentXAlignment, xAlignments) ? this.parentXAlignment : settings.parentXAlignment;
        this.parentYAlignment = this.isReasonableDefault(this.parentYAlignment, yAlignments) ? this.parentYAlignment : settings.parentYAlignment;
        this.placement = this.isReasonableDefault(this.placement, placements) ? this.placement : settings.placement;

        if (!$.isArray(this.strategies) || !this.strategies.length) {
          this.strategies = ['nudge'];
        }
        this.strategies.forEach(function(strat, i) {
          self.strategies[i] = self.isReasonableDefault(strat, strategies) ? strat : self.strategies[i];
        });

      },

      setCoordinate: function(coordinate, value) {
        var coordinates = ['x', 'y'];
        if (!this.isReasonableDefault(coordinate, coordinates)) {
          return;
        }

        if (isNaN(value)) {
          value = 0;
        }

        this[coordinate] = parseInt(value, 10);
      }
    };

    // Place Behavior Constructor
    // This is the actual "thing" that is tied to a Placeable Element.
    function Place(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      this.init();
    }

    Place.prototype = {
      init: function() {
        //Do other init (change/normalize settings, load externals, etc)
        return this
          .build()
          .handleEvents();
      },

      // Add markup to the control
      build: function() {
        if (!this.element.hasClass('placeable')) {
          this.element.addClass('placeable');
        }

        // Setup a hash of original styles that will retain width/height whenever
        // the placement for this element is recalculated.
        this.originalStyles = {};
        var h = this.element[0].style.height,
          w = this.element[0].style.width;

        if (h) {
          this.originalStyles.height = h;
        }
        if (w) {
          this.originalStyles.width = w;
        }

        return this;
      },

      // Sets up event handlers for this control and its sub-elements
      handleEvents: function() {
        var self = this;

        this.element.on('place.' + pluginName, function placementEventHandler(e, x, y) {
          self.place(new PlacementObject({ x: x, y: y }));
        }).on('updated.' + pluginName, function updatedEventHandler() {
          self.updated();
        });

        return this;
      },

      // Actually renders an element with coordinates inside the DOM
      render: function(placementObj) {
        this.element.offset({
          'left': placementObj.x,
          'top': placementObj.y
        });

        if (placementObj.height) {
          this.element.height(placementObj.height);
        }
        if (placementObj.width) {
          this.element.width(placementObj.width);
        }
      },

      // Main placement API Method (external)
      // Can either take a PlacementObject as a single argument, or can take 2 coordinates (x, y) and
      // will use the pre-defined settings.
      place: function(placementObj) {
        var curr = [
          this.element.css('left'),
          this.element.css('top')
        ];
        // Cancel placement with return:false; from a "beforeplace" event
        var canBePlaced = this.element.trigger('beforeplace', [curr]);
        if (!canBePlaced) {
          return curr;
        }

        if (!(placementObj instanceof PlacementObject)) {
          placementObj = new PlacementObject(placementObj);
        }

        // If no values are defined, simply return the current coordinates with a warning.
        if (placementObj.x == null && placementObj.y == null) {
          // TODO: Log a warning about not positioning stuff?
          return curr;
        }

        // Remove any previous placement styles
        this.clearOldStyles();

        // Use different methods if placement against a parent, versus straight-up coordinate placement
        if (placementObj.parent) {
          return this._placeWithParent(placementObj);
        }

        return this._placeWithCoords(placementObj);
      },

      // Placement Routine that expects a parent to be used as a base placement marking.
      // In this case, "x" and "y" integers are "relative" adjustments to the original numbers generated by the parent.
      // Can be modified by using a callback in the settings.
      _placeWithParent: function(placementObj) {
        if (!placementObj.parent || !placementObj.parent.length) {
          return [undefined, undefined]; // can't simply return x and y here because they are not coordinates, they are offsets
        }

        var self = this,
          parentRect = placementObj.parent[0].getBoundingClientRect(),
          elRect = this.element[0].getBoundingClientRect(),
          container = this.getContainer(placementObj),
          containerIsBody = container.length && container[0] === document.body,
          scrollX = (typeof container.scrollLeft === 'number' ? container : document.body).scrollLeft,
          scrollY = (typeof container.scrollTop === 'number' ? container : document.body).scrollTop;

        function getCoordsFromPlacement(placementObj) {
          var cX, cY,
            p = placementObj.placement,
            aX = placementObj.parentXAlignment,
            aY = placementObj.parentYAlignment;

          // Set initial placements
          switch(p) {
            case 'top':
              cY = parentRect.top - elRect.height - placementObj.y + (containerIsBody ? scrollY : 0);
              break;
            case 'left':
              cX = parentRect.left - elRect.width - placementObj.x + (containerIsBody ? scrollX : 0);
              break;
            case 'right':
              cX = parentRect.right + placementObj.x + (containerIsBody ? scrollX : 0);
              break;
            default: // Bottom
              cY = parentRect.bottom + placementObj.y + (containerIsBody ? scrollY : 0) - 10;
              break;
          }

          // Set X alignments on bottom/top placements
          if (p === 'top' || p === 'bottom') {
            switch(aX) {
              case 'left':
                cX = parentRect.left - placementObj.x + (containerIsBody ? scrollX : 0);
                break;
              case 'right':
                cX = (parentRect.right - elRect.width) + placementObj.x + (containerIsBody ? scrollX : 0);
                break;
              default: // center
                cX = (parentRect.left + ((parentRect.width - elRect.width) / 2)) + placementObj.x + (containerIsBody ? scrollX : 0);
                break;
            }
          }

          // Set Y alignments on left/right placements
          if (p === 'right' || p === 'left') {
            switch(aY) {
              case 'top':
                cY = parentRect.top - placementObj.y + (containerIsBody ? scrollY : 0);
                break;
              case 'bottom':
                cY = (parentRect.bottom - elRect.height) + placementObj.y + (containerIsBody ? scrollY : 0);
                break;
              default: // center
                cY = (parentRect.top + ((parentRect.height - elRect.height) / 2)) + placementObj.y + (containerIsBody ? scrollY : 0);
                break;
            }
          }
		  // adjustments for various cases where defaults don't seem to work well
			if (($(placementObj.parent[0]).hasClass('btn-copy-url') || $(placementObj.parent[0]).hasClass('btn-pdf')) && !Locale.isRTL()) {
				let cxadj = window.innerWidth / 7;
				cX = cX + cxadj;
				cY = cY + 40;
				return [cX, cY];
			}
			else if (($(placementObj.parent[0]).hasClass('btn-copy-url') || $(placementObj.parent[0]).hasClass('btn-pdf')) && Locale.isRTL()) {
				let cxadj = window.innerWidth / 7;
				cX = cX - cxadj;
				cY = cY + 40;
				return [cX, cY];
			}
			else if ($(placementObj.parent[0]).hasClass('searchselect-button') && Locale.isRTL()) {
				let cxadj = 50;
				cX = cX + cxadj;
				//cY = cY + 40;
				return [cX, cY];				
			}
			else {
				return [cX, cY];
			}
        }

        function doPlacementAgainstParent(placementObj) {
          var coords = getCoordsFromPlacement(placementObj);
          placementObj.setCoordinate('x', coords[0]);
          placementObj.setCoordinate('y', coords[1]);
          self.render(placementObj);
          placementObj = self._handlePlacementCallback(placementObj);
          return placementObj;
        }

        // Simple placement logic
        placementObj = doPlacementAgainstParent(placementObj);

        // Adjusts the placement coordinates based on a defined strategy
        // Will only adjust the current strategy if bleeding outside the viewport/container are detected.
        placementObj.strategies.forEach(function(strat) {
          placementObj = self.checkBleeds(placementObj);

          if (placementObj.bleeds) {
            placementObj = (function(self) {
              switch(strat) {
                case 'nudge':
                  return self.nudge(placementObj);
                case 'clockwise':
                  return self.clockwise(placementObj);
                case 'flip':
                  placementObj = self.flip(placementObj);
                  placementObj.setCoordinate('x', placementObj.originalx);
                  placementObj.setCoordinate('y', placementObj.originaly);
                  placementObj = doPlacementAgainstParent(placementObj);
                  return placementObj;
                case 'shrink':
                  return self.shrink(placementObj);
                default:
                  return placementObj;
              }
            })(self);

            self.render(placementObj);
          }
        });

        // Trigger an event to notify placement has ended
        this.element.trigger('afterplace', [placementObj]);

        return placementObj;
      },

      // Basic Placement Routine that simply accepts X and Y coordinates.
      // In this case, "x" and "y" integers are "absolute" and will be the base point for placement.
      // Can be modified by using a callback in the settings.
      _placeWithCoords: function(placementObj) {
        this.render(placementObj);

        placementObj = this._handlePlacementCallback(placementObj);

        this.render(placementObj);

        // Coordinate placement can only be "nudged" (strategy is not used in this style of placement).
        placementObj = this.checkBleeds(placementObj);
        if (placementObj.bleeds) {
          placementObj = this.nudge(placementObj);
        }

        // Place again
        this.render(placementObj);

        placementObj = this.checkBleeds(placementObj);
        if (placementObj.bleeds) {
          placementObj = this.shrink(placementObj);
        }

        this.render(placementObj);

        this.element.trigger('afterplace', [
          placementObj
        ]);

        return placementObj;
      },

      // Perform callback, if it exists
      // Callback should return an array containing the modified coordinate values: [x, y];
      // NOTE: These are actual coordinates in all cases.  They are not relative values - they are absolute
      _handlePlacementCallback: function(placementObj) {
        var cb = placementObj.callback || this.settings.callback;

        if (cb && typeof cb === 'function') {
          placementObj = cb(placementObj);
        }

        //placementObj.setCoordinate('x', coords[0]);
        //placementObj.setCoordinate('y', coords[1]);
        return placementObj;
      },

      // Gets a parent container element.
      getContainer: function(placementObj) {
        if (placementObj.container instanceof $ && placementObj.container.length) {
          return placementObj.container;
        }

        var modalParent = this.element.parents('.modal');
        if (modalParent.length) {
          return modalParent;
        }

        return $(document.body);
      },

      // Re-adjust a previously-placed element to account for bleeding off the edges.
      // Element must fit within the boundaries of the page or it's current scrollable pane.
      checkBleeds: function(placementObj) {
        var containerBleed = this.settings.bleedFromContainer,
          container = this.getContainer(placementObj),
          containerIsBody = container.length && container[0] === document.body,
          rect = this.element[0].getBoundingClientRect(),
          containerRect = container ? container[0].getBoundingClientRect() : {},
          scrollX = (typeof container.scrollLeft === 'number' ? container : document.body).scrollLeft,
          scrollY = (typeof container.scrollTop === 'number' ? container : document.body).scrollTop,
          windowH = Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
          windowW = Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
          d;

        function getBoundary(edge) {
          switch(edge) {
            case 'top':
              return (containerBleed ? 0 : containerRect.top) - (!containerIsBody ? scrollY : scrollY * -1); // 0 === top edge of viewport
            case 'left':
              return (containerBleed ? 0 : containerRect.left) - (!containerIsBody ? scrollX : scrollX * -1); // 0 === left edge of viewport
            case 'right':
              return (containerBleed ? windowW : containerRect.right) - (!containerIsBody ? scrollX : scrollX * -1);
            default: // bottom
              return (containerBleed ? windowH : containerRect.bottom) - (!containerIsBody ? scrollY : scrollY * -1);
          }
        }

        // If element width is greater than window width, shrink to fit
        var rightViewportEdge = getBoundary('right');
        if (rect.width >= rightViewportEdge) {
          d = rect.width - rightViewportEdge;
          var newWidth = rect.width - d;
          placementObj.width = newWidth;

          this.element.css('width', newWidth);
          rect = this.element[0].getBoundingClientRect(); // reset the rect because the size changed
        }

        // If element height is greater than window height, shrink to fit
        var bottomViewportEdge = getBoundary('bottom');
        if (rect.height >= bottomViewportEdge) {
          d = rect.height - bottomViewportEdge;
          var newHeight = rect.height - d;
          placementObj.height = newHeight;

          this.element.css('height', newHeight);
          rect = this.element[0].getBoundingClientRect(); // reset the rect because the size changed
        }

        // build conditions
        var offRightEdge = rect.right > getBoundary('right'),
            offLeftEdge = rect.left < getBoundary('left'),
            offTopEdge = rect.top < getBoundary('top'),
            offBottomEdge = rect.bottom > getBoundary('bottom');

        // Return if no bleeding is detected (no need to fix anything!)
        if (!offRightEdge && !offLeftEdge && !offTopEdge && !offBottomEdge) {
          placementObj.bleeds = undefined;
          return placementObj;
        }

        // Keep a record of bleeds that need to be adjusted, and by what values
        placementObj.bleeds = {};
        placementObj.bleeds.right = offRightEdge ? (rect.right - getBoundary('right')) : null;
        placementObj.bleeds.left = offLeftEdge ? -(rect.left - getBoundary('left')) : null;
        placementObj.bleeds.top = offTopEdge ? -(rect.top - getBoundary('top')) : null;
        placementObj.bleeds.bottom = offBottomEdge ? (rect.bottom - getBoundary('bottom')) : null;

        return placementObj;
      },

      // Bumps the element around in each direction
      nudge: function(placementObj) {
        if (!placementObj.nudges) {
          placementObj.nudges = {x: 0, y: 0};
        }

        var d = 0;
        if (placementObj.bleeds.right) {
          d = Math.abs(placementObj.bleeds.right) + Math.abs(placementObj.containerOffsetX);
          placementObj.setCoordinate('x', placementObj.x - d);
          placementObj.nudges.x = placementObj.nudges.x - d;
        }
        if (placementObj.bleeds.left) {
          d = Math.abs(placementObj.bleeds.left) + Math.abs(placementObj.containerOffsetX);
          placementObj.setCoordinate('x', placementObj.x + d);
          placementObj.nudges.x = placementObj.nudges.x + d;
        }
        if (placementObj.bleeds.top) {
          d = Math.abs(placementObj.bleeds.top) + Math.abs(placementObj.containerOffsetY);
          placementObj.setCoordinate('y', placementObj.y + d);
          placementObj.nudges.y = placementObj.nudges.y + d;
        }
        if (placementObj.bleeds.bottom) {
          d = Math.abs(placementObj.bleeds.bottom) + Math.abs(placementObj.containerOffsetY);
          placementObj.setCoordinate('y', placementObj.y - d);
          placementObj.nudges.y = placementObj.nudges.y - d;
        }

        placementObj.wasNudged = true;
        placementObj.bleeds = undefined;

        return placementObj;
      },

      flip: function(placementObj) {
        // Don't attempt to flip if there was no bleeding on the edge we're attempting to leave from.
        if (!placementObj.bleeds[placementObj.placement]) {
          return placementObj;
        }

        if (!placementObj.attemptedFlips) {
          placementObj.attemptedFlips = [];
        }
        placementObj.attemptedFlips.push(placementObj.placement);

        // If we've tried flipping in all directions, give up and use the default placement.
        if (placementObj.attemptedFlips.length > 3) {
          placementObj = this.giveup(placementObj);
          return placementObj;
        }

        var isXCoord = ['left', 'right'].indexOf(placementObj.placement) > -1,
          containerBleed = this.settings.bleedFromContainer,
          container = this.getContainer(placementObj),
          containerIsBody = container.length && container[0] === document.body,
          containerRect = container ? container[0].getBoundingClientRect() : {},
          parentRect = placementObj.parent[0].getBoundingClientRect(),
          scrollX = (typeof container.scrollLeft === 'number' ? container : document.body).scrollLeft,
          scrollY = (typeof container.scrollTop === 'number' ? container : document.body).scrollTop,
          windowH = Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
          windowW = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);

        function getOppositeDir(dir) {
          switch(dir) {
            case 'left':
              return 'right';
            case 'right':
              return 'left';
            case 'top':
              return 'bottom';
            default: // bottom
              return 'top';
          }
        }

        // Gets the distance between an edge on the target element, and its opposing viewport border
        function getDistance(dir) {
          var d = 0;

          switch (dir) {
            case 'left':
              d = (containerBleed ? 0 : containerRect.left) - (!containerIsBody ? scrollX : 0) - parentRect.left + placementObj.containerOffsetX;
              break;
            case 'right':
              d = ((containerBleed ? windowW : containerRect.right) - (!containerIsBody ? scrollX : 0)) - parentRect.right - placementObj.containerOffsetX;
              break;
            case 'top':
              d = (containerBleed ? 0 : containerRect.top) - (!containerIsBody ? scrollY : 0) - parentRect.top + placementObj.containerOffsetY;
              break;
            default: // bottom
              d = ((containerBleed ? windowH : containerRect.bottom) - (!containerIsBody ? scrollY : 0)) - parentRect.bottom - placementObj.containerOffsetY;
              break;
          }

          return Math.abs(d);
        }

        function tried(placement) {
          return $.inArray(placement, placementObj.attemptedFlips) > -1;
        }

        function performFlip(originalDir) {
          var newDir = getOppositeDir(originalDir),
            perpendicularDir = isXCoord ? 'top' : 'left',
            oppPerpendicularDir = getOppositeDir(perpendicularDir),
            originalDistance = getDistance(originalDir),
            targetDistance = getDistance(newDir);

          if (!tried(newDir)) {
            if (originalDistance >= targetDistance) {
              return originalDir;
            }
            return newDir;
          }

          // switch the coordinate definitions
          // since the axis for placement is flipped, our coordinate offsets should also flip
          var tmp = placementObj.originalx;
          placementObj.originalx = placementObj.originaly;
          placementObj.originaly = tmp;

          var perpendicularDistance = getDistance(perpendicularDir),
            oppPerpendicularDistance = getDistance(oppPerpendicularDir);

          if (!tried(perpendicularDir)) {
            if (perpendicularDistance >= oppPerpendicularDistance) {
              return perpendicularDir;
            }

            if (!tried(oppPerpendicularDir)) {
              return oppPerpendicularDir;
            }
          }

          return originalDir;
        }

        placementObj.placement = performFlip(placementObj.placement);

        return placementObj;
      },

      // TODO: Move Clockwise
      clockwise: function(placementObj) {
        return placementObj;
      },

      // If element height/width is greater than window height/width, shrink to fit
      shrink: function(placementObj) {
        var containerBleed = this.settings.bleedFromContainer,
          container = this.getContainer(placementObj),
          containerRect = container ? container[0].getBoundingClientRect() : {},
          rect = this.element[0].getBoundingClientRect(),
          scrollX = (typeof container.scrollLeft === 'number' ? container : document.body).scrollLeft,
          scrollY = (typeof container.scrollTop === 'number' ? container : document.body).scrollTop,
          windowH = Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
          windowW = Math.max(document.documentElement.clientWidth, window.innerWidth || 0),
          leftViewportEdge = (containerBleed ? 0 : containerRect.left + placementObj.containerOffsetX) + scrollX,
          topViewportEdge = (containerBleed ? 0 : containerRect.top + placementObj.containerOffsetY) + scrollY,
          rightViewportEdge = (containerBleed ? windowW : containerRect.right - placementObj.containerOffsetX) + scrollX,
          bottomViewportEdge = (containerBleed ? windowH : containerRect.bottom - placementObj.containerOffsetY) + scrollY,
          d;

        // Shrink in each direction.
        // The value of the "containerOffsets" is "factored out" of each calculation, if for some reason the
        // element is larger than the viewport/container space allowed.
        placementObj.nudges = placementObj.nudges || {};

        // Left
        if (rect.left < leftViewportEdge) {
          d = Math.abs(leftViewportEdge - rect.left);
          if (rect.right >= rightViewportEdge) {
            d = d - placementObj.containerOffsetX;
          }
          placementObj.width = rect.width - d;
          placementObj.setCoordinate('x', placementObj.x + d);
          placementObj.nudges.x = placementObj.nudges.x + d;
        }

        // Right
        if (rect.right > rightViewportEdge) {
          d = Math.abs(rect.right - rightViewportEdge);
          if (rect.left <= leftViewportEdge) {
            d = d - placementObj.containerOffsetX;
          }
          placementObj.width = rect.width - d;
        }

        // Top
        if (rect.top < topViewportEdge) {
          d = Math.abs(topViewportEdge - rect.top);
          if (rect.bottom >= bottomViewportEdge) {
            d = d - placementObj.containerOffsetY;
          }
          placementObj.height = rect.height - d;
          placementObj.setCoordinate('y', placementObj.y + d);
          placementObj.nudges.y = placementObj.nudges.y + d;
        }

        // Bottom
        if (rect.bottom > bottomViewportEdge) {
          d = Math.abs(rect.bottom - bottomViewportEdge);
          if (rect.top <= topViewportEdge) {
            d = d - placementObj.containerOffsetY;
          }
          placementObj.height = rect.height - d;
        }

        return placementObj;
      },

      // Giving up causes all the placementObj settings to revert
      giveup: function(placementObj) {
        placementObj.giveup = true;
        placementObj.strategy = this.settings.strategy;
        placementObj.placement = this.settings.placement;
        return placementObj;
      },

      // Clears the old styles that may be present
      clearOldStyles: function() {
        this.element.css({
          'left': '',
          'top': '',
          'width': '',
          'height': ''
        });

        var os = this.originalStyles;
        if (os) {
          if (os.width) {
            this.element[0].style.width = os.width;
          }

          if (os.height) {
            this.element[0].style.height = os.height;
          }
        }

        return this;
      },

      // Built-in method for handling positon of optional arrow elements.
      // Used for tooltip/popovers/popupmenus
      setArrowPosition: function(e, placementObj, element) {
        var target = placementObj.parent,
          arrow = element.find('div.arrow'),
          dir = placementObj.placement,
          isXCoord = ['left', 'right'].indexOf(dir) > -1,
          targetRect = {},
          elementRect = element[0].getBoundingClientRect(),
          arrowRect = {},
          newArrowRect = {},
          hideArrow = false;

        if (!target || !target.length || !arrow.length) {
          return;
        }

        if (placementObj.attemptedFlips) {
          element.removeClass('top right bottom left').addClass(dir);
        }

        // Flip the arrow if we're in RTL mode
        if (this.isRTL && isXCoord) {
          var opposite = dir === 'right' ? 'left' : 'right';
          element.removeClass('right left').addClass(opposite);
        }

        // Custom target for some scenarios
        if (target.is('.colorpicker')) {
          target = target.next('.trigger');
        }
        if (target.is('.datepicker, .timepicker')) {
          target = target.next('.icon');
        }

        if (target.is('.btn-split-menu, .btn-menu, .btn-actions, .btn-filter, .tab')) {
          target = target.find('.icon');
        }
        if (target.is('.searchfield-category-button')) {
          target = target.find('.icon.icon-dropdown');
        }

        // reset if we borked the target
        if (!target.length) {
          target = placementObj.parent;
        }

        targetRect = target.length ? target[0].getBoundingClientRect() : targetRect;
        arrowRect = arrow.length ? arrow[0].getBoundingClientRect() : arrowRect;
        newArrowRect = {};

        function getMargin(placement) {
          return (placement === 'right' || placement === 'left') ? 'margin-top' : 'margin-left';
        }

        function getDistance() {
          var targetCenter = 0,
            currentArrowCenter = 0,
            d = 0;

          if (dir === 'left' || dir === 'right') {
            targetCenter = targetRect.top + (targetRect.height/2);
            currentArrowCenter = arrowRect.top + (arrowRect.height/2);
            d = targetCenter - currentArrowCenter;
            newArrowRect.top = arrowRect.top + d;
            newArrowRect.bottom = arrowRect.bottom + d;

            if (newArrowRect.top <= elementRect.top || newArrowRect.bottom >= elementRect.bottom) {
              hideArrow = true;
            }
          }
          if (dir === 'top' || dir === 'bottom') {
            targetCenter = targetRect.left + (targetRect.width/2);
            currentArrowCenter = arrowRect.left + (arrowRect.width/2);
            d = targetCenter - currentArrowCenter;
            newArrowRect.left = arrowRect.left + d;
            newArrowRect.right = arrowRect.right + d;

            if (newArrowRect.left <= elementRect.left || newArrowRect.right >= elementRect.right) {
              //hideArrow = true;
            }
          }

          return d;
        }

        // line the arrow up with the target element's "dropdown icon", if applicable
        var positionOpts = {};
        positionOpts[getMargin(dir)] = getDistance();
        if (hideArrow) {
          positionOpts.display = 'none';
        }
        arrow.css(positionOpts);
      },

      //Handle Updating Settings
      updated: function() {
        return this
          .teardown()
          .init();
      },

      // Simple Teardown - remove events & rebuildable markup.
      teardown: function() {
        this.clearOldStyles();
        this.element.removeClass('placeable');

        this.element.off('updated.' + pluginName + ' place.' + pluginName);

        this.element.trigger('afterteardown');
        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new Place(this, settings));
      }
    });
  };

/**
* Popdown Control (TODO: bitly link to soho xi docs)
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.



/**
* Responsive POPUPMENU Control (Context)
* @name popupmenu
*/


  $.fn.popupmenu = function(options) {

    // Settings and Options
    var pluginName = 'popupmenu',
      defaults = {
        menu: null,  //Menu's ID Selector, or a jQuery object representing a menu
        trigger: 'click',  //click, rightClick, immediate ect
        autoFocus: true,
        mouseFocus: true,
        attachToBody: false,
        beforeOpen: null, //Ajax callback for open event
        ariaListbox: false,   //Switches aria to use listbox construct instead of menu construct (internal)
        useCoordsForClick: false, //By default, menus open up underneath their target element.  Set this to true to use mouse coordinates for positioning a menu inside of its target element.
        eventObj: undefined,  //Can pass in the event object so you can do a right click with immediate,
        placementOpts: { // Gets passed to this control's Place behavior
          containerOffsetX: 10,
          containerOffsetY: 10,
          strategies: ['flip', 'shrink']
        },
        offset: { //mludwig, originally these were 0,0
          //x: -80,
          //y: 12,
		  x: -45,
		  y: 12,
        }
      },
      settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function PopupMenu(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      this.isOldIe  = $('html').is('.ie11, .ie10, .ie9');
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Object
    PopupMenu.prototype = {
      init: function() {
        this.setup();
        this.addMarkup();
        this.handleEvents();

        //this.iconFilteringSetup();

        // Allow for an external click event to be passed in from outside this code.
        // This event can be used to pass clientX/clientY coordinates for mouse cursor positioning.
        if (this.settings.trigger === 'immediate') {
          this.open(this.settings.eventObj);
        }
      },

      isRTL: function() {
        return $('html').attr('dir') === 'rtl';
      },

      setup: function() {
        if (this.element.attr('data-popupmenu') && !this.settings.menu) {
          this.settings.menu = this.element.attr('data-popupmenu').replace(/#/g, '');
        }
        // Backwards compatibility for "menuId" menu options coming from other controls
        // that utilize the Popupmenu.
        if (this.settings.menuId) {
          this.settings.menu = this.settings.menuId;
          this.settings.menuId = undefined;
        }

        // keep track of how many popupmenus there are with an ID.
        // Used for managing events that are bound to $(document)
        if (!this.id) {
          this.id = (parseInt($('.popupmenu-wrapper').length, 10)+1).toString();
        }
      },

      //Add markup including Aria
      addMarkup: function () {
        var id,
          leftClick = this.settings.trigger !== 'rightClick',
		  rightClick = this.settings.trigger === 'rightClick',
          immediate = this.settings.trigger === 'immediate';
		if (this.element.hasClass('contextmenu')) {
			leftClick = false;
			rightClick = true;
		}
        switch(typeof this.settings.menu) {
          case 'string': // ID Selector
            id = this.settings.menu;
            this.menu = $('#' + this.settings.menu);
            break;
          case 'object': // jQuery Object
            if (this.settings.menu === null) {
              this.menu = this.element.nextAll('.popupmenu');
            } else {
              this.menu = $(this.settings.menu);
            }

            id = this.menu.attr('id');
            if (!id || id === '') {
              this.menu.attr('id', 'popupmenu-' + this.id);
              id = this.menu.attr('id');
            }
            break;
        }

        //Reuse Same menu
        if (this.menu.parent().is('.popupmenu-wrapper')) {
          return;
        }

        if (this.menu.length === 0) {
          return false;
        }

        // if the menu is deeply rooted inside the markup, detach it and append it to the <body> tag
        // to prevent containment issues. (Now a Preference)
        if (this.settings.attachToBody && this.menu.parent().not('body').length > 0) {
          this.originalParent = this.menu.parent();
          this.menu.detach().appendTo('body');
        }

        this.menu.addClass('popupmenu')
          .data('trigger', this.element)
          .attr('role', (this.settings.ariaListbox ? 'listbox' : 'menu'))
          .wrap('<div class="popupmenu-wrapper"></div>');

        this.wrapper = this.menu.parent('.popupmenu-wrapper');
        this.wrapper.find('svg').icon();

        //Enforce Correct Modality
        this.menu.parent('.popupmenu-wrapper').attr('role', 'application').attr('aria-hidden', 'true');

        // Use "absolute" positioning on the menu insead of "fixed", only when the
        // menu lives <body> tag and we have a <body> element that is tall enough to
        // scroll and is allowed to scroll.
        function scrollableFilter() {
          var c = $(this).css('overflow');
          return c !== 'auto' && c !== 'visible' && c !== 'scroll';
        }
        if (this.wrapper.parents().filter(scrollableFilter).length === 0) {
          this.wrapper.css('position', 'absolute');
        }

        // Wrap submenu ULs in a 'wrapper' to help break it out of overflow.
        this.menu.find('.popupmenu').each(function(i, elem) {
          var popup = $(elem);

          if (!(popup.parent().hasClass('wrapper'))) {
            popup.wrap('<div class="wrapper"></div>');
          }

        });

        // If a button with no border append arrow markup
        var containerClass = this.element.parent().attr('class');
        if ((this.element.hasClass('btn-menu') ||
            this.element.hasClass('btn-actions') ||
            this.settings.menu === 'colorpicker-menu' ||
            this.element.closest('.toolbar').length > 0 ||
            this.element.closest('.masthead').length > 0 ||
            this.element.is('.searchfield-category-button') ||
            (containerClass && containerClass.indexOf('more') >= 0 && this.element.is(':not(.tab-more)')) ||
            containerClass && containerClass.indexOf('btn-group') >= 0)) {

          var arrow = $('<div class="arrow"></div>'),
            wrapper = this.menu.parent('.popupmenu-wrapper');

          wrapper.addClass('bottom').append(arrow);
        }

        // If inside of a ".field-short" container, make smaller
        if (this.element.closest('.field-short').length) {
          this.menu.addClass('popupmenu-short');
        }

        // If button is part of a header/masthead or a container using the "alternate" UI color, add the "alternate" class.
        if (containerClass !== undefined &&
          (this.element.closest('.masthead').not('.search-results .masthead').length > 0)) {
          this.menu.parent('.popupmenu-wrapper').addClass('alternate');
        }

        this.element.attr('aria-haspopup', true);
        this.element.attr('aria-controls', id);

        this.markupItems();

        //Add an Audible Label
        if (!leftClick && !immediate) {
          var audibleSpanId = 'popupmenu-f10-label';
          if ($('#'+audibleSpanId).length === 0) {
            this.element.after('<span style="display:none;" id="' + audibleSpanId + '">' + Locale.translate('PressShiftF10') + '</span>');
          }
          //PressShiftF10
          this.element.attr('aria-describedby', audibleSpanId);
        }
      },

      markupItems: function () {
        this.menu.find('li').attr('role', 'presentation');
        this.menu.find('.popupmenu').parent().parent().addClass('submenu');
        this.menu.find('.submenu').children('a').each(function(i, value) {
          var item = $(value);

          if (item.find('span').length === 0) {
            var text = $(item).text();
            //item.text('<span>' + text + '</span>');
          }

          if (item.find('svg.arrow').length === 0) {
            item.append($.createIconElement({ classes: ['arrow', 'icon-dropdown'], icon: 'dropdown' }));
          }
          item.attr('aria-haspopup', 'true');

        });
        var anchor = this.menu.find('a'),
          isTranslatable = this.menu.hasClass('is-translatable');
        anchor.attr('tabindex', '0').attr('role', (this.settings.ariaListbox ? 'option' : 'menuitem'));
		if (varstore.isCollection) {
			// mludwig, adding labels for print menu items in collection framework - OBSOLETE????
			var list = this.menu.find('li');
			$.each(list, function() {
			// find or children below???
				var listanchor = $(this).find('a');
				if (listanchor.attr("id") == "printpage") {
					listanchor.text(Locale.translate('printpage'));
				}
				else if (listanchor.attr("id") == "printpdf") {
					listanchor.text(Locale.translate('printpdf'));
				}
			});
		}

        //Add Checked indication
        anchor.each(function () {
          var a = $(this);

          if (isTranslatable) {
            var span = $('span', a);
            span.text(Locale.translate(span.text()) || span.text());
          }

          if (a.parent().hasClass('is-checked')) {
            a.attr({'role': 'menuitemcheckbox', 'aria-checked': 'true'});
          }
          if (a.parent().hasClass('is-not-checked')) {
            a.attr({'role': 'menuitemcheckbox', 'aria-checked': 'false'});
          }
        });

        this.menu.find('li.is-disabled a, li.disabled a').attr('tabindex', '-1').attr('disabled', 'disabled');

      },

      handleEvents: function() {
        var self = this,
          leftClick = this.settings.trigger !== 'rightClick',
		  rightClick = this.settings.trigger === 'rightClick',
          immediate = this.settings.trigger === 'immediate';
		
		$('#application-menu a[data-file=""], .accordion-header.collection-group, .accordion-header.collection-link, .accordion-header.collection-group a[data-file=""], .accordion-header.collection a[data-file=""], .wh_tile span.topicref a, .taskbody a[class="external"], .conbody a[class="external"], .contextmenu a, a.foundResult, a[data-file$="javascript:void(0)"]').on('contextmenu', function(e) {
			disableBrowserContextMenu(e);
		});
		
		$('#application-menu').resizable({ ghost: true });
		// set up context menus
		if (this.element.attr('id') == "search-context-trigger") {
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
			var searcharea = $('#landing').contents().find('.wh_topic_page, .wh_main_page');
			// WH_TOPIC_PAGE MIGHT BE WH_TOPIC_CONTENT NOW, ALSO CHECK WH_MAIN_PAGE, check if diff depending on if topic viewed yet
			//var searchlinks = searcharea.find('a.foundResult');
			searcharea.on('contextmenu', 'ol.searchresult a', function(e) {
				self.settings.trigger = 'rightClick';
				disableBrowserContextMenu(e);
				var alink = $(e.currentTarget);	
				var onclickval = "";
				var currTopic = "";

				if (alink.prop('tagName') == "A") {					
					onclickval = alink.attr('datafile');
					if (onclickval.indexOf("?hl") != -1) {
						currTopic = onclickval.substring(0,onclickval.indexOf("?hl"));
					}	
					else {
						currTopic = onclickval;
					}
				}
				var startpage = window.location.pathname.substring(window.location.pathname.lastIndexOf("/")+1);	
				var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);	
				var newURL = whpath+ startpage + "?helpcontent=" + currTopic;

				if (currTopic == "") {
					newURL = whpath + startpage;
				}
				
				$('#landing',window.document).contents().find('#item-a, #item-b').off('click.popupmenu');
				$('#landing',window.document).contents().find('#item-a').on('click.popupmenu',function() {
					inforhelp.openContextTarget(newURL,"tab");
				});
				$('#landing',window.document).contents().find('#item-b').on('click.popupmenu',function() {
					inforhelp.openContextTarget(newURL,"window");
				});
				// mludwig, adding below to handle search copyurl context menu, but all of this should use same code as for topics
				$('#landing',window.document).contents().find('#item-c').on('click.popupmenu',function(e) {
					var copytarget = $(e.target);
					var copiedURL = "";
					var $temp = $("<input id='temptext2' type='text' style='display:block'>");
					var texttocopy = "";
					if (copytarget.attr('id') == "item-c" && $('#landing',window.document).contents().find('#item-c').attr('data-file') != undefined && $('#landing',window.document).contents().find('#item-c').attr('data-file').indexOf("javascript:void(0)") == -1) {
						copiedURL = newURL;
						$temp.text(copiedURL);
						$("body").append($temp);
					}				
					texttocopy = $("#temptext2").get(0);
					
					var area = $('#temptext2')[0],
						sel;
					area.value = copiedURL;				
					area.focus();
					area.select();
					sel = area.value.substring(
						area.selectionStart,
						area.selectionEnd
						);
					document.execCommand('copy'); 
					$('#temptext2').remove();					
				});				
				$('#landing',window.document).contents().find('#item-c').attr('data-file',newURL);
				$('#landing',window.document).contents().find('#item-a').text(Locale.translate('OpenLinkTab'));
				$('#landing',window.document).contents().find('#item-b').text(Locale.translate('OpenLinkWin'));
				$('#landing',window.document).contents().find('#item-c').text(Locale.translate('CopyLink'));
				doOpen(e);					
			});
			var iframectxtmenu = $('#landing').contents().find('.popupmenu-wrapper');
			iframectxtmenu.on('mouseleave.popupmenu', '#contextmenu-3', function(e) {
				return self.close();
			});
			iframectxtmenu.find('#contextmenu-3').on('keydown.popupmenu', function(e) {
				self.handleKeys(e);
			});
		}
		
		if (this.element.attr('id') == "landing-context-trigger" || this.element.attr('id') == "topic-context-trigger") {

			$('#landing',window.document).contents().find('.wh_tiles a[data-file], .wh_publication_toc a[data-file], .wh_breadcrumb a[data-file], .wh_related_links a.navheader_parent_path, .taskbody a, .conbody a, span.xdr, .olchildlink a, a.pdffile').on('contextmenu.popupmenu', function(e) {
				
				self.settings.trigger = 'rightClick';
				disableBrowserContextMenu(e);
				buildContextMenu(e);
				handleContextEvents(e);
			});
			
			// for IE11, so Shift F10 doesn't trigger browser's context menu		
			$('#landing',window.document).contents().find('.wh_tiles a[data-file], .wh_publication_toc a[data-file], .wh_ breadcrumb a[data-file], .wh_related_links a.navheader_parent_path, .taskbody a:not([class="external"]), .conbody a:not([class="external"]), span.xdr, .olchildlink a').on('keydown.popupmenu', function(e) {			
				switch(e.which) {
				  case 13:
				  case 32:
					break;
				  case 121:
					if (e.shiftKey) { //Shift F10
						e.preventDefault();
						buildContextMenu(e);
					}
					break;
				}
			});
			var iframectxtmenu = $('#landing',window.document).contents().find('.popupmenu-wrapper');
			iframectxtmenu.on('mouseleave.popupmenu', '#contextmenu-2', function(e) {
				return self.close();
			});
			iframectxtmenu.on('mouseleave.popupmenu', '#contextmenu-3', function(e) {
				return self.close();
			});
			iframectxtmenu.find('#contextmenu-3').on('keydown.popupmenu', function(e) {
				self.handleKeys(e);
			});
		}
		
		  function buildContextMenu(e) {
			// clear any leftover events
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
			var alink = $(e.currentTarget);	
			var onclickval = "";
			var currTopic = "";
			var whrootpath = window.location.pathname;
			whrootpath = whrootpath.substring(0,whrootpath.lastIndexOf("/"));
			if (alink.prop('tagName') == "A" && !alink.parents().hasClass('hslist')) {
				onclickval = alink.attr('data-file');
				if (!alink.hasClass('foundResult') && !alink.hasClass('external') && !alink.hasClass('coll-link')) {
					currTopic  = onclickval;
					if (currTopic.indexOf("..") != -1) {
						currTopic = inforhelp.calcHistoryPath(currTopic, whrootpath, false);
						if (currTopic.indexOf("cover.html") == -1 && varstore.isCollection) {
							currTopic = currTopic.substring(currTopic.indexOf("/")+1);
						}
					}
					else if (currTopic.indexOf("..") == -1 && currTopic.indexOf("cover.html") != -1) {
						currTopic = inforhelp.calcHistoryPath(currTopic, whrootpath, false);
					}						
				}
				else if (alink.hasClass('foundResult')) {
					//MIGHT NEED TO REMOVE HL PARAMETER if this is ever reached
					currTopic = onclickval + ".html";
				}
				else if (alink.hasClass('external') || alink.hasClass('pdffile')) {
					// set currTopic for internal pdf, external pdf, external html/web site
					currTopic = onclickval;					
				}
			}
			else if (alink.prop('tagName') == "A" && alink.parents().hasClass('hslist')) {
				if (!alink.hasClass('coll-link')) {
					onclickval = alink.attr('data-file');
					currTopic = onclickval;
				}
				else if (alink.hasClass('coll-link')) {
					onclickval = alink.attr('data-file');
					currTopic = window.location.protocol + "//" + window.location.host + "/" + onclickval;
					$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').addClass('coll-link');
				}
			}
			else if (alink.prop('tagName') == "SPAN") {
				onclickval = alink.attr('data-onclickval');
				currTopic = onclickval;
			}				

			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').attr('data-file',currTopic);
			$('#landing',window.document).contents().find('#item-a').text(Locale.translate('OpenLinkTab'));
			$('#landing',window.document).contents().find('#item-b').text(Locale.translate('OpenLinkWin'));
			$('#landing',window.document).contents().find('#item-c').text(Locale.translate('CopyLink'));
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').on('contextmenu.popupmenu', function(e) {
				disableBrowserContextMenu(e);
			});	
			doOpen(e);				  
		  }
		  function handleContextEvents() {
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
			$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').on('click.popupmenu',function(e) {
				var newURL = buildURL(e);
				if ($(e.target).attr('id') == "item-a") {
					inforhelp.openContextTarget(newURL,"tab");
				}
				else if ($(e.target).attr('id') == "item-b") {
					inforhelp.openContextTarget(newURL,"window");
				}
				else if ($(e.target).attr('id') == "item-c") {
					var copytarget = $(e.target);
					var copiedURL = "";
					var $temp = $("<input id='temptext2' type='text' style='display:block'>");
					var texttocopy = "";

					if (copytarget.attr('id') == "item-c" && $('#landing',window.document).contents().find('#item-c').attr('data-file') != undefined && $('#landing',window.document).contents().find('#item-c').attr('data-file').indexOf("javascript:void(0)") == -1) {
						copiedURL = newURL;
						$temp.text(copiedURL);
						$("body").append($temp);
					}				
					texttocopy = $("#temptext2").get(0);
					var area = $('#temptext2')[0],
						sel;
					area.value = copiedURL;				
					area.focus();
					area.select();
					sel = area.value.substring(
						area.selectionStart,
						area.selectionEnd
						);
					document.execCommand('copy'); 
					$('#temptext2').remove();
				}
				$('#landing',window.document).contents().find('#item-a, #item-b, #item-c').off('click.popupmenu');
			});	
		  }
		  
		  function buildURL(e) {
			  // for special collection links to other help systems/doc libraries
			  if ($(e.target).hasClass('coll-link')) {
				  return $(e.target).attr('data-file');
			  }
			  // all other cases: 
			var startpage = "default.html";
			var startroot = window.document.getElementsByTagName('html');
			var starturl = startroot[0].parentNode.documentURI;
			var whpath = starturl;
			if (whpath.indexOf("?") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("?"));
			}
			if (whpath.indexOf("#") != -1) {
				whpath = whpath.substring(0,whpath.lastIndexOf("#"));
			}
			whpath = whpath.substring(0,whpath.lastIndexOf("/")+1);
			var dataid = $(e.target).attr('data-file');
			var nonhtmlfile = dataid.indexOf(".htm") == -1;
			var pdffile = dataid.indexOf(".pdf") != -1;
			if (dataid.indexOf("/") == 0) {
				// This assumes that any xref with scope=external that starts with a slash
				// is meant to link to different help system on same server using the 
				// format: "differentHelpSys/default.html?helpcontent=sometopic.html
				var serverroot = window.location.protocol + '//' + window.location.host;
				return serverroot + dataid;
			}

			var httpurl = dataid.indexOf("http:") != -1 || dataid.indexOf("https:") != -1;
			var nonEnglishTopic = $(e.target).parents('html.fixed').attr('lang') != "en-us";
			var englishTopic = $(e.target).parents('html.fixed').attr('lang') == "en-us";
			var nonEnglishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us";
			var englishHelpSys = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() == "en-us";		

			if (dataid.indexOf("/") > 0 && !varstore.isCollection && !httpurl) {
				dataid = dataid.substring(dataid.lastIndexOf("/") +1);
			}
			//var englishTopic = ($('#landing',window.document).contents().find('html.fixed').attr('lang') == "en-us" && inforhelp.getIsoLang($('html').attr('lang')).toLowerCase() != "en-us");			
	
			if (httpurl) {
				// for external links
				return dataid;
			}
			if (!httpurl && nonhtmlfile) {
				// for links to internal PDF files (and potentially other types in future)
				var mapfolder = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
				if (varstore.isCollection) {
					if (englishTopic && nonEnglishHelpSys) {					
						var url = whpath + mapfolder + "/" + dataid;
						if (inforhelp.UrlExists(url)) {
							return url;
						}
						else {
							var currLang = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase();
							url = url.replace(currLang,"en-us");
							return url;
						}				
					}
					else if (!nonEnglishHelpSys || (nonEnglishHelpSys && nonEnglishTopic)) {
						if (mapfolder === "") {
							// for links on pdflist that already have mapfolder
							return whpath + dataid;
						}
						else {
							// for links in topics
							return whpath + mapfolder + "/" + dataid;
						}
												
					}			
				}
				else if (!varstore.isCollection) {
					var url = whpath + dataid;
					if (englishTopic && nonEnglishHelpSys) {					
						if (inforhelp.UrlExists(url)) {
							return url;
						}
						else {
							var currLang = inforhelp.getIsoLang($('html').attr('lang')).toLowerCase();
							url = url.replace(currLang,"en-us");
							return url;
						}				
					}
					else if (!nonEnglishHelpSys || (nonEnglishHelpSys && nonEnglishTopic)) {
						return url;						
					}					
				}
			}

			var ellipsis = inforhelp.getFrequency(dataid,"..");
			// check if already has mapfolder in data-file
			var includesmap = false;
			for (var i = 0; i < titlemap.titlemapping.length; ++i) {
				var folder = titlemap.titlemapping[i].folder;
				if (dataid.indexOf(folder) != -1) {
					includesmap = true;
					break;
				}
			}

			if (varstore.isCollection && includesmap == false && (englishHelpSys || (nonEnglishTopic && nonEnglishHelpSys))) {
				var map = $('#landing',window.document).contents().find('meta[name="INF.Task.Docidc"]').attr('content');
				var pathTopic = $('#landing',window.document).contents().find('meta[name="wh-out-relpath"]').attr('content');
				if (varstore.isCollection) {
					basetopic = map + "/" + pathTopic;
				}
				else {
					basetopic = pathTopic;
				}				
				//var basetopic = $('#landing',window.document).attr('src');
				if (basetopic.indexOf("?hl") != -1) {
					var hl = basetopic.substring(basetopic.indexOf("?hl")+4);
					basetopic = basetopic.substring(0,basetopic.indexOf("?hl"));
					basetopic = basetopic + "&hl=" + hl;
				}
				var mapfolder = inforhelp.getMapFolder(basetopic);
				var relpath = basetopic.substring(basetopic.indexOf(mapfolder)+mapfolder.length+1);
				relpath = relpath.substring(0,relpath.lastIndexOf("/"));			
				if (ellipsis > 0) {
					for (var i = 0; i < ellipsis; i++) {
						relpath = relpath.substring(0,relpath.lastIndexOf("/"));
						dataid = dataid.substring(dataid.indexOf("/") + 1);
					}
					if (relpath.length > 0) {
						return whpath +startpage + "?helpcontent=" + mapfolder + "/" + relpath + "/" + dataid;
					}
					else {
						return whpath +startpage + "?helpcontent=" + mapfolder + "/" + dataid;
					}					
				}
				else if (ellipsis == 0) {
					return whpath +startpage + "?helpcontent=" + mapfolder + "/" + dataid;
				}
			}
			else if (englishTopic && nonEnglishHelpSys && !nonhtmlfile) {	
				if (!varstore.isCollection || (varstore.isCollection && dataid.indexOf("cover.html") == -1)) {
					return whpath + startpage + "?helpcontent=" + dataid;
				}
				else if (varstore.isCollection && dataid.indexOf("cover.html") != -1) {
					var currRelPath = $('#landing').attr('src');
					var engMapFolder = currRelPath.substring(currRelPath.indexOf("/en-us/")+7);
					engMapFolder = engMapFolder.substring(engMapFolder.indexOf("/") + 1);
					engMapFolder = engMapFolder.substring(0,engMapFolder.indexOf("/"));
					dataid = engMapFolder + "/" + dataid;
					return whpath + startpage + "?helpcontent=" + dataid;
				}
			}
			
			else {
				return whpath + startpage + "?helpcontent=" + dataid;
			}					 
		  }

		if (this.element.attr('id') == "home-context-trigger") {
			var appmenuctxtmenu = $('.popupmenu-wrapper');
			appmenuctxtmenu.on('mouseleave.popupmenu', '#contextmenu-1', function(e) {
				return self.close();
			});	
			// Filtering out collection-group heads in collections and topichead entries in a map toc; those don't need context menu
			$('#application-menu .accordion-header:not(.collection-group) a[data-file]').filter("a:not([data-file=''])").filter("a:not([data-file$='javascript:void(0)'])").on('keydown.accordion', function(e) {
				switch(e.which) {
				  case 13:
				  case 32:
					break;
				  case 121:
					if (e.shiftKey) { //Shift F10
						e.preventDefault();
						buildAccordionContextMenu(e);
					}
					break;
				}
			}).on('contextmenu', function(e) {		
				self.settings.trigger = 'rightClick';
				disableBrowserContextMenu(e);
				buildAccordionContextMenu(e);
				handleAccContextEvents(e);
			});			
		}
		
		function buildAccordionContextMenu(e) {
			// turn off any left over events
			$('#itemone, #itemtwo,#itemthree').off('click.popupmenu');
			var alink = $(e.currentTarget);
			var onclickval = "";
			var currTopic = "";
			if (alink.prop('tagName') == "A" && alink.parent().hasClass('accordion-header') && !alink.parent().hasClass('collection-link')) {
				currTopic = alink.attr('data-file');
			}
			else if (alink.parent().hasClass('collection-link')) {
				currTopic = window.location.protocol + "//" + window.location.host + "/" + alink.attr('data-file');
			}
			var startpage = window.location.pathname.substring(window.location.pathname.lastIndexOf("/")+1);			
			var newURL = inforhelp.whUrl + startpage + "?helpcontent=" + currTopic;
			if (currTopic == "") {
				currTopic = inforhelp.whUrl + startpage;
			}
			$('#itemone, #itemtwo,#itemthree').attr('data-file',currTopic);
			$('#itemone').text(Locale.translate('OpenLinkTab'));
			$('#itemtwo').text(Locale.translate('OpenLinkWin'));
			$('#itemthree').text(Locale.translate('CopyLink'));
			$('#itemone, #itemtwo, #itemthree').on('contextmenu.popupmenu', function(e) {
				disableBrowserContextMenu(e);
			});
			doOpen(e);
		}
		// set up events on collection tiles with group headings MOVE NEXT TO OTHER TILE SETUP STUFF
		$('.hslist, .hslist2, .hslist3').on('keydown.popupmenu', function(e) {
			self.handleKeys(e);
		});
	
	  function handleAccContextEvents() {
		$('#itemone, #itemtwo, #itemthree').on('click.popupmenu',function(e) {
			var newURL = buildAccordionURL(e);
			if ($(e.target).attr('id') == "itemone") {
				inforhelp.openContextTarget(newURL,"tab");
			}
			else if ($(e.target).attr('id') == "itemtwo") {
				inforhelp.openContextTarget(newURL,"window");
			}
			else if ($(e.target).attr('id') == "itemthree") {
				var copytarget = $(e.target);
				var copiedURL = "";
				var $temp = $("<input id='temptext2' type='text' style='display:block'>");
				var texttocopy = "";
				if (copytarget.attr('id') == "itemthree") {
					copiedURL = newURL;
					$temp.text(copiedURL);
					$("body").append($temp);
				}				
				texttocopy = $("#temptext2").get(0);
				var area = $('#temptext2')[0],
					sel;
				area.value = copiedURL;				
				area.focus();
				area.select();
				sel = area.value.substring(
					area.selectionStart,
					area.selectionEnd
					);
				document.execCommand('copy'); 
				$('#temptext2').remove();
			}
			$('#itemone, #itemtwo,#itemthree').off('click.popupmenu');
		});	
	  }
	 function buildAccordionURL(e) {
		var startpage = "default.html";
		var whpath = inforhelp.whUrl.substring(0,inforhelp.whUrl.lastIndexOf("/")+1);
		if ($(e.target).attr('data-file') == "" || $(e.target).attr('data-file').indexOf("javascript:void(0)") != -1) { 
			return whpath + startpage;
		}
		else if ($(e.target).attr('data-file').startsWith("http")) {
			return $(e.target).attr('data-file');
		}
		else {
			return whpath + startpage + "?helpcontent=" + $(e.target).attr('data-file');
		}			 
	  }  
        function disableBrowserContextMenu(e) {
          e.stopPropagation();
          e.preventDefault();
          return false;
        }

        function doOpen(e) {
          var rightClick = self.settings.trigger === 'rightClick';
          e.stopPropagation();
          e.preventDefault();

          if (rightClick && self.menu.hasClass('is-open')) {
            self.close();
            self.open(e);
            return;
          }

          if (self.menu.hasClass('is-open')){
            self.close();
          } else {
			  var iframectxtmenu = $('#landing',window.document).contents().find('.popupmenu-wrapper');
			  if ($(e.target).attr('datafile') != undefined && $(e.target).attr('datafile').indexOf('.html') != -1) {
				  //mludwig, need to force context menu for search results
				  self.menu = $('#landing').contents().find('#contextmenu-3');				  
				  iframectxtmenu.on('mouseleave.popupmenu', '#contextmenu-3', function(e) {
				});
				var initoptions = inforhelp.getIsoLang($('html').attr('lang'));
				iframectxtmenu.initialize(initoptions);
			  }
             self.open(e);
          }
        }
		
        if (leftClick && !immediate) {
			/*if ($(this.element).hasClass('menu')) {
				// this creates events for links in list of pdfs
				$('a.pdffile').off('click.popupmenu');
				$('a.pdffile').on('click.popupmenu',function(e) {
					let dataid = $(e.target).attr('data-file');
					inforhelp.printPDF(dataid);
				});
			}*/
			if ($(this.element).hasClass('menu')) {
				// This only applies to mobile device menu
				this.element.off('mousedown.popupmenu touchend.popupmenu');
				this.element.on('mousedown.popupmenu touchend.popupmenu', function (e) {
					doOpen(e);
				});
			}
			if ($(this.element).hasClass('searchselect-button')) {
				this.element.off('mousedown.popupmenu touchend.popupmenu');
				this.element.on('mousedown.popupmenu touchend.popupmenu', function (e) {
					e.stopPropagation();
					e.preventDefault();
					if (e.button > 0 || self.element.is(':disabled')) {
						return;
					}					
					var bookroot = "";
					if (varstore.isCollection) {
						bookroot = $(".booktitle",window.document).first().attr("data-id");
						if (bookroot != "" && bookroot !== undefined) {
							doOpen(e);
						}					
					}
				});
			}			  		
		}

	function checkpdfjs(pdfjspath,callback) {
		var pdfjsexists = false;
		$.ajax({
			  url: pdfjspath, 
			  method: 'HEAD',
			  success: function(data){				  
				 pdfjsexists = true;
				 callback(pdfjsexists);
			  },
			  error: function(data){
				pdfjspath = "";
				pdfjsexists = false;
				callback(pdfjsexists);
			  },
		});			
	}
	
        //settings.trigger
        if (!leftClick) {
          this.menu.parent().on('contextmenu.popupmenu', disableBrowserContextMenu);
          this.element
            .on('contextmenu.popupmenu', disableBrowserContextMenu)
            .on('mousedown.popupmenu', function (e) {
              if (e.button === 2 || (e.button === 0 & e.ctrlKey)) {
				  var iframectxtmenu = $('#landing').contents().find('.popupmenu-wrapper');
				  iframectxtmenu.initialize(initoptions);
                doOpen(e);
              }
            });
        }

        // Setup these next events no matter what trigger type is		
        this.element.not('.autocomplete, .contextmenu')
          .on('keydown.popupmenu', function (e) {
            switch(e.which) {
              case 13:
              case 32:
                self.open(e, true);
                break;
              case 121:
			  	//below causes problems with shift f10 on breadcrumbs
                if (e.shiftKey) { //Shift F10
                 // self.open(e, true);
                }
                break;
            }
          })
          .on('updated.popupmenu', function(e) {
            e.stopPropagation();
            self.updated();
          });

          // Media Query Listener to detect a menu closing on mobile devices that change orientation.
          this.matchMedia = window.matchMedia('(orientation: landscape)');
          this.mediaQueryListener = function() {
            // Match every time.
            if (!self.menu.hasClass('is-open')) {
              return;
            }
            self.close();
          };
          this.matchMedia.addListener(this.mediaQueryListener);
      },

      handleKeys: function (e) {
        var self = this;
        //http://access.aol.com/dhtml-style-guide-working-group/#popupmenu

        //Handle Events in Anchors
        this.menu.onTouchClick('popupmenu', 'a')
          .on('click.popupmenu', 'a', function (e) {

          var anchor = $(this),
            href = anchor.attr('href'),
            selectionResult = [anchor];

          if (anchor.attr('disabled') || anchor.parent().is('.submenu') || anchor.parent().is('.is-disabled')) {
            //Do not close parent items of submenus on click
            e.preventDefault();
            return;
          }

          if (anchor.find('input[checkbox]').length > 0) {
            return;
          }

          if (self.isInSelectableSection(anchor) || self.menu.hasClass('is-selectable') || self.menu.hasClass('is-multiselectable')) {
            selectionResult = self.select(anchor);
          }

          //Single toggle on off of checkbox class
          if (anchor.parent().hasClass('is-toggleable')) {
            anchor.parent().toggleClass('is-checked');
          }

          // Trigger a selected event containing the anchor that was selected
          self.element.triggerHandler('selected', selectionResult);

          // MultiSelect Lists should act like other "multiselect" items and not close the menu when options are chosen.
          if (self.menu.hasClass('is-multiselectable') || self.isInMultiselectSection(anchor)) {
            return;
          }

          self.close();

          if (self.element.is('.autocomplete')) {
            return;
          }

          if (href && href.charAt(0) !== '#') {
            if (anchor.attr('target') === '_blank') {
			  var winopener = window.open(href, '_blank');
              winopener.opener = null;
            } else {
              window.location.href = href;
            }
            return true;
          }

          e.preventDefault();
          e.stopPropagation();
        });

        var excludes = 'li:not(.separator):not(.hidden):not(.heading):not(.group):not(.is-disabled)';

        //Select on Focus
        if (this.settings.mouseFocus) {
          this.menu.on('mouseenter.popupmenu', 'li', function () {
            self.highlight($(this).children('a'));
          });
        }

        $(document).off('keydown.popupmenu.' + this.id).on('keydown.popupmenu.' + this.id, function (e) {
          var key = e.which,
            focus;

          //Close on escape
          if (key === 27) {
            e.stopPropagation();
            self.close(true);
          }

          if (key === 9) {
            e.stopPropagation();
            self.close(true);
          }

          //Select Checkboxes
          if (key === 32) {
            e.stopPropagation();

            var target = $(e.target),
              checkbox = target.find('input:checkbox');
            if (checkbox.length) {
              checkbox.trigger('click');
              return;
            }

            var a = $();

            // Return here and let Tabs control handle the spacebar
            if (target.is('.tab') || target.parent().is('.tab') || target.is('.tab-more')) {
              // Spacebar acts like Enter if there aren't any checkboxes (trigger links, etc)
              e.preventDefault();
              return;
            }

            if (target.is('li')) {
              a = target.children('a');
            }

            if (target.is('a')) {
              a = target;
            }

            if (a.length) {
              a.trigger('click');
              return;
            }
          }
          focus = self.menu.find(':focus');

          var isPicker = (self.settings.menu === 'colorpicker-menu'),
            isAutocomplete = self.element.is('.autocomplete');

          // Close Submenu
          if (key === 37 && !isAutocomplete) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.closest('.popupmenu')[0] !== self.menu[0] && focus.closest('.popupmenu').length > 0) {
              focus.closest('.popupmenu').removeClass('is-open').parent().parent().removeClass('is-submenu-open');
              self.highlight(focus.closest('.popupmenu').parent().prev('a'));
            }
          }

          //Up on Up
          if ((!isPicker && key === 38) || (isPicker && key === 37)) {
             e.stopPropagation();
             e.preventDefault();
			if (e.target.tagName == "A" && $(e.target).attr('id') === undefined) {
				// mludwig, adding special case of collection tile submenus
				var prevelems = $(e.target).parent().prevAll('li');
				if (prevelems.length === 0 ) {
					self.highlight($(e.target).parent('li').parent('ul').children('li').last().find('a'));
				}
				else {
					 self.highlight($(e.target).parent('li').prev('li').find('a')); 
				}
				return;
			}
			else {
				//Go back to Top on the last one (below is original Soho code
				if (focus.parent().prevAll(excludes).length === 0) {
				  if (focus.length === 0) {
					self.highlight(self.menu.children(excludes).last().find('a'));
				  } else {
					self.highlight(focus.closest('.popupmenu').children(excludes).last().find('a'));
				  }
				  return;
				}
				self.highlight(focus.parent().prevAll(excludes).first().find('a'));
			}
          }

          //Up a square
          if (isPicker && key === 38) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.parent().prevAll(excludes).length > 0) {
              self.highlight($(focus.parent().prevAll(excludes)[9]).find('a'));
            }
          }

          //Right Open Submenu
          if (key === 39  && !isAutocomplete) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.parent().hasClass('submenu')) {
              self.showSubmenu(focus.parent());
              self.highlight(focus.parent().find('.popupmenu a:first'));
            }
          }

          //Down
          if ((!isPicker && key === 40) || (isPicker && key === 39 && !isAutocomplete)) {
            e.stopPropagation();
            e.preventDefault();			
			if (e.target.tagName == "A" && $(e.target).attr('id') === undefined) {
				// mludwig, adding special case of collection tile submenus
				var nextelems = $(e.target).parent().nextAll('li');
				if (nextelems.length === 0 ) {
					self.highlight($(e.target).parent('li').parent('ul').find('li').first().find('a'));
				}
				else {
					 self.highlight($(e.target).parent('li').next('li').find('a')); 
				}
				return;
			}
			else {
				// mludwig, following is the original Soho code
				//Go back to Top on the last one
				if (focus.parent().nextAll(excludes).length === 0) {
				  if (focus.length === 0) {
					self.highlight(self.menu.children(excludes).last().find('a'));
				  }else {
					self.highlight(focus.closest('.popupmenu').children(excludes).first().find('a'));
				  }
				  return;
				}
				self.highlight(focus.parent().nextAll(excludes).first().find('a'));
			}
          }

          //Down a square
          if ((isPicker && key === 40)) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.parent().nextAll(excludes).length > 0) {
              self.highlight($(focus.parent().nextAll(excludes)[9]).find('a'));
            }
          }
        });
		
		// making contextmenu-3 specific version (for search result links)
        if ($(e.target).parent().parent().attr('id') == 'contextmenu-3') {
          var key = e.which,
            focus;

          //Close on escape
          if (key === 27) {
            e.stopPropagation();
            self.close(true);
          }

          if (key === 9) {
            e.stopPropagation();
            self.close(true);
          }

          focus = self.menu.find(':focus');

          var isPicker = (self.settings.menu === 'colorpicker-menu'),
            isAutocomplete = self.element.is('.autocomplete');

          // Close Submenu
          if (key === 37 && !isAutocomplete) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.closest('.popupmenu')[0] !== self.menu[0] && focus.closest('.popupmenu').length > 0) {
              focus.closest('.popupmenu').removeClass('is-open').parent().parent().removeClass('is-submenu-open');
              self.highlight(focus.closest('.popupmenu').parent().prev('a'));
            }
          }

          //Up on Up
          if ((!isPicker && key === 38) || (isPicker && key === 37)) {
             e.stopPropagation();
             e.preventDefault();

            //Go back to Top on the last one
            if (focus.parent().prevAll(excludes).length === 0) {
              if (focus.length === 0) {
                self.highlight(self.menu.children(excludes).last().find('a'));
              } else {
                self.highlight(focus.closest('.popupmenu').children(excludes).last().find('a'));
              }
              return;
            }
            self.highlight(focus.parent().prevAll(excludes).first().find('a'));
          }

          //Right Open Submenu
          if (key === 39  && !isAutocomplete) {
            e.stopPropagation();
            e.preventDefault();

            if (focus.parent().hasClass('submenu')) {
              self.showSubmenu(focus.parent());
              self.highlight(focus.parent().find('.popupmenu a:first'));
            }
          }

          //Down
          if ((!isPicker && key === 40) || (isPicker && key === 39 && !isAutocomplete)) {
            e.stopPropagation();
            e.preventDefault();

            //Go back to Top on the last one
            if (focus.parent().nextAll(excludes).length === 0) {
              if (focus.length === 0) {
                self.highlight(self.menu.children(excludes).first().find('a'));
              } else {
                self.highlight(focus.closest('.popupmenu').children(excludes).first().find('a'));
              }
              return;
            }
			self.highlight(focus.parent().nextAll(excludes).find('a'));
          }
        }	
		
      },

      // Filtering icon initial setup
	  // mludwig, Deleting iconFilteringSetup and iconFilteringUpdate to delete changeIcon call
      // Filtering icon update

      position: function(e) {
        var self = this,
          target = this.element,
          isRTL = this.isRTL(),
          wrapper = this.menu.parent('.popupmenu-wrapper'),
          mouse =  {
            x: e && e.clientX ? e.clientX : (window.event && window.event.clientX) ? window.event.clientX : 0,
            y: e && e.clientY ? e.clientY : (window.event && window.event.clientY) ? window.event.clientY : 0
          },
          menuDimensions = {
            width: this.menu.outerWidth(),
            height: this.menu.outerHeight()
          };
		// adjust x and y if 0 or negative (IE11 and Edge don't calculate target location correctly on Shift+F10)
		var useNewCoordinates = false;
		if (mouse.x <= 0 || mouse.y <= 0) {
			useNewCoordinates = true;
			var linkx = $(e.target).offset().left;
			var linky = $(e.target).offset().top;
			var linkwidthadj = ($(e.target).width()/2) - 30;
			var linkheightadj = 35;
			// move menu up if link is at bottom of iframe
			if (linky + 130 > $('#landing',window.document).height() && $('#landing',window.document).height() > 0) {
				linkheightadj = -85;
			}
			mouse.x = linkx + linkwidthadj;
			mouse.y = linky + linkheightadj;
		}
        if (!wrapper.length) {
          return;
        }

        if (target.is('svg, .icon') && target.closest('.tab').length) {
          target = target.closest('.tab');
        }

        function getCoordinates(e, axis) {
          axis = ((axis === 'x' || axis === 'y') ? axis : 'x');
          return mouse[axis]; // use mouseX/mouseY if this doesn't work
        }

        // Reset the arrow
        wrapper.find('.arrow').removeAttr('style');

        var opts = $.extend({}, this.settings.placementOpts);
        if ((this.settings.trigger === 'immediate' && this.settings.eventObj) || this.settings.trigger === 'rightClick') {
          opts.x = getCoordinates(e, 'x') - (isRTL ? menuDimensions.width : 0) + ((isRTL ? -1 : 1) * this.settings.offset.x);
          opts.y = getCoordinates(e, 'y') + this.settings.offset.y;

          opts.strategies = ['flip', 'nudge', 'shrink'];
		  //var currBody = $('iframe',window.document).contents().find('body');
		  var currBody = $('.page-container.two-column');
		  var currHeight = currBody.height();
		  var offsetadj = 130 - currHeight + opts.y;
		  if (currHeight - opts.y < 130) {
			  opts.y = opts.y - offsetadj;
		  }
        } else if (useNewCoordinates) {
			opts.x = mouse.x;
			opts.y = mouse.y;
		} else {
          opts.x = this.settings.offset.x || 0;
          opts.y = this.settings.offset.y || 0;
          opts.parent = this.element;
          opts.placement = 'bottom';
        }

        //=======================================================
        // BEGIN Temporary stuff until we sort out passing these settings from the controls that utilize them
        //=======================================================

        // change the width of the menu if it's shorter than the trigger, in some conditions
        var triggerWidth = this.element.outerWidth(true),
          menuIsSmallerThanTrigger = (target.is('.btn-menu') && menuDimensions.width < triggerWidth);

        function shouldBeLeftAligned(target) {
          return target.is('.btn-split-menu, .btn-menu, .tab, .searchfield-category-button') &&
            !target.parent('.pager-pagesize').length;
        }

        function shouldBeRightAligned(target) {
          return target.is('.btn-actions, .btn-filter') || menuIsSmallerThanTrigger;
        }

        // Customize some settings based on the type of element that is doing the triggering.
        if (shouldBeLeftAligned(target)) {
          opts.parentXAlignment = (isRTL ? 'right': 'left');
        }
        if (shouldBeRightAligned(target)) {
          opts.parentXAlignment = (isRTL ? 'left' : 'right');
        }

        //=======================================================
        // END Temporary stuff until we sort out passing these settings from the controls that utilize them
        //=======================================================

        wrapper.one('afterplace.popupmenu', function(e, positionObj) {
          self.handleAfterPlace(e, positionObj);
        });

        wrapper.place(opts);
        wrapper.data('place').place(opts);
      },

      handleAfterPlace: function(e, placementObj) {
        var wrapper = this.menu.parent('.popupmenu-wrapper');
        wrapper.data('place').setArrowPosition(e, placementObj, wrapper);

        if (placementObj.height) {
          wrapper.css('height', '');
          //this.menu.height(placementObj.height);
		  this.menu.height("auto");
        }
        if (placementObj.width) {
          wrapper.css('width', '');
          //this.menu.width(placementObj.width);
		  //mludwig, fixing for menu dropdown, line above leaves width too short
		  if (!this.isRTL()) {
			  this.menu.width('auto');
		  }
		  else {
			 // this.menu.width(placementObj.width);
			 this.menu.width('180');
		  }
		 //this.menu.width('140');
        }

        wrapper.triggerHandler('popupmenuafterplace', [placementObj]);
        return placementObj;
      },

      open: function(e, ajaxReturn) {
        var self = this;

        var canOpen = this.element.triggerHandler('beforeopen', [this.menu]);
        if (canOpen === false) {
          return;
        }
		// following is a way to force the context menus to open, somehow this.menu was ending up undefined
		if ($(this.element).attr('id') == "search-context-trigger") {
			this.menu = $(this.element).parent('p').parent('div').next('.popupmenu-wrapper').first().children('#contextmenu-3');
		}
		if ($(this.element).attr('id') == "landing-context-trigger") {
			this.menu = $(this.element).parent('p').parent('div').next('.popupmenu-wrapper').first().children('#contextmenu-3');
		}
		if ($(this.element).attr('id') == "topic-context-trigger") {
			this.menu = $(this.element).parent('.homediv').parent('.wh_breadcrumb').parent('.wh_tools').parent('.row').siblings('.popupmenu-wrapper').first().children('#contextmenu-2');
			if (this.menu.length == 0) {
				this.menu = $(this.element).parent().parent().siblings('.popupmenu-wrapper').first().children('#contextmenu-4');
			}
		}
		if ($(this.element).hasClass("searchselect-button")) {
			this.menu = $(this.element).parent('.searchfield-wrapper').children('.popupmenu-wrapper').children('#popupmenu-2');
		}		
        $('.popupmenu').not('.hslist').not(this.menu).removeClass('is-open');  //close others.
		// mludwig, also removing is-open for print and search select button
		$('#printButton, .searchselect-button').removeClass('is-open');
		var wrappers = $('#landing',window.document).contents().find('.popupmenu-wrapper');
        this.element.addClass('is-open');
        this.menu.addClass('is-open').attr('aria-hidden', 'false');
        this.position(e);
		// mludwig, just using single command here for new design, if it works
		//this.menu.parent().css('left', 40 + 'px');
        if (this.element.closest('.header').length > 0) {
          this.menu.parent().css('z-index', '9001');
		  //mludwig, needed to push print menu to left
		  if (!Locale.isRTL()) {
			  var currleft = this.menu.parent().css('left');
			  var leftadj = 0;
			  if (currleft != undefined) {
				  leftadj = currleft.substring(0, currleft.indexOf('px'));
			  }
			 // var leftadj = currleft.substring(0, currleft.indexOf('px'));
			  var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
			  if (!(this.menu.hasClass('contextmenu'))){	
				var newleft = leftadj - 210;
				if (touchenabled) {
					newleft = leftadj - 65;
				}				
				this.menu.parent().css('left', newleft + 'px');
			  }
			  else if (this.menu.hasClass('contextmenu'))
				this.menu.parent().css('left', leftadj + 'px');
		  }
		  else if (Locale.isRTL()) {
		  // used to be "left", see if change is correct
			if (this.menu.attr('id') == "contextmenu-1") {
				this.menu.parent().css('right', 40 + 'px');
			}
			else {
				// for mobile device menu on left side
				this.menu.parent().css('left', 40 + 'px');
			}
			  
		  }
        }

        //Close on Document Click etc.
        setTimeout(function () {
          $(document).on('touchend.popupmenu.' + this.id +' click.popupmenu.' + this.id, function (e) {
            if (e.button === 2) {
              return;
            }

            //Click functionality will toggle the menu - otherwise it closes and opens
            if ($(e.target).is(self.element)) {
              return;
            }

            if ($(e.target).closest('.popupmenu').length === 0) {
              self.close(true, self.settings.trigger ==='rightClick');
            }
          });

          if (window.orientation === undefined) {
            $(window).on('resize.popupmenu', function() {
              self.close();
            });
          }

          $(window).on('scroll.popupmenu', function () {
            self.close();
          });

          $('.scrollable').on('scroll.popupmenu', function () {
            self.close();
          });
          self.element.trigger('open', [self.menu]);

          if (self.settings.trigger === 'rightClick') {
            self.element.on('click.popupmenu touchend.popupmenu', function () {
              self.close();
            });
          }
        }, 300);

        //Hide on iFrame Clicks - only works if on same domain
        $('iframe').each(function () {
          var frame = $(this);
          frame.ready(function () {

            try {
              frame.contents().find('body').on('click.popupmenu', function () {
                self.close();
              });
            } catch (e)  {
              //Ignore security errors on out of iframe
            }

          });
        });
        this.handleKeys(e);

        //hide and decorate submenus - we use a variation on
        var tracker = 0, startY, menuToClose, timeout;

        self.menu.find('.popupmenu').removeClass('is-open');
        self.menu.on('mouseenter.popupmenu touchstart.popupmenu', '.submenu', function (e) {
          var menuitem = $(this);
          startY = e.pageX;

          clearTimeout(timeout);
          timeout = setTimeout(function () {
            self.showSubmenu(menuitem);
          }, 300);

          $(document).on('mousemove.popupmenu.' + this.id, function (e) {
            tracker = e.pageX;
          });
        }).on('mouseleave.popupmenu', '.submenu', function () {
          $(document).off('mousemove.popupmenu.' + this.id);

          menuToClose = $(this).find('ul');

          var isLeft = parseInt(menuToClose.parent('.wrapper').css('left')) < 0,
            canClose = (tracker - startY) < 3.5;

          if (isLeft) {
            canClose = (tracker - startY) >= 0;
          }

          if (canClose) { //We are moving slopie to the menu
            menuToClose.removeClass('is-open').removeAttr('style');
            menuToClose.parent('.wrapper').removeAttr('style');
            menuToClose.parent().parent().removeClass('is-submenu-open');
            self.element.removeClass('is-open');
          }
          clearTimeout(timeout);
        });

        if (self.settings.autoFocus) {
          setTimeout(function () {
            var excludes = ':not(.separator):not(.hidden):not(.heading):not(.group):not(.is-disabled)',
              selection = self.menu.children(excludes).find('.is-selected').children('a');

            if (!selection.length) {
              selection = self.menu.children(excludes).first().children('a');
            }
            self.highlight(selection);
            self.element.trigger('afteropen', [self.menu]);
          }, 1);
        }
      },

      showSubmenu: function (li) {
        var wrapper = li.children('.wrapper').filter(':first');

        // Wrap if not wrapped (dynamic menu situation)
        if (wrapper.length === 0) {
          var ul = li.children('ul').filter(':first');
          ul.wrap('<div class="wrapper"></div>');
          wrapper = ul.parent();
        }

        var menu = wrapper.children('.popupmenu'),
          mainWrapperOffset = li.parents('.popupmenu-wrapper:first').offset().top;
        li.parent().find('.popupmenu').removeClass('is-open').removeAttr('style');

        wrapper.css({
          'left': li.position().left + li.outerWidth(),
          'top': (parseInt(li.position().top) - 5) + 'px'
        }).children('.popupmenu').addClass('is-open');

        //Handle Case where the menu is off to the right
        var menuWidth = menu.outerWidth();
        if ((wrapper.offset().left + menuWidth) > ($(window).width() + $(document).scrollLeft())) {
          wrapper.css('left', -9999);
          menuWidth = menu.outerWidth();
          wrapper.css('left', li.position().left - menuWidth);
          //Did it fit?
          if (wrapper.offset().left < 0) {
            //No. Push the menu's left offset onto the screen.
            wrapper.css('left', li.position().left - menuWidth + Math.abs(wrapper.offset().left) + 40);
            menuWidth = menu.outerWidth();
          }
          // Do one more check to see if the right edge bleeds off the screen.
          // If it does, shrink the menu's X size.
          if ((wrapper.offset().left + menuWidth) > ($(window).width() + $(document).scrollLeft())) {
            var differenceY = (wrapper.offset().left + menuWidth) - ($(window).width() + $(document).scrollLeft());
            menuWidth = menuWidth - differenceY;
            menu.width(menuWidth);
          }
        }

        //Handle Case where menu is off bottom
        var menuHeight = menu.outerHeight();
        if ((wrapper.offset().top + menuHeight) > ($(window).height() + $(document).scrollTop())) {
          // First try bumping up the menu to sit just above the bottom edge of the window.
          var bottomEdgeCoord = wrapper.offset().top + menuHeight,
            differenceFromBottomY = bottomEdgeCoord - ($(window).height() + $(document).scrollTop());
          wrapper.css('top', wrapper.position().top - differenceFromBottomY);

          // Does it fit?
          if ((wrapper.offset().top + menuHeight) > ($(window).height() + $(document).scrollTop())) {
            // No. Bump the menu up higher based on the menu's height and the extra space from the main wrapper.
            wrapper.css('top', ($(window).height() + $(document).scrollTop()) - menuHeight - mainWrapperOffset);
          }

          // Does it fit now?
          if ((wrapper.offset().top - $(document).scrollTop()) < 0) {
            // No. Push the menu down onto the screen from the top of the window edge.
            wrapper.css('top', 0);
            wrapper.css('top', (wrapper.offset().top * -1));
            menuHeight = menu.outerHeight();
          }

          // Do one more check to see if the bottom edge bleeds off the screen.
          // If it does, shrink the menu's Y size and make it scrollable.
          if ((wrapper.offset().top + menuHeight) > ($(window).height() + $(document).scrollTop())) {
            var differenceX = (wrapper.offset().top + menuHeight) - ($(window).height() + $(document).scrollTop());
            menuHeight = menuHeight - differenceX - 32;
            menu.height(menuHeight);
          }
        }

        li.parent().find('.is-submenu-open').removeClass('is-submenu-open');
        li.addClass('is-submenu-open');
      },

      highlight: function(anchor) {
        if (!anchor || !anchor.length) {
          return false;
        }

        var li = anchor.parent();

        li.parent().children('li').removeClass('is-focused');
		// mludwig, put focus only on first
        li.first().addClass('is-focused');
		li.first().find('a').focus();

        //Prevent chrome from scrolling - toolbar
        //anchor.focus();
        li.closest('.header').scrollTop(0);

      },

      // adds/removes checkmarks that are in selectable groups inside the popupmenu
      select: function(anchor) {
        var singleMenu = this.menu.is('.is-selectable'),
          multipleMenu = this.menu.is('.is-multiselectable'),
          singleSection = this.isInSingleSelectSection(anchor),
          multipleSection = this.isInMultiselectSection(anchor),
          parent = anchor.parent(),
          returnObj = [anchor, 'selected'];

        if (!singleMenu && !multipleMenu && !singleSection && !multipleSection) {
          return;
        }

        // If the entire menu is "selectable", place the checkmark where it's supposed to go.
        if (singleMenu || singleSection) {
          parent.prevUntil('.heading, .separator').add(parent.nextUntil('.heading, .separator')).removeClass('is-checked');
          parent.addClass('is-checked');
          return returnObj;
        }

        if (multipleMenu || multipleSection) {
          if (parent.hasClass('is-checked')) {
            returnObj[1] = 'deselected';
            parent.removeClass('is-checked');
            return returnObj;
          }
          parent.addClass('is-checked');
          return returnObj;
        }
      },

      getSelected: function() {
        if (!this.menu.is('.is-selectable, .is-multiselectable')) {
          return $();
        }

        return this.menu.children('.is-checked').children('a');
      },

      isInSelectableSection: function(anchor) {
        var separator = anchor.parent().prevAll().filter('.separator').first();
        return (separator.hasClass('multi-selectable-section') || separator.hasClass('single-selectable-section'));
      },

      isInSingleSelectSection: function(anchor) {
        return anchor.parent().prevAll().filter('.separator').first().hasClass('single-selectable-section');
      },

      isInMultiselectSection: function(anchor) {
        return anchor.parent().prevAll().filter('.separator').first().hasClass('multi-selectable-section');
      },

      detach: function () {
        $(document).off('click.popupmenu touchend.popupmenu keydown.popupmenu');
        $(window).off('scroll.popupmenu resize.popupmenu orientationchange.popupmenu');
        $('.scrollable').off('scroll.popupmenu');

        this.menu.off('click.popupmenu touchend.popupmenu touchcancel.popupmenu');

        if (this.settings.trigger === 'rightClick') {
          this.element.off('click.popupmenu touchend.popupmenu');
        }

        $('iframe').each(function () {
          var frame = $(this);
          try {
            frame.contents().find('body').off('click.popupmenu touchend.popupmenu touchcancel.popupmenu');
          } catch (e) {
            //Ignore security errors on out of iframe
          }
        });
      },

      close: function (isCancelled, noFocus) {
        if (!isCancelled || isCancelled === undefined) {
          isCancelled = false;
        }

        var self = this;
		//mludwig, no longer clearing set width on first item below
        this.menu.removeClass('is-open').attr('aria-hidden', 'true').css({'height': ''});
		if (!Locale.isRTL()) {
			this.menu.parent('.popupmenu-wrapper').css({'left': '-999px', 'height': '', 'width': ''});
		}
        else if (Locale.isRTL()) {
			this.menu.parent('.popupmenu-wrapper').css({'left': '-999px', 'height': '', 'width': ''});
		}
        this.menu.find('.submenu').off('mouseenter mouseleave').removeClass('is-submenu-open');
        this.menu.find('.popupmenu').css({'left': '', 'top': '', 'height': '', 'width': ''});

        this.menu.find('.is-focused').removeClass('is-focused');

        // Close all events
        $(document).off('keydown.popupmenu.' + this.id + ' click.popupmenu.' + this.id + ' mousemove.popupmenu.' + this.id);
        this.menu.off('click.popupmenu touchend.popupmenu touchcancel.popupmenu mouseenter.popupmenu mouseleave.popupmenu');
		if (this.element.hasClass('contextmenu-trigger is-open') || $('.hslist, .hslist2, .hslist3').hasClass('is-open')) {
			$('.hslist, .hslist2, .hslist3').removeClass('is-open');
			$('.hslist, .hslist2, .hslist3').find('li').removeClass('is-focused');
			$('.hslist, .hslist2, .hslist3').css('display', '');
			$('#contextmenu-3').find('li').find('a').attr('data-file','');
		}
        this.element.removeClass('is-open').triggerHandler('close', [isCancelled]);
        this.detach();

        if (this.settings.trigger === 'immediate') {
          this.destroy();
        }

        if (noFocus) {
          return;
        }
        //self.element.removeClass('hide-focus').focus();
      },

      teardown: function() {
        var wrapper = this.menu.parent('.popupmenu-wrapper');

        this.menu.parent().off('contextmenu.popupmenu');
        if (this.element.hasClass('btn-actions')) {
          this.menu.parent().removeClass('bottom').find('.arrow').remove();
        }
        if (this.originalParent) {
          this.menu.detach().appendTo(this.originalParent);
        }
        this.menu.find('.submenu').children('a').each(function(i, item) {
          var text = $(item).find('span').text();
          $(item).find('span, svg').remove();
          $(item).text(text);
        });

        function unwrapPopup(menu) {
          var wrapper = menu.parent();
          if (wrapper.is('.popupmenu-wrapper')) {
            if (wrapper.data('place')) {
              wrapper.data('place').destroy();
            }
            menu.unwrap();
          }
        }

        unwrapPopup(this.menu);
        this.menu.find('.popupmenu').each(function() {
          unwrapPopup($(this));
        });

        $.removeData(this.menu[0], 'trigger');
        wrapper.remove();

        if (this.matchMedia) {
          this.matchMedia.removeListener(this.mediaQueryListener);
        }

        this.detach();
        this.element
          .removeAttr('aria-controls')
          .removeAttr('aria-haspopup')
          .off('touchend.popupmenu touchcancel.popupmenu click.popupmenu keypress.popupmenu contextmenu.popupmenu mousedown.popupmenu');

        return this;
      },

      updated: function() {
        this.teardown().init();
      },

      destroy: function() {
        this.teardown();
        this.menu.trigger('destroy');
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initializing the Control Once or Call Methods.
    return this.each(function() {
      var instance = $.data(this, pluginName);
      /*if (instance) {
        if (typeof instance[options] === 'function') {
          instance[options]();
        }
        instance.settings = $.extend({}, instance.settings, options);
		$.each(instance.settings, function(index, value) {
		});
		$.each(options, function(index, value) {
		});
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new PopupMenu(this, settings));
      }*/
	  instance = $.data(this, pluginName, new PopupMenu(this, settings));
    });
  };

/**
* Progress Indicator Control (Deleted, not used)
*/

/**
* Inline Field Formatter (Mask) Control  (Deleted, not used)
* Adds a text-based formatting "mask" to input fields that displays how data should be entered into the field.
* Does not allow text entry that does not match the provided mask.
*/

/**
* MultiSelect Control (TODO: bitly link to soho xi docs) (Deleted, not used)
*/

/**
* Responsive Messages
* Deps: modal
*/

/**
* Responsive and Accessible MODAL Control
* @name modal
* @param {string} trigger - click, immediate,  manual
*/


  $.fn.modal = function(options) {

    // Settings and Options
    var pluginName = 'modal',
      defaults = {
        trigger: 'click', //Supports click, immediate
        buttons: null,  //Pass in the Buttons
        isAlert: false, //Adds alertdialog role
        content: null, //Ability to pass in dialog html content
        cssClass: null,  //Append a css class to top level
        autoFocus: true,
        id: null,  //Optionally tag a dialog with an id
        frameHeight: 180, //Extra Height
        frameWidth: 46 //Extra Width
      },
      settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Modal(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
      this.reStructure();
    }

    // Actual Plugin Code
    Modal.prototype = {
      init: function() {
        var self = this;

        // Used for tracking events tied to the Window object
        this.id = (parseInt($('.modal').length, 10)+1);
        this.trigger = $('button[data-modal="' + this.element.attr('id') + '"]');  //Find the button with same dialog ID
        this.overlay = $('<div class="overlay"></div>');
        this.oldActive = this.trigger;

        if (this.settings.trigger === 'click') {
          this.trigger.on('click.modal', function() {
            self.open();
          });
        }

        if (this.settings.trigger === 'immediate') {
          setTimeout(function() {
            self.open();
          }, 1);
        }

        self.isCancelled = false;

        //ensure is appended to body for new dom tree
        if (this.settings.content) {

          this.settings.trigger = this.settings.content instanceof jQuery ? this.settings.trigger : 'immediate';
          this.appendContent();
          setTimeout(function () {
            self.open();
          }, 1);
          return;
        }

        self.addButtons(this.settings.buttons);
        this.element.appendTo('body');
        this.element.css({'display':'none'});
      },

      appendContent: function () {
        var isAppended = false;

        this.element = $(
          '<div class="modal">' +
            '<div class="modal-content">'+
              '<div class="modal-header"><h1 class="modal-title">'+ this.settings.title +'</h1></div>' +
              '<div class="modal-body-wrapper">'+
                '<div class="modal-body"></div>'+
              '</div>'+
            '</div>'+
          '</div>');

        if (this.settings.id) {
          this.element.attr('id', this.settings.id);
        }

        if ($(this.settings.content).is('.modal')) {
          this.element = $(this.settings.content);
        } else if (this.settings.content && this.settings.content.length > 0) {

          if (this.settings.content instanceof jQuery && this.settings.content.parent().is('.modal-body')) {
            isAppended = true;
            this.element = this.settings.content.closest('.modal');
          } else {
            this.element.find('.modal-body').append(this.settings.content);
          }

          if (this.settings.content instanceof jQuery){
            this.settings.content.show();
          }
        }

        if (!isAppended) {
          this.element.appendTo('body');
        }

        if (this.settings.cssClass) {
          this.element.addClass(this.settings.cssClass);
        }

        if (this.settings.title) {
          this.element.find('.modal-title').text(this.settings.title);
        }

        if (!isAppended) {
          this.addButtons(this.settings.buttons);
        }
      },

      reStructure: function() {
        var body = $('.modal-body', this.element),
          hr = $('hr:first-child', body),
          buttonset = $('.modal-buttonset', this.element);

        if (body && body.length && !body.parent().hasClass('modal-body-wrapper')) {
          body.wrap('<div class="modal-body-wrapper"></div>');
        }
        if (hr && hr.length && !hr.parent().hasClass('modal-content')) {
          hr.insertAfter(this.element.find('.modal-header'));
        }
        if (buttonset && buttonset.length && !buttonset.parent().hasClass('modal-content')) {
          buttonset.insertAfter(this.element.find('.modal-body-wrapper'));
        }

      },

      disableSubmit: function () {
        var body = this.element,
          fields = body.find('[data-validate]'),
          inlineBtns = body.find('.modal-buttonset button');

        if (fields.length > 0) {
          var allValid = true;
          fields.each(function () {

            var field = $(this);
            if (field.closest('.datagrid-filter-wrapper').length > 0) {
              return;
            }

            if (!field.val()) {
              allValid = false;
            }

            if (allValid) {
              inlineBtns.filter('.btn-modal-primary').not('.no-validation').removeAttr('disabled');
            }
          });

          if (!allValid && !inlineBtns.filter('.btn-modal-primary').is(':disabled')) {
             inlineBtns.filter('.btn-modal-primary').not('.no-validation').attr('disabled', 'true');
          }
        }

      },

      addButtons: function(buttons) {
        var self = this,
          body = this.element.find('.modal-body'),
          bodywrapper = body.parent(),
          btnWidth = 100,
          isPanel = false,
          buttonset;

        this.modalButtons = buttons;

        if (!buttons) {
          var inlineBtns = this.element.find('.modal-buttonset button');
          // Buttons in markup
          btnWidth = 100/inlineBtns.length;
          inlineBtns.css('width', btnWidth + '%').button();
          inlineBtns.not('[data-ng-click], [ng-click], [onclick], :submit').on('click.modal', function (e) {
            if ($(e.target).is('.btn-cancel')) {
              self.isCancelled = true;
            }
            self.close();
          });
          return;
        }

        if (this.element.is('.contextual-action-panel')) {
          isPanel = true;
          // construct the toolbar markup if a toolbar isn't found
          buttonset = this.element.find('.buttonset');
          if (!buttonset.length) {
            var toolbar = this.element.find('.toolbar');
            if (!toolbar.length) {
              $('<div class="toolbar"></div>').appendTo(this.element.find('.modal-header'));
            }
            buttonset = $('<div class="buttonset"></div>').appendTo(this.element.find('.toolbar'));
          }
        } else {
          buttonset = this.element.find('.modal-buttonset');
          if (!buttonset.length) {
            buttonset = $('<div class="modal-buttonset"></div>').insertAfter(bodywrapper);
          }
        }

        btnWidth = 100/buttons.length;

        if (buttons) {
          buttonset.empty();
        }

        $.each(buttons, function (name, props) {
          var btn = $('<button type="button"></button>');
          btn.text(props.text);

          if (props.cssClass === 'separator') {
            btn = $('<div class="separator"></div>');
          }

          if (props.cssClass) {
            btn.attr('class', props.cssClass);
          } else {
            if (props.isDefault) {
              btn.addClass('btn-modal-primary');
            } else {
              btn.addClass('btn-modal');
            }
          }

          if (props.validate !== undefined && !props.validate) {
            btn.addClass('no-validation');
          }

          var attrs = {},
            attrTypes = ['id', 'name', 'text'];

          for (var i = 0; i < attrTypes.length; i++) {
            if (props[attrTypes[i]]) {
              attrs[attrTypes[i]] = props[attrTypes[i]];
            }
          }

          if (props.type === 'input') {
            var label = $('<label class="audible" for="filter">' + props.text + '</label>'),
              input = $('<input class="searchfield">').attr(attrs);
            buttonset.append(label, input);
            return;
          }

          if (props.icon && props.icon.charAt(0) === '#') {
            btn.text('<span>' + btn.text() + '</span>');
            $.createIconElement({
              classes: [props.icon === '#icon-close' ? 'icon-close' : ''],
              icon: props.icon.substr('#icon-'.length)
            }).prependTo(btn);
          }

          if (props.id) {
            btn.attr('id', props.id);
          }

          btn.on('click.modal', function(e) {
            if (props.click) {
              props.click.apply(self.element[0], [e, self]);
              return;
            }
            self.close();
          });

          if (!isPanel) {
            btn.css('width', btnWidth + '%');
          }

          btn.button();
          buttonset.append(btn);

        });

      },

      sizeInner: function () {
        var messageArea;
        messageArea = this.element.find('.detailed-message');
        //Set a max width
        var h = $(window).height() - messageArea.offset().top - 150;
        messageArea.css({'max-height': h, 'overflow': 'auto', 'width': messageArea.width()});
      },

      open: function () {
        var self = this, messageArea,
          elemCanOpen = true;

        if (!this.trigger || this.trigger.length ===0) {
          this.oldActive = $(':focus');  //Save and restore focus for A11Y
        }

        this.element.after(this.overlay);
        if (this.element && !this.element.parent().hasClass('modal-wrapper')) {
          this.element.wrap('<div class="modal-page-container"><div class="modal-wrapper"></div>');
        }
        this.root = this.element.closest('.modal-page-container');

        messageArea = self.element.find('.detailed-message');
        if (messageArea.length === 1) {
          $(window).on('resize.modal-' + this.id, function () {
            self.sizeInner();
          });
          self.sizeInner();
        }

        elemCanOpen = this.element.triggerHandler('beforeopen');
        self.isCancelled = false;

        if (elemCanOpen === false) {
          self.overlay.remove();
          self.root.css({'display':'none'});
          return false;
        }

        //Look for other nested dialogs and adjust the zindex.
        $('.modal').each(function (i) {
          var modal = $(this);
		  //mludwig, bumping zindex by 2 for test
          modal.css('z-index', (1022 + (i + 1)).toString());

          if (modal.data('modal') && modal.data('modal').overlay) {
            modal.data('modal').overlay.css('z-index', (1020 + i).toString());
          }
        });

        $('body > *').not(this.element).not('.modal, .overlay, .modal-page-container').attr('aria-hidden', 'true');

        // Ensure aria-labelled by points to the id
        if (this.settings.isAlert) {
          this.element.attr('aria-labeledby', 'message-title');
          this.element.attr('aria-describedby', 'message-text');
        } else {
          var h1 = this.element.find('h1:first'),
            id = h1.attr('id');

          if (!id) {
            id = (this.element.attr('id') ? this.element.attr('id') : 'h1')  + '-title';
            h1.attr('id', id);
          }

          var body = this.element.find('.modal-body'),
            descById = (this.element.attr('id') ? this.element.attr('id') : 'message') + '-text';

          this.element.attr('aria-labeledby', id);

          //Contextual Action Panel Case - Has a toolbar
          if (this.element.find('.toolbar .title').length) {
            this.element.find('.toolbar .title').attr('id', descById);
            this.element.attr('aria-describedby', descById);
          } else {
            body.attr('id', descById);
            this.element.attr('aria-describedby', descById);
          }

        }

        this.mainContent = $('body').children('.scrollable-container');
        if (!this.mainContent.length) {
          this.mainContent = $('body');
        }

        this.removeNoScroll = !this.mainContent.hasClass('no-scroll');
        this.mainContent.addClass('no-scroll');

        $(window).on('resize.modal-' + this.id, function() {
          self.resize();
        });

        //Center
        this.root.css({'display': ''});
        this.element.css({'display': ''});

        setTimeout(function() {
          self.resize();
          self.element.addClass('is-visible').attr('role', (self.settings.isAlert ? 'alertdialog' : 'dialog'));
          self.root.attr('aria-hidden', 'false');
          self.overlay.attr('aria-hidden', 'true');
          self.element.attr('aria-modal', 'true'); //This is a forward thinking approach, since aria-modal isn't actually supported by browsers or ATs yet
        }, 1);

        // Add the 'modal-engaged' class after all the HTML markup and CSS classes have a chance to be established
        // (Fixes an issue in non-V8 browsers (FF, IE) where animation doesn't work correctly).
        // http://stackoverflow.com/questions/12088819/css-transitions-on-new-elements
        $('body').addClass('modal-engaged');

        //Handle Default button.
        $(this.element).on('keypress.modal', function (e) {
          var target = $(e.target);

          if (target.is('.searchfield') || target.is('textarea') || target.is(':button') || target.is('.dropdown') || target.closest('.tab-list').length) {
            return;
          }

          if (e.which === 13 && self.isOnTop() && !target.closest('form').find(':submit').length) {
            e.stopPropagation();
            e.preventDefault();
            self.element.find('.btn-modal-primary:enabled').trigger('click');
          }
        });

        // Override this page's skip-link default functionality to instead focus the top
        // of this element if it's clicked.
        $('.skip-link').on('focus.modal', function(e) {
          e.preventDefault();
          self.getTabbableElements().first.focus();
        });

        function focusElement() {
          var focusElem = self.element.find(':focusable').not('.modal-header .searchfield').first();
          self.keepFocus();
          self.element.trigger('open', [self]);

          if (focusElem.length === 0) {
            focusElem = self.element.find('.btn-modal-primary');
          }

          if (focusElem.length === 1 && focusElem.is('.btn-modal')) {
            focusElem = self.element.find('.btn-modal-primary');
          }

          if (focusElem.length === 1 && focusElem.is('button') && !focusElem.is(':disabled')) {
            focusElem.addClass('hide-focus');
          }

          if (!self.settings.autoFocus) {
            return;
          }

          // If the selected element is a tab, actually make sure it's the "selected" tab.
          var selected, tabParent;
          if (focusElem.is('.tab:not(.is-selected) a')) {
            tabParent = focusElem.closest('.tab-container');
            selected = tabParent.find('.is-selected');
            if (selected.length) {
              focusElem = selected;
              tabParent.data('tabs').select(selected.children('a').attr('href'));
              return;
            }
          }

          // Otherwise, just focus
          focusElem.focus();

        }

        var pagerElem = self.element.find('.paginated');
        pagerElem.on('afterpaging', function () {
          self.resize();
        });

        setTimeout(function () {
          self.disableSubmit();
        }, 10);

        var fields = this.element.find('[data-validate]');
        fields.removeClass('disable-validation');

        setTimeout(function () {
          focusElement();
        }, 200);

        setTimeout(function () {
          self.element.trigger('afteropen');
        }, 300);

      },

      resize: function() {
        var calcHeight = ($(window).height()* 0.9)-this.settings.frameHeight, //90% -(180 :extra elements-height)
          //calcWidth = ($(window).width()* 0.9)-this.settings.frameWidth; change by mludwig
		  calcWidth = ($(window).width()* 0.9);

        this.element.find('.modal-body-wrapper').css({'max-height': calcHeight, 'max-width': calcWidth});
      },

      isOpen: function() {
        return this.element.is('.is-visible');
      },

      isOnTop: function () {
        var max = 0,
          dialog = this.element;

        $('.modal.is-visible').each(function () {
          if (max < $(this).css('z-index')) {
            max = $(this).css('z-index');
          }
        });

        return max === dialog.css('z-index');
      },

      getTabbableElements: function() {
        var allTabbableElements = $(this.element).find('a[href], area[href], input:not([disabled]),' +
          'select:not([disabled]), textarea:not([disabled]),' +
          'button:not([disabled]), iframe, object, embed, *[tabindex],' +
          '*[contenteditable]').filter(':visible');
        return {
          first: allTabbableElements[0],
          last: allTabbableElements[allTabbableElements.length - 1]
        };
      },

      keepFocus: function() {
        var self = this, tabbableElements;

          $(self.element).on('keypress.modal keydown.modal', function (e) {
            var keyCode = e.which || e.keyCode;

            if (keyCode === 27) {
              setTimeout(function () {
                self.close();
              }, 0);
            }

            if (keyCode === 9) {
              tabbableElements = self.getTabbableElements();

              // Move focus to first element that can be tabbed if Shift isn't used
              if (e.target === tabbableElements.last && !e.shiftKey) {
                e.preventDefault();
                tabbableElements.first.focus();
              } else if (e.target === tabbableElements.first && e.shiftKey) {
                e.preventDefault();
                tabbableElements.last.focus();
              }

              self.element.find('#message-title').removeAttr('tabindex');
            }

          });
      },

      close: function (destroy) {
        if (!this.isOpen()) {
          return true;
        }

        var elemCanClose = this.element.triggerHandler('beforeclose'),
          self = this,
          fields = this.element.find('[data-validate]');

        this.root = this.element.closest('.modal-page-container');
        fields.addClass('disable-validation');

        if (elemCanClose === false) {
          return false;
        }

        if (this.mainContent && this.removeNoScroll) {
          this.mainContent.removeClass('no-scroll');
        }
        $(window).off('resize.modal-' + this.id);

        this.element.off('keypress.modal keydown.modal');
        this.element.removeClass('is-visible');

        this.overlay.attr('aria-hidden', 'true');
        if (this.root) {
          this.root.attr('aria-hidden', 'true');
        }

        if ($('.modal-page-container[aria-hidden="false"]').length < 1) {
          $('body').removeClass('modal-engaged');
          $('body > *').not(this.element.closest('.modal-page-container')).removeAttr('aria-hidden');
          $('.overlay').remove();
        }

        //Fire Events
        self.element.trigger('close', self.isCancelled);

        if (this.oldActive && $(this.oldActive).is('button:visible')) {
          this.oldActive.focus();
          this.oldActive = null;
        } else if (this.trigger.parents('.toolbar, .formatter-toolbar').length < 1) {
          this.trigger.focus();
        }

        //close tooltips
        $('#validation-errors, #tooltip, #validation-tooltip').addClass('is-hidden');

        // remove the event that changed this page's skip-link functionality in the open event.
        $('.skip-link').off('focus.modal');

        setTimeout( function() {
          self.overlay.remove();
          self.root.css({'display':'none'});
          self.element.trigger('afterclose');

          if (self.settings.trigger === 'immediate' || destroy) {
            self.destroy();
          }
        }, 300); // should match the length of time needed for the overlay to fade out
      },

      // NOTE: Destroy method needs to function as a callback because it's
      destroy: function() {
        var self = this,
          canDestroy = this.element.trigger('beforedestroy');

        if (!canDestroy) {
          return;
        }

        function destroyCallback() {
          if (self.modalButtons) {
            self.element.find('button').off('click.modal');
          }

          if (self.element.find('.detailed-message').length === 1) {
            $(window).off('resize.modal-' + this.id);
          }

          if (self.settings.trigger === 'click') {
            self.trigger.off('click.modal');
          }

          self.element.closest('.modal-page-container').remove();
          $.removeData(self.element[0], 'modal');
        }

        if (!this.isOpen()) {
          destroyCallback();
          return;
        }

        this.element.one('afterclose.modal', function() {
          destroyCallback();
        });

        this.close(true);
      }
    };

    // Support Chaining and Init the Control or Set Settings
    return this.each(function() {
      var instance = $.data(this, pluginName),
        elem = $(this);

      if (!elem.is('.modal')) {
        instance = elem.closest('.modal').data(pluginName);
      }

      if (instance) {
        if (typeof instance[options] === 'function') {
          instance[options]();
        }
        instance.settings = $.extend({}, instance.settings, options);

        if (settings.trigger === 'immediate') {
          instance.open();
        }
        return;
      }

      instance = $.data(this, pluginName, new Modal(this, settings));
    });
  };

/**
* Modal Search Control (TODO: bitly link to soho xi docs) (Deleted, not used)
* Used Mostly for the Site, but could be used elsewhere with some modifications
*/

/**
* Rating Control (Deleted, not used)
*/

/**
* Resizable Control (TODO: bitly link to docs)
*/


  $.fn.resize = function(options) {
    'use strict';

    // Settings and Options
    var pluginName = 'resize',
        defaults = {
          axis: 'x'
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Plugin(element) {
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Plugin.prototype = {

      init: function() {
        //Original Prototype http://jsfiddle.net/41h9pcpb/2/
        this.handleEvents();
      },

      // Handle Touch/Mouse Resize
      handleEvents: function() {
        var self = this;
        self.handle = null;
//mludwig, hiding below because drag function (which is probably from d3.js, isn't being found after use of requireJS
       // this.element.find('.resize-handle').drag({axis: settings.axis}).on('drag.resziable', function (e, args) {
       //   self.element.width(args.left);
       // });
      },

      // Teardown
      destroy: function() {
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, defaults, options);
        instance.show();
      } else {
        instance = $.data(this, pluginName, new Plugin(this, settings));
      }
    });
  };

/**
* SEARCHFIELD Control (TODO: bitly link to soho xi docs)
*/

  $.fn.searchfield = function(options) {
    'use strict';
    // Settings and Options
    var pluginName = 'searchfield',
        defaults = {
          allResultsCallback: undefined,
          showAllResults: true,
          categories: undefined, // If defined as an array, displays a dropdown containing categories that can be used to filter results.
          categoryMultiselect: false, // If true, creates a multiselectable Categories list
          showCategoryText: false, // If true, will show any available categories that are selected to the left of the Dropdown field.
          source: undefined,
          template: undefined, // Template that can be passed
          clearable: true //Has an X to clear
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function SearchField(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    SearchField.prototype = {

      init: function() {
        this.build().setupEvents();
      },

      build: function() {
        var self = this;

        this.optionsParseBoolean();
        this.label = this.element.prev('label, .label');

        // Invoke Autocomplete and store references to that and the popupmenu created by autocomplete.
        // Autocomplete settings are fed the same settings as Searchfield
        if (this.settings.source || this.element.attr('data-autocomplete')) {
          this.element.autocomplete(this.settings);
        }
        this.autocomplete = this.element.data('autocomplete');

        //Prevent browser typahead
        this.element.attr('autocomplete','off');
		
		//Add placeholder text
		var searchtext1 = Locale.translate('Search');
		//var searchtext2 = Locale.translate('SearchHelpLib');
		//var searchtext3 = Locale.translate('SearchHelpSys');
		var searchtext2 = Locale.translate('SearchAll');
		var searchtext3 = Locale.translate('SearchCurrent');
		if (this.element.attr('id') == "textToSearch" && varstore.isCollection == false) {
			this.element.attr('placeholder',searchtext1);
		}
		else if (varstore.isCollection) {
			$('#textToSearch').attr('placeholder',searchtext2);
			$('#textToSearchHS').attr('placeholder',searchtext3);
		}
		

        this.wrapper = this.element.parent('.searchfield-wrapper');
        if (!this.wrapper || !this.wrapper.length) {
            this.wrapper = this.element.wrap('<span class="searchfield-wrapper"></span>').parent();

          var customClasses = ['context', 'alternate'],
            c;
          for (var i = 0; i < customClasses.length; i++) {
            if (this.element.hasClass(customClasses[i])) {
              c = customClasses[i];
              this.wrapper.addClass(c);
              this.element.removeClass(c);
            }
          }
        }

        // Add Icon
        var icon = this.wrapper.find('.icon:not(.icon-dropdown)');
        if (!icon || !icon.length) {
          icon = $.createIconElement('search').insertAfter(this.element).icon();
		}
		icon.addClass("search");
		
		//wrap search svg in button
		icon.wrap("<button type='button' class='btn-icon searchfield-button' accesskey='S' title='" + Locale.translate('Search') + "'></button>");
		// Change icon to a trigger button if we're dealing with categories
        if (varstore.isCollection) {
			var inputHS = $('#textToSearchHS');
            var iconHS = this.wrapper.find('.icon.dropdown');
			if (!iconHS || !iconHS.length) {
			  iconHS = $.createIconElement('dropdown').insertAfter(inputHS).icon();			  
			  iconHS.addClass("dropdown");
			}
			inputHS.insertAfter('.searchfield-button');
			iconHS.insertAfter(inputHS);
			iconHS.wrap("<button type='button' class='btn-icon btn-menu searchselect-button' tabindex='-1' title='" + Locale.translate('SearchSelect') + "' role='menu'></button>");
			// to replace English literal string above, Locale.translate('SearchSelect')
			var buttonSelect = $('.searchselect-button');
			
			this.list = $('.buttonset.search ul.popupmenu');
			if (!this.list || !this.list.length) {
				this.list = $('<ul class="popupmenu"></ul>');
			}
			 this.list.insertAfter(buttonSelect);
			// Handle Single vs Multi-Selectable Lists
			/*var categoryListType = this.settings.categoryMultiselect ? 'is-multiselectable' : 'is-selectable';
			this.list.addClass(categoryListType);
			var removeListType = 'is-selectable';
			if (!this.settings.categoryMultiselect) {
				removeListType = 'is-multiselectable';
			}
			this.list.removeClass(removeListType);

			this.list.empty();*/

			var val1 = Locale.translate('SearchAll');
			var val2 = Locale.translate('SearchCurrent');
			this.list.append('<li><a id="showsearch" href="#">' + val1 + '</a></li>'); 
			this.list.append('<li><a id="showsearchHS" href="#">' + val2 + '</a></li>');
			$("#showsearch").click(function(e) {
				$('#textToSearchHS').val('');
				self.handleMenuClick(e);
			});
			$("#showsearchHS").click(function(e) {
				$('#textToSearch').val('');
				self.handleMenuClick(e);
			});
			//this.settings.categories.forEach(function(val) {
			//	self.list.append('<li><a href="#">' + val + '</a></li>'); 
			//  });
			
			//this.list.insertAfter(iconHS);
			  buttonSelect.popupmenu({
				menu: this.list,
				offset: {
				  y: 10
				}
			  });
		}
        

        // Swap icon position to in-front if we have an "alternate" class.
        if (this.wrapper.hasClass('context') || this.wrapper.hasClass('has-categories') ) {
          icon.insertBefore(this.element);
        }

        if (this.settings.clearable) {
          this.element.clearable();
		  $('#textToSearchHS').clearable();
        }
		// set focus on search button so keyboard users can start right away with search
		$('.searchfield-button').focus();

        return this;
      },

      // Set boolean value if strings
      optionsParseBoolean: function() {
        var i, l,
          arr = [
            'showAllResults',
            'categoryMultiselect',
            'showCategoryText',
            'clearable'
          ];
        for (i=0,l=arr.length; i<l; i++) {
          this.settings[arr[i]] = this.parseBoolean(this.settings[arr[i]]);
        }
      },

      hasCategories: function() {
        return this.settings.categories && $.isArray(this.settings.categories) && this.settings.categories.length > 0;
      },

      setupEvents: function() {
        var self = this;
		//switching to use of texttosearch instead of this.element
         $('#textToSearch').on('updated.searchfield', function() {
          self.updated();
        }).on('focus.searchfield', function(e) {
          self.handleFocus(e);
        }).on('blur.searchfield', function(e) {
          self.handleBlur(e);
        }).onTouchClick('searchfield', '.searchfield')
        .on('click.searchfield', function(e) {
          self.handleClick(e);
        }).on('keydown.searchfield', function(e) {
			e.stopPropagation();
          self.handleKeydown(e);
        });
		
		// changed from this.wrapper to self.element to limit mouseover area, mludwig
        self.element.on('mouseover.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseover(e);
        }).on('mouseleave.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseleave(e);
        });
		
		// mludwig, adding for #textToSearchHS, since that element doesn't get done by .searchfield init 
        $('#textToSearchHS').on('updated.searchfield', function() {
          self.updated();
        }).on('focus.searchfield', function(e) {
          self.handleFocus(e);
        }).on('blur.searchfield', function(e) {
          self.handleBlur(e);
        }).onTouchClick('searchfield', '.searchfield')
        .on('click.searchfield', function(e) {
          self.handleClick(e);
        }).on('keydown.searchfield', function(e) {
          self.handleKeydown(e);
        }).on('mouseover.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseover(e);
        }).on('mouseleave.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseleave(e);
        });
		
		// changed from this.wrapper to self.element to limit mouseover area, mludwig
        self.element.on('mouseover.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseover(e);
        }).on('mouseleave.searchfield', function(e) {
			e.stopPropagation();
			self.handleMouseleave(e);
        });		
		
		// mludwig, adding for searchfield button itself
		$('.searchfield-button').on('click.searchfield', function(e) {
			var booktitle = $(".booktitle",window.document).first().attr("data-id");
			if (varstore.isCollection && booktitle !== "" && booktitle !== undefined && booktitle !== null && $('#textToSearchHS').val() == "" && $('#textToSearch').val() == "") {
				$('.searchselect-button').trigger('mousedown.popupmenu');
			}
			else {
				self.handleClick(e);
			}			
		});
				
		$('svg.icon.search').onTouchClick('searchfield', 'svg.icon.search')
        .on('click.searchfield', function(e) {
          self.handleClick(e);
		});
		// Next sections are for resetting things if user touches outside original touch area, mludwig	
		/*$('div.YConsole_left_pan.YConsole_left_pan__dock_left').on('touchstart', function (e) {
			console.log("touchstart yconcole");
			$('.YConsole_left_pan').click();
			
		});*/

		// Set up iframe for search-related events, mludwig PUT COPY OF THIS IN SEARCH.JS or in search field area, MAYBE REMOVE FROM HERE
		$("#landing").on('load', function(evt) {
			$("#landing").contents().on("touchstart.searchfield mousedown.searchfield click.searchfield", function(e) {
				var target = $(e.target);				
				var touchenabled = ("ontouchstart" in window || window.DocumentTouch && document instanceof DocumentTouch || (navigator.msMaxTouchPoints > 0));
				if  (!touchenabled && e.type == "click") {
					if (!target.attr('datafile')) {
						$('#textToSearch').val('');
					  // if (!(target.hasClass('wh_main_page')) && !(target.hasClass('wh_topic_page'))){
						//	$('#textToSearch').val('');
					  // }	
					   if (varstore.isCollection){
						  $('#textToSearchHS').val('');
						   //if (!(target.hasClass('wh_main_page')) && !(target.hasClass('wh_topic_page'))){
							//  $('#textToSearchHS').val(''); 
						  //}
						}
					}           					
				}
				if (touchenabled && ((e.type == "mousedown" || e.type == "touchstart") && !target.is('INPUT') && !target.is('svg'))) {
					if ($('svg.icon.close').first().hasClass('is-empty')){
						inforhelp.hidesearch();	
						$('#textToSearch').val('');				
					}
					// delete following,  no longer applies??
					if ($('svg.icon.close').eq(1).hasClass('is-empty') && isCollection){
						inforhelp.hidesearchHS();
						$('#textToSearchHS').val('');
					}
				}
			});
			$('#landing',window.document).contents().find('.foundResult').on('focus', function(evt) {
				e.preventDefault();
			});
		});

        // Override the 'click' listener created by Autocomplete (which overrides the default Popupmenu method)
        // to act differntly when the More Results link is activated.
        this.element.on('listopen.searchfield', function(e, items) {
          var list = $('#autocomplete-list');

          list.off('click').on('click.autocomplete', 'a', function (e) {
            var a = $(e.currentTarget),
              ret = a.text().trim(),
              isMoreLink = a.hasClass('more-results'),
              isNoneLink = a.hasClass('no-results');

            if (!isMoreLink && !isNoneLink) {
              // Only write text into the field on a regular result pick.
              self.element.attr('aria-activedescendant', a.parent().attr('id'));
            }

            if (isMoreLink) {
              // Trigger callback if one is defined
              var callback = self.settings.allResultsCallback;
              if (callback && typeof callback === 'function') {
                callback(ret);
              }
            }

            if (a.parent().attr('data-value')) {
              for (var i = 0; i < items.length; i++) {
                if (items[i].value.toString() === a.parent().attr('data-value')) {
                  ret = items[i];
                }
              }
            }

            self.element.trigger('selected', [a, ret]);
            self.element.data('popupmenu').close();
            e.preventDefault();
            return false;
          });

          // Override the focus event created by the Autocomplete control to make the more link
          // and no-results link blank out the text inside the input.
          list.find('.more-results, .no-results').off('focus').on('focus.searchfield', function () {
            var anchor = $(this);
            list.find('li').removeClass('is-selected');
            anchor.parent('li').addClass('is-selected');
            self.element.val('');
          });

        });

        return this;
      },

      recalculateParent: function() {
        var toolbar = this.element.closest('.toolbar');
        if (toolbar.length) {
          // Setup a timed event that will send a signal to a parent toolbar, telling it to recalculate which buttons are visible.
          // Needs to be done after a CSS animation on the searchfield finishes.
          // TODO: Bolster this to work with CSS TransitonEnd
          setTimeout(function() {
            toolbar.triggerHandler('recalculateButtons');
          }, 300);
        }
      },

      // Activates a toolbar-based searchfield and keeps it "open".  Instead of closing it on blur, sets up
      // an explicit, out-of-bounds click/tap that will serve to close it when the user acts.
      setAsActive: function() {
        if (this.element.hasClass('active')) {
          return;
        }

        var self = this;

        // Activate
        this.element.addClass('active');
        var toolbar = this.element.closest('.toolbar, [class$="-toolbar"]');
        if (toolbar.length) {
          toolbar.addClass('searchfield-active');
        }

        // if Toolbar Searchfield, allow that control to handle adding this class
        if (!this.wrapper.is('.toolbar-searchfield-wrapper')) {
          this.wrapper.addClass('has-focus');
        }

        setTimeout(function() {
			function deactivate() {
              self.element.removeClass('active').blur();
              toolbar.removeClass('searchfield-active');
              $(document).offTouchClick('searchfield').off('click.searchfield');
            }

         // $(document).onTouchClick('searchfield', '.searchfield').on('click.searchfield', function(e) {
         //   var target = $(e.target);
         //   if (target[0] !== self.element[0] && target[0] !== self.element.parent('.searchfield-wrapper')[0]) {
              //deactivate();
         //   }
        //  });
         self.element.one('blur.searchfield', function() {
            //deactivate();
          });
      }, 100);
        //this.recalculateParent();
      },

		// alternative setAsActive for use of texttosearchHS input
	 setAsActiveHS: function() {
		 // mludwig, not sure if this function is actually doing anything
		 // because I'm setting it to active  before getting here
        if ($('#textToSearchHS').hasClass('active')) {
          return;
        }

        var self = this;

        // Activate
        $('#textToSearchHS').addClass('active');
        var toolbar = $('#textToSearchHS').closest('.toolbar, [class$="-toolbar"]');
        if (toolbar.length) {
          toolbar.addClass('searchfield-active');
        }

        // if Toolbar Searchfield, allow that control to handle adding this class
        if (!this.wrapper.is('.toolbar-searchfield-wrapper')) {
          this.wrapper.addClass('has-focus');
        }

     //   setTimeout(function() {
        //  function deactivate() {
            //self.element.removeClass('active').blur();
            //toolbar.removeClass('searchfield-active');
        //    $(document).offTouchClick('searchfield').off('click.searchfield');
        //  }

         // $(document).onTouchClick('searchfield', '.searchfield').on('click.searchfield', function(e) {
         //   var target = $(e.target);
         //   if (target[0] !== self.element[0] && target[0] !== self.element.parent('.searchfield-wrapper')[0]) {
              //deactivate();
         //   }
        //  });
        // self.element.one('blur.searchfield', function() {
            //deactivate();
          //});
      //}, 100);
      },
	  
      handleFocus: function(e) {
		  if($(e.target).attr('id') == "textToSearch") {
				var keyCode = e.which || e.keyCode;
				if (keyCode === 9 ) {
					//inforhelp.hidesearch();
				}
				else {
					this.setAsActive();				
				}
		  }  
		  if($(e.target).attr('id') == "textToSearchHS") {
				var keyCode = e.which || e.keyCode;
				if (keyCode === 9 ) {
					//inforhelp.hidesearchHS();
				}
				else {
					this.setAsActiveHS();				
				}
		  } 		  
      },

      handleBlur: function(e) {
        var self = this;
        //this.recalculateParent();
       if (this.wrapper.is('.searchfield-wrapper')) {
			setTimeout(function() {
				//$(window).focus(); this goofs up IE11, don't seem to need since focus needs to be on search box
				self.wrapper.removeClass('has-focus');
			}, 10);
        }
      },

      handleClick: function(e) {
        //this.setAsActive();
		var searchinput = $('#textToSearch').val();
		var searchinputHS = $('#textToSearchHS').val();
		var target = $(e.target);
		var searchicon = $('svg.icon.search').first();
		var searchbutton = $('button.searchfield-button');
		var bookroot = $(".booktitle",window.document).first().attr("data-id");
		if (this.element.hasClass('searchfield') && (target.is(searchicon) || target.is(searchbutton))) {
			if ((!searchinput || !searchinput.length) && (!searchinputHS || !searchinputHS.length) && !($('#textToSearch').is($(document.activeElement))) && !($('#textToSearchHS').is($(document.activeElement)))){
				if (varstore.isCollection && bookroot !== "" && bookroot !== undefined) {
					$('.searchselect-button').trigger('mousedown.popupmenu');
				}
				else {
					require(["inforhelp"], function () {
						//search is already visible, but this should move focus there
						inforhelp.showsearch();
					});
					
				}				
			}			
			else if ((!searchinput || !searchinput.length) && $('#textToSearch').is($(document.activeElement))){
				return;
			}
			else if ((!searchinputHS || !searchinputHS.length) && $('#textToSearchHS').is($(document.activeElement))){
				return;
			}			
			else if (searchinput && target.is(searchbutton)){
				//require(["inforhelp"], function () {
						inforhelp.goSearch(searchinput, "");
				//});
				
				if (searchinputHS) {
					$('#textToSearchHS').val('');
					//inforhelp.hidesearchHS();
				}
			}
			else if (searchinputHS && target.is(searchbutton)) {
				var filter = "";
				if ($(".booktitle").first().attr('data-id')) {
					filter = $(".booktitle").first().attr("data-id");
				}
				// Maybe not do search if filter is empty???, might have value left over
				// even though user trying to do Search All (should have been cleared above
				inforhelp.goSearch($('#textToSearchHS').val(), filter);
				if (searchinput) {
					// clear this earlier??
					$('#textToSearch').val('');
					//hidesearch();
				}
			}
		}		
      },

      handleMenuClick: function(e) {
        //this.setAsActive();
		var searchinput = $('#textToSearch').val();
		var searchinputHS = $('#textToSearchHS').val();
		var target = $(e.target);
		var searchicon = $('svg.icon.search').first();
		var searchbutton = $('button.searchfield-button');
		var menusearchall = false;
		var menusearchHS = false;
		if (target.attr("id") == "showsearch") {
			menusearchall = true;
		}
		if (target.attr("id") == "showsearchHS") {
			menusearchHS = true;
		}
		var bookroot = $(".booktitle",window.document).first().attr("data-id");
		if (this.element.hasClass('searchfield') && (menusearchall || menusearchHS)) {
			if (menusearchall) {
				if ($('#textToSearchHS').val() !== undefined && searchinputHS !== "" ) {
					$('#textToSearch').val(searchinputHS);
					$('#textToSearchHS').val('');
				}
				inforhelp.hidesearchHS();
				//$('button.searchselect-button').blur();
				inforhelp.showsearch();
				this.setAsActive();
			}
			else if (menusearchHS) {
				if ($('#textToSearch').val() !== undefined && searchinput !== "" ) {
					$('#textToSearchHS').val(searchinput);
					$('#textToSearch').val('');
				}
				inforhelp.hidesearch();
				inforhelp.showsearchHS();
				this.setAsActiveHS();
			}
		}		
      },
	  
     handleTouchstart: function() {
		 // NEED TO ADD CODE FOR COLLECTION HS SEARCH
        this.setAsActive();
		var filter = "";
		var input = "";
		if ($("#textToSearch").is(":focus")) {
			input = $('#textToSearch').val();
		}
		if ($("#textToSearchHS").is(":focus")) {
			input = $('#textToSearchHS').val();
			if ($(".booktitle").first().attr('data-id')) {
				filter = $(".booktitle").first().attr("data-id");
			}
		}
		if (!input || !input.length || !$('#textToSearch').is(':focus')){
			inforhelp.showsearch();
		}
		if (input && ($('#textToSearch').is(':focus') || $('#textToSearchHS').is(':focus'))){
			inforhelp.goSearch(input, filter);
		}
      },

      handleKeydown: function(e) {
        var key = e.which;
        if (key === 27) {
          this.clear();
        }
		// mludwig
		if (key === 13) {
			var filter = "";
			var input = "";
			if ($("#textToSearch").is(":focus")) {
				input = document.getElementById('textToSearch').value;
				document.getElementById('textToSearch').blur();
			}
			if ($("#textToSearchHS").is(":focus")) {
				input = document.getElementById('textToSearchHS').value;
				if ($(".booktitle").first().attr('data-id')) {
					filter = $(".booktitle").first().attr("data-id");
					document.getElementById('textToSearchHS').blur();
				}
			}
			if (input != "") {
				require(["inforhelp"], function () {
						inforhelp.goSearch(input,filter);
				});
				
			}		
		}
		if (key === 9) {
			this.clear();
			inforhelp.hidesearch();
			inforhelp.hidesearchHS();
		}
      },

		handleMouseover: function(e) {
			$(this).addClass('is-hovered');			
		},
		handleMouseleave: function(e) {
			if (!varstore.isCollection && !$('#textToSearch').val()) {
				//inforhelp.hidesearch();
			}
			if (varstore.isCollection && !$('#textToSearchHS').val() && !$('#textToSearch').val()) {
				//inforhelp.hideAllSearch();
			}
           $(this).removeClass('is-hovered');
		},
		
		// Modifies the menu at $('#autocomplete-list') to propagate/remove style classes on the Searchfield element.
		handlePopupBeforeOpen: function(e, menu) {
			if (!menu) {
          return;
        }

        var contextClassMethod = this.wrapper.hasClass('context') ? 'addClass' : 'removeClass',
          altClassMethod = this.wrapper.hasClass('alternate') ? 'addClass' : 'removeClass';

        menu[contextClassMethod]('context');
        menu[altClassMethod]('alternate');

        return true;
      },

      handleCategoryFocus: function() {
        // if Toolbar Searchfield, allow that control to handle adding this class
        if (this.wrapper.is('.toolbar-searchfield-wrapper')) {
          return;
        }

        this.wrapper.addClass('has-focus');
      },

      handleCategoryBlur: function() {
        // if Toolbar Searchfield, allow that control to handle adding this class
        if (this.wrapper.is('.toolbar-searchfield-wrapper')) {
          return;
        }

        this.wrapper.removeClass('has-focus');
      },

      handlePopupClose: function() {
        return this.setAsActive();
      },

      clear: function() {
        this.element.val('').trigger('change').focus();
      },

      // Triggered by the "updated.searchfield" event
      updated: function() {
        this.teardown().init();
      },

      enable: function() {
        this.element.prop('disabled', false);
      },

      disable: function() {
        this.element.prop('disabled', true);
      },

      // Performs the usual Boolean coercion with the exception of
      // the strings "false" (case insensitive) and "0"
      parseBoolean: function(b) {
        return !(/^(false|0)$/i).test(b) && !!b;
      },

      teardown: function() {
        this.element.off('updated.searchfield populated.searchfield');

        if (this.autocomplete) {
          this.autocomplete.destroy();
        }

        if (this.wrapper.hasClass('context')) {
          this.element.addClass('context');
        }

        this.element.next('.icon').remove();
        if (this.element.parent().hasClass('searchfield-wrapper')) {
          this.element.unwrap();
        }

        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new SearchField(this, settings));
      }
    });
  };


/**
* Side Bar Menu Control (Deleted, not used)
*/

/**
* SignIn Control (Deleted, not used)
*/

/**
* Touch Enabled/Responsive and Accessible Slider Control (Deleted, not used)
*/

// Arrange control (Deleted, not used)

  /**
  * Scroll Action Control
  */
  $.fn.scrollaction = function(options) {

    // Tab Settings and Options
    var pluginName = 'scrollaction',
        defaults = {
          scrollActionTarget: '.js-scroll-target', // The element to add a class to based on scrolling logic
          classToAdd: 'scrolled-down' // The class added to the target element
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function ScrollAction(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      this.init();
    }

    // Actual Plugin Code
    ScrollAction.prototype = {

      init: function() {
        this.trackScrolling();
        return this;
      },

      /**
       * Attach scrolling logic to specified element
       */
      trackScrolling: function() {
        var self = this;
        self.lastScrollTop = 0;

        this.element.scroll(function() {
          var st = $(this).scrollTop();

          if (st > self.lastScrollTop){
            self.didScrollDown();
          } else {
            self.didScrollUp();
          }

          self.lastScrollTop = st;
        });
      },

      /**
       * Slide element down on scroll up
       */
      didScrollUp: function() {
        $(this.settings.scrollActionTarget).removeClass(this.settings.classToAdd);
      },

      /**
       * Slide element up on scroll down
       */
      didScrollDown: function() {
        $(this.settings.scrollActionTarget).addClass(this.settings.classToAdd);
      }

    };

    // Keep the Chaining and Init the Controls or Settings
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {

      } else {
        instance = $.data(this, pluginName, new ScrollAction(this, settings));
      }
    });
  };


/**
* Spinbox Control (link to docs) (Deleted, not used)
*/

/**
* Splitter Control (Deleted, not used)
*/


  /**
  * Step Process Control (Deleted, not used)
  */

  /**
  * Swaplist Control (Deleted, not used)
  */

/**
* Toast Control (TODO: bitly link to docs), deleted, not used
*/

  /**
  * Tab Control, deleted from here
  */


  // Deprecated the old Vertical Tabs code in favor of using the Tabs class.
  //$.fn.verticaltabs = $.fn.tabs;

  //tag function deleted from here

/**
* Textarea Control (TODO: link to docs) (Deleted, not used)
*/

/**
* Timepicker Control (TODO: bitly link to docs)
*/


/*!
 *  Copyright 2011 Twitter, Inc.
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */


  var Tmpl = window.Tmpl = {};

  Tmpl.Template = function (codeObj, text, compiler, options) {
    codeObj = codeObj || {};
    this.r = codeObj.code || this.r;
    this.c = compiler;
    this.options = options || {};
    this.text = text || '';
    this.partials = codeObj.partials || {};
    this.subs = codeObj.subs || {};
    this.buf = '';
  };

  // Setup regex  assignments
  // remove whitespace according to Mustache spec
  var rIsWhitespace = /\S/,
      rNewline =  /\n/g,
      rCr = /\r/g,
      rSlash = /\\/g,
      rLineSep = /\u2028/,
      rParagraphSep = /\u2029/;

  var rAmp = /&/g,
      rLt = /</g,
      rGt = />/g,
      rApos = /\'/g,
      rQuot = /\"/g,
      hChars = /[&<>\"\']/;

  //Find a key in an object
  function findInScope(key, scope, doModelGet) {
    var val;

    if (scope && typeof scope === 'object') {

      if (scope[key] !== undefined) {
        val = scope[key];

      // try lookup with get for backbone or similar model data
      } else if (doModelGet && scope.get && typeof scope.get === 'function') {
        val = scope.get(key);
      }
    }

    return val;
  }

  function write(s) {
    return 't.b(' + s + ');';
  }

  function isOpener(token, tags) {
    for (var i = 0, l = tags.length; i < l; i++) {
      if (tags[i].o === token.n) {
        token.tag = '#';
        return true;
      }
    }
  }

  function isCloser(close, open, tags) {
    for (var i = 0, l = tags.length; i < l; i++) {
      if (tags[i].c === close && tags[i].o === open) {
        return true;
      }
    }
  }

  function esc(s) {
    return s.replace(rSlash, '\\\\')
            .replace(rQuot, '\\\'')
            .replace(rNewline, '\\n')
            .replace(rCr, '\\r')
            .replace(rLineSep, '\\u2028')
            .replace(rParagraphSep, '\\u2029');
  }

  function createSpecializedPartial(instance, subs, partials, stackSubs, stackPartials, stackText) {
    function PartialTemplate() {}
    PartialTemplate.prototype = instance;
    function Substitutions() {}
    Substitutions.prototype = instance.subs;
    var key;
    var partial = new PartialTemplate();
    partial.subs = new Substitutions();
    partial.subsText = {};  //hehe. substext.
    partial.buf = '';

    stackSubs = stackSubs || {};
    partial.stackSubs = stackSubs;
    partial.subsText = stackText;
    for (key in subs) {
      if (!stackSubs[key]) {
        stackSubs[key] = subs[key];
      }
    }
    for (key in stackSubs) {
      partial.subs[key] = stackSubs[key];
    }

    stackPartials = stackPartials || {};
    partial.stackPartials = stackPartials;
    for (key in partials) {
      if (!stackPartials[key]) {
       stackPartials[key] = partials[key];
      }
    }
    for (key in stackPartials) {
      partial.partials[key] = stackPartials[key];
    }

    return partial;
  }

  function coerceToString(val) {
    return String((val === null || val === undefined) ? '' : val);
  }

  function cleanTripleStache(token) {
    if (token.n.substr(token.n.length - 1) === '}') {
      token.n = token.n.substring(0, token.n.length - 1);
    }
  }

  function trim(s) {
    if (s.trim) {
      return s.trim();
    }

    return s.replace(/^\s*|\s*$/g, '');
  }

  function tagChange(tag, text, index) {
    if (text.charAt(index) !== tag.charAt(0)) {
      return false;
    }

    for (var i = 1, l = tag.length; i < l; i++) {
      if (text.charAt(index + i) !== tag.charAt(i)) {
        return false;
      }
    }
    return true;
  }

  function TmplEscape(str) {
    str = coerceToString(str);
    return hChars.test(str) ?
      str
        .replace(rAmp, '&amp;')
        .replace(rLt, '&lt;')
        .replace(rGt, '&gt;')
        .replace(rApos, '&#39;')
        .replace(rQuot, '&quot;') :
      str;
  }

  Tmpl.Template.prototype = {
    // render: replaced by generated code.
    r: function (context, partials, indent) { return ''; }, // jshint ignore:line

    // variable escaping
    v: TmplEscape,

    // triple stache
    t: coerceToString,

    render: function render(context, partials, indent) {
      return this.ri([context], partials || {}, indent);
    },

    // render internal -- a hook for overrides that catches partials too
    ri: function (context, partials, indent) {
      return this.r(context, partials, indent);
    },

    // ensurePartial
    ep: function(symbol, partials) {
      var partial = this.partials[symbol];

      // check to see that if we've instantiated this partial before
      var template = partials[partial.name];
      if (partial.instance && partial.base === template) {
        return partial.instance;
      }

      if (typeof template === 'string') {
        if (!this.c) {
          throw new Error('No compiler available.');
        }
        template = this.c.compile(template, this.options);
      }

      if (!template) {
        return null;
      }

      // We use this to check whether the partials dictionary has changed
      this.partials[symbol].base = template;

      if (partial.subs) {
        // Make sure we consider parent template now
        if (!partials.stackText) {
          partials.stackText = {};
        }
        for (var key in partial.subs) {
          if (!partials.stackText[key]) {
            partials.stackText[key] = (this.activeSub !== undefined && partials.stackText[this.activeSub]) ? partials.stackText[this.activeSub] : this.text;
          }
        }
        template = createSpecializedPartial(template, partial.subs, partial.partials,
          this.stackSubs, this.stackPartials, partials.stackText);
      }
      this.partials[symbol].instance = template;

      return template;
    },

    // tries to find a partial in the current scope and render it
    rp: function(symbol, context, partials, indent) {
      var partial = this.ep(symbol, partials);
      if (!partial) {
        return '';
      }

      return partial.ri(context, partials, indent);
    },

    // render a section
    rs: function(context, partials, section) {
      var tail = context[context.length - 1];

      if (!$.isArray(tail)) {
        section(context, partials, this);
        return;
      }

      for (var i = 0; i < tail.length; i++) {
        context.push(tail[i]);
        section(context, partials, this);
        context.pop();
      }
    },

    // maybe start a section
    s: function(val, ctx, partials, inverted, start, end, tags) {
      var pass;

      if ($.isArray(val) && val.length === 0) {
        return false;
      }

      if (typeof val === 'function') {
        val = this.ms(val, ctx, partials, inverted, start, end, tags);
      }

      pass = !!val;

      if (!inverted && pass && ctx) {
        ctx.push((typeof val === 'object') ? val : ctx[ctx.length - 1]);
      }

      return pass;
    },

    // find values with dotted names
    d: function(key, ctx, partials, returnFound) {
      var found,
          names = key.split('.'),
          val = this.f(names[0], ctx, partials, returnFound),
          doModelGet = this.options.modelGet,
          cx = null;

      if (key === '.' && $.isArray(ctx[ctx.length - 2])) {
        val = ctx[ctx.length - 1];
      } else {
        for (var i = 1; i < names.length; i++) {
          found = findInScope(names[i], val, doModelGet);
          if (found !== undefined) {
            cx = val;
            val = found;
          } else {
            val = '';
          }
        }
      }

      if (returnFound && !val) {
        return false;
      }

      if (!returnFound && typeof val === 'function') {
        ctx.push(cx);
        val = this.mv(val, ctx, partials);
        ctx.pop();
      }

      return val;
    },

    // find values with normal names
    f: function(key, ctx, partials, returnFound) {
      var val = false,
          v = null,
          found = false,
          doModelGet = this.options.modelGet;

      for (var i = ctx.length - 1; i >= 0; i--) {
        v = ctx[i];
        val = findInScope(key, v, doModelGet);
        if (val !== undefined) {
          found = true;
          break;
        }
      }

      if (!found) {
        return (returnFound) ? false : '';
      }

      if (!returnFound && typeof val === 'function') {
        val = this.mv(val, ctx, partials);
      }

      return val;
    },

    // higher order templates
    ls: function(func, cx, partials, text, tags) {
      var oldTags = this.options.delimiters;

      this.options.delimiters = tags;
      this.b(this.ct(coerceToString(func.call(cx, text)), cx, partials));
      this.options.delimiters = oldTags;

      return false;
    },

    // compile text
    ct: function(text, cx, partials) {
      if (this.options.disableLambda) {
        throw new Error('Lambda features disabled.');
      }
      return this.c.compile(text, this.options).render(cx, partials);
    },

    // template result buffering
    b: function(s) { this.buf += s; },

    fl: function() { var r = this.buf; this.buf = ''; return r; },

    // method replace section
    ms: function(func, ctx, partials, inverted, start, end, tags) {
      var textSource,
          cx = ctx[ctx.length - 1],
          result = func.call(cx);

      if (typeof result === 'function') {
        if (inverted) {
          return true;
        } else {
          textSource = (this.activeSub && this.subsText && this.subsText[this.activeSub]) ? this.subsText[this.activeSub] : this.text;
          return this.ls(result, cx, partials, textSource.substring(start, end), tags);
        }
      }

      return result;
    },

    // method replace variable
    mv: function(func, ctx, partials) {
      var cx = ctx[ctx.length - 1];
      var result = func.call(cx);

      if (typeof result === 'function') {
        return this.ct(coerceToString(result.call(cx)), cx, partials);
      }

      return result;
    },

    sub: function(name, context, partials, indent) {
      var f = this.subs[name];
      if (f) {
        this.activeSub = name;
        f(context, partials, this, indent);
        this.activeSub = false;
      }
    }
  };

  Tmpl.tags = {
    '#': 1, '^': 2, '<': 3, '$': 4,
    '/': 5, '!': 6, '>': 7, '=': 8, '_v': 9,
    '{': 10, '&': 11, '_t': 12
  };

  Tmpl.scan = function scan(text, delimiters) {
    var len = text.length,
        IN_TEXT = 0,
        IN_TAG_TYPE = 1,
        IN_TAG = 2,
        state = IN_TEXT,
        tagType = null,
        tag = null,
        buf = '',
        tokens = [],
        seenTag = false,
        i = 0,
        lineStart = 0,
        otag = '{{',
        ctag = '}}';

    function addBuf() {
      if (buf.length > 0) {
        tokens.push({tag: '_t', text: new String(buf)}); // jshint ignore:line
        buf = '';
      }
    }

    function lineIsWhitespace() {
      var isAllWhitespace = true;
      for (var j = lineStart; j < tokens.length; j++) {
        isAllWhitespace =
          (Tmpl.tags[tokens[j].tag] < Tmpl.tags._v) ||
          (tokens[j].tag == '_t' && tokens[j].text.match(rIsWhitespace) === null); // jshint ignore:line
        if (!isAllWhitespace) {
          return false;
        }
      }

      return isAllWhitespace;
    }

    function filterLine(haveSeenTag, noNewLine) {
      addBuf();

      if (haveSeenTag && lineIsWhitespace()) {
        for (var j = lineStart, next; j < tokens.length; j++) {
          if (tokens[j].text) {
            if ((next = tokens[j+1]) && next.tag === '>') {
              // set indent to token value
              next.indent = tokens[j].text.toString();
            }
            tokens.splice(j, 1);
          }
        }
      } else if (!noNewLine) {
        tokens.push({tag:'\n'});
      }

      seenTag = false;
      lineStart = tokens.length;
    }

    function changeDelimiters(text, index) {
      var close = '=' + ctag,
          closeIndex = text.indexOf(close, index),
          delimiters = trim(
            text.substring(text.indexOf('=', index) + 1, closeIndex)
          ).split(' ');

      otag = delimiters[0];
      ctag = delimiters[delimiters.length - 1];

      return closeIndex + close.length - 1;
    }

    if (delimiters) {
      delimiters = delimiters.split(' ');
      otag = delimiters[0];
      ctag = delimiters[1];
    }

    for (i = 0; i < len; i++) {
      if (state === IN_TEXT) {
        if (tagChange(otag, text, i)) {
          --i;
          addBuf();
          state = IN_TAG_TYPE;
        } else {
          if (text.charAt(i) === '\n') {
            filterLine(seenTag);
          } else {
            buf += text.charAt(i);
          }
        }
      } else if (state === IN_TAG_TYPE) {
        i += otag.length - 1;
        tag = Tmpl.tags[text.charAt(i + 1)];
        tagType = tag ? text.charAt(i + 1) : '_v';
        if (tagType === '=') {
          i = changeDelimiters(text, i);
          state = IN_TEXT;
        } else {
          if (tag) {
            i++;
          }
          state = IN_TAG;
        }
        seenTag = i;
      } else {
        if (tagChange(ctag, text, i)) {
          tokens.push({tag: tagType, n: trim(buf), otag: otag, ctag: ctag,
                       i: (tagType === '/') ? seenTag - otag.length : i + ctag.length});
          buf = '';
          i += ctag.length - 1;
          state = IN_TEXT;
          if (tagType === '{') {
            if (ctag === '}}') {
              i++;
            } else {
              cleanTripleStache(tokens[tokens.length - 1]);
            }
          }
        } else {
          buf += text.charAt(i);
        }
      }
    }

    filterLine(seenTag, true);
    return tokens;
  };

  // the tags allowed inside super templates
  var allowedInSuper = {'_t': true, '\n': true, '$': true, '/': true};

  function buildTree(tokens, kind, stack, customTags) {
    var instructions = [],
        opener = null,
        tail = null,
        token = null;

    tail = stack[stack.length - 1];

    while (tokens.length > 0) {
      token = tokens.shift();

      if (tail && tail.tag === '<' && !(token.tag in allowedInSuper)) {
        throw new Error('Illegal content in < super tag.');
      }

      if (Tmpl.tags[token.tag] <= Tmpl.tags.$ || isOpener(token, customTags)) {
        stack.push(token);
        token.nodes = buildTree(tokens, token.tag, stack, customTags);
      } else if (token.tag === '/') {
        if (stack.length === 0) {
          throw new Error('Closing tag without opener: /' + token.n);
        }
        opener = stack.pop();
        if (token.n !== opener.n && !isCloser(token.n, opener.n, customTags)) {
          throw new Error('Nesting error: ' + opener.n + ' vs. ' + token.n);
        }
        opener.end = token.i;
        return instructions;
      } else if (token.tag === '\n') {
        token.last = (tokens.length === 0) || (tokens[0].tag === '\n');
      }

      instructions.push(token);
    }

    if (stack.length > 0) {
      throw new Error('missing closing tag: ' + stack.pop().n);
    }

    return instructions;
  }

  function stringifySubstitutions(obj) {
    var items = [];
    for (var key in obj) {
      items.push('"' + esc(key) + '": function(c,p,t,i) {' + obj[key] + '}');
    }
    return '{ ' + items.join(',') + ' }';
  }

  function stringifyPartials(codeObj) {
    var partials = [];
    for (var key in codeObj.partials) {
      partials.push('"' + esc(key) + '":{name:"' + esc(codeObj.partials[key].name) + '", ' + stringifyPartials(codeObj.partials[key]) + '}');
    }
    return 'partials: {' + partials.join(',') + '}, subs: ' + stringifySubstitutions(codeObj.subs);
  }

  Tmpl.stringify = function(codeObj, text, options) { // jshint ignore:line
    return '{code: function (c,p,i) { ' + Tmpl.wrapMain(codeObj.code) + ' },' + stringifyPartials(codeObj) +  '}';
  };

  var serialNo = 0;
  Tmpl.generate = function(tree, text, options) {
    serialNo = 0;
    var context = { code: '', subs: {}, partials: {} };
    Tmpl.walk(tree, context);

    if (options.asString) {
      return this.stringify(context, text, options);
    }

    return this.makeTemplate(context, text, options);
  };

  Tmpl.wrapMain = function(code) {
    return 'var t=this;t.b(i=i||"");' + code + 'return t.fl();';
  };

  Tmpl.template = Tmpl.Template;

  Tmpl.makeTemplate = function(codeObj, text, options) {
    var template = this.makePartials(codeObj);
    template.code = new Function('c', 'p', 'i', this.wrapMain(codeObj.code)); // jshint ignore:line
    return new this.template(template, text, this, options);
  };

  Tmpl.makePartials = function(codeObj) {
    var key, template = {subs: {}, partials: codeObj.partials, name: codeObj.name};
    for (key in template.partials) {
      template.partials[key] = this.makePartials(template.partials[key]);
    }
    for (key in codeObj.subs) {
      template.subs[key] = new Function('c', 'p', 't', 'i', codeObj.subs[key]); // jshint ignore:line
    }
    return template;
  };

  function chooseMethod(s) {
    return (~s.indexOf('.')) ? 'd' : 'f';
  }

  function createPartial(node, context) {
    var prefix = '<' + (context.prefix || '');
    var sym = prefix + node.n + serialNo++;
    context.partials[sym] = {name: node.n, partials: {}};
    context.code += 't.b(t.rp("' +  esc(sym) + '",c,p,"' + (node.indent || '') + '"));';
    return sym;
  }

  function tripleStache(node, context) {
    context.code += 't.b(t.t(t.' + chooseMethod(node.n) + '("' + esc(node.n) + '",c,p,0)));';
  }

  Tmpl.codegen = {
    '#': function(node, context) {
      context.code += 'if(t.s(t.' + chooseMethod(node.n) + '("' + esc(node.n) + '",c,p,1),' +
                      'c,p,0,' + node.i + ',' + node.end + ',"' + node.otag + ' ' + node.ctag + '")){' +
                      't.rs(c,p,' + 'function(c,p,t){';
      Tmpl.walk(node.nodes, context);
      context.code += '});c.pop();}';
    },

    '^': function(node, context) {
      context.code += 'if(!t.s(t.' + chooseMethod(node.n) + '("' + esc(node.n) + '",c,p,1),c,p,1,0,0,"")){';
      Tmpl.walk(node.nodes, context);
      context.code += '};';
    },

    '>': createPartial,
    '<': function(node, context) {
      var ctx = {partials: {}, code: '', subs: {}, inPartial: true};
      Tmpl.walk(node.nodes, ctx);
      var template = context.partials[createPartial(node, context)];
      template.subs = ctx.subs;
      template.partials = ctx.partials;
    },

    '$': function(node, context) {
      var ctx = {subs: {}, code: '', partials: context.partials, prefix: node.n};
      Tmpl.walk(node.nodes, ctx);
      context.subs[node.n] = ctx.code;
      if (!context.inPartial) {
        context.code += 't.sub("' + esc(node.n) + '",c,p,i);';
      }
    },

    '\n': function(node, context) {
      context.code += write('"\\n"' + (node.last ? '' : ' + i'));
    },

    '_v': function(node, context) {
      context.code += 't.b(t.v(t.' + chooseMethod(node.n) + '("' + esc(node.n) + '",c,p,0)));';
    },

    '_t': function(node, context) {
      context.code += write('"' + esc(node.text) + '"');
    },

    '{': tripleStache,

    '&': tripleStache
  };

  Tmpl.walk = function(nodelist, context) {
    var func;
    for (var i = 0, l = nodelist.length; i < l; i++) {
      func = Tmpl.codegen[nodelist[i].tag];
      if (func) {
        func(nodelist[i], context);
      }
    }
    return context;
  };

  Tmpl.parse = function(tokens, text, options) {
    options = options || {};
    return buildTree(tokens, '', [], options.sectionTags || []);
  };

  Tmpl.cache = {};

  Tmpl.cacheKey = function(text, options) {
    return [text, !!options.asString, !!options.disableLambda, options.delimiters, !!options.modelGet].join('||');
  };

  Tmpl.compile = function(text, options) {
    options = options || {};
    var key = Tmpl.cacheKey(text, options);
    var template = this.cache[key];

    if (template) {
      var partials = template.partials;
      for (var name in partials) {
        delete partials[name].instance;
      }
      return template;
    }

    template = this.generate(this.parse(this.scan(text, options.delimiters), text, options), text, options);
    this.cache[key] = template;
    return template;
  };

/**
* Toolbar Control (TODO: bitly link to soho xi docs)
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.
  $.fn.toolbar = function(options) {

    'use strict';
    // Settings and Options
    var pluginName = 'toolbar',
        defaults = {
          rightAligned: false, // Will always attempt to right-align the contents of the toolbar.
          maxVisibleButtons: 7 // Total amount of buttons that can be present, not including the More button
		  // changed max to 7 from 3, mludwig
        },
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function Toolbar(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    Toolbar.prototype = {

      init: function() {
        return this
          .setup()
          .build()
          .handleEvents();
      },

      setup: function() {
        // Can't have zero buttons
        if (this.settings.maxVisibleButtons <= 0) {
          this.settings.maxVisibleButtons = 3;
        }

        return this;
      },

      build: function() {
        var self = this;

        this.element.attr('role', 'toolbar');
        this.buildAriaLabel();

        // keep track of how many popupmenus there are with an ID.
        // Used for managing events that are bound to $(document)
        if (!this.id) {
          this.id = (parseInt($('.toolbar, .formatter-toolbar').index(this.element), 10));
        }

        // Check for a "title" element.  This element is optional.
        this.title = this.element.children('.title');

        // Container for main group of buttons and input fields.  Only these spill into the More menu.
        //this.buttonset = this.element.children('.buttonset');
		this.buttonset = this.element.children('.buttonset.search');
        if (!this.buttonset.length) {
          this.buttonset = $('<div class="buttonset"></div>');
          if (this.title.length) {
            this.buttonset.insertAfter(this.title);
          } else {
            this.buttonset.prependTo(this.element);
          }
        }

        this.buttonset[this.settings.rightAligned ? 'addClass' : 'removeClass']('right-aligned');

        // Add and invoke More Button, if it doesn't exist
        this.more = this.element.find('.btn-actions');
        if (this.more.length === 0 && !this.element.hasClass('no-actions-button')) {
          var moreContainer = this.element.find('.more');

          if (!moreContainer.length) {
            moreContainer = $('<div class="more"></div>').appendTo(this.element);
          }
		// mludwig, hiding below to avoid security flag until such time as we use a more button
         // this.more = $('<button class="btn-actions" type="button"></button>')
         //   .text($.createIcon({icon: 'more'}) +
         //     '<span class="audible">'+Locale.translate('MoreActions')+'</span>')
        //    .appendTo(moreContainer);
        }

        // Reference all interactive items in the toolbar
        this.items = this.buttonset.children('button')
          .add(this.buttonset.find('input')) // Searchfield Wrappers
          .add(this.title.children('button'));
          //.add(this.more);

        this.buttonsetItems = this.buttonset.children('button, input')
          .add(this.buttonset.find('.searchfield-wrapper').children('input'));

        // Invoke buttons
        var buttons = this.items.filter('button, input[type="button"], [class^="btn"]');
        buttons.each(function() {
          var buttonControl = $(this).data('button');
          if (!buttonControl) {
            $(this).button();
          }
        });

        // Setup the More Actions Menu.  Add Menu Items for existing buttons/elements in the toolbar, but
        // hide them initially.  They are revealed when overflow checking happens as the menu is opened.
        var popupMenuInstance = this.more.data('popupmenu'),
          moreAriaAttr = this.more.attr('aria-controls');
        if (!popupMenuInstance) {
          this.moreMenu = $('#' + moreAriaAttr);
          if (!this.moreMenu.length) {
            this.moreMenu = this.more.next('.popupmenu');
          }
          if (!this.moreMenu.length) {
            this.moreMenu = $('<ul id="popupmenu-toolbar-'+ this.id +'" class="popupmenu"></ul>').insertAfter(this.more);
          }
        } else {
          this.moreMenu = popupMenuInstance.menu;
        }
        this.defaultMenuItems = this.moreMenu.children('li:not(.separator)').length > 0;

        function menuItemFilter() {
          //jshint validthis:true
          return $(this).parent('.buttonset, .inline').length;
        }

        var menuItems = [];
        function buildMenuItem() {
          /*jshint validthis:true */
          var item = $(this),
            popupLi = $('<li></li>'),
            a = $('<a href="#"></a>').appendTo(popupLi);

          if (item.is(':hidden')) {
            popupLi.addClass('hidden');
          }
          if (item.is(':disabled')) {
            popupLi.addClass('is-disabled');
          } else {
            popupLi.removeClass('is-disabled');
          }

          a.text(self.getItemText(item));

          // Pass along any icons except for the dropdown (which is added as part of the submenu design)
          var submenuDesignIcon = $.getBaseURL('#icon-dropdown');
          var icon = item.children('.icon').filter(function() {
            var iconName = $(this).getIconName();

            return iconName && iconName !== submenuDesignIcon && iconName.indexOf('dropdown') === -1;
          });

          if (icon && icon.length) {
            a.html('<span>' + a.text() + '</span>');
            icon.clone().detach().prependTo(a);
          }

          var linkspan = popupLi.find('b');
          if (linkspan.length) {
            self.moreMenu.addClass('has-icons');
            linkspan.detach().prependTo(popupLi);
          }

          if (item.is('.searchfield')) {
            if (!item.data('searchfield')) {
              var searchfieldOpts = $.extend({}, $.fn.parseOptions(item[0]));
              item.toolbarsearchfield(searchfieldOpts);
            }
          }

          function addItemLinksRecursively(menu, diffMenu, parentItem) {
            var children = menu.children('li'),
              id = diffMenu.attr('id');

            diffMenu.children('li').each(function(i, diffMenuItem) {
              var dmi = $(diffMenuItem), // "Diffed" Menu Item
                omi = children.eq(i), // Corresponding "Original" menu item
                dmiA = dmi.children('a'), // Anchor inside of "Diffed" menu item
                omiA = omi.children('a'); // Anchor inside of "Original" menu item

              dmiA.removeAttr('id');

              omiA.data('action-button-link', dmiA);
              dmiA.data('original-button', omiA);

              var omiSubMenu = omi.children('.wrapper').children('.popupmenu'),
                dmiSubMenu = dmi.children('.wrapper').children('.popupmenu');

              if (dmiSubMenu.length && dmiSubMenu.length) {
                dmi.addClass('submenu');
                addItemLinksRecursively(dmiSubMenu, omiSubMenu, dmi);
              }
            });

            diffMenu.removeAttr('id').attr('data-original-menu', id);
            parentItem.addClass('submenu');

            if (parentItem.is(popupLi)) {
              diffMenu.wrap($('<div class="wrapper"></div>'));
              parentItem.append(diffMenu);
            }
          }

          if (item.is('.btn-menu')) {
            if (!item.data('popupmenu')) {
              item.popupmenu();
            }

            var menu = item.data('popupmenu').menu,
              diffMenu = menu.clone();

            addItemLinksRecursively(menu, diffMenu, popupLi);
          }

          if (item.is('[data-popdown]')) {
            item.popdown();
          }

          // Setup data links between the buttons and their corresponding list items
          item.data('action-button-link', a);
          popupLi.children('a').data('original-button', item);
          menuItems.push(popupLi);
        }

        this.items.not(this.more).filter(menuItemFilter).each(buildMenuItem);
        menuItems.reverse();
        $.each(menuItems, function(i, item) {
          if (item.text() !== '') {
            item.prependTo(self.moreMenu);
          }
        });

        //Refresh Text and Disabled
        function refreshTextAndDisabled() {
          self.moreMenu.find('a').each(function () {
            var a = $(this),
                item = $(this).data('originalButton'),
                text = self.getItemText(item);

            if (item) {
              if (a.find('span').length) {
                a.find('span').text(text.trim());
              } else {
                a.text(text.trim());
              }

              if (item.is(':disabled')) {
                a.closest('li').addClass('is-disabled');
                a.attr('disabled', 'disabled');
              } else {
                a.closest('li').removeClass('is-disabled');
                a.removeAttr('disabled');
              }

            }
          });
        }

        if (popupMenuInstance) {
          this.more.triggerHandler('updated');
          popupMenuInstance.element.off('beforeopen').on('beforeopen', refreshTextAndDisabled);
        } else {
          var actionButtonOpts = $.fn.parseOptions(this.more[0]);

          this.more.popupmenu($.extend({}, actionButtonOpts, {
            trigger: 'click',
            menu: this.moreMenu
          })).off('beforeopen').on('beforeopen', refreshTextAndDisabled);
        }


        // Setup the tabindexes of all items in the toolbar and set the starting active button.
        function setActiveToolbarItem() {
			//mludwig, switching to 0, this was preventing tabbing, not ever getting reset from -1
          self.items.attr('tabindex', '0');

          var active = self.items.filter('.is-selected');
          if (active.length) {
            self.activeButton = active.first().attr('tabindex', '0');
            self.items.not(self.activeButton).removeClass('is-selected');
            return;
          }

          // Set active to the first item in the toolbar.
          active = self.items.filter(':visible:not(:disabled)').first().attr('tabindex', '0');
          self.activeButton = active;

          // If the whole toolbar is hidden (contextual toolbars, etc),
          // automatically set the first non-disabled item as visible
          if (self.element.is(':hidden, .is-hidden')) {
            self.activeButton = self.items.filter(':not(:disabled)').first().attr('tabindex', '0');
            return;
          }

          if (self.isItemOverflowed(active)) {
            active.attr('tabindex', '-1');
            self.activeButton = self.more.addClass('is-selected').attr('tabindex', '0');
          }
          return;
        }

        setActiveToolbarItem();

        // Toggles the More Menu based on overflow of toolbar items
        this.adjustButtonVisibility();
        this.toggleMoreMenu();

        this.element.triggerHandler('rendered');

        return this;
      },

      // Order of operations for populating the List Item text:
      // span contents (.audible) >> button title attribute >> tooltip text (if applicable)
      getItemText: function (item) {
        if (!item) {
          return;
        }
        var span = item.find('.audible'),
          title = item.attr('title'),
          tooltip = item.data('tooltip'),
          tooltipText = tooltip ? tooltip.content : undefined;

        var popupLiText = span.length ? span.text() :
          title !== '' && title !== undefined ? item.attr('title') :
          tooltipText ? tooltipText : item.text();

        return popupLiText;
      },

      handleEvents: function() {
        var self = this;
		// mludwig, event to track touches on toolbar to hide search field if needed on mobile devices
		$('#toolbar','#toolbarColl').on('touchstart.toolbar mousedown.toolbar', function(e) {
			self.handleTouchstart(e);
		});
        /*this.items
          .off('keydown.toolbar').on('keydown.toolbar', function(e) {
            self.handleKeys(e);
          }).off('click.toolbar').on('click.toolbar', function(e) {	
            self.handleClick(e);
          });*/

        this.items.filter('.btn-menu, .btn-actions')
          .off('close.toolbar').on('close.toolbar', function onClosePopup() {
            $(this).focus();
          });

        this.items.not(this.more).off('selected.toolbar').on('selected.toolbar', function(e, anchor) {
          e.stopPropagation();
          self.handleSelected(e, anchor);
        });

        this.more.off('keydown.toolbar').on('keydown.toolbar', function(e) {
          self.handleKeys(e);
        }).off('beforeopen.toolbar').on('beforeopen.toolbar', function() {
          self.checkOverflowItems();
        }).off('selected.toolbar').on('selected.toolbar', function(e, anchor) {
          e.stopPropagation();
          self.handleSelected(e, anchor);
        });

        this.element.off('updated.toolbar').on('updated.toolbar', function(e) {
          e.stopPropagation();
          self.updated();
        }).off('recalculateButtons.toolbar').on('recalculateButtons.toolbar', function() {
          self.handleResize();
        });

        $(window).off('resize.toolbar-' + this.id).on('resize.toolbar-' + this.id, function() {
          self.handleResize();
        });
        return this;
      },

      handleSelected: function(e, anchor) {
        var itemLink = anchor.data('original-button'),
          itemEvts,
          toolbarEvts;
        if (itemLink && itemLink.length > 0) {
          itemEvts = itemLink.listEvents();
          toolbarEvts = this.element.listEvents();

          // Make sure the active button is set properly
          this.setActiveButton(itemLink);

          // Fire Angular Events
          if (itemLink.attr('ng-click') || itemLink.attr('data-ng-click')) {
            itemLink.trigger('click');
            return;
          }

          // Check the Toolbar Button for the existence of certain event types.
          // Checks the button, and checks the toolbar container element for delegated events.
          var evtTypes = ['click', 'touchend', 'touchcancel'];
          for (var i = 0; i < evtTypes.length; i++) {
            var type = evtTypes[i];

            // Check toolbar element for delegated-down events first
            if (toolbarEvts && toolbarEvts[type] && toolbarEvts[type].delegateCount > 0) {
              var el = this.element,
                evt = $.Event(type);

              evt.target = el.find(itemLink)[0];
              el.trigger(evt);
              return;
            }

            // Check for events directly on the element
            if ((itemEvts && itemEvts[type]) || itemLink[0]['on' + type]) {
              itemLink.trigger(type);
              return;
            }
          }

          // Trigger Select on the linked item, since it won't be done by another event
          this.triggerSelect(itemLink);
          return;
        }

        // If no item link exists, it's a pre-defined menu item.
        // Trigger 'selected' manually on the toolbar element.
        // Normally this would happen by virtue of triggering the "click" handlers on a linked button above.
        this.triggerSelect(anchor);
      },
	  handleTouchstart: function(e) {
		  var target = $(e.target);
		  // mludwig, to hide search field if no search value and touch is outside
		  if (!($('#textToSearch').val()) && !target.is('INPUT') && !target.is('svg')) {
			  inforhelp.hidesearch();
			  if (window.innerWidth < 641){
				$('.title').css('display','inline-block');
			  }
		  }
	  },
      handleClick: function(e) {
        this.setActiveButton($(e.currentTarget));
        this.triggerSelect($(e.currentTarget));
        return false;
      },

      handleKeys: function(e) {
        var self = this,
          key = e.which,
          target = $(e.target);
		if (target.is('INPUT') && key === 13) {
			return false;
		}
        if (target.is('.btn-actions')) {
          if (key === 37 || key === 38) { // Left/Up
            e.preventDefault();
            self.setActiveButton(self.getLastVisibleButton());
          }

          if (key === 39 || (key === 40 && target.attr('aria-expanded') !== 'true')) { // Right (or Down if the menu's closed)
            e.preventDefault();
            self.setActiveButton(self.getFirstVisibleButton());
          }
          return;
        }
		if (key === 9) {
			// do nothing here
		}
        if ((key === 37 && target.is(':not(input)')) ||
          (key === 37 && target.is('input') && e.shiftKey) || // Shift + Left Arrow should be able to navigate away from Searchfields
          key === 38) {
          e.preventDefault();
          self.navigate(-1);
        }

        if ((key === 39 && target.is(':not(input)')) ||
          (key === 39 && target.is('input') && e.shiftKey) || // Shift + Right Arrow should be able to navigate away from Searchfields
          key === 40) {
          e.preventDefault();
          self.navigate(1);
        }

        return;
      },

      handleResize: function() {
        this.adjustButtonVisibility();
        this.toggleMoreMenu(); // Added 9/16/2015 due to issue HFC-2876
      },

      // Go To a button
      navigate: function (direction) {
        var items = this.items.filter(':visible:not(:disabled)'),
          current = items.index(this.activeButton),
          next = current + direction,
          target;

        if (next >= 0 && next < items.length) {
          target = items.eq(next);
        }

        if (next >= items.length) {
          target = items.first();
        }

        if (next === -1) {
          target = items.last();
        }

        if (this.isItemOverflowed(target)) {
          target = this.more;
        }

        this.setActiveButton(target);
        return false;
      },

      // Gets the last button that's above the overflow line
      getLastVisibleButton: function() {
        var self = this,
          target;

        this.items.each(function(i) {
          if (self.isItemOverflowed($(this))) {
            target = self.items.eq(i - 1);
            return false;
          }
        });

        if (!target || target.length === 0) {
          target = this.items.not(this.more).last();
        }

        while(target.is('.separator, *:disabled, *:hidden')) {
          target = target.prev();
        }
        return target;
      },

      getFirstVisibleButton: function() {
        var target = this.items.eq(0);
        while(target.is('.separator, *:disabled, *:hidden')) {
          target = target.next();
        }
        return target;
      },

      setActiveButton: function(activeButton, noFocus) {
        // Return out of this if we're clicking the currently-active item
        if (activeButton[0] === this.activeButton[0]) {
          return;
        }

        var self = this;

        function getActiveButton() {
          // Menu items simply set the "More Actions" button as active
          if (activeButton.is('a')) {
            return self.more;
          }

          // If it's the more button, hide the tooltip and set it as active
          var tooltip = self.more.data('tooltip');
          if (activeButton[0] === self.more[0]) {
            if (tooltip && tooltip.tooltip.is(':not(.hidden)')) {
              tooltip.hide();
            }
            return self.more;
          }

          // Overflowed items also set
          if (self.isItemOverflowed(activeButton)) {
            if (!activeButton.is('.searchfield')) {
              return self.more;
            }
          }

          return activeButton;
        }
       // this.items.add(this.more).attr('tabindex', '-1').removeClass('is-selected');

        this.activeButton = getActiveButton();
        this.activeButton.addClass('is-selected').attr('tabindex', '0');
		
		//mludwig
       // if (!noFocus) {
        //  this.activeButton[0].focus();
        //}
      },

      // Triggers a "selected" event on the base Toolbar element using a common element as an argument.
      // @param {Object} element - a jQuery Object containing an anchor tag, button, or input field.
      triggerSelect: function(element) {
        var elem = $(element);
        if (elem.is(this.more) || (elem.is('.btn-menu, li.submenu'))) {
          return;
        }

        this.element.trigger('selected', [elem]);
      },

      adjustButtonVisibility: function() {
        var self = this,
          visibleLis = [];

        function menuItemFilter() {
          // jshint validthis:true
          var i = $(this);
          return (i.data('action-button-link') && i.is(':not(.searchfield)'));
        }

        var addIconClassToMenu = 'removeClass';

        this.buttonsetItems.filter(menuItemFilter).removeClass('is-overflowed').each(function() {
          var i = $(this),
            li = i.data('action-button-link').parent();

          if (!self.isItemOverflowed(i) || i.hasClass('hidden')) {
            li.addClass('hidden');
          } else {
            li.removeClass('hidden');
            i.addClass('is-overflowed');

            if (i.find('.icon').length) {
              addIconClassToMenu = 'addClass';
            }

            visibleLis.push(li);
          }
        });

        this.moreMenu[addIconClassToMenu]('has-icons');

        return {
          visible: visibleLis
        };
      },

      // Item is considered overflowed if its right-most edge sits past the right-most edge of the border.
      isItemOverflowed: function(item) {
        if (!item || item.length === 0) {
          return true;
        }
        // In cases where a Title is present and buttons are right-aligned, only show up to the maximum allowed.
        if (this.title.length && (this.buttonsetItems.index(item) >= (this.settings.maxVisibleButtons - 1))) { // Subtract one to account for the More Button
          // ONLY cause this to happen if there are at least two items that can be placed in the overflow menu.
          // This prevents ONE item from being present in the menu by itself
          if (!this.buttonsetItems.last().is(item) || item.prev().is('.is-overflowed')) {
            return true;
          }
        }

        if (this.buttonset.scrollTop() > 0) {
          this.buttonset.scrollTop(0);
        }
        var offset = ($(item).offset().top + $(item).outerHeight()) - this.buttonset.offset().top;
        return offset >= this.buttonset.outerHeight() + 1;
      },

      checkOverflowItems: function() {
        var items = this.adjustButtonVisibility();



        // Focus the more menu if the current item is focused
        if (!$.contains(this.buttonset[0], document.activeElement)) {
          if (items.visible.length) {
            items.visible[items.visible.length - 1].focus();
          } else {
            this.moreMenu.find('.hidden').last().next().focus();
          }
        }
      },

      toggleMoreMenu: function() {
        if (this.element.hasClass('no-actions-button')) {
          return;
        }

        var overflowItems = this.moreMenu.children('li:not(.separator)'),
          hiddenOverflowItems = overflowItems.not('.hidden');

        var method = 'removeClass';
        if (this.defaultMenuItems || hiddenOverflowItems.length > 0) {
          method = 'addClass';
        }

        this.element[method]('has-more-button');

        var popupAPI = this.more.data('popupmenu');
        if (method === 'removeClass') {
          if (!popupAPI) {
            return;
          }

          popupAPI.close();

          var menuItems = popupAPI.menu.find('li:not(.separator)').children('a'),
            shouldFocus = false;

          menuItems.add(this.more).each(function() {
            if (document.activeElement === this) {
              shouldFocus = true;
            }
          });

          if (shouldFocus) {
            this.getLastVisibleButton()[0].focus();
          }
        }
      },

      buildAriaLabel: function() {
        // Set up an aria-label as per AOL guidelines
        // http://access.aol.com/dhtml-style-guide-working-group/#toolbar
        if (!this.element.attr('aria-label')) {
          var isHeader = (this.element.closest('.header').length ===1),
            id = this.element.attr('id') || '',
            title = this.element.children('.title'),
            prevLabel = this.element.prev('label'),
            prevSpan = this.element.prev('.label'),
            labelText = isHeader ? $('header.header').find('h1').text() :
            title.length ? title.filter('div').text() :
            prevLabel.length ? prevLabel.text() :
            prevSpan.length ? prevSpan.text() : id + ' ' + Locale.translate('Toolbar');

          this.element.attr('aria-label', labelText.replace(/\s+/g,' ').trim());
        }
      },

      updated: function() {

        this
          .unbind()
          .teardown()
          .init();

        setTimeout(function () {
          $(window).trigger('resize');
        }, 0);

      },

      enable: function() {
        this.element.prop('disabled', false);
        this.items.prop('disabled', false);
        this.more.prop('disabled', false);
      },

      disable: function() {
        this.element.prop('disabled', true);
        this.items.prop('disabled', true);
        this.more.prop('disabled', true).data('popupmenu').close();
      },

      unbind: function() {
        this.items
          .offTouchClick('toolbar')
          .off('keydown.toolbar click.toolbar focus.toolbar blur.toolbar');

        this.more.off('beforeOpen.toolbar selected.toolbar');
        $(window).off('resize.toolbar-' + this.id);
        return this;
      },

      teardown: function() {
        function deconstructMenuItem(i, item) {
          var li = $(item),
            a = li.children('a'),
            itemLink = a.data('original-button');

          a.off('mousedown.toolbar click.toolbar touchend.toolbar touchcancel.toolbar');

          if (itemLink && itemLink.length) {
            $.removeData(a[0], 'original-button');
            $.removeData(itemLink[0], 'action-button-link');
          }

          if (li.is('submenu')) {
            li.children('.wrapper').children('.popupmenu').children('li').each(deconstructMenuItem);
          }

          li.remove();
        }

        this.moreMenu.children('li').each(deconstructMenuItem);

        if (this.more.length && this.more.data('popupmenu') !== undefined) {
          this.more.data('popupmenu').destroy();
        }

        if (!this.defaultMenuItems) {
          this.moreMenu.remove();
        }

        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this
          .unbind()
          .teardown();

        if (this.buttonset.children('.searchfield-wrapper').length) {
          var searchFields = this.buttonset.children('.searchfield-wrapper').children('.searchfield');
          if (searchFields.data('toolbarsearchfield')) {
            searchFields.data('toolbarsearchfield').destroy();
          }
        }

        this.element.removeAttr('role').removeAttr('aria-label');
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new Toolbar(this, settings));
      }
    });
  };

/**
* Toolbar Searchfield (TODO: bitly link to soho xi docs)
* NOTE:  Depends on both a Toolbar control and Searchfield control to be present
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.
 
 $.fn.toolbarsearchfield = function(options) {
    'use strict';
    // Settings and Options
    var pluginName = 'toolbarsearchfield',
        defaults = {
          clearable: true,  // If "true", provides an "x" button on the right edge that clears the field
          collapsible: false // If "true", allows the field to expand/collapse on larger breakpoints when focused/blurred respectively
			// mludwig, was true for collapsible
		},
        settings = $.extend({}, defaults, options);

    // Plugin Constructor
    function ToolbarSearchfield(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    // Plugin Methods
    ToolbarSearchfield.prototype = {

      init: function() {
        return this
          .build()
          .handleEvents();
      },

      // Creates and manages any markup the control needs to function.
      build: function() {
        // Used for managing events that are bound to $(document)
        if (!this.id) {
          this.id = this.element.uniqueId('toolbar-searchfield');
        }

        // Build the searchfield element
        this.input = this.element;

        // If inside a toolbar, make sure to append it to the root toolbar element.
        this.toolbarParent = this.element.parents('.toolbar');
        this.containmentParent = this.toolbarParent;
        var moduleTabs = this.containmentParent.closest('.module-tabs');
        if (moduleTabs.length) {
          this.containmentParent = moduleTabs;
        }

        // Setup ARIA
        var label = this.element.attr('placeholder') || this.element.prev('label, .label').text().trim();
        if (!label || label === '') {
          label = Locale.translate('Keyword');
        }
        this.input.attr({
          'aria-label': label,
        });

        // Invoke Searchfield, pass settings on
        var sfSettings = $.extend({}, this.settings, $.fn.parseOptions(this.input[0]));
        this.input.searchfield(sfSettings);
        this.inputWrapper = this.input.parent('.searchfield-wrapper');
        //this.inputWrapper.addClass('toolbar-searchfield-wrapper');

        if (sfSettings.categories) {
          this.button = this.inputWrapper.find('.searchfield-category-button');
        }

        // Add/remove the collapsible setting
        var collapsibleMethod = this.settings.collapsible ? 'removeClass' : 'addClass';
        this.inputWrapper[collapsibleMethod]('non-collapsible');

        this.xButton = this.inputWrapper.children('.icon.close');

        // Open the searchfield once on intialize if it's a "non-collapsible" searchfield
        if (!this.settings.collapsible) {
          this.inputWrapper.addClass('no-transition').one('activated.' + this.id, function() {
            $(this).removeClass('no-transition');
          });
          this.activate();
        }

        return this;
      },

      // Main entry point for setting up event handlers.
      handleEvents: function() {
        var self = this;

        this.inputWrapper.on('mousedown.toolbarsearchfield', function() {
          self.fastActivate = true;
        }).on('focusin.toolbarsearchfield', function(e) {
          self.handleFocus(e);
        }).on('deactivate.toolbarsearchfield', function() {
          self.deactivate();
        });

        if (this.button && this.button.length) {
          this.button.on('beforeopen.toolbarsearchfield', function(e, menu) {
            return self.handlePopupBeforeOpen(e, menu);
          });
        }

        // Used to determine if the "Tab" key was involved in switching focus to the searchfield.
        $(document).on('keydown.' + this.id, function(e) {
          self.handleOutsideKeydown(e);
        });

        $('body').on('resize.' + this.id, function() {
          self.adjustOnBreakpoint();
        });

        return this;
      },

      handleDeactivationEvents: function() {
        var self = this;
        $(document).onTouchClick(this.id).on('click.' + this.id, function(e) {
          self.handleOutsideClick(e);
        });
      },

      handleFocus: function() {
        var self = this;
        clearTimeout(this.focusTimer);
        this.inputWrapper.addClass('has-focus');

        function searchfieldActivationTimer() {
          self.activate();
        }

        if (this.fastActivate) {
          searchfieldActivationTimer();
          return;
        }

        this.focusTimer = setTimeout(searchfieldActivationTimer, 0);
      },

      handleFakeBlur: function() {
        var self = this;
        clearTimeout(this.focusTimer);

        function searchfieldDeactivationTimer() {
          if (!$.contains(self.inputWrapper[0], document.activeElement) && self.inputWrapper.hasClass('active')) {
            self.inputWrapper.removeClass('has-focus');
            self.deactivate();
          }
        }

        this.focusTimer = setTimeout(searchfieldDeactivationTimer, 0);
      },

      handleOutsideClick: function(e) {
        var target = $(e.target);
		// need following because it thinks click/touch is outside searchfield
		if ($('#textToSearch').is('.active') && window.innerWidth < 641) {
			return;
		}
        // Don't close if we're focused on an element inside the wrapper
        if ($.contains(this.inputWrapper[0], e.target) || target.is(this.element) || target.is(this.inputWrapper)) {
          return;
        }
        // Don't close if a category is being selected from a category menu
        if (this.button && this.button.length) {
          var menu = this.button.data('popupmenu').menu;
          if (menu.has(target).length) {
            return;
          }
        }

        $(document).offTouchClick(this.id).off('click.' + this.id);
        this.deactivate();
      },

      handleOutsideKeydown: function(e) {
        var key = e.which;

        this.fastActivate = false;
        if (key === 9) { // Tab
          this.fastActivate = true;
          return this.handleFakeBlur();
        }

        var wasInputTheTarget = ($(e.target).is(this.input) || $(e.target).is(this.inputWrapper));
        if (wasInputTheTarget && (key === 37 || key === 38 || key === 39 || key === 40)) {
          return this.handleFakeBlur();
        }
      },

      handlePopupBeforeOpen: function(e, menu) {
        if (!menu) {
          return false;
        }

        if (!this.inputWrapper.is('.is-open')) {
          this.input.focus();
          return false;
        }

        return true;
      },

      // Retrieves the distance between a left and right boundary.
      // Used on controls like Lookup, Contextual Panel, etc. to fill the space remaining in a toolbar.
      getFillSize: function(leftBoundary, rightBoundary) {
		  //defaultWidth sets initial width of span.searchfield-wrapper
        var defaultWidth = "auto",
          leftBoundaryNum = 0,
          rightBoundaryNum = 0,
          maxFillSize = 450;

        function sanitize(boundary) {
          if (!boundary) {
            return 0;
          }

          // Return out if the boundary is just a number
          if (!isNaN(parseInt(boundary))) {
            return parseInt(boundary);
          }

          if (boundary instanceof jQuery) {
            if (!boundary.length) {
              return;
            }

            if (boundary.is('.title')) {
              boundary = boundary.next('.buttonset');
            }

            boundary = boundary[0];
          }

          return boundary;
        }

        function getEdgeFromBoundary(boundary, edge) {
          if (!isNaN(boundary)) {
            return (boundary === null || boundary === undefined) ? 0 : boundary;
          }

          if (!edge || typeof edge !== 'string') {
            edge = 'left';
          }

          var edges = ['left', 'right'];
          if ($.inArray(edge, edges) === -1) {
            edge = edges[0];
          }

          var rect;

          if (boundary instanceof HTMLElement || boundary instanceof SVGElement) {
            rect = boundary.getBoundingClientRect();
          }

          return rect[edge];
        }

        leftBoundary = sanitize(leftBoundary);
        rightBoundary = sanitize(rightBoundary);

        function whichEdge() {
          var e = 'left';
          if (leftBoundary === rightBoundary || ($(rightBoundary).length && $(rightBoundary).is('.buttonset'))) {
            e = 'right';
          }

          return e;
        }

        leftBoundaryNum = getEdgeFromBoundary(leftBoundary);
        rightBoundaryNum = getEdgeFromBoundary(rightBoundary, whichEdge());

        if (!leftBoundaryNum && !rightBoundaryNum) {
          return defaultWidth;
        }

        var distance = rightBoundaryNum - leftBoundaryNum;
        if (distance <= defaultWidth) {
          return defaultWidth;
        }

        if (distance >= maxFillSize) {
          return maxFillSize;
        }

        return distance;
      },

      setOpenWidth: function() {
        this.inputWrapper.css('width', this.openWidth);
      },

      calculateOpenWidth: function() {
        var buttonset = this.element.parents('.toolbar').children('.buttonset'),
          nextElem = this.inputWrapper.next(),
          width;

        // If small form factor, use the right edge
        if (nextElem.is('.title')) {
          nextElem = buttonset;
        }

        if (!buttonset.length) {
          return;
        }

        if (this.shouldBeFullWidth()) {
         // width = '100%';

          if (this.toolbarParent.closest('.header').length) {
            //width = 'calc(100% - 40px)';
			if (window.innerWidth > 640 ) {
				width = '200px';
			}
          }

          this.openWidth = width;
          return;
        }

        // Figure out boundaries
        // +10 on the left boundary reduces the likelyhood that the toolbar pushes other elements
        // into the spillover menu whenever the searchfield opens.
        var leftBoundary = buttonset.offset().left + 10;
        var rightBoundary = this.inputWrapper.next();

        // If the search input sits alone, just use the other side of the buttonset to measure
        if (!rightBoundary.length) {
          rightBoundary = buttonset.offset().left + buttonset.outerWidth(true);
        }

        width = this.getFillSize(leftBoundary, rightBoundary);
        //this.openWidth = width + 'px';
		this.openWidth = "auto";
      },

      isActive: function() {
        return this.inputWrapper.hasClass('is-active');
      },

      adjustOnBreakpoint: function() {
        var isFullWidth = this.shouldBeFullWidth(),
          hasStyleAttr = this.inputWrapper.attr('style');

        if (this.isActive()) {
          this.deactivate();
        }

        if (!isFullWidth && !hasStyleAttr) {
          this.calculateOpenWidth();
        }
      },

      activate: function() {
        if (this.inputWrapper.hasClass('active')) {
          return;
        }

        var self = this,
          notFullWidth = !this.shouldBeFullWidth();

        if (this.animationTimer) {
          clearTimeout(this.animationTimer);
        }

        // Places the input wrapper into the toolbar on smaller breakpoints
        if (!notFullWidth) {
			// mludwig, not needed for our help system
        }

        this.inputWrapper.addClass('active');
        this.handleDeactivationEvents();

        function activateCallback() {
          self.inputWrapper.addClass('is-open');
          self.calculateOpenWidth();
          self.setOpenWidth();
          self.input.focus(); // for iOS
          self.toolbarParent.trigger('recalculateButtons');
          self.inputWrapper.triggerHandler('activated');
        }

        if (this.settings.collapsible === false && !this.shouldBeFullWidth()) {
          activateCallback();
          return;
        }

        this.animationTimer = setTimeout(activateCallback, 0);
      },

      deactivate: function() {
        var self = this,
          textMethod = 'removeClass';

        function closeWidth() {
          if (self.settings.collapsible || self.shouldBeFullWidth()) {
            self.inputWrapper.removeAttr('style');
          }
        }

        if (this.input.val().trim() !== '') {
          textMethod = 'addClass';
        }
        this.inputWrapper[textMethod]('has-text');

        if (this.animationTimer) {
          clearTimeout(this.animationTimer);
        }

        function deactivateCallback() {
          if ($('#textToSearch').val() === '') {
            self.inputWrapper.removeClass('is-open');
          }         
          self.fastActivate = false;

          closeWidth();

          if (self.button && self.button.length && self.button.is('.is-open')) {
            self.button.data('popupmenu').close(false, true);
          }

          self.toolbarParent.trigger('recalculateButtons');
          self.inputWrapper.trigger('deactivated');
        }

        // Puts the input wrapper back where it should be if it's been moved due to small form factors.
        if (this.inputWrapper.parent().is(this.containmentParent)) {
          // Not currently using
        }

        self.inputWrapper.removeClass('active').removeClass('has-focus');
        if (this.fastActivate || this.settings.collapsible === false) {
          deactivateCallback();
          return;
        }

        this.animationTimer = setTimeout(deactivateCallback, 0);
      },

      shouldBeFullWidth: function() {
        var header = this.inputWrapper.closest('.header'),
          headerWidth = header.width(),
          windowWidth = $(window).width();

        return windowWidth < 767 || (header.length > 0 && headerWidth < 377);
      },

      // Used when the control has its settings or structural markup changed.  Rebuilds key parts of the control that
      // otherwise wouldn't automatically update.
      updated: function() {
        return this
          .teardown()
          .init();
      },

      enable: function() {
        this.inputWrapper.addClass('is-disabled');
        this.input.prop('disabled', true);
      },

      disable: function() {
        this.inputWrapper.removeClass('is-disabled');
        this.input.prop('disabled', false);
      },

      // Tears down events, properties, etc. and resets the control to "factory" state
      teardown: function() {
        this.inputWrapper.off('mousedown.toolbarsearchfield focusin.toolbarsearchfield');

        // Used to determine if the "Tab" key was involved in switching focus to the searchfield.
        $(document).off('keydown.' + this.id);
        $('body').off('resize.' + this.id);

        return this;
      },

      // Removes the entire control from the DOM and from this element's internal data
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new ToolbarSearchfield(this, settings));
      }
    });
  };



/**
* Tooltip and Popover Control
*/

  $.fn.tooltip = function(options, args) {
    'use strict';

    // Settings and Options
    var pluginName = 'tooltip',
      defaults = {
        content: null, //Takes title attribute or feed content. Can be a function or jQuery markup
        offset: {top: 10, left: 10}, //how much room to leave
        placement: 'top',  //can be top/left/bottom/right/offset
        trigger: 'hover', //supports click and immediate and hover (and maybe in future focus)
        title: null, //Title for Infor Tips
        beforeShow: null, //Call back for ajax tooltip
        popover: null , //force it to be a popover (no content)
        closebutton: true, //Show X close button next to title in popover
        isError: false, //Add error classes
        isErrorColor: false, //Add error color only not description
        tooltipElement: null, // ID selector for an alternate element to use to contain the tooltip classes
        parentElement: null, // jQuery-wrapped element that gets passed to the 'place' behavior as the element to place the tooltip against.  Defaults to "this.element" in tooltip, if not set.
        keepOpen: false, // Forces the tooltip to stay open in situations where it would normally close.
        extraClass: null, // Extra css class
        maxWidth: null // Toolip max width
      },
      settings = $.extend({}, defaults, options);

    function Tooltip(element) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    Tooltip.prototype = {
      init: function() {
        this.setup();
        this.appendTooltip();

        // Initial Content Setting.
        // Don't do this if we're using an "immediate" trigger because _setContent()_ is handled at
        // display time in that case.
        var shouldRender = this.settings.trigger !== 'immediate';
        if (shouldRender) {
          this.setContent(this.settings.content, true);
        }

        this.handleEvents();
      },

      setup: function() {
        // "this.activeElement" is the target element that the Tooltip will display itself against
        this.activeElement = this.settings.parentElement instanceof $ && this.settings.parentElement.length ? this.settings.parentElement : this.element;
        this.descriptionId = $('.tooltip-description').length + 1;
        this.description = this.element.parent().find('.tooltip-description');
        if (!this.description.length && this.settings.isError) {
          this.description = $('<span id="tooltip-description-'+ this.descriptionId +'" class="tooltip-description audible"></span>').insertAfter(this.element);
        }

        if (this.element.is('.dropdown, .multiselect')) {
          this.activeElement = this.element.nextAll('.dropdown-wrapper:first').find('>.dropdown');
        }

        var titleAttr = this.element.attr('title');
        if (titleAttr && titleAttr.length) {
          this.settings.content = titleAttr;
          this.element.removeAttr('title');
        }
	
        this.isPopover = (this.settings.content !== null && typeof this.settings.content === 'object') || this.settings.popover === true;

        this.settings.closebutton = (this.settings.closebutton || this.element.data('closebutton')) ? true : false;

        if (this.element.data('extraClass') && this.element.data('extraClass').length) {
          this.settings.extraClass = this.element.data('extraClass');
        }

        this.isRTL = Locale.isRTL();
      },

      addAria: function() {
        if (!this.content) {
          return;
        }

        this.description.text(this.content);
        this.content = this.addClassToLinks(this.content, 'links-clickable');

        if (!this.isPopover) {
          this.element.removeAttr('title').attr('aria-describedby', this.description.attr('id'));
        }

        if (this.isPopover && this.settings.trigger === 'click') {
          this.element.attr('aria-haspopup', true);
        }
      },

      addClassToLinks: function(content, thisClass) {
        var isjQuery = (content instanceof $ && content.length > 0);
        if (isjQuery) {
          return content;
        }

        var d = $('<div/>').html(content);
        $('a', d).addClass(thisClass);
        return d.html();
      },

      appendTooltip: function() {
        this.tooltip = this.settings.tooltipElement ? $(this.settings.tooltipElement) : $('#tooltip');
        if (!this.tooltip.length) {
			// mludwig, deleting div for .arrow
          var name = (this.settings.tooltipElement ? this.settings.tooltipElement.substring(1, this.settings.tooltipElement.length) : 'tooltip');
          this.tooltip = $('<div class="' + (this.isPopover ? 'popover' : 'tooltip') + ' bottom is-hidden" role="tooltip" id="' + name + '"><div class="tooltip-content"></div></div>');
        }

        this.tooltip.place({
          container: this.scrollparent,
          parent: this.activeElement,
          placement: this.settings.placement,
          strategy: 'flip'
        });

        this.setTargetContainer();
      },

      handleEvents: function() {
        var self = this, timer, delay = 4000;

        if (this.settings.trigger === 'hover' && !this.settings.isError) {
          this.element
            .on('mouseenter.tooltip', function() {
              timer = setTimeout(function() {
                self.show();
              }, delay);
            })
            /*.on('mouseleave.tooltip mousedown.tooltip click.tooltip mouseup.tooltip', function() {
                clearTimeout(timer);
                setTimeout(function() {
                  self.hide();
                }, delay);
            })*/
            .on('updated.tooltip', function() {
              self.updated();
            });
        }
		if (this.settings.trigger === 'click' && !this.settings.isError) {
			$('.buttonset.copy-url, #menucopy').off('click.tooltip');
			$('.buttonset.copy-url, #menucopy').on('click.tooltip',function(e) {				
				e.preventDefault();
				$("#popover-contents-click-right p",window.document).text(Locale.translate('CopyUrlMsg'));
				toggleTooltipDisplay();
				var copiedURL = inforhelp.copyURL();
				var $temp = $("<input id='temptext' type='text' style='display:block'></input>");		
				$temp.text(copiedURL);
				$("body",window.document).append($temp);
				var texttocopy = $("#temptext").get(0);
				var area = $('#temptext')[0],
					sel;
				area.value = copiedURL;	
				area.focus();
				area.select();
				sel = area.value.substring(
					area.selectionStart,
					area.selectionEnd
					);

				document.execCommand('copy'); 
				$('#temptext').remove();
			})
			.on('mouseleave.tooltip mousedown.tooltip click.tooltip mouseup.tooltip', function() {
                clearTimeout(timer);
                setTimeout(function() {
                  self.hide();
                }, delay);
            });
			if (!varstore.isCollection) {
				const pdfjspath = "oxyhelp7-pdf.js";
				inforhelp.checkpdfjs(pdfjspath,function(pdfjsexists,pdfFilename) {
					if (!pdfjsexists) {
						$('.buttonset.pdf, #printpdf').off('click.tooltip');
						$('.buttonset.pdf, #printpdf').on('click.tooltip',function(e) {				
							e.preventDefault();
							$("#popover-contents-click-right p",window.document).attr('class','pdftext');
							$("#popover-contents-click-right p",window.document).text("No PDF available");
							toggleTooltipDisplay();
						})						
						.on('mouseleave.tooltip mousedown.tooltip click.tooltip mouseup.tooltip', function() {
							clearTimeout(timer);
							setTimeout(function() {
							  self.hide();
							}, delay);
						});					
					}						
				});								
			}			
		}

        function toggleTooltipDisplay() {
          if (!self.tooltip.hasClass('is-hidden')) {
            self.hide();
          }
		  self.show();
		  //mludwig, add any needed checks on validity or content
		  /*var checkURL = inforhelp.copyURL();
		  if (checkURL != "query" && checkURL.indexOf("query=") == -1) {
			self.show();
		  if (checkURL != "query" && checkURL.indexOf("query=") == -1) {
			  self.show();
		  }
		  else {
			  // in order to do nothing if on search results page when CopyURL is clicked, not supported yet
			  return;
		  }*/
        }
		// mludwig, maybe I don't need this since I set popover click already
        if (this.settings.trigger === 'click') {
         this.element.on('click.tooltip', function() {
           toggleTooltipDisplay();
          });
        }

        if (this.settings.trigger === 'immediate') {
          timer = setTimeout(function() {
            toggleTooltipDisplay();
          }, 1);
        }

        // Uncomment the line below to get focus support on some elements all the time, regardless of trigger setting.
        //var isFocusable = (this.element.filter('button, a').length && this.settings.trigger !== 'click') || this.settings.trigger === 'focus';
        var isFocusable = this.settings.trigger === 'focus';
        if (isFocusable) {
          this.element.on('focus.tooltip', function() {
            self.show();
          })
          .on('blur.tooltip', function() {
            if (!self.settings.keepOpen) {
              self.hide();
            }
          });
        }

        // Media Query Listener to detect a menu closing on mobile devices that change orientation.
        this.matchMedia = window.matchMedia('(orientation: landscape)');
        this.mediaQueryListener = function() {
          // Match every time.
          if (self.tooltip.hasClass('is-hidden')) {
            return;
          }
          self.close();
        };
        this.matchMedia.addListener(this.mediaQueryListener);
      },

      setContent: function(content, dontRender) {
        var self = this,
          specified,
          settingsContent = this.settings.content,
          noIncomingContent = (content === undefined || content === null),
          noSettingsContent = (settingsContent === undefined || settingsContent === null);

        function doRender() {
          if (dontRender === true) {
            return;
          }
          self.addAria();
          self.render();
        }

        // If all sources of content are undefined, just return false and don't show anything.
        if (noIncomingContent && noSettingsContent) {
          return false;
        }

        // If the settingsContent type is a function, we need to re-run that function to update the content.
        // NOTE: If you need to use a function to generate content, understand that the tooltip/popover will not
        // cache your content for future reuse.  It will ALWAYS override incoming content.
        if (typeof settingsContent === 'function') {
          content = settingsContent;
        }

        // Use the pre-set content if we have no incoming content
        if (noIncomingContent) {
          content = settingsContent;
        }

        // If the incoming/preset content is exactly the same as the stored content, don't continue with this step.
        // Deep object comparison for jQuery objects is done further down the chain.
        if (content === this.content) {
          doRender();
          return true;
        }

        // jQuery-wrapped elements don't get manipulated.
        // Simply store the reference, render, and return.
        if (content instanceof $ && content.length) {
          this.content = content;
          doRender();
          return true;
        }

        // Handle setting of content based on its Object type.
        // If type isn't handled, the tooltip will not display.
        if (typeof content === 'string') {
          if (!content.length) {
            return false;
          }

          // Could be a translation definition
          content = Locale.translate(content) || content;

          // Could be an ID attribute
          // If it matches an element already on the page, grab that element's content and store the reference only.
          if (content.indexOf('#') === 0) {
            var contentCheck = $('' + content);
            if (contentCheck.length) {
              this.content = contentCheck;
              doRender();
              return true;
            }
            return false;
          }

        // functions
        } else if (typeof content === 'function') {
          var callbackResult = content.call(this.element);
          if (!callbackResult || typeof callbackResult !== 'string' || !callbackResult.length) {
            return false;
          }
          content = callbackResult;

        // if type isn't handled, return false
        } else {
          return false;
        }

        // Store an internal copy of the processed content
        this.content = content;

        // Wrap tooltip content in <p> tags if there isn't already one present.
        // Only happens for non-jQuery markup.
        if (!specified) {
          this.content = '<p>' + this.content + '</p>';
        }

        doRender();
        return true;
      },

      render: function() {
        if (this.isPopover) {
          return this.renderPopover();
        }
        return this.renderTooltip();
      },

      renderTooltip: function() {
        var titleArea = this.tooltip.find('.tooltip-title'),
          contentArea = this.tooltip.find('.tooltip-content'),
          cssClass = 'tooltip' + (this.settings.extraClass ? ' ' + this.settings.extraClass : '') + ' is-hidden',
          content = this.content;

        this.tooltip.attr('class', cssClass);
        titleArea.hide();

        // Generate an arrow if one doesn't already exist
        if (contentArea.prev('.arrow').length === 0) {
          contentArea.before('<div class="arrow"></div>');
        }

        if (typeof content === 'string') {
          content = $(content);
        }

        contentArea.text(content).removeClass('hidden');
        content.removeClass('hidden');
      },

      renderPopover: function() {
        var self = this,
          cssClass = 'popover' + (this.settings.extraClass ? ' ' + this.settings.extraClass : '') + ' is-hidden',
          contentArea = this.tooltip.find('.tooltip-content'),
          content = this.content;

        if (typeof this.content === 'string') {
          content = $(content);
        }

        // Use currently-set content to render a popover
        contentArea.html(content).removeClass('hidden');
        content.removeClass('hidden');

        this.tooltip.attr('class', cssClass);

        if (this.settings.title !== null) {
          var title = this.tooltip.find('.tooltip-title');
          if (title.length === 0) {
            title = $('<div class="tooltip-title"></div>').prependTo(this.tooltip);
          }
          title.text(this.settings.title).show();
        } else {
          this.tooltip.find('.tooltip-title').hide();
        }
        if (this.settings.closebutton) {
          var closeBtnX = $(
            '<button type="button" class="btn-icon l-pull-right" style="margin-top: -9px">'+
              $.createIcon({ classes: ['icon-close'], icon: 'close' }) +
              '<span>Close</span>'+
            '</button>'
          ).on('click', function() {
            self.hide();
          });
          $('.tooltip-title', this.tooltip).append(closeBtnX);
        }
        content.initialize();
      },

      // Alias for _show()_.
      open: function() {
        return this.show();
      },

      show: function(newSettings, ajaxReturn) {
        var self = this;
        this.isInPopup = false;

        if (newSettings) {
          this.settings = $.extend({}, this.settings, newSettings);
        }

        if (this.settings.beforeShow && !ajaxReturn) {
          var response = function (content) {
            self.show({content: content}, true);
          };

          if (typeof this.settings.beforeShow === 'string') {
            window[this.settings.beforeShow](response);
            return;
          }

          this.settings.beforeShow(response);
          return;
        }

        var okToShow = true;

        okToShow = this.setContent(this.content);
        if (okToShow === false) {
          return;
        }

        okToShow = this.element.triggerHandler('beforeshow', [this.tooltip]);
        if (okToShow === false) {
          return;
        }

        this.tooltip.removeAttr('style');
        this.tooltip.addClass(this.settings.placement);

        if (this.settings.isError || this.settings.isErrorColor) {
          this.tooltip.addClass('is-error');
        }

        this.position();
        this.element.trigger('show', [this.tooltip]);

        setTimeout(function () {
          $(document).on('mouseup.tooltip', function (e) {

            if (self.settings.isError || self.settings.trigger === 'focus') {
             return;
            }

            if ($(e.target).is(self.element) && $(e.target).is('svg.icon')) {
              return;
            }

            if ($(e.target).closest('.popover').length === 0 &&
                $(e.target).closest('.dropdown-list').length === 0) {
              self.hide(e);
            }
          })
          .on('keydown.tooltip', function (e) {
            if (e.which === 27 || self.settings.isError) {
              self.hide();
            }
          });

          if (self.settings.isError && !self.element.is(':visible') && !self.element.is('.dropdown')) {
            self.hide();
          }

          if (window.orientation === undefined) {
            $('body').on('resize.tooltip', function() {
              self.hide();
            });
          }

          // Click to close
          if (self.settings.isError) {
            self.tooltip.on('click.tooltip', function () {
              self.hide();
            });
          }

          self.element.trigger('aftershow', [self.tooltip]);
        }, 400);

      },

      // Places the tooltip element itself in the correct DOM element.
      // If the current element is inside a scrollable container, the tooltip element goes as high as possible in the DOM structure.
      setTargetContainer: function() {
        var targetContainer = $('body');

        // adjust the tooltip if the element is being scrolled inside a scrollable DIV
        this.scrollparent = this.element.closest('.page-container.scrollable');
        if (this.scrollparent.length) {
          targetContainer = this.scrollparent;
        }

        this.tooltip.detach().appendTo(targetContainer);
      },

      // Placement behavior's "afterplace" handler.
      // DO NOT USE FOR ADDITONAL POSITIONING.
      handleAfterPlace: function(e, placementObj) {
        this.tooltip.data('place').setArrowPosition(e, placementObj, this.tooltip);
        this.tooltip.triggerHandler('tooltipafterplace', [placementObj]);
      },

      position: function () {
        this.setTargetContainer();
        this.tooltip.removeClass('is-hidden');

        var self = this,
          distance = this.isPopover ? 40 : 10,
          tooltipPlacementOpts = this.settings.placementOpts || {},
          opts = $.extend({}, tooltipPlacementOpts, {
            x: 0,
            y: distance,
            container: this.scrollparent,
            containerOffsetX: tooltipPlacementOpts.containerOffsetX || this.settings.offset.left,
            containerOffsetY: tooltipPlacementOpts.containerOffsetY || this.settings.offset.top,
            parent: tooltipPlacementOpts.parent || this.activeElement,
            placement: tooltipPlacementOpts.placement || this.settings.placement,
            strategies: ['flip', 'nudge']
          });
        if (opts.placement === 'left' || opts.placement === 'right') {
          opts.x = distance;
          opts.y = 0;
        }

        this.tooltip.one('afterplace.tooltip', function(e, placementObj) {
          self.handleAfterPlace(e, placementObj);
        });

        this.tooltip.data('place').place(opts);
        return this;
      },

      // Alias for _hide()_ that works with the global _closeChildren()_ method.
      close: function() {
        return this.hide();
      },

      hide: function() {
        if (this.settings.keepOpen) {
          return;
        }

        if (this.isInPopup) {
          this.settings.content.addClass('hidden');
          return;
        }

        this.tooltip.addClass('is-hidden').css({'left': '', 'top': ''});
        this.tooltip.find('.arrow').removeAttr('style');

        this.tooltip.off('click.tooltip');

        if ($('.popover').not('.is-hidden').length === 0) {
          $(document).off('mouseup.tooltip keydown.tooltip');
          $(window).off('resize.tooltip');
        }

        this.element.trigger('hide', [this.tooltip]);
      },

      updated: function() {
        var self = this;

        if (settings.trigger === 'immediate') {
          setTimeout(function() {
            self.show();
          }, 100);
        } else {
          self.setContent();
        }

        return this;
      },

      teardown: function() {
        this.description.remove();
        this.descriptionId = undefined;
        this.element.removeAttr('aria-describedby').removeAttr('aria-haspopup');
        if (!this.tooltip.hasClass('is-hidden')) {
          this.hide();
        }

        this.element.off('mouseenter.tooltip mouseleave.tooltip mousedown.tooltip click.tooltip focus.tooltip blur.tooltip');

        if (this.matchMedia) {
          this.matchMedia.removeListener(this.mediaQueryListener);
        }

        return this;
      },

      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initializing the Control Once or Call Methods.
    return this.each(function() {

      var instance = $.data(this, pluginName);
      //Allow one tooltip and one popover
      if (instance /*&& (instance.settings.popover == null || instance.settings.popover !== settings.popover)*/) {
        if (typeof instance[options] === 'function') {
          instance[options](args);
        }

        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();

        return;
      }
	  var currElement = $(this);
	  if (currElement.data('popover') != undefined && currElement.data('popover') != "") {
		  instance = $.data(this, pluginName, new Tooltip(this, settings));
	  }
      
    });
  };

  // Popover & Tooltip are the same control
  $.fn.popover = $.fn.tooltip;

/**
* Tree Control (Deleted, not used)
*/


/**
* Validation Plugin, removed from here
*/

  //Add a Message to a Field
  $.fn.addError = function(options) {
    var defaults = {message: '', showTooltip: false, inline: true},
      settings = $.extend({}, defaults, options);

    return this.each(function() {
      var instance = new Validator(this, settings);
      instance.addError($(this), settings.message, settings.inline, settings.showTooltip);
    });
  };

  //Remove a Message from a Field
  $.fn.removeError = function(options) {
    var defaults = {message: ''},
      settings = $.extend({}, defaults, options);

    return this.each(function() {
      var instance = new Validator(this, settings);
      instance.removeError($(this));
    });
  };

  $.fn.validate = function(options, args) {
    // Settings and Options
    var pluginName = 'validate',
      defaults = {
        inline: true
      },
      settings = $.extend({}, defaults, options);

    // Initializing the Control Once or Call Methods.
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        if (typeof instance[options] === 'function') {
          instance[options](args);
        }
        instance.settings = $.extend({}, defaults, options);
      } else {
        instance = $.data(this, pluginName, new Validator(this, settings));
        instance.attachEvents();
      }
    });
  };

  //The validation rules object
  var Validation = function () {
    var self = this;
    this.rules = {
      required: {
        isNotEmpty: function(value, field) {
          var supportsPlaceholder = !!('placeholder' in document.createElement('input'));

          if (!supportsPlaceholder && field &&
              (value === field.attr('placeholder') || value === Locale.translate('Required'))) {
            return false;
          }

          if (typeof value === 'string') {
            // strip out any HTML tags and focus only on text content.
            value = $.trim(value.replace(/<\/?[^>]*>/g, ''));
            if ($.trim(value).length === 0) {
              return false;
            }
            return true;
          }

          return (value ? true : false);
        },

        // Check if at least one radio button checked in group
        isRadioChecked: function (field) {
          var name = field.attr('name');
          return (name && name.length && $('input[name="'+ name +'"]:radio:checked').length);
        },

        check: function (value, field) {
          var self = this;

          //Check all required fields filled on modal

          var allFilled = true;
          field.closest('.modal').find('input.required, textarea.required, select.required').each(function () {
            if (!self.isNotEmpty($(this).val())) {
              allFilled = false;
            }
          });

          if (allFilled) {
            field.closest('.modal').find('.btn-modal-primary').not('.no-validation').removeAttr('disabled');
          } else {
            field.closest('.modal').find('.btn-modal-primary').not('.no-validation').attr('disabled', 'disabled');
          }

          this.message = Locale.translate('Required');
          return field.is(':radio') ? this.isRadioChecked(field) : this.isNotEmpty(value, field);
        },
        message: 'Required'
      },

      //date: Validate date, datetime (24hr or 12hr am/pm)
      date: {
        check: function (value, field) {
          this.message = Locale.translate('InvalidDate');

          if (value instanceof Date) {
            return value && value.getTime && !isNaN(value.getTime());
          }

          var dateFormat = (value.indexOf(':') > -1) ? Locale.calendar().dateFormat.datetime: Locale.calendar().dateFormat.short;

          if (field && field.data('datepicker')) {
            dateFormat = field.data('datepicker').pattern;
          }

          var parsedDate = Locale.parseDate(value, dateFormat, true);
          return ((parsedDate === undefined) && value !== '') ? false : true;
        },
        message: 'Invalid Date'
      },

      //Validate date, disable dates
      availableDate: {
        check: function (value, field) {
          this.message = Locale.translate('UnavailableDate');
          var check = true;

          if(value !== '' && self.rules.date.check(value)) { //if valid date
            var d, i, l, min, max,
              d2 = new Date(value),
              options = field.data('datepicker').settings;

            if (options) {

              min = (new Date(options.disable.minDate)).setHours(0,0,0,0);
              max = (new Date(options.disable.maxDate)).setHours(0,0,0,0);

              //dayOfWeek
              if(options.disable.dayOfWeek.indexOf(d2.getDay()) !== -1) {
                check = false;
              }

              d2 = d2.setHours(0,0,0,0);

              //min and max
              if((d2 <= min) || (d2 >= max)) {
                check = false;
              }

              //dates
              if (options.disable.dates.length && typeof options.disable.dates === 'string') {
                options.disable.dates = [options.disable.dates];
              }
              for (i=0, l=options.disable.dates.length; i<l; i++) {
                d = new Date(options.disable.dates[i]);
                if(d2 === d.setHours(0,0,0,0)) {
                  check = false;
                  break;
                }
              }
            }
            check = ((check && !options.disable.isEnable) || (!check && options.disable.isEnable)) ? true : false;
          }

          return check;
        },
        message: 'Unavailable Date'
      },

      email: {
        check: function (value) {
          this.message = Locale.translate('EmailValidation');
          var regex = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,16}(?:\.[a-z]{2})?)$/i;

          return (value.length) ? regex.test(value) : true;
        },
        message: 'EmailValidation'
      },

      enableSubmit: {
        check: function (value, field) {
          var submit = field.closest('.signin').find('button[type="submit"]'),
            ok = ((value.length) && (self.rules.email.check(value) || self.rules.passwordConfirm.check(value, field)));

          if (ok) {
            submit.enable();
          } else {
            submit.disable();
          }
          return true;
        },
        message: ''
      },

      emailPositive: {
        check: function (value, field) {
          if($.trim(value).length && !field.is('[readonly]')) {
            self.rules.emailPositive.positive = true;
            this.message = Locale.translate('EmailValidation');

            var isValid = self.rules.email.check(value, field);

            if (isValid) {
              this.message = '';
            }

            return isValid;
          } else {
            self.rules.emailPositive.positive = false;
            return true;
          }
        },
        message: 'EmailValidation'
      },

      passwordReq: {
        check: function (value) {
         this.message = Locale.translate('PasswordValidation');
          /* Must be at least 10 characters which contain at least
          ** one lowercase letter,
          ** one uppercase letter,
          ** one numeric digit
          ** and one special character */
          var regex = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?=.*[^a-zA-Z0-9])(?!.*\s).{10,}$/;
          return (value.length) ? value.match(regex) : true;
        },
        message: 'PasswordValidation'
      },

      passwordConfirm: {
        check: function (value, field) {
          this.message = Locale.translate('PasswordConfirmValidation');
          var passwordValue = $('input[type="password"]:not('+ field.attr('id') +')', field.closest('.signin')).eq(0).val(),
            check = ((value === passwordValue) && (self.rules.passwordReq.check(passwordValue)));
          return (value.length) ? check : true;
        },
        message: 'PasswordConfirmValidation'
      },

      time: {
        check: function(value, field) {
          value = value.replace(/ /g, '');
          this.message = Locale.translate('InvalidTime');
          var timepickerSettings = field && field.data('timepicker') ? field.data('timepicker').settings : {},
            pattern = timepickerSettings && timepickerSettings.timeFormat ? timepickerSettings.timeFormat : Locale.calendar().timeFormat,
            is24Hour = (pattern.match('HH') || []).length > 0,
            maxHours = is24Hour ? 24 : 12,
            colon = value.indexOf(Locale.calendar().dateFormat.timeSeparator),
            valueHours = 0,
            valueMins,
            valueM;

          if (value === '') {
            return true;
          }

          valueHours = parseInt(value.substring(0, colon));
          valueMins = parseInt(value.substring(colon + 1, colon + 3));

          if (valueHours.toString().length < 1 || isNaN(valueHours) || parseInt(valueHours) < 0 || parseInt(valueHours) > maxHours) {
            return false;
          }
          if (valueMins.toString().length < 1 || isNaN(valueMins) || parseInt(valueMins) < 0 || parseInt(valueMins) > 59) {
            return false;
          }

          // AM/PM
          if (!is24Hour) {
            if (parseInt(valueHours) < 1) {
              return false;
            }
            var period0 = new RegExp(Locale.calendar().dayPeriods[0], 'i'),
              period1 = new RegExp(Locale.calendar().dayPeriods[1], 'i');

            valueM = value.match(period0) || value.match(period1) || [];
            if (valueM.length === 0) {
              return false;
            }
          }

          return true;
        },
        message: 'Invalid Time'
      },

      //Test validation function, always returns false
      test: {

        check: function(value) {
          return value === '1' ? true : false;
        },

        message: 'Value is not valid (test).'
      }
    };
  };

  $.fn.validation = new Validation();

  $.fn.isValid = function() {
    return ($(this).data('isValid') ? true : false);
  };

  //Clear out the stuff on the Form
  $.fn.resetForm = function() {
    var formFields = $(this).find('input, select, textarea');

    //Clear Errors
    formFields.removeClass('error');
    $(this).find('.error').removeClass('error');
    $(this).find('.icon-error').remove();
    $(this).find('.icon-confirm').remove();
    $(this).find('.error-message').remove();

    setTimeout(function () {
      $('#validation-errors').addClass('is-hidden');
    }, 300);

    //Remove Dirty
    formFields.data('isDirty', false).removeClass('isDirty');
    $(this).find('.isDirty').removeClass('isDirty');

    //reset form data
    if ($(this).is('form')) {
      $(this)[0].reset();
    }
  };

/**
* Wizard Control (TODO: bitly link to soho xi docs) (Deleted, not used)
*/

/**
* Zoom Behavior (TODO: bitly link to soho xi docs)
*/

// NOTE:  There are AMD Blocks available


  //NOTE: Just this part will show up in SoHo Xi Builds.

  $.fn.zoom = function(options) {
    'use strict';

    // Settings and Options
    var pluginName = 'zoom',
        settings = $.extend({}, options);

    // Plugin Constructor
    function Zoom(element, settings) {
      this.settings = $.extend({}, settings);
      this.element = $(element);
      Soho.logTimeStart(pluginName);
      this.init();
      Soho.logTimeEnd(pluginName);
    }

    Zoom.prototype = {
      init: function() {
        return this
          .build()
          .handleEvents();
      },

      // Add markup to the control
      build: function() {
        // setup environment
        this.env = {
          'iOS': $('html').hasClass('ios'),
          'iPhone': $('html').hasClass('iPhone'),
          'iPad': $('html').hasClass('iPad'),
          'iPod': $('html').hasClass('iPod')
        };

        // get references to elements
        this.viewport = this.element.find('meta[name=viewport]');
        this.body = $('body');

        return this;
      },

      // Sets up event handlers for this control and its sub-elements
      handleEvents: function() {
        var self = this;

        // Allow the head to listen to events to globally deal with the zoom problem on
        // a per-control basis (for example, Dropdown/Multiselect need to handle this issue manually).
        this.element.on('updated.' + pluginName, function() {
          self.updated();
        }).on('enable-zoom', function() {
          self.enableZoom();
        }).on('disable-zoom', function() {
          self.disableZoom();
        });

        // Don't continue setting this up on each element if
        if (!this.env.iOS) {
          return this;
        }

        // Setup conditional events for all elements that need it.
        this.body.on('touchstart.zoomdisabler', 'input, label', function() {
          if (self.noZoomTimeout) {
            return;
          }

          self.disableZoom();
        }).on('touchend.zoomdisabler', 'input, label', function() {
          if (self.noZoomTimeout) {
            clearTimeout(self.noZoomTimeout);
            self.noZoomTimeout = null;
          }
          self.noZoomTimeout = setTimeout(function() {
            self.noZoomTimeout = null;
            self.enableZoom();
          }, 600);
        });

        return this;
      },

      // TODO: Test to see if prepending this meta tag conflicts with Base Tag implementation
      enableZoom: function() {
        this.viewport.remove();

        this.viewport = $('<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=1" />');
        this.element.prepend(this.viewport);
      },

      // TODO: Test to see if prepending this meta tag conflicts with Base Tag implementation
      disableZoom: function() {
        this.viewport.remove();

        this.viewport = $('<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0" />');
        this.element.prepend(this.viewport);
      },

      // Handle Updating Settings
      updated: function() {
        return this
          .teardown()
          .init();
      },

      // Simple Teardown - remove events & rebuildable markup.
      teardown: function() {
        this.element.off('updated.' + pluginName + ' enable-zoom disable-zoom');
        this.body.off('touchstart.zoomdisabler touchend.zoomdisabler');
        return this;
      },

      // Teardown - Remove added markup and events
      destroy: function() {
        this.teardown();
        $.removeData(this.element[0], pluginName);
      }
    };

    // Initialize the plugin (Once)
    return this.each(function() {
      var instance = $.data(this, pluginName);
      if (instance) {
        instance.settings = $.extend({}, instance.settings, options);
        instance.updated();
      } else {
        instance = $.data(this, pluginName, new Zoom(this, settings));
      }
    });
  };

// DRAG

  /* eslint-disable no-cond-assign */
  // Similar: https://github.com/desandro/draggabilly
  // The name of this plugin

  var COMPONENT_NAME$2 = 'drag';
  /**
   * Drag/Drop functions with touch support.
   * @class Drag
   * @constructor
   *
   * @param {jQuery[]|HTMLElement} element The component element.
   * @param {object} [settings] The component settings.
   * @param {string} [settings.axis]  Constrains dragging to either axis. Possible values: null, 'x', 'y'
   * @param {boolean} [settings.clone=false] Set to true to clone the object to drag. In many situations this is
   *  needed to break out of layout.
   * @param {string} [settings.cloneCssClass='is-clone'] Css class added to clone element (defaults is 'is-clone')
   * @param {boolean} [settings.clonePosIsFixed=false] If true cloned object will use css style "position: fixed"
   * @param {string} [settings.cloneAppendTo] Selector to append to for the clone
   * ['body'|'parent'|'jquery object'] default:'body'
   * @param {boolean} [settings.containment=false] Constrains dragging to within the bounds of the specified element
   *  or region. Possible values: "parent", "document", "window".
   * @param {string} [settings.obstacle] jQuery Selector of object(s) that you cannot drag into,
   * @param {boolean} [settings.underElements=false] If set to true will return list of elements that are
   * underneath the drag element
   * @param {object} [settings.containmentOffset={left: 0, top: 0}] How close to the containment object should we be allowed
   * to drag in position form. `{left: 0, top: 0}`
  */

  var DRAG_DEFAULTS = {
    axis: null,
    clone: false,
    cloneCssClass: 'is-clone',
    clonePosIsFixed: false,
    cloneAppendTo: null,
    containment: false,
    obstacle: false,
    underElements: false,
    containmentOffset: {
      left: 0,
      top: 0
    }
  };

  function Drag(element, settings) {
    this.element = $(element);
    this.settings = mergeSettings(this.element[0], settings, DRAG_DEFAULTS);
    this.init();
  } // Plugin Methods


  Drag.prototype = {
    init: function init() {
      this.handleEvents();
    },

    /**
    * Trigger events and remove clone
    * @private
    * @param {number} left Current left position
    * @param {number} top Current top position
    */
    finish: function finish(left, top) {
      var pos = {
        top: top,
        left: left
      };
      this.element.off('mouseup.draggable');
      $(document).off('mousemove.draggable mouseup.draggable');

      if (this.settings.underElements) {
        pos.underElements = this.getElementsFromPoint(pos.left, pos.top);
      }

      pos.offset = this.offset;
      pos.clone = this.clone;
      /**
      * Fires after the drag is completed. Use this to remove / set drag feedback off.
      * @event dragend
      * @memberof Drag
      * @property {object} event - The jquery event object.
      * @property {object} ui - The dialog object
      */

      this.element.trigger('dragend', pos);
      this.element.removeClass('is-dragging');

      if (this.clone) {
        if (this.settings.axis === 'x') {
          delete pos.top;
        }

        if (this.settings.axis === 'y') {
          delete pos.left;
        } // this.element.css(pos);


        this.clone.remove();
        this.clone = null;
      } // Clear Cached Sizes


      if (this.obstacle) {
        this.obstacle = null;
      }

      if (this.upperYLimit) {
        this.upperYLimit = null;
      }

      if (this.upperXLimit) {
        this.upperXLimit = null;
      }

      $('body').removeClass('disable-select');
    },
    // Move the object from the event coords
    move: function move(left, top) {
      var self = this;
      var css = {
        left: left,
        top: top
      }; // X-Y Axis

      if (this.settings.axis === 'x') {
        delete css.top;
      }

      if (this.settings.axis === 'y') {
        delete css.left;
      }

      if (this.settings.containment) {
        if (this.settings.containment instanceof jQuery) {
          this.container = this.settings.containment;
        } else if (this.settings.containment === 'parent') {
          this.container = this.element.parent();
        } else if (this.settings.containment === 'window') {
          this.container = $(window);
        } else if (this.settings.containment === 'container') {
          this.container = this.element.closest('.page-container');
        } else {
          this.container = $(document);
        }

        if (!this.upperXLimit) {
          this.upperXLimit = this.container.width() - this.element.outerWidth() + this.settings.containmentOffset.left;
        }

        if (!this.upperYLimit) {
          this.upperYLimit = this.container.height() - this.element.outerHeight() + this.settings.containmentOffset.top;
        }

        if (css.top > this.upperYLimit) {
          css.top = this.upperYLimit;
        }

        if (css.left > this.upperXLimit) {
          css.left = this.upperXLimit;
        }

        if (css.top < 0) {
          css.top = 0;
        }

        if (css.left < 0) {
          //css.left = 0;
        }

        if (this.settings.containment === 'container' && css.left <= 1) {
          css.left = 1;
        }
      }

      if (this.settings.obstacle) {
        var elemOffset = this.clone ? this.clone.offset() : this.element.offset();
        var elemWidth = this.clone ? this.clone.outerWidth() : this.element.outerWidth();
        var movingRight = css.left > elemOffset.left; // Caching this so drag is not jaggie

        if (!this.obstacle) {
          this.obstacle = $(this.settings.obstacle).not(this.element);
          var obstacleOffset = $(this.obstacle).offset();
          this.constraints = {
            top: obstacleOffset.top,
            left: obstacleOffset.left,
            bottom: obstacleOffset.top + this.obstacle.outerHeight(),
            right: obstacleOffset.left + this.obstacle.outerWidth()
          };
        }

        if (!movingRight && self.originalPos.left > this.constraints.left && css.left <= this.constraints.right) {
          css.left = this.constraints.right;
        }

        if (movingRight && self.originalPos.left + elemWidth <= this.constraints.left && css.left + elemWidth >= this.constraints.left) {
          css.left = this.constraints.left - this.obstacle.outerWidth();
        }
      }

      var applyCssStyle = function applyCssStyle(el, applyCss, prop) {
        if (typeof applyCss[prop] !== 'undefined') {
          el[0].style[prop] = "".concat(applyCss[prop], "px");
        }
      };

      applyCssStyle(this.clone || this.element, css, 'top');
      applyCssStyle(this.clone || this.element, css, 'left');

      if (this.settings.underElements) {
        css.underElements = this.getElementsFromPoint(css.left, css.top);
      }

      css.offset = this.offset;
      css.clone = this.clone;
      /**
      * Fires (many times) while dragging is occuring. Use this for DOM feedback but
      * be careful about what you do in here for performance.
      * @event drag
      * @memberof Drag
      * @property {object} event - The jquery event object.
      * @property {object} ui - The dialog object
      */

      this.element.trigger('drag', css);
    },

    /**
    * Get elements from given point.
    * @param {number} x The x-coordinate of the Point.
    * @param {number} y The y-coordinate of the Point.
    * @Returns {array} List of all elements at the given point.
    */
    getElementsFromPoint: function getElementsFromPoint(x, y) {
      var elements = [];

      if (document.elementsFromPoint) {
        elements = document.elementsFromPoint(x, y);
      } else if (document.msElementsFromPoint) {
        elements = document.msElementsFromPoint(x, y);
      } else {
        var i;
        var l;
        var d;
        var current;
        var max = 999;
        var pointerEvents = [];

        while ((current = document.elementFromPoint(x, y)) && elements.indexOf(current) === -1 && current !== null && max > -1) {
          max--; // push the element and its current style

          elements.push(current);
          pointerEvents.push({
            value: current.style.getPropertyValue('pointer-events') || '',
            priority: current.style.getPropertyPriority('pointer-events')
          }); // add "pointer-events: none", to get to the underlying element

          current.style.setProperty('pointer-events', 'none', 'important');
        } // restore the previous pointer-events values


        for (i = 0, l = elements.length; i < l; i++) {
          d = pointerEvents[i];
          elements[i].style.setProperty('pointer-events', d.value, d.priority);
        }
      }

      return elements;
    },

    /**
     * Update the component and optionally apply new settings.
     * @param  {object} settings the settings to update to.
     */
    updated: function updated(settings) {
      if (settings) {
        this.settings = mergeSettings(this.element[0], settings, this.settings);
      }
    },

    /**
     * Detach all functionality and events.
     */
    destroy: function destroy() {
      $.removeData(this.element[0], COMPONENT_NAME$2);
      this.element.off('touchstart.draggable MSPointerDown.draggable pointerdown.draggable touchmove.draggable touchend.draggable touchcancel.draggable mousedown.draggable');
    },
    handleEvents: function handleEvents() {
      var self = this;
      self.offset = null; // Touch and Drag Support

      self.element.attr('draggable', !Environment.features.touch);

      if ('onpointerdown' in window || 'onmspointerdown' in window) ; else {
        // Touch-only Drag Support
        self.element.on('touchstart.draggable gesturestart.draggable', function (e) {
          var pos = $(this).position();
          var orig = e.originalEvent;
          self.offset = {
            x: orig.changedTouches[0].pageX - pos.left,
            y: orig.changedTouches[0].pageY - pos.top
          };
          self.originalPos = pos;
          self.element.addClass('is-dragging');
          pos.offset = self.offset;
          pos.clone = self.clone;
          /**
          * When the dragging is initiated. Use this to customize/style
          * the drag/drop objects in the DOM.
          * @event dragstart
          * @memberof Drag
          * @property {object} event - The jquery event object.
          * @property {object} ui - The dialog object
          */

          self.element.trigger('dragstart', pos);
        }) // Move
        .on('touchmove.draggable gesturechange.draggable', function (e) {
          e.preventDefault();
          var orig = e.originalEvent; // do now allow two touch points to drag the same element

          if (orig.targetTouches.length > 1) {
            return;
          }

          var xpos = orig.changedTouches[0].pageX - self.offset.x;
          var ypos = orig.changedTouches[0].pageY - self.offset.y;
          self.move(xpos, ypos);
        }) // Finish Touch Dragging
        .on('touchend.draggable gestureend.draggable touchcancel.draggable', function (e) {
          e.preventDefault();
          var touch = e.originalEvent.changedTouches[0];
          self.finish(touch.pageX - self.offset.x, touch.pageY - self.offset.y);
        });
      } // Always bind mousedown in either scenario, in the event that a mouse is used


      self.element.on('mousedown.draggable', function (e) {
        e.preventDefault();
        var pos = self.settings.clonePosIsFixed ? self.element[0].getBoundingClientRect() : self.element.position(); // Save offset
	  if (Locale.isRTL()) { 
		  pos.left = $('.sidebar')[0].offsetLeft + pos.left;
	  }
        self.offset = {
          x: e.pageX - pos.left,
          y: e.pageY - pos.top
        };
        self.originalPos = pos; // Prevent Text Selection

        $('body').addClass('disable-select'); // Handle Mouse Press over draggable element

        $(document).on('mousemove.draggable', function (mouseMoveEvent) {
          mouseMoveEvent.preventDefault();
          self.move(mouseMoveEvent.pageX - self.offset.x, mouseMoveEvent.pageY - self.offset.y);
        }); // Handle Mouse release over draggable element close out events and trigger

        $(document).on('mouseup.draggable', function (docMouseUpEvent) {
          docMouseUpEvent.preventDefault();
          self.finish(e.pageX - self.offset.x, docMouseUpEvent.pageY - self.offset.y);
        });
        self.element.on('mouseup.draggable', function (mouseUpEvent) {
          mouseUpEvent.preventDefault();
          self.finish(mouseUpEvent.pageX - self.offset.x, mouseUpEvent.pageY - self.offset.y);
        }); // Trigger dragging
        // Clone

        if (!self.clone && self.settings.clone) {
          self.clone = self.element.clone(true);

          if (self.settings.cloneAppendTo === 'parent') {
            self.settings.cloneAppendTo = self.element.parent();
          }

          self.clone.addClass(self.settings.cloneCssClass).appendTo(self.settings.cloneAppendTo || 'body');
        }

        self.element.addClass('is-dragging');
        self.element.trigger('dragstart', [pos, self.clone]);
      });
    }
  };

  /**
   * jQuery Component Wrapper for Drag
   * @param {object} [settings] incoming settings
   * @returns {jQuery[]} elements being acted on
   */

  $.fn.drag = function (settings) {
    return this.each(function () {
      var instance = $.data(this, COMPONENT_NAME$2);

      if (instance) {
        instance.updated(settings);
      } else {
        instance = $.data(this, COMPONENT_NAME$2, new Drag(this, settings));
      }
    });
  };
// SPLITTER
  var COMPONENT_NAME$13 = 'splitter'; // Default Splitter Options

  var SPLITTER_DEFAULTS = {
    axis: 'x',
    side: 'right',
    // or left
    resize: 'immediate',
    containment: null,
    // document or parent
    save: true,
    maxWidth: {
      left: 'auto',
      right: 'auto'
    },
    attributes: null
  };
  /**
  * Splitter Component
  * @class Splitter
  * @constructor
  * @param {string} element The component element.
  * @param {string} [settings] The component settings.
  * @param {string} [settings.axis = 'x'] The axis on which to split x or y
  * @param {string} [settings.side = 'left'] Which side to dock to 'left' or 'right'.
  * @param {string} [settings.resize = 'immediate'] When to resize, during the drag 'immediate' or 'end'
  * @param {HTMLElement|jQuery[]} [settings.containment = null] When to stop the splitter, this can be document, or a parent element
  * @param {boolean} [settings.save = true] If true the split size will automatically be saved for next time
  * @param {object} [settings.maxWidth = {left: 'auto', right: 'auto'}] Ability to stop dragging at a max left or right size.
  * @param {string} [settings.attributes=null] Add extra attributes like id's to the element. e.g. `attributes: { name: 'id', value: 'my-unique-id' }`
  */

  function Splitter(element, settings) {
    this.settings = mergeSettings(element, settings, SPLITTER_DEFAULTS);
    this.element = $(element);
    this.init();
  } // Plugin Methods


  Splitter.prototype = {
    /**
     * Do other init (change/normalize settings, load externals, etc)
     * @private
     * @returns {this} component instance
     */
    init: function init() {
      return this.build().handleEvents();
    },

    /**
     * Build the Control and Events
     * @private
     * @returns {void}
     */
    build: function build() {
      var _this = this;

      var self = this;
      var s = this.settings;
      var splitter = this.element;
      var parent = splitter.parent();
      var direction = s.axis === 'x' ? 'left' : 'top';
      var thisSide = parent.is('.content') ? parent.parent() : parent;
      var dragHandle = $("<div class=\"splitter-drag-handle\">".concat($.createIcon('drag'), "</div>"));
      var defaultOffset = 350;
      var w = parent.width();
      var parentHeight;
      this.isRTL = Locale.isRTL();
      setTimeout(function () {
        parentHeight = parent.height();
      }, 0);
      this.docBody = $('body');
      this.isSplitterRightSide = splitter.is('.splitter-right') || s.axis === 'x' && s.side === 'right';
      this.isSplitterHorizontal = splitter.is('.splitter-horizontal') || s.axis === 'y';
      s.uniqueId = uniqueId(this.element, 'splitter');
      dragHandle.appendTo(splitter);
      dragHandle.prepend("<span class=\"audible\">".concat(Locale.translate('SplitterDragHandle'), "</span>"));
	  // HANDLECOLLAPSEBUTTON SECTION (NOT USING)
      var handleCollapseButton = function handleCollapseButton() {
        var savedOffset = 0;
        var isClickedOnce = false;

        var splitAndRotate = function splitAndRotate(splitVal, el, isRotate) {
          self.splitTo(splitVal, parentHeight);
          $(el)[isRotate ? 'addClass' : 'removeClass']('rotate');
        };

        _this.splitterCollapseButton = $("<button type=\"button\" class=\"splitter-btn\" id=\"splitter-collapse-btn\"><span class=\"audible\">".concat(Locale.translate('SplitterCollapseButton'), "</span><svg class=\"icon\" focusable=\"false\" aria-hidden=\"true\" role=\"presentation\"><use href=\"#icon-double-chevron\"></use></svg></button>"));

        _this.splitterCollapseButton.appendTo(splitter);

        if (splitter[0].offsetLeft > 10) {
          _this.splitterCollapseButton.addClass('rotate');
        }

        _this.splitterCollapseButton.click(function () {
          var isDragging = splitter.is('is-dragging');

          if (isDragging) {
            return;
          }

          if (self.isRTL && !self.isSplitterHorizontal || !self.isSplitterRightSide && s.side === 'left' || self.isSplitterRightSide && s.side === 'right') {
            var containerWidth = self.getContainerWidth() - splitter.outerWidth();
            var x = containerWidth;
            if (!isClickedOnce) {
              savedOffset = containerWidth - savedOffset;
              defaultOffset = containerWidth - defaultOffset;
            }

            var left = splitter[0].offsetLeft;

            if (self.isSplitterRightSide && s.side === 'right') {
              left = splitter[0].offsetLeft + 1;
            }

            if (savedOffset >= x) {
              if (left >= containerWidth) {
                splitAndRotate(defaultOffset, this, true);
              } else {
                savedOffset = left;
                splitAndRotate(x, this, false);
              }
            } else if (left < containerWidth) {
              savedOffset = left;
              splitAndRotate(x, this, false);
            } else {
              splitAndRotate(savedOffset, this, true);
              savedOffset = x;
            }
          } else {
            var _left = splitter[0].offsetLeft;
            if (savedOffset <= 0) {
              if (_left <= 10) {
                splitAndRotate(defaultOffset, this, true);
              } else {
                savedOffset = _left;
                splitAndRotate(0, this, false);
              }
            } else if (_left > 10) {
              savedOffset = _left;
              splitAndRotate(0, this, false);
            } else {
              splitAndRotate(savedOffset, this, true);
              savedOffset = 0;
            }
          }

          isClickedOnce = true;
        });
      };
	  // END HANDLECOLLAPSEBUTTON SECTION (NOT USING)
	  
      if (this.isSplitterRightSide) {
        var thisPrev = thisSide.prev();

        if (thisPrev.is('.main')) {
          this.leftSide = thisPrev;
          w = thisSide.parent().outerWidth() - w;
		  //w = 330;
        } else {
          this.leftSide = thisSide;
          splitter.addClass('splitter-right');
        }
        thisSide.addClass('is-right-side').next().addClass('flex-grow-shrink is-right-side').parent().addClass('splitter-container');

        if (s.collapseButton) {
          handleCollapseButton();
        }
        this.setSplitterContainer(thisSide.parent());
      } else if (this.isSplitterHorizontal) {
			this.topPanel = splitter.prev();
			w = this.topPanel.height();
			parent.addClass('splitter-container is-horizontal');
			splitter.next().addClass('flex-grow-shrink');
			splitter.addClass('splitter-horizontal');
      } else {
			this.rightSide = thisSide;
			this.leftSide = thisSide.prev().parent();
			thisSide.prev().addClass('flex-grow-shrink').parent().addClass('splitter-container');

			if (s.collapseButton) {
			  handleCollapseButton();
        }
        this.setSplitterContainer(thisSide.parent());
      }

      if (this.isRTL && !this.isSplitterHorizontal) {
        var containerWidth = this.getContainerWidth();
        w = containerWidth >= w ? containerWidth - w : w;
      } // Restore from local storage

      if (localStorage && s.save && !isNaN(parseInt(localStorage[s.uniqueId], 10))) {
        w = localStorage[s.uniqueId];
      }

      w = parseInt(w, 10);
      if (this.isSplitterHorizontal) {
        splitter[0].style.top = "".concat(w, "px");
      } else {
        splitter[0].style.top = 50;
      }
      this.splitTo(w, parentHeight);

      if (w <= 10 && this.splitterCollapseButton) {
        this.splitterCollapseButton.removeClass('rotate');
      } // Add the Splitter Events


      this.documentWidth = 0;
      this.element.drag({
        axis: s.axis,
        containment: s.containment || s.axis === 'x' ? 'document' : 'parent',
        containmentOffset: {
          left: 0,
          top: 0
        }
      }).on('dragstart.splitter', function () {
        var iframes = thisSide.parent().find('iframe');
        self.documentWidth = $(document).width();

        if (iframes.length > 0) {
          for (var i = 0, l = iframes.length; i < l; i++) {
            var frame = $(iframes[i]); // eslint-disable-next-line

            var width = "".concat(parseInt(getComputedStyle(frame.parent()[0]).width, 10), "px");
            var overlay = $('<div class="overlay splitter-overlay"></div>');
            overlay.css('width', width);
            frame.before(overlay);
          }
        }
      }).on('dragend.splitter', function (e, args) {
        thisSide.parent().find('.splitter-overlay').remove();
        var splitRect = splitter[0].getBoundingClientRect();
        var splitOffset = window.innerWidth - splitRect.left;
        var isRightSide = _this.isSplitterRightSide && _this.settings.side === 'right' || !_this.isSplitterRightSide && _this.settings.side === 'left'; // Prevent splitter content area to remain open if splitter is dragged rapidly.
        // Make sure the width is reset when splitter is flush left.

        if (splitRect.left === 0) {
          //thisSide[0].style.width = '0px';
		  thisSide[0].style.width = '100%';
          args[direction] = 10;
        }

        if (s.collapseButton) {
          if (args[direction] <= 10 || isRightSide && splitOffset <= 21) {
            $('#splitter-collapse-btn').removeClass('rotate');
          } else {
            $('#splitter-collapse-btn').addClass('rotate');
          }
        }

        if (s.resize === 'end') {
          self.splitTo(args[direction], parentHeight);
        } // Run here on `dragend` and `drag` because it take some time to apply, which leaving some gap in between especially with case zero or less value.


        if (s.resize === 'immediate' && _this.isRTL && !_this.isSplitterHorizontal) {
          setTimeout(function () {
            var left = parseInt(_this.element.css('left'), 10);
			// line below causes splitter to revert to earlier position sometimes
            //self.splitTo(args[direction], parentHeight);
          }, 0);
        }
      }).on('drag.splitter', function (e, args) {
        if (args.left <= 0 && !_this.isRTL) {
          return false;
        }

        if (s.resize === 'immediate') {
			if (_this.isRTL) {
				var containerwidth = splitter.parents('.splitter-container').outerWidth();
				var left = containerwidth - parseInt($('.sidebar').css('width'),10);
          self.splitTo(args[direction], parentHeight);
			}
			else {
				self.splitTo(args[direction], parentHeight);
			}      
        }

        return true;
      }); // Horizontal Splitter

      if (s.axis === 'y') {
        this.element.addClass('splitter-horizontal');
      } // Aria


      this.element.attr({
        'aria-dropeffect': 'move',
        tabindex: '0',
        'aria-grabbed': 'false'
      });
      addAttributes(this.element, this, this.settings.attributes, '', true);
      addAttributes(this.element.find('.splitter-drag-handle'), this, this.settings.attributes, 'handle', true);
      addAttributes(this.element.find('.splitter-drag-handle svg.icon'), this, this.settings.attributes, 'icon', true);
      return this;
    },

    /**
     * Set the splitter container
     * @private
     * @param {jQueryElement} parentEl The main parent container element.
     * @returns {void}
     */
    setSplitterContainer: function setSplitterContainer(parentEl) {
      this.container = this.element.closest('.splitter-container');
      if (!this.container.length && parentEl && parentEl.length) {
        parentEl.addClass('splitter-container');
        this.container = this.element.closest('.splitter-container');
      }
    },

    /**
     * Get splitter container width
     * @private
     * @returns {number} Container width
     */
    getContainerWidth: function getContainerWidth() {
      var _this$container;

      return ((_this$container = this.container) === null || _this$container === void 0 ? void 0 : _this$container == null ? void 0 : _this$container.outerWidth()) || 0;
    },

    /**
     * Toggle selection
     * @private
     * @returns {void}
     */
    toggleSelection: function toggleSelection() {
      this.element.toggleClass('is-dragging');
    },

    /**
     * Resize the panel vertically
     * @private
     * @param {object} splitter element.
     * @param {number} top value.
     * @param {number} parentHeight value.
     * @returns {void}
     */
    resizeTop: function resizeTop(splitter, top, parentHeight) {
      if (top > parentHeight || top < 0) {
        top = parseInt(parentHeight, 10) / 2;
      }

      this.topPanel[0].style.height = "".concat(top, "px");
    },

    /**
     * Resize the panel to the Left
     * @private
     * @param {object} splitter element.
     * @param {number} leftArg value.
     * @returns {void}
     */
    resizeLeft: function resizeLeft(splitter, leftArg) {
      var left = this.isRTL ? leftArg + 20 : this.leftSide.outerWidth() - leftArg; // Adjust Left and Right Side
      this.rightSide[0].style.width = "".concat(left, "px"); // Reset the Width

      splitter[0].style.left = '';
    },

    /**
     * Resize the panel to the Right
     * @private
     * @param {object} splitter element.
     * @param {number} w - width value.
     * @returns {void}
     */
    resizeRight: function resizeRight(splitter, w) {
      var parent = splitter.parent();
      var thisSide = parent.is('.content') ? parent.parent() : parent;
      var width = w;
	  if (window.innerWidth < 490) {
		  width = window.innerWidth;		  
	  }
      var left = w - 1;
	 // var left = 1;

      if (this.isRTL && !this.isSplitterHorizontal) {
        var containerWidth = this.getContainerWidth();
		var sidebar = parseInt($('.sidebar').css('width'), 10);
		if (window.innerWidth > 490) {
			width = containerWidth >= w ? containerWidth - w -16: w;
			if (width < 0) {
				width = containerWidth >= w ? sidebar : w;
			}
		}
		else {
			width = window.innerWidth;
		}
		
		left = -16;
      }

      if (!this.isSplitterRightSide && this.settings.side === 'left' || this.isSplitterRightSide && this.settings.side === 'right') {
        thisSide[0].style.width = '0px';
		//thisSide[0].style.width = 'calc(100% - 330px)';
      } // Adjust Left and Right Side
		if (window.innerWidth < 569) {
			this.leftSide[0].style.width = "".concat(width, "px");
			$('#application-menu').css('width','100%');
		}
		else if (!(window.innerWidth < 569)) {
		  this.leftSide[0].style.width = "".concat(width, "px");
		  $('#application-menu').css('width',width + 'px');
	  }
	  splitter[0].style.left = "".concat(left, "px");
    },

    /**
     * Split to
     * @private
     * @param {number} split value.
     * @param {number} parentHeight value.
     * @returns {void}
     */
    splitTo: function splitTo(split, parentHeight) {
      var self = this;
      var s = this.settings;
      var splitter = this.element;

      if (this.isSplitterRightSide) {
        if (!this.isRTL && split > s.maxWidth.right || this.isRTL && split < s.maxWidth.right) {
          split = s.maxWidth.right;
        }
        this.resizeRight(splitter, split);
      } else if (this.isSplitterHorizontal) {
        this.resizeTop(splitter, split, parentHeight);
      } else {
        if (!this.isRTL && split > s.maxWidth.left || this.isRTL && split < s.maxWidth.left) {
          split = s.maxWidth.left;
        }
        this.resizeLeft(splitter, split);
      }
      /**
      * Fires when after the split occurs. Allowing you to sync any ui.
      * @event split
      * @memberof Splitter
      * @property {object} event The jquery event object
      * @property {number} split value
      */

      this.element.trigger('split', [split]);
      this.docBody.triggerHandler('resize', [self]); // Save to local storage
      if (localStorage) {
        localStorage[this.settings.uniqueId] = split;
      }

      this.split = split;
      this.parentHeight = parentHeight;
    },

    /**
     * Removes event bindings from the instance.
     * @private
     * @returns {object} The api
     */
    unbind: function unbind() {
      this.element.off("updated.".concat(COMPONENT_NAME$13));
      return this;
    },

    /**
     * Resync the UI and Settings.
     * @param {object} settings The settings to apply.
     * @returns {object} The api
     */
    updated: function updated(settings) {
      if (typeof settings !== 'undefined') {
        this.settings = mergeSettings(this.element, settings, SPLITTER_DEFAULTS);
        return this.destroy().init();
      }

      return this;
    },

    /**
    * Destroy and remove added markup, all events
    * @returns {void}
    */
    destroy: function destroy() {
      this.unbind();

      if (this.splitterCollapseButton) {
        this.splitterCollapseButton.remove();
      }

      $.removeData(this.element[0], COMPONENT_NAME$13);
    },

    /**
     * Attach Events used by the Control
     * @private
     * @returns {void}
     */
    handleEvents: function handleEvents() {
      var _this2 = this;

      this.element
      /**
      * Fires when the component updates.
      *
      * @event updated
      * @memberof Splitter
      * @type {object}
      * @property {object} event - The jquery event object
      */
      .on("updated.".concat(COMPONENT_NAME$13), function () {
        _this2.updated();
      })
      /**
      * Fires when a key is pressed while the component is focused.
      *
      * @event keydown
      * @memberof Splitter
      * @type {object}
      * @property {object} event - The jquery event object
      */
      .on("keydown.".concat(COMPONENT_NAME$13), function (e) {
        // Space will toggle selection
        if (e.which === 32) {
          _this2.toggleSelection();

          e.preventDefault();
        }

        if (e.which === 37) {
          _this2.splitTo(_this2.split - 15, _this2.parentHeight);
        }

        if (e.which === 39) {
          _this2.splitTo(_this2.split + 15, _this2.parentHeight);
        }
      });
      return this;
    }
  };

  /**
   * jQuery Component Wrapper for Splitter
   * @param {object} [settings] incoming settings
   * @returns {jQuery[]} elements being acted on
   */

  $.fn.splitter = function (settings) {
	  localStorage.removeItem('splitter-1');
    return this.each(function () {
      var instance = $.data(this, COMPONENT_NAME$13);
      if (instance) {
        instance.updated(settings);
      } else {
        instance = $.data(this, COMPONENT_NAME$13, new Splitter(this, settings));
      }
    });
  };
// stuff from recent utils.js
/**
 * Merges various sets of options into a single object,
 * whose intention is to be set as options on a Soho component.
 * @private
 * @param {HTMLElement|SVGElement|jQuery[]} [element] the element to process for inline-settings
 * @param {Object|function} incomingOptions desired settings
 * @param {Object|function} [defaultOptions] optional base settings
 * @returns {object} processed settings
 */
function mergeSettings(element, incomingOptions, defaultOptions) {
  if (!incomingOptions || !isValidOptions(incomingOptions)) {
    if (isValidOptions(defaultOptions)) {
      incomingOptions = defaultOptions;
    } else {
      incomingOptions = {};
    }
  }

  // Actually get ready to merge incoming options if we get to this point.
  return $.extend(
    true, {},
    resolveFunctionBasedSettings(defaultOptions || {}),
    resolveFunctionBasedSettings(incomingOptions),
    (element !== undefined ? parseSettings(element) : {})
  ); // possible to run this without an element present -- will simply skip this part
};

/**
 * Checks to see if a variable is valid for containing Soho component options.
 * @private
 * @param {object|function} o an object or function
 * @returns {boolean} whether or not the object type is valid
 */
function isValidOptions(o) {
  return (typeof o === 'object' || typeof o === 'function');
}

/**
 * In some cases, functions are passed to component constructors as the settings argument.
 * This method runs the settings function if it's present and returns the resulting object.
 * @private
 * @param {object|function} o represents settings
 * @returns {object} processed settings
 */
function resolveFunctionBasedSettings(o) {
  if (typeof o === 'function') {
    return o();
  }
  return o;
}

function parseSettings(element, attr) {
  let options = {};
  if (!element ||
    (!(element instanceof HTMLElement) && !(element instanceof $)) ||
    (element instanceof $ && !element.length)) {
    return options;
  }

  if (element instanceof $) {
    element = element[0];
  }

  // Use `data-options` as a default.
  attr = attr || 'data-options';

  const str = element.getAttribute(attr);
  if (!str || typeof str !== 'string' || str.indexOf('{') === -1) {
    return options;
  }

  // replace single to double quotes, since single-quotes may be necessary
  // due to entry in markup.
  function replaceDoubleQuotes(changedStr) {
    return changedStr.replace(/'/g, '"');
  }

  // Manually parse a string more in-depth
  function manualParse(changedStr) {
    // get keys
    let regex = /({|,)(?:\s*)(?:')?([A-Za-z_$\.][A-Za-z0-9_ \-\.$]*)(?:')?(?:\s*):/g; // eslint-disable-line

    // add double quotes to keys
    changedStr = changedStr.replace(regex, '$1\"$2\":'); // eslint-disable-line

    // get strings in values
    regex = /:(?:\s*)(?!(true|false|null|undefined))([A-Za-z_$\.#][A-Za-z0-9_ \-\.$]*)/g; // eslint-disable-line

    // add double quotes to strings in values
    changedStr = changedStr.replace(regex, ':\"$2\"'); // eslint-disable-line
    changedStr = replaceDoubleQuotes(changedStr);
    return changedStr;
  }

  try {
    options = JSON.parse(replaceDoubleQuotes(str));
  } catch (err) {
    options = JSON.parse(manualParse(str));
  }

  return options;
}

let uniqueIdCount = [];

function uniqueId(element, className, prefix, suffix) {
  const predefinedId = element.id;

  if (predefinedId && $(`#${predefinedId}`).length < 2) {
    return predefinedId;
  }

  prefix = (!prefix ? '' : `${prefix}-`);
  suffix = (!suffix ? '' : `-${suffix}`);
  className = (!className ? getArrayFromList(element.classList).join('-') : className);

  if (!uniqueIdCount[className]) {
    uniqueIdCount[className] = 1;
  }
  const str = `${prefix}${className}-${uniqueIdCount[className]}${suffix}`;
  uniqueIdCount[className] += 1;
  return str;
}

 function getArrayFromList(listObj) {
  const unboundSlice = Array.prototype.slice;
  return Function.prototype.call.bind(unboundSlice)(listObj);
}

/**
 * Generate additional attributes.
 * @private
 * @param {object} elem The DOM node to add to
 * @param {object} api The object base api
 * @param {object|Array} setting The attribute setting
 * @param {string} suffix Append an extra string at the end
 * @param {boolean} overrideExistingId Write over the current id value if there already
 */
function addAttributes(elem, api, setting, suffix, overrideExistingId) {
  if (!setting) {
    return;
  }

  // Add the given attribute to element, if not alreay exist
  const addAttr = (name, value) => {
    if (elem[0] && (overrideExistingId ? true : !elem[0].hasAttribute(name))) {
      elem.attr(name, value + (suffix ? `-${suffix.toLowerCase()}` : ''));
    }
  };

  if (Array.isArray(setting)) {
    setting.forEach((item) => {
      const value = typeof item.value === 'function' ? item.value(api) : item.value;
      addAttr(item.name, value);
    });
    return;
  }

  const value = typeof setting.value === 'function' ? setting.value(api) : setting.value;
  addAttr(setting.name, value);
}

 });  
//# sourceURL=sohoxi.js